/*
 * Copyright (C) 2015-2017 Socionext Inc.
 *   Author: Masahiro Yamada <yamada.masahiro@socionext.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program5 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pinctrl/pinctrl.h>
#include <linux/platform_device.h>

#include "pinctrl-uniphier.h"

static const struct pinctrl_pin_desc uniphier_pro5_pins[] = {
	UNIPHIER_PINCTRL_PIN(0, "AEXCKA1", 0,
			     0, UNIPHIER_PIN_DRV_1BIT,
			     0, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(1, "AEXCKA2", 0,
			     1, UNIPHIER_PIN_DRV_1BIT,
			     1, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(2, "CK27EXI", 0,
			     2, UNIPHIER_PIN_DRV_1BIT,
			     2, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(3, "CK54EXI", 0,
			     3, UNIPHIER_PIN_DRV_1BIT,
			     3, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(4, "ED0", UNIPHIER_PIN_IECTRL_NONE,
			     4, UNIPHIER_PIN_DRV_1BIT,
			     4, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(5, "ED1", UNIPHIER_PIN_IECTRL_NONE,
			     5, UNIPHIER_PIN_DRV_1BIT,
			     5, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(6, "ED2", UNIPHIER_PIN_IECTRL_NONE,
			     6, UNIPHIER_PIN_DRV_1BIT,
			     6, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(7, "ED3", UNIPHIER_PIN_IECTRL_NONE,
			     7, UNIPHIER_PIN_DRV_1BIT,
			     7, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(8, "ED4", UNIPHIER_PIN_IECTRL_NONE,
			     8, UNIPHIER_PIN_DRV_1BIT,
			     8, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(9, "ED5", UNIPHIER_PIN_IECTRL_NONE,
			     9, UNIPHIER_PIN_DRV_1BIT,
			     9, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(10, "ED6", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_1BIT,
			     10, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(11, "ED7", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_1BIT,
			     11, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(12, "XERWE0", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_1BIT,
			     12, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(13, "XERWE1", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_1BIT,
			     13, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(14, "ERXW", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_1BIT,
			     14, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(15, "ES0", UNIPHIER_PIN_IECTRL_NONE,
			     15, UNIPHIER_PIN_DRV_1BIT,
			     15, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(16, "ES1", UNIPHIER_PIN_IECTRL_NONE,
			     16, UNIPHIER_PIN_DRV_1BIT,
			     16, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(17, "ES2", UNIPHIER_PIN_IECTRL_NONE,
			     17, UNIPHIER_PIN_DRV_1BIT,
			     17, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(18, "XECS1", UNIPHIER_PIN_IECTRL_NONE,
			     18, UNIPHIER_PIN_DRV_1BIT,
			     18, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(19, "XNFRE", UNIPHIER_PIN_IECTRL_NONE,
			     19, UNIPHIER_PIN_DRV_1BIT,
			     19, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(20, "XNFWE", UNIPHIER_PIN_IECTRL_NONE,
			     20, UNIPHIER_PIN_DRV_1BIT,
			     20, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(21, "NFALE", UNIPHIER_PIN_IECTRL_NONE,
			     21, UNIPHIER_PIN_DRV_1BIT,
			     21, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(22, "NFCLE", UNIPHIER_PIN_IECTRL_NONE,
			     22, UNIPHIER_PIN_DRV_1BIT,
			     22, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(23, "XNFWP", UNIPHIER_PIN_IECTRL_NONE,
			     23, UNIPHIER_PIN_DRV_1BIT,
			     23, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(24, "XNFCE0", UNIPHIER_PIN_IECTRL_NONE,
			     24, UNIPHIER_PIN_DRV_1BIT,
			     24, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(25, "NFRYBY0", UNIPHIER_PIN_IECTRL_NONE,
			     25, UNIPHIER_PIN_DRV_1BIT,
			     25, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(26, "XNFCE1", UNIPHIER_PIN_IECTRL_NONE,
			     26, UNIPHIER_PIN_DRV_1BIT,
			     26, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(27, "NFRYBY1", UNIPHIER_PIN_IECTRL_NONE,
			     27, UNIPHIER_PIN_DRV_1BIT,
			     27, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(28, "NFD0", UNIPHIER_PIN_IECTRL_NONE,
			     28, UNIPHIER_PIN_DRV_1BIT,
			     28, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(29, "NFD1", UNIPHIER_PIN_IECTRL_NONE,
			     29, UNIPHIER_PIN_DRV_1BIT,
			     29, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(30, "NFD2", UNIPHIER_PIN_IECTRL_NONE,
			     30, UNIPHIER_PIN_DRV_1BIT,
			     30, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(31, "NFD3", UNIPHIER_PIN_IECTRL_NONE,
			     31, UNIPHIER_PIN_DRV_1BIT,
			     31, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(32, "NFD4", UNIPHIER_PIN_IECTRL_NONE,
			     32, UNIPHIER_PIN_DRV_1BIT,
			     32, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(33, "NFD5", UNIPHIER_PIN_IECTRL_NONE,
			     33, UNIPHIER_PIN_DRV_1BIT,
			     33, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(34, "NFD6", UNIPHIER_PIN_IECTRL_NONE,
			     34, UNIPHIER_PIN_DRV_1BIT,
			     34, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(35, "NFD7", UNIPHIER_PIN_IECTRL_NONE,
			     35, UNIPHIER_PIN_DRV_1BIT,
			     35, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(36, "XERST", UNIPHIER_PIN_IECTRL_NONE,
			     36, UNIPHIER_PIN_DRV_1BIT,
			     36, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(37, "MMCCLK", UNIPHIER_PIN_IECTRL_NONE,
			     37, UNIPHIER_PIN_DRV_1BIT,
			     37, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(38, "MMCCMD", UNIPHIER_PIN_IECTRL_NONE,
			     38, UNIPHIER_PIN_DRV_1BIT,
			     38, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(39, "MMCDAT0", UNIPHIER_PIN_IECTRL_NONE,
			     39, UNIPHIER_PIN_DRV_1BIT,
			     39, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(40, "MMCDAT1", UNIPHIER_PIN_IECTRL_NONE,
			     40, UNIPHIER_PIN_DRV_1BIT,
			     40, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(41, "MMCDAT2", UNIPHIER_PIN_IECTRL_NONE,
			     41, UNIPHIER_PIN_DRV_1BIT,
			     41, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(42, "MMCDAT3", UNIPHIER_PIN_IECTRL_NONE,
			     42, UNIPHIER_PIN_DRV_1BIT,
			     42, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(43, "MMCDAT4", UNIPHIER_PIN_IECTRL_NONE,
			     43, UNIPHIER_PIN_DRV_1BIT,
			     43, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(44, "MMCDAT5", UNIPHIER_PIN_IECTRL_NONE,
			     44, UNIPHIER_PIN_DRV_1BIT,
			     44, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(45, "MMCDAT6", UNIPHIER_PIN_IECTRL_NONE,
			     45, UNIPHIER_PIN_DRV_1BIT,
			     45, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(46, "MMCDAT7", UNIPHIER_PIN_IECTRL_NONE,
			     46, UNIPHIER_PIN_DRV_1BIT,
			     46, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(47, "TXD0", 0,
			     47, UNIPHIER_PIN_DRV_1BIT,
			     47, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(48, "RXD0", 0,
			     48, UNIPHIER_PIN_DRV_1BIT,
			     48, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(49, "TXD1", 0,
			     49, UNIPHIER_PIN_DRV_1BIT,
			     49, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(50, "RXD1", 0,
			     50, UNIPHIER_PIN_DRV_1BIT,
			     50, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(51, "TXD2", UNIPHIER_PIN_IECTRL_NONE,
			     51, UNIPHIER_PIN_DRV_1BIT,
			     51, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(52, "RXD2", UNIPHIER_PIN_IECTRL_NONE,
			     52, UNIPHIER_PIN_DRV_1BIT,
			     52, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(53, "TXD3", 0,
			     53, UNIPHIER_PIN_DRV_1BIT,
			     53, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(54, "RXD3", 0,
			     54, UNIPHIER_PIN_DRV_1BIT,
			     54, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(55, "MS0CS0", 0,
			     55, UNIPHIER_PIN_DRV_1BIT,
			     55, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(56, "MS0DO", 0,
			     56, UNIPHIER_PIN_DRV_1BIT,
			     56, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(57, "MS0DI", 0,
			     57, UNIPHIER_PIN_DRV_1BIT,
			     57, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(58, "MS0CLK", 0,
			     58, UNIPHIER_PIN_DRV_1BIT,
			     58, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(59, "CSCLK", 0,
			     59, UNIPHIER_PIN_DRV_1BIT,
			     59, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(60, "CSBPTM", 0,
			     60, UNIPHIER_PIN_DRV_1BIT,
			     60, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(61, "CSBMTP", 0,
			     61, UNIPHIER_PIN_DRV_1BIT,
			     61, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(62, "XCINTP", 0,
			     62, UNIPHIER_PIN_DRV_1BIT,
			     62, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(63, "XCINTM", 0,
			     63, UNIPHIER_PIN_DRV_1BIT,
			     63, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(64, "XCMPREQ", 0,
			     64, UNIPHIER_PIN_DRV_1BIT,
			     64, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(65, "XSRST", 0,
			     65, UNIPHIER_PIN_DRV_1BIT,
			     65, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(66, "LPST", UNIPHIER_PIN_IECTRL_NONE,
			     66, UNIPHIER_PIN_DRV_1BIT,
			     66, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(67, "PWMA", 0,
			     67, UNIPHIER_PIN_DRV_1BIT,
			     67, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(68, "XIRQ0", 0,
			     68, UNIPHIER_PIN_DRV_1BIT,
			     68, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(69, "XIRQ1", 0,
			     69, UNIPHIER_PIN_DRV_1BIT,
			     69, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(70, "XIRQ2", 0,
			     70, UNIPHIER_PIN_DRV_1BIT,
			     70, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(71, "XIRQ3", 0,
			     71, UNIPHIER_PIN_DRV_1BIT,
			     71, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(72, "XIRQ4", 0,
			     72, UNIPHIER_PIN_DRV_1BIT,
			     72, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(73, "XIRQ5", 0,
			     73, UNIPHIER_PIN_DRV_1BIT,
			     73, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(74, "XIRQ6", 0,
			     74, UNIPHIER_PIN_DRV_1BIT,
			     74, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(75, "XIRQ7", 0,
			     75, UNIPHIER_PIN_DRV_1BIT,
			     75, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(76, "XIRQ8", 0,
			     76, UNIPHIER_PIN_DRV_1BIT,
			     76, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(77, "XIRQ9", 0,
			     77, UNIPHIER_PIN_DRV_1BIT,
			     77, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(78, "XIRQ10", 0,
			     78, UNIPHIER_PIN_DRV_1BIT,
			     78, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(79, "XIRQ11", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     79, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(80, "XIRQ12", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     80, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(81, "XIRQ13", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     81, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(82, "XIRQ14", 0,
			     82, UNIPHIER_PIN_DRV_1BIT,
			     82, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(83, "XIRQ15", 0,
			     83, UNIPHIER_PIN_DRV_1BIT,
			     83, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(84, "XIRQ16", 0,
			     84, UNIPHIER_PIN_DRV_1BIT,
			     84, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(85, "XIRQ17", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     85, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(86, "XIRQ18", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     86, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(87, "XIRQ19", 0,
			     87, UNIPHIER_PIN_DRV_1BIT,
			     87, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(88, "XIRQ20", 0,
			     88, UNIPHIER_PIN_DRV_1BIT,
			     88, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(89, "PORT00", 0,
			     89, UNIPHIER_PIN_DRV_1BIT,
			     89, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(90, "PORT01", 0,
			     90, UNIPHIER_PIN_DRV_1BIT,
			     90, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(91, "PORT02", 0,
			     91, UNIPHIER_PIN_DRV_1BIT,
			     91, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(92, "PORT03", 0,
			     92, UNIPHIER_PIN_DRV_1BIT,
			     92, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(93, "PORT04", 0,
			     93, UNIPHIER_PIN_DRV_1BIT,
			     93, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(94, "PORT05", 0,
			     94, UNIPHIER_PIN_DRV_1BIT,
			     94, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(95, "PORT06", 0,
			     95, UNIPHIER_PIN_DRV_1BIT,
			     95, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(96, "PORT07", 0,
			     96, UNIPHIER_PIN_DRV_1BIT,
			     96, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(97, "PORT10", 0,
			     97, UNIPHIER_PIN_DRV_1BIT,
			     97, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(98, "PORT11", 0,
			     98, UNIPHIER_PIN_DRV_1BIT,
			     98, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(99, "PORT12", 0,
			     99, UNIPHIER_PIN_DRV_1BIT,
			     99, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(100, "PORT13", 0,
			     100, UNIPHIER_PIN_DRV_1BIT,
			     100, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(101, "PORT14", 0,
			     101, UNIPHIER_PIN_DRV_1BIT,
			     101, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(102, "PORT15", 0,
			     102, UNIPHIER_PIN_DRV_1BIT,
			     102, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(103, "PORT16", 0,
			     103, UNIPHIER_PIN_DRV_1BIT,
			     103, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(104, "PORT17", 0,
			     104, UNIPHIER_PIN_DRV_1BIT,
			     104, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(105, "T0HPD", 0,
			     105, UNIPHIER_PIN_DRV_1BIT,
			     105, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(106, "T1HPD", 0,
			     106, UNIPHIER_PIN_DRV_1BIT,
			     106, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(107, "R0HPD", 0,
			     107, UNIPHIER_PIN_DRV_1BIT,
			     107, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(108, "R1HPD", 0,
			     108, UNIPHIER_PIN_DRV_1BIT,
			     108, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(109, "XPERST", 0,
			     109, UNIPHIER_PIN_DRV_1BIT,
			     109, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(110, "XPEWAKE", 0,
			     110, UNIPHIER_PIN_DRV_1BIT,
			     110, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(111, "XPECLKRQ", 0,
			     111, UNIPHIER_PIN_DRV_1BIT,
			     111, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(112, "SDA0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     112, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(113, "SCL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     113, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(114, "SDA1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     114, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(115, "SCL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     115, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(116, "SDA2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     116, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(117, "SCL2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     117, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(118, "SDA3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     118, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(119, "SCL3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED4,
			     119, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(120, "SPISYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     120, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(121, "SPISCLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     121, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(122, "SPITXD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     122, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(123, "SPIRXD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     123, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(124, "USB0VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     124, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(125, "USB0OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     125, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(126, "USB1VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     126, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(127, "USB1OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     127, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(128, "USB2VBUS", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     128, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(129, "USB2OD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     129, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(130, "SMTRST0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     130, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(131, "SMTCMD0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     131, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(132, "SMTD0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     132, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(133, "SMTSEL0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     133, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(134, "SMTCLK0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     134, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(135, "SMTRST1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     135, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(136, "SMTCMD1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     136, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(137, "SMTD1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     137, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(138, "SMTSEL1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     138, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(139, "SMTCLK1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     139, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(140, "CH0CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     140, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(141, "CH0PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     141, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(142, "CH0VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     142, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(143, "CH0DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     143, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(144, "CH1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     144, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(145, "CH1PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     145, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(146, "CH1VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     146, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(147, "CH1DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     147, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(148, "CH2CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     148, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(149, "CH2PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     149, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(150, "CH2VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     150, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(151, "CH2DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     151, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(152, "CH3CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     152, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(153, "CH3PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     153, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(154, "CH3VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     154, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(155, "CH3DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     155, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(156, "CH4CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     156, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(157, "CH4PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     157, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(158, "CH4VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     158, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(159, "CH4DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     159, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(160, "CH5CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     160, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(161, "CH5PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     161, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(162, "CH5VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     162, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(163, "CH5DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     163, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(164, "CH6CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     164, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(165, "CH6PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     165, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(166, "CH6VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     166, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(167, "CH6DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     167, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(168, "CH7CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     168, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(169, "CH7PSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     169, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(170, "CH7VAL", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     170, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(171, "CH7DATA", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     171, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(172, "AI1ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     172, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(173, "AI1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     173, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(174, "AI1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     174, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(175, "AI1D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     175, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(176, "AI1D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     176, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(177, "AI1D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     177, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(178, "AI1D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     178, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(179, "AI2ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     179, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(180, "AI2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     180, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(181, "AI2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     181, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(182, "AI2D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     182, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(183, "AI2D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     183, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(184, "AI2D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     184, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(185, "AI2D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     185, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(186, "AI3ADCCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     186, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(187, "AI3BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     187, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(188, "AI3LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     188, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(189, "AI3D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     189, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(190, "AO1IEC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     190, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(191, "AO1DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     191, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(192, "AO1BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     192, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(193, "AO1LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     193, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(194, "AO1D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     194, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(195, "AO1D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     195, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(196, "AO1D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     196, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(197, "AO1D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     197, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(198, "AO2IEC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     198, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(199, "AO2DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     199, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(200, "AO2BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     200, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(201, "AO2LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     201, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(202, "AO2D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     202, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(203, "AO2D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     203, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(204, "AO2D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     204, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(205, "AO2D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     205, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(206, "AO3DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     206, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(207, "AO3BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     207, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(208, "AO3LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     208, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(209, "AO3DMIX", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     209, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(210, "AO4DACCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     210, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(211, "AO4BCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     211, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(212, "AO4LRCK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     212, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(213, "AO4DMIX", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     213, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(214, "VI1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     214, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(215, "VI1C0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     215, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(216, "VI1C1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     216, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(217, "VI1C2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     217, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(218, "VI1C3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     218, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(219, "VI1C4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     219, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(220, "VI1C5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     220, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(221, "VI1C6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     221, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(222, "VI1C7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     222, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(223, "VI1C8", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     223, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(224, "VI1C9", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     224, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(225, "VI1Y0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     225, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(226, "VI1Y1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     226, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(227, "VI1Y2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     227, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(228, "VI1Y3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     228, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(229, "VI1Y4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     229, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(230, "VI1Y5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     230, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(231, "VI1Y6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     231, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(232, "VI1Y7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     232, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(233, "VI1Y8", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     233, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(234, "VI1Y9", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     234, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(235, "VI1DE", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     235, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(236, "VI1HSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     236, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(237, "VI1VSYNC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     237, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(238, "VO1CLK", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     238, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(239, "VO1D0", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     239, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(240, "VO1D1", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     240, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(241, "VO1D2", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     241, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(242, "VO1D3", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     242, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(243, "VO1D4", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     243, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(244, "VO1D5", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     244, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(245, "VO1D6", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     245, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(246, "VO1D7", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     246, UNIPHIER_PIN_PULL_DOWN),
	UNIPHIER_PINCTRL_PIN(247, "SDCD", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     247, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(248, "SDWP", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     248, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(249, "SDVOLC", UNIPHIER_PIN_IECTRL_NONE,
			     -1, UNIPHIER_PIN_DRV_FIXED8,
			     249, UNIPHIER_PIN_PULL_UP),
	UNIPHIER_PINCTRL_PIN(250, "SDCLK", UNIPHIER_PIN_IECTRL_NONE,
			     10, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(251, "SDCMD", UNIPHIER_PIN_IECTRL_NONE,
			     11, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(252, "SDDAT0", UNIPHIER_PIN_IECTRL_NONE,
			     12, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(253, "SDDAT1", UNIPHIER_PIN_IECTRL_NONE,
			     13, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(254, "SDDAT2", UNIPHIER_PIN_IECTRL_NONE,
			     14, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
	UNIPHIER_PINCTRL_PIN(255, "SDDAT3", UNIPHIER_PIN_IECTRL_NONE,
			     15, UNIPHIER_PIN_DRV_2BIT,
			     -1, UNIPHIER_PIN_PULL_UP_FIXED),
};

static const unsigned emmc_pins[] = {36, 37, 38, 39, 40, 41, 42};
static const int emmc_muxvals[] = {0, 0, 0, 0, 0, 0, 0};
static const unsigned emmc_dat8_pins[] = {43, 44, 45, 46};
static const int emmc_dat8_muxvals[] = {0, 0, 0, 0};
static const unsigned i2c0_pins[] = {112, 113};
static const int i2c0_muxvals[] = {0, 0};
static const unsigned i2c1_pins[] = {114, 115};
static const int i2c1_muxvals[] = {0, 0};
static const unsigned i2c2_pins[] = {116, 117};
static const int i2c2_muxvals[] = {0, 0};
static const unsigned i2c3_pins[] = {118, 119};
static const int i2c3_muxvals[] = {0, 0};
static const unsigned i2c5_pins[] = {87, 88};
static const int i2c5_muxvals[] = {2, 2};
static const unsigned i2c5b_pins[] = {196, 197};
static const int i2c5b_muxvals[] = {2, 2};
static const unsigned i2c5c_pins[] = {215, 216};
static const int i2c5c_muxvals[] = {2, 2};
static const unsigned i2c6_pins[] = {101, 102};
static const int i2c6_muxvals[] = {2, 2};
static const unsigned nand_pins[] = {19, 20, 21, 22, 23, 24, 25, 28, 29, 30,
				     31, 32, 33, 34, 35};
static const int nand_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned nand_cs1_pins[] = {26, 27};
static const int nand_cs1_muxvals[] = {0, 0};
static const unsigned sd_pins[] = {250, 251, 252, 253, 254, 255, 256, 257, 258};
static const int sd_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
static const unsigned system_bus_pins[] = {4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
					   14, 15, 16, 17};
static const int system_bus_muxvals[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					 0};
static const unsigned system_bus_cs0_pins[] = {105};
static const int system_bus_cs0_muxvals[] = {1};
static const unsigned system_bus_cs1_pins[] = {18};
static const int system_bus_cs1_muxvals[] = {0};
static const unsigned system_bus_cs2_pins[] = {106};
static const int system_bus_cs2_muxvals[] = {1};
static const unsigned system_bus_cs3_pins[] = {100};
static const int system_bus_cs3_muxvals[] = {1};
static const unsigned system_bus_cs4_pins[] = {101};
static const int system_bus_cs4_muxvals[] = {1};
static const unsigned system_bus_cs5_pins[] = {102};
static const int system_bus_cs5_muxvals[] = {1};
static const unsigned system_bus_cs6_pins[] = {69};
static const int system_bus_cs6_muxvals[] = {5};
static const unsigned system_bus_cs7_pins[] = {70};
static const int system_bus_cs7_muxvals[] = {5};
static const unsigned uart0_pins[] = {47, 48};
static const int uart0_muxvals[] = {0, 0};
static const unsigned uart0b_pins[] = {227, 228};
static const int uart0b_muxvals[] = {3, 3};
static const unsigned uart1_pins[] = {49, 50};
static const int uart1_muxvals[] = {0, 0};
static const unsigned uart2_pins[] = {51, 52};
static const int uart2_muxvals[] = {0, 0};
static const unsigned uart3_pins[] = {53, 54};
static const int uart3_muxvals[] = {0, 0};
static const unsigned usb0_pins[] = {124, 125};
static const int usb0_muxvals[] = {0, 0};
static const unsigned usb1_pins[] = {126, 127};
static const int usb1_muxvals[] = {0, 0};
static const unsigned usb2_pins[] = {128, 129};
static const int usb2_muxvals[] = {0, 0};
static const unsigned port_range0_pins[] = {
	89, 90, 91, 92, 93, 94, 95, 96,			/* PORT0x */
	97, 98, 99, 100, 101, 102, 103, 104,		/* PORT1x */
	251, 252, 253, 254, 255, 247, 248, 249,		/* PORT2x */
	39, 40, 41, 42, 43, 44, 45, 46,			/* PORT3x */
	156, 157, 158, 159, 160, 161, 162, 163,		/* PORT4x */
	164, 165, 166, 167, 168, 169, 170, 171,		/* PORT5x */
	190, 191, 192, 193, 194, 195, 196, 197,		/* PORT6x */
	198, 199, 200, 201, 202, 203, 204, 205,		/* PORT7x */
	120, 121, 122, 123, 55, 56, 57, 58,		/* PORT8x */
	124, 125, 126, 127, 49, 50, 53, 54,		/* PORT9x */
	148, 149, 150, 151, 152, 153, 154, 155,		/* PORT10x */
	133, 134, 131, 130, 138, 139, 136, 135,		/* PORT11x */
	28, 29, 30, 31, 32, 33, 34, 35,			/* PORT12x */
	179, 180, 181, 182, 186, 187, 188, 189,		/* PORT13x */
	4, 5, 6, 7, 8, 9, 10, 11,			/* PORT14x */
};
static const int port_range0_muxvals[] = {
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT0x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT1x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT2x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT3x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT4x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT5x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT6x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT7x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT8x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT9x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT10x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT11x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT12x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT13x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT14x */
};
static const unsigned port_range1_pins[] = {
	109, 110, 111,					/* PORT175-177 */
	206, 207, 208, 209, 210, 211, 212, 213,		/* PORT18x */
	12, 13, 14, 15, 16, 17, 107, 108,		/* PORT19x */
	140, 141, 142, 143, 144, 145, 146, 147,		/* PORT20x */
	59, 60, 61, 62, 63, 64, 65, 66,			/* PORT21x */
	214, 215, 216, 217, 218, 219, 220, 221,		/* PORT22x */
	222, 223, 224, 225, 226, 227, 228, 229,		/* PORT23x */
	19, 20, 21, 22, 23, 24, 25, 26,			/* PORT24x */
	230, 231, 232, 233, 234, 235, 236, 237,		/* PORT25x */
	239, 240, 241, 242, 243, 244, 245, 246,		/* PORT26x */
	172, 173, 174, 175, 176, 177, 178, 129,		/* PORT27x */
	0, 1, 2, 67, 85, 86, 87, 88,			/* PORT28x */
	105, 106, 18, 27, 36, 128, 132, 137,		/* PORT29x */
	183, 184, 185, 84, 47, 48, 51, 52,		/* PORT30x */
};
static const int port_range1_muxvals[] = {
	15, 15, 15,					/* PORT175-177 */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT18x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT19x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT20x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT21x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT22x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT23x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT24x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT25x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT26x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT27x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT28x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT29x */
	15, 15, 15, 15, 15, 15, 15, 15,			/* PORT30x */
};
static const unsigned xirq_pins[] = {
	68, 69, 70, 71, 72, 73, 74, 75,			/* XIRQ0-7 */
	76, 77, 78, 79, 80, 81, 82, 83,			/* XIRQ8-15 */
	84, 85, 86, 87, 88,				/* XIRQ16-20 */
};
static const int xirq_muxvals[] = {
	14, 14, 14, 14, 14, 14, 14, 14,			/* XIRQ0-7 */
	14, 14, 14, 14, 14, 14, 14, 14,			/* XIRQ8-15 */
	14, 14, 14, 14, 14,				/* XIRQ16-20 */
};
static const unsigned xirq_alternatives_pins[] = {
	91, 92, 239, 144, 240, 156, 241, 106, 128,
};
static const int xirq_alternatives_muxvals[] = {
	14, 14, 14, 14, 14, 14, 14, 14, 14,
};

static const struct uniphier_pinctrl_group uniphier_pro5_groups[] = {
	UNIPHIER_PINCTRL_GROUP(nand),
	UNIPHIER_PINCTRL_GROUP(nand_cs1),
	UNIPHIER_PINCTRL_GROUP(emmc),
	UNIPHIER_PINCTRL_GROUP(emmc_dat8),
	UNIPHIER_PINCTRL_GROUP(i2c0),
	UNIPHIER_PINCTRL_GROUP(i2c1),
	UNIPHIER_PINCTRL_GROUP(i2c2),
	UNIPHIER_PINCTRL_GROUP(i2c3),
	UNIPHIER_PINCTRL_GROUP(i2c5),
	UNIPHIER_PINCTRL_GROUP(i2c5b),
	UNIPHIER_PINCTRL_GROUP(i2c5c),
	UNIPHIER_PINCTRL_GROUP(i2c6),
	UNIPHIER_PINCTRL_GROUP(sd),
	UNIPHIER_PINCTRL_GROUP(system_bus),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs0),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs1),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs2),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs3),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs4),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs5),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs6),
	UNIPHIER_PINCTRL_GROUP(system_bus_cs7),
	UNIPHIER_PINCTRL_GROUP(uart0),
	UNIPHIER_PINCTRL_GROUP(uart0b),
	UNIPHIER_PINCTRL_GROUP(uart1),
	UNIPHIER_PINCTRL_GROUP(uart2),
	UNIPHIER_PINCTRL_GROUP(uart3),
	UNIPHIER_PINCTRL_GROUP(usb0),
	UNIPHIER_PINCTRL_GROUP(usb1),
	UNIPHIER_PINCTRL_GROUP(usb2),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range0),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_PORT(port_range1),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_IRQ(xirq),
	UNIPHIER_PINCTRL_GROUP_GPIO_RANGE_IRQ(xirq_alternatives),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port00, port_range0, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port01, port_range0, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port02, port_range0, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port03, port_range0, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port04, port_range0, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port05, port_range0, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port06, port_range0, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port07, port_range0, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port10, port_range0, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port11, port_range0, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port12, port_range0, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port13, port_range0, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port14, port_range0, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port15, port_range0, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port16, port_range0, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port17, port_range0, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port20, port_range0, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port21, port_range0, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port22, port_range0, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port23, port_range0, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port24, port_range0, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port25, port_range0, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port26, port_range0, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port27, port_range0, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port30, port_range0, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port31, port_range0, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port32, port_range0, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port33, port_range0, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port34, port_range0, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port35, port_range0, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port36, port_range0, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port37, port_range0, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port40, port_range0, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port41, port_range0, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port42, port_range0, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port43, port_range0, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port44, port_range0, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port45, port_range0, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port46, port_range0, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port47, port_range0, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port50, port_range0, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port51, port_range0, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port52, port_range0, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port53, port_range0, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port54, port_range0, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port55, port_range0, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port56, port_range0, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port57, port_range0, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port60, port_range0, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port61, port_range0, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port62, port_range0, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port63, port_range0, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port64, port_range0, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port65, port_range0, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port66, port_range0, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port67, port_range0, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port70, port_range0, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port71, port_range0, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port72, port_range0, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port73, port_range0, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port74, port_range0, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port75, port_range0, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port76, port_range0, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port77, port_range0, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port80, port_range0, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port81, port_range0, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port82, port_range0, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port83, port_range0, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port84, port_range0, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port85, port_range0, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port86, port_range0, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port87, port_range0, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port90, port_range0, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port91, port_range0, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port92, port_range0, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port93, port_range0, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port94, port_range0, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port95, port_range0, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port96, port_range0, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port97, port_range0, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port100, port_range0, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port101, port_range0, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port102, port_range0, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port103, port_range0, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port104, port_range0, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port105, port_range0, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port106, port_range0, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port107, port_range0, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port110, port_range0, 88),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port111, port_range0, 89),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port112, port_range0, 90),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port113, port_range0, 91),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port114, port_range0, 92),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port115, port_range0, 93),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port116, port_range0, 94),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port117, port_range0, 95),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port120, port_range0, 96),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port121, port_range0, 97),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port122, port_range0, 98),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port123, port_range0, 99),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port124, port_range0, 100),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port125, port_range0, 101),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port126, port_range0, 102),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port127, port_range0, 103),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port130, port_range0, 104),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port131, port_range0, 105),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port132, port_range0, 106),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port133, port_range0, 107),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port134, port_range0, 108),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port135, port_range0, 109),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port136, port_range0, 110),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port137, port_range0, 111),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port140, port_range0, 112),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port141, port_range0, 113),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port142, port_range0, 114),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port143, port_range0, 115),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port144, port_range0, 116),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port145, port_range0, 117),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port146, port_range0, 118),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port147, port_range0, 119),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port175, port_range1, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port176, port_range1, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port177, port_range1, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port180, port_range1, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port181, port_range1, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port182, port_range1, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port183, port_range1, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port184, port_range1, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port185, port_range1, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port186, port_range1, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port187, port_range1, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port190, port_range1, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port191, port_range1, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port192, port_range1, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port193, port_range1, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port194, port_range1, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port195, port_range1, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port196, port_range1, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port197, port_range1, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port200, port_range1, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port201, port_range1, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port202, port_range1, 21),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port203, port_range1, 22),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port204, port_range1, 23),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port205, port_range1, 24),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port206, port_range1, 25),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port207, port_range1, 26),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port210, port_range1, 27),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port211, port_range1, 28),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port212, port_range1, 29),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port213, port_range1, 30),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port214, port_range1, 31),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port215, port_range1, 32),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port216, port_range1, 33),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port217, port_range1, 34),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port220, port_range1, 35),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port221, port_range1, 36),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port222, port_range1, 37),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port223, port_range1, 38),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port224, port_range1, 39),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port225, port_range1, 40),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port226, port_range1, 41),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port227, port_range1, 42),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port230, port_range1, 43),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port231, port_range1, 44),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port232, port_range1, 45),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port233, port_range1, 46),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port234, port_range1, 47),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port235, port_range1, 48),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port236, port_range1, 49),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port237, port_range1, 50),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port240, port_range1, 51),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port241, port_range1, 52),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port242, port_range1, 53),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port243, port_range1, 54),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port244, port_range1, 55),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port245, port_range1, 56),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port246, port_range1, 57),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port247, port_range1, 58),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port250, port_range1, 59),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port251, port_range1, 60),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port252, port_range1, 61),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port253, port_range1, 62),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port254, port_range1, 63),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port255, port_range1, 64),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port256, port_range1, 65),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port257, port_range1, 66),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port260, port_range1, 67),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port261, port_range1, 68),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port262, port_range1, 69),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port263, port_range1, 70),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port264, port_range1, 71),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port265, port_range1, 72),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port266, port_range1, 73),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port267, port_range1, 74),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port270, port_range1, 75),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port271, port_range1, 76),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port272, port_range1, 77),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port273, port_range1, 78),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port274, port_range1, 79),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port275, port_range1, 80),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port276, port_range1, 81),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port277, port_range1, 82),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port280, port_range1, 83),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port281, port_range1, 84),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port282, port_range1, 85),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port283, port_range1, 86),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port284, port_range1, 87),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port285, port_range1, 88),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port286, port_range1, 89),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port287, port_range1, 90),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port290, port_range1, 91),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port291, port_range1, 92),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port292, port_range1, 93),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port293, port_range1, 94),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port294, port_range1, 95),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port295, port_range1, 96),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port296, port_range1, 97),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port297, port_range1, 98),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port300, port_range1, 99),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port301, port_range1, 100),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port302, port_range1, 101),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port303, port_range1, 102),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port304, port_range1, 103),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port305, port_range1, 104),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port306, port_range1, 105),
	UNIPHIER_PINCTRL_GROUP_SINGLE(port307, port_range1, 106),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq0, xirq, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq1, xirq, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq2, xirq, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq3, xirq, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq4, xirq, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq5, xirq, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq6, xirq, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq7, xirq, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq8, xirq, 8),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq9, xirq, 9),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq10, xirq, 10),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq11, xirq, 11),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq12, xirq, 12),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq13, xirq, 13),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq14, xirq, 14),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq15, xirq, 15),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq16, xirq, 16),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17, xirq, 17),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18, xirq, 18),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq19, xirq, 19),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq20, xirq, 20),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq3b, xirq_alternatives, 0),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq4b, xirq_alternatives, 1),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq16b, xirq_alternatives, 2),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17b, xirq_alternatives, 3),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq17c, xirq_alternatives, 4),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18b, xirq_alternatives, 5),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq18c, xirq_alternatives, 6),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq19b, xirq_alternatives, 7),
	UNIPHIER_PINCTRL_GROUP_SINGLE(xirq20b, xirq_alternatives, 8),
};

static const char * const emmc_groups[] = {"emmc", "emmc_dat8"};
static const char * const i2c0_groups[] = {"i2c0"};
static const char * const i2c1_groups[] = {"i2c1"};
static const char * const i2c2_groups[] = {"i2c2"};
static const char * const i2c3_groups[] = {"i2c3"};
static const char * const i2c5_groups[] = {"i2c5", "i2c5b", "i2c5c"};
static const char * const i2c6_groups[] = {"i2c6"};
static const char * const nand_groups[] = {"nand", "nand_cs1"};
static const char * const sd_groups[] = {"sd"};
static const char * const system_bus_groups[] = {"system_bus",
						 "system_bus_cs0",
						 "system_bus_cs1",
						 "system_bus_cs2",
						 "system_bus_cs3",
						 "system_bus_cs4",
						 "system_bus_cs5",
						 "system_bus_cs6",
						 "system_bus_cs7"};
static const char * const uart0_groups[] = {"uart0", "uart0b"};
static const char * const uart1_groups[] = {"uart1"};
static const char * const uart2_groups[] = {"uart2"};
static const char * const uart3_groups[] = {"uart3"};
static const char * const usb0_groups[] = {"usb0"};
static const char * const usb1_groups[] = {"usb1"};
static const char * const usb2_groups[] = {"usb2"};
static const char * const port_groups[] = {
	"port00",  "port01",  "port02",  "port03",
	"port04",  "port05",  "port06",  "port07",
	"port10",  "port11",  "port12",  "port13",
	"port14",  "port15",  "port16",  "port17",
	"port20",  "port21",  "port22",  "port23",
	"port24",  "port25",  "port26",  "port27",
	"port30",  "port31",  "port32",  "port33",
	"port34",  "port35",  "port36",  "port37",
	"port40",  "port41",  "port42",  "port43",
	"port44",  "port45",  "port46",  "port47",
	"port50",  "port51",  "port52",  "port53",
	"port54",  "port55",  "port56",  "port57",
	"port60",  "port61",  "port62",  "port63",
	"port64",  "port65",  "port66",  "port67",
	"port70",  "port71",  "port72",  "port73",
	"port74",  "port75",  "port76",  "port77",
	"port80",  "port81",  "port82",  "port83",
	"port84",  "port85",  "port86",  "port87",
	"port90",  "port91",  "port92",  "port93",
	"port94",  "port95",  "port96",  "port97",
	"port100", "port101", "port102", "port103",
	"port104", "port105", "port106", "port107",
	"port110", "port111", "port112", "port113",
	"port114", "port115", "port116", "port117",
	"port120", "port121", "port122", "port123",
	"port124", "port125", "port126", "port127",
	"port130", "port131", "port132", "port133",
	"port134", "port135", "port136", "port137",
	"port140", "port141", "port142", "port143",
	"port144", "port145", "port146", "port147",
	/* port150-174 missing */
	/* none */ "port175", "port176", "port177",
	"port180", "port181", "port182", "port183",
	"port184", "port185", "port186", "port187",
	"port190", "port191", "port192", "port193",
	"port194", "port195", "port196", "port197",
	"port200", "port201", "port202", "port203",
	"port204", "port205", "port206", "port207",
	"port210", "port211", "port212", "port213",
	"port214", "port215", "port216", "port217",
	"port220", "port221", "port222", "port223",
	"port224", "port225", "port226", "port227",
	"port230", "port231", "port232", "port233",
	"port234", "port235", "port236", "port237",
	"port240", "port241", "port242", "port243",
	"port244", "port245", "port246", "port247",
	"port250", "port251", "port252", "port253",
	"port254", "port255", "port256", "port257",
	"port260", "port261", "port262", "port263",
	"port264", "port265", "port266", "port267",
	"port270", "port271", "port272", "port273",
	"port274", "port275", "port276", "port277",
	"port280", "port281", "port282", "port283",
	"port284", "port285", "port286", "port287",
	"port290", "port291", "port292", "port293",
	"port294", "port295", "port296", "port297",
	"port300", "port301", "port302", "port303",
	"port304", "port305", "port306", "port307",
};
static const char * const xirq_groups[] = {
	"xirq0",  "xirq1",  "xirq2",  "xirq3",
	"xirq4",  "xirq5",  "xirq6",  "xirq7",
	"xirq8",  "xirq9",  "xirq10", "xirq11",
	"xirq12", "xirq13", "xirq14", "xirq15",
	"xirq16", "xirq17", "xirq18", "xirq19",
	"xirq20",
	"xirq3b", "xirq4b", "xirq16b", "xirq17b", "xirq17c",
	"xirq18b", "xirq18c", "xirq19b", "xirq20b",
};

static const struct uniphier_pinmux_function uniphier_pro5_functions[] = {
	UNIPHIER_PINMUX_FUNCTION(emmc),
	UNIPHIER_PINMUX_FUNCTION(i2c0),
	UNIPHIER_PINMUX_FUNCTION(i2c1),
	UNIPHIER_PINMUX_FUNCTION(i2c2),
	UNIPHIER_PINMUX_FUNCTION(i2c3),
	UNIPHIER_PINMUX_FUNCTION(i2c5),
	UNIPHIER_PINMUX_FUNCTION(i2c6),
	UNIPHIER_PINMUX_FUNCTION(nand),
	UNIPHIER_PINMUX_FUNCTION(sd),
	UNIPHIER_PINMUX_FUNCTION(system_bus),
	UNIPHIER_PINMUX_FUNCTION(uart0),
	UNIPHIER_PINMUX_FUNCTION(uart1),
	UNIPHIER_PINMUX_FUNCTION(uart2),
	UNIPHIER_PINMUX_FUNCTION(uart3),
	UNIPHIER_PINMUX_FUNCTION(usb0),
	UNIPHIER_PINMUX_FUNCTION(usb1),
	UNIPHIER_PINMUX_FUNCTION(usb2),
	UNIPHIER_PINMUX_FUNCTION(port),
	UNIPHIER_PINMUX_FUNCTION(xirq),
};

static struct uniphier_pinctrl_socdata uniphier_pro5_pindata = {
	.pins = uniphier_pro5_pins,
	.npins = ARRAY_SIZE(uniphier_pro5_pins),
	.groups = uniphier_pro5_groups,
	.groups_count = ARRAY_SIZE(uniphier_pro5_groups),
	.functions = uniphier_pro5_functions,
	.functions_count = ARRAY_SIZE(uniphier_pro5_functions),
	.caps = UNIPHIER_PINCTRL_CAPS_DBGMUX_SEPARATE,
};

static int uniphier_pro5_pinctrl_probe(struct platform_device *pdev)
{
	return uniphier_pinctrl_probe(pdev, &uniphier_pro5_pindata);
}

static const struct of_device_id uniphier_pro5_pinctrl_match[] = {
	{ .compatible = "socionext,uniphier-pro5-pinctrl" },
	{ /* sentinel */ }
};

static struct platform_driver uniphier_pro5_pinctrl_driver = {
	.probe = uniphier_pro5_pinctrl_probe,
	.driver = {
		.name = "uniphier-pro5-pinctrl",
		.of_match_table = uniphier_pro5_pinctrl_match,
	},
};
builtin_platform_driver(uniphier_pro5_pinctrl_driver);
