/* arch/arm/plat-samsung/include/plat/regs-usb3-exynos-drd-phy.h
 *
 * Copyright (c) 2011 Samsung Electronics Co. Ltd
 * Author: Anton Tikhomirov <av.tikhomirov@samsung.com>
 *
 * Exynos SuperSpeed USB 3.0 DRD Controller PHY registers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __PLAT_SAMSUNG_REGS_USB3_EXYNOS_DRD_PHY_H
#define __PLAT_SAMSUNG_REGS_USB3_EXYNOS_DRD_PHY_H __FILE__

#define EXYNOS_USB3_PHYREG(x) ((x) + S5P_VA_DRD_PHY)

#define EXYNOS_USB3_LINKSYSTEM		EXYNOS_USB3_PHYREG(0x04)
#define EXYNOS_USB3_PHYUTMI		EXYNOS_USB3_PHYREG(0x08)

#define EXYNOS_USB3_PHYUTMI_OTGDISABLE			(1 << 6)
#define EXYNOS_USB3_PHYUTMI_FORCESUSPEND		(1 << 1)
#define EXYNOS_USB3_PHYUTMI_FORCESLEEP			(1 << 0)

#define EXYNOS_USB3_PHYPIPE		EXYNOS_USB3_PHYREG(0x0C)
#define EXYNOS_USB3_PHYCLKRST		EXYNOS_USB3_PHYREG(0x10)

#define EXYNOS_USB3_PHYCLKRST_SSC_REF_CLK_SEL_MASK	(0xff << 23)
#define EXYNOS_USB3_PHYCLKRST_SSC_REF_CLK_SEL_SHIFT	(23)
#define EXYNOS_USB3_PHYCLKRST_SSC_REF_CLK_SEL_LIMIT	(0xff)
#define EXYNOS_USB3_PHYCLKRST_SSC_REF_CLK_SEL(_x)	((_x) << 23)

#define EXYNOS_USB3_PHYCLKRST_SSC_RANGE_MASK		(0x03 << 21)
#define EXYNOS_USB3_PHYCLKRST_SSC_RANGE_SHIFT		(21)
#define EXYNOS_USB3_PHYCLKRST_SSC_RANGE_LIMIT		(0x03)
#define EXYNOS_USB3_PHYCLKRST_SSC_RANGE(_x)		((_x) << 21)

#define EXYNOS_USB3_PHYCLKRST_SSC_EN			(1 << 20)
#define EXYNOS_USB3_PHYCLKRST_REF_SSP_EN		(1 << 19)
#define EXYNOS_USB3_PHYCLKRST_REF_CLKDIV2		(1 << 18)

#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_MASK	(0x7f << 11)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_SHIFT	(11)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_LIMIT	(0x7f)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER(_x)	((_x) << 11)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_100MHZ_REF \
		EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER(0x19)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_24MHZ_REF	\
		EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER(0x68)
#define EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER_20MHZ_REF	\
		EXYNOS_USB3_PHYCLKRST_MPLL_MULTIPLIER(0x7d)

#define EXYNOS_USB3_PHYCLKRST_FSEL_MASK			(0x3f << 5)
#define EXYNOS_USB3_PHYCLKRST_FSEL_SHIFT		(5)
#define EXYNOS_USB3_PHYCLKRST_FSEL_LIMIT		(0x3f)
#define EXYNOS_USB3_PHYCLKRST_FSEL(_x)			((_x) << 5)
#define EXYNOS_USB3_PHYCLKRST_FSEL_PAD_100MHZ		\
		EXYNOS_USB3_PHYCLKRST_FSEL(0x27)
#define EXYNOS_USB3_PHYCLKRST_FSEL_PAD_24MHZ		\
		EXYNOS_USB3_PHYCLKRST_FSEL(0x2a)
#define EXYNOS_USB3_PHYCLKRST_FSEL_PAD_20MHZ		\
		EXYNOS_USB3_PHYCLKRST_FSEL(0x31)
#define EXYNOS_USB3_PHYCLKRST_FSEL_PAD_19_2MHZ		\
		EXYNOS_USB3_PHYCLKRST_FSEL(0x38)


#define EXYNOS_USB3_PHYCLKRST_RETENABLEN		(1 << 4)

#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL_MASK		(0x03 << 2)
#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL_SHIFT		(2)
#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL_LIMIT		(0x03)
#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL(_x)		((_x) << 2)
#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL_PAD_REF_CLK	\
		EXYNOS_USB3_PHYCLKRST_REFCLKSEL(2)
#define EXYNOS_USB3_PHYCLKRST_REFCLKSEL_EXT_REF_CLK	\
		EXYNOS_USB3_PHYCLKRST_REFCLKSEL(3)

#define EXYNOS_USB3_PHYCLKRST_PORTRESET			(1 << 1)
#define EXYNOS_USB3_PHYCLKRST_COMMONONN			(1 << 0)

#define EXYNOS_USB3_PHYREG0		EXYNOS_USB3_PHYREG(0x14)
#define EXYNOS_USB3_PHYREG1		EXYNOS_USB3_PHYREG(0x18)
#define EXYNOS_USB3_PHYPARAM0		EXYNOS_USB3_PHYREG(0x1C)
#define EXYNOS_USB3_PHYPARAM1		EXYNOS_USB3_PHYREG(0x20)
#define EXYNOS_USB3_PHYTERM		EXYNOS_USB3_PHYREG(0x24)

#define EXYNOS_USB3_PHYTEST		EXYNOS_USB3_PHYREG(0x28)

#define EXYNOS_USB3_PHYTEST_POWERDOWN_SSP		(1 << 3)
#define EXYNOS_USB3_PHYTEST_POWERDOWN_HSP		(1 << 2)

#define EXYNOS_USB3_PHYADP		EXYNOS_USB3_PHYREG(0x2C)
#define EXYNOS_USB3_PHYBATCHG		EXYNOS_USB3_PHYREG(0x30)
#define EXYNOS_USB3_PHYRESUME		EXYNOS_USB3_PHYREG(0x34)
#define EXYNOS_USB3_LINKPORT		EXYNOS_USB3_PHYREG(0x44)
#endif /* __PLAT_SAMSUNG_REGS_USB3_EXYNOS_DRD_PHY_H */
