
set(LIBEV_PATH "" CACHE PATH "Base path for include/ev.h and lib/libev*")
set(LIBEV_INCLUDE_PATH "" CACHE PATH "Include path for ev.h")
set(LIBEV_LIBDIR "" CACHE PATH "Path containing libev")

if(LIBEV_PATH)
	set(LIBEV_INCLUDE_PATH "${LIBEV_PATH}/include" CACHE PATH "Include path for ev.h" FORCE)
	set(LIBEV_LIBDIR "${LIBEV_PATH}/lib" CACHE PATH "Path containing libev" FORCE)
endif()

if(LIBEV_INCLUDE_PATH)
	include_directories(${LIBEV_INCLUDE_PATH})
endif()

# Use cached result
if(NOT LIBEV_FOUND)
	unset(HAVE_EV_H)
	unset(HAVE_LIBEV)
	unset(HAVE_EV_H CACHE)
	unset(HAVE_LIBEV CACHE)
	unset(LIBEV_CFLAGS)
	unset(LIBEV_LDFLAGS)

	if(LIBEV_INCLUDE_PATH OR LIBEV_LIBDIR)
		set(CMAKE_REQUIRED_INCLUDES ${LIBEV_INCLUDE_PATH})
#		message(STATUS "Looking for ev.h in ${CMAKE_REQUIRED_INCLUDES}")
		check_include_files(ev.h HAVE_EV_H)
		if(HAVE_EV_H)
#			message(STATUS "Looking for lib ev in ${LIBEV_LIBDIR}")
			check_library_exists(ev ev_time "${LIBEV_LIBDIR}" HAVE_LIBEV)
			if(HAVE_LIBEV)
				set(LIBEV_CFLAGS "" CACHE INTERNAL "")
				set(LIBEV_LDFLAGS "-L${LIBEV_LIBDIR} -lev" CACHE INTERNAL "")
				set(LIBEV_FOUND TRUE CACHE INTERNAL "Found libev")
			else()
				message(STATUS "Couldn't find lib ev in ${LIBEV_LIBDIR}")
			endif()
		else()
			message(STATUS "Couldn't find <ev.h> in ${LIBEV_INCLUDE_PATH}")
		endif()
	else()
		pkg_check_modules(LIBEV libev)
		if(NOT LIBEV_FOUND)
#			message(STATUS "Looking for ev.h in ${CMAKE_REQUIRED_INCLUDES}")
			check_include_files(ev.h HAVE_EV_H)
			if(HAVE_EV_H)
#				message(STATUS "Looking for lib ev")
				check_library_exists(ev ev_time "" HAVE_LIBEV)
				if(HAVE_LIBEV)
					set(LIBEV_CFLAGS "" CACHE INTERNAL "")
					set(LIBEV_LDFLAGS "-lev" CACHE INTERNAL "")
					set(LIBEV_FOUND TRUE CACHE INTERNAL "Found libev")
				else()
					message(STATUS "Couldn't find lib ev")
				endif()
			else()
				message(STATUS "Couldn't find <ev.h>")
			endif()
		endif()
	endif()

endif()

if(NOT LIBEV_FOUND)
	if(LibEV_FIND_REQUIRED)
		message(FATAL_ERROR "Could not find libev")
	endif()
endif()

mark_as_advanced(LIBEV_PATH LIBEV_INCLUDE_PATH LIBEV_LIBDIR)
