/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "main.h"

#define KEYFILE "." PACKAGE_NAME "rc"

/* Groups */
#define PLUGINS "Plugins"
#define SCREEN  "Screen"
#define ENGINE  "Engine"
#define INPUT   "Input"
#define WEBCAM  "Webcam"

/*
   [Plugins]
   Input=alsa
   Output=SDL
   
   [Screen]
   Width=640
   Height=480
   FullScreen=false
   
   [Engine]
   Themes=biniou
   OSD=0
   RandomMode=2
   Fps=60

   [Input]
   AntiPhase=false

   [Webcam]
   HorizontalFlip=false
   VerticalFlip=false
   Webcams=1
   Device=/dev/video0
*/

extern float phase;
#ifdef WITH_WEBCAM
extern int hflip, vflip, webcams;
extern char *video_base;
#endif


static void
process(GKeyFile *kf)
{
  GError *error = NULL;
  gchar *input = NULL, *output = NULL, *kf_themes = NULL;
  gchar fs = FALSE, antiphase = FALSE;
#ifndef FIXED
  gint kf_width, kf_height;
#endif
  gint kf_fps, kf_osd, kf_rnd;
#ifdef WITH_WEBCAM
  gchar whflip = FALSE, wvflip = FALSE;
  gint kf_webcams;
  gchar *kf_video_base;
#endif

  input = g_key_file_get_string(kf, PLUGINS, "Input", NULL);
  if (NULL != input) {
    input_plugin = input;
#ifdef DEBUG
    printf("[k] Setting input plugin: %s\n", input_plugin);
#endif
  }

  output = g_key_file_get_string(kf, PLUGINS, "Output", NULL);
  if (NULL != output) {
    output_plugin = output;
#ifdef DEBUG
    printf("[k] Setting output plugin: %s\n", output_plugin);
#endif
  }

  fs = g_key_file_get_boolean(kf, SCREEN, "FullScreen", &error);
  if (NULL == error) {
    if (fs != fullscreen) {
      fullscreen = fs;
#ifdef DEBUG
      printf("[k] Setting full-screen to: %s\n", (fs ? "on" : "off"));
#endif
    }
  } else {
    g_error_free(error);
    error = NULL;
  }

#ifndef FIXED
  kf_width = g_key_file_get_integer(kf, SCREEN, "Width", &error);
  if (NULL == error) {
    if (kf_width > 0)
      if (width != kf_width) {
	width = kf_width;
#ifdef DEBUG
	printf("[k] Setting screen width to %d\n", width);
#endif
      }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_height = g_key_file_get_integer(kf, SCREEN, "Height", &error);
  if (NULL == error) {
    if (kf_height > 0)
      if (height != kf_height) {
	height = kf_height;
#ifdef DEBUG
	printf("[k] Setting screen height to %d\n", height);
#endif
      }
  } else {
    g_error_free(error);
    error = NULL;
  }
#endif

  kf_fps = g_key_file_get_integer(kf, ENGINE, "Fps", &error);
  if (NULL == error) {
    if (kf_fps > 0)
      if (max_fps != kf_fps) {
	max_fps = kf_fps;
#ifdef DEBUG
	printf("[k] Setting FPS to %li\n", max_fps);
#endif
      }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_osd = g_key_file_get_integer(kf, ENGINE, "OSD", &error);
  if (NULL == error) {
    if ((kf_osd >= OSD_NONE) && (kf_osd <= OSD_FULL_BG))
      if ((gint)osd_mode != kf_osd) {
	osd_mode = kf_osd;
#ifdef DEBUG
	printf("[k] Setting OSD to %d\n", kf_osd);
#endif
      }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_rnd = g_key_file_get_integer(kf, ENGINE, "RandomMode", &error);
  if (NULL == error) {
    if ((kf_rnd >= BR_NONE) && (kf_rnd <= BR_BOTH))
      if ((gint)random_mode != kf_rnd) {
	random_mode = kf_rnd;
#ifdef DEBUG
	printf("[k] Setting random mode to %d\n", kf_rnd);
#endif
      }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_themes = g_key_file_get_string(kf, ENGINE, "Themes", NULL);
  if (NULL != kf_themes) {
    themes = kf_themes;
#ifdef DEBUG
    printf("[k] Setting themes to: %s\n", themes);
#endif
  }

  antiphase = g_key_file_get_boolean(kf, INPUT, "AntiPhase", &error);
  if (NULL == error) {
    if (antiphase == TRUE) {
      phase = -1.0;
#ifdef DEBUG
      printf("[k] Setting antiphase\n");
#endif
    }
  } else {
    g_error_free(error);
    error = NULL;
  }

#ifdef WITH_WEBCAM
  whflip = g_key_file_get_boolean(kf, WEBCAM, "HorizontalFlip", &error);
  if (NULL == error) {
    if (whflip == TRUE) {
#ifdef DEBUG
      printf("[k] Setting webcam horizontal flip\n");
#endif
      hflip = !hflip;
    }
  } else {
    g_error_free(error);
    error = NULL;
  }

  wvflip = g_key_file_get_boolean(kf, WEBCAM, "VerticalFlip", &error);
  if (NULL == error) {
    if (wvflip == TRUE) {
#ifdef DEBUG
      printf("[k] Setting webcam vertical flip\n");
#endif
      vflip = !vflip;
    }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_webcams = g_key_file_get_integer(kf, WEBCAM, "Webcams", &error);
  if (NULL == error) {
    if ((kf_webcams >= 0) && (kf_webcams <= MAX_CAMS)) {
      webcams = kf_webcams;
#ifdef DEBUG
      printf("[k] Webcam: grabbing %d device%s\n", webcams, (webcams == 1 ? "": "s"));
#endif
    }
  } else {
    g_error_free(error);
    error = NULL;
  }

  kf_video_base = g_key_file_get_string(kf, WEBCAM, "Device", NULL);
  if (NULL != kf_video_base) {
    free(video_base);
    video_base = kf_video_base;
#ifdef DEBUG
    printf("[k] Webcam: device base %s\n", video_base);
#endif
  }
#endif /* WITH_WEBCAM */
}


void
read_keyfile()
{
  const gchar *home_dir = NULL;
  gchar *keyfile = NULL;
  GKeyFile* kf = NULL;
  GKeyFileFlags flags = G_KEY_FILE_NONE;
  GError *error = NULL;

  home_dir = g_get_home_dir();
  keyfile = g_strdup_printf("%s/%s", home_dir, KEYFILE);

  kf = g_key_file_new();
  if (TRUE != g_key_file_load_from_file(kf, keyfile, flags, &error)) {
    if (G_FILE_ERROR_NOENT == error->code) {
      g_free(keyfile);
      g_key_file_free(kf);
      return;
    } else
      xerror("failed to load %s\n", keyfile);
  }

  process(kf);

  g_free(keyfile);
  g_key_file_free(kf);
}
