/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_log.h
    \brief  Logging API for the LCMAPS plugins and LCMAPS itself
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCMAPS logging functions
    The LCMAPS plugins can use this API to write output to the LCMAPS logging
    devices.
    -# lcmaps_log(): Log to LCMAPS logging devices.
    -# lcmaps_log_debug(): Produce debugging output.
    \ingroup APIforLcmapsPlugins
*/

#ifndef LCMAPS_LOG_H
#define LCMAPS_LOG_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <syslog.h>

/******************************************************************************
 *                            Module definition
 *****************************************************************************/
/******************************************************************************
Function:       lcmaps_log()
Description:    Log information to file and or syslog
Parameters:
                prty:    syslog priority (if 0 don't syslog)
                fmt:     string format
Returns:        0 succes
                1 failure
******************************************************************************/
extern int lcmaps_log(
        int prty,
        char * fmt,
        ...
);

/******************************************************************************
Function:       lcmaps_log_debug()
Description:    Print debugging information
Parameters:
                debug_lvl: debugging level
                fmt:       string format
Returns:        0 succes
                1 failure
******************************************************************************/
extern int lcmaps_log_debug(
        int debug_lvl,
        char * fmt,
        ...
);

/******************************************************************************
Function:       lcmaps_log_time()
Description:    Log information to file and or syslog with a timestamp
Parameters:
                prty:    syslog priority (if 0 don't syslog)
                fmt:     string format
Returns:        0 succes
                1 failure
******************************************************************************/
extern int lcmaps_log_time(
        int prty, 
        char * fmt, 
        ...
);

/******************************************************************************
Function:       lcmaps_log_a_string()
Description:    Log a string according to the passed format to file and or syslog
Parameters:
                prty:       syslog priority (if 0 don't syslog)
                fmt:        string format
                the_string: the string
Returns:        0 succes
                1 failure
******************************************************************************/
extern int lcmaps_log_a_string(
        int prty,
        char * fmt,
        char * the_string
);

/******************************************************************************
Function:       lcmaps_log_a_string_debug()
Description:    Print debugging information
Parameters:
                debug_lvl:  debugging level
                fmt:        string format
                the_string: the string
Returns:        0 succes
                1 failure
******************************************************************************/
extern int lcmaps_log_a_string_debug(
        int debug_lvl,
        char * fmt,
        char * the_string
);
#endif /* LCMAPS_LOG_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/interface/lcmaps_log.h,v $
    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
    $Revision: 14868 $
    $Author: dennisvd $
******************************************************************************/
