#!/bin/sh

test_description="simple tests for otftotfm - part of LCDF Typetools"

. /usr/share/sharness/sharness.sh

CFF=/usr/share/fonts/opentype/font-awesome/FontAwesome.otf
TTF=/usr/share/fonts/truetype/noto/NotoSans-Regular.ttf

test_expect_success "otftotfm version" "
    otftotfm --version > out &&
    grep -x 'otftotfm (LCDF typetools) [0-9.]\+' out
"

test_expect_success "otftotfm help" "
    otftotfm --help > out &&
    grep -Fx 'Usage: otftotfm [-a] [OPTIONS] OTFFILE FONTNAME' out
"

test_expect_success "otftotfm from OpenType/CFF" "
    otftotfm --automatic $CFF FontAwesome
"

test_expect_success "otftotfm fail from bogus name" "
    test_expect_code 1 otftotfm --automatic $CFF FooBar
"

test_expect_success "otftotfm fail from OpenType/TTF" "
    test_expect_code 1 otftotfm --automatic $TTF Noto
"

test_done
