#include "Exception.h"

#include <string.h> // strerror_r

#include <stdio.h>

#include <typeinfo>

#ifdef HAVE_EXECINFO_H
#include <execinfo.h>
#endif

using namespace std;

#ifdef HAVE_EXECINFO_H
void DefaultUnexpected()
{
	try {
		const int trace_size = 50;
		void *addrs[trace_size];
		size_t size = backtrace (addrs, trace_size);
		char **strings = backtrace_symbols (addrs, size);

		fprintf(stderr, "Caught unexpected exception, %zd stack frames unwound:\n", size);
		for (size_t i = 0; i < size; i++)
			fprintf (stderr, "   %s\n", strings[i]);
		free (strings);
		throw;
	} catch (Exception& e) {
		fprintf(stderr, "Exception was: %s: %.*s.\n", e.type(), PFSTR(e.desc()));
		throw;
	} catch (exception& e) {
		fprintf(stderr, "Exception was: %s: %s\n", typeid(e).name(), e.what());
		throw;
	} catch (...) {
		fprintf(stderr, "Exception was: unknown object\n");
		throw;
	}
}
#else
void DefaultUnexpected()
{
	try {
		fprintf(stderr, "Caught unexpected exception\n");
		throw;
	} catch (Exception& e) {
		fprintf(stderr, "Exception was: %s: %.*s.\n", e.type(), PFSTR(e.desc()));
		throw;
	} catch (exception& e) {
		fprintf(stderr, "Exception was: %s: %s\n", typeid(e).name(), e.what());
		throw;
	} catch (...) {
		fprintf(stderr, "Exception was: unknown object\n");
		throw;
	}
}
#endif

InstallUnexpected::InstallUnexpected(void (*func)())
{
	old = set_unexpected(func);
}

InstallUnexpected::~InstallUnexpected()
{
	set_unexpected(old);
}

///// SystemException

string SystemException::system_desc() const throw ()
{
	const int buf_size = 100;
	char* buf = new char[buf_size];
	string res(strerror_r(_code, buf, buf_size));
	delete buf;
	return res;
}

// vim:set ts=4 sw=4:
