/***************************************************************************
                          kmessshared.h  -  description
                             -------------------
    begin                : Thu May 8 2008
    copyright            : (C) 2008 by Valerio Pilo
    email                : valerio@kmess.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSSHARED_H
#define KMESSSHARED_H

#include <QByteArray>
#include <QObject>
#include <QPixmap>


// Forward declaration
class KUrl;



/**
 * @brief Shared globally useful methods for KMess
 *
 * This class is just a container for many methods which are useful throughout the entire
 * application.
 *
 * @author Valerio Pilo <valerio@kmess.org>
 * @ingroup Utils
 */
class KMessShared
{

  public: // Public static methods
    // Sorting helper, to compare two filenames using natural sorting
    static bool            compareFileNames( const QString& name1, const QString& name2 );
    // Create a HMACSha1 hash
    static QByteArray      createHMACSha1( const QByteArray &keyForHash, const QByteArray &secret );
    // Return a derived key with HMACSha1 algorithm
    static QByteArray      deriveKey( const QByteArray &keyToDerive, const QByteArray &magic );
    // Generate a random GUID.
    static QString         generateGUID();
    // Generate an random number to use as ID
    static quint32         generateID();
    // Return the hash of a file name using the SHA1 algorithm
    static QByteArray      generateFileHash( const QString &fileName );
    // Converts a string with HTML to one with escaped entities
    static QString        &htmlEscape( QString &string );
    // Converts a string constant with HTML to one with escaped entities
    static QString         htmlEscape( const QString &string );
    // Converts a string with escaped entities to one with HTML
    static QString        &htmlUnescape( QString &string );
    // Converts a string constant with escaped entities to one with HTML
    static QString         htmlUnescape( const QString &string );
    // Open the given URL respecting the user's preference
    static void            openBrowser( const KUrl &url );
    // Open the given URL mail respecting the user's preference
    static void            openEmailClient( const QString &mailto, const QString &folder, bool isHotmailAvailable = true );
    // Select the next available file
    static bool            selectNextFile( const QString &directory, const QString &baseName, QString &suffix, const QString &extension, int &startingNumber );
    // Returns the full path to the next non-existing sequentially mumbered file
    static QString         nextSequentialFile( const QString &baseDirPath, const QString &baseFileName, const QString &extension, QString &lastFile );
    // Draws an icon with an overlay from two pixmaps (width and height -1, the defaults, mean take the width and height from the icon itself)
    static QPixmap         drawIconOverlay( const QPixmap icon, const QPixmap overlay, int width = -1, int height = -1, float sizeFactor = 0.5, float iconSizeFactor = 1.0 );
    // Truncate an UTF-8 multibyte string to a fixed byte size
    static QString         fixStringToByteSize( const QString &string, quint32 size );

  private:
    // Create the html file to request the given service
    static QString         createRequestFile( const QString &mailto, const QString &folder );
};

#endif
