/***************************************************************************
                          kmessapplication.h -  description
                             -------------------
    begin                : Wed 7 13 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSAPPLICATION_H
#define KMESSAPPLICATION_H

#include <KApplication>


class KMess;



/**
 * @brief KApplication subclass to handle quit requests.
 *
 * This class stores the data to close or quit KMess correctly.
 * When quitSelected() is false, the main window should only close.
 * When it's true, or sessionSaving() returns true, the application is exiting.
 * For compatibility with KDE 3.1.0, the sessionSaving() is implemented in an <code>\#if</code> block,
 * so users can still compile KMess at their old systems.
 *
 * @author Mike K. Bennett (original work), Diederik van der Boor (new class)
 * @ingroup Root
 */
class KMessApplication : public KApplication
{
  Q_OBJECT

  friend class KMessTest;

  public:
    // Constructor
                KMessApplication();

    // Destructor
    virtual    ~KMessApplication();

    // Return the contact list window
    KMess*       getContactListWindow() const;
    // Return the server used in test server mode
    const QString&getTestServer() const;
    // Return whether to use an alternative server as the Live Service server
    bool         getUseTestServer() const;
    // Return true if quit was selected
    bool         quitSelected() const;
    // Tell the application that quit was selected
    void         setQuitSelected(bool quitSelected);

  private slots:
    void         slotAboutToQuit();
    void         slotLastWindowClosed();

  private:  // private methods
    void         initializeMainWindow();
    void         initializePaths();

  private:
    // Reference to the contact list window
    KMess       *contactListWindow_;
    // True when quit was selected
    bool         quitSelected_;
    // Address of the testing server, if any
    QString      testServerAddress_;
};

#endif
