/***************************************************************************
                          invitedcontact.h  -  description
                             -------------------
    begin                : Thu Jan 16 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INVITEDCONTACT_H
#define INVITEDCONTACT_H

#include "../contact/contactbase.h"



/**
 * @brief Data class for contacts that are not in your MSN ContactList.
 *
 * This class represents a contact that's in a chat but not on the ContactList.
 * This occurs when someone invites one of their contacts in the chat.
 * If your privacy settings allow this, contacts can always start a chat with you (even if they're not on your AL/BL/FL/RL lists).
 *
 * @author Mike K. Bennett
 * @ingroup Contact
 */
class InvitedContact : public ContactBase
{
  Q_OBJECT

  public:
    // The constructor
                         InvitedContact( const QString &handle, const QString &friendlyName = QString(), uint capabilities = 0 );
    // The destructor
    virtual             ~InvitedContact();
    // Return the path to the contact's picture
    const QString        getContactPicturePath() const;
    // Return the contact's status
    Status               getStatus() const;
};

#endif
