
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraFocusControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraFocusControl>
#include <QCameraFocusZone>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPointF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraFocusControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraFocusControl::staticMetaObject);
}


// QPointF QCameraFocusControl::customFocusPoint()


static void _init_f_customFocusPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_customFocusPoint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QCameraFocusControl *)cls)->customFocusPoint ());
}


// QFlags<QCameraFocus::FocusMode> QCameraFocusControl::focusMode()


static void _init_f_focusMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCameraFocus::FocusMode> > ();
}

static void _call_f_focusMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCameraFocus::FocusMode> > ((QFlags<QCameraFocus::FocusMode>)((QCameraFocusControl *)cls)->focusMode ());
}


// QCameraFocus::FocusPointMode QCameraFocusControl::focusPointMode()


static void _init_f_focusPointMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type > ();
}

static void _call_f_focusPointMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type > ((qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type)qt_gsi::CppToQtAdaptor<QCameraFocus::FocusPointMode>(((QCameraFocusControl *)cls)->focusPointMode ()));
}


// QList<QCameraFocusZone> QCameraFocusControl::focusZones()


static void _init_f_focusZones_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QCameraFocusZone> > ();
}

static void _call_f_focusZones_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QCameraFocusZone> > ((QList<QCameraFocusZone>)((QCameraFocusControl *)cls)->focusZones ());
}


// bool QCameraFocusControl::isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode)


static void _init_f_isFocusModeSupported_c3327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraFocus::FocusMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFocusModeSupported_c3327 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraFocus::FocusMode> arg1 = gsi::arg_reader<QFlags<QCameraFocus::FocusMode> >() (args, heap);
  ret.write<bool > ((bool)((QCameraFocusControl *)cls)->isFocusModeSupported (arg1));
}


// bool QCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode)


static void _init_f_isFocusPointModeSupported_c3153 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isFocusPointModeSupported_c3153 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFocusControl *)cls)->isFocusPointModeSupported (qt_gsi::QtToCppAdaptor<QCameraFocus::FocusPointMode>(arg1).cref()));
}


// void QCameraFocusControl::setCustomFocusPoint(const QPointF &point)


static void _init_f_setCustomFocusPoint_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCustomFocusPoint_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl *)cls)->setCustomFocusPoint (arg1);
}


// void QCameraFocusControl::setFocusMode(QFlags<QCameraFocus::FocusMode> mode)


static void _init_f_setFocusMode_3327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraFocus::FocusMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusMode_3327 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraFocus::FocusMode> arg1 = gsi::arg_reader<QFlags<QCameraFocus::FocusMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl *)cls)->setFocusMode (arg1);
}


// void QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)


static void _init_f_setFocusPointMode_3153 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusPointMode_3153 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl *)cls)->setFocusPointMode (qt_gsi::QtToCppAdaptor<QCameraFocus::FocusPointMode>(arg1).cref());
}


// static QString QCameraFocusControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraFocusControl::tr (arg1, arg2, arg3));
}


// static QString QCameraFocusControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraFocusControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraFocusControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":customFocusPoint", "@brief Method QPointF QCameraFocusControl::customFocusPoint()\n", true, &_init_f_customFocusPoint_c0, &_call_f_customFocusPoint_c0);
  methods += new qt_gsi::GenericMethod (":focusMode", "@brief Method QFlags<QCameraFocus::FocusMode> QCameraFocusControl::focusMode()\n", true, &_init_f_focusMode_c0, &_call_f_focusMode_c0);
  methods += new qt_gsi::GenericMethod (":focusPointMode", "@brief Method QCameraFocus::FocusPointMode QCameraFocusControl::focusPointMode()\n", true, &_init_f_focusPointMode_c0, &_call_f_focusPointMode_c0);
  methods += new qt_gsi::GenericMethod ("focusZones", "@brief Method QList<QCameraFocusZone> QCameraFocusControl::focusZones()\n", true, &_init_f_focusZones_c0, &_call_f_focusZones_c0);
  methods += new qt_gsi::GenericMethod ("isFocusModeSupported?", "@brief Method bool QCameraFocusControl::isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode)\n", true, &_init_f_isFocusModeSupported_c3327, &_call_f_isFocusModeSupported_c3327);
  methods += new qt_gsi::GenericMethod ("isFocusPointModeSupported?", "@brief Method bool QCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode)\n", true, &_init_f_isFocusPointModeSupported_c3153, &_call_f_isFocusPointModeSupported_c3153);
  methods += new qt_gsi::GenericMethod ("setCustomFocusPoint|customFocusPoint=", "@brief Method void QCameraFocusControl::setCustomFocusPoint(const QPointF &point)\n", false, &_init_f_setCustomFocusPoint_1986, &_call_f_setCustomFocusPoint_1986);
  methods += new qt_gsi::GenericMethod ("setFocusMode|focusMode=", "@brief Method void QCameraFocusControl::setFocusMode(QFlags<QCameraFocus::FocusMode> mode)\n", false, &_init_f_setFocusMode_3327, &_call_f_setFocusMode_3327);
  methods += new qt_gsi::GenericMethod ("setFocusPointMode|focusPointMode=", "@brief Method void QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)\n", false, &_init_f_setFocusPointMode_3153, &_call_f_setFocusPointMode_3153);
  methods += gsi::qt_signal<const QPointF & > ("customFocusPointChanged(const QPointF &)", "customFocusPointChanged", gsi::arg("point"), "@brief Signal declaration for QCameraFocusControl::customFocusPointChanged(const QPointF &point)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraFocusControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QFlags<QCameraFocus::FocusMode> > ("focusModeChanged(QFlags<QCameraFocus::FocusMode>)", "focusModeChanged", gsi::arg("mode"), "@brief Signal declaration for QCameraFocusControl::focusModeChanged(QFlags<QCameraFocus::FocusMode> mode)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > ("focusPointModeChanged(QCameraFocus::FocusPointMode)", "focusPointModeChanged", gsi::arg("mode"), "@brief Signal declaration for QCameraFocusControl::focusPointModeChanged(QCameraFocus::FocusPointMode mode)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("focusZonesChanged()", "focusZonesChanged", "@brief Signal declaration for QCameraFocusControl::focusZonesChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCameraFocusControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraFocusControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraFocusControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraFocusControl> decl_QCameraFocusControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraFocusControl_Native",
  methods_QCameraFocusControl (),
  "@hide\n@alias QCameraFocusControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraFocusControl> &qtdecl_QCameraFocusControl () { return decl_QCameraFocusControl; }

}


class QCameraFocusControl_Adaptor : public QCameraFocusControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraFocusControl_Adaptor();

  //  [adaptor ctor] QCameraFocusControl::QCameraFocusControl()
  QCameraFocusControl_Adaptor() : QCameraFocusControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraFocusControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraFocusControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraFocusControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraFocusControl::receivers(const char *signal)
  int fp_QCameraFocusControl_receivers_c1731 (const char *signal) const {
    return QCameraFocusControl::receivers(signal);
  }

  //  [expose] QObject *QCameraFocusControl::sender()
  QObject * fp_QCameraFocusControl_sender_c0 () const {
    return QCameraFocusControl::sender();
  }

  //  [expose] int QCameraFocusControl::senderSignalIndex()
  int fp_QCameraFocusControl_senderSignalIndex_c0 () const {
    return QCameraFocusControl::senderSignalIndex();
  }

  //  [adaptor impl] QPointF QCameraFocusControl::customFocusPoint()
  QPointF cbs_customFocusPoint_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("customFocusPoint");
  }

  virtual QPointF customFocusPoint() const
  {
    if (cb_customFocusPoint_c0_0.can_issue()) {
      return cb_customFocusPoint_c0_0.issue<QCameraFocusControl_Adaptor, QPointF>(&QCameraFocusControl_Adaptor::cbs_customFocusPoint_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("customFocusPoint");
    }
  }

  //  [emitter impl] void QCameraFocusControl::customFocusPointChanged(const QPointF &point)
  void emitter_QCameraFocusControl_customFocusPointChanged_1986(const QPointF &point)
  {
    emit QCameraFocusControl::customFocusPointChanged(point);
  }

  //  [emitter impl] void QCameraFocusControl::destroyed(QObject *)
  void emitter_QCameraFocusControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraFocusControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QCameraFocusControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCameraFocusControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraFocusControl_Adaptor, bool, QEvent *>(&QCameraFocusControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCameraFocusControl::event(_event);
    }
  }

  //  [adaptor impl] bool QCameraFocusControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCameraFocusControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraFocusControl_Adaptor, bool, QObject *, QEvent *>(&QCameraFocusControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCameraFocusControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QFlags<QCameraFocus::FocusMode> QCameraFocusControl::focusMode()
  QFlags<QCameraFocus::FocusMode> cbs_focusMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("focusMode");
  }

  virtual QFlags<QCameraFocus::FocusMode> focusMode() const
  {
    if (cb_focusMode_c0_0.can_issue()) {
      return cb_focusMode_c0_0.issue<QCameraFocusControl_Adaptor, QFlags<QCameraFocus::FocusMode> >(&QCameraFocusControl_Adaptor::cbs_focusMode_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("focusMode");
    }
  }

  //  [emitter impl] void QCameraFocusControl::focusModeChanged(QFlags<QCameraFocus::FocusMode> mode)
  void emitter_QCameraFocusControl_focusModeChanged_3327(QFlags<QCameraFocus::FocusMode> mode)
  {
    emit QCameraFocusControl::focusModeChanged(mode);
  }

  //  [adaptor impl] QCameraFocus::FocusPointMode QCameraFocusControl::focusPointMode()
  qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type cbs_focusPointMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("focusPointMode");
  }

  virtual QCameraFocus::FocusPointMode focusPointMode() const
  {
    if (cb_focusPointMode_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QCameraFocus::FocusPointMode>(cb_focusPointMode_c0_0.issue<QCameraFocusControl_Adaptor, qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type>(&QCameraFocusControl_Adaptor::cbs_focusPointMode_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("focusPointMode");
    }
  }

  //  [emitter impl] void QCameraFocusControl::focusPointModeChanged(QCameraFocus::FocusPointMode mode)
  void emitter_QCameraFocusControl_focusPointModeChanged_3153(QCameraFocus::FocusPointMode mode)
  {
    emit QCameraFocusControl::focusPointModeChanged(mode);
  }

  //  [adaptor impl] QList<QCameraFocusZone> QCameraFocusControl::focusZones()
  QList<QCameraFocusZone> cbs_focusZones_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("focusZones");
  }

  virtual QList<QCameraFocusZone> focusZones() const
  {
    if (cb_focusZones_c0_0.can_issue()) {
      return cb_focusZones_c0_0.issue<QCameraFocusControl_Adaptor, QList<QCameraFocusZone> >(&QCameraFocusControl_Adaptor::cbs_focusZones_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("focusZones");
    }
  }

  //  [emitter impl] void QCameraFocusControl::focusZonesChanged()
  void emitter_QCameraFocusControl_focusZonesChanged_0()
  {
    emit QCameraFocusControl::focusZonesChanged();
  }

  //  [adaptor impl] bool QCameraFocusControl::isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode)
  bool cbs_isFocusModeSupported_c3327_0(QFlags<QCameraFocus::FocusMode> mode) const
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("isFocusModeSupported");
  }

  virtual bool isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode) const
  {
    if (cb_isFocusModeSupported_c3327_0.can_issue()) {
      return cb_isFocusModeSupported_c3327_0.issue<QCameraFocusControl_Adaptor, bool, QFlags<QCameraFocus::FocusMode> >(&QCameraFocusControl_Adaptor::cbs_isFocusModeSupported_c3327_0, mode);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isFocusModeSupported");
    }
  }

  //  [adaptor impl] bool QCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode)
  bool cbs_isFocusPointModeSupported_c3153_0(const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & mode) const
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("isFocusPointModeSupported");
  }

  virtual bool isFocusPointModeSupported(QCameraFocus::FocusPointMode mode) const
  {
    if (cb_isFocusPointModeSupported_c3153_0.can_issue()) {
      return cb_isFocusPointModeSupported_c3153_0.issue<QCameraFocusControl_Adaptor, bool, const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type &>(&QCameraFocusControl_Adaptor::cbs_isFocusPointModeSupported_c3153_0, qt_gsi::CppToQtAdaptor<QCameraFocus::FocusPointMode>(mode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isFocusPointModeSupported");
    }
  }

  //  [emitter impl] void QCameraFocusControl::objectNameChanged(const QString &objectName)
  void emitter_QCameraFocusControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCameraFocusControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QCameraFocusControl::setCustomFocusPoint(const QPointF &point)
  void cbs_setCustomFocusPoint_1986_0(const QPointF &point)
  {
    __SUPPRESS_UNUSED_WARNING (point);
    throw qt_gsi::AbstractMethodCalledException("setCustomFocusPoint");
  }

  virtual void setCustomFocusPoint(const QPointF &point)
  {
    if (cb_setCustomFocusPoint_1986_0.can_issue()) {
      cb_setCustomFocusPoint_1986_0.issue<QCameraFocusControl_Adaptor, const QPointF &>(&QCameraFocusControl_Adaptor::cbs_setCustomFocusPoint_1986_0, point);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setCustomFocusPoint");
    }
  }

  //  [adaptor impl] void QCameraFocusControl::setFocusMode(QFlags<QCameraFocus::FocusMode> mode)
  void cbs_setFocusMode_3327_0(QFlags<QCameraFocus::FocusMode> mode)
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("setFocusMode");
  }

  virtual void setFocusMode(QFlags<QCameraFocus::FocusMode> mode)
  {
    if (cb_setFocusMode_3327_0.can_issue()) {
      cb_setFocusMode_3327_0.issue<QCameraFocusControl_Adaptor, QFlags<QCameraFocus::FocusMode> >(&QCameraFocusControl_Adaptor::cbs_setFocusMode_3327_0, mode);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFocusMode");
    }
  }

  //  [adaptor impl] void QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)
  void cbs_setFocusPointMode_3153_0(const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & mode)
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("setFocusPointMode");
  }

  virtual void setFocusPointMode(QCameraFocus::FocusPointMode mode)
  {
    if (cb_setFocusPointMode_3153_0.can_issue()) {
      cb_setFocusPointMode_3153_0.issue<QCameraFocusControl_Adaptor, const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type &>(&QCameraFocusControl_Adaptor::cbs_setFocusPointMode_3153_0, qt_gsi::CppToQtAdaptor<QCameraFocus::FocusPointMode>(mode));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFocusPointMode");
    }
  }

  //  [adaptor impl] void QCameraFocusControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCameraFocusControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraFocusControl_Adaptor, QChildEvent *>(&QCameraFocusControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCameraFocusControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QCameraFocusControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCameraFocusControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraFocusControl_Adaptor, QEvent *>(&QCameraFocusControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCameraFocusControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QCameraFocusControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraFocusControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraFocusControl_Adaptor, const QMetaMethod &>(&QCameraFocusControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraFocusControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraFocusControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCameraFocusControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraFocusControl_Adaptor, QTimerEvent *>(&QCameraFocusControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCameraFocusControl::timerEvent(event);
    }
  }

  gsi::Callback cb_customFocusPoint_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusMode_c0_0;
  gsi::Callback cb_focusPointMode_c0_0;
  gsi::Callback cb_focusZones_c0_0;
  gsi::Callback cb_isFocusModeSupported_c3327_0;
  gsi::Callback cb_isFocusPointModeSupported_c3153_0;
  gsi::Callback cb_setCustomFocusPoint_1986_0;
  gsi::Callback cb_setFocusMode_3327_0;
  gsi::Callback cb_setFocusPointMode_3153_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraFocusControl_Adaptor::~QCameraFocusControl_Adaptor() { }

//  Constructor QCameraFocusControl::QCameraFocusControl() (adaptor class)

static void _init_ctor_QCameraFocusControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraFocusControl_Adaptor> ();
}

static void _call_ctor_QCameraFocusControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraFocusControl_Adaptor *> (new QCameraFocusControl_Adaptor ());
}


// void QCameraFocusControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraFocusControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// QPointF QCameraFocusControl::customFocusPoint()

static void _init_cbs_customFocusPoint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_cbs_customFocusPoint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QCameraFocusControl_Adaptor *)cls)->cbs_customFocusPoint_c0_0 ());
}

static void _set_callback_cbs_customFocusPoint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_customFocusPoint_c0_0 = cb;
}


// emitter void QCameraFocusControl::customFocusPointChanged(const QPointF &point)

static void _init_emitter_customFocusPointChanged_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customFocusPointChanged_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_customFocusPointChanged_1986 (arg1);
}


// emitter void QCameraFocusControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_destroyed_1302 (arg1);
}


// void QCameraFocusControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraFocusControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraFocusControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraFocusControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraFocusControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QFlags<QCameraFocus::FocusMode> QCameraFocusControl::focusMode()

static void _init_cbs_focusMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCameraFocus::FocusMode> > ();
}

static void _call_cbs_focusMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCameraFocus::FocusMode> > ((QFlags<QCameraFocus::FocusMode>)((QCameraFocusControl_Adaptor *)cls)->cbs_focusMode_c0_0 ());
}

static void _set_callback_cbs_focusMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_focusMode_c0_0 = cb;
}


// emitter void QCameraFocusControl::focusModeChanged(QFlags<QCameraFocus::FocusMode> mode)

static void _init_emitter_focusModeChanged_3327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraFocus::FocusMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusModeChanged_3327 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraFocus::FocusMode> arg1 = gsi::arg_reader<QFlags<QCameraFocus::FocusMode> >() (args, heap);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_focusModeChanged_3327 (arg1);
}


// QCameraFocus::FocusPointMode QCameraFocusControl::focusPointMode()

static void _init_cbs_focusPointMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type > ();
}

static void _call_cbs_focusPointMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type > ((qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type)((QCameraFocusControl_Adaptor *)cls)->cbs_focusPointMode_c0_0 ());
}

static void _set_callback_cbs_focusPointMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_focusPointMode_c0_0 = cb;
}


// emitter void QCameraFocusControl::focusPointModeChanged(QCameraFocus::FocusPointMode mode)

static void _init_emitter_focusPointModeChanged_3153 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusPointModeChanged_3153 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & >() (args, heap);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_focusPointModeChanged_3153 (arg1);
}


// QList<QCameraFocusZone> QCameraFocusControl::focusZones()

static void _init_cbs_focusZones_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QCameraFocusZone> > ();
}

static void _call_cbs_focusZones_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QCameraFocusZone> > ((QList<QCameraFocusZone>)((QCameraFocusControl_Adaptor *)cls)->cbs_focusZones_c0_0 ());
}

static void _set_callback_cbs_focusZones_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_focusZones_c0_0 = cb;
}


// emitter void QCameraFocusControl::focusZonesChanged()

static void _init_emitter_focusZonesChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_focusZonesChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_focusZonesChanged_0 ();
}


// bool QCameraFocusControl::isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode)

static void _init_cbs_isFocusModeSupported_c3327_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraFocus::FocusMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isFocusModeSupported_c3327_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraFocus::FocusMode> arg1 = args.read<QFlags<QCameraFocus::FocusMode> > (heap);
  ret.write<bool > ((bool)((QCameraFocusControl_Adaptor *)cls)->cbs_isFocusModeSupported_c3327_0 (arg1));
}

static void _set_callback_cbs_isFocusModeSupported_c3327_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_isFocusModeSupported_c3327_0 = cb;
}


// bool QCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode)

static void _init_cbs_isFocusPointModeSupported_c3153_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isFocusPointModeSupported_c3153_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraFocusControl_Adaptor *)cls)->cbs_isFocusPointModeSupported_c3153_0 (arg1));
}

static void _set_callback_cbs_isFocusPointModeSupported_c3153_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_isFocusPointModeSupported_c3153_0 = cb;
}


// exposed bool QCameraFocusControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraFocusControl_Adaptor *)cls)->fp_QCameraFocusControl_isSignalConnected_c2394 (arg1));
}


// emitter void QCameraFocusControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraFocusControl_Adaptor *)cls)->emitter_QCameraFocusControl_objectNameChanged_4567 (arg1);
}


// exposed int QCameraFocusControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraFocusControl_Adaptor *)cls)->fp_QCameraFocusControl_receivers_c1731 (arg1));
}


// exposed QObject *QCameraFocusControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraFocusControl_Adaptor *)cls)->fp_QCameraFocusControl_sender_c0 ());
}


// exposed int QCameraFocusControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraFocusControl_Adaptor *)cls)->fp_QCameraFocusControl_senderSignalIndex_c0 ());
}


// void QCameraFocusControl::setCustomFocusPoint(const QPointF &point)

static void _init_cbs_setCustomFocusPoint_1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCustomFocusPoint_1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_setCustomFocusPoint_1986_0 (arg1);
}

static void _set_callback_cbs_setCustomFocusPoint_1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_setCustomFocusPoint_1986_0 = cb;
}


// void QCameraFocusControl::setFocusMode(QFlags<QCameraFocus::FocusMode> mode)

static void _init_cbs_setFocusMode_3327_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCameraFocus::FocusMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFocusMode_3327_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCameraFocus::FocusMode> arg1 = args.read<QFlags<QCameraFocus::FocusMode> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_setFocusMode_3327_0 (arg1);
}

static void _set_callback_cbs_setFocusMode_3327_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_setFocusMode_3327_0 = cb;
}


// void QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)

static void _init_cbs_setFocusPointMode_3153_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFocusPointMode_3153_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraFocus::FocusPointMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_setFocusPointMode_3153_0 (arg1);
}

static void _set_callback_cbs_setFocusPointMode_3153_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_setFocusPointMode_3153_0 = cb;
}


// void QCameraFocusControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraFocusControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraFocusControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraFocusControl> &qtdecl_QCameraFocusControl ();

static gsi::Methods methods_QCameraFocusControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraFocusControl::QCameraFocusControl()\nThis method creates an object of class QCameraFocusControl.", &_init_ctor_QCameraFocusControl_Adaptor_0, &_call_ctor_QCameraFocusControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraFocusControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraFocusControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("customFocusPoint", "@brief Virtual method QPointF QCameraFocusControl::customFocusPoint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_customFocusPoint_c0_0, &_call_cbs_customFocusPoint_c0_0);
  methods += new qt_gsi::GenericMethod ("customFocusPoint", "@hide", true, &_init_cbs_customFocusPoint_c0_0, &_call_cbs_customFocusPoint_c0_0, &_set_callback_cbs_customFocusPoint_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_customFocusPointChanged", "@brief Emitter for signal void QCameraFocusControl::customFocusPointChanged(const QPointF &point)\nCall this method to emit this signal.", false, &_init_emitter_customFocusPointChanged_1986, &_call_emitter_customFocusPointChanged_1986);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraFocusControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraFocusControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraFocusControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraFocusControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("focusMode", "@brief Virtual method QFlags<QCameraFocus::FocusMode> QCameraFocusControl::focusMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusMode_c0_0, &_call_cbs_focusMode_c0_0);
  methods += new qt_gsi::GenericMethod ("focusMode", "@hide", true, &_init_cbs_focusMode_c0_0, &_call_cbs_focusMode_c0_0, &_set_callback_cbs_focusMode_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusModeChanged", "@brief Emitter for signal void QCameraFocusControl::focusModeChanged(QFlags<QCameraFocus::FocusMode> mode)\nCall this method to emit this signal.", false, &_init_emitter_focusModeChanged_3327, &_call_emitter_focusModeChanged_3327);
  methods += new qt_gsi::GenericMethod ("focusPointMode", "@brief Virtual method QCameraFocus::FocusPointMode QCameraFocusControl::focusPointMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusPointMode_c0_0, &_call_cbs_focusPointMode_c0_0);
  methods += new qt_gsi::GenericMethod ("focusPointMode", "@hide", true, &_init_cbs_focusPointMode_c0_0, &_call_cbs_focusPointMode_c0_0, &_set_callback_cbs_focusPointMode_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusPointModeChanged", "@brief Emitter for signal void QCameraFocusControl::focusPointModeChanged(QCameraFocus::FocusPointMode mode)\nCall this method to emit this signal.", false, &_init_emitter_focusPointModeChanged_3153, &_call_emitter_focusPointModeChanged_3153);
  methods += new qt_gsi::GenericMethod ("focusZones", "@brief Virtual method QList<QCameraFocusZone> QCameraFocusControl::focusZones()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusZones_c0_0, &_call_cbs_focusZones_c0_0);
  methods += new qt_gsi::GenericMethod ("focusZones", "@hide", true, &_init_cbs_focusZones_c0_0, &_call_cbs_focusZones_c0_0, &_set_callback_cbs_focusZones_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusZonesChanged", "@brief Emitter for signal void QCameraFocusControl::focusZonesChanged()\nCall this method to emit this signal.", false, &_init_emitter_focusZonesChanged_0, &_call_emitter_focusZonesChanged_0);
  methods += new qt_gsi::GenericMethod ("isFocusModeSupported", "@brief Virtual method bool QCameraFocusControl::isFocusModeSupported(QFlags<QCameraFocus::FocusMode> mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isFocusModeSupported_c3327_0, &_call_cbs_isFocusModeSupported_c3327_0);
  methods += new qt_gsi::GenericMethod ("isFocusModeSupported", "@hide", true, &_init_cbs_isFocusModeSupported_c3327_0, &_call_cbs_isFocusModeSupported_c3327_0, &_set_callback_cbs_isFocusModeSupported_c3327_0);
  methods += new qt_gsi::GenericMethod ("isFocusPointModeSupported", "@brief Virtual method bool QCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isFocusPointModeSupported_c3153_0, &_call_cbs_isFocusPointModeSupported_c3153_0);
  methods += new qt_gsi::GenericMethod ("isFocusPointModeSupported", "@hide", true, &_init_cbs_isFocusPointModeSupported_c3153_0, &_call_cbs_isFocusPointModeSupported_c3153_0, &_set_callback_cbs_isFocusPointModeSupported_c3153_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraFocusControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCameraFocusControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraFocusControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraFocusControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraFocusControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setCustomFocusPoint", "@brief Virtual method void QCameraFocusControl::setCustomFocusPoint(const QPointF &point)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCustomFocusPoint_1986_0, &_call_cbs_setCustomFocusPoint_1986_0);
  methods += new qt_gsi::GenericMethod ("setCustomFocusPoint", "@hide", false, &_init_cbs_setCustomFocusPoint_1986_0, &_call_cbs_setCustomFocusPoint_1986_0, &_set_callback_cbs_setCustomFocusPoint_1986_0);
  methods += new qt_gsi::GenericMethod ("setFocusMode", "@brief Virtual method void QCameraFocusControl::setFocusMode(QFlags<QCameraFocus::FocusMode> mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFocusMode_3327_0, &_call_cbs_setFocusMode_3327_0);
  methods += new qt_gsi::GenericMethod ("setFocusMode", "@hide", false, &_init_cbs_setFocusMode_3327_0, &_call_cbs_setFocusMode_3327_0, &_set_callback_cbs_setFocusMode_3327_0);
  methods += new qt_gsi::GenericMethod ("setFocusPointMode", "@brief Virtual method void QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFocusPointMode_3153_0, &_call_cbs_setFocusPointMode_3153_0);
  methods += new qt_gsi::GenericMethod ("setFocusPointMode", "@hide", false, &_init_cbs_setFocusPointMode_3153_0, &_call_cbs_setFocusPointMode_3153_0, &_set_callback_cbs_setFocusPointMode_3153_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraFocusControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraFocusControl_Adaptor> decl_QCameraFocusControl_Adaptor (qtdecl_QCameraFocusControl (), "QtMultimedia", "QCameraFocusControl",
  methods_QCameraFocusControl_Adaptor (),
  "@qt\n@brief Binding of QCameraFocusControl");

}

