/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright The KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


void NGSPICE_MODEL_INFO_MAP::addHSIM()
{
    modelInfos[MODEL_TYPE::HISIM2] = { "HiSIM2", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Hiroshima University STARC IGFET Model 2.8.0", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "info",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "information level (for debug, etc.)" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "noise",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "noise model selector" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "version",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "280", "280", "model version 280" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "show",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "show physical value" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "corsrd",  11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "solve equations accounting Rs and Rd." );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "corg_",  32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "solve equations accounting Rg." );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coiprv",  12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "use ids_prv as initial guess of Ids (internal flag)" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "copprv",  13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "use ps{0/l}_prv as initial guess of Ps{0/l} (internal flag)" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coadov",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "add overlap to intrisic" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coisub",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculate isub" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coiigs",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculate igate" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cogidl",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculate igidl" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coovlp",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "calculate overlap charge" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coflick",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "calculate 1/f noise" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coisti",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculate STI" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "conqs",  29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculate in nqs mode or qs mode" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cothrml",  30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "calculate thermal noise" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coign",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "calculate induced gate noise" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "codfm",  36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "calculation of model for DFM" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "corecip",  37, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "capacitance reciprocity takes first priority" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coqy",  38, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "calculate lateral-field-induced charge/capacitance" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coqovsm",  39, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "select smoothing method of Qover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coerrrep",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "selector for error report" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "codep",  45, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "selector for depletion device" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "coddlt",  40, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "selector for ddlt model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vmax",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "saturation velocity [cm/s]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "bgtmp1",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "9.025e-05", "9.025e-05", "first order temp. coeff. for band gap [V/K]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "bgtmp2",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1e-07", "1e-07", "second order temp. coeff. for band gap [V/K^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tox",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-09", "3e-09", "oxide thickness [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xld",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "lateral diffusion of S/D under the gate [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lover",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "overlap length" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xwd",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "lateral diffusion along the width dir. [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xl",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate length offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xw",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "saref",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sbref",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ll",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate length parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lld",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate length parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lln",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate length parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wl",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wl1",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wl1p",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wl2",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wl2p",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wld",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wln",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate width parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xqy",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "[m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xqy1",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[F m^{XQY2}]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xqy2",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "rs",  398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "source contact resistance [ohm m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "rd",  399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "drain contact resistance  [ohm m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "rsh",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "source/drain diffusion sheet  resistance  [ohm]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "rshg",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-elecrode sheet resistance" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vfbc",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "constant part of Vfb [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vbi",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.1", "1.1", "built-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubc",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "constant part of Nsub [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vfbcl",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-length dependence of VFBC [um]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vfbclp",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "gate-length dependence of VFBC [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "parl2",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "under diffusion [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lp",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "length of pocket potential [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubp",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+18", "1e+18", "[1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpl",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0.001", "0.001", "gate-length dependence of NSUBP" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpfac",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "gate-length dependence of NSUBP" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpdlt",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Delta for nsubp smoothing [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpw",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpwp",  183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "scp1",  184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for pocket [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "scp2",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for pocket [1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "scp3",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for pocket [m/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sc1",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for SCE [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sc2",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for SCE [1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sc3",  128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for SCE [m/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sc4",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for SCE [MODEL_TYPE::HISIM2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgd1",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgd2",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgd4",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate-poly depletion [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndep",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepl",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndeplp",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepw",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepwp",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ninv",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "coeff. of Qnm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ninvd",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "modification of Vdse dependence on Eeff [1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ninvdl",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "LG dependence of NINVD" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ninvdlp",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LG dependence of NINVD" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muecb0",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "const. part of coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muecb1",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "coeff. for coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mueph0",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "power of Eeff for phonon scattering [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muepwp",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muepwd",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muephl",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mueplp",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muepld",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesr0",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "power of Eeff for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesr1",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "coeff. for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesrl",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesrw",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mueswp",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mueslp",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muetmp",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "parameter for mobility [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "bb",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "1", "empirical mobility model coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sub1",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "parameter for Isub [1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sub2",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "25", "25", "parameter for Isub [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "svgs",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "coefficient for Vg of Psislsat" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "svbs",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "coefficient for Vbs of Psislsat" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsti",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "parameter for STI [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsti",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wstil",  227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wstilp",  231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wstiw",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wstiwp",  228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "scsti1",  229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "scsti2",  230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vthsti",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vdsti",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesti1",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesti2",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muesti3",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpsti1",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket impla parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpsti2",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket impla parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpsti3",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress pocket impla parameter" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcsti1",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress Parameter for Nsubc [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcsti2",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress Parameter for Nsubc [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcsti3",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress Parameter for Nsubc [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lpext",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-50", "1e-50", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "npext",  242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "npextw",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "new model parameter NPEXTW" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "npextwp",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "new model parameter NPEXTWP" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cgso_",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-S overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cgdo_",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-D overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cgbo_",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "G-B overlap capacitance per unit L [F/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tpoly",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "hight of poly gate [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "js0",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "5e-07", "5e-07", "Saturation current density [A/m^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "js0sw",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side wall saturation current density [A/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nj",  159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "njsw",  160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall emission coefficient" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xti",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Junction current temparature exponent coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cj",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Bottom junction capacitance per unit area at zero bias [F/m^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cjsw",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain sidewall junction capacitance grading coefficient per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cjswg",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain gate sidewall junction capacitance per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mj",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mjsw",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mjswg",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain gate sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pb",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bottom junction build-in potential  [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pbsw",  176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pbswg",  177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain gate sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbd",  92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbd" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbs",  93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbdsw",  94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbdsw" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbssw",  95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbssw" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbdswg",  96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbdswg" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tcjbsswg",  97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of czbsswg" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "xti2",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cisb",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "reverse bias saturation current [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cvb",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "bias dependence coefficient of cisb [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ctemp",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cisbk",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "reverse bias saturation current [A]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "cvbk",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "bias dependence coefficient of cisb [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "divx",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[1/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "clm1",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "clm2",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for CLM [1/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "clm3",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "clm5",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "clm6",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for CLM [um^{-clm5}]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vover",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "parameter for overshoot [m^{voverp}]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "voverp",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vovers",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "voversp",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wfc",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for narrow channel effect [m*F/(cm^2)]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcw",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcwp",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcmax",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+18", "5e+18", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "qme1",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for quantum effect [mV]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "qme2",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for quantum effect [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "qme3",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for quantum effect [m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl1",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl2",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl3",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl4",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl5",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl6",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gidl7",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for GIDL [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak1",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "parameter for gate current [A*V^(-3/2)/C]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak2",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "parameter for gate current [V^(-1/2)/m ]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak3",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.06", "0.06", "parameter for gate current [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak4",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "4", "4", "parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak5",  212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "7500", "7500", "parameter for gate current [V/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak6",  213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.25", "0.25", "parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "gleak7",  214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "parameter for gate current [m^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glksd1",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-15", "1e-15", "parameter for gate current [A*m/V^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glksd2",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e+06", "5e+06", "parameter for gate current [1/(V*m)]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glksd3",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "-5e+06", "-5e+06", "parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glkb1",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e-16", "5e-16", "parameter for gate current [A/V^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glkb2",  219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "parameter for gate current [m/V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "glkb3",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "egig",  220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "igtemp2",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate current [V*k]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "igtemp3",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for gate current [V*k^2]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vzadd0",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.02", "0.02", "Vzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pzadd0",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.02", "0.02", "Pzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "falph",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "parameter for 1/f noise" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "kappa",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "dielectric constant for high-k stacked gate" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vdiffj",  254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.0006", "0.0006", "threshold voltage for S/D junction diode [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "dly1",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "1e-10", "1e-10", "parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "dly2",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "dly3",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "8e-07", "8e-07", "parameter for trandforming bulk charge [s/F]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tnom",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "nominal temperature [K]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ibpc1",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for Impact-Ionization Induced Bulk Potential Change" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ibpc2",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for Impact-Ionization Induced Bulk Potential Change" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "mphdfm_",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.3", "-0.3", "NSUBCDFM dependence of phonon scattering for DFM" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "web",  88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Description for the model parameter WPE web" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wec",  89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Description for the model parameter WPE wec" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubcwpe",  91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Description for the model parameter WPE nsubcwpe" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "npextwpe",  41, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Description for the model parameter WPE npextwpe" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "nsubpwpe",  43, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Description for the model parameter WPE nsubpwpe" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgsmin",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-5", "5", "minimal/maximal expected Vgs (NMOS/PMOS) [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "sc3vbs",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vbs value for clamping sc3 [V]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "byptol",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "BYP_TOL_FACTOR for bypass control" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muecb0lp",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L dependence of MUECB0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "muecb1lp",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L dependence of MUECB1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepm",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+17", "1e+17", "N- layer concentlation of the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepml",  610, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L dependence of NDEPM" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ndepmlp",  611, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "L dependence of NDEPM" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "tndep",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "N- layer depth of the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depleak",  608, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "leakage current modification parameter for the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depleakl",  614, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "L dependence of DEPLEAK" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depleaklp",  615, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "L dependence of DEPLEAK" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depeta",  609, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of threshold voltage for the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue0",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue0l",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue0lp",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue1",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue1l",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmue1lp",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback0",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback0l",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback0lp",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback1",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback1l",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueback1lp",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueph0",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmueph1",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5000", "5000", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvmax",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvmaxl",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvmaxlp",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef1",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef1l",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef1lp",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef2",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef2l",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depvdsef2lp",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depbb",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "depmuetmp",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "[-]" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmin",  1000, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmax",  1001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmin",  1002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmax",  1003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lbinn",  1004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "L modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wbinn",  1005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "W modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvmax",  1100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lbgtmp1",  1101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lbgtmp2",  1102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "leg0",  1103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "llover",  1106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvfbover",  1428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnover",  1430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lwl2",  1407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvfbc",  1121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubc",  1123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubp",  1181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lscp1",  1184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lscp2",  1185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lscp3",  1186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsc1",  1126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsc2",  1127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsc3",  1128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsc4",  1270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc4" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lpgd1",  1187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lndep",  1129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lninv",  1130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuecb0",  1131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuecb1",  1132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmueph1",  1133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvtmp",  1141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lwvth0",  1142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuesr1",  1143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuetmp",  1195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsub1",  1151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsub2",  1152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsvds",  1286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svds" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsvbs",  1284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lsvgs",  1283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsti",  1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lwsti",  1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lscsti1",  1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lscsti2",  1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvthsti",  1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuesti1",  1235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuesti2",  1236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lmuesti3",  1237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubpsti1",  1238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubpsti2",  1239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubpsti3",  1240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubcsti1",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubcsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubcsti2",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubcsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnsubcsti3",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubcsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lcgso",  1154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lcgdo",  1155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ljs0",  1157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ljs0sw",  1158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnj",  1159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lcisbk",  1172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lclm1",  1191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lclm2",  1192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lclm3",  1193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lwfc",  1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgidl1",  1205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgidl2",  1206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgleak1",  1208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgleak2",  1209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgleak3",  1210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lgleak6",  1213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lglksd1",  1215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lglksd2",  1216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lglkb1",  1218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lglkb2",  1219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnftrp",  1258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lnfalp",  1259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "lvdiffj",  1254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "libpc1",  1404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "libpc2",  1405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvmax",  2100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wbgtmp1",  2101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wbgtmp2",  2102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "weg0",  2103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wlover",  2106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvfbover",  2428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnover",  2430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wwl2",  2407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvfbc",  2121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubc",  2123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubp",  2181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wscp1",  2184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wscp2",  2185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wscp3",  2186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsc1",  2126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsc2",  2127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsc3",  2128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsc4",  2270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc4" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wpgd1",  2187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wndep",  2129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wninv",  2130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuecb0",  2131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuecb1",  2132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmueph1",  2133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvtmp",  2141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wwvth0",  2142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuesr1",  2143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuetmp",  2195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsub1",  2151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsub2",  2152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsvds",  2286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svds" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsvbs",  2284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wsvgs",  2283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsti",  2225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wwsti",  2226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wscsti1",  2229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wscsti2",  2230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvthsti",  2232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuesti1",  2235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuesti2",  2236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wmuesti3",  2237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubpsti1",  2238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubpsti2",  2239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubpsti3",  2240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubcsti1",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of nsubcsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubcsti2",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of nsubcsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnsubcsti3",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of nsubcsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wcgso",  2154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wcgdo",  2155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wjs0",  2157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wjs0sw",  2158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnj",  2159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wcisbk",  2172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wclm1",  2191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wclm2",  2192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wclm3",  2193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wwfc",  2201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgidl1",  2205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgidl2",  2206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgleak1",  2208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgleak2",  2209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgleak3",  2210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wgleak6",  2213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wglksd1",  2215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wglksd2",  2216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wglkb1",  2218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wglkb2",  2219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnftrp",  2258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wnfalp",  2259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wvdiffj",  2254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wibpc1",  2404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "wibpc2",  2405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvmax",  3100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pbgtmp1",  3101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pbgtmp2",  3102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "peg0",  3103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "plover",  3106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvfbover",  3428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnover",  3430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nover" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pwl2",  3407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvfbc",  3121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubc",  3123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubp",  3181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pscp1",  3184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pscp2",  3185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pscp3",  3186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psc1",  3126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psc2",  3127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psc3",  3128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psc4",  3270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc4" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "ppgd1",  3187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pndep",  3129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pninv",  3130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuecb0",  3131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuecb1",  3132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmueph1",  3133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvtmp",  3141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pwvth0",  3142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuesr1",  3143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuetmp",  3195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psub1",  3151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psub2",  3152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psvds",  3286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svds" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psvbs",  3284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "psvgs",  3283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsti",  3225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pwsti",  3226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pscsti1",  3229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pscsti2",  3230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvthsti",  3232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuesti1",  3235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuesti2",  3236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pmuesti3",  3237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubpsti1",  3238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubpsti2",  3239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubpsti3",  3240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubcsti1",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubcsti1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubcsti2",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubcsti2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnsubcsti3",  271, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubcsti3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pcgso",  3154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pcgdo",  3155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pjs0",  3157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pjs0sw",  3158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnj",  3159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pcisbk",  3172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pclm1",  3191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pclm2",  3192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pclm3",  3193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pwfc",  3201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgidl1",  3205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgidl2",  3206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgleak1",  3208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgleak2",  3209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgleak3",  3210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pgleak6",  3213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pglksd1",  3215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pglksd2",  3216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pglkb1",  3218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pglkb2",  3219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnftrp",  3258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pnfalp",  3259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pvdiffj",  3254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pibpc1",  3404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "pibpc2",  3405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgs_max",  4001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgd_max",  4002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgb_max",  4003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vds_max",  4004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vbs_max",  4005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vbd_max",  4006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgsr_max",  4007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgdr_max",  4008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vgbr_max",  4009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vbsr_max",  4010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIM2].modelParams.emplace_back( "vbdr_max",  4011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    // Instance parameters
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "m",  83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplication factor [-]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "l",  51, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "w",  52, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ad",  53, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "as",  54, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "pd",  55, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ps",  56, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "nrd",  57, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "nrs",  58, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "temp",  59, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::PRINCIPAL, "", "", "Lattice temperature [K]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "off",  61, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ic",  65, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "corbnet",  66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "activate body resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "corg",  72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "activate gate resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ngcon",  74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "number of gate contacts", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "xgw",  75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "distance from gate contact to channel edge", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "xgl",  76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "offset of gate length due to variation in patterning", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "nf",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "number of fingers", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "sa",  78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "sb",  79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "sd",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "distance from Gate edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "nsubcdfm",  82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "constant part of Nsub for DFM [1/cm^3]", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "mphdfm",  84, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "-0.3", "-0.3", "NSUBCDFM dependence of phonon scattering for DFM", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "sca",  85, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "WPE sca", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "scb",  86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "WPE scb", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "scc",  87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "WPE scc", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ids",  351, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "isub",  410, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "igidl",  411, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "igisl",  412, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "igd",  413, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "igs",  414, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "igb",  415, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "gm",  354, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "gds",  355, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "gmbs",  356, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmbs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "von",  376, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Von", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "vdsat",  377, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "qb",  359, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qb", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "qg",  361, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qg", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "qd",  363, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgg",  365, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgg", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgd",  366, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgs",  367, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cbg",  368, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbg", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cbs",  383, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cbd",  382, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cdg",  373, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdg", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cdd",  374, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cds",  375, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cds", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgdo",  418, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgdo", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgso",  416, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgso", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "cgbo",  417, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgbo", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ibd",  353, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "ibs",  352, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "gbd",  357, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "gbs",  358, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbs", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "capbd",  369, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::HISIM2].instanceParams.emplace_back( "capbs",  371, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );


    modelInfos[MODEL_TYPE::HISIMHV1] = { "HiSIMHV1", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Hiroshima University STARC IGFET Model - HiSIM_HV v.1", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nmos", 1, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmos", 2, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "level", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "73", "73", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "info", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Information level (for debug, etc.)" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "noise", 5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "version", 6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.24", "1.24", "Model version" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "show", 7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Show physical value" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "corsrd", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3", "3", "Handling of Rs and Rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "corg_", 32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Activate gate resistance (1) or not (0)" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coiprv", 12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Use ids_prv as initial guess of Ids (internal flag)" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "copprv", 13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Use ps{0/l}_prv as initial guess of Ps{0/l} (internal flag)" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coadov", 17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Add overlap to intrisic" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coisub", 21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate isub" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coiigs", 22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate igate" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cogidl", 23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate igidl" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coovlp", 24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Calculate overlap charge on the drain side" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coovlps", 8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate overlap charge on the source side" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coflick", 25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate 1/f noise" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coisti", 26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate STI" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "conqs", 29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate in nqs mode or qs mode" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "corbnet_", 33, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cothrml", 30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate thermal noise" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coign", 31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate induced gate noise" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "codfm", 36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculation of model for DFM" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coqovsm", 34, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "select smoothing method of Qover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coselfheat_", 35, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculation of self heating model" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cosubnode_", 48, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Switch tempNode to subNode" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cosym", 37, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model selector for symmetry device" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cotemp", 38, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Model flag for temperature dependence" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "coldrift", 39, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "selector for Ldrift parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbsmin", 198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-10.5", "-10.5", "Minimum back bias voltage to be treated in hsmhveval [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vmax", 500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Saturation velocity [cm/s]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vmaxt1", 503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity coeff. [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vmaxt2", 504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity coeff. [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "bgtmp1", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "9.025e-05", "9.025e-05", "First order temp. coeff. for band gap [V/K]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "bgtmp2", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1e-07", "1e-07", "Second order temp. coeff. for band gap [V/K^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "eg0", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.1785", "1.1785", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tox", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "Oxide thickness [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xld", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion of S/D under the gate [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xldld", 439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Lateral diffusion of Drain under the gate [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xwdld", 494, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lover_", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Overlap length on source side [m], alias for lovers" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lovers_", 385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "Overlap length on source side [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdov11", 313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdov12", 314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdov13", 476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdslp1", 315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LDRIFT1 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdict1", 316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LDRIFT1 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdslp2", 317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LDRIFT2 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdict2", 318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "LDRIFT2 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "loverld_", 436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Overlap length on the drain side" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ldrift1_", 319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-1 on the drain side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ldrift2_", 320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-2 on the drain side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ldrift1s_", 324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drift region length-1 on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ldrift2s_", 325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-2 on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "subld1_", 321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "subld2_", 322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [m^{-1}*V^{3/2}]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ddltmax", 421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ddltslp", 422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ddltict", 423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vfbover", 428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.5", "-0.5", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nover", 430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+16", "3e+16", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "novers", 431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xwd", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion along the width dir. [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xwdc", 513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion along the width dir. for capacitance [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xl", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xw", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "saref", 433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sbref", 434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ll", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lld", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lln", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wl", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wl1", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wl1p", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wl2", 407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wl2p", 408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wld", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wln", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xqy", 178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xqy1", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[F m^{XQY2}]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xqy2", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rs", 398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source contact resistance [ohm m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd", 399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "Drain contact resistance  [ohm m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rsh", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/drain diffusion sheet  resistance  [ohm]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rshg", 384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-elecrode sheet resistance" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vfbc", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Constant part of Vfb [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbi", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.1", "1.1", "Built-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubc", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "Constant part of Nsub [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "parl2", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Under diffusion [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lp", 180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length of pocket potential [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubp", 181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+18", "1e+18", "[1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubp0", 182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubwp", 183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scp1", 184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for pocket [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scp2", 185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for pocket [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scp3", 186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for pocket [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sc1", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for SCE [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sc2", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sc3", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sc4", 248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgd1", 187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgd2", 188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgd3", 189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Parameter for gate-poly depletion [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgd4", 190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate-poly depletion [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ndep", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ndepl", 419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ndeplp", 420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninv", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Coeff. of Qnm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninvd", 505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Modification of Vdse dependence on Eeff [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninvdw", 506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninvdwp", 507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninvdt1", 508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ninvdt2", 509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muecb0", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "Const. part of coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muecb1", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Coeff. for coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mueph0", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Power of Eeff for phonon scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mueph1", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "25000", "9000", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muephw", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muepwp", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muephl", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mueplp", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muephs", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muepsp", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vtmp", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvth0", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesr0", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Power of Eeff for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesr1", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+16", "1e+16", "Coeff. for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesrl", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesrw", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mueswp", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mueslp", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muetmp", 195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "Parameter for mobility [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "bb", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "1", "Empirical mobility model coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sub1", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Parameter for Isub [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sub2", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "25", "25", "Parameter for Isub [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svgs", 283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Coefficient for Vg of Psislsat" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svbs", 284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Coefficient for Vbs of Psislsat" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svbsl", 285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svds", 286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "slg", 287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sub1l", 290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0025", "0.0025", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sub2l", 292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "fn1", 294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "fn2", 295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00017", "0.00017", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "fn3", 296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "fvbs", 297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.012", "0.012", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svgsl", 305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svgslp", 306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svgswp", 307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svgsw", 308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "svbslp", 309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "slgl", 310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "slglp", 311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "sub1lp", 312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsti", 225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+17", "1e+17", "Parameter for STI [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsti", 226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wstil", 227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wstilp", 231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wstiw", 234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wstiwp", 228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scsti1", 229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scsti2", 230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vthsti", 232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vdsti", 233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesti1", 235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesti2", 236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "muesti3", 237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubpsti1", 238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubpsti2", 239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubpsti3", 240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lpext", 241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-50", "1e-50", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "npext", 242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+17", "1e+17", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scp22", 243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "scp21", 244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "bs1", 245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "bs2", 246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cgso_", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-S overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cgdo_", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-D overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cgbo_", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-B overlap capacitance per unit L [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tpoly", 179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "Height of poly gate on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "js0", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "5e-07", "5e-07", "Saturation current density [A/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "js0sw", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side wall saturation current density [A/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nj", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "njsw", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall emission coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xti", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Junction current temparature exponent coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cj", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.0005", "0.0005", "Bottom junction capacitance per unit area at zero bias [F/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cjsw", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Source/drain sidewall junction capacitance grading coefficient per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cjswg", 164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Source/drain gate sidewall junction capacitance per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mj", 165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mjsw", 166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Source/drain sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mjswg", 167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Source/drain gate sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pb", 175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bottom junction build-in potential  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pbsw", 176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pbswg", 177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain gate sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "xti2", 168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cisb", 169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cvb", 170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias dependence coefficient of cisb [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ctemp", 171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cisbk", 172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current [A]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cvbk", 173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias dependence coefficient of cisb [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "divx", 174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "clm1", 191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "clm2", 192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Parameter for CLM [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "clm3", 193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "clm5", 402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "clm6", 403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for CLM [um^{-clm5}]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vover", 199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Parameter for overshoot [m^{voverp}]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "voverp", 200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vovers", 303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "voversp", 304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfc", 201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for narrow channel effect [m*F/(cm^2)]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubcw", 249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubcwp", 250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "qme1", 202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for quantum effect [mV]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "qme2", 203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for quantum effect [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "qme3", 204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for quantum effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gidl1", 205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gidl2", 206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gidl3", 207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gidl4", 281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gidl5", 282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glpart1", 406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for gate current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak1", 208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Parameter for gate current [A*V^(-3/2)/C]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak2", 209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Parameter for gate current [V^(-1/2)/m ]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak3", 210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.06", "0.06", "Parameter for gate current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak4", 211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "4", "4", "Parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak5", 212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "7500", "7500", "Parameter for gate current [V/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak6", 213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.25", "0.25", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gleak7", 214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Parameter for gate current [m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glksd1", 215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-15", "1e-15", "Parameter for gate current [A*m/V^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glksd2", 216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e+06", "5e+06", "Parameter for gate current [1/(V*m)]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glksd3", 217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "-5e+06", "-5e+06", "Parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glkb1", 218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e-16", "5e-16", "Parameter for gate current [A/V^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glkb2", 219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for gate current [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "glkb3", 429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "egig", 220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "igtemp2", 221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V*k]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "igtemp3", 222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V*k^2]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vzadd0", 223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Vzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pzadd0", 224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "Pzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nftrp", 258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+10", "1e+10", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nfalp", 259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-19", "1e-19", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cit", 260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "falph", 263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Parameter for 1/f noise" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "kappa", 251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant for high-k stacked gate" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pthrou", 253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Modify subthreshold slope [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vdiffj", 254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.0006", "0.0006", "Threshold voltage for S/D junction diode [V]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "dly1", 255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "1e-10", "1e-10", "Parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "dly2", 256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "Parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "dly3", 257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "8e-07", "8e-07", "Parameter for transforming bulk charge [s/F]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "dlyov", 437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for transforming overlap charge [s/F]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tnom", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Nominal temperature [K]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ovslp", 261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.1e-07", "2.1e-07", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ovmag", 262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "gbmin", 394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rbpb_", 389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rbpd_", 390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rbps_", 391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rbdb_", 392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rbsb_", 393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ibpc1", 404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ibpc2", 405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "mphdfm", 409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.3", "-0.3", "NSUBCDFM dependence of phonon scattering for DFM" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvg11", 424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvg12", 425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rth0", 432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.1", "0.1", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cth0", 462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Thermal capacitance" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "powrat", 463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rthtemp1", 490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rthtemp2", 491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prattemp1", 492, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prattemp2", 493, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbd", 92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbs", 93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbdsw", 94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbdsw" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbssw", 95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbssw" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbdswg", 96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbdswg" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "tcjbsswg", 97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbsswg" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "qdftvd", 438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Qdrift Vd dependence" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvd", 510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.07", "0.07", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvb", 301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd20", 447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd21", 441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd22", 442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd22d", 478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd23", 443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd24", 444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd25", 445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd26", 446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "alias for qovsm" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdl", 448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdlp", 449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvds", 450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdsp", 451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd23l", 452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd23lp", 453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd23s", 454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rd23sp", 455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rds", 456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdsp", 457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "qovsm", 323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Smoothing Qover at depletion/inversion transition" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ldrift", 458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "alias for ldrift2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdtemp1", 461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of Rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdtemp2", 464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of Rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rth0r", 470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Heat radiation for SHE" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdtemp1", 471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of RDVD" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdtemp2", 472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of RDVD" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rth0w", 473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rth0wp", 474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rth0nf", 475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "nf-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "cvdsover", 480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "vds drop along the overlap" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvsub", 481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "rdvdsub", 482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ddrift", 483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbisub", 484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "nsubsub", 485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "shemax", 100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "500", "500", "Maximum rise temperatue for SHE [C]" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmin", 1000, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmax", 1001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmin", 1002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmax", 1003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lbinn", 1004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "L modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wbinn", 1005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "W modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvmax", 1100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lbgtmp1", 1101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lbgtmp2", 1102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "leg0", 1103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvfbover", 1428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnover", 1430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnovers", 1431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nover on source size" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lwl2", 1407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvfbc", 1121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsubc", 1123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsubp", 1181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lscp1", 1184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lscp2", 1185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lscp3", 1186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsc1", 1126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsc2", 1127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsc3", 1128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lpgd1", 1187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lpgd3", 1189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pgd3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lndep", 1129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lninv", 1130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuecb0", 1131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuecb1", 1132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmueph1", 1133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvtmp", 1141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lwvth0", 1142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuesr1", 1143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuetmp", 1195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsub1", 1151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsub2", 1152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsvds", 1286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsvbs", 1284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lsvgs", 1283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lfn1", 1294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lfn2", 1295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lfn3", 1296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lfvbs", 1297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsti", 1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lwsti", 1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lscsti1", 1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lscsti2", 1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvthsti", 1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuesti1", 1235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuesti2", 1236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lmuesti3", 1237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsubpsti1", 1238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsubpsti2", 1239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnsubpsti3", 1240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lcgso", 1154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lcgdo", 1155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ljs0", 1157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ljs0sw", 1158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnj", 1159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lcisbk", 1172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lclm1", 1191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lclm2", 1192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lclm3", 1193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lwfc", 1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgidl1", 1205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgidl2", 1206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgleak1", 1208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgleak2", 1209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgleak3", 1210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lgleak6", 1213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lglksd1", 1215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lglksd2", 1216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lglkb1", 1218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lglkb2", 1219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnftrp", 1258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnfalp", 1259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lpthrou", 1253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pthrou" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvdiffj", 1254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "libpc1", 1404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "libpc2", 1405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lcgbo", 1156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lcvdsover", 1480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lfalph", 1263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lnpext", 1242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lpowrat", 1463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrd", 1399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrd22", 1442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrd23", 1443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrd24", 1444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdict1", 1316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdov13", 1476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdslp1", 1315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdvb", 1301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdvd", 1510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrdvg11", 1424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrs", 1398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lrth0", 1432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "lvover", 1199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvmax", 2100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wbgtmp1", 2101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wbgtmp2", 2102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "weg0", 2103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvfbover", 2428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnover", 2430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnovers", 2431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of novers on source size" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wwl2", 2407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvfbc", 2121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsubc", 2123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsubp", 2181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wscp1", 2184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wscp2", 2185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wscp3", 2186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsc1", 2126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsc2", 2127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsc3", 2128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wpgd1", 2187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wpgd3", 2189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pgd3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wndep", 2129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wninv", 2130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuecb0", 2131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuecb1", 2132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmueph1", 2133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvtmp", 2141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wwvth0", 2142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuesr1", 2143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuetmp", 2195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsub1", 2151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsub2", 2152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsvds", 2286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsvbs", 2284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wsvgs", 2283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfn1", 2294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfn2", 2295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfn3", 2296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfvbs", 2297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsti", 2225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wwsti", 2226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wscsti1", 2229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wscsti2", 2230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvthsti", 2232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuesti1", 2235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuesti2", 2236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wmuesti3", 2237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsubpsti1", 2238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsubpsti2", 2239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnsubpsti3", 2240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wcgso", 2154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wcgdo", 2155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wjs0", 2157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wjs0sw", 2158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnj", 2159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wcisbk", 2172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wclm1", 2191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wclm2", 2192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wclm3", 2193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wwfc", 2201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgidl1", 2205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgidl2", 2206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgleak1", 2208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgleak2", 2209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgleak3", 2210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wgleak6", 2213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wglksd1", 2215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wglksd2", 2216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wglkb1", 2218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wglkb2", 2219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnftrp", 2258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnfalp", 2259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wpthrou", 2253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pthrou" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvdiffj", 2254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wibpc1", 2404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wibpc2", 2405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wcgbo", 2156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wcvdsover", 2480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wfalph", 2263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wnpext", 2242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wpowrat", 2463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrd", 2399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrd22", 2442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrd23", 2443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrd24", 2444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdict1", 2316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdov13", 2476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdslp1", 2315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdvb", 2301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdvd", 2510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrdvg11", 2424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrs", 2398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wrth0", 2432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "wvover", 2199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvmax", 3100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pbgtmp1", 3101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pbgtmp2", 3102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "peg0", 3103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvfbover", 3428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnover", 3430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnovers", 3431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nover on source size" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pwl2", 3407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvfbc", 3121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsubc", 3123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsubp", 3181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pscp1", 3184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pscp2", 3185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pscp3", 3186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psc1", 3126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psc2", 3127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psc3", 3128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ppgd1", 3187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ppgd3", 3189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pgd3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pndep", 3129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pninv", 3130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuecb0", 3131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuecb1", 3132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmueph1", 3133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvtmp", 3141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pwvth0", 3142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuesr1", 3143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuetmp", 3195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psub1", 3151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psub2", 3152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psvds", 3286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psvbs", 3284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "psvgs", 3283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pfn1", 3294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pfn2", 3295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pfn3", 3296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pfvbs", 3297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsti", 3225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pwsti", 3226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pscsti1", 3229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pscsti2", 3230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvthsti", 3232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuesti1", 3235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuesti2", 3236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pmuesti3", 3237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsubpsti1", 3238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsubpsti2", 3239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnsubpsti3", 3240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pcgso", 3154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pcgdo", 3155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pjs0", 3157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pjs0sw", 3158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnj", 3159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pcisbk", 3172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pclm1", 3191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pclm2", 3192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pclm3", 3193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pwfc", 3201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgidl1", 3205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgidl2", 3206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgleak1", 3208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgleak2", 3209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgleak3", 3210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pgleak6", 3213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pglksd1", 3215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pglksd2", 3216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pglkb1", 3218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pglkb2", 3219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnftrp", 3258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnfalp", 3259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ppthrou", 3253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pthrou" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvdiffj", 3254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pibpc1", 3404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pibpc2", 3405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pcgbo", 3156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pcvdsover", 3480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pfalph", 3263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pnpext", 3242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "ppowrat", 3463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prd", 3399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prd22", 3442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prd23", 3443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prd24", 3444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdict1", 3316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdov13", 3476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdslp1", 3315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdvb", 3301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdvd", 3510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prdvg11", 3424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prs", 3398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "prth0", 3432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "pvover", 3199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgs_max", 4001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgd_max", 4002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgb_max", 4003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vds_max", 4004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbs_max", 4005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbd_max", 4006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgsr_max", 4007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgdr_max", 4008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vgbr_max", 4009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbsr_max", 4010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV1].modelParams.emplace_back( "vbdr_max", 4011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    // Instance parameters
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "coselfheat", 49, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Calculation of self heating model", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cosubnode", 50, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Switch tempNode to subNode", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "m", 83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplication factor [-]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "l", 51, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "w", 52, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ad", 53, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "as", 54, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "pd", 55, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ps", 56, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "nrd", 57, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "nrs", 58, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "dtemp", 60, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "off", 61, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ic", 65, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "corbnet", 66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Activate body resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "rbpb", 67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "rbpd", 68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "rbps", 69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "rbdb", 70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "rbsb", 71, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "corg", 72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Activate gate resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ngcon", 74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate contacts", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "xgw", 75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from gate contact to channel edge", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "xgl", 76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Offset of gate length due to variation in patterning", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "nf", 77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of fingers", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "sa", 78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "sb", 79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "sd", 80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from Gate edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "nsubcdfm", 82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Constant part of Nsub for DFM [1/cm^3]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "subld1", 86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for impact-ionization current in the drift region [-]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "subld2", 87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for impact-ionization current in the drift region [m^{-1}*V^{3/2}]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "lover", 41, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Overlap length on source side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "lovers", 42, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "3e-08", "3e-08", "Overlap length on source side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "loverld", 43, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Overlap length on drain side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ldrift1", 88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-1 [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ldrift2", 89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-2 [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ldrift1s", 90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for drift region length-1 on source side[m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ldrift2s", 91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-2 on source side[m]", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ids", 351, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "isub", 410, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "igidl", 411, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "igisl", 412, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "igd", 413, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "igs", 414, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "igb", 415, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gm", 354, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gds", 355, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gmbs", 356, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmbs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gmt", 465, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "GmT", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "von", 376, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Von", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "vdsat", 377, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "qb", 359, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qb", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "qg", 361, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qg", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "qd", 363, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgg", 365, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgg", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgd", 366, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgs", 367, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cbg", 368, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbg", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cbs", 383, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cbd", 382, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cdg", 373, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdg", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cdd", 374, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cds", 375, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cds", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgdo", 418, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgdo", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgso", 416, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgso", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "cgbo", 417, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgbo", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ibd", 353, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "ibs", 352, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gbd", 357, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "gbs", 358, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbs", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "capbd", 369, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::HISIMHV1].instanceParams.emplace_back( "capbs", 371, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );


    modelInfos[MODEL_TYPE::HISIMHV2] = { "HiSIMHV2", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Hiroshima University STARC IGFET Model - HiSIM_HV v.2", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nmos", 1, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmos", 2, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "level", 3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "73", "73", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "info", 4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Information level (for debug, etc.)" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "noise", 5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "version", 6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2.0", "2.2.0", "Model version" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "show", 7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Show physical value" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "corsrd", 11, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Handling of Rs and Rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "corg_", 32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Activate gate resistance (1) or not (0)" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coiprv", 12, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Use ids_prv as initial guess of Ids (internal flag)" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "copprv", 13, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Use ps{0/l}_prv as initial guess of Ps{0/l} (internal flag)" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coadov", 17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Add overlap to intrisic" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coisub", 21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate isub" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coiigs", 22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate igate" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cogidl", 23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate igidl" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coovlp", 24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Calculate overlap charge on the drain side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coovlps", 8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate overlap charge on the source side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coflick", 25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate 1/f noise" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coisti", 26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate STI" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "conqs", 29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculate in nqs mode or qs mode" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "corbnet_", 33, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cothrml", 30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate thermal noise" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coign", 31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Calculate induced gate noise" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "codfm", 36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculation of model for DFM" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coqovsm", 34, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "select smoothing method of Qover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coselfheat_", 35, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Calculation of self heating model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cosubnode_", 48, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Switch tempNode to subNode" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cosym", 37, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model selector for symmetry device" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cotemp", 38, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Model flag for temperature dependence" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coldrift", 39, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "selector for Ldrift parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cordrift", 40, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coerrrep", 44, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "selector for error report" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "codep", 45, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "selector for depletion device" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "coddlt", 46, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "selector for DDLT model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbsmin", 198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-10.5", "-10.5", "Minimum back bias voltage to be treated in hsmhveval [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vmax", 500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Saturation velocity [cm/s]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vmaxt1", 503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity coeff. [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vmaxt2", 504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity coeff. [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "bgtmp1", 101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "9.025e-05", "9.025e-05", "First order temp. coeff. for band gap [V/K]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "bgtmp2", 102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1e-07", "1e-07", "Second order temp. coeff. for band gap [V/K^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "eg0", 103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.1785", "1.1785", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tox", 104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "7e-09", "7e-09", "Oxide thickness [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xld", 105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion of S/D under the gate [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xldld", 439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Lateral diffusion of Drain under the gate [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xwdld", 494, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lover_", 106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "Overlap length on source side [m], alias for lovers" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lovers_", 385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "Overlap length on source side [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdov11", 313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdov12", 314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdov13", 476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Dependence coeff. for overlap length" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdslp1", 315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "LDRIFT1 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdict1", 316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LDRIFT1 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdslp2", 317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "LDRIFT2 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdict2", 318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "LDRIFT2 dependence of resistance for CORSRD=1,3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "loverld_", 436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Overlap length on the drain side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ldrift1_", 319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-1 on the drain side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ldrift2_", 320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-2 on the drain side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ldrift1s_", 324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drift region length-1 on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ldrift2s_", 325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Drift region length-2 on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "subld1_", 321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "subld1l", 329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [um^{subld1lp}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "subld1lp", 330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Impact-ionization current in the drift region [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "subld2_", 322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [m^{-1}*V^{3/2}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xpdv", 326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [m^{-1}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xpvdth", 327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xpvdthg", 328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact-ionization current in the drift region [V^{-1}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ddltmax", 421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ddltslp", 422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ddltict", 423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vfbover", 428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.5", "-0.5", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nover", 430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+16", "3e+16", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "novers", 431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+17", "1e+17", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xwd", 107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion along the width dir. [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xwdc", 513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral diffusion along the width dir. for capacitance [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xl", 112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xw", 117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width offset due to mask/etch effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "saref", 433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sbref", 434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance from STI edge to Gate edge [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ll", 108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lld", 109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lln", 110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate length parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wl", 111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wl1", 113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wl1p", 114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wl2", 407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wl2p", 408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wld", 115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wln", 116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate width parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xqy", 178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xqy1", 118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[F m^{XQY2}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xqy2", 120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "[-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rs", 398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source contact resistance [ohm m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd", 399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain contact resistance  [ohm m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rsh", 119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source/drain diffusion sheet  resistance  [ohm]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rshg", 384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-elecrode sheet resistance" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vfbc", 121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Constant part of Vfb [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbi", 122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.1", "1.1", "Built-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubc", 123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+17", "3e+17", "Constant part of Nsub [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "parl2", 125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Under diffusion [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lp", 180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "Length of pocket potential [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubp", 181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+18", "1e+18", "[1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubp0", 182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubwp", 183, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scp1", 184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for pocket [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scp2", 185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for pocket [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scp3", 186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for pocket [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sc1", 126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sc2", 127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sc3", 128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sc4", 248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for SCE [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgd1", 187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgd2", 188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for gate-poly depletion [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgd4", 190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate-poly depletion [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ndep", 129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ndepl", 419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ndeplp", 420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff. of Qbm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninv", 130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Coeff. of Qnm for Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninvd", 505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Modification of Vdse dependence on Eeff [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninvdw", 506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninvdwp", 507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninvdt1", 508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ninvdt2", 509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coeff of modification of Vdse dependence on Eeff [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muecb0", 131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "Const. part of coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muecb1", 132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Coeff. for coulomb scattering [cm^2/Vs]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mueph0", 134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Power of Eeff for phonon scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mueph1", 133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "20000", "9000", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muephw", 135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muepwp", 136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muephl", 137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mueplp", 138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Phonon scattering parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muephs", 139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muepsp", 140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vtmp", 141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvth0", 142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesr0", 144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Power of Eeff for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesr1", 143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "6e+14", "6e+14", "Coeff. for S.R. scattering [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesrl", 145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesrw", 147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mueswp", 148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Change of surface roughness related mobility" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mueslp", 146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Surface roughness parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muetmp", 195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "1.5", "Parameter for mobility [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "bb", 149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "1", "Empirical mobility model coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sub1", 151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Parameter for Isub [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sub2", 152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "25", "25", "Parameter for Isub [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svgs", 283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "Coefficient for Vg of Psislsat" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svbs", 284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Coefficient for Vbs of Psislsat" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svbsl", 285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svds", 286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.8", "0.8", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "slg", 287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e-08", "3e-08", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sub1l", 290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0025", "0.0025", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sub2l", 292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "fn1", 294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "fn2", 295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.00017", "0.00017", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "fn3", 296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "fvbs", 297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.012", "0.012", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svgsl", 305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svgslp", 306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svgswp", 307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svgsw", 308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "svbslp", 309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "slgl", 310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "slglp", 311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "sub1lp", 312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsti", 225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "Parameter for STI [1/cm^3]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsti", 226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wstil", 227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wstilp", 231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wstiw", 234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wstiwp", 228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for STI [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scsti1", 229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scsti2", 230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vthsti", 232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vdsti", 233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for STI [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesti1", 235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesti2", 236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "muesti3", 237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress mobility parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubpsti1", 238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubpsti2", 239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubpsti3", 240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "STI Stress pocket implant parameter" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lpext", 241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-50", "1e-50", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "npext", 242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5e+17", "5e+17", "Pocket extension" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scp22", 243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "scp21", 244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "bs1", 245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "bs2", 246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cgso_", 154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-S overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cgdo_", 155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-D overlap capacitance per unit W [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cgbo_", 156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "G-B overlap capacitance per unit L [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tpoly", 179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "Height of poly gate on the source side[m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0", 157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "5e-07", "5e-07", "Saturation current density [A/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0sw", 158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side wall saturation current density [A/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nj", 159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "njsw", 160, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall emission coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xti", 161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Junction current temparature exponent coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cj", 162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.0005", "0.0005", "Bottom junction capacitance per unit area at zero bias [F/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjsw", 163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Source/drain sidewall junction capacitance grading coefficient per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjswg", 164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Source/drain gate sidewall junction capacitance per unit length at zero bias [F/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mj", 165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjsw", 166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Source/drain sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjswg", 167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Source/drain gate sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pb", 175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bottom junction build-in potential  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbsw", 176, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbswg", 177, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain gate sidewall junction build-in potential [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xti2", 168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisb", 169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cvb", 170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias dependence coefficient of cisb [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ctemp", 171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisbk", 172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current [A]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cvbk", 173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Inactived by CVB" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "divx", 174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "[1/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "clm1", 191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.05", "0.05", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "clm2", 192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Parameter for CLM [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "clm3", 193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "clm5", 402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for CLM [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "clm6", 403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for CLM [um^{-clm5}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vover", 199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Parameter for overshoot [m^{voverp}]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "voverp", 200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vovers", 303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "voversp", 304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for overshoot [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfc", 201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for narrow channel effect [m*F/(cm^2)]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubcw", 249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubcwp", 250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for narrow channel effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "qme1", 202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for quantum effect [mV]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "qme2", 203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Parameter for quantum effect [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "qme3", 204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for quantum effect [m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gidl1", 205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gidl2", 206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gidl3", 207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gidl4", 281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gidl5", 282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.2", "0.2", "Parameter for GIDL [?]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glpart1", 406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Parameter for gate current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak1", 208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Parameter for gate current [A*V^(-3/2)/C]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak2", 209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Parameter for gate current [V^(-1/2)/m ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak3", 210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.06", "0.06", "Parameter for gate current [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak4", 211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "4", "4", "Parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak5", 212, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "7500", "7500", "Parameter for gate current [V/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak6", 213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.25", "0.25", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gleak7", 214, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Parameter for gate current [m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glksd1", 215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-15", "1e-15", "Parameter for gate current [A*m/V^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glksd2", 216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "Parameter for gate current [1/(V*m)]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glksd3", 217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "-1000", "-1000", "Parameter for gate current [1/m]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glkb1", 218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5e-16", "5e-16", "Parameter for gate current [A/V^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glkb2", 219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for gate current [m/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "glkb3", 429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "egig", 220, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "igtemp2", 221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V*k]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "igtemp3", 222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for gate current [V*k^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vzadd0", 223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Vzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pzadd0", 224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "Pzadd at Vds=0  [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nftrp", 258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+10", "1e+10", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nfalp", 259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-19", "1e-19", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cit", 260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "falph", 263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Parameter for 1/f noise" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "kappa", 251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant for high-k stacked gate" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vdiffj", 254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.0006", "0.0006", "Threshold voltage for S/D junction diode [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "dly1", 255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "1e-10", "1e-10", "Parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "dly2", 256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "s", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "Parameter for transit time [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "dly3", 257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "8e-07", "8e-07", "Parameter for transforming bulk charge [s/F]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "dlyov", 437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for transforming overlap charge [s/F]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tnom", 124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "27", "27", "Nominal temperature [K]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ovslp", 261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.1e-07", "2.1e-07", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ovmag", 262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gbmin", 394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rbpb_", 389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rbpd_", 390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rbps_", 391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rbdb_", 392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rbsb_", 393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ibpc1", 404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ibpc1l", 331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ibpc1lp", 332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ibpc2", 405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Parameter for impact-ionization induced bulk potential change" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mphdfm", 409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.3", "-0.3", "NSUBCDFM dependence of phonon scattering for DFM" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ptl", 530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ptp", 531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.5", "3.5", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pt2", 532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ptlp", 533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gdl", 534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gdlp", 535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gdld", 536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pt4", 537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pt4p", 538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvg11", 424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvg12", 425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rth0", 432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.1", "0.1", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cth0", 462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Thermal capacitance" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "powrat", 463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rthtemp1", 490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rthtemp2", 491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Thermal resistance" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prattemp1", 492, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prattemp2", 493, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbd", 92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbs", 93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbdsw", 94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbdsw" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbssw", 95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbssw" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbdswg", 96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbdswg" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tcjbsswg", 97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependence of cjbsswg" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "qdftvd", 438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Qdrift Vd dependence" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvd", 510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.07", "0.07", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvb", 301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd20", 447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd21", 441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd22", 442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd22d", 478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd23", 443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd24", 444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd25", 445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdl", 448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdlp", 449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvds", 450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdsp", 451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd23l", 452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd23lp", 453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd23s", 454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rd23sp", 455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rds", 456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdsp", 457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdtemp1", 461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of Rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdtemp2", 464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of Rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rth0r", 470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Heat radiation for SHE" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdtemp1", 471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of RDVD" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdtemp2", 472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature-dependence of RDVD" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rth0w", 473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rth0wp", 474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rth0nf", 475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "nf-dependence of RTH0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cvdsover", 480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "vds drop along the overlap" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvsub", 481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdvdsub", 482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ddrift", 483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbisub", 484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "0.7", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "nsubsub", 485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "model parameter for the substrate effect" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrmue", 520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvmax", 521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrmuetmp", 522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ndepm", 600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+17", "1e+17", "N- layer concentlation of the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "tndep", 601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "N- layer depth of the depletion MOS model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmue0", 605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "coulomb scattering of resistor region" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmue1", 606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coulomb scattering of resistor region" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmueback0", 607, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "coulomb scattering of back region" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmueback1", 608, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coulomb scattering of back region" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depleak", 615, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "leakage current coefficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depeta", 616, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depvmax", 609, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "3e+07", "3e+07", "velocity saturation" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depvdsef1", 611, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Vds dependece of leakage current" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depvdsef2", 612, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Vds dependece of leakage current" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmueph0", 613, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "phonon scattering" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmueph1", 614, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5000", "5000", "phonon scattering" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depbb", 610, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "high field effect coeeficient" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depvtmp", 617, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "temperature dependence of velocity saturation" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "depmuetmp", 618, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1.5", "1.5", "temperature dependence of mobility" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "isbreak", 619, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "reverse saturation current for breakdown" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rwell", 620, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "ohm", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "well resistance for breakdown" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvtmp", 523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrdjunc", 527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrcx", 528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrcar", 529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrdl1", 540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrdl2", 541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvmaxw", 544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvmaxwp", 545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvmaxl", 546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrvmaxlp", 547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrmuel", 548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrmuelp", 549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrqover", 552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "100000", "100000", "" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "qovadd", 338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for additional Qover Charge [-]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0d", 100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "5e-07", "5e-07", "Saturation current density for drain junction [A/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0swd", 150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side wall saturation current density for drain junction [A/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "njd", 153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient for drain junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "njswd", 189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall emission coefficient for drain junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xtid", 194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Junction current temparature exponent coefficient for drain junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjd", 196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.0005", "0.0005", "Bottom junction capacitance per unit area at zero bias for drain junction [F/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjswd", 197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Sidewall junction capacitance grading coefficient per unit length at zero bias for drain junction [F/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjswgd", 247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Gate sidewall junction capacitance per unit length at zero bias for drain junction [F/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjd", 252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom junction capacitance grading coefficient for drain junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjswd", 253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Sidewall junction capacitance grading coefficient for drain junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjswgd", 264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Gate sidewall junction capacitance grading coefficient for drain junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbd", 265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bottom junction build-in potential  for drain junction  [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbswd", 266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall junction build-in potential for drain junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbswgd", 267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate sidewall junction build-in potential for drain junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xti2d", 268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for drain junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisbd", 269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current for drain junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cvbd", 270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias dependence coefficient of cisb for drain junction  [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ctempd", 271, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for drain junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisbkd", 272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current for drain junction [A    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "divxd", 274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse coefficient coefficient for drain junction [1/V  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vdiffjd", 275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.0006", "0.0006", "Threshold voltage for junction diode for drain junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0s", 276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "5e-07", "5e-07", "Saturation current density for source junction [A/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "js0sws", 277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m^2", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Side wall saturation current density for source junction [A/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "njs", 278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Emission coefficient for source junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "njsws", 279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall emission coefficient for source junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xtis", 280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Junction current temparature exponent coefficient for source junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjs", 288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.0005", "0.0005", "Bottom junction capacitance per unit area at zero bias for source junction [F/m^2]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjsws", 289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Sidewall junction capacitance grading coefficient per unit length at zero bias for source junction [F/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cjswgs", 291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::DC, "5e-10", "5e-10", "Gate sidewall junction capacitance per unit length at zero bias for source junction [F/m  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjs", 293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Bottom junction capacitance grading coefficient for source junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjsws", 298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Sidewall junction capacitance grading coefficient for source junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "mjswgs", 299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::DC, "0.33", "0.33", "Gate sidewall junction capacitance grading coefficient for source junction [     ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbs", 300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bottom junction build-in potential  for source junction  [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbsws", 302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Sidewall junction build-in potential for source junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbswgs", 323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Gate sidewall junction build-in potential for source junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "xti2s", 333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for source junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisbs", 334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current for source junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cvbs", 335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias dependence coefficient of cisb for source junction  [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ctemps", 336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for source junction [-    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "cisbks", 337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse bias saturation current for source junction [A    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "divxs", 339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse coefficient coefficient for source junction [1/V  ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vdiffjs", 340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.0006", "0.0006", "Threshold voltage for junction diode for source junction [V    ]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "shemax", 501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "500", "500", "Maximum rise temperatue for SHE [C]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgsmin", 502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-100", "100", "minimal/maximal expected Vgs (NMOS/PMOS) [V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "gdsleak", 511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel leakage conductance [A/V]" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrbb", 273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "degradation of the mobility in drift region" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "rdrbbtmp", 602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "temperature coeeficient of RDRBB" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmin", 1000, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmax", 1001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmin", 1002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmax", 1003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lbinn", 1004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "L modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wbinn", 1005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "W modulation coefficient for binning" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvmax", 1100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lbgtmp1", 1101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lbgtmp2", 1102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "leg0", 1103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvfbover", 1428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnover", 1430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnovers", 1431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nover on source side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lwl2", 1407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvfbc", 1121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsubc", 1123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsubp", 1181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lscp1", 1184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lscp2", 1185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lscp3", 1186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsc1", 1126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsc2", 1127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsc3", 1128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lpgd1", 1187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lndep", 1129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lninv", 1130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuecb0", 1131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuecb1", 1132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmueph1", 1133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvtmp", 1141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lwvth0", 1142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuesr1", 1143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuetmp", 1195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsub1", 1151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsub2", 1152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsvds", 1286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsvbs", 1284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lsvgs", 1283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lfn1", 1294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lfn2", 1295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lfn3", 1296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lfvbs", 1297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsti", 1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lwsti", 1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lscsti1", 1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lscsti2", 1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvthsti", 1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuesti1", 1235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuesti2", 1236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lmuesti3", 1237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsubpsti1", 1238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsubpsti2", 1239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnsubpsti3", 1240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcgso", 1154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcgdo", 1155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0", 1157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0sw", 1158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnj", 1159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcisbk", 1172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lclm1", 1191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lclm2", 1192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lclm3", 1193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lwfc", 1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgidl1", 1205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgidl2", 1206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgleak1", 1208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgleak2", 1209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgleak3", 1210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lgleak6", 1213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lglksd1", 1215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lglksd2", 1216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lglkb1", 1218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lglkb2", 1219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnftrp", 1258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnfalp", 1259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvdiffj", 1254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "libpc1", 1404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "libpc2", 1405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcgbo", 1156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcvdsover", 1480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lfalph", 1263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnpext", 1242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lpowrat", 1463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrd", 1399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrd22", 1442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrd23", 1443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrd24", 1444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdict1", 1316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdov13", 1476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdslp1", 1315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdvb", 1301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdvd", 1510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrdvg11", 1424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrs", 1398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lrth0", 1432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvover", 1199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0d", 345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0d" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0swd", 370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0swd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnjd", 372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of njd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcisbkd", 386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cisbkd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvdiffjd", 387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdiffjd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0s", 388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0s" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ljs0sws", 395, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of js0sws" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lnjs", 396, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of njs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lcisbks", 397, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cisbks" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "lvdiffjs", 400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdiffjs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvmax", 2100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wbgtmp1", 2101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wbgtmp2", 2102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "weg0", 2103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvfbover", 2428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnover", 2430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnovers", 2431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of novers on source side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wwl2", 2407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvfbc", 2121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsubc", 2123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsubp", 2181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wscp1", 2184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wscp2", 2185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wscp3", 2186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsc1", 2126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsc2", 2127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsc3", 2128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wpgd1", 2187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wndep", 2129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wninv", 2130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuecb0", 2131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuecb1", 2132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmueph1", 2133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvtmp", 2141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wwvth0", 2142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuesr1", 2143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuetmp", 2195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsub1", 2151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsub2", 2152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsvds", 2286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsvbs", 2284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wsvgs", 2283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfn1", 2294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfn2", 2295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfn3", 2296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfvbs", 2297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsti", 2225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wwsti", 2226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wscsti1", 2229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wscsti2", 2230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvthsti", 2232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuesti1", 2235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuesti2", 2236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wmuesti3", 2237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsubpsti1", 2238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsubpsti2", 2239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnsubpsti3", 2240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcgso", 2154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcgdo", 2155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0", 2157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0sw", 2158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnj", 2159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcisbk", 2172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wclm1", 2191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wclm2", 2192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wclm3", 2193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wwfc", 2201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgidl1", 2205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgidl2", 2206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgleak1", 2208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgleak2", 2209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgleak3", 2210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wgleak6", 2213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wglksd1", 2215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wglksd2", 2216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wglkb1", 2218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wglkb2", 2219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnftrp", 2258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnfalp", 2259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvdiffj", 2254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wibpc1", 2404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wibpc2", 2405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcgbo", 2156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcvdsover", 2480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wfalph", 2263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnpext", 2242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wpowrat", 2463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrd", 2399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrd22", 2442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrd23", 2443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrd24", 2444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdict1", 2316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdov13", 2476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdslp1", 2315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdvb", 2301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdvd", 2510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrdvg11", 2424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrs", 2398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wrth0", 2432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvover", 2199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0d", 401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of js0d" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0swd", 435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of js0swd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnjd", 440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of njd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcisbkd", 446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of cisbkd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvdiffjd", 459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of vdiffjd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0s", 460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of js0s" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wjs0sws", 467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of js0sws" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wnjs", 468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of njs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wcisbks", 469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of cisbks" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "wvdiffjs", 477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Wength dependence of vdiffjs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvmax", 3100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vmax" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbgtmp1", 3101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pbgtmp2", 3102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgtmp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "peg0", 3103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eg0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvfbover", 3428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnover", 3430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnovers", 3431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nover on source side" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pwl2", 3407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvfbc", 3121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsubc", 3123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsubp", 3181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pscp1", 3184, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pscp2", 3185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pscp3", 3186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scp3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psc1", 3126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psc2", 3127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psc3", 3128, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sc3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ppgd1", 3187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pgd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pndep", 3129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndep" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pninv", 3130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ninv" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuecb0", 3131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuecb1", 3132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muecb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmueph1", 3133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mueph1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvtmp", 3141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pwvth0", 3142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wvth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuesr1", 3143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesr1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuetmp", 3195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muetmp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psub1", 3151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psub2", 3152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sub2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psvds", 3286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svds" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psvbs", 3284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "psvgs", 3283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of svgs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pfn1", 3294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pfn2", 3295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pfn3", 3296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fn3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pfvbs", 3297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fvbs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsti", 3225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pwsti", 3226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pscsti1", 3229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pscsti2", 3230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of scsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvthsti", 3232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vthsti" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuesti1", 3235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuesti2", 3236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pmuesti3", 3237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of muesti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsubpsti1", 3238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsubpsti2", 3239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnsubpsti3", 3240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsubpsti3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcgso", 3154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgso" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcgdo", 3155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0", 3157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0sw", 3158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0sw" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnj", 3159, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcisbk", 3172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cisbk" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pclm1", 3191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pclm2", 3192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pclm3", 3193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clm3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pwfc", 3201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wfc" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgidl1", 3205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgidl2", 3206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gidl2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgleak1", 3208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgleak2", 3209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgleak3", 3210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak3" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pgleak6", 3213, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gleak6" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pglksd1", 3215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pglksd2", 3216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glksd2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pglkb1", 3218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pglkb2", 3219, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of glkb2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnftrp", 3258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nftrp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnfalp", 3259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfalp" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvdiffj", 3254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdiffj" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pibpc1", 3404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pibpc2", 3405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ibpc2" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcgbo", 3156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgbo" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcvdsover", 3480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cvdsover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pfalph", 3263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of falph" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnpext", 3242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of npext" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "ppowrat", 3463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of powrat" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prd", 3399, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prd22", 3442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd22" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prd23", 3443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd23" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prd24", 3444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rd24" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdict1", 3316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdict1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdov13", 3476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdov13" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdslp1", 3315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdslp1" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdvb", 3301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvb" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdvd", 3510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prdvg11", 3424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdvg11" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prs", 3398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "prth0", 3432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rth0" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvover", 3199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vover" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0d", 479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0d" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0swd", 486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0swd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnjd", 487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of njd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcisbkd", 488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cisbkd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvdiffjd", 489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdiffjd" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0s", 495, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0s" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pjs0sws", 496, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of js0sws" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pnjs", 497, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of njs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pcisbks", 498, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cisbks" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "pvdiffjs", 499, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdiffjs" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgs_max", 4001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgd_max", 4002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgb_max", 4003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vds_max", 4004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbs_max", 4005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbd_max", 4006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgsr_max", 4007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgdr_max", 4008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vgbr_max", 4009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbsr_max", 4010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::HISIMHV2].modelParams.emplace_back( "vbdr_max", 4011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    // Instance parameters
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "coselfheat", 49, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Calculation of self heating model", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cosubnode", 50, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Switch tempNode to subNode", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "m", 83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Multiplication factor [-]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "l", 51, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "w", 52, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ad", 53, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "as", 54, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "pd", 55, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ps", 56, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "nrd", 57, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "nrs", 58, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "dtemp", 60, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "off", 61, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ic", 65, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "corbnet", 66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Activate body resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "rbpb", 67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "rbpd", 68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "rbps", 69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "rbdb", 70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "rbsb", 71, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "corg", 72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Activate gate resistance (1) or not (0)", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ngcon", 74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of gate contacts", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "xgw", 75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from gate contact to channel edge", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "xgl", 76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Offset of gate length due to variation in patterning", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "nf", 77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of fingers", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "sa", 78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "sb", 79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from STI edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "sd", 80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Distance from Gate edge to Gate edge [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "nsubcdfm", 82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Constant part of Nsub for DFM [1/cm^3]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "subld1", 86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for impact-ionization current in the drift region [-]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "subld2", 87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for impact-ionization current in the drift region [m^{-1}*V^{3/2}]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "lover", 41, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "3e-08", "3e-08", "Overlap length on source side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "lovers", 42, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "3e-08", "3e-08", "Overlap length on source side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "loverld", 43, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Overlap length on drain side [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ldrift1", 88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-1 [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ldrift2", 89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-2 [m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ldrift1s", 90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Parameter for drift region length-1 on source side[m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ldrift2s", 91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-06", "1e-06", "Parameter for drift region length-2 on source side[m]", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ids", 351, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "isub", 410, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "isubld", 426, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "IsubLD", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "idsibpc", 427, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "IdsIBPC", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "igidl", 411, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "igisl", 412, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "igd", 413, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "igs", 414, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "igb", 415, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gm", 354, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gds", 355, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gmbs", 356, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmbs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gmt", 465, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "GmT", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "von", 376, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Von", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "vdsat", 377, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "qb", 359, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qb", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "qg", 361, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qg", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "qd", 363, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgg", 365, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgg", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgd", 366, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgs", 367, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cbg", 368, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbg", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cbs", 383, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cbd", 382, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cdg", 373, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdg", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cdd", 374, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cds", 375, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cds", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgdo", 418, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgdo", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgso", 416, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgso", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "cgbo", 417, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Cgbo", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ibd", 353, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "ibs", 352, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gbd", 357, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "gbs", 358, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gbs", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "capbd", 369, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::HISIMHV2].instanceParams.emplace_back( "capbs", 371, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );
}