/*
   Copyright (C) 2019 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef DKIMGENERALWIDGET_H
#define DKIMGENERALWIDGET_H

#include <QWidget>
#include "dkimconfigure_private_export.h"
class QCheckBox;
class LIBDKIMVERIFYCONFIGURE_TESTS_EXPORT DKIMGeneralWidget : public QWidget
{
    Q_OBJECT
public:
    explicit DKIMGeneralWidget(QWidget *parent = nullptr);
    ~DKIMGeneralWidget();
    void loadSettings();
    void saveSettings();
    void resetSettings();
private:
    QCheckBox *mEnableDkimSupport = nullptr;
    QCheckBox *mSaveResult = nullptr;
    QCheckBox *mSaveKey = nullptr;
};

#endif // DKIMGENERALWIDGET_H
