package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           82,   82,  113,  113,  354,  253,   82,  212,  212,  212, 
          392,  582,  227,  212,  212,  216,  219,  212,  200,  285, 
          187,  572,  553,  357,  212,  420,  653,   60,   60,  108, 
          108,  108,  593,   60,  112,  112,  240,  240,  200,  226, 
          240,   82,  212,  212,  112,  281,  202,  212,  239,  239, 
          514,  519,  239,  525,  526,  242,  242,  603,  522,  242, 
          283,   71,  222,  472,  291,  266,  202,  277,   60,  249, 
          250,  510,  280,  734,  277,  550,  217,  112,   61,  276, 
          698,  245,  552,  701,  436,  463,  346,  300,  619,  281, 
          461,  307,  514,  519,  363,  231,   60,  472,  217,  254, 
          590,  188,  188,  212,  510,   82,  510,  465,  550,  248, 
          302,  303,  472,  236,  236,  608,  280,  236,  656,  463, 
          510,  112,  188,  619,  461,  218,  477,  222,  511,  789, 
          378,  792,   60,  423,  463,  791,  217,  254,  550,  461, 
          456,  465,   95,  270,  510,  188,  383,  218,  249,  660, 
          217,  657,  254,  510,  510,  510,  465,  302,  314,  315, 
          550,  444,  367,  510,  262,   71,  243,  650,  301,  244, 
          510,   69,  535,  462,  309,  477,  257,  467,  378,  378, 
           40,  510,   61,  444,  600,  218,  663,  505,  371,  456, 
          296,  510,  441,  750,  751,  443,  752,  685,  470,  218, 
          424,  425,  402,  471,  370,  505,  263,  402,  572,  744, 
           84,  510,  510,   64,  218,   67,   87,  446,  693,  510, 
          298,  212,  212,  309,  718,  510,   94,   94,  398,  399, 
          510,  394,   94,  395,  393,  347,  371,  371,  456,  444, 
          510,  499,  348,  212,   84,  212,  212,   51,  388,  342, 
           87,   86,   86,  114,  114,   82,   65,   86,   84,   84, 
           56,   57,   82,  228,   87,   87,  240,   94,  240,  240, 
          222,  510,  872,  448,  510,  349,  791,  374,  239,  510, 
          239,  422,   60,  350,  375,  242,  266,  242,  242,   60, 
          361,  490,   86,  316,  362,  839,  282,  280,  841,  377, 
          377,  842,  356,  676,  678,  377,   82,  212,  212,  212, 
          212,   82,  212,  212,  477,  478,  479,  480,  377,  527, 
          510,  530,  364,  344,  331,  538,  541,  351,  333,  334, 
          345,   94,  581,   60,  395,  739,  740,  763,   60,  355, 
          282,  628,  631,  236,  212,  236,  418,  212,  654,  212, 
           82,  281,  539,  212,  212,  382,   86,  551,   63,  261, 
          262,  642,  643,  510,  456,  457,  536,  407,  212,   82, 
          212,  459,  380,  403,  266,  577,   62,   60,  280,  314, 
          315,  894,   82,  112,  534,  810,  212,  378,  534,   69, 
           82,  723,   82,  770,  472,  414,   60,  416,  419,  774, 
           61,  212,   89,   89,  634,  277,  619,  599,   89,   60, 
          743,  534,  619,  212,  229,  544,  463,   60,  461,   60, 
          510,  461,  365,  510,  510,  212,  231,   82,  596,  615, 
          836,   64,  381,   67,  510,  510,  625,  200,  465,  851, 
          521,  368,  572,   89,  270,  371,  853,  476,  369,  602, 
          602,   69,  481,  212,   60,  626,    6,  477,  378,  511, 
           40,   40,  510,  378,  521,  202,    6,   84,  270,  510, 
          629,  456,   79,   87,   65,  510,  688,  630,  510,  510, 
          490,   94,  521,  389,  510,  386,  270,  390,   94,  510, 
          397,  510,  387,   64,  874,   67,  499,  521,  499,  800, 
          500,  270,  500,  499,  499,  499,   86,   89,  218,  499, 
          499,   40,  499,   86,  388,    6,  404,  676,  678,  280, 
          391,  188,  400,  510,  510,  510,  408,  521,  490,  407, 
          510,   74,   94,  411,  280,  490,   65,   94,  619,  455, 
          490,  280,  316,  212,   82,  847,  491,  314,  315,  521, 
          684,   82,  550,  270,  703,  510,  435,   86,   84,  879, 
          429,  490,   86,  667,   87,   82,   76,  672,  673,  500, 
          758,   60,  358,  359,  675,  677,   94,  619,  438,   82, 
            8,  790,  499,  711,  581,   82,  300,  200,  433,  702, 
            8,  437,   60,  434,  683,   94,  849,  438,  672,   82, 
           82,   86,  282,  499,  510,  451,   60,  212,   94,  442, 
          401,  537,  784,  490,  727,  202,   94,  402,   94,  694, 
           86,  452,  561,  562,  563,  564,  309,  310,  311,  312, 
          313,  212,  438,   86,  766,  768,  465,  510,  474,    8, 
          771,   86,   76,   86,  469,  447,  248,  449,  450,   82, 
          563,  564,  427,   94,  615,  281,   82,   89,   82,   76, 
          581,   82,  212,  212,   89,  821,  585,  301,  212,  822, 
          188,  188,  510,  510,  456,  457,   60,  395,   86,  598, 
          610,  459,  280,   60,  464,   60,  510,  112,   60,  490, 
          294,  295,   81,   80,  620,   75,  456,  457,  458,  632, 
          174,  633,  797,  459,  637,  641,   82,   87,   89,  212, 
          174,  655,  664,   89,  665,  670,  802,  671,    6,    6, 
            6,   82,   82,   82,    6,    6,  674,    6,  681,  796, 
          682,  742,  686,   60,  112,  780,  687,  689,  691,  274, 
          281,  869,  282,   79,  218,  833,  695,    7,   60,   60, 
           60,  431,   89,  797,  797,  818,  280,    7,  432,  174, 
           79,   82,  697,  280,  692,  699,   82,  817,  491,  700, 
           94,   89,  704,  212,  819,  708,  453,   82,  602,  714, 
          796,  796,  845,  454,   89,  112,  112,  715,   60,  846, 
          280,   94,   89,  717,   89,   86,  716,    6,   82,  719, 
          720,   84,  490,  722,   60,   94,    7,  726,   82,  510, 
          456,  457,  461,  510,  510,  438,   86,  459,    6,  233, 
          729,  735,  438,  745,  737,   60,  281,  738,  748,   89, 
           86,  500,  500,  500,  741,  746,  775,  500,  500,  781, 
          500,   82,    8,    8,    8,  212,  782,   82,    8,    8, 
          490,    8,  785,  280,   82,  803,  804,  490,  112,  805, 
          823,  815,  490,  797,  827,  797,  797,  828,   60,  438, 
           89,  829,  830,  832,   60,   94,  438,   76,  490,  837, 
          886,   60,   94,  490,   94,  838,  840,   94,  797,  844, 
          796,  510,  796,  796,  854,  112,  510,  112,  112,   82, 
           86,  754,  797,  855,   89,  859,  282,   86,  797,   86, 
          500,  861,   86,  864,  865,  796,  866,  870,   89,   89, 
          112,    8,  871,  890,  895,  896,  490,   89,   88,  796, 
           83,  500,   94,  490,  112,  796,  898,  900,  490,   76, 
          112,  521,    8,  904,  905,  270,   89,   94,   94,   94, 
          910,  274,  510,  798,  510,  501,   76,   86,  499,  490, 
          510,  501,  174,  174,  174,  503,  503,   89,  174,  174, 
          255,  174,   86,   86,   86,  412,  274,  281,   79,  282, 
          505,   89,  501,  274,  281,  510,  282,   94,  505,   74, 
          174,  174,  349,  174,  174,  174,  174,  511,  339,  305, 
          348,  340,  115,   94,  798,  798,   74,  316,  345,    7, 
            7,    7,   86,  344,  897,    7,    7,  190,    7,  786, 
          843,  306,  235,  235,   94,  690,  235,  280,   86,  230, 
          880,  788,  308,    0,  280,    0,  438,   75,  331,  491, 
           79,  174,  333,  334,  335,  336,  258,  260,    0,   86, 
            0,   89,  235,  235,    0,  284,  286,   79,   89,    0, 
           89,    0,  174,   89,  456,  457,  463,   94,  210,  210, 
          210,  459,    0,   94,  456,  457,  466,  282,  265,    0, 
           94,  459,    0,    0,  316,  251,    0,    0,    7,  406, 
          406,  406,   86,    0,    0,   86,  406,    0,   86,    0, 
          329,  330,    0,  268,  799,   86,    0,    0,   89,    7, 
            0,  396,  396,  396,  798,  331,  798,  798,  396,  333, 
          334,  335,  336,   89,   89,   89,    0,   89,    0,   86, 
          555,    0,  556,  557,  558,  559,   88,    0,    0,  798, 
          611,    0,  265,   86,   86,    0,    0,    0,    0,    0, 
            0,    0,    0,  798,    0,  825,  826,    0,    0,  798, 
            0,    0,    0,   89,  360,    0,    0,   83,    0,    0, 
           88,  561,  562,  563,  564,    0,  491,    0,    0,   89, 
          272,  275,    0,    0,   88,   88,    0,    0,  274,    0, 
           62,   62,  316,    0,    0,  274,   62,   62,   62,   62, 
           89,   83,    0,   62,   62,    0,    0,   62,  329,  330, 
            0,    0,    0,    0,   62,   83,   83,  281,   89,    0, 
            0,    0,    0,  331,   74,  332,    0,  333,  334,  335, 
          336,   62,   62,   62,   78,    0,   85,   62,    0,  235, 
          235,  286,    0,   89,    0,    0,    0,    0,  282,   89, 
            0,   78,  235,    0,  235,  235,   89,    0,    0,    0, 
            0,    0,  428,    0,    0,  889,    0,  892,  893,    0, 
           85,    0,   77,  438,    0,    0,  235,    0,    0,    0, 
          438,  491,  210,  210,   85,   85,   74,    0,    0,   77, 
          903,    0,  430,   62,    0,   62,    0,    0,    0,  265, 
            0,    0,    0,   74,  909,    0,    0,    0,    0,    0, 
          912,    0,    0,    0,    0,    0,    0,  494,    0,  494, 
            0,    0,    0,  484,  485,  486,  487,  488,  489,  490, 
          491,  492,  493,  494,  495,  496,  497,  498,  499,  500, 
          501,  502,  503,  504,  505,  506,  507,  508,  509,    0, 
          730,    0,   86,  235,    0,    0,  528,    0,  531,    0, 
          736,    0,  235,  542,    0,  491,    0,    0,  210,  210, 
          210,  210,    0,  482,  483,    0,    0,  235,    0,    0, 
            0,    0,    0,  421,    0,  235,    0,  265,    0,    0, 
            0,    0,    0,   88,    0,  235,  528,  591,  542,    0, 
            0,    0,  235,    0,    0,    0,    0,    0,    0,    0, 
          235,   62,   62,  491,  235,  235,    0,    0,  235,  584, 
          491,    0,  622,    0,   83,  491,    0,  592,    0,  594, 
            0,  554,    0,   62,    0,   62,   62,    0,    0,    0, 
          638,  639,  640,   86,    0,   62,  491,    0,   78,    0, 
          235,    0,   62,  235,  281,  235,    0,    0,    0,    0, 
            0,  281,  235,  811,  636,    0,  813,  814,    0,   78, 
          491,    0,    0,    0,  268,    0,    0,   77,    0,    0, 
            0,  272,    0,    0,   88,  282,  635,    0,    0,    0, 
            0,    0,  282,   85,    0,  491,   62,   62,   62,   62, 
           62,   62,   62,   62,    0,  272,  494,   77,  494,    0, 
            0,    0,    0,  580,  583,   83,    0,    0,  491,    0, 
            0,    0,    0,  272,  494,  491,    0,    0,    0,    0, 
          491,   78,    0,    0,   62,    0,  235,   62,  272,   62, 
           62,    0,    0,   62,   62,    0,    0,    0,   78,    0, 
            0,  491,  860,  862,  494,    0,  494,    0,   62,   62, 
           62,  494,    0,  494,    0,    0,  490,    0,  490,   77, 
            0,    0,   62,    0,    0,    0,   62,    0,    0,    0, 
           62,    0,   62,    0,   85,    0,   77,  494,    0,  494, 
          272,   62,  883,  884,    0,    0,    0,    0,  888,    0, 
            0,    0,  235,   62,  210,    0,    0,  659,  659,    0, 
            0,    0,    0,    0,    0,   62,  707,   62,    0,    0, 
          235,  901,    0,    0,  235,    0,  405,  406,  235,    0, 
            0,    0,    0,    0,  906,    0,    0,  908,   81,    0, 
          235,    0,   80,   62,    0,  659,  913,   75,    0,  669, 
            0,  235,    0,    0,    0,   81,    0,    0,    0,   80, 
          669,  669,    0,  440,   75,    0,    0,    0,  210,  764, 
            0,  767,  769,    0,    0,    0,    0,  772,  773,    0, 
            0,    0,  669,   86,  491,  274,  749,  776,  235,  281, 
            0,    0,    0,  761,  282,  762,  235,    0,  765,    0, 
            0,    0,    0,    0,    0,    0,  235,    0,  264,    0, 
            0,    0,   85,  494,  706,    0,    0,  710,  264,  583, 
            0,  767,  769,  772,    0,    0,    0,  583,  511,  235, 
            0,    0,  491,   62,   62,    0,  235,    0,  511,  491, 
            0,  235,  235,  801,  491,  533,    0,    0,    0,  540, 
            0,    0,  263,    0,    0,   62,    0,    0,  807,  808, 
          809,  494,    0,    0,    0,  491,  264,  264,  494,   62, 
          210,    0,  578,  490,  555,    0,  556,  557,  558,  559, 
            0,    0,  834,    0,  235,    0,  511,  511,    0,  533, 
            0,    0,    0,    0,  494,    0,  659,   62,  831,    0, 
            0,  612,  614,    0,    0,  618,    0,    0,  560,  624, 
            0,  834,    0,  235,    0,  561,  562,  563,  564,  857, 
            0,   62,    0,  235,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,  848,    0,  645,    0,   62, 
          618,    0,  645,    0,    0,    0,   62,  235,   62,    0, 
            0,   62,   62,   62,  235,    0,    0,  199,   62,    0, 
            0,    0,    0,    0,    0,    0,  235,  199,  235,    0, 
            0,    0,    0,   81,  669,  669,    0,   80,    0,    0, 
            0,    0,   75,    0,  881,    0,    0,    0,    0,    0, 
            0,  882,  235,    0,  235,   41,   62,    0,    0,   62, 
            0,  199,    0,    0,    0,   41,    0,  235,    0,    0, 
            0,   62,   62,   62,  235,  199,  199,    0,    0,    0, 
          199,    0,  274,  679,    0,    0,  281,    0,    0,  274, 
            0,  282,    0,  281,    0,   81,    0,    0,  282,   80, 
            0,    0,  583,    0,   75,    0,    0,    0,    0,    0, 
            0,   62,   81,   41,   41,    0,   80,    0,    0,    0, 
            0,   75,    0,   62,    0,    0,    0,   62,    0,    0, 
          264,  264,  264,    0,    0,  264,  264,  264,    0,  264, 
            0,    0,  272,    0,    0,    0,    0,    0,   62,  721, 
          511,  511,  511,    0,    0,  511,  511,  511,    0,  511, 
            0,  264,  264,  264,  264,  264,    0,  728,    0,  511, 
          511,  731,    0,    0,    0,  732,  583,  316,  511,  511, 
            0,  511,  511,  511,  511,  511,    0,  614,    0,    0, 
            0,   62,    0,  329,  330,   62,    0,   62,  747,    0, 
            0,  427,    0,    0,   62,    0,  264,    0,  331,  264, 
          332,  427,  333,  334,  335,  336,    0,    0,  339,    0, 
          340,    0,    0,    0,    0,    0,    0,    0,    0,  511, 
          264,    0,  511,    0,  511,  778,    0,    0,    0,    0, 
            0,    0,    0,  783,    0,  427,    0,    0,    0,    0, 
          511,    0,    0,  793,    0,    0,    0,    0,    0,  427, 
          427,    0,  427,    0,  427,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  645,    0,    0,  199, 
          199,  199,    0,  618,  199,  199,  199,    0,  199,  618, 
            0,    0,  427,    0,    0,    0,    0,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,    0, 
          199,  199,  199,  199,  199,    0,    0,   41,   41,   41, 
            0,    0,   41,   41,   41,  430,   41,    0,    0,    0, 
            0,  835,    0,    0,    0,  430,   41,    0,    0,    0, 
            0,  199,  199,    0,    0,    0,  199,  199,   41,   41, 
           41,   41,   41,    0,    0,  199,    0,    0,  199,    0, 
          850,  199,    0,  199,    0,    0,    0,    0,    0,  430, 
          858,    0,    0,    0,  863,    0,    0,    0,    0,  199, 
            0,    0,    0,  430,  430,    0,  430,  316,  430,    0, 
            0,    0,  321,  322,  873,    0,   41,    0,    0,    0, 
            0,    0,    0,  329,  330,    0,    0,    0,    0,    0, 
            0,    0,    0,  614,    0,  618,  430,   41,  331,    0, 
          332,    0,  333,  334,  335,  336,  337,  338,  339,    0, 
          340,    0,    0,    0,    0,    0,    0,    0,    0,  899, 
            0,  902,    0,   52,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,  618,    0,  162,    0,  487,  487, 
          487,  911,  487,  427,  427,  427,  487,  487,  427,  427, 
          427,  487,  427,  487,  487,  487,  487,  487,  487,  487, 
          427,  487,  427,  427,  487,  487,  487,  487,  487,  487, 
          487,  427,  427,    0,  427,  427,  427,  427,  427,    0, 
          487,   52,   52,  487,  487,  162,    0,  487,  487,  487, 
          487,  487,  487,    0,    0,  487,  487,  487,  427,  427, 
          427,  427,  427,  427,  427,  427,  427,  427,  427,  427, 
          427,  427,    0,    0,  427,  427,  427,  487,  427,  427, 
          487,  487,  427,  487,  487,  427,  487,  427,  487,  427, 
          487,  427,  487,  427,  427,  427,  427,  427,  427,  427, 
          487,  427,  487,  427,    0,  487,  487,  487,  487,  487, 
          487,   54,    0,    0,    0,    0,  487,  487,    0,  487, 
          487,   54,  488,  488,  488,    0,  488,  430,  430,  430, 
          488,  488,  430,  430,  430,  488,  430,  488,  488,  488, 
          488,  488,  488,  488,  430,  488,  430,  430,  488,  488, 
          488,  488,  488,  488,  488,  430,  430,    0,  430,  430, 
          430,  430,  430,    0,  488,    0,    0,  488,  488,   54, 
           54,  488,  488,  488,  488,  488,  488,    0,    0,  488, 
          488,  488,  430,  430,  430,  430,  430,  430,  430,  430, 
          430,  430,  430,  430,  430,  430,    0,    0,  430,  430, 
          430,  488,  430,  430,  488,  488,  430,  488,  488,  430, 
          488,  430,  488,  430,  488,  430,  488,  430,  430,  430, 
          430,  430,  430,  430,  488,  430,  488,  430,  490,  488, 
          488,  488,  488,  488,  488,    0,    0,    0,  490,    0, 
          488,  488,    0,  488,  488,   52,   52,   52,    0,    0, 
           52,   52,   52,    0,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   52,    0,    0,    0,    0, 
            0,    0,  490,   52,   52,    0,   52,   52,   52,   52, 
           52,    0,    0,    0,    0,    0,  490,  490,    0,   84, 
            0,  490,  162,    0,  162,  162,  162,  162,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  433,    0,    0,    0,    0,  490, 
            0,  433,    0,    0,   52,    0,  162,   52,    0,    0, 
            0,    0,    0,  162,  162,  162,  162,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,    0,    0,    0,    0, 
            0,  491,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  491,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   54,   54,   54,    0,    0,   54,   54, 
           54,    0,   54,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,   54,    0,  491,    0,    0,    0,    0, 
            0,   54,   54,    0,   54,   54,   54,   54,   54,  491, 
          491,    0,   86,    0,  491,    0,    0,    0,    0,    0, 
            0,    0,    0,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,    0,    0,    0,    0,    0,  329, 
          330,    0,  491,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   54,    0,  331,   54,  332,    0,  333,  334, 
          335,  336,  337,  338,  339,    0,  340,    0,    0,    0, 
           56,    0,    0,   54,    0,    0,    0,    0,    0,    0, 
           56,    0,    0,  155,    0,  490,  490,  490,    0,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,    0,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
            0,  490,  490,  490,  490,  490,    0,  490,   56,   56, 
          490,  490,  155,    0,  490,  490,  490,  490,  490,  490, 
            0,    0,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,    0, 
            0,  490,  490,  490,  490,    0,  490,  490,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,    0,  490,  490,  490,  490,  490,  490,    0,    0, 
            0,    0,    0,  490,  490,    0,  490,  490,  491,  491, 
          491,    0,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          610,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,    0,  491,  491,  491,  491,  491,  341, 
          491,    0,    0,  491,  491,    0,    0,  491,  491,  491, 
          491,  491,  491,    0,    0,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,    0,    0,  491,  491,  491,  491,    0,  491, 
          491,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  494,  491,  491,  491,  491,  491, 
          491,    0,    0,    0,  494,    0,  491,  491,    0,  491, 
          491,    0,   56,   56,   56,    0,    0,   56,   56,   56, 
            0,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   56,   56,    0,    0,    0,    0,    0,  494,    0, 
           56,   56,    0,   56,   56,   56,   56,   56,    0,    0, 
            0,    0,  494,  494,    0,   85,    0,  494,    0,  155, 
            0,  155,  155,  155,  155,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  432,    0,    0,    0,  494,    0,    0,  432,    0, 
            0,   56,    0,  155,   56,    0,    0,    0,    0,    0, 
          155,  155,  155,  155,  316,  317,  318,  319,  320,  321, 
          322,  323,   56,  325,  326,    0,    0,  275,    0,    0, 
          329,  330,    0,    0,    0,    0,    0,  275,    0,    0, 
            0,    0,    0,    0,    0,  331,    0,  332,    0,  333, 
          334,  335,  336,  337,  338,  339,    0,  340,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  275,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  275,  275,    0,    0,    0, 
          275,    0,    0,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,    0,  327,  328,    0,    0,  329, 
          330,    0,    0,    0,    0,    0,    0,    0,  275,    0, 
            0,    0,    0,    0,  331,    0,  332,    0,  333,  334, 
          335,  336,  337,  338,  339,    0,  340,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   40,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   40,    0,    0,  165, 
            0,  490,  490,  490,    0,  490,  494,  494,  494,  490, 
          490,  494,  494,  494,  490,  494,  490,  490,  490,  490, 
          490,  490,  490,    0,  494,  494,  494,  490,  490,  490, 
          490,  490,  490,  490,  494,  494,    0,  494,  494,  494, 
          494,  494,    0,  490,   40,   40,  490,  490,  165,    0, 
          490,  490,  490,  490,  490,  490,    0,    0,  490,  490, 
          490,  494,  494,  494,  494,  494,  494,  494,  494,  494, 
          494,  494,  494,  494,  494,    0,    0,  494,  494,  494, 
          490,    0,  494,  490,  490,  494,  490,  490,  494,  490, 
          494,  490,  494,  490,  494,  490,  494,  494,  494,  494, 
          494,  494,  494,  490,  494,  494,  494,    0,  490,  490, 
          490,  490,  490,  490,    0,    0,    0,    0,    0,  490, 
          490,    0,  490,  490,  489,  489,  489,    0,  489,  275, 
          275,  275,  489,  489,  275,  275,  275,  489,  275,  489, 
          489,  489,  489,  489,  489,  489,    0,  489,  275,  275, 
          489,  489,  489,  489,  489,  489,  489,  275,  275,    0, 
          275,  275,  275,  275,  275,    0,  489,  662,    0,  489, 
          489,    0,  341,  489,  489,  489,  489,  489,  489,    0, 
            0,  489,  489,  489,  275,  275,  275,  275,  275,  275, 
          275,  275,  275,  275,  275,  275,  275,  275,    0,    0, 
          275,  275,  275,  489,    0,  275,  489,  489,  275,  489, 
          489,  275,  489,  275,  489,  275,  489,  275,  489,  275, 
          275,  275,  275,  275,  275,  275,  489,  275,  489,  275, 
          495,  489,  489,  489,  489,  489,  489,    0,    0,    0, 
          495,    0,  489,  489,    0,  489,  489,    0,   40,   40, 
           40,    0,    0,   40,   40,   40,    0,   40,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   40,    0,    0, 
            0,    0,    0,    0,  495,    0,   40,   40,    0,   40, 
           40,   40,   40,   40,    0,    0,    0,    0,  495,  495, 
            0,    0,    0,  495,    0,  165,    0,  165,  165,  165, 
          165,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  434,    0,    0, 
            0,  495,    0,    0,  434,    0,    0,   40,    0,  165, 
            0,    0,    0,    0,    0,    0,  165,  165,  165,  165, 
          316,  317,  318,  319,  320,  321,  322,    0,   40,  325, 
          326,    0,    0,  496,    0,    0,  329,  330,    0,    0, 
            0,    0,    0,  496,    0,    0,    0,    0,    0,    0, 
            0,  331,    0,  332,    0,  333,  334,  335,  336,  337, 
          338,  339,    0,  340,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  496,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  496,  496,    0,    0,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,    0,  327,  328, 
            0,    0,  329,  330,  496,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  331,    0,  332, 
            0,  333,  334,  335,  336,  337,  338,  339,    0,  340, 
            0,    0,   42,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   42,    0,    0,  150,    0,  492,  492,  492, 
            0,  492,  495,  495,  495,  492,  492,  495,  495,  495, 
          492,  495,  492,  492,  492,  492,  492,  492,  492,    0, 
          495,  495,  495,  492,  492,  492,  492,  492,  492,  492, 
          495,  495,    0,  495,  495,  495,  495,  495,    0,  492, 
           42,   42,  492,  492,  150,    0,  492,  492,  492,  492, 
          492,  492,    0,    0,  492,  492,  492,  495,  495,  495, 
          495,  495,  495,  495,  495,  495,  495,  495,  495,  495, 
          495,    0,    0,  495,  495,  495,  492,    0,  495,  492, 
          492,  495,  492,  492,  495,  492,  495,  492,  495,  492, 
          495,  492,  495,  495,  495,  495,  495,  495,  495,  492, 
          495,  495,  495,    0,  492,  492,  492,  492,  492,  492, 
            0,    0,    0,    0,    0,  492,  492,    0,  492,  492, 
          493,  493,  493,    0,  493,  496,  496,  496,  493,  493, 
          496,  496,  496,  493,  496,  493,  493,  493,  493,  493, 
          493,  493,    0,  496,  496,  496,  493,  493,  493,  493, 
          493,  493,  493,  496,  496,    0,  496,  496,  496,  496, 
          496,  341,  493,    0,    0,  493,  493,    0,    0,  493, 
          493,  493,  493,  493,  493,    0,    0,  493,  493,  493, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,    0,    0,  496,  496,  496,  493, 
            0,  496,  493,  493,  496,  493,  493,  496,  493,  496, 
          493,  496,  493,  496,  493,  496,  496,  496,  496,  496, 
          496,  496,  493,  496,  496,  496,  365,  493,  493,  493, 
          493,  493,  493,    0,    0,    0,  365,    0,  493,  493, 
            0,  493,  493,    0,   42,   42,   42,    0,    0,   42, 
           42,   42,    0,   42,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   42,    0,    0,    0,    0,    0,    0, 
          365,    0,   42,   42,    0,   42,   42,   42,   42,   42, 
            0,    0,    0,    0,  365,  365,    0,    0,    0,  365, 
            0,  150,    0,  150,  150,  150,  150,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  435,    0,    0,    0,  365,    0,    0, 
          435,    0,    0,   42,    0,  150,    0,    0,    0,    0, 
            0,    0,  150,  150,  150,  150,    0,    0,    0,    0, 
            0,    0,    0,    0,   42,    0,    0,    0,    0,  510, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  510, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,    0,  680,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  510,  510,    0, 
            0,    0,  510,    0,    0,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,    0,  327,  328,    0, 
            0,  329,  330,    0,    0,    0,    0,    0,    0,    0, 
          510,    0,    0,    0,    0,    0,  331,    0,  332,    0, 
          333,  334,  335,  336,  337,  338,  339,    0,  340,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   47,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   47,    0, 
            0,  133,    0,  252,  252,  252,    0,  252,  365,  365, 
          365,  252,  252,  365,  365,  365,  252,  365,  252,  252, 
          252,  252,  252,  252,  252,    0,  365,  365,  365,  252, 
          252,  252,  252,  252,  252,  252,  365,  365,    0,  365, 
          365,  365,  365,  365,    0,  252,   47,   47,  252,  252, 
          133,    0,  252,  252,  252,  252,  252,  252,    0,    0, 
          252,  252,  252,  365,  365,  365,  365,  365,  365,  365, 
          365,  365,  365,  365,  365,  365,  365,    0,    0,  365, 
          365,  365,  252,    0,  365,  252,    0,  365,  252,  252, 
          365,  252,  365,  252,  365,  252,  365,  252,  365,  365, 
          365,  365,  365,  365,  365,  252,  365,  365,  365,    0, 
          252,  252,  252,  252,  252,  252,    0,    0,    0,    0, 
            0,  252,  252,    0,  252,  252,  252,  252,  252,    0, 
          252,  510,  510,  510,  252,  252,  510,  510,  510,  252, 
          510,  252,  252,  252,  252,  252,  252,  252,    0,  510, 
          510,  510,  252,  252,  252,  252,  252,  252,  252,  510, 
          510,    0,  510,  510,  510,  510,  510,  341,  252,    0, 
            0,  252,  252,    0,    0,  252,  252,  252,  252,  252, 
          252,    0,    0,  252,  252,  252,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  510, 
            0,    0,  510,  510,  510,  252,    0,  510,  252,    0, 
          510,  252,  252,  510,  252,  510,  252,  510,  252,  510, 
          252,  510,  510,  510,  510,  510,  510,  510,  252,  510, 
          510,  510,  280,  252,  252,  252,  252,  252,  252,    0, 
            0,    0,  280,    0,  252,  252,    0,  252,  252,    0, 
           47,   47,   47,    0,    0,   47,   47,   47,    0,   47, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   47, 
            0,    0,    0,    0,    0,    0,  280,    0,   47,   47, 
            0,   47,   47,   47,   47,   47,    0,    0,    0,    0, 
          280,  280,    0,   87,    0,  280,    0,  133,    0,  133, 
          133,  133,  133,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  437, 
            0,    0,    0,  280,    0,    0,  437,    0,    0,   47, 
            0,  133,    0,    0,    0,    0,    0,    0,  133,  133, 
          133,  133,    0,    0,    0,    0,    0,    0,    0,    0, 
           47,    0,    0,    0,    0,  288,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  288,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  288, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,  288,    0,    0,    0,  288,    0, 
            0,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,    0,  327,  328,    0,    0,  329,  330,    0, 
            0,    0,    0,    0,    0,    0,  288,    0,    0,    0, 
            0,    0,  331,    0,  332,    0,  333,  334,  335,  336, 
          337,  338,  339,  134,  340,    0,    0,    0,    0,    0, 
            0,    0,    0,   34,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   34,    0,    0,    0,    0,    0,  491, 
          491,  491,    0,  491,  280,  280,  280,  491,  491,  280, 
          280,  280,  491,  280,  491,  491,  491,  491,  491,  491, 
          491,    0,  134,  280,  280,  491,  491,  491,  491,  491, 
          491,  491,  280,  280,    0,  280,  280,  280,  280,  280, 
            0,  491,   34,    0,  491,  491,    0,    0,  491,  491, 
          491,  491,  491,  491,    0,    0,  491,  491,  491,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,    0,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          280,  280,  280,  491,    0,  280,  491,  491,  280,  491, 
          491,  280,  491,  280,  491,  280,  491,  280,  491,  280, 
          280,  280,  280,  280,  280,  280,  491,  280,    0,  280, 
            0,  491,  491,  491,  491,  491,  491,    0,    0,    0, 
            0,    0,  491,  491,    0,  491,  491,  252,  252,  252, 
            0,  252,  288,  288,  288,  252,  252,  288,  288,  288, 
          252,  288,  252,  252,  252,  252,  252,  252,  252,    0, 
            0,  288,  288,  252,  252,  252,  252,  252,  252,  252, 
          288,  288,    0,  288,  288,  288,  288,  288,    0,  252, 
            0,    0,  252,  252,    0,    0,  252,  252,  252,  252, 
          252,  252,    0,    0,  252,  252,  252,  288,  288,  288, 
          288,  288,  288,  288,  288,  288,  288,  288,  288,  288, 
          288,    0,    0,  288,  288,  288,  252,    0,  288,  252, 
            0,  288,  252,  252,  288,  252,  288,  252,  288,  252, 
          288,  252,  288,  288,  288,  288,  288,  288,  288,  252, 
          288,  490,  288,    0,  252,  252,  252,  252,  252,  252, 
            0,  490,    0,    0,    0,  252,  252,    0,  252,  252, 
           34,   34,   34,    0,    0,    0,   34,   34,    0,   34, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  134,   76,  134,  134,  134,  134, 
            0,   34,   34,   34,   34,   34,    0,    0,    0,    0, 
          490,    0,   84,    0,  490,    0,  436,    0,    0,    0, 
            0,    0,    0,  436,    0,    0,    0,    0,  134,    0, 
            0,    0,    0,    0,    0,  134,  134,  134,  134,    0, 
            0,    0,  490,    0,    0,    0,    0,    0,    0,   34, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
           34,    0,    0,   11,  491,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,  491,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  101,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,    0,    0,   78,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  491,    0,   86,    0,  491,    0,  279, 
            0,    0,  352,    0,    0,   44,   45,    0,   46,    0, 
          755,    0,  756,    0,    0,    0,    0,    0,    0,    0, 
            0,  757,    0,    0,    0,  491,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   14,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   14,    0,    0,    0,   95,    0,  490,  490, 
          490,    0,  490,  490,  490,  490,  490,  490,    0,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
            0,  490,    0,    0,  490,  490,  490,  490,  490,  490, 
          490,  490,  490,    0,  490,  490,  490,  490,  490,    0, 
          490,   14,    0,  490,  490,   95,    0,  490,  490,  490, 
          490,  490,  490,    0,    0,  490,  490,  490,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,  490,    0,    0,  490,  490,  490,  490,    0,    0, 
          490,  490,  490,  490,  490,    0,  490,    0,  490,  490, 
          490,  490,  490,  490,  490,  490,  490,  490,  490,  490, 
          490,  490,  490,  490,    0,  490,  490,  490,  490,  490, 
          490,    0,    0,    0,    0,    0,  490,  490,    0,  490, 
          490,  491,  491,  491,    0,  491,  491,  491,  491,  491, 
          491,    0,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,    0,  491,    0,    0,  491,  491,  491, 
          491,  491,  491,  491,  491,  491,    0,  491,  491,  491, 
          491,  491,    0,  491,    0,    0,  491,  491,    0,    0, 
          491,  491,  491,  491,  491,  491,    0,    0,  491,  491, 
          491,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  491,    0,    0,  491,  491,  491, 
          491,    0,    0,  491,  491,  491,  491,  491,    0,  491, 
            0,  491,  491,  491,  491,  491,  491,  491,  491,  491, 
          491,  491,  491,  491,  491,  491,  491,  494,  491,  491, 
          491,  491,  491,  491,    0,    0,    0,  494,    0,  491, 
          491,    0,  491,  491,   14,   14,   14,    0,    0,    0, 
           14,   14,    0,   14,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   77,    0,    0,    0,   14,   14,   14,   14,   14, 
            0,    0,    0,    0,    0,    0,  494,    0,   85,    0, 
          494,    0,   95,    0,   95,   95,   95,   95,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  427,    0,    0,    0,  494,    0, 
            0,  427,    0,   14,    0,    0,   95,    0,    0,    0, 
            0,    0,    0,   95,   95,   95,   95,    3,    4,    5, 
            6,    7,    8,    0,   14,    0,    9,   10,    0,    0, 
          280,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
          280,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,   79,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  280, 
            0,   87,    0,  280,    0,    0,    0,   42,    0,    0, 
           43,    0,    0,   44,   45,    0,   46,    0,   47,    0, 
            0,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
           49,  280,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  510,  490,  490,  490,    0,  490,  494, 
          494,  494,  490,  490,    0,  494,  494,  490,  494,  490, 
          490,  490,  490,  490,  490,  490,    0,  494,    0,    0, 
          490,  490,  490,  490,  490,  490,  490,  494,  494,    0, 
          494,  494,  494,  494,  494,    0,  490,    0,    0,  490, 
          490,  510,  510,  490,  490,  490,  490,  490,  490,    0, 
            0,  490,  490,  490,  494,  494,  494,  494,  494,  494, 
          494,  494,  494,  494,  494,  494,  494,  494,    0,    0, 
          494,  494,  494,  490,    0,    0,  490,  490,  494,  490, 
          490,    0,  490,    0,  490,  494,  490,  494,  490,  494, 
          494,  494,  494,  494,  494,  494,  490,  494,  494,  494, 
            0,  490,  490,  490,  490,  490,  490,    0,    0,    0, 
            0,    0,  490,  490,    0,  490,  490,  491,  491,  491, 
            0,  491,  280,  280,  280,  491,  491,    0,  280,  280, 
          491,  280,  491,  491,  491,  491,  491,  491,  491,    0, 
            0,    0,   90,  491,  491,  491,  491,  491,  491,  491, 
          280,  280,    0,  280,  280,  280,  280,  280,    0,  491, 
            0,    0,  491,  491,    0,    0,  491,  491,  491,  491, 
          491,  491,    0,    0,  491,  491,  491,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,   90,    0,  280,  280,  280,  491,    0,    0,  491, 
          491,  280,  491,  491,    0,  491,    0,  491,  280,  491, 
          280,  491,  280,  280,  280,  280,  280,  280,  280,  491, 
          280,    0,  280,  427,  491,  491,  491,  491,  491,  491, 
            0,    0,    0,    0,    0,  491,  491,    0,  491,  491, 
          252,  252,  252,    0,  252,  510,  510,  510,  252,  252, 
          510,  510,  510,  252,  510,  252,  252,  252,  252,  252, 
          252,  252,    0,    0,  510,    0,  252,  252,  252,  252, 
          252,  252,  252,  510,  510,    0,  510,  510,  510,  510, 
          510,    0,  252,    0,   91,  252,  252,    0,    0,  252, 
          252,  252,  252,  252,  252,    0,    0,  252,  252,  252, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  510,    0,    0,    0,    0,    0,    0,  510,  252, 
            0,    0,  252,    0,  510,  252,  252,    0,  252,    0, 
          252,    0,  252,   91,  252,    0,    0,    0,    0,    0, 
            0,    0,  252,    0,    0,  510,    0,  252,  252,  252, 
          252,  252,  252,    0,    0,    0,    0,    0,  252,  252, 
            0,  252,  252,    0,    0,  430,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   90,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,    0, 
            0,   90,   90,    0,   90,   90,   90,   90,   90,   90, 
           90,    0,  487,   90,    0,   90,   90,   90,   90,   90, 
           90,   90,    0,    0,   90,    0,    0,    0,    0,    0, 
           90,   90,   90,   90,   90,   90,    0,    0,   90,   90, 
           90,   90,   90,   90,    0,    0,   90,   90,   90,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          427,    0,   90,    0,    0,    0,    0,  427,   90,    0, 
            0,   90,  487,    0,   90,   90,    0,   90,    0,   90, 
            0,    0,    0,   90,    0,    0,    0,    0,   90,    0, 
            0,   90,    0,  487,  494,    0,   90,   90,   90,   90, 
           90,   90,    0,    0,    0,    0,    0,   90,   90,    0, 
           90,   90,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,   91, 
           91,    0,   91,   91,   91,    0,   91,   91,   91,   91, 
           91,   91,   91,    0,  488,   96,    0,   91,   91,   91, 
           91,   91,   91,   91,    0,    0,   91,    0,    0,    0, 
            0,    0,   91,   91,   91,   91,   91,   91,    0,    0, 
           91,   91,   91,   91,   91,   91,    0,    0,   91,   91, 
           91,   91,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  430,    0,   96,    0,    0,    0,    0,  430, 
           91,    0,    0,   91,  488,    0,   91,   91,    0,   91, 
            0,   91,    0,  280,    0,   91,    0,    0,    0,    0, 
           91,    0,    0,   91,    0,  488,    0,    0,   91,   91, 
           91,   91,   91,   91,    0,    0,    0,    0,    0,   91, 
           91,    0,   91,   91,    0,    0,    0,    0,    0,   90, 
           90,   90,   90,   90,   90,   90,   90,   90,   90,   90, 
            0,   91,   90,   90,    0,   90,   90,   90,   90,   90, 
           90,   90,    0,  494,    0,    0,   90,   90,   90,   90, 
           90,   90,   90,    0,    0,   90,    0,    0,    0,    0, 
            0,   90,   90,   90,   90,   90,   90,    0,    0,   90, 
           90,   90,   90,   90,   90,    0,    0,   90,   90,   90, 
           91,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  494,    0,    0,    0,    0,    0,    0,  494,   90, 
            0,    0,   90,  490,    0,   90,   90,    0,   90,    0, 
           90,    0,  281,    0,   90,    0,    0,    0,    0,   90, 
            0,    0,   90,    0,  494,    0,    0,   90,   90,   90, 
           90,   90,   90,    0,    0,    0,    0,    0,   90,   90, 
            0,   90,   90,    0,    0,    0,    0,    0,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,   91,    0, 
          324,   91,   91,    0,   91,   91,   91,   91,   91,   91, 
           91,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,   91,    0,    0,   91,    0,    0,    0,    0,    0, 
           91,   91,   91,   91,   91,   91,    0,    0,   91,   91, 
           91,   91,   91,   91,    0,    0,   91,   91,   91,  324, 
            0,   96,    0,   96,   96,   96,   96,    0,    0,    0, 
          280,    0,    0,    0,    0,    0,    0,  280,   91,    0, 
            0,   91,  491,  430,   91,   91,    0,   91,    0,   91, 
          430,    0,    0,   91,    0,   96,    0,    0,   91,    0, 
            0,   91,   96,   96,   96,   96,   91,   91,   91,   91, 
           91,   91,    0,    0,    0,    0,    0,   91,   91,    0, 
           91,   91,    0,    0,    0,    0,    0,   91,   91,   91, 
           91,   91,   91,   91,   91,   91,   91,   91,    0,  510, 
           91,   91,    0,   91,   91,   91,   91,   91,   91,   91, 
            0,    0,    0,    0,   91,   91,   91,   91,   91,   91, 
           91,    0,    0,   91,    0,    0,    0,    0,    0,   91, 
           91,   91,   91,   91,   91,    0,    0,   91,   91,   91, 
           91,   91,   91,    0,    0,   91,   91,   91,  510,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  281, 
            0,    0,    0,    0,    0,    0,  281,   91,    0,    0, 
           91,    0,    0,   91,   91,    0,   91,    0,   91,    0, 
            0,    0,   91,    0,    0,    0,    0,   91,    0,    0, 
           91,    0,    0,    0,    0,   91,   91,   91,   91,   91, 
           91,    0,    0,    0,    0,    0,   91,   91,    0,   91, 
           91,    0,    0,    0,    0,    0,  324,  324,  324,  324, 
          324,  324,  324,  324,  324,  324,  324,    0,  324,  324, 
          324,  324,  324,  324,  324,  324,  324,  324,  324,  510, 
            0,    0,    0,  324,  324,  324,  324,  324,  324,  324, 
            0,    0,  324,    0,    0,    0,    0,    0,  324,  324, 
          324,  324,  324,  324,    0,    0,  324,  324,  324,  324, 
          324,  324,    0,    0,  324,  324,  324,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  510,    0, 
            0,    0,    0,    0,    0,    0,  324,    0,    0,  324, 
            0,    0,  324,  324,    0,  324,    0,  324,    0,    0, 
            0,  324,    0,    0,    0,    0,    0,    0,    0,  324, 
            0,    0,    0,    0,  324,  324,  324,  324,  324,  324, 
            0,    0,    0,    0,    0,  324,  324,    0,  324,  324, 
            0,    0,    0,    0,    0,  510,  510,  510,  510,  510, 
          510,    0,    0,  510,  510,  510,    0,    0,    0,  510, 
            0,  510,  510,  510,  510,  510,  510,  510,  217,    0, 
            0,    0,  510,  510,  510,  510,  510,  510,  510,    0, 
            0,  510,    0,    0,    0,    0,    0,  510,  510,  510, 
          510,  510,  510,    0,    0,  510,  510,  510,  510,  510, 
          510,    0,    0,  510,  510,  510,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  218,    0,    0, 
            0,    0,    0,    0,    0,  510,    0,    0,  510,    0, 
            0,  510,  510,    0,  510,    0,  510,    0,    0,    0, 
          510,    0,    0,    0,    0,    0,    0,    0,  510,    0, 
            0,    0,    0,  510,  510,  510,  510,  510,  510,    0, 
            0,    0,    0,    0,  510,  510,    0,  510,  510,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  510,  510,  510,  510,  510, 
          510,    0,    0,    0,  510,  510,    0,    0,  365,  510, 
            0,  510,  510,  510,  510,  510,  510,  510,  365,    0, 
            0,    0,  510,  510,  510,  510,  510,  510,  510,    0, 
            0,  510,    0,    0,    0,    0,    0,  510,  510,  510, 
          510,  510,  510,    0,    0,  510,  510,  510,  510,  510, 
          510,    0,  365,  510,  510,  510,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  365,  365,    0,    0, 
            0,  365,    0,    0,    0,  510,    0,    0,  510,    0, 
            0,  510,  510,    0,  510,    0,  510,    0,    0,    0, 
          510,    0,    0,    0,    0,    0,    0,    0,  510,  365, 
            0,  510,    0,  510,  510,  510,  510,  510,  510,    0, 
            0,    0,    0,    0,  510,  510,    0,  510,  510,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,  438,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,  438,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,  438,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  438,  438,    0,   82,    0, 
          438,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,    0,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,   49,  438,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,  510,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  510,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          365,  365,  365,    0,    0,  365,  365,  365,    0,  365, 
            0,    0,    0,    0,    0,    0,    0,    0,  365,  365, 
          365,    0,  510,    0,    0,    0,    0,    0,  365,  365, 
            0,  365,  365,  365,  365,  365,  510,  510,    0,    0, 
            0,  510,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  365,  365,  365,  365,  365, 
          365,  365,  365,  365,  365,  365,  365,  365,  365,  510, 
            0,  365,  365,  365,    0,    0,  365,    0,    0,  365, 
            0,    0,  365,    0,  365,    0,  365,    0,  365,    0, 
          365,  365,  365,  365,  365,  365,  365,    0,  365,  365, 
          365,    0,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  274,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  438, 
          438,  438,    0,    0,  438,  438,  438,    0,  438,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  438,  438, 
            0,  274,    0,    0,    0,    0,    0,  438,  438,    0, 
          438,  438,  438,  438,  438,  274,  274,    0,   89,    0, 
          274,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  438,  438,  438,  438,  438,  438, 
          438,  438,  438,  438,  438,  438,  438,  438,  274,    0, 
          438,  438,  438,    0,  439,  438,    0,    0,  438,    0, 
            0,  438,    0,  438,    0,  438,    0,  438,  281,  438, 
          438,  438,  438,  438,  438,  438,    0,  438,  281,  438, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          510,  510,  510,    0,    0,  510,  510,  510,    0,  510, 
            0,    0,    0,    0,    0,    0,    0,    0,  510,  510, 
          510,    0,  281,    0,    0,    0,    0,    0,  510,  510, 
            0,  510,  510,  510,  510,  510,  281,  281,    0,   88, 
            0,  281,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,  510,  281, 
            0,  510,  510,  510,    0,    0,  510,    0,    0,  510, 
            0,    0,  510,    0,  510,    0,  510,    0,  510,    0, 
          510,  510,  510,  510,  510,  510,  510,    0,  510,  510, 
          510,    0,    0,    0,    0,    0,    0,  282,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  282,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  274, 
          274,  274,    0,    0,  274,  274,  274,    0,  274,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  274,  274, 
            0,  282,    0,    0,    0,    0,    0,  274,  274,    0, 
          274,  274,  274,  274,  274,  282,  282,    0,   83,    0, 
          282,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  282,    0, 
          274,  274,  274,    0,    0,  274,    0,    0,  274,    0, 
            0,  274,    0,  274,    0,  274,    0,  274,  388,  274, 
          274,  274,  274,  274,  274,  274,    0,  274,  388,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,    0,    0,  281,  281,  281,    0,  281, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  281, 
          281,    0,  388,    0,    0,    0,    0,    0,  281,  281, 
            0,  281,  281,  281,  281,  281,  388,  388,    0,    0, 
            0,  388,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  388, 
            0,  281,  281,  281,    0,    0,  281,    0,    0,  281, 
            0,    0,  281,    0,  281,    0,  281,    0,  281,    0, 
          281,  281,  281,  281,  281,  281,  281,    0,  281,    0, 
          281,    0,    0,    0,    0,    0,    0,  291,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  291,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  282, 
          282,  282,    0,    0,  282,  282,  282,    0,  282,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  282,  282, 
            0,  291,    0,    0,    0,    0,    0,  282,  282,    0, 
          282,  282,  282,  282,  282,  291,  291,    0,    0,    0, 
          291,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  291,    0, 
          282,  282,  282,    0,    0,  282,    0,    0,  282,    0, 
            0,  282,    0,  282,    0,  282,    0,  282,  217,  282, 
          282,  282,  282,  282,  282,  282,    0,  282,  217,  282, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          388,  388,  388,    0,    0,  388,  388,  388,    0,  388, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  388, 
          388,    0,  217,    0,    0,    0,    0,    0,  388,  388, 
            0,  388,  388,  388,  388,  388,  217,  217,    0,    0, 
            0,  217,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  388,  388,  388,  388,  388, 
          388,  388,  388,  388,  388,  388,  388,  388,  388,  323, 
            0,  388,  388,  388,    0,    0,  388,    0,    0,  388, 
            0,    0,  388,    0,  388,    0,  388,    0,  388,    0, 
          388,  388,  388,  388,  388,  388,  388,    0,  388,    0, 
          388,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  291, 
          291,  291,    0,    0,  291,  291,  291,    0,  291,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  291,  291, 
            0,  288,    0,    0,    0,    0,    0,  291,  291,    0, 
          291,  291,  291,  291,  291,  288,  288,    0,    0,    0, 
          288,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  291,  291,  291,  291,  291,  291, 
          291,  291,  291,  291,  291,  291,  291,  291,  288,    0, 
          291,  291,  291,    0,    0,  291,    0,    0,  291,    0, 
            0,  291,    0,  291,    0,  291,    0,  291,  425,  291, 
          291,  291,  291,  291,  291,  291,    0,  291,  425,  291, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,  217,  217,    0,    0,  217,  217,  217,    0,  217, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
          217,    0,  425,    0,    0,    0,    0,    0,  217,  217, 
            0,  217,  217,  217,  217,  217,  425,  425,    0,    0, 
            0,  425,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,  217,  217,  217,  217, 
          217,  217,  217,  217,  217,  217,  323,  217,  217,  425, 
            0,  217,  217,  323,    0,    0,  217,    0,    0,  217, 
            0,    0,  217,    0,  217,    0,  217,    0,  217,    0, 
          217,  217,  217,  217,  217,  217,  217,    0,  217,    0, 
          217,    0,    0,    0,    0,    0,    0,  426,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  426,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  288, 
          288,  288,    0,    0,  288,  288,  288,    0,  288,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  288,  288, 
            0,  426,    0,    0,    0,    0,    0,  288,  288,    0, 
          288,  288,  288,  288,  288,  426,  426,    0,    0,    0, 
          426,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  288,  288,  288,  288,  288,  288, 
          288,  288,  288,  288,  288,  288,  288,  288,  426,    0, 
          288,  288,  288,    0,    0,  288,    0,    0,  288,    0, 
            0,  288,    0,  288,    0,  288,    0,  288,  319,  288, 
          288,  288,  288,  288,  288,  288,    0,  288,  319,  288, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          425,  425,  425,    0,    0,  425,  425,  425,    0,  425, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  425, 
          425,    0,  319,    0,    0,    0,    0,    0,  425,  425, 
            0,  425,  425,  425,  425,  425,  319,  319,    0,    0, 
            0,  319,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  425,  425,  425,  425, 
          425,  425,  425,  425,  425,  425,  425,  425,  425,  319, 
            0,  425,  425,  425,    0,    0,  425,    0,    0,  425, 
            0,    0,  425,    0,  425,    0,  425,    0,  425,    0, 
          425,  425,  425,  425,  425,  425,  425,    0,  425,    0, 
          425,    0,    0,    0,    0,    0,    0,  320,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  320,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  426, 
          426,  426,    0,    0,  426,  426,  426,    0,  426,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  426,  426, 
            0,  320,    0,    0,    0,    0,    0,  426,  426,    0, 
          426,  426,  426,  426,  426,  320,  320,    0,    0,    0, 
          320,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  426,  426,  426,  426,  426, 
          426,  426,  426,  426,  426,  426,  426,  426,  320,    0, 
          426,  426,  426,    0,    0,  426,    0,    0,  426,    0, 
            0,  426,    0,  426,    0,  426,    0,  426,  285,  426, 
          426,  426,  426,  426,  426,  426,    0,  426,  285,  426, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,  319,  319,    0,    0,  319,  319,  319,    0,  319, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  319, 
            0,    0,  285,    0,    0,    0,    0,    0,  319,  319, 
            0,  319,  319,  319,  319,  319,  285,  285,    0,    0, 
            0,  285,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  319,  319,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  285, 
            0,  319,  319,  319,    0,    0,  319,    0,    0,  319, 
            0,    0,    0,    0,    0,    0,  319,    0,  319,    0, 
          319,  319,  319,  319,  319,  319,  319,    0,  319,    0, 
          319,    0,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
          320,  320,    0,    0,  320,  320,  320,    0,  320,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,  195,    0,    0,    0,    0,    0,  320,  320,    0, 
          320,  320,  320,  320,  320,  195,  195,    0,    0,    0, 
          195,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,    0,    0, 
          320,  320,  320,    0,    0,  320,    0,    0,  320,    0, 
            0,    0,    0,    0,    0,  320,    0,  320,  191,  320, 
          320,  320,  320,  320,  320,  320,    0,  320,  191,  320, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          285,  285,  285,    0,    0,  285,  285,  285,    0,  285, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  285, 
            0,    0,  191,    0,    0,    0,    0,    0,  285,  285, 
            0,  285,  285,  285,  285,  285,  191,  191,    0,    0, 
            0,  191,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,  285,  285,    0, 
            0,  285,  285,  285,    0,    0,  285,    0,    0,  285, 
            0,    0,    0,    0,    0,    0,  285,    0,  285,    0, 
          285,  285,  285,  285,  285,  285,  285,    0,  285,    0, 
          285,    0,    0,    0,    0,    0,    0,  188,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  188,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  195, 
          195,  195,    0,    0,  195,  195,  195,    0,  195,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  195,  195, 
            0,  188,    0,    0,    0,    0,    0,  195,  195,    0, 
          195,  195,  195,  195,  195,  188,  188,    0,    0,    0, 
          188,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  195,  195,  195,  195,  195, 
          195,  195,  195,  195,  195,    0,  195,  195,    0,    0, 
          195,  195,    0,    0,    0,  195,    0,    0,  195,    0, 
            0,  195,    0,  195,    0,  195,    0,  195,  190,  195, 
          195,  195,  195,  195,  195,  195,    0,  195,  190,  195, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          191,  191,  191,    0,    0,  191,  191,  191,    0,  191, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  191, 
          191,    0,  190,    0,    0,    0,    0,    0,  191,  191, 
            0,  191,  191,  191,  191,  191,  190,  190,    0,    0, 
            0,  190,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  191,  191,  191,  191, 
          191,  191,  191,  191,  191,  191,    0,  191,  191,    0, 
            0,  191,  191,    0,    0,    0,  191,    0,    0,  191, 
            0,    0,  191,    0,  191,    0,  191,    0,  191,    0, 
          191,  191,  191,  191,  191,  191,  191,    0,  191,    0, 
          191,    0,    0,    0,    0,    0,    0,  189,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  188, 
          188,  188,    0,    0,  188,  188,  188,    0,  188,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  188,  188, 
            0,  189,    0,    0,    0,    0,    0,  188,  188,    0, 
          188,  188,  188,  188,  188,  189,  189,    0,    0,    0, 
          189,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  188,  188,  188,  188,  188, 
          188,  188,  188,  188,  188,    0,  188,  188,    0,    0, 
          188,  188,    0,    0,    0,  188,    0,    0,  188,    0, 
            0,  188,    0,  188,    0,  188,    0,  188,  192,  188, 
          188,  188,  188,  188,  188,  188,    0,  188,  192,  188, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          190,  190,  190,    0,    0,  190,  190,  190,    0,  190, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  190, 
          190,    0,  192,    0,    0,    0,    0,    0,  190,  190, 
            0,  190,  190,  190,  190,  190,  192,  192,    0,    0, 
            0,  192,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,  190,  190,  190, 
          190,  190,  190,  190,  190,  190,    0,  190,  190,    0, 
            0,  190,  190,    0,    0,    0,  190,    0,    0,  190, 
            0,    0,  190,    0,  190,    0,  190,    0,  190,    0, 
          190,  190,  190,  190,  190,  190,  190,    0,  190,    0, 
          190,    0,    0,    0,    0,    0,    0,  193,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  193,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
          189,  189,    0,    0,  189,  189,  189,    0,  189,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,  189, 
            0,  193,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,  189,  189,    0,  189,  189,  189,  189,  189, 
          193,  193,    0,    0,    0,  193,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          189,  189,  189,  189,  189,  189,  189,  189,  189,  189, 
            0,  189,  189,    0,    0,  189,  189,    0,    0,    0, 
          189,    0,    0,  189,    0,    0,  189,    0,  189,    0, 
          189,    0,  189,  438,  189,  189,  189,  189,  189,  189, 
          189,    0,  189,  438,  189,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  192,  192,  192,    0,    0, 
          192,  192,  192,    0,  192,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  192,  192,    0,   74,    0,    0, 
            0,    0,    0,  192,  192,    0,  192,  192,  192,  192, 
          192,    0,  438,    0,   82,    0,  438,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  192,  192,  192,  192,  192,  192,  192,  192,  192, 
          192,    0,  192,  192,  438,    0,  192,  192,    0,    0, 
            0,  192,    0,    0,  192,    0,    0,  192,    0,  192, 
            0,  192,    0,  192,    0,  192,  192,  192,  192,  192, 
          192,  192,    0,  192,    0,  192,    0,    0,    0,    0, 
            0,    0,  274,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  274,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  193,  193,  193,    0,    0,  193, 
          193,  193,    0,  193,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  193,  193,    0,   81,    0,    0,    0, 
            0,    0,  193,  193,    0,  193,  193,  193,  193,  193, 
            0,  274,    0,   89,    0,  274,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          193,  193,  193,  193,  193,  193,  193,  193,  193,  193, 
            0,  193,  193,  274,    0,  193,  193,    0,    0,    0, 
          193,    0,    0,  193,    0,    0,  193,    0,  193,    0, 
          193,    0,  193,  281,  193,  193,  193,  193,  193,  193, 
          193,    0,  193,  281,  193,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  438,  438,  438,    0,    0, 
            0,  438,  438,    0,  438,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   80,    0,    0, 
            0,    0,    0,  438,  438,    0,  438,  438,  438,  438, 
          438,    0,  281,    0,   88,    0,  281,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          438,  438,  438,  438,  438,  438,  438,  438,  438,  438, 
          438,  438,  438,  438,  281,    0,  438,  438,  438,    0, 
          439,    0,    0,    0,  438,    0,    0,    0,    0,    0, 
            0,  438,    0,  438,  282,  438,  438,  438,  438,  438, 
          438,  438,    0,  438,  282,  438,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  274,  274,  274,    0,   75,    0, 
          274,  274,    0,  274,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  282,    0,   83,    0,  282,    0,    0, 
            0,    0,  274,  274,    0,  274,  274,  274,  274,  274, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  282,    0,    0,    0,  274, 
          274,  274,  274,  274,  274,  274,  274,  274,  274,  274, 
          274,  274,  274,    0,  186,  274,  274,  274,    0,    0, 
            0,    0,    0,  274,  186,    0,    0,    0,    0,    0, 
          274,    0,  274,    0,  274,  274,  274,  274,  274,  274, 
          274,    0,  274,    0,  274,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  281,  281,  281,  186,    0, 
            0,  281,  281,    0,  281,    0,    0,    0,    0,    0, 
            0,    0,  186,  186,    0,    0,    0,  186,    0,    0, 
            0,    0,    0,  281,  281,    0,  281,  281,  281,  281, 
          281,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  281,    0,  187,  281,  281,  281,    0, 
            0,    0,    0,    0,  281,  187,    0,    0,    0,    0, 
            0,  281,    0,  281,    0,  281,  281,  281,  281,  281, 
          281,  281,    0,  281,    0,  281,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  282,  282,  282,  187, 
            0,    0,  282,  282,    0,  282,    0,    0,    0,    0, 
            0,    0,    0,  187,  187,    0,    0,    0,  187,    0, 
            0,    0,    0,    0,  282,  282,    0,  282,  282,  282, 
          282,  282,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  282,  282,    0,    0,  282,  282,  282, 
          211,    0,    0,    0,    0,  282,    0,    0,    0,    0, 
          211,    0,  282,    0,  282,    0,  282,  282,  282,  282, 
          282,  282,  282,    0,  282,    0,  282,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  186,  186,  186,    0, 
            0,  186,  186,  186,  211,  186,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  186,  186,    0,  211,  211, 
            0,    0,    0,  211,  186,  186,    0,  186,  186,  186, 
          186,  186,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  186,  186,  186,  186,  186,  186,  186,  186, 
          186,  186,    0,  186,  186,    0,  212,  186,  186,    0, 
            0,    0,  186,    0,    0,  186,  212,    0,  186,    0, 
          186,    0,    0,    0,  186,    0,    0,    0,  186,  186, 
          186,  186,  186,    0,  186,    0,  186,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  187,  187,  187, 
          212,    0,  187,  187,  187,    0,  187,    0,    0,    0, 
            0,    0,    0,    0,  212,  212,  187,  187,    0,  212, 
            0,    0,    0,    0,    0,  187,  187,    0,  187,  187, 
          187,  187,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  187,  187,  187,  187,  187,  187,  187, 
          187,  187,  187,    0,  187,  187,    0,  198,  187,  187, 
            0,    0,    0,  187,    0,    0,  187,  198,    0,  187, 
            0,  187,    0,    0,    0,  187,    0,    0,    0,  187, 
          187,  187,  187,  187,    0,  187,    0,  187,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  198,  211,  211,  211,    0,    0,  211,  211,  211, 
            0,  211,    0,    0,    0,  198,  198,    0,    0,    0, 
          198,  211,  211,    0,    0,    0,    0,    0,    0,    0, 
          211,  211,    0,  211,  211,  211,  211,  211,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  211,  211, 
          211,  211,  211,  211,  211,  211,  211,  211,    0,  211, 
          211,    0,  196,  211,  211,    0,    0,    0,  211,    0, 
            0,  211,  196,    0,  211,    0,  211,    0,    0,    0, 
          211,    0,    0,    0,    0,    0,  211,  211,  211,    0, 
          211,    0,  211,    0,    0,    0,    0,    0,  212,  212, 
          212,    0,    0,  212,  212,  212,  196,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,    0, 
          196,  196,    0,    0,    0,  196,  212,  212,    0,  212, 
          212,  212,  212,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  212,  212,  212,  212,  212,  212, 
          212,  212,  212,  212,    0,  212,  212,    0,  197,  212, 
          212,    0,    0,    0,  212,    0,    0,  212,  197,    0, 
          212,    0,  212,    0,    0,    0,  212,    0,    0,    0, 
            0,    0,  212,  212,  212,    0,  212,    0,  212,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
          198,  198,  197,    0,  198,  198,  198,    0,  198,    0, 
            0,    0,    0,    0,    0,    0,  197,  197,  198,  198, 
            0,  197,    0,    0,    0,    0,    0,  198,  198,    0, 
          198,  198,  198,  198,  198,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  198,  198,  198,  198,  198, 
          198,  198,  198,  198,  198,    0,  198,  198,    0,  201, 
            0,    0,    0,    0,    0,  198,    0,    0,  198,  201, 
            0,  198,    0,  198,    0,    0,    0,  198,    0,    0, 
            0,    0,    0,  198,  198,  198,    0,  198,    0,  198, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  201,  196,  196,  196,    0,    0,  196, 
          196,  196,    0,  196,    0,    0,    0,  201,  201,    0, 
            0,    0,  201,  196,  196,    0,    0,    0,    0,    0, 
            0,    0,  196,  196,    0,  196,  196,  196,  196,  196, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          196,  196,  196,  196,  196,  196,  196,  196,  196,  196, 
            0,  196,  196,    0,  203,    0,    0,    0,    0,    0, 
          196,    0,    0,  196,  203,    0,  196,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  196,  196, 
          196,    0,  196,    0,  196,    0,    0,    0,    0,    0, 
          197,  197,  197,    0,    0,  197,  197,  197,  203,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
          197,    0,  203,  203,    0,    0,    0,  203,  197,  197, 
            0,  197,  197,  197,  197,  197,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,  197,  197,  197, 
          197,  197,  197,  197,  197,  197,    0,  197,  197,    0, 
          202,    0,    0,    0,    0,    0,  197,    0,    0,  197, 
          202,    0,  197,    0,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  197,  197,  197,    0,  197,    0, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  201,  201,  201,  202,    0,  201,  201,  201,    0, 
          201,    0,    0,    0,    0,    0,    0,    0,  202,  202, 
          201,  201,    0,  202,    0,    0,    0,    0,    0,  201, 
          201,    0,  201,  201,  201,  201,  201,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  201,  201,  201, 
          201,  201,  201,  201,  201,  201,  201,    0,  201,  201, 
            0,  200,    0,    0,    0,    0,    0,  201,    0,    0, 
          201,  200,    0,  201,    0,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  201,  201,    0,    0,    0, 
            0,  201,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  200,  203,  203,  203,    0, 
            0,  203,  203,  203,    0,  203,    0,    0,    0,  200, 
          200,    0,    0,    0,  200,  203,  203,    0,    0,    0, 
            0,    0,    0,    0,  203,  203,    0,  203,  203,  203, 
          203,  203,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  203,  203,  203,  203,  203,  203,  203,  203, 
          203,  203,    0,  203,  203,    0,  204,    0,    0,    0, 
            0,    0,  203,    0,    0,  203,  204,    0,  203,    0, 
          203,    0,   32,    0,    0,    0,    0,    0,    0,    0, 
          203,  203,   32,    0,    0,    0,  203,    0,    0,    0, 
            0,    0,  202,  202,  202,    0,    0,  202,  202,  202, 
          204,  202,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  202,  202,    0,  204,  204,  262,    0,    0,  204, 
          202,  202,    0,  202,  202,  202,  202,  202,    0,    0, 
            0,   32,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  202,  202, 
          202,  202,  202,  202,  202,  202,  202,  202,    0,  202, 
          202,    0,  205,    0,    0,    0,    0,    0,  202,    0, 
            0,  202,  205,    0,  202,    0,  202,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  202,  202,    0,    0, 
            0,    0,  202,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,  200,  200,  205,    0,  200,  200, 
          200,    0,  200,    0,    0,    0,    0,    0,    0,    0, 
          205,  205,  200,  200,    0,  205,    0,    0,    0,    0, 
            0,  200,  200,    0,  200,  200,  200,  200,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,  206,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  206,    0,  200, 
          200,  200,  200,  200,  200,  200,  200,  200,  200,    0, 
          200,  200,    0,    0,    0,    0,    0,    0,    0,  200, 
            0,    0,  200,    0,    0,  200,    0,  200,    0,    0, 
            0,  206,    0,    0,    0,    0,    0,  200,  200,    0, 
            0,    0,    0,  200,    0,  206,  206,    0,    0,    0, 
          206,    0,    0,    0,    0,    0,    0,    0,  204,  204, 
          204,    0,    0,  204,  204,  204,    0,  204,    0,    0, 
            0,    0,  213,    0,   32,   32,   32,  204,  204,    0, 
           32,   32,  213,   32,    0,    0,  204,  204,    0,  204, 
          204,  204,  204,  204,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   32,   32,   32,   32,   32, 
            0,    0,    0,    0,    0,    0,  213,    0,    0,    0, 
          204,  204,    0,    0,    0,  204,  204,    0,    0,    0, 
          213,  213,    0,    0,  204,  213,    0,  204,    0,    0, 
          204,    0,  204,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   32,    0,    0,    0,  207,  204,    0, 
            0,    0,    0,    0,  205,  205,  205,  207,    0,  205, 
          205,  205,    0,  205,   32,    0,    0,    0,    0,    0, 
            0,    0,    0,  205,  205,    0,    0,    0,    0,    0, 
            0,    0,  205,  205,    0,  205,  205,  205,  205,  205, 
            0,  207,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,  207,    0,    0,    0, 
          207,    0,    0,    0,    0,    0,  205,  205,    0,    0, 
            0,  205,  205,    0,    0,    0,    0,    0,    0,    0, 
          205,    0,  208,  205,    0,    0,  205,    0,  205,  206, 
          206,  206,  208,    0,  206,  206,  206,    0,  206,    0, 
            0,    0,    0,    0,  205,    0,    0,    0,  206,  206, 
            0,    0,    0,    0,    0,    0,    0,  206,  206,    0, 
          206,  206,  206,  206,  206,    0,  208,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,  208,    0,    0,    0,  208,    0,    0,    0,    0, 
            0,  206,  206,    0,    0,    0,  206,  206,    0,    0, 
            0,    0,    0,    0,    0,  206,    0,  214,  206,    0, 
            0,  206,    0,  206,  213,  213,  213,  214,    0,  213, 
          213,  213,    0,  213,    0,    0,    0,    0,    0,  206, 
            0,    0,    0,  213,  213,    0,    0,    0,    0,    0, 
            0,    0,  213,  213,    0,  213,  213,  213,  213,  213, 
            0,  214,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  214,  214,    0,    0,    0, 
          214,    0,    0,    0,    0,    0,  213,  213,    0,    0, 
            0,  213,  213,    0,    0,    0,    0,    0,    0,    0, 
          213,    0,  184,  213,    0,    0,  213,    0,  213,  207, 
          207,  207,  184,    0,  207,  207,  207,    0,  207,    0, 
            0,    0,    0,    0,  213,    0,    0,    0,  207,  207, 
            0,    0,    0,    0,    0,    0,    0,  207,  207,  185, 
          207,  207,  207,  207,  207,    0,  184,    0,    0,  185, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          184,  184,    0,    0,    0,  184,    0,    0,    0,    0, 
            0,  207,  207,    0,    0,    0,  207,  207,    0,    0, 
            0,    0,    0,  185,    0,  207,    0,    0,  207,    0, 
            0,  207,    0,  207,  208,  208,  208,  185,  185,  208, 
          208,  208,  185,  208,    0,    0,    0,    0,    0,  207, 
            0,    0,    0,  208,  208,    0,    0,    0,    0,    0, 
            0,    0,  208,  208,  218,  208,  208,  208,  208,  208, 
            0,    0,    0,    0,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,  208,    0,    0, 
            0,  208,  208,    0,    0,    0,    0,    0,  218,    0, 
          208,    0,    0,  208,    0,    0,  208,    0,  208,  214, 
          214,  214,  218,  218,  214,  214,  214,    0,  214,    0, 
            0,    0,    0,    0,  208,    0,    0,    0,  214,  214, 
            0,    0,    0,    0,    0,    0,    0,  214,  214,  215, 
          214,  214,  214,  214,  214,    0,    0,    0,    0,  215, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  214,    0,    0,    0,  214,  214,    0,    0, 
            0,    0,    0,  215,    0,  214,    0,    0,  214,    0, 
            0,  214,    0,  214,  184,  184,  184,  215,  215,  184, 
          184,  184,    0,  184,    0,    0,    0,    0,    0,  214, 
            0,    0,    0,  184,  184,    0,    0,    0,    0,    0, 
            0,    0,  184,  184,  183,  184,  184,  184,  184,  184, 
            0,  185,  185,  185,  183,    0,  185,  185,  185,    0, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          185,  185,    0,    0,    0,    0,    0,    0,    0,  185, 
          185,  176,  185,  185,  185,  185,  185,    0,  183,    0, 
          184,  176,    0,  184,    0,    0,  184,    0,  184,    0, 
            0,    0,  183,  183,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  184,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  176,    0,  185,    0,    0, 
          185,    0,    0,  185,    0,  185,  218,  218,  218,  176, 
          176,  218,  218,  218,    0,  218,    0,    0,    0,    0, 
            0,  185,    0,    0,    0,  218,  218,    0,    0,    0, 
            0,    0,    0,    0,  218,  218,  182,  218,  218,  218, 
          218,  218,    0,    0,    0,    0,  182,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  216,    0,    0,    0,    0,    0,    0, 
          182,    0,  218,  216,    0,  218,    0,    0,  218,    0, 
          218,  215,  215,  215,  182,  182,  215,  215,  215,    0, 
          215,    0,    0,    0,    0,    0,  218,    0,    0,    0, 
          215,  215,    0,    0,    0,    0,    0,  216,    0,  215, 
          215,    0,  215,  215,  215,  215,  215,    0,    0,    0, 
            0,  216,  216,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  178,    0, 
            0,    0,    0,    0,    0,    0,    0,  215,  178,    0, 
          215,    0,    0,  215,    0,  215,  183,  183,  183,    0, 
            0,  183,  183,  183,    0,  183,    0,    0,    0,    0, 
            0,  215,    0,    0,    0,  183,  183,    0,    0,    0, 
            0,    0,  178,    0,  183,  183,    0,  183,  183,  183, 
          183,  183,    0,  176,  176,  176,  178,  178,  176,  176, 
          176,    0,  176,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  176,  176,    0,    0,    0,    0,    0,    0, 
            0,  176,  176,  179,  176,  176,  176,  176,  176,    0, 
            0,    0,  183,  179,    0,  183,    0,    0,  183,    0, 
          183,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  183,    0,    0,    0, 
          180,    0,    0,    0,    0,    0,    0,  179,    0,  176, 
          180,    0,  176,    0,    0,  176,    0,  176,  182,  182, 
          182,  179,  179,  182,  182,  182,    0,  182,    0,    0, 
            0,    0,    0,  176,    0,    0,    0,  182,  182,    0, 
            0,    0,    0,    0,  180,    0,  182,  182,    0,  182, 
          182,  182,  182,  182,    0,  216,  216,  216,  180,  180, 
          216,  216,  216,    0,  216,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  216,  216,    0,    0,    0,    0, 
            0,    0,    0,  216,  216,  181,  216,  216,  216,  216, 
          216,    0,    0,    0,  182,  181,    0,  182,    0,    0, 
          182,    0,  182,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  182,    0, 
            0,    0,  175,    0,    0,    0,    0,    0,    0,  181, 
            0,  216,  175,    0,  216,    0,    0,  216,    0,  216, 
          178,  178,  178,  181,  181,  178,  178,  178,    0,  178, 
            0,    0,    0,    0,    0,  216,    0,    0,    0,  178, 
          178,    0,    0,    0,    0,    0,  175,    0,  178,  178, 
            0,  178,  178,  178,  178,  178,    0,    0,    0,    0, 
          175,  175,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  177,    0,    0, 
            0,    0,    0,    0,    0,    0,  178,  177,    0,  178, 
            0,    0,  178,    0,  178,  179,  179,  179,    0,    0, 
          179,  179,  179,    0,  179,    0,    0,    0,    0,    0, 
          178,    0,    0,    0,  179,  179,    0,    0,    0,    0, 
            0,  177,    0,  179,  179,    0,  179,  179,  179,  179, 
          179,    0,  180,  180,  180,  177,  177,  180,  180,  180, 
            0,  180,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  180,  180,    0,    0,    0,    0,    0,    0,    0, 
          180,  180,  262,  180,  180,  180,  180,  180,    0,    0, 
            0,  179,  262,    0,  179,    0,    0,  179,    0,  179, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  179,    0,    0,    0,  174, 
            0,    0,    0,    0,    0,    0,  262,    0,  180,  174, 
            0,  180,    0,    0,  180,    0,  180,  181,  181,  181, 
          262,  262,  181,  181,  181,    0,  181,    0,    0,    0, 
            0,    0,  180,    0,    0,    0,  181,  181,    0,    0, 
            0,    0,    0,  174,    0,  181,  181,    0,  181,  181, 
          181,  181,  181,    0,  175,  175,  175,  174,  174,  175, 
          175,  175,    0,  175,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  175,  175,    0,    0,    0,    0,    0, 
            0,    0,  175,  175,  263,  175,  175,  175,  175,  175, 
            0,    0,    0,  181,  263,    0,  181,    0,    0,  181, 
            0,  181,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  181,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  263,    0, 
          175,    0,    0,  175,    0,    0,  175,    0,  175,  177, 
          177,  177,  263,  263,  177,  177,  177,    0,  177,    0, 
            0,    0,    0,    0,  175,    0,    0,    0,  177,  177, 
            0,    0,    0,    0,    0,    0,    0,  177,  177,    0, 
          177,  177,  177,  177,  177,    0,  824,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  177,    0,    0,  177,    0, 
            0,  177,    0,  177,  262,  262,  262,    0,    0,  262, 
          262,  262,    0,  262,    0,    0,    0,    0,    0,  177, 
            0,    0,    0,  262,  262,    0,    0,    0,    0,    0, 
            0,    0,  262,  262,    0,  262,  262,  262,  262,  262, 
            0,  174,  174,  174,    0,    0,  174,  174,  174,    0, 
          174,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          174,  174,    0,    0,    0,    0,    0,    0,    0,  174, 
          174,    0,  174,  174,  174,  174,    0,    0,    0,  891, 
            0,    0,    0,  262,    0,    0,  262,    0,  262,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  262,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  174,    0,    0, 
          174,    0,    0,  174,    0,  174,  263,  263,  263,    0, 
            0,  263,  263,  263,    0,  263,    0,    0,    0,    0, 
            0,  174,    0,    0,    0,  263,  263,    0,    0,    0, 
            0,    0,    0,    0,  263,  263,    0,  263,  263,  263, 
          263,  263,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   96,   97,   17, 
           18,    0,    0,    0,    0,   98,   99,  100,   22,   23, 
           24,   25,    0,    0,    0,  263,    0,    0,  263,    0, 
          263,  101,    0,    0,   31,   32,    0,  397,   33,   34, 
           35,   36,   37,   38,    0,    0,  263,    0,  104,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  795,    0, 
            0,  107,    0,    0,   44,   45,    0,   46,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  101,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,    0, 
            0,  104,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  795,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   42,    0,    0,   43,    0,    0, 
           44,   45,    0,   46,    0,   47,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,   49,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    3,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,    0,    0,   33,   34, 
           35,   36,   37,   38,    0,    0,   39,   40,   41,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   42,    0, 
            0,  264,    0,    0,   44,   45,    0,   46,    0,   47, 
            0,    0,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,   49,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   42,    0,    0,   43,    0,    0,   44,   45,    0, 
           46,    0,   47,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,   49,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,  413, 
           44,   45,    0,   46,    0,  232,    0,  233,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,    0,    0,   44,   45,    0,   46,    0,  621,    0, 
          233,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
           49,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  232,    0,  233,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   20,   21,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,   39,   40,   41,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,  107,    0,    0,  415,   45,    0,   46,    0,  232, 
            0,  233,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,  234,    0,    0,    0,    0,   50,   51,   52,   53, 
           54,   55,    0,    0,    0,    0,    0,   56,   57,    0, 
           58,   59,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,  613,    0,  233,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   99,  100,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,  617,    0,  233,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   20,   21,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,    0,    0,   44,   45,    0,   46,    0,  613,    0, 
          233,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   99,  100, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  812,    0,  233,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,   39,   40,   41,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  107,    0,    0,   44, 
           45,    0,   46,    0,  816,    0,  233,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,  234,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,   39,   40,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  107, 
            0,    0,   44,   45,    0,   46,    0,  820,    0,  233, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,    0,   39,   40,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  208, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
          885,    0,  233,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,  234,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
           39,   40,   41,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,  887,    0,  233,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,   39,   40,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  208,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,  907,    0,  233,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,  234,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  252, 
          252,  252,    0,  252,    0,    0,    0,  252,  252,    0, 
            0,    0,  252,    0,  252,  252,  252,  252,  252,  252, 
          252,    0,    0,    0,    0,  252,  252,  252,  252,  252, 
          252,  252,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  252,    0,    0,  252,  252,    0,    0,  252,  252, 
          252,  252,  252,  252,    0,    0,  252,  252,  252,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
            0,  252,    0,    0,  252,  252,    0,  252,    0,  252, 
            0,  252,    0,  252,    0,    0,    0,    0,    0,    0, 
            0,  252,    0,    0,    0,    0,  252,  252,  252,  252, 
          252,  252,    0,    0,    0,    0,    0,  252,  252,    0, 
          252,  252,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,   49,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   96,   97,   17,   18,    0,    0,    0, 
            0,   98,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,  269,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,   39,   40,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
          107,  427,    0,   44,   45,    0,   46,    0,    0,    0, 
            0,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
          234,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,    0,    0, 
           33,   34,   35,   36,   37,   38,    0,    0,   39,   40, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,  529,    0,    0,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,   39,   40,   41,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  208,    0,    0,  107,    0,    0,   44, 
           45,    0,   46,    0,  529,    0,    0,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,  234,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,   39,   40,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,  107, 
            0,    0,   44,   45,    0,   46,    0,  595,    0,    0, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,    0,    0,   33, 
           34,   35,   36,   37,   38,    0,    0,   39,   40,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  208, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
          644,    0,    0,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,  234,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
           39,   40,   41,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,  777,    0,    0,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,   39,   40,   41,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  208,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,  806,    0,    0,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,  234,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  501, 
          501,  501,    0,  501,    0,    0,    0,  501,  501,    0, 
            0,    0,  501,    0,  501,  501,  501,  501,  501,  501, 
          501,    0,    0,    0,    0,  501,  501,  501,  501,  501, 
          501,  501,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  501,    0,    0,  501,  501,    0,    0,  501,  501, 
          501,  501,  501,  501,    0,    0,  501,  501,  501,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  501,    0, 
            0,  501,  501,    0,  501,  501,    0,  501,    0,    0, 
            0,    0,    0,  501,    0,    0,    0,    0,    0,    0, 
            0,  501,    0,    0,    0,    0,  501,  501,  501,  501, 
          501,  501,    0,    0,    0,    0,    0,  501,  501,    0, 
          501,  501,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           96,   97,   17,   18,    0,    0,    0,    0,   98,   99, 
          100,   22,   23,   24,   25,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,    0, 
            0,   33,   34,   35,   36,   37,   38,    0,    0,   39, 
           40,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  107,    0,    0,   44,   45,    0, 
           46,    0,    0,    0,    0,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,   50, 
           51,   52,   53,   54,   55,    0,    0,    0,    0,    0, 
           56,   57,    0,   58,   59,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,    0,    0,   33,   34,   35,   36,   37,   38, 
            0,    0,   39,   40,   41,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,    0,  107,    0,    0, 
           44,   45,    0,   46,    0,    0,    0,    0,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,  234,    0,    0, 
            0,    0,   50,   51,   52,   53,   54,   55,    0,    0, 
            0,    0,    0,   56,   57,    0,   58,   59,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   96,   97,   17,   18, 
            0,    0,    0,    0,   98,   99,  100,   22,   23,   24, 
           25,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          101,    0,    0,   31,   32,    0,    0,   33,   34,   35, 
           36,   37,   38,    0,    0,    0,    0,  104,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  279,    0,    0, 
          352,    0,    0,   44,   45,    0,   46,    0,  867,    0, 
          868,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,   52,   53,   54, 
           55,    0,    0,    0,    0,    0,   56,   57,    0,   58, 
           59,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   96, 
           97,   17,   18,    0,    0,    0,    0,   98,   99,  100, 
           22,   23,   24,   25,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,   31,   32,    0,    0, 
          102,   34,   35,   36,  103,   38,    0,    0,    0,    0, 
          104,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  105,    0,    0, 
          106,    0,    0,  107,    0,    0,   44,   45,    0,   46, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,   51, 
           52,   53,   54,   55,    0,    0,    0,    0,    0,   56, 
           57,    0,   58,   59,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   96,   97,   17,   18,    0,    0,    0,    0, 
           98,   99,  100,   22,   23,   24,   25,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  101,    0,    0,   31, 
           32,    0,    0,   33,   34,   35,   36,   37,   38,    0, 
            0,    0,    0,  104,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,   43,    0,    0,   44, 
           45,    0,   46,    0,   47,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,   52,   53,   54,   55,    0,    0,    0, 
            0,    0,   56,   57,    0,   58,   59,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   96,   97,   17,   18,    0, 
            0,    0,    0,   98,   99,  100,   22,   23,   24,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  101, 
            0,    0,   31,   32,    0,    0,   33,   34,   35,   36, 
           37,   38,    0,    0,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  279,    0,    0,  352, 
            0,    0,   44,   45,    0,   46,    0,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,   52,   53,   54,   55, 
            0,    0,    0,    0,    0,   56,   57,    0,   58,   59, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   96,   97, 
           17,   18,    0,    0,    0,    0,   98,   99,  100,   22, 
           23,   24,   25,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  101,    0,    0,   31,   32,    0,    0,  102, 
           34,   35,   36,  103,   38,    0,    0,    0,    0,  104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  106, 
            0,    0,  107,    0,    0,   44,   45,    0,   46,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,   52, 
           53,   54,   55,    0,    0,    0,    0,    0,   56,   57, 
            0,   58,   59,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   96,   97,   17,   18,    0,    0,    0,    0,   98, 
           99,  100,   22,   23,   24,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  101,    0,    0,   31,   32, 
            0,    0,   33,   34,   35,   36,   37,   38,    0,    0, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  279,    0,    0,  107,    0,    0,   44,   45, 
            0,   46,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           50,   51,   52,   53,   54,   55,    0,    0,    0,    0, 
            0,   56,   57,    0,   58,   59,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   96,   97,   17,   18,    0,    0, 
            0,    0,   98,   99,  100,   22,   23,   24,   25,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  101,    0, 
            0,   31,   32,    0,    0,   33,   34,   35,   36,   37, 
           38,    0,    0,    0,    0,  104,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  795,    0,    0,  107,    0, 
            0,   44,   45,    0,   46,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,   52,   53,   54,   55,    0, 
            0,    0,    0,    0,   56,   57,    0,   58,   59,  116, 
          117,  118,  119,  120,  121,  122,  123,    0,    0,  124, 
          125,  126,  127,  128,    0,    0,  129,  130,  131,  132, 
          133,  134,  135,    0,    0,  136,  137,  138,  192,  193, 
          194,  195,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  196,  197,    0,    0,  198,  158, 
          252,    0,  199,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,    0,    0,  186,   50,  116,  117,  118, 
          119,  120,  121,  122,  123,    0,    0,  124,  125,  126, 
          127,  128,    0,    0,  129,  130,  131,  132,  133,  134, 
          135,    0,    0,  136,  137,  138,  192,  193,  194,  195, 
          143,  144,  145,  146,  147,  148,  149,  150,  151,  152, 
          153,  154,  196,  197,    0,    0,  198,  158,    0,    0, 
          199,    0,    0,    0,  160,  161,    0,  162,  163,  164, 
          165,    0,  166,  167,    0,    0,  168,    0,    0,    0, 
            0,  169,  170,  171,  172,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  174,  175,    0, 
          176,  177,  178,  179,  180,  181,  182,  183,  184,    0, 
          185,    0,    0,  186,   50,  116,  117,  118,  119,  120, 
          121,  122,  123,    0,    0,  124,  125,  126,  127,  128, 
            0,    0,  129,  130,  131,  132,  133,  134,  135,    0, 
            0,  136,  137,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,    0,    0,  157,  158,   35,   36,  159,   38, 
            0,    0,  160,  161,    0,  162,  163,  164,  165,    0, 
          166,  167,    0,    0,  168,    0,    0,    0,    0,  169, 
          170,  171,  172,    0,    0,    0,    0,    0,  173,    0, 
            0,    0,    0,    0,    0,  174,  175,    0,  176,  177, 
          178,  179,  180,  181,  182,  183,  184,    0,  185,    0, 
            0,  186,  116,  117,  118,  119,  120,  121,  122,  123, 
            0,    0,  124,  125,  126,  127,  128,    0,    0,  129, 
          130,  131,  132,  133,  134,  135,    0,    0,  136,  137, 
          138,  192,  193,  194,  195,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  196,  197,    0, 
            0,  198,  158,  287,  288,  199,  289,    0,    0,  160, 
          161,    0,  162,  163,  164,  165,    0,  166,  167,    0, 
            0,  168,    0,    0,    0,    0,  169,  170,  171,  172, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  174,  175,    0,  176,  177,  178,  179,  180, 
          181,  182,  183,  184,    0,  185,    0,    0,  186,  116, 
          117,  118,  119,  120,  121,  122,  123,    0,    0,  124, 
          125,  126,  127,  128,    0,    0,  129,  130,  131,  132, 
          133,  134,  135,    0,    0,  136,  137,  138,  192,  193, 
          194,  195,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  196,  197,    0,    0,  198,  158, 
            0,    0,  199,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  511,  512,  186,    0,  513,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  516,  517, 
          186,    0,  518,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  523,  512,  186,    0,  524,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  548,  517, 
          186,    0,  549,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  586,  512,  186,    0,  587,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  588,  517, 
          186,    0,  589,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  604,  512,  186,    0,  605,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  606,  517, 
          186,    0,  607,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  646,  512,  186,    0,  647,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  648,  517, 
          186,    0,  649,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,  875,  512,  186,    0,  876,    0,    0, 
            0,  160,  161,    0,  162,  163,  164,  165,    0,  166, 
          167,    0,    0,  168,    0,    0,    0,    0,  169,  170, 
          171,  172,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  174,  175,    0,  176,  177,  178, 
          179,  180,  181,  182,  183,  184,    0,  185,  877,  517, 
          186,    0,  878,    0,    0,    0,  160,  161,    0,  162, 
          163,  164,  165,    0,  166,  167,    0,    0,  168,    0, 
            0,    0,    0,  169,  170,  171,  172,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  174, 
          175,    0,  176,  177,  178,  179,  180,  181,  182,  183, 
          184,    0,  185,    0,    0,  186, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,    3,    4,    5,   91,   27,    8,    9,   10,   11, 
          216,  379,   14,   15,   16,   10,   11,   19,    7,   49, 
            6,  373,  371,  101,   26,  248,   32,    2,    3,    4, 
            5,    6,  393,    8,    4,    5,   15,   16,   27,   14, 
           19,   43,   44,   45,   14,   47,    7,   49,   15,   16, 
          344,  345,   19,  347,  348,   15,   16,  399,  346,   19, 
           47,   44,   11,   10,   50,   43,   27,   46,   43,   21, 
           21,   10,   47,   44,   10,  369,   10,   47,   61,   46, 
          571,  340,  370,  574,  264,   10,   91,  280,  411,   91, 
           10,   76,  386,  387,  106,   10,   61,   44,   10,   10, 
          388,    6,    7,  105,   10,  107,   10,   10,  402,  340, 
           62,   62,   59,   15,   16,  403,   91,   19,  325,   44, 
           59,   91,   27,  446,   44,   59,   10,   76,   10,  695, 
           10,  697,  107,  308,   59,  697,   10,   10,  432,   59, 
           10,   44,    3,   45,   10,   50,   58,   59,  100,  473, 
           10,  358,   10,   59,   58,   59,   59,  109,  290,  291, 
          454,   10,  111,   10,   44,   44,   16,  455,  361,   19, 
           10,   61,  352,  293,   10,   59,  361,  297,   58,   59, 
           10,    0,   61,   10,   58,   59,  510,  344,   10,   10, 
           32,   10,  270,  308,  309,   44,  311,  546,  372,   59, 
          375,  376,  372,  377,   91,  362,  310,  377,  560,  341, 
           10,   58,   59,   61,   44,   61,   10,   44,  567,   59, 
           32,  223,  224,   59,  592,   10,    2,    3,  223,  224, 
           10,  269,    8,  271,  219,  328,   58,   59,   59,   10, 
           59,    0,  335,  245,   44,  247,  248,  365,   91,  282, 
           44,    2,    3,    4,    5,  257,   61,    8,   58,   59, 
          375,  376,  264,   14,   58,   59,  245,   43,  247,  248, 
          219,   10,  838,   44,   59,  337,  838,  328,  245,   59, 
          247,  248,  257,   44,  335,  245,  264,  247,  248,  264, 
          306,   91,   43,  317,  310,  786,   47,   91,  789,  263, 
          264,  792,  337,  525,  526,  269,  308,  309,  310,  311, 
          312,  313,  314,  315,  309,  310,  311,  312,   44,  349, 
           59,  351,  256,  328,  348,  355,  356,   61,  352,  353, 
          335,  107,  269,  308,  271,  629,  630,  661,  313,   61, 
           91,  419,  420,  245,  346,  247,  248,  349,  468,  351, 
          352,  353,  355,  355,  356,  267,  107,  369,  341,  378, 
          379,  439,  440,  267,  370,  371,  353,  338,  370,  371, 
          372,  377,  264,   91,  352,  378,  341,  352,  353,  290, 
          291,  872,  384,  353,  351,  727,  388,  267,  355,  279, 
          392,  597,  394,  667,  341,  245,  371,  247,  248,  673, 
          279,  403,    2,    3,  426,  341,  729,  281,    8,  384, 
          633,  378,  735,  415,   14,  364,  341,  392,  338,  394, 
          267,  341,  356,  362,  264,  427,  341,  429,  395,  408, 
          779,  279,  310,  279,  338,  341,  415,  426,  341,  807, 
          345,  328,  794,   43,  346,  267,  807,  308,  335,  398, 
          399,  341,  313,  455,  429,  415,    0,  341,  338,  341, 
          290,  291,  328,  262,  369,  426,   10,  267,  370,  335, 
          328,  341,   44,  267,  279,  341,  554,  335,  263,  264, 
          280,  257,  387,  337,  264,  328,  388,   61,  264,  269, 
           59,  271,  335,  341,  843,  341,  269,  402,  271,  705, 
          269,  403,  271,  262,  263,  264,  257,  107,  338,  268, 
          269,  341,  271,  264,   91,   59,  279,  739,  740,   91, 
          337,  426,  310,  262,  263,  264,   44,  432,  328,  338, 
          269,   44,  308,   44,  328,  335,  341,  313,  861,   91, 
          340,  335,  317,  545,  546,   91,  340,  290,  291,  454, 
          545,   10,  846,  455,  576,   10,  337,  308,  358,  847, 
          361,  361,  313,  514,  358,  567,   44,  519,  519,    0, 
          657,  546,  378,  379,  525,  526,  352,  900,   91,  581, 
            0,  306,  341,  268,  269,   44,  280,  576,  317,  575, 
           10,  341,  567,  317,  543,  371,  802,  341,  550,   58, 
           59,  352,  353,  362,   59,  362,  581,  609,  384,  344, 
          328,   44,  690,   91,  609,  576,  392,  335,  394,  568, 
          371,  310,  347,  348,  349,  350,  293,  294,  295,  296, 
          297,  633,   91,  384,  664,  665,  372,   10,  346,   59, 
          670,  392,   44,  394,  372,  274,  340,  276,  277,  651, 
          349,  350,  340,  429,  633,  657,  658,  257,  660,   61, 
          269,  663,  664,  665,  264,  743,  267,  361,  670,  747, 
          575,  576,  263,  264,  370,  371,  651,  271,  429,  264, 
           44,  377,  657,  658,  380,  660,   59,  657,  663,   91, 
           52,   53,   44,   44,  341,   44,  370,  371,  372,  341, 
            0,   44,  704,  377,  362,  341,  708,  279,  308,  711, 
           10,   32,  337,  313,  337,  337,  711,  337,  262,  263, 
          264,  723,  724,  725,  268,  269,  344,  271,   44,  704, 
          341,  633,  344,  708,  704,  684,  264,   61,  306,   91, 
           91,  828,   91,   44,   44,  775,   44,    0,  723,  724, 
          725,  328,  352,  755,  756,  734,  328,   10,  335,   59, 
           61,  763,   44,  335,  306,  338,  279,  734,  340,   44, 
          546,  371,  338,  775,  734,  263,  328,  779,  727,  337, 
          755,  756,  328,  335,  384,  755,  756,  337,  763,  335, 
           91,  567,  392,  344,  394,  546,  337,  341,  800,  264, 
          264,  279,  280,   44,  779,  581,   59,  344,  267,  264, 
          370,  371,  372,  268,  269,  328,  567,  377,  362,  349, 
           44,   44,  335,  362,  341,  800,  828,  341,  344,  429, 
          581,  262,  263,  264,  341,  341,  337,  268,  269,  264, 
          271,  843,  262,  263,  264,  847,  341,  849,  268,  269, 
          328,  271,  264,  828,  856,  264,  337,  335,  828,  264, 
          362,  341,  340,  865,  358,  867,  868,   44,  843,  328, 
           10,  264,  362,  264,  849,  651,  335,  279,  280,  341, 
          859,  856,  658,  361,  660,   44,  338,  663,  890,  310, 
          865,  264,  867,  868,  264,  865,  269,  867,  868,  358, 
          651,  652,  904,  264,   44,   44,  657,  658,  910,  660, 
          341,   44,  663,  341,  349,  890,   44,  362,   58,   59, 
          890,  341,  264,  349,  264,  344,  328,  279,  279,  904, 
          279,  362,  708,  335,  904,  910,  264,   44,  340,  341, 
          910,  846,  362,  349,   44,  847,  546,  723,  724,  725, 
          349,   91,  344,  704,  362,  340,  358,  708,  271,  361, 
          341,  344,  262,  263,  264,  344,  362,  567,  268,  269, 
          341,  271,  723,  724,  725,  240,  328,  328,  279,  328, 
          362,  581,  341,  335,  335,  264,  335,  763,  344,   44, 
          290,  291,  358,  293,  294,  295,  296,  341,  358,   64, 
          358,  358,    5,  779,  755,  756,   61,  317,  358,  262, 
          263,  264,  763,  358,  881,  268,  269,    6,  271,  695, 
          794,   68,   15,   16,  800,  560,   19,  328,  779,   14, 
          848,  695,   76,   -1,  335,   -1,   91,    2,  348,  340, 
          341,  341,  352,  353,  354,  355,   39,   40,   -1,  800, 
           -1,  651,   45,   46,   -1,   48,   49,  358,  658,   -1, 
          660,   -1,  362,  663,  370,  371,  372,  843,    9,   10, 
           11,  377,   -1,  849,  370,  371,  372,  828,   43,   -1, 
          856,  377,   -1,   -1,  317,   26,   -1,   -1,  341,  370, 
          371,  372,  843,   -1,   -1,   10,  377,   -1,  849,   -1, 
          333,  334,   -1,   44,  704,  856,   -1,   -1,  708,  362, 
           -1,  370,  371,  372,  865,  348,  867,  868,  377,  352, 
          353,  354,  355,  723,  724,  725,   -1,  267,   -1,   44, 
          306,   -1,  308,  309,  310,  311,   10,   -1,   -1,  890, 
          405,   -1,  107,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  904,   -1,  755,  756,   -1,   -1,  910, 
           -1,   -1,   -1,  763,  105,   -1,   -1,   10,   -1,   -1, 
           44,  347,  348,  349,  350,   -1,   91,   -1,   -1,  779, 
           45,   46,   -1,   -1,   58,   59,   -1,   -1,  328,   -1, 
            2,    3,  317,   -1,   -1,  335,    8,    9,   10,   11, 
          800,   44,   -1,   15,   16,   -1,   -1,   19,  333,  334, 
           -1,   -1,   -1,   -1,   26,   58,   59,   91,  358,   -1, 
           -1,   -1,   -1,  348,  279,  350,   -1,  352,  353,  354, 
          355,   43,   44,   45,   44,   -1,   10,   49,   -1,  232, 
          233,  234,   -1,  843,   -1,   -1,   -1,   -1,   91,  849, 
           -1,   61,  245,   -1,  247,  248,  856,   -1,   -1,   -1, 
           -1,   -1,  255,   -1,   -1,  865,   -1,  867,  868,   -1, 
           44,   -1,   44,  328,   -1,   -1,  269,   -1,   -1,   -1, 
          335,   91,  223,  224,   58,   59,  341,   -1,   -1,   61, 
          890,   -1,  257,  105,   -1,  107,   -1,   -1,   -1,  264, 
           -1,   -1,   -1,  358,  904,   -1,   -1,   -1,   -1,   -1, 
          910,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   91, 
           -1,   -1,   -1,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,   -1, 
          615,   -1,  267,  346,   -1,   -1,  349,   -1,  351,   -1, 
          625,   -1,  355,  356,   -1,  280,   -1,   -1,  309,  310, 
          311,  312,   -1,  314,  315,   -1,   -1,  370,   -1,   -1, 
           -1,   -1,   -1,  248,   -1,  378,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,  267,   -1,  388,  389,  390,  391,   -1, 
           -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          403,  223,  224,  328,  407,  408,   -1,   -1,  411,  384, 
          335,   -1,  415,   -1,  267,  340,   -1,  392,   -1,  394, 
           -1,  372,   -1,  245,   -1,  247,  248,   -1,   -1,   -1, 
          433,  434,  435,  358,   -1,  257,  361,   -1,   44,   -1, 
          443,   -1,  264,  446,  328,  448,   -1,   -1,   -1,   -1, 
           -1,  335,  455,  728,  429,   -1,  731,  732,   -1,  279, 
          280,   -1,   -1,   -1,  415,   -1,   -1,   44,   -1,   -1, 
           -1,  346,   -1,   -1,  358,  328,  427,   -1,   -1,   -1, 
           -1,   -1,  335,  267,   -1,   91,  308,  309,  310,  311, 
          312,  313,  314,  315,   -1,  370,  280,  279,  280,   -1, 
           -1,   -1,   -1,  378,  379,  358,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,  388,   91,  335,   -1,   -1,   -1,   -1, 
          340,  341,   -1,   -1,  346,   -1,  529,  349,  403,  351, 
          352,   -1,   -1,  355,  356,   -1,   -1,   -1,  358,   -1, 
           -1,  361,  817,  818,  328,   -1,  328,   -1,  370,  371, 
          372,  335,   -1,  335,   -1,   -1,  340,   -1,  340,  341, 
           -1,   -1,  384,   -1,   -1,   -1,  388,   -1,   -1,   -1, 
          392,   -1,  394,   -1,  358,   -1,  358,  361,   -1,  361, 
          455,  403,  857,  858,   -1,   -1,   -1,   -1,  863,   -1, 
           -1,   -1,  595,  415,  545,   -1,   -1,  472,  473,   -1, 
           -1,   -1,   -1,   -1,   -1,  427,  581,  429,   -1,   -1, 
          613,  886,   -1,   -1,  617,   -1,  232,  233,  621,   -1, 
           -1,   -1,   -1,   -1,  899,   -1,   -1,  902,   44,   -1, 
          633,   -1,   44,  455,   -1,  510,  911,   44,   -1,  514, 
           -1,  644,   -1,   -1,   -1,   61,   -1,   -1,   -1,   61, 
          525,  526,   -1,  269,   61,   -1,   -1,   -1,  609,  662, 
           -1,  664,  665,   -1,   -1,   -1,   -1,  670,  671,   -1, 
           -1,   -1,  547,  279,  280,   91,  651,  680,  681,   91, 
           -1,   -1,   -1,  658,   91,  660,  689,   -1,  663,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  699,   -1,    0,   -1, 
           -1,   -1,  279,  280,  579,   -1,   -1,  582,   10,  584, 
           -1,  714,  715,  716,   -1,   -1,   -1,  592,    0,  722, 
           -1,   -1,  328,  545,  546,   -1,  729,   -1,   10,  335, 
           -1,  734,  735,  708,  340,  351,   -1,   -1,   -1,  355, 
           -1,   -1,   44,   -1,   -1,  567,   -1,   -1,  723,  724, 
          725,  328,   -1,   -1,   -1,  361,   58,   59,  335,  581, 
          711,   -1,  378,  340,  306,   -1,  308,  309,  310,  311, 
           -1,   -1,  775,   -1,  777,   -1,   58,   59,   -1,  395, 
           -1,   -1,   -1,   -1,  361,   -1,  661,  609,  763,   -1, 
           -1,  407,  408,   -1,   -1,  411,   -1,   -1,  340,  415, 
           -1,  804,   -1,  806,   -1,  347,  348,  349,  350,  812, 
           -1,  633,   -1,  816,   -1,   -1,   -1,  820,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  800,   -1,  443,   -1,  651, 
          446,   -1,  448,   -1,   -1,   -1,  658,  840,  660,   -1, 
           -1,  663,  664,  665,  847,   -1,   -1,    0,  670,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  859,   10,  861,   -1, 
           -1,   -1,   -1,  279,  739,  740,   -1,  279,   -1,   -1, 
           -1,   -1,  279,   -1,  849,   -1,   -1,   -1,   -1,   -1, 
           -1,  856,  885,   -1,  887,    0,  708,   -1,   -1,  711, 
           -1,   44,   -1,   -1,   -1,   10,   -1,  900,   -1,   -1, 
           -1,  723,  724,  725,  907,   58,   59,   -1,   -1,   -1, 
           63,   -1,  328,  529,   -1,   -1,  328,   -1,   -1,  335, 
           -1,  328,   -1,  335,   -1,  341,   -1,   -1,  335,  341, 
           -1,   -1,  807,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  763,  358,   58,   59,   -1,  358,   -1,   -1,   -1, 
           -1,  358,   -1,  775,   -1,   -1,   -1,  779,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,  847,   -1,   -1,   -1,   -1,   -1,  800,  595, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  293,  294,  295,  296,  297,   -1,  613,   -1,  281, 
          282,  617,   -1,   -1,   -1,  621,  881,  317,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  633,   -1,   -1, 
           -1,  843,   -1,  333,  334,  847,   -1,  849,  644,   -1, 
           -1,    0,   -1,   -1,  856,   -1,  338,   -1,  348,  341, 
          350,   10,  352,  353,  354,  355,   -1,   -1,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          362,   -1,  344,   -1,  346,  681,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  689,   -1,   44,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,  699,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  722,   -1,   -1,  262, 
          263,  264,   -1,  729,  267,  268,  269,   -1,  271,  735, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,    0,  271,   -1,   -1,   -1, 
           -1,  777,   -1,   -1,   -1,   10,  281,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,  293,  294, 
          295,  296,  297,   -1,   -1,  338,   -1,   -1,  341,   -1, 
          806,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   44, 
          816,   -1,   -1,   -1,  820,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   58,   59,   -1,   61,  317,   63,   -1, 
           -1,   -1,  322,  323,  840,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  859,   -1,  861,   91,  362,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  885, 
           -1,  887,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  900,   -1,   10,   -1,  257,  258, 
          259,  907,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   58,   59,  302,  303,   59,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,    0,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,   10,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,   58, 
           59,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,    0,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   10,   -1, 
          375,  376,   -1,  378,  379,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   91, 
           -1,  335,   -1,   -1,  341,   -1,  340,  344,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,   -1,   -1,   -1,   -1,  333, 
          334,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,  348,  344,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
            0,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   10,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  299,   58,   59, 
          302,  303,   59,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           44,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   63, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,    0,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   10,   -1,  375,  376,   -1,  378, 
          379,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,  306, 
           -1,  308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   91,   -1,   -1,  335,   -1, 
           -1,  341,   -1,  340,  344,   -1,   -1,   -1,   -1,   -1, 
          347,  348,  349,  350,  317,  318,  319,  320,  321,  322, 
          323,  324,  362,  326,  327,   -1,   -1,    0,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   10, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   58,   59,  302,  303,   59,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   58,   -1,  302, 
          303,   -1,   63,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
            0,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           10,   -1,  375,  376,   -1,  378,  379,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  306,   -1,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   91,   -1,   -1,  335,   -1,   -1,  341,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350, 
          317,  318,  319,  320,  321,  322,  323,   -1,  362,  326, 
          327,   -1,   -1,    0,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   10,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           58,   59,  302,  303,   59,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   63,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,    0,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   10,   -1,  375,  376, 
           -1,  378,  379,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,  306,   -1,  308,  309,  310,  311,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   91,   -1,   -1, 
          335,   -1,   -1,  341,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   10,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  299,   58,   59,  302,  303, 
           59,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,   -1,  293,  294,  295,  296,  297,   63,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,    0,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   10,   -1,  375,  376,   -1,  378,  379,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,   -1,  306,   -1,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   91,   -1,   -1,  335,   -1,   -1,  341, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   59,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  299,   59,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,    0,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   10,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
          362,   -1,   -1,  270,    0,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   10,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,   -1,   44,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  358,   -1,   -1,   -1,   91,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   10,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
          299,   59,   -1,  302,  303,   59,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,  340,  341,  342,  343,   -1,  345,   -1,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,    0,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   10,   -1,  375, 
          376,   -1,  378,  379,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   91,   -1, 
           -1,  335,   -1,  341,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,  256,  257,  258, 
          259,  260,  261,   -1,  362,   -1,  265,  266,   -1,   -1, 
            0,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   44,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   91,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,   58,   59,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   10,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   59,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
          340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   91,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   10,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,   -1,  341,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   59,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   10,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   59,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,  359,   -1,  361,   91,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   10,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   10,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   59,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,  339,  340,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   10,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           10,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   59, 
           -1,  306,   -1,  308,  309,  310,  311,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,  328,  342,  343,   -1,  345,   -1,  347, 
          335,   -1,   -1,  351,   -1,  340,   -1,   -1,  356,   -1, 
           -1,  359,  347,  348,  349,  350,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,  264,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   10,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,    0,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   10,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   44,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   91, 
           -1,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,    0,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   10,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   44,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   91,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  361, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,  337,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  361, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   91,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   91,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
          337,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,    0,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   44,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,    0,  333,  334,  335,   -1,   -1, 
           -1,   -1,   -1,  341,   10,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,    0,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   10,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
            0,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           10,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   44,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59, 
           -1,   -1,   -1,   63,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,    0,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,   -1,   -1,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  281,  282,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,    0,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,    0,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,   -1,   -1, 
          350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,    0,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   10,   -1, 
          344,   -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   44,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  281,  282, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,   -1,   -1,  350,   -1,   -1, 
           -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   44,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   58,   59,   -1,   -1,   -1,   63,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           10,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   44,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          281,  282,   -1,   63,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   10,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  356,  357,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          356,  357,   10,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   58,   59,   44,   -1,   -1,   63, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,    0,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   44,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,  281,  282,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1, 
           -1,   -1,   -1,  362,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,    0,   -1,  262,  263,  264,  281,  282,   -1, 
          268,  269,   10,  271,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1, 
           58,   59,   -1,   -1,  338,   63,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,    0,  362,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   10,   -1,  267, 
          268,  269,   -1,  271,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,    0,  341,   -1,   -1,  344,   -1,  346,  262, 
          263,  264,   10,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,    0,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   10,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,    0,  341,   -1,   -1,  344,   -1,  346,  262, 
          263,  264,   10,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,    0, 
          293,  294,  295,  296,  297,   -1,   44,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   58,   59,  267, 
          268,  269,   63,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,    0,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,  262, 
          263,  264,   58,   59,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,    0, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   58,   59,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,    0,  293,  294,  295,  296,  297, 
           -1,  262,  263,  264,   10,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,    0,  293,  294,  295,  296,  297,   -1,   44,   -1, 
          338,   10,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   58, 
           59,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,    0,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  338,   10,   -1,  341,   -1,   -1,  344,   -1, 
          346,  262,  263,  264,   58,   59,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   44,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  262,  263,  264,   58,   59,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,    0,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  338,   10,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  338, 
           10,   -1,  341,   -1,   -1,  344,   -1,  346,  262,  263, 
          264,   58,   59,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  262,  263,  264,   58,   59, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,    0,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,  338,   10,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  338,   10,   -1,  341,   -1,   -1,  344,   -1,  346, 
          262,  263,  264,   58,   59,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   44,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1,  341, 
           -1,   -1,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  262,  263,  264,   58,   59,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,    0,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  338,   10,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  338,   10, 
           -1,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           58,   59,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  262,  263,  264,   58,   59,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,    0,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,  338,   10,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,  262, 
          263,  264,   58,   59,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,  299,   -1,   -1,  302,  303,   -1,   59,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  362,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,  341, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,  340,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,   -1,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,   -1,   -1,  306,  307,  308,  309,  310,  311,   -1, 
           -1,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
           -1,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,   -1,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,   -1,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,   -1,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
           -1,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,   -1, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,   -1,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,   -1,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
          308,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,  363,  364,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,   -1,  322,  323,   -1,   -1,  326,   -1,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,  363,  364,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,   -1,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,   -1, 
          322,  323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,  363,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,   -1, 
           -1,  306,  307,  308,  309,  310,  311,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,   -1,  322,  323,   -1, 
           -1,  326,   -1,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,  363,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,   -1,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,   -1,  322, 
          323,   -1,   -1,  326,   -1,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,   -1,  322,  323,   -1,   -1,  326,   -1, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,  363, 
      };
   }

}
