/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.PLPInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;

final class ServerDTVImpl
extends DTVImpl {
    private int valueLength;
    private TDSReaderMark valueMark;
    private boolean isNull;
    int nIntValue;
    private static final int STREAMCONSUMED = -2;
    static final /* synthetic */ boolean $assertionsDisabled;

    ServerDTVImpl() {
    }

    void setValue(DTV dTV, TypeInfo typeInfo, int n, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        dTV.setImpl(new AppDTVImpl());
        dTV.setValue(typeInfo, n, object, object2, sQLServerConnection);
    }

    void setPositionAfterStreamed(TDSReader tDSReader) {
        this.valueMark = tDSReader.mark();
        this.valueLength = -2;
    }

    Object getSetterArgs() {
        return null;
    }

    boolean isNull() {
        return this.isNull;
    }

    int getJdbcType(TypeInfo typeInfo) throws SQLServerException {
        return DataTypes.nativeTypeToJdbcType(null, typeInfo.getNativeType(), typeInfo.getMaxLength());
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.valueMark) {
            this.getValuePrep(typeInfo, tDSReader);
        }
        tDSReader.reset(this.valueMark);
        if (this.valueLength != -2) {
            if (this.valueLength == -1) {
                if (!$assertionsDisabled && !typeInfo.isPLPType()) {
                    throw new AssertionError();
                }
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, bl, this);
                try {
                    if (null != pLPInputStream) {
                        pLPInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            } else {
                if (!$assertionsDisabled && this.valueLength < 0) {
                    throw new AssertionError();
                }
                tDSReader.skip(this.valueLength);
            }
        }
    }

    private final void getValuePrep(TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.valueMark) {
            if (typeInfo.isPLPType()) {
                this.valueMark = tDSReader.mark();
                PLPInputStream pLPInputStream = PLPInputStream.makeTempStream(tDSReader, false, null);
                tDSReader.reset(this.valueMark);
                this.valueLength = -1;
                if (null == pLPInputStream) {
                    this.isNull = true;
                } else {
                    this.isNull = false;
                    pLPInputStream = null;
                }
            } else {
                int n = typeInfo.getValueLengthSize();
                switch (n) {
                    case 0: {
                        this.valueLength = typeInfo.getMaxLength();
                        this.isNull = 0 == this.valueLength;
                        break;
                    }
                    case 1: {
                        this.valueLength = tDSReader.readUnsignedByte();
                        this.isNull = 0 == this.valueLength;
                        break;
                    }
                    case 2: {
                        this.valueLength = tDSReader.readUnsignedShort();
                        boolean bl = this.isNull = 65535 == this.valueLength;
                        if (!this.isNull) break;
                        this.valueLength = 0;
                        break;
                    }
                    case 4: {
                        if (35 == typeInfo.getTDSType() || 34 == typeInfo.getTDSType() || 99 == typeInfo.getTDSType()) {
                            boolean bl = this.isNull = 0 == tDSReader.readUnsignedByte();
                            if (this.isNull) {
                                this.valueLength = 0;
                                break;
                            }
                            tDSReader.skip(24);
                            this.valueLength = tDSReader.readInt();
                            break;
                        }
                        this.valueLength = tDSReader.readInt();
                        this.isNull = 0 == this.valueLength;
                        break;
                    }
                    default: {
                        tDSReader.throwInvalidTDS();
                    }
                }
                this.valueMark = tDSReader.mark();
            }
        }
    }

    Object getValue(DTV dTV, int n, boolean bl, int n2, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        this.nIntValue = 0;
        this.getValuePrep(typeInfo, tDSReader);
        boolean bl2 = false;
        if (!DataTypes.canConvertFromNativeTypeToJDBCType(typeInfo.getNativeType(), typeInfo.getMaxLength(), n)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{DataTypes.sqlNativeTypeToString(typeInfo.getNativeType()), Util.javaSqlTypeToString(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        if (-2 == this.valueLength) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_dataAlreadyAccessed"), null, 0, false);
        }
        if (this.isNull) {
            return null;
        }
        tDSReader.reset(this.valueMark);
        if (typeInfo.isPLPType()) {
            switch (typeInfo.getNativeType()) {
                case 165: 
                case 240: {
                    return DDC.binaryPLPToObject(tDSReader, n, inputStreamGetterArgs, this);
                }
                case 241: {
                    return DDC.xmlPLPToObject(tDSReader, n, inputStreamGetterArgs, this);
                }
                case 167: 
                case 231: {
                    return DDC.characterPLPToObject(tDSReader, typeInfo, n, inputStreamGetterArgs, this);
                }
            }
        }
        if (typeInfo.getNativeType() == 239 || typeInfo.getNativeType() == 231 || typeInfo.getNativeType() == 99) {
            return tDSReader.readUnicodeString(this.valueLength, n, inputStreamGetterArgs, this);
        }
        if (typeInfo.getNativeType() == 175 || typeInfo.getNativeType() == 167 || typeInfo.getNativeType() == 35) {
            return DDC.convertNonUnicodeNonPLPToObject(tDSReader, this.valueLength, typeInfo, n, inputStreamGetterArgs, this);
        }
        if (typeInfo.getNativeType() == 104 || typeInfo.getNativeType() == 10 || typeInfo.getNativeType() == 11 || typeInfo.getNativeType() == 38) {
            switch (this.valueLength) {
                case 8: {
                    long l = tDSReader.readLong();
                    if (bl) {
                        return DDC.convertLongToObject(l, n, inputStreamGetterArgs.streamType);
                    }
                    this.nIntValue = (int)l;
                    return null;
                }
                case 4: {
                    this.nIntValue = tDSReader.readInt();
                    break;
                }
                case 2: {
                    this.nIntValue = tDSReader.readShort();
                    break;
                }
                case 1: {
                    this.nIntValue = tDSReader.readUnsignedByte();
                }
            }
            if (bl) {
                return DDC.convertIntegerToObject(this.nIntValue, this.valueLength, n, inputStreamGetterArgs.streamType);
            }
            return null;
        }
        if (typeInfo.getNativeType() == 106 || typeInfo.getNativeType() == 108) {
            return tDSReader.readDecimal(this.valueLength, typeInfo, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 110 || typeInfo.getNativeType() == 14) {
            return tDSReader.readMoney(this.valueLength, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 109) {
            return tDSReader.readFloat(this.valueLength, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 16) {
            return tDSReader.readReal(this.valueLength, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 111 || typeInfo.getNativeType() == 12) {
            return tDSReader.readDateTime(this.valueLength, calendar, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 36) {
            return tDSReader.readGUID(this.valueLength, n, inputStreamGetterArgs.streamType);
        }
        if (typeInfo.getNativeType() == 34 || typeInfo.getNativeType() == 173 || typeInfo.getNativeType() == 165) {
            return tDSReader.readBinary(this.valueLength, n, inputStreamGetterArgs, this);
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        Object[] objectArray = new Object[]{DataTypes.sqlNativeTypeToString(typeInfo.getNativeType()), DataTypes.classNameFromJDBCType(n)};
        String string = messageFormat.format(objectArray);
        SQLServerException.makeFromDriverError(null, null, string, null, true);
        return null;
    }

    int getInt() {
        return this.nIntValue;
    }

    short getShort() {
        return (short)this.nIntValue;
    }

    byte getByte(DTV dTV, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        return (byte)dTV.getInt(typeInfo, tDSReader);
    }

    static {
        $assertionsDisabled = !ServerDTVImpl.class.desiredAssertionStatus();
    }
}

