complete -c j4-dmenu-desktop -f

# Source:
# https://github.com/fish-shell/fish-shell/blob/3.7.1/share/functions/__fish_contains_opt.fish
function __contains_opt -d "Checks if a specific option has been given in the current commandline"
    set -l next_short
    set -l short_opt
    set -l long_opt

    for i in $argv
        if test -n "$next_short"
            set next_short
            set -a short_opt $i
        else
            switch $i
                case -s
                    set next_short 1
                case '-*'
                    echo __fish_contains_opt: Unknown option $i >&2
                    return 1
                case '*'
                    set -a long_opt $i
            end
        end
    end

    for i in $short_opt
        if test -z "$i"
            continue
        end

        if string match -qr -- "^-$i|^-[^-]*$i" (commandline -cpo)
            return 0
        end

        if string match -qr -- "^-$i|^-[^-]*$i" (commandline -ct)
            return 0
        end
    end

    for i in $long_opt
        if test -z "$i"
            continue
        end

        if contains -- --$i (commandline -cpo)
            return 0
        end
    end

    return 1
end

# Source:
# https://github.com/fish-shell/fish-shell/blob/3.7.1/share/functions/__fish_complete_list.fish
function __complete_list --argument-names div cmd prefix iprefix
    if not set -q cmd[1]
        echo "Usage:
    __fish_complete_list <separator> <function> <prefix> <itemprefix>
where:
  separator - a symbol, separating individual entries
  function - a function which prints a completion list to complete each entry
  prefix - a prefix, which is printed before the list
  itemprefix - a prefix, which is printed before each item" >/dev/stderr
        return 1
    end
    set -q iprefix[1]
    or set -l iprefix ""
    set -q prefix[1]
    or set -l prefix ""
    set -l pat (commandline -t)
    #set -l pat $argv[5]
    switch $pat
        case "*$div*"
            for i in (echo $pat | sed "s/^\(.\+$div\)$iprefix.*\$/\1/")$iprefix(eval $cmd)
                echo $i
            end
        case '*'
            for i in $prefix$iprefix(eval $cmd)
                echo $i
            end
    end


end

function __desktop_file_quirks_list
    printf 'wine\tcompatibility with desktop files generated by Wine\n'
    printf 'multispace\taccept multiple spaces as argument separators in Exec\n'
end

complete -c j4-dmenu-desktop     -s b -l display-binary     -d "Display binary name after each entry"
complete -c j4-dmenu-desktop     -s f -l display-binary-base -d "Display basename of binary name after each entry"
complete -c j4-dmenu-desktop -Fr -s d -l dmenu              -d "Command used to invoke dmenu"
complete -c j4-dmenu-desktop          -l no-exec            -d "Do not execute selected command, send to stdout instead"
complete -c j4-dmenu-desktop          -l no-generic         -d "Do not include the generic name of desktop entries"
complete -c j4-dmenu-desktop -Fr -s t -l term               -d "Sets the terminal emulator used to start terminal apps"
complete -c j4-dmenu-desktop -x       -l term-mode -a "default xterm alacritty kitty terminator gnome-terminal custom" -d "Set terminal emulator execution strategy"
complete -c j4-dmenu-desktop -Fr      -l usage-log          -d "Set usage log"
complete -c j4-dmenu-desktop          -l prune-bad-usage-log-entries -d "Remove bad history entries"
complete -c j4-dmenu-desktop     -s x -l use-xdg-de         -d "Enables reading \$XDG_CURRENT_DESKTOP to determine the desktop environment"
complete -c j4-dmenu-desktop -Fr      -l wait-on            -d "Enable daemon mode"
complete -c j4-dmenu-desktop -Fr      -l wrapper            -d "A wrapper binary"
complete -c j4-dmenu-desktop     -s I -l i3-ipc             -d "Execute desktop entries through i3 IPC"
complete -c j4-dmenu-desktop          -l skip-i3-exec-check -d "Disable the check for '--wrapper \"i3 exec\"'"
complete -c j4-dmenu-desktop     -s i -l case-insensitive   -d "Sort applications case insensitively"
complete -c j4-dmenu-desktop     -s v                       -d "Be more verbose, can be specified multiple times"
complete -c j4-dmenu-desktop -x       -l log-level -a "ERROR WARNING INFO DEBUG" -d "Set loglevel"
complete -c j4-dmenu-desktop -Fr      -l log-file           -d "Specify a log file"
complete -c j4-dmenu-desktop -x       -l log-file-level -a "ERROR WARNING INFO DEBUG" -d "Set file loglevel"
complete -c j4-dmenu-desktop -x       -l desktop-file-quirks -n 'not __contains_opt strict-parsing' -a "(__complete_list , __desktop_file_quirks_list)" -d "Enable nonconformant desktop file parsing quirks"
complete -c j4-dmenu-desktop          -l strict-parsing -n 'not __contains_opt desktop-file-quirks' -d "Enable strict desktop file parsing"
complete -c j4-dmenu-desktop     -s h -l help               -d "Display help message"
complete -c j4-dmenu-desktop          -l version            -d "Display program version"
