<?php

//    listlinks.php
//    Shows a List of Links previously set with a form
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: listlinks.php,v 1.25 2004/06/29 10:06:25 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</a>";
   die;
}

$strSection=$strListofLinks;
$pagetitle = "Database: $dbname - " . $strSection;
eval("\$strhome = \"$strDBHome \";");
$linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</a>";

// A database has been selected

include ("./include/header.inc.php");

if (isset ($cmd))
{

   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;

   $strwhere = "";
   $otherinfo = '&cmd=' . urlencode($cmd);
   
   if (isset($linkresult) && $linkresult!="AllLinks")
   {
      $strwhere = $strwhere . "AND Link.LinkResult $whatlinkresult '$linkresult' ";
      $otherinfo = $otherinfo . '&whatlinkresult=' . urlencode($whatlinkresult)
         . '&linkresult=' . urlencode($linkresult);
   }
   
   if (isset($linktype) && $linktype!="AllLinks")
   {
      $strwhere = $strwhere . "AND Link.LinkType $whatlinktype '$linktype' ";
      $otherinfo = $otherinfo . '&whatlinktype=' . urlencode($whatlinktype)
         . '&linktype=' . urlencode($linktype);
   }

   if (isset($linkdomain) && $linkdomain!="AllLinks")
   {
      $strwhere = $strwhere . "AND Link.LinkDomain $whatlinkdomain '$linkdomain' ";
      $otherinfo = $otherinfo . '&whatlinkdomain=' . urlencode($whatlinkdomain)
         . '&linkdomain=' . urlencode($linkdomain);
   }

   $num=count($src); // Count the elements

   // Set the source filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($src[$i]) && $src[$i] && strlen($src[$i]) > 0)
      {
         if(isset($whatsrc[$i]))
         {
            $strwhere = $strwhere . "AND Url.Url " . $whatsrc[$i]
               . " '" . $src[$i] . "' ";
            $otherinfo = $otherinfo . "&whatsrc[$i]=" . urlencode($whatsrc[$i])
               . "&src[$i]=" . urlencode($src[$i]);
          }
      }
   }
   
   $num=count($dest); // Count the elements

   // Set the destination filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($dest[$i]) && $dest[$i] && strlen($dest[$i]) > 0)
      {
         if(isset($whatdest[$i]))
         {
            $strwhere = $strwhere . "AND Schedule.Url " . $whatdest[$i]
               . " '" . $dest[$i] . "' ";
            $otherinfo = $otherinfo . "&whatdest[$i]="
               . urlencode($whatdest[$i]) . "&dest[$i]=" . urlencode($dest[$i]);
          }
      }
   }

   $num=count($anchor); // Count the elements

   // Set the destination filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($anchor[$i]) && $anchor[$i] && strlen($anchor[$i]) > 0)
      {
         if(isset($whatanchor[$i]))
         {
            $strwhere = $strwhere . "AND Link.Anchor " . $whatanchor[$i]
               . " '" . $anchor[$i] . "' ";
            $otherinfo = $otherinfo . "&whatanchor[$i]="
               . urlencode($whatanchor[$i]) . "&anchor[$i]=" . urlencode($anchor[$i]);
          }
      }
   }

   // Show all the URLs, retrieved ones as well as not
   $strGenSQL = "SELECT Link.*, "
      . "Url.Url as UrlSrc, "
      . "Schedule.Url as UrlDest, "
      . "HtmlStatement.Statement "
      . "FROM Url, Schedule, Link "
      . "LEFT JOIN HtmlStatement "
      . "ON HtmlStatement.IDUrl = Link.IDUrlSrc "
      . "AND HtmlStatement.TagPosition = Link.TagPosition "
      . "WHERE Schedule.IDUrl = Link.IDUrlDest "
      . "AND Url.IDUrl = Link.IDUrlSrc "
      . $strwhere
      . " ORDER BY UrlSrc ASC "
      . " LIMIT " . $initpage . ", " . $pagesize;

   if (!isset($count))
   {
      $strCountSQL="select count(*) from Schedule, Url, Link "
         . "LEFT JOIN HtmlStatement "
         . "ON HtmlStatement.IDUrl = Link.IDUrlSrc "
         . "AND HtmlStatement.TagPosition = Link.TagPosition "
         . "WHERE Schedule.IDUrl = Link.IDUrlDest "
         . "AND Url.IDUrl = Link.IDUrlSrc "
         . $strwhere;

      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }

?>

<!--
<?php echo $strCountSQL; ?><br>
Records found: <?php echo $count; ?><br>
<?php echo $strGenSQL; ?><br>
-->


<?php

// HTTP results
   
?>
<h4><?php echo $strSection; ?></h4>
<p>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<br>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</p>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found

?>
<table>
<tr>
<th> N. </th>
<th> <?php echo $strReferencingUrl; ?> \ <?php echo $strReferencedUrl; ?> \ <?php echo $strHTMLStatement; ?> </th>
<th class="noprint"> <?php echo $strLinkType; ?> </th>
<th class="noprint"> <?php echo $strLinkResult; ?> </th>
<th class="noprint"><?php echo $strShow; ?></th>
</tr>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;

         // If HTML statement to be shown is too large, we cut it, depending
         // on MaxTagStrLenght setting in 'global.inc'
         $htmlstat = $row["Statement"];
         
         if (empty($htmlstat))
            $htmlstat = $strRedirection;
         else if (strlen($htmlstat) > $MaxTagStrLength)
            $htmlstat = '<I>' . substr($htmlstat, 0, $MaxTagStrLength) . '...</I>';

         ($i % 2)? $trclass='odd':$trclass='even';
?>
 <tr class="<?php echo $trclass; ?>">
   <td align="right"> <?php echo number_format($initpage+$i); ?> </td>
   <td class="url" align="left">
   <strong><?php echo $strReferencingUrl; ?></strong>: <a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlSrc"]; ?>"><?php echo GetURL($row["UrlSrc"]); ?></a><br>
   <strong><?php echo $strReferencedUrl; ?></strong>: <a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlDest"]; ?>"><?php echo GetURL($row["UrlDest"]); ?></a><br>
   <strong><?php echo $strHTMLStatement; ?></strong>: <?php echo $htmlstat; ?></td>
   <td align="center" class="noprint"><?php echo GetTextString($row["LinkType"]) ; ?></td>
   <td align="center" valign="middle" class="noprint"><?php
   // Show the image or the text
   if ($ShowIcons)
   {
?>
<IMG src="img/<?php echo $row["LinkResult"]; ?>.png" alt="<?php
   echo GetTextString($row["LinkResult"]); ?>"
   width="40" height="35" border=1" bordercolor="black">
<?php
   }
   else echo GetTextString($row["LinkResult"]); // No Icons
 ?></td>
   <td align="center" class="noprint">
<?php
   if (strcmp($row["LinkType"], "Redirection"))  // It's not a redirection
   {
?>
   <a href="showlink.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrlSrc"]; ?>&TagPosition=<?php echo $row["TagPosition"]; ?>&AttrPosition=<?php echo $row["AttrPosition"]; ?>"><?php echo $strShowLink; ?></a>
<?php
   }
   else echo '-';
?>
   </td>
 </tr>
<?php         
      }

?>
</table>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>

<?php
   }

   $MyDB->Free();
}
else
{
?>
<p><?php echo $strFilterLinks; ?>:</p>

<form action="<?php echo $PHP_SELF; ?>" method="GET">
<input type="hidden" name="dbname" value="<?php echo $dbname; ?>">
<table>

<?php

   // Retrieving all the LinkResults found
   $strSQL="SELECT count(*) as Count, LinkResult "
      . "FROM Link GROUP BY LinkResult "
      . "ORDER BY LinkResult ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
?>
<tr>
<td colspan="2">
<strong><?php echo $strLinkResult; ?> : </strong>
<select name="whatlinkresult">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="linkresult">
 <option value="AllLinks"><?php echo $strAllLinks; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <option value="<?php echo $row["LinkResult"]; ?>">
   <?php echo GetTextString($row["LinkResult"]); ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>

<?php

   }

   $MyDB->Free();

   // Retrieving all the LinkType found
   $strSQL="SELECT count(*) as Count, LinkType "
      . "FROM Link GROUP BY LinkType "
      . "ORDER BY LinkType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td colspan="2">
<strong><?php echo $strLinkType; ?> : </strong>
<select name="whatlinktype">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="linktype">
 <option value="AllLinks"><?php echo $strAllLinks; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <option value="<?php echo $row["LinkType"]; ?>">
   <?php echo GetTextString($row["LinkType"]); ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

   // Retrieving all the LinkDomain found
   $strSQL="SELECT count(*) as Count, LinkDomain "
      . "FROM Link GROUP BY LinkDomain "
      . "ORDER BY LinkDomain ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td colspan="2">
<strong><?php echo $strLinkDomain; ?> : </strong>
<select name="whatlinkdomain">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="linkdomain">
 <option value="AllLinks"><?php echo $strAllLinks; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
?>
 <option value="<?php echo $row["LinkDomain"]; ?>">
   <?php echo GetTextString($row["LinkDomain"]); ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
<?php
   }

   $MyDB->Free();

?>

<tr>
<th>
<?php echo $strReferencingUrl; ?> : 
</th>
<th>
<?php echo $strReferencedUrl; ?> : 
</th>
</tr>
<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>
<tr>
<td>
<select name="whatsrc[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="src[<?php echo $i; ?>]" type="text" value="<?php echo (is_array($src)?$src[$i]:''); ?>"
   size="30" maxlength="255">
</td>
<td>
<select name="whatdest[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="dest[<?php echo $i; ?>]" type="text" value="<?php echo (is_array($dest)?$dest[$i]:''); ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>

<tr>
<th colspan="2">
<?php echo $strAnchor; ?> :
</th>
</tr>
<?php
   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>
<tr>
<td colspan="2">
<select name="whatanchor[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="anchor[<?php echo $i; ?>]" type="text" value="<?php echo $anchor[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }
?>



<tr>
<td colspan="2" align="right">
<input type="submit" name="cmd" value="<?php echo $strLinkSubmit; ?>">
</td>
</tr>
</form>
</table>

<p align="justify">
<?php echo $strHelpOnString; ?>
</p>
<p align="justify">
<?php echo $strHelpOnRegExp; ?>
</p>

<?php
}
?>

<br>

<?php include ("./include/footer.inc.php"); ?>
