// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutmetrics

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/lookoutmetrics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpActivateAnomalyDetector struct {
}

func (*validateOpActivateAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpActivateAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ActivateAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpActivateAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBackTestAnomalyDetector struct {
}

func (*validateOpBackTestAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBackTestAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BackTestAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBackTestAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAlert struct {
}

func (*validateOpCreateAlert) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAlert) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAlertInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAlertInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAnomalyDetector struct {
}

func (*validateOpCreateAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateMetricSet struct {
}

func (*validateOpCreateMetricSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateMetricSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateMetricSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateMetricSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeactivateAnomalyDetector struct {
}

func (*validateOpDeactivateAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeactivateAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeactivateAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeactivateAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAlert struct {
}

func (*validateOpDeleteAlert) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAlert) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAlertInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAlertInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAnomalyDetector struct {
}

func (*validateOpDeleteAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAlert struct {
}

func (*validateOpDescribeAlert) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAlert) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAlertInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAlertInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAnomalyDetectionExecutions struct {
}

func (*validateOpDescribeAnomalyDetectionExecutions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAnomalyDetectionExecutions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAnomalyDetectionExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAnomalyDetectionExecutionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAnomalyDetector struct {
}

func (*validateOpDescribeAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeMetricSet struct {
}

func (*validateOpDescribeMetricSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeMetricSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeMetricSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeMetricSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDetectMetricSetConfig struct {
}

func (*validateOpDetectMetricSetConfig) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDetectMetricSetConfig) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DetectMetricSetConfigInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDetectMetricSetConfigInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAnomalyGroup struct {
}

func (*validateOpGetAnomalyGroup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAnomalyGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAnomalyGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAnomalyGroupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataQualityMetrics struct {
}

func (*validateOpGetDataQualityMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataQualityMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataQualityMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataQualityMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetFeedback struct {
}

func (*validateOpGetFeedback) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetFeedback) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetFeedbackInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetFeedbackInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetSampleData struct {
}

func (*validateOpGetSampleData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSampleData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSampleDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSampleDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAnomalyGroupRelatedMetrics struct {
}

func (*validateOpListAnomalyGroupRelatedMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAnomalyGroupRelatedMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAnomalyGroupRelatedMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAnomalyGroupRelatedMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAnomalyGroupSummaries struct {
}

func (*validateOpListAnomalyGroupSummaries) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAnomalyGroupSummaries) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAnomalyGroupSummariesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAnomalyGroupSummariesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAnomalyGroupTimeSeries struct {
}

func (*validateOpListAnomalyGroupTimeSeries) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAnomalyGroupTimeSeries) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAnomalyGroupTimeSeriesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAnomalyGroupTimeSeriesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutFeedback struct {
}

func (*validateOpPutFeedback) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutFeedback) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutFeedbackInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutFeedbackInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAlert struct {
}

func (*validateOpUpdateAlert) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAlert) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAlertInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAlertInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAnomalyDetector struct {
}

func (*validateOpUpdateAnomalyDetector) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAnomalyDetector) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAnomalyDetectorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAnomalyDetectorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateMetricSet struct {
}

func (*validateOpUpdateMetricSet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateMetricSet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateMetricSetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateMetricSetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpActivateAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpActivateAnomalyDetector{}, middleware.After)
}

func addOpBackTestAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBackTestAnomalyDetector{}, middleware.After)
}

func addOpCreateAlertValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAlert{}, middleware.After)
}

func addOpCreateAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAnomalyDetector{}, middleware.After)
}

func addOpCreateMetricSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateMetricSet{}, middleware.After)
}

func addOpDeactivateAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeactivateAnomalyDetector{}, middleware.After)
}

func addOpDeleteAlertValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAlert{}, middleware.After)
}

func addOpDeleteAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAnomalyDetector{}, middleware.After)
}

func addOpDescribeAlertValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAlert{}, middleware.After)
}

func addOpDescribeAnomalyDetectionExecutionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAnomalyDetectionExecutions{}, middleware.After)
}

func addOpDescribeAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAnomalyDetector{}, middleware.After)
}

func addOpDescribeMetricSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeMetricSet{}, middleware.After)
}

func addOpDetectMetricSetConfigValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDetectMetricSetConfig{}, middleware.After)
}

func addOpGetAnomalyGroupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAnomalyGroup{}, middleware.After)
}

func addOpGetDataQualityMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataQualityMetrics{}, middleware.After)
}

func addOpGetFeedbackValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetFeedback{}, middleware.After)
}

func addOpGetSampleDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSampleData{}, middleware.After)
}

func addOpListAnomalyGroupRelatedMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAnomalyGroupRelatedMetrics{}, middleware.After)
}

func addOpListAnomalyGroupSummariesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAnomalyGroupSummaries{}, middleware.After)
}

func addOpListAnomalyGroupTimeSeriesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAnomalyGroupTimeSeries{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutFeedbackValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutFeedback{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAlertValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAlert{}, middleware.After)
}

func addOpUpdateAnomalyDetectorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAnomalyDetector{}, middleware.After)
}

func addOpUpdateMetricSetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateMetricSet{}, middleware.After)
}

func validateAction(v *types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	if v.SNSConfiguration != nil {
		if err := validateSNSConfiguration(v.SNSConfiguration); err != nil {
			invalidParams.AddNested("SNSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaConfiguration != nil {
		if err := validateLambdaConfiguration(v.LambdaConfiguration); err != nil {
			invalidParams.AddNested("LambdaConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAnomalyGroupTimeSeries(v *types.AnomalyGroupTimeSeries) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AnomalyGroupTimeSeries"}
	if v.AnomalyGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAnomalyGroupTimeSeriesFeedback(v *types.AnomalyGroupTimeSeriesFeedback) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AnomalyGroupTimeSeriesFeedback"}
	if v.AnomalyGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupId"))
	}
	if v.TimeSeriesId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeSeriesId"))
	}
	if v.IsAnomaly == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IsAnomaly"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAthenaSourceConfig(v *types.AthenaSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AthenaSourceConfig"}
	if v.BackTestConfiguration != nil {
		if err := validateBackTestConfiguration(v.BackTestConfiguration); err != nil {
			invalidParams.AddNested("BackTestConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBackTestConfiguration(v *types.BackTestConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BackTestConfiguration"}
	if v.RunBackTestMode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RunBackTestMode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCloudWatchConfig(v *types.CloudWatchConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CloudWatchConfig"}
	if v.BackTestConfiguration != nil {
		if err := validateBackTestConfiguration(v.BackTestConfiguration); err != nil {
			invalidParams.AddNested("BackTestConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaConfiguration(v *types.LambdaConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaConfiguration"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.LambdaArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LambdaArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetric(v *types.Metric) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Metric"}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if len(v.AggregationFunction) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AggregationFunction"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricList(v []types.Metric) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricList"}
	for i := range v {
		if err := validateMetric(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricSource(v *types.MetricSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricSource"}
	if v.CloudWatchConfig != nil {
		if err := validateCloudWatchConfig(v.CloudWatchConfig); err != nil {
			invalidParams.AddNested("CloudWatchConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.RDSSourceConfig != nil {
		if err := validateRDSSourceConfig(v.RDSSourceConfig); err != nil {
			invalidParams.AddNested("RDSSourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.RedshiftSourceConfig != nil {
		if err := validateRedshiftSourceConfig(v.RedshiftSourceConfig); err != nil {
			invalidParams.AddNested("RedshiftSourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AthenaSourceConfig != nil {
		if err := validateAthenaSourceConfig(v.AthenaSourceConfig); err != nil {
			invalidParams.AddNested("AthenaSourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRDSSourceConfig(v *types.RDSSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RDSSourceConfig"}
	if v.VpcConfiguration != nil {
		if err := validateVpcConfiguration(v.VpcConfiguration); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRedshiftSourceConfig(v *types.RedshiftSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RedshiftSourceConfig"}
	if v.VpcConfiguration != nil {
		if err := validateVpcConfiguration(v.VpcConfiguration); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSampleDataS3SourceConfig(v *types.SampleDataS3SourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SampleDataS3SourceConfig"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.FileFormatDescriptor == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileFormatDescriptor"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSNSConfiguration(v *types.SNSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SNSConfiguration"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.SnsTopicArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SnsTopicArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVpcConfiguration(v *types.VpcConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VpcConfiguration"}
	if v.SubnetIdList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIdList"))
	}
	if v.SecurityGroupIdList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecurityGroupIdList"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpActivateAnomalyDetectorInput(v *ActivateAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActivateAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBackTestAnomalyDetectorInput(v *BackTestAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BackTestAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAlertInput(v *CreateAlertInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAlertInput"}
	if v.AlertName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlertName"))
	}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAnomalyDetectorInput(v *CreateAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAnomalyDetectorInput"}
	if v.AnomalyDetectorName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorName"))
	}
	if v.AnomalyDetectorConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorConfig"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateMetricSetInput(v *CreateMetricSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateMetricSetInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.MetricSetName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricSetName"))
	}
	if v.MetricList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricList"))
	} else if v.MetricList != nil {
		if err := validateMetricList(v.MetricList); err != nil {
			invalidParams.AddNested("MetricList", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetricSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricSource"))
	} else if v.MetricSource != nil {
		if err := validateMetricSource(v.MetricSource); err != nil {
			invalidParams.AddNested("MetricSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeactivateAnomalyDetectorInput(v *DeactivateAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeactivateAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAlertInput(v *DeleteAlertInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAlertInput"}
	if v.AlertArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlertArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAnomalyDetectorInput(v *DeleteAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAlertInput(v *DescribeAlertInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAlertInput"}
	if v.AlertArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlertArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAnomalyDetectionExecutionsInput(v *DescribeAnomalyDetectionExecutionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAnomalyDetectionExecutionsInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAnomalyDetectorInput(v *DescribeAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeMetricSetInput(v *DescribeMetricSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeMetricSetInput"}
	if v.MetricSetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricSetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDetectMetricSetConfigInput(v *DetectMetricSetConfigInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DetectMetricSetConfigInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.AutoDetectionMetricSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AutoDetectionMetricSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAnomalyGroupInput(v *GetAnomalyGroupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAnomalyGroupInput"}
	if v.AnomalyGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupId"))
	}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataQualityMetricsInput(v *GetDataQualityMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataQualityMetricsInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetFeedbackInput(v *GetFeedbackInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetFeedbackInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.AnomalyGroupTimeSeriesFeedback == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupTimeSeriesFeedback"))
	} else if v.AnomalyGroupTimeSeriesFeedback != nil {
		if err := validateAnomalyGroupTimeSeries(v.AnomalyGroupTimeSeriesFeedback); err != nil {
			invalidParams.AddNested("AnomalyGroupTimeSeriesFeedback", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSampleDataInput(v *GetSampleDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSampleDataInput"}
	if v.S3SourceConfig != nil {
		if err := validateSampleDataS3SourceConfig(v.S3SourceConfig); err != nil {
			invalidParams.AddNested("S3SourceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAnomalyGroupRelatedMetricsInput(v *ListAnomalyGroupRelatedMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAnomalyGroupRelatedMetricsInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.AnomalyGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAnomalyGroupSummariesInput(v *ListAnomalyGroupSummariesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAnomalyGroupSummariesInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAnomalyGroupTimeSeriesInput(v *ListAnomalyGroupTimeSeriesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAnomalyGroupTimeSeriesInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.AnomalyGroupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupId"))
	}
	if v.MetricName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutFeedbackInput(v *PutFeedbackInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutFeedbackInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if v.AnomalyGroupTimeSeriesFeedback == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyGroupTimeSeriesFeedback"))
	} else if v.AnomalyGroupTimeSeriesFeedback != nil {
		if err := validateAnomalyGroupTimeSeriesFeedback(v.AnomalyGroupTimeSeriesFeedback); err != nil {
			invalidParams.AddNested("AnomalyGroupTimeSeriesFeedback", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAlertInput(v *UpdateAlertInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAlertInput"}
	if v.AlertArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlertArn"))
	}
	if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAnomalyDetectorInput(v *UpdateAnomalyDetectorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAnomalyDetectorInput"}
	if v.AnomalyDetectorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnomalyDetectorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateMetricSetInput(v *UpdateMetricSetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateMetricSetInput"}
	if v.MetricSetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricSetArn"))
	}
	if v.MetricList != nil {
		if err := validateMetricList(v.MetricList); err != nil {
			invalidParams.AddNested("MetricList", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetricSource != nil {
		if err := validateMetricSource(v.MetricSource); err != nil {
			invalidParams.AddNested("MetricSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
