/* retro-core-source.c generated by valac 0.36.12.13-3ae08, the Vala compiler
 * generated from retro-core-source.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <retro-gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_RETRO_CORE_SOURCE (games_retro_core_source_get_type ())
#define GAMES_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSource))
#define GAMES_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))
#define GAMES_IS_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_IS_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_RETRO_CORE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))

typedef struct _GamesRetroCoreSource GamesRetroCoreSource;
typedef struct _GamesRetroCoreSourceClass GamesRetroCoreSourceClass;
typedef struct _GamesRetroCoreSourcePrivate GamesRetroCoreSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _GamesRetroCoreSource {
	GObject parent_instance;
	GamesRetroCoreSourcePrivate * priv;
};

struct _GamesRetroCoreSourceClass {
	GObjectClass parent_class;
};

struct _GamesRetroCoreSourcePrivate {
	gchar* platform;
	gchar** mime_types;
	gint mime_types_length1;
	gint _mime_types_size_;
	RetroCoreDescriptor* core_descriptor;
	gboolean searched;
};

typedef enum  {
	GAMES_RETRO_ERROR_MODULE_NOT_FOUND,
	GAMES_RETRO_ERROR_INVALID_GAME_FILE,
	GAMES_RETRO_ERROR_COULDNT_WRITE_SNAPSHOT,
	GAMES_RETRO_ERROR_COULDNT_LOAD_SNAPSHOT,
	GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND
} GamesRetroError;
#define GAMES_RETRO_ERROR games_retro_error_quark ()

static gpointer games_retro_core_source_parent_class = NULL;

GType games_retro_core_source_get_type (void) G_GNUC_CONST;
#define GAMES_RETRO_CORE_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourcePrivate))
enum  {
	GAMES_RETRO_CORE_SOURCE_0_PROPERTY
};
GamesRetroCoreSource* games_retro_core_source_new (const gchar* platform, gchar** mime_types, int mime_types_length1);
GamesRetroCoreSource* games_retro_core_source_construct (GType object_type, const gchar* platform, gchar** mime_types, int mime_types_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar* games_retro_core_source_get_platform (GamesRetroCoreSource* self);
gchar* games_retro_core_source_get_module_path (GamesRetroCoreSource* self, GError** error);
static void games_retro_core_source_ensure_module_is_found (GamesRetroCoreSource* self, GError** error);
GQuark games_retro_error_quark (void);
static void games_retro_core_source_search_module (GamesRetroCoreSource* self, GError** error);
gchar** retro_core_descriptor_get_firmwares (RetroCoreDescriptor* core_descriptor, const gchar* platform, gsize* result_length1, GError** error);
static void games_retro_core_source_check_firmware_is_valid (GamesRetroCoreSource* self, const gchar* firmware, GError** error);
gchar* games_application_get_platforms_dir (void);
static void games_retro_core_source_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GamesRetroCoreSource* games_retro_core_source_construct (GType object_type, const gchar* platform, gchar** mime_types, int mime_types_length1) {
	GamesRetroCoreSource * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (platform != NULL, NULL);
	self = (GamesRetroCoreSource*) g_object_new (object_type, NULL);
	_tmp0_ = platform;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->platform);
	self->priv->platform = _tmp1_;
	_tmp2_ = mime_types;
	_tmp2__length1 = mime_types_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	self->priv->mime_types = _tmp3_;
	self->priv->mime_types_length1 = _tmp3__length1;
	self->priv->_mime_types_size_ = self->priv->mime_types_length1;
	self->priv->searched = FALSE;
	return self;
}


GamesRetroCoreSource* games_retro_core_source_new (const gchar* platform, gchar** mime_types, int mime_types_length1) {
	return games_retro_core_source_construct (GAMES_TYPE_RETRO_CORE_SOURCE, platform, mime_types, mime_types_length1);
}


gchar* games_retro_core_source_get_platform (GamesRetroCoreSource* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->platform;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* games_retro_core_source_get_module_path (GamesRetroCoreSource* self, GError** error) {
	gchar* result = NULL;
	GFile* module_file = NULL;
	RetroCoreDescriptor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	games_retro_core_source_ensure_module_is_found (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp0_ = self->priv->core_descriptor;
	_tmp1_ = retro_core_descriptor_get_module_file (_tmp0_, &_inner_error_);
	module_file = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = module_file;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = self->priv->platform;
		_tmp4_ = self->priv->mime_types;
		_tmp4__length1 = self->priv->mime_types_length1;
		_tmp5_ = _vala_g_strjoinv (_ ("”, “"), _tmp4_, _tmp4__length1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, _ ("No module found for platform “%s” and MIME types [ “%s” ]."), _tmp3_, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (module_file);
		return NULL;
	}
	_tmp9_ = module_file;
	_tmp10_ = g_file_get_path (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (module_file);
	return result;
}


static void games_retro_core_source_ensure_module_is_found (GamesRetroCoreSource* self, GError** error) {
	gboolean _tmp0_;
	RetroCoreDescriptor* _tmp1_;
	gboolean _tmp8_ = FALSE;
	RetroCoreDescriptor* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->searched;
	if (!_tmp0_) {
		self->priv->searched = TRUE;
		games_retro_core_source_search_module (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->core_descriptor;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = self->priv->platform;
		_tmp3_ = self->priv->mime_types;
		_tmp3__length1 = self->priv->mime_types_length1;
		_tmp4_ = _vala_g_strjoinv (_ ("”, “"), _tmp3_, _tmp3__length1);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, _ ("No module found for platform “%s” and MIME types [ “%s” ]."), _tmp2_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp9_ = self->priv->core_descriptor;
	_tmp10_ = self->priv->platform;
	_tmp11_ = retro_core_descriptor_has_firmwares (_tmp9_, _tmp10_, &_inner_error_);
	_tmp8_ = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (_tmp8_) {
		gchar** _tmp12_ = NULL;
		RetroCoreDescriptor* _tmp13_;
		const gchar* _tmp14_;
		gsize _tmp15_;
		gchar** _tmp16_;
		gint _tmp12__length1;
		gint __tmp12__size_;
		_tmp13_ = self->priv->core_descriptor;
		_tmp14_ = self->priv->platform;
		_tmp16_ = retro_core_descriptor_get_firmwares (_tmp13_, _tmp14_, &_tmp15_, &_inner_error_);
		_tmp12_ = _tmp16_;
		_tmp12__length1 = _tmp15_;
		__tmp12__size_ = _tmp12__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		{
			gchar** firmware_collection = NULL;
			gint firmware_collection_length1 = 0;
			gint _firmware_collection_size_ = 0;
			gint firmware_it = 0;
			firmware_collection = _tmp12_;
			firmware_collection_length1 = _tmp12__length1;
			for (firmware_it = 0; firmware_it < _tmp12__length1; firmware_it = firmware_it + 1) {
				gchar* _tmp17_;
				gchar* firmware = NULL;
				_tmp17_ = g_strdup (firmware_collection[firmware_it]);
				firmware = _tmp17_;
				{
					const gchar* _tmp18_;
					_tmp18_ = firmware;
					games_retro_core_source_check_firmware_is_valid (self, _tmp18_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (firmware);
						_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_g_free0 (firmware);
				}
			}
		}
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_retro_core_source_search_module (GamesRetroCoreSource* self, GError** error) {
	RetroModuleQuery* modules = NULL;
	RetroModuleQuery* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = retro_module_query_new (TRUE);
	modules = _tmp0_;
	{
		RetroModuleIterator* _core_descriptor_it = NULL;
		RetroModuleQuery* _tmp1_;
		RetroModuleIterator* _tmp2_;
		_tmp1_ = modules;
		_tmp2_ = retro_module_query_iterator (_tmp1_);
		_core_descriptor_it = _tmp2_;
		while (TRUE) {
			RetroModuleIterator* _tmp3_;
			gboolean _tmp4_;
			RetroCoreDescriptor* core_descriptor = NULL;
			RetroModuleIterator* _tmp5_;
			RetroCoreDescriptor* _tmp6_;
			_tmp3_ = _core_descriptor_it;
			_tmp4_ = retro_module_iterator_next (_tmp3_);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = _core_descriptor_it;
			_tmp6_ = retro_module_iterator_get (_tmp5_);
			core_descriptor = _tmp6_;
			{
				gboolean _tmp7_ = FALSE;
				RetroCoreDescriptor* _tmp8_;
				gboolean _tmp9_;
				RetroCoreDescriptor* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_ = FALSE;
				RetroCoreDescriptor* _tmp14_;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gboolean _tmp17_;
				GFile* _tmp18_ = NULL;
				RetroCoreDescriptor* _tmp19_;
				GFile* _tmp20_;
				RetroCoreDescriptor* _tmp21_;
				RetroCoreDescriptor* _tmp22_;
				_tmp8_ = core_descriptor;
				_tmp9_ = retro_core_descriptor_get_is_emulator (_tmp8_, &_inner_error_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch13_g_error;
				}
				if (!_tmp7_) {
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp10_ = core_descriptor;
				_tmp11_ = self->priv->platform;
				_tmp12_ = retro_core_descriptor_has_platform (_tmp10_, _tmp11_);
				if (!_tmp12_) {
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp14_ = core_descriptor;
				_tmp15_ = self->priv->platform;
				_tmp16_ = self->priv->mime_types;
				_tmp16__length1 = self->priv->mime_types_length1;
				_tmp17_ = retro_core_descriptor_get_platform_supports_mime_types (_tmp14_, _tmp15_, _tmp16_, &_inner_error_);
				_tmp13_ = _tmp17_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch13_g_error;
				}
				if (!_tmp13_) {
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp19_ = core_descriptor;
				_tmp20_ = retro_core_descriptor_get_module_file (_tmp19_, &_inner_error_);
				_tmp18_ = _tmp20_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch13_g_error;
				}
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp18_);
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp21_ = core_descriptor;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (self->priv->core_descriptor);
				self->priv->core_descriptor = _tmp22_;
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (core_descriptor);
				break;
			}
			goto __finally13;
			__catch13_g_error:
			{
				GError* e = NULL;
				GError* _tmp23_;
				const gchar* _tmp24_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp23_ = e;
				_tmp24_ = _tmp23_->message;
				g_debug ("retro-core-source.vala:65: %s", _tmp24_);
				_g_error_free0 (e);
			}
			__finally13:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (core_descriptor);
				_g_object_unref0 (_core_descriptor_it);
				_g_object_unref0 (modules);
				return;
			}
			_g_object_unref0 (core_descriptor);
		}
		_g_object_unref0 (_core_descriptor_it);
	}
	_g_object_unref0 (modules);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void games_retro_core_source_check_firmware_is_valid (GamesRetroCoreSource* self, const gchar* firmware, GError** error) {
	gboolean _tmp0_ = FALSE;
	RetroCoreDescriptor* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* platforms_dir = NULL;
	gchar* _tmp4_;
	GFile* firmware_dir = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gchar* firmware_path = NULL;
	RetroCoreDescriptor* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* firmware_file = NULL;
	GFile* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	gboolean _tmp20_;
	gboolean has_md5 = FALSE;
	RetroCoreDescriptor* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_;
	gboolean has_sha512 = FALSE;
	RetroCoreDescriptor* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	GFileInputStream* stream = NULL;
	GFile* _tmp35_;
	GFileInputStream* _tmp36_;
	GFileInputStream* _tmp37_;
	gsize size = 0UL;
	GFileInputStream* _tmp38_;
	gint64 _tmp39_;
	GFileInputStream* _tmp40_;
	GBytes* bytes = NULL;
	GFileInputStream* _tmp41_;
	gsize _tmp42_;
	GBytes* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (firmware != NULL);
	_tmp1_ = self->priv->core_descriptor;
	_tmp2_ = firmware;
	_tmp3_ = retro_core_descriptor_get_is_firmware_mandatory (_tmp1_, _tmp2_, &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (!_tmp0_) {
		return;
	}
	_tmp4_ = games_application_get_platforms_dir ();
	platforms_dir = _tmp4_;
	_tmp5_ = platforms_dir;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = self->priv->platform;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = g_strconcat (_tmp6_, "/", _tmp8_, "/system", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	firmware_dir = _tmp12_;
	_tmp13_ = self->priv->core_descriptor;
	_tmp14_ = firmware;
	_tmp15_ = retro_core_descriptor_get_firmware_path (_tmp13_, _tmp14_, &_inner_error_);
	firmware_path = _tmp15_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp16_ = firmware_dir;
	_tmp17_ = firmware_path;
	_tmp18_ = g_file_get_child (_tmp16_, _tmp17_);
	firmware_file = _tmp18_;
	_tmp19_ = firmware_file;
	_tmp20_ = g_file_query_exists (_tmp19_, NULL);
	if (!_tmp20_) {
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		_tmp21_ = firmware_file;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND, _ ("This game requires the %s firmware file to run."), _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_inner_error_ = _tmp25_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp26_ = self->priv->core_descriptor;
	_tmp27_ = firmware;
	_tmp28_ = retro_core_descriptor_has_firmware_md5 (_tmp26_, _tmp27_, &_inner_error_);
	has_md5 = _tmp28_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp29_ = self->priv->core_descriptor;
	_tmp30_ = firmware;
	_tmp31_ = retro_core_descriptor_has_firmware_sha512 (_tmp29_, _tmp30_, &_inner_error_);
	has_sha512 = _tmp31_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp33_ = has_md5;
	if (!_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		gboolean _tmp34_;
		_tmp34_ = has_sha512;
		_tmp32_ = !_tmp34_;
	}
	if (_tmp32_) {
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp35_ = firmware_file;
	_tmp36_ = g_file_read (_tmp35_, NULL, &_inner_error_);
	stream = _tmp36_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp37_ = stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp37_)->seek (_tmp37_, (gint64) 0, G_SEEK_END, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp38_ = stream;
	_tmp39_ = G_FILE_INPUT_STREAM_GET_CLASS (_tmp38_)->tell (_tmp38_);
	size = (gsize) _tmp39_;
	_tmp40_ = stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp40_)->seek (_tmp40_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp41_ = stream;
	_tmp42_ = size;
	_tmp43_ = g_input_stream_read_bytes ((GInputStream*) _tmp41_, _tmp42_, NULL, &_inner_error_);
	bytes = _tmp43_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_g_object_unref0 (firmware_file);
		_g_free0 (firmware_path);
		_g_object_unref0 (firmware_dir);
		_g_free0 (platforms_dir);
		return;
	}
	_tmp44_ = has_md5;
	if (_tmp44_) {
		gchar* md5 = NULL;
		RetroCoreDescriptor* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		GBytes* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
		_tmp45_ = self->priv->core_descriptor;
		_tmp46_ = firmware;
		_tmp47_ = retro_core_descriptor_get_firmware_md5 (_tmp45_, _tmp46_, &_inner_error_);
		md5 = _tmp47_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_bytes_unref0 (bytes);
			_g_object_unref0 (stream);
			_g_object_unref0 (firmware_file);
			_g_free0 (firmware_path);
			_g_object_unref0 (firmware_dir);
			_g_free0 (platforms_dir);
			return;
		}
		_tmp48_ = bytes;
		_tmp49_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = md5;
		_tmp52_ = g_strcmp0 (_tmp50_, _tmp51_) != 0;
		_g_free0 (_tmp50_);
		if (_tmp52_) {
			GFile* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			const gchar* _tmp56_;
			GError* _tmp57_;
			GError* _tmp58_;
			_tmp53_ = firmware_file;
			_tmp54_ = g_file_get_path (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = md5;
			_tmp57_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND, _ ("This game requires the %s firmware file with a MD5 fingerprint of %s t" \
"o run."), _tmp55_, _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp55_);
			_inner_error_ = _tmp58_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (md5);
			_g_bytes_unref0 (bytes);
			_g_object_unref0 (stream);
			_g_object_unref0 (firmware_file);
			_g_free0 (firmware_path);
			_g_object_unref0 (firmware_dir);
			_g_free0 (platforms_dir);
			return;
		}
		_g_free0 (md5);
	}
	_tmp59_ = has_sha512;
	if (_tmp59_) {
		gchar* sha512 = NULL;
		RetroCoreDescriptor* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		GBytes* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		const gchar* _tmp66_;
		gboolean _tmp67_;
		_tmp60_ = self->priv->core_descriptor;
		_tmp61_ = firmware;
		_tmp62_ = retro_core_descriptor_get_firmware_sha512 (_tmp60_, _tmp61_, &_inner_error_);
		sha512 = _tmp62_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_bytes_unref0 (bytes);
			_g_object_unref0 (stream);
			_g_object_unref0 (firmware_file);
			_g_free0 (firmware_path);
			_g_object_unref0 (firmware_dir);
			_g_free0 (platforms_dir);
			return;
		}
		_tmp63_ = bytes;
		_tmp64_ = g_compute_checksum_for_bytes (G_CHECKSUM_SHA512, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = sha512;
		_tmp67_ = g_strcmp0 (_tmp65_, _tmp66_) != 0;
		_g_free0 (_tmp65_);
		if (_tmp67_) {
			GFile* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			const gchar* _tmp71_;
			GError* _tmp72_;
			GError* _tmp73_;
			_tmp68_ = firmware_file;
			_tmp69_ = g_file_get_path (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = sha512;
			_tmp72_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND, _ ("This game requires the %s firmware file with a SHA-512 fingerprint of " \
"%s to run."), _tmp70_, _tmp71_);
			_tmp73_ = _tmp72_;
			_g_free0 (_tmp70_);
			_inner_error_ = _tmp73_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (sha512);
			_g_bytes_unref0 (bytes);
			_g_object_unref0 (stream);
			_g_object_unref0 (firmware_file);
			_g_free0 (firmware_path);
			_g_object_unref0 (firmware_dir);
			_g_free0 (platforms_dir);
			return;
		}
		_g_free0 (sha512);
	}
	_g_bytes_unref0 (bytes);
	_g_object_unref0 (stream);
	_g_object_unref0 (firmware_file);
	_g_free0 (firmware_path);
	_g_object_unref0 (firmware_dir);
	_g_free0 (platforms_dir);
}


static void games_retro_core_source_class_init (GamesRetroCoreSourceClass * klass) {
	games_retro_core_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesRetroCoreSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = games_retro_core_source_finalize;
}


static void games_retro_core_source_instance_init (GamesRetroCoreSource * self) {
	self->priv = GAMES_RETRO_CORE_SOURCE_GET_PRIVATE (self);
}


static void games_retro_core_source_finalize (GObject * obj) {
	GamesRetroCoreSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSource);
	_g_free0 (self->priv->platform);
	self->priv->mime_types = (_vala_array_free (self->priv->mime_types, self->priv->mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->core_descriptor);
	G_OBJECT_CLASS (games_retro_core_source_parent_class)->finalize (obj);
}


GType games_retro_core_source_get_type (void) {
	static volatile gsize games_retro_core_source_type_id__volatile = 0;
	if (g_once_init_enter (&games_retro_core_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesRetroCoreSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_core_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroCoreSource), 0, (GInstanceInitFunc) games_retro_core_source_instance_init, NULL };
		GType games_retro_core_source_type_id;
		games_retro_core_source_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroCoreSource", &g_define_type_info, 0);
		g_once_init_leave (&games_retro_core_source_type_id__volatile, games_retro_core_source_type_id);
	}
	return games_retro_core_source_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



