/* Code automatically generated by mgd77netcdfhelper.sh
 * To be included by mgd77.c
 *
 *    Copyright (c) 2005-2013 by P. Wessel
 *    See README file for copying and redistribution conditions.
 */
 
void MGD77_Read_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS **P)
{
	/* Read the netCDF-encoded MGD77 header parameters as attributes of the data set.
	 * If orig is TRUE we will recover the original MGD77 parameters; otherwise we first
	 * look for revised parameters and fall back on the original if no revision is found. */
	
	struct MGD77_HEADER_LOOKUP *L;
	int i;
	
	L = MGD77_Header_Lookup;
	
	L[MGD77_Param_Key(1,2)].revised = MGD77_Get_Param (F, "Survey_Identifier", P[0]->Survey_Identifier, P[1]->Survey_Identifier);
	L[MGD77_Param_Key(1,3)].revised = MGD77_Get_Param (F, "Format_Acronym", P[0]->Format_Acronym, P[1]->Format_Acronym);
	L[MGD77_Param_Key(1,4)].revised = MGD77_Get_Param (F, "Data_Center_File_Number", P[0]->Data_Center_File_Number, P[1]->Data_Center_File_Number);
	L[MGD77_Param_Key(1,5)].revised = MGD77_Get_Param (F, "Parameters_Surveyed_Code", P[0]->Parameters_Surveyed_Code, P[1]->Parameters_Surveyed_Code);
	L[MGD77_Param_Key(1,10)].revised = MGD77_Get_Param (F, "File_Creation_Year", P[0]->File_Creation_Year, P[1]->File_Creation_Year);
	L[MGD77_Param_Key(1,11)].revised = MGD77_Get_Param (F, "File_Creation_Month", P[0]->File_Creation_Month, P[1]->File_Creation_Month);
	L[MGD77_Param_Key(1,12)].revised = MGD77_Get_Param (F, "File_Creation_Day", P[0]->File_Creation_Day, P[1]->File_Creation_Day);
	L[MGD77_Param_Key(1,13)].revised = MGD77_Get_Param (F, "Source_Institution", P[0]->Source_Institution, P[1]->Source_Institution);
	L[MGD77_Param_Key(2,1)].revised = MGD77_Get_Param (F, "Country", P[0]->Country, P[1]->Country);
	L[MGD77_Param_Key(2,2)].revised = MGD77_Get_Param (F, "Platform_Name", P[0]->Platform_Name, P[1]->Platform_Name);
	L[MGD77_Param_Key(2,3)].revised = MGD77_Get_Param (F, "Platform_Type_Code", &P[0]->Platform_Type_Code, &P[1]->Platform_Type_Code);
	L[MGD77_Param_Key(2,4)].revised = MGD77_Get_Param (F, "Platform_Type", P[0]->Platform_Type, P[1]->Platform_Type);
	L[MGD77_Param_Key(2,5)].revised = MGD77_Get_Param (F, "Chief_Scientist", P[0]->Chief_Scientist, P[1]->Chief_Scientist);
	L[MGD77_Param_Key(3,1)].revised = MGD77_Get_Param (F, "Project_Cruise_Leg", P[0]->Project_Cruise_Leg, P[1]->Project_Cruise_Leg);
	L[MGD77_Param_Key(3,2)].revised = MGD77_Get_Param (F, "Funding", P[0]->Funding, P[1]->Funding);
	L[MGD77_Param_Key(4,1)].revised = MGD77_Get_Param (F, "Survey_Departure_Year", P[0]->Survey_Departure_Year, P[1]->Survey_Departure_Year);
	L[MGD77_Param_Key(4,2)].revised = MGD77_Get_Param (F, "Survey_Departure_Month", P[0]->Survey_Departure_Month, P[1]->Survey_Departure_Month);
	L[MGD77_Param_Key(4,3)].revised = MGD77_Get_Param (F, "Survey_Departure_Day", P[0]->Survey_Departure_Day, P[1]->Survey_Departure_Day);
	L[MGD77_Param_Key(4,4)].revised = MGD77_Get_Param (F, "Port_of_Departure", P[0]->Port_of_Departure, P[1]->Port_of_Departure);
	L[MGD77_Param_Key(4,5)].revised = MGD77_Get_Param (F, "Survey_Arrival_Year", P[0]->Survey_Arrival_Year, P[1]->Survey_Arrival_Year);
	L[MGD77_Param_Key(4,6)].revised = MGD77_Get_Param (F, "Survey_Arrival_Month", P[0]->Survey_Arrival_Month, P[1]->Survey_Arrival_Month);
	L[MGD77_Param_Key(4,7)].revised = MGD77_Get_Param (F, "Survey_Arrival_Day", P[0]->Survey_Arrival_Day, P[1]->Survey_Arrival_Day);
	L[MGD77_Param_Key(4,8)].revised = MGD77_Get_Param (F, "Port_of_Arrival", P[0]->Port_of_Arrival, P[1]->Port_of_Arrival);
	L[MGD77_Param_Key(5,1)].revised = MGD77_Get_Param (F, "Navigation_Instrumentation", P[0]->Navigation_Instrumentation, P[1]->Navigation_Instrumentation);
	L[MGD77_Param_Key(5,2)].revised = MGD77_Get_Param (F, "Geodetic_Datum_Position_Determination_Method", P[0]->Geodetic_Datum_Position_Determination_Method, P[1]->Geodetic_Datum_Position_Determination_Method);
	L[MGD77_Param_Key(6,1)].revised = MGD77_Get_Param (F, "Bathymetry_Instrumentation", P[0]->Bathymetry_Instrumentation, P[1]->Bathymetry_Instrumentation);
	L[MGD77_Param_Key(6,2)].revised = MGD77_Get_Param (F, "Bathymetry_Add_Forms_of_Data", P[0]->Bathymetry_Add_Forms_of_Data, P[1]->Bathymetry_Add_Forms_of_Data);
	L[MGD77_Param_Key(7,1)].revised = MGD77_Get_Param (F, "Magnetics_Instrumentation", P[0]->Magnetics_Instrumentation, P[1]->Magnetics_Instrumentation);
	L[MGD77_Param_Key(7,2)].revised = MGD77_Get_Param (F, "Magnetics_Add_Forms_of_Data", P[0]->Magnetics_Add_Forms_of_Data, P[1]->Magnetics_Add_Forms_of_Data);
	L[MGD77_Param_Key(8,1)].revised = MGD77_Get_Param (F, "Gravity_Instrumentation", P[0]->Gravity_Instrumentation, P[1]->Gravity_Instrumentation);
	L[MGD77_Param_Key(8,2)].revised = MGD77_Get_Param (F, "Gravity_Add_Forms_of_Data", P[0]->Gravity_Add_Forms_of_Data, P[1]->Gravity_Add_Forms_of_Data);
	L[MGD77_Param_Key(9,1)].revised = MGD77_Get_Param (F, "Seismic_Instrumentation", P[0]->Seismic_Instrumentation, P[1]->Seismic_Instrumentation);
	L[MGD77_Param_Key(9,2)].revised = MGD77_Get_Param (F, "Seismic_Data_Formats", P[0]->Seismic_Data_Formats, P[1]->Seismic_Data_Formats);
	L[MGD77_Param_Key(10,1)].revised = MGD77_Get_Param (F, "Format_Type", &P[0]->Format_Type, &P[1]->Format_Type);
	L[MGD77_Param_Key(10,2)].revised = MGD77_Get_Param (F, "Format_Description", P[0]->Format_Description, P[1]->Format_Description);
	L[MGD77_Param_Key(11,1)].revised = MGD77_Get_Param (F, "Topmost_Latitude", P[0]->Topmost_Latitude, P[1]->Topmost_Latitude);
	L[MGD77_Param_Key(11,2)].revised = MGD77_Get_Param (F, "Bottommost_Latitude", P[0]->Bottommost_Latitude, P[1]->Bottommost_Latitude);
	L[MGD77_Param_Key(11,3)].revised = MGD77_Get_Param (F, "Leftmost_Longitude", P[0]->Leftmost_Longitude, P[1]->Leftmost_Longitude);
	L[MGD77_Param_Key(11,4)].revised = MGD77_Get_Param (F, "Rightmost_Longitude", P[0]->Rightmost_Longitude, P[1]->Rightmost_Longitude);
	L[MGD77_Param_Key(12,1)].revised = MGD77_Get_Param (F, "Bathymetry_Digitizing_Rate", P[0]->Bathymetry_Digitizing_Rate, P[1]->Bathymetry_Digitizing_Rate);
	L[MGD77_Param_Key(12,2)].revised = MGD77_Get_Param (F, "Bathymetry_Sampling_Rate", P[0]->Bathymetry_Sampling_Rate, P[1]->Bathymetry_Sampling_Rate);
	L[MGD77_Param_Key(12,3)].revised = MGD77_Get_Param (F, "Bathymetry_Assumed_Sound_Velocity", P[0]->Bathymetry_Assumed_Sound_Velocity, P[1]->Bathymetry_Assumed_Sound_Velocity);
	L[MGD77_Param_Key(12,4)].revised = MGD77_Get_Param (F, "Bathymetry_Datum_Code", P[0]->Bathymetry_Datum_Code, P[1]->Bathymetry_Datum_Code);
	L[MGD77_Param_Key(12,5)].revised = MGD77_Get_Param (F, "Bathymetry_Interpolation_Scheme", P[0]->Bathymetry_Interpolation_Scheme, P[1]->Bathymetry_Interpolation_Scheme);
	L[MGD77_Param_Key(13,1)].revised = MGD77_Get_Param (F, "Magnetics_Digitizing_Rate", P[0]->Magnetics_Digitizing_Rate, P[1]->Magnetics_Digitizing_Rate);
	L[MGD77_Param_Key(13,2)].revised = MGD77_Get_Param (F, "Magnetics_Sampling_Rate", P[0]->Magnetics_Sampling_Rate, P[1]->Magnetics_Sampling_Rate);
	L[MGD77_Param_Key(13,3)].revised = MGD77_Get_Param (F, "Magnetics_Sensor_Tow_Distance", P[0]->Magnetics_Sensor_Tow_Distance, P[1]->Magnetics_Sensor_Tow_Distance);
	L[MGD77_Param_Key(13,4)].revised = MGD77_Get_Param (F, "Magnetics_Sensor_Depth", P[0]->Magnetics_Sensor_Depth, P[1]->Magnetics_Sensor_Depth);
	L[MGD77_Param_Key(13,5)].revised = MGD77_Get_Param (F, "Magnetics_Sensor_Separation", P[0]->Magnetics_Sensor_Separation, P[1]->Magnetics_Sensor_Separation);
	L[MGD77_Param_Key(13,6)].revised = MGD77_Get_Param (F, "Magnetics_Ref_Field_Code", P[0]->Magnetics_Ref_Field_Code, P[1]->Magnetics_Ref_Field_Code);
	L[MGD77_Param_Key(13,7)].revised = MGD77_Get_Param (F, "Magnetics_Ref_Field", P[0]->Magnetics_Ref_Field, P[1]->Magnetics_Ref_Field);
	L[MGD77_Param_Key(13,8)].revised = MGD77_Get_Param (F, "Magnetics_Method_Applying_Res_Field", P[0]->Magnetics_Method_Applying_Res_Field, P[1]->Magnetics_Method_Applying_Res_Field);
	L[MGD77_Param_Key(14,1)].revised = MGD77_Get_Param (F, "Gravity_Digitizing_Rate", P[0]->Gravity_Digitizing_Rate, P[1]->Gravity_Digitizing_Rate);
	L[MGD77_Param_Key(14,2)].revised = MGD77_Get_Param (F, "Gravity_Sampling_Rate", P[0]->Gravity_Sampling_Rate, P[1]->Gravity_Sampling_Rate);
	L[MGD77_Param_Key(14,3)].revised = MGD77_Get_Param (F, "Gravity_Theoretical_Formula_Code", &P[0]->Gravity_Theoretical_Formula_Code, &P[1]->Gravity_Theoretical_Formula_Code);
	L[MGD77_Param_Key(14,4)].revised = MGD77_Get_Param (F, "Gravity_Theoretical_Formula", P[0]->Gravity_Theoretical_Formula, P[1]->Gravity_Theoretical_Formula);
	L[MGD77_Param_Key(14,5)].revised = MGD77_Get_Param (F, "Gravity_Reference_System_Code", &P[0]->Gravity_Reference_System_Code, &P[1]->Gravity_Reference_System_Code);
	L[MGD77_Param_Key(14,6)].revised = MGD77_Get_Param (F, "Gravity_Reference_System", P[0]->Gravity_Reference_System, P[1]->Gravity_Reference_System);
	L[MGD77_Param_Key(14,7)].revised = MGD77_Get_Param (F, "Gravity_Corrections_Applied", P[0]->Gravity_Corrections_Applied, P[1]->Gravity_Corrections_Applied);
	L[MGD77_Param_Key(15,1)].revised = MGD77_Get_Param (F, "Gravity_Departure_Base_Station", P[0]->Gravity_Departure_Base_Station, P[1]->Gravity_Departure_Base_Station);
	L[MGD77_Param_Key(15,2)].revised = MGD77_Get_Param (F, "Gravity_Departure_Base_Station_Name", P[0]->Gravity_Departure_Base_Station_Name, P[1]->Gravity_Departure_Base_Station_Name);
	L[MGD77_Param_Key(15,3)].revised = MGD77_Get_Param (F, "Gravity_Arrival_Base_Station", P[0]->Gravity_Arrival_Base_Station, P[1]->Gravity_Arrival_Base_Station);
	L[MGD77_Param_Key(15,4)].revised = MGD77_Get_Param (F, "Gravity_Arrival_Base_Station_Name", P[0]->Gravity_Arrival_Base_Station_Name, P[1]->Gravity_Arrival_Base_Station_Name);
	L[MGD77_Param_Key(16,1)].revised = MGD77_Get_Param (F, "Number_of_Ten_Degree_Identifiers", P[0]->Number_of_Ten_Degree_Identifiers, P[1]->Number_of_Ten_Degree_Identifiers);
	L[MGD77_Param_Key(16,2)].revised = MGD77_Get_Param (F, "Ten_Degree_Identifier", P[0]->Ten_Degree_Identifier, P[1]->Ten_Degree_Identifier);
	L[MGD77_Param_Key(18,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_1", P[0]->Additional_Documentation_1, P[1]->Additional_Documentation_1);
	L[MGD77_Param_Key(19,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_2", P[0]->Additional_Documentation_2, P[1]->Additional_Documentation_2);
	L[MGD77_Param_Key(20,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_3", P[0]->Additional_Documentation_3, P[1]->Additional_Documentation_3);
	L[MGD77_Param_Key(21,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_4", P[0]->Additional_Documentation_4, P[1]->Additional_Documentation_4);
	L[MGD77_Param_Key(22,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_5", P[0]->Additional_Documentation_5, P[1]->Additional_Documentation_5);
	L[MGD77_Param_Key(23,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_6", P[0]->Additional_Documentation_6, P[1]->Additional_Documentation_6);
	L[MGD77_Param_Key(24,1)].revised = MGD77_Get_Param (F, "Additional_Documentation_7", P[0]->Additional_Documentation_7, P[1]->Additional_Documentation_7);

	for (i = 0, F->revised = FALSE; !F->revised && i < MGD77_N_HEADER_PARAMS; i++) if (L[i].revised) F->revised = TRUE;
}

void MGD77_Write_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS **P)
{
	/* Write the MGD77 header parameters as attributes of the netCDF-encoded data set */
	
	struct MGD77_HEADER_LOOKUP *L;
	
	L = MGD77_Header_Lookup;
	
	MGD77_Put_Param (F, "Survey_Identifier", strlen (P[0]->Survey_Identifier), P[0]->Survey_Identifier, strlen (P[1]->Survey_Identifier), P[1]->Survey_Identifier, L[MGD77_Param_Key(1,2)].revised);
	MGD77_Put_Param (F, "Format_Acronym", strlen (P[0]->Format_Acronym), P[0]->Format_Acronym, strlen (P[1]->Format_Acronym), P[1]->Format_Acronym, L[MGD77_Param_Key(1,3)].revised);
	MGD77_Put_Param (F, "Data_Center_File_Number", strlen (P[0]->Data_Center_File_Number), P[0]->Data_Center_File_Number, strlen (P[1]->Data_Center_File_Number), P[1]->Data_Center_File_Number, L[MGD77_Param_Key(1,4)].revised);
	MGD77_Put_Param (F, "Parameters_Surveyed_Code", strlen (P[0]->Parameters_Surveyed_Code), P[0]->Parameters_Surveyed_Code, strlen (P[1]->Parameters_Surveyed_Code), P[1]->Parameters_Surveyed_Code, L[MGD77_Param_Key(1,5)].revised);
	MGD77_Put_Param (F, "File_Creation_Year", strlen (P[0]->File_Creation_Year), P[0]->File_Creation_Year, strlen (P[1]->File_Creation_Year), P[1]->File_Creation_Year, L[MGD77_Param_Key(1,10)].revised);
	MGD77_Put_Param (F, "File_Creation_Month", strlen (P[0]->File_Creation_Month), P[0]->File_Creation_Month, strlen (P[1]->File_Creation_Month), P[1]->File_Creation_Month, L[MGD77_Param_Key(1,11)].revised);
	MGD77_Put_Param (F, "File_Creation_Day", strlen (P[0]->File_Creation_Day), P[0]->File_Creation_Day, strlen (P[1]->File_Creation_Day), P[1]->File_Creation_Day, L[MGD77_Param_Key(1,12)].revised);
	MGD77_Put_Param (F, "Source_Institution", strlen (P[0]->Source_Institution), P[0]->Source_Institution, strlen (P[1]->Source_Institution), P[1]->Source_Institution, L[MGD77_Param_Key(1,13)].revised);
	MGD77_Put_Param (F, "Country", strlen (P[0]->Country), P[0]->Country, strlen (P[1]->Country), P[1]->Country, L[MGD77_Param_Key(2,1)].revised);
	MGD77_Put_Param (F, "Platform_Name", strlen (P[0]->Platform_Name), P[0]->Platform_Name, strlen (P[1]->Platform_Name), P[1]->Platform_Name, L[MGD77_Param_Key(2,2)].revised);
	MGD77_Put_Param (F, "Platform_Type_Code", (size_t)1, &P[0]->Platform_Type_Code, (size_t)1, &P[1]->Platform_Type_Code, L[MGD77_Param_Key(2,3)].revised);
	MGD77_Put_Param (F, "Platform_Type", strlen (P[0]->Platform_Type), P[0]->Platform_Type, strlen (P[1]->Platform_Type), P[1]->Platform_Type, L[MGD77_Param_Key(2,4)].revised);
	MGD77_Put_Param (F, "Chief_Scientist", strlen (P[0]->Chief_Scientist), P[0]->Chief_Scientist, strlen (P[1]->Chief_Scientist), P[1]->Chief_Scientist, L[MGD77_Param_Key(2,5)].revised);
	MGD77_Put_Param (F, "Project_Cruise_Leg", strlen (P[0]->Project_Cruise_Leg), P[0]->Project_Cruise_Leg, strlen (P[1]->Project_Cruise_Leg), P[1]->Project_Cruise_Leg, L[MGD77_Param_Key(3,1)].revised);
	MGD77_Put_Param (F, "Funding", strlen (P[0]->Funding), P[0]->Funding, strlen (P[1]->Funding), P[1]->Funding, L[MGD77_Param_Key(3,2)].revised);
	MGD77_Put_Param (F, "Survey_Departure_Year", strlen (P[0]->Survey_Departure_Year), P[0]->Survey_Departure_Year, strlen (P[1]->Survey_Departure_Year), P[1]->Survey_Departure_Year, L[MGD77_Param_Key(4,1)].revised);
	MGD77_Put_Param (F, "Survey_Departure_Month", strlen (P[0]->Survey_Departure_Month), P[0]->Survey_Departure_Month, strlen (P[1]->Survey_Departure_Month), P[1]->Survey_Departure_Month, L[MGD77_Param_Key(4,2)].revised);
	MGD77_Put_Param (F, "Survey_Departure_Day", strlen (P[0]->Survey_Departure_Day), P[0]->Survey_Departure_Day, strlen (P[1]->Survey_Departure_Day), P[1]->Survey_Departure_Day, L[MGD77_Param_Key(4,3)].revised);
	MGD77_Put_Param (F, "Port_of_Departure", strlen (P[0]->Port_of_Departure), P[0]->Port_of_Departure, strlen (P[1]->Port_of_Departure), P[1]->Port_of_Departure, L[MGD77_Param_Key(4,4)].revised);
	MGD77_Put_Param (F, "Survey_Arrival_Year", strlen (P[0]->Survey_Arrival_Year), P[0]->Survey_Arrival_Year, strlen (P[1]->Survey_Arrival_Year), P[1]->Survey_Arrival_Year, L[MGD77_Param_Key(4,5)].revised);
	MGD77_Put_Param (F, "Survey_Arrival_Month", strlen (P[0]->Survey_Arrival_Month), P[0]->Survey_Arrival_Month, strlen (P[1]->Survey_Arrival_Month), P[1]->Survey_Arrival_Month, L[MGD77_Param_Key(4,6)].revised);
	MGD77_Put_Param (F, "Survey_Arrival_Day", strlen (P[0]->Survey_Arrival_Day), P[0]->Survey_Arrival_Day, strlen (P[1]->Survey_Arrival_Day), P[1]->Survey_Arrival_Day, L[MGD77_Param_Key(4,7)].revised);
	MGD77_Put_Param (F, "Port_of_Arrival", strlen (P[0]->Port_of_Arrival), P[0]->Port_of_Arrival, strlen (P[1]->Port_of_Arrival), P[1]->Port_of_Arrival, L[MGD77_Param_Key(4,8)].revised);
	MGD77_Put_Param (F, "Navigation_Instrumentation", strlen (P[0]->Navigation_Instrumentation), P[0]->Navigation_Instrumentation, strlen (P[1]->Navigation_Instrumentation), P[1]->Navigation_Instrumentation, L[MGD77_Param_Key(5,1)].revised);
	MGD77_Put_Param (F, "Geodetic_Datum_Position_Determination_Method", strlen (P[0]->Geodetic_Datum_Position_Determination_Method), P[0]->Geodetic_Datum_Position_Determination_Method, strlen (P[1]->Geodetic_Datum_Position_Determination_Method), P[1]->Geodetic_Datum_Position_Determination_Method, L[MGD77_Param_Key(5,2)].revised);
	MGD77_Put_Param (F, "Bathymetry_Instrumentation", strlen (P[0]->Bathymetry_Instrumentation), P[0]->Bathymetry_Instrumentation, strlen (P[1]->Bathymetry_Instrumentation), P[1]->Bathymetry_Instrumentation, L[MGD77_Param_Key(6,1)].revised);
	MGD77_Put_Param (F, "Bathymetry_Add_Forms_of_Data", strlen (P[0]->Bathymetry_Add_Forms_of_Data), P[0]->Bathymetry_Add_Forms_of_Data, strlen (P[1]->Bathymetry_Add_Forms_of_Data), P[1]->Bathymetry_Add_Forms_of_Data, L[MGD77_Param_Key(6,2)].revised);
	MGD77_Put_Param (F, "Magnetics_Instrumentation", strlen (P[0]->Magnetics_Instrumentation), P[0]->Magnetics_Instrumentation, strlen (P[1]->Magnetics_Instrumentation), P[1]->Magnetics_Instrumentation, L[MGD77_Param_Key(7,1)].revised);
	MGD77_Put_Param (F, "Magnetics_Add_Forms_of_Data", strlen (P[0]->Magnetics_Add_Forms_of_Data), P[0]->Magnetics_Add_Forms_of_Data, strlen (P[1]->Magnetics_Add_Forms_of_Data), P[1]->Magnetics_Add_Forms_of_Data, L[MGD77_Param_Key(7,2)].revised);
	MGD77_Put_Param (F, "Gravity_Instrumentation", strlen (P[0]->Gravity_Instrumentation), P[0]->Gravity_Instrumentation, strlen (P[1]->Gravity_Instrumentation), P[1]->Gravity_Instrumentation, L[MGD77_Param_Key(8,1)].revised);
	MGD77_Put_Param (F, "Gravity_Add_Forms_of_Data", strlen (P[0]->Gravity_Add_Forms_of_Data), P[0]->Gravity_Add_Forms_of_Data, strlen (P[1]->Gravity_Add_Forms_of_Data), P[1]->Gravity_Add_Forms_of_Data, L[MGD77_Param_Key(8,2)].revised);
	MGD77_Put_Param (F, "Seismic_Instrumentation", strlen (P[0]->Seismic_Instrumentation), P[0]->Seismic_Instrumentation, strlen (P[1]->Seismic_Instrumentation), P[1]->Seismic_Instrumentation, L[MGD77_Param_Key(9,1)].revised);
	MGD77_Put_Param (F, "Seismic_Data_Formats", strlen (P[0]->Seismic_Data_Formats), P[0]->Seismic_Data_Formats, strlen (P[1]->Seismic_Data_Formats), P[1]->Seismic_Data_Formats, L[MGD77_Param_Key(9,2)].revised);
	MGD77_Put_Param (F, "Format_Type", (size_t)1, &P[0]->Format_Type, (size_t)1, &P[1]->Format_Type, L[MGD77_Param_Key(10,1)].revised);
	MGD77_Put_Param (F, "Format_Description", strlen (P[0]->Format_Description), P[0]->Format_Description, strlen (P[1]->Format_Description), P[1]->Format_Description, L[MGD77_Param_Key(10,2)].revised);
	MGD77_Put_Param (F, "Topmost_Latitude", strlen (P[0]->Topmost_Latitude), P[0]->Topmost_Latitude, strlen (P[1]->Topmost_Latitude), P[1]->Topmost_Latitude, L[MGD77_Param_Key(11,1)].revised);
	MGD77_Put_Param (F, "Bottommost_Latitude", strlen (P[0]->Bottommost_Latitude), P[0]->Bottommost_Latitude, strlen (P[1]->Bottommost_Latitude), P[1]->Bottommost_Latitude, L[MGD77_Param_Key(11,2)].revised);
	MGD77_Put_Param (F, "Leftmost_Longitude", strlen (P[0]->Leftmost_Longitude), P[0]->Leftmost_Longitude, strlen (P[1]->Leftmost_Longitude), P[1]->Leftmost_Longitude, L[MGD77_Param_Key(11,3)].revised);
	MGD77_Put_Param (F, "Rightmost_Longitude", strlen (P[0]->Rightmost_Longitude), P[0]->Rightmost_Longitude, strlen (P[1]->Rightmost_Longitude), P[1]->Rightmost_Longitude, L[MGD77_Param_Key(11,4)].revised);
	MGD77_Put_Param (F, "Bathymetry_Digitizing_Rate", strlen (P[0]->Bathymetry_Digitizing_Rate), P[0]->Bathymetry_Digitizing_Rate, strlen (P[1]->Bathymetry_Digitizing_Rate), P[1]->Bathymetry_Digitizing_Rate, L[MGD77_Param_Key(12,1)].revised);
	MGD77_Put_Param (F, "Bathymetry_Sampling_Rate", strlen (P[0]->Bathymetry_Sampling_Rate), P[0]->Bathymetry_Sampling_Rate, strlen (P[1]->Bathymetry_Sampling_Rate), P[1]->Bathymetry_Sampling_Rate, L[MGD77_Param_Key(12,2)].revised);
	MGD77_Put_Param (F, "Bathymetry_Assumed_Sound_Velocity", strlen (P[0]->Bathymetry_Assumed_Sound_Velocity), P[0]->Bathymetry_Assumed_Sound_Velocity, strlen (P[1]->Bathymetry_Assumed_Sound_Velocity), P[1]->Bathymetry_Assumed_Sound_Velocity, L[MGD77_Param_Key(12,3)].revised);
	MGD77_Put_Param (F, "Bathymetry_Datum_Code", strlen (P[0]->Bathymetry_Datum_Code), P[0]->Bathymetry_Datum_Code, strlen (P[1]->Bathymetry_Datum_Code), P[1]->Bathymetry_Datum_Code, L[MGD77_Param_Key(12,4)].revised);
	MGD77_Put_Param (F, "Bathymetry_Interpolation_Scheme", strlen (P[0]->Bathymetry_Interpolation_Scheme), P[0]->Bathymetry_Interpolation_Scheme, strlen (P[1]->Bathymetry_Interpolation_Scheme), P[1]->Bathymetry_Interpolation_Scheme, L[MGD77_Param_Key(12,5)].revised);
	MGD77_Put_Param (F, "Magnetics_Digitizing_Rate", strlen (P[0]->Magnetics_Digitizing_Rate), P[0]->Magnetics_Digitizing_Rate, strlen (P[1]->Magnetics_Digitizing_Rate), P[1]->Magnetics_Digitizing_Rate, L[MGD77_Param_Key(13,1)].revised);
	MGD77_Put_Param (F, "Magnetics_Sampling_Rate", strlen (P[0]->Magnetics_Sampling_Rate), P[0]->Magnetics_Sampling_Rate, strlen (P[1]->Magnetics_Sampling_Rate), P[1]->Magnetics_Sampling_Rate, L[MGD77_Param_Key(13,2)].revised);
	MGD77_Put_Param (F, "Magnetics_Sensor_Tow_Distance", strlen (P[0]->Magnetics_Sensor_Tow_Distance), P[0]->Magnetics_Sensor_Tow_Distance, strlen (P[1]->Magnetics_Sensor_Tow_Distance), P[1]->Magnetics_Sensor_Tow_Distance, L[MGD77_Param_Key(13,3)].revised);
	MGD77_Put_Param (F, "Magnetics_Sensor_Depth", strlen (P[0]->Magnetics_Sensor_Depth), P[0]->Magnetics_Sensor_Depth, strlen (P[1]->Magnetics_Sensor_Depth), P[1]->Magnetics_Sensor_Depth, L[MGD77_Param_Key(13,4)].revised);
	MGD77_Put_Param (F, "Magnetics_Sensor_Separation", strlen (P[0]->Magnetics_Sensor_Separation), P[0]->Magnetics_Sensor_Separation, strlen (P[1]->Magnetics_Sensor_Separation), P[1]->Magnetics_Sensor_Separation, L[MGD77_Param_Key(13,5)].revised);
	MGD77_Put_Param (F, "Magnetics_Ref_Field_Code", strlen (P[0]->Magnetics_Ref_Field_Code), P[0]->Magnetics_Ref_Field_Code, strlen (P[1]->Magnetics_Ref_Field_Code), P[1]->Magnetics_Ref_Field_Code, L[MGD77_Param_Key(13,6)].revised);
	MGD77_Put_Param (F, "Magnetics_Ref_Field", strlen (P[0]->Magnetics_Ref_Field), P[0]->Magnetics_Ref_Field, strlen (P[1]->Magnetics_Ref_Field), P[1]->Magnetics_Ref_Field, L[MGD77_Param_Key(13,7)].revised);
	MGD77_Put_Param (F, "Magnetics_Method_Applying_Res_Field", strlen (P[0]->Magnetics_Method_Applying_Res_Field), P[0]->Magnetics_Method_Applying_Res_Field, strlen (P[1]->Magnetics_Method_Applying_Res_Field), P[1]->Magnetics_Method_Applying_Res_Field, L[MGD77_Param_Key(13,8)].revised);
	MGD77_Put_Param (F, "Gravity_Digitizing_Rate", strlen (P[0]->Gravity_Digitizing_Rate), P[0]->Gravity_Digitizing_Rate, strlen (P[1]->Gravity_Digitizing_Rate), P[1]->Gravity_Digitizing_Rate, L[MGD77_Param_Key(14,1)].revised);
	MGD77_Put_Param (F, "Gravity_Sampling_Rate", strlen (P[0]->Gravity_Sampling_Rate), P[0]->Gravity_Sampling_Rate, strlen (P[1]->Gravity_Sampling_Rate), P[1]->Gravity_Sampling_Rate, L[MGD77_Param_Key(14,2)].revised);
	MGD77_Put_Param (F, "Gravity_Theoretical_Formula_Code", (size_t)1, &P[0]->Gravity_Theoretical_Formula_Code, (size_t)1, &P[1]->Gravity_Theoretical_Formula_Code, L[MGD77_Param_Key(14,3)].revised);
	MGD77_Put_Param (F, "Gravity_Theoretical_Formula", strlen (P[0]->Gravity_Theoretical_Formula), P[0]->Gravity_Theoretical_Formula, strlen (P[1]->Gravity_Theoretical_Formula), P[1]->Gravity_Theoretical_Formula, L[MGD77_Param_Key(14,4)].revised);
	MGD77_Put_Param (F, "Gravity_Reference_System_Code", (size_t)1, &P[0]->Gravity_Reference_System_Code, (size_t)1, &P[1]->Gravity_Reference_System_Code, L[MGD77_Param_Key(14,5)].revised);
	MGD77_Put_Param (F, "Gravity_Reference_System", strlen (P[0]->Gravity_Reference_System), P[0]->Gravity_Reference_System, strlen (P[1]->Gravity_Reference_System), P[1]->Gravity_Reference_System, L[MGD77_Param_Key(14,6)].revised);
	MGD77_Put_Param (F, "Gravity_Corrections_Applied", strlen (P[0]->Gravity_Corrections_Applied), P[0]->Gravity_Corrections_Applied, strlen (P[1]->Gravity_Corrections_Applied), P[1]->Gravity_Corrections_Applied, L[MGD77_Param_Key(14,7)].revised);
	MGD77_Put_Param (F, "Gravity_Departure_Base_Station", strlen (P[0]->Gravity_Departure_Base_Station), P[0]->Gravity_Departure_Base_Station, strlen (P[1]->Gravity_Departure_Base_Station), P[1]->Gravity_Departure_Base_Station, L[MGD77_Param_Key(15,1)].revised);
	MGD77_Put_Param (F, "Gravity_Departure_Base_Station_Name", strlen (P[0]->Gravity_Departure_Base_Station_Name), P[0]->Gravity_Departure_Base_Station_Name, strlen (P[1]->Gravity_Departure_Base_Station_Name), P[1]->Gravity_Departure_Base_Station_Name, L[MGD77_Param_Key(15,2)].revised);
	MGD77_Put_Param (F, "Gravity_Arrival_Base_Station", strlen (P[0]->Gravity_Arrival_Base_Station), P[0]->Gravity_Arrival_Base_Station, strlen (P[1]->Gravity_Arrival_Base_Station), P[1]->Gravity_Arrival_Base_Station, L[MGD77_Param_Key(15,3)].revised);
	MGD77_Put_Param (F, "Gravity_Arrival_Base_Station_Name", strlen (P[0]->Gravity_Arrival_Base_Station_Name), P[0]->Gravity_Arrival_Base_Station_Name, strlen (P[1]->Gravity_Arrival_Base_Station_Name), P[1]->Gravity_Arrival_Base_Station_Name, L[MGD77_Param_Key(15,4)].revised);
	MGD77_Put_Param (F, "Number_of_Ten_Degree_Identifiers", strlen (P[0]->Number_of_Ten_Degree_Identifiers), P[0]->Number_of_Ten_Degree_Identifiers, strlen (P[1]->Number_of_Ten_Degree_Identifiers), P[1]->Number_of_Ten_Degree_Identifiers, L[MGD77_Param_Key(16,1)].revised);
	MGD77_Put_Param (F, "Ten_Degree_Identifier", strlen (P[0]->Ten_Degree_Identifier), P[0]->Ten_Degree_Identifier, strlen (P[1]->Ten_Degree_Identifier), P[1]->Ten_Degree_Identifier, L[MGD77_Param_Key(16,2)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_1", strlen (P[0]->Additional_Documentation_1), P[0]->Additional_Documentation_1, strlen (P[1]->Additional_Documentation_1), P[1]->Additional_Documentation_1, L[MGD77_Param_Key(18,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_2", strlen (P[0]->Additional_Documentation_2), P[0]->Additional_Documentation_2, strlen (P[1]->Additional_Documentation_2), P[1]->Additional_Documentation_2, L[MGD77_Param_Key(19,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_3", strlen (P[0]->Additional_Documentation_3), P[0]->Additional_Documentation_3, strlen (P[1]->Additional_Documentation_3), P[1]->Additional_Documentation_3, L[MGD77_Param_Key(20,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_4", strlen (P[0]->Additional_Documentation_4), P[0]->Additional_Documentation_4, strlen (P[1]->Additional_Documentation_4), P[1]->Additional_Documentation_4, L[MGD77_Param_Key(21,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_5", strlen (P[0]->Additional_Documentation_5), P[0]->Additional_Documentation_5, strlen (P[1]->Additional_Documentation_5), P[1]->Additional_Documentation_5, L[MGD77_Param_Key(22,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_6", strlen (P[0]->Additional_Documentation_6), P[0]->Additional_Documentation_6, strlen (P[1]->Additional_Documentation_6), P[1]->Additional_Documentation_6, L[MGD77_Param_Key(23,1)].revised);
	MGD77_Put_Param (F, "Additional_Documentation_7", strlen (P[0]->Additional_Documentation_7), P[0]->Additional_Documentation_7, strlen (P[1]->Additional_Documentation_7), P[1]->Additional_Documentation_7, L[MGD77_Param_Key(24,1)].revised);
}

void MGD77_Dump_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS *P)
{
	char word[2] = { '\0', '\0'}, EOL = '\n';

	/* Write all the individual MGD77 header parameters to stdout */

	if (F->Want_Header_Item[0]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Identifier", P->Survey_Identifier, EOL);
	if (F->Want_Header_Item[1]) printf ("%s %44s : %s%c", F->NGDC_id, "Format_Acronym", P->Format_Acronym, EOL);
	if (F->Want_Header_Item[2]) printf ("%s %44s : %s%c", F->NGDC_id, "Data_Center_File_Number", P->Data_Center_File_Number, EOL);
	if (F->Want_Header_Item[3]) printf ("%s %44s : %s%c", F->NGDC_id, "Parameters_Surveyed_Code", P->Parameters_Surveyed_Code, EOL);
	if (F->Want_Header_Item[4]) printf ("%s %44s : %s%c", F->NGDC_id, "File_Creation_Year", P->File_Creation_Year, EOL);
	if (F->Want_Header_Item[5]) printf ("%s %44s : %s%c", F->NGDC_id, "File_Creation_Month", P->File_Creation_Month, EOL);
	if (F->Want_Header_Item[6]) printf ("%s %44s : %s%c", F->NGDC_id, "File_Creation_Day", P->File_Creation_Day, EOL);
	if (F->Want_Header_Item[7]) printf ("%s %44s : %s%c", F->NGDC_id, "Source_Institution", P->Source_Institution, EOL);
	if (F->Want_Header_Item[8]) printf ("%s %44s : %s%c", F->NGDC_id, "Country", P->Country, EOL);
	if (F->Want_Header_Item[9]) printf ("%s %44s : %s%c", F->NGDC_id, "Platform_Name", P->Platform_Name, EOL);
	word[0] = P->Platform_Type_Code;
	if (F->Want_Header_Item[10]) printf ("%s %44s : %s%c", F->NGDC_id, "Platform_Type_Code", word, EOL);
	if (F->Want_Header_Item[11]) printf ("%s %44s : %s%c", F->NGDC_id, "Platform_Type", P->Platform_Type, EOL);
	if (F->Want_Header_Item[12]) printf ("%s %44s : %s%c", F->NGDC_id, "Chief_Scientist", P->Chief_Scientist, EOL);
	if (F->Want_Header_Item[13]) printf ("%s %44s : %s%c", F->NGDC_id, "Project_Cruise_Leg", P->Project_Cruise_Leg, EOL);
	if (F->Want_Header_Item[14]) printf ("%s %44s : %s%c", F->NGDC_id, "Funding", P->Funding, EOL);
	if (F->Want_Header_Item[15]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Departure_Year", P->Survey_Departure_Year, EOL);
	if (F->Want_Header_Item[16]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Departure_Month", P->Survey_Departure_Month, EOL);
	if (F->Want_Header_Item[17]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Departure_Day", P->Survey_Departure_Day, EOL);
	if (F->Want_Header_Item[18]) printf ("%s %44s : %s%c", F->NGDC_id, "Port_of_Departure", P->Port_of_Departure, EOL);
	if (F->Want_Header_Item[19]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Arrival_Year", P->Survey_Arrival_Year, EOL);
	if (F->Want_Header_Item[20]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Arrival_Month", P->Survey_Arrival_Month, EOL);
	if (F->Want_Header_Item[21]) printf ("%s %44s : %s%c", F->NGDC_id, "Survey_Arrival_Day", P->Survey_Arrival_Day, EOL);
	if (F->Want_Header_Item[22]) printf ("%s %44s : %s%c", F->NGDC_id, "Port_of_Arrival", P->Port_of_Arrival, EOL);
	if (F->Want_Header_Item[23]) printf ("%s %44s : %s%c", F->NGDC_id, "Navigation_Instrumentation", P->Navigation_Instrumentation, EOL);
	if (F->Want_Header_Item[24]) printf ("%s %44s : %s%c", F->NGDC_id, "Geodetic_Datum_Position_Determination_Method", P->Geodetic_Datum_Position_Determination_Method, EOL);
	if (F->Want_Header_Item[25]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Instrumentation", P->Bathymetry_Instrumentation, EOL);
	if (F->Want_Header_Item[26]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Add_Forms_of_Data", P->Bathymetry_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[27]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Instrumentation", P->Magnetics_Instrumentation, EOL);
	if (F->Want_Header_Item[28]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Add_Forms_of_Data", P->Magnetics_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[29]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Instrumentation", P->Gravity_Instrumentation, EOL);
	if (F->Want_Header_Item[30]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Add_Forms_of_Data", P->Gravity_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[31]) printf ("%s %44s : %s%c", F->NGDC_id, "Seismic_Instrumentation", P->Seismic_Instrumentation, EOL);
	if (F->Want_Header_Item[32]) printf ("%s %44s : %s%c", F->NGDC_id, "Seismic_Data_Formats", P->Seismic_Data_Formats, EOL);
	word[0] = P->Format_Type;
	if (F->Want_Header_Item[33]) printf ("%s %44s : %s%c", F->NGDC_id, "Format_Type", word, EOL);
	if (F->Want_Header_Item[34]) printf ("%s %44s : %s%c", F->NGDC_id, "Format_Description", P->Format_Description, EOL);
	if (F->Want_Header_Item[35]) printf ("%s %44s : %s%c", F->NGDC_id, "Topmost_Latitude", P->Topmost_Latitude, EOL);
	if (F->Want_Header_Item[36]) printf ("%s %44s : %s%c", F->NGDC_id, "Bottommost_Latitude", P->Bottommost_Latitude, EOL);
	if (F->Want_Header_Item[37]) printf ("%s %44s : %s%c", F->NGDC_id, "Leftmost_Longitude", P->Leftmost_Longitude, EOL);
	if (F->Want_Header_Item[38]) printf ("%s %44s : %s%c", F->NGDC_id, "Rightmost_Longitude", P->Rightmost_Longitude, EOL);
	if (F->Want_Header_Item[39]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Digitizing_Rate", P->Bathymetry_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[40]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Sampling_Rate", P->Bathymetry_Sampling_Rate, EOL);
	if (F->Want_Header_Item[41]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Assumed_Sound_Velocity", P->Bathymetry_Assumed_Sound_Velocity, EOL);
	if (F->Want_Header_Item[42]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Datum_Code", P->Bathymetry_Datum_Code, EOL);
	if (F->Want_Header_Item[43]) printf ("%s %44s : %s%c", F->NGDC_id, "Bathymetry_Interpolation_Scheme", P->Bathymetry_Interpolation_Scheme, EOL);
	if (F->Want_Header_Item[44]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Digitizing_Rate", P->Magnetics_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[45]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Sampling_Rate", P->Magnetics_Sampling_Rate, EOL);
	if (F->Want_Header_Item[46]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Sensor_Tow_Distance", P->Magnetics_Sensor_Tow_Distance, EOL);
	if (F->Want_Header_Item[47]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Sensor_Depth", P->Magnetics_Sensor_Depth, EOL);
	if (F->Want_Header_Item[48]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Sensor_Separation", P->Magnetics_Sensor_Separation, EOL);
	if (F->Want_Header_Item[49]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Ref_Field_Code", P->Magnetics_Ref_Field_Code, EOL);
	if (F->Want_Header_Item[50]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Ref_Field", P->Magnetics_Ref_Field, EOL);
	if (F->Want_Header_Item[51]) printf ("%s %44s : %s%c", F->NGDC_id, "Magnetics_Method_Applying_Res_Field", P->Magnetics_Method_Applying_Res_Field, EOL);
	if (F->Want_Header_Item[52]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Digitizing_Rate", P->Gravity_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[53]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Sampling_Rate", P->Gravity_Sampling_Rate, EOL);
	word[0] = P->Gravity_Theoretical_Formula_Code;
	if (F->Want_Header_Item[54]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Theoretical_Formula_Code", word, EOL);
	if (F->Want_Header_Item[55]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Theoretical_Formula", P->Gravity_Theoretical_Formula, EOL);
	word[0] = P->Gravity_Reference_System_Code;
	if (F->Want_Header_Item[56]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Reference_System_Code", word, EOL);
	if (F->Want_Header_Item[57]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Reference_System", P->Gravity_Reference_System, EOL);
	if (F->Want_Header_Item[58]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Corrections_Applied", P->Gravity_Corrections_Applied, EOL);
	if (F->Want_Header_Item[59]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Departure_Base_Station", P->Gravity_Departure_Base_Station, EOL);
	if (F->Want_Header_Item[60]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Departure_Base_Station_Name", P->Gravity_Departure_Base_Station_Name, EOL);
	if (F->Want_Header_Item[61]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Arrival_Base_Station", P->Gravity_Arrival_Base_Station, EOL);
	if (F->Want_Header_Item[62]) printf ("%s %44s : %s%c", F->NGDC_id, "Gravity_Arrival_Base_Station_Name", P->Gravity_Arrival_Base_Station_Name, EOL);
	if (F->Want_Header_Item[63]) printf ("%s %44s : %s%c", F->NGDC_id, "Number_of_Ten_Degree_Identifiers", P->Number_of_Ten_Degree_Identifiers, EOL);
	if (F->Want_Header_Item[64]) printf ("%s %44s : %s%c", F->NGDC_id, "Ten_Degree_Identifier", P->Ten_Degree_Identifier, EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_1", P->Additional_Documentation_1, EOL);
	if (F->Want_Header_Item[66]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_2", P->Additional_Documentation_2, EOL);
	if (F->Want_Header_Item[67]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_3", P->Additional_Documentation_3, EOL);
	if (F->Want_Header_Item[68]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_4", P->Additional_Documentation_4, EOL);
	if (F->Want_Header_Item[69]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_5", P->Additional_Documentation_5, EOL);
	if (F->Want_Header_Item[70]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_6", P->Additional_Documentation_6, EOL);
	if (F->Want_Header_Item[71]) printf ("%s %44s : %s%c", F->NGDC_id, "Additional_Documentation_7", P->Additional_Documentation_7, EOL);
}

void MGD77_Reset_Header_Params (struct MGD77_CONTROL *F)
{
	/* Remove the revised MGD77 header attributes so we return to the original values.
	 * Here we simply ignore return values since many of these are presumably unknown attributes.
	 * File is assumed to be in define mode. */
	
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Identifier_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Acronym_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Data_Center_File_Number_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Parameters_Surveyed_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Source_Institution_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Country_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Type_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Type_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Chief_Scientist_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Project_Cruise_Leg_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Funding_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Port_of_Departure_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Port_of_Arrival_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Navigation_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Geodetic_Datum_Position_Determination_Method_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Seismic_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Seismic_Data_Formats_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Type_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Description_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Topmost_Latitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bottommost_Latitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Leftmost_Longitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Rightmost_Longitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Assumed_Sound_Velocity_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Datum_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Interpolation_Scheme_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Tow_Distance_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Depth_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Separation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Ref_Field_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Ref_Field_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Method_Applying_Res_Field_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Theoretical_Formula_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Theoretical_Formula_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Reference_System_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Reference_System_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Corrections_Applied_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Departure_Base_Station_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Departure_Base_Station_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Arrival_Base_Station_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Arrival_Base_Station_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Number_of_Ten_Degree_Identifiers_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Ten_Degree_Identifier_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_1_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_2_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_3_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_4_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_5_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_6_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_7_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "E77");
}

GMT_LONG MGD77_Get_Param (struct MGD77_CONTROL *F, char *name, char *value_orig, char *value_rev)
{	/* Get a single parameter: original if requested, otherwise check for revised value first */
	GMT_LONG got_rev = FALSE;
	
	if (!F->original) {	/* Must look for revised attribute unless explicitly turned off [ e.g, mgd77convert -FC] */
		char Att[64];
		sprintf (Att, "%s_REVISED", name);	/* Revised attributes have _REVISED at the end of their names */
		if (nc_get_att_text (F->nc_id, NC_GLOBAL, Att, value_rev) == NC_NOERR) got_rev = TRUE;	/* Found a revised attribute */
	}
	
	/* Next, we get the original value */
	
	MGD77_nc_status (nc_get_att_text (F->nc_id, NC_GLOBAL, name, value_orig));
	return (got_rev);
}

void MGD77_Put_Param (struct MGD77_CONTROL *F, char *name, size_t length_orig, char *value_orig, size_t length_rev, char *value_revised, GMT_LONG revised)
{	/* Function assumes we are in define mode. 
	 * Place a single parameter in one of several ways:
	 * revised == 2: Only write the revised attribute [This only happens in mgd77manage where we update a value via -Ae]
	 * revised == 1: Write both revised and original attribute;	[e.g., mgd77manage -D needs this]
	 * revised == 0: Only write original attribute;
	 * If F->original is TRUE place a revised attribute name.
	 */

	if (revised == 2 || revised == 0) MGD77_nc_status (nc_put_att_text (F->nc_id, NC_GLOBAL, name, length_orig, value_orig));
	if (revised) {	/* Write revised attribute */
		char Att[64];
		sprintf (Att, "%s_REVISED", name);	/* Revised attributes have _REVISED at the end of their names */
		MGD77_nc_status (nc_put_att_text (F->nc_id, NC_GLOBAL, Att, length_rev, value_revised));
	}
}
 
struct MGD77_HEADER_LOOKUP MGD77_Header_Lookup[MGD77_N_HEADER_PARAMS] = {
	{ "Survey_Identifier"                           ,   9,  1,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Format_Acronym"                              ,   6,  1,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Data_Center_File_Number"                     ,   9,  1,  4,  TRUE, FALSE, { NULL, NULL } },
	{ "Parameters_Surveyed_Code"                    ,   6,  1,  5,  TRUE, FALSE, { NULL, NULL } },
	{ "File_Creation_Year"                          ,   5,  1, 10,  TRUE, FALSE, { NULL, NULL } },
	{ "File_Creation_Month"                         ,   3,  1, 11,  TRUE, FALSE, { NULL, NULL } },
	{ "File_Creation_Day"                           ,   3,  1, 12,  TRUE, FALSE, { NULL, NULL } },
	{ "Source_Institution"                          ,  40,  1, 13, FALSE, FALSE, { NULL, NULL } },
	{ "Country"                                     ,  19,  2,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Platform_Name"                               ,  22,  2,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Platform_Type_Code"                          ,   1,  2,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Platform_Type"                               ,   7,  2,  4, FALSE, FALSE, { NULL, NULL } },
	{ "Chief_Scientist"                             ,  33,  2,  5, FALSE, FALSE, { NULL, NULL } },
	{ "Project_Cruise_Leg"                          ,  59,  3,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Funding"                                     ,  21,  3,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Survey_Departure_Year"                       ,   5,  4,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Survey_Departure_Month"                      ,   3,  4,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Survey_Departure_Day"                        ,   3,  4,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Port_of_Departure"                           ,  33,  4,  4, FALSE, FALSE, { NULL, NULL } },
	{ "Survey_Arrival_Year"                         ,   5,  4,  5,  TRUE, FALSE, { NULL, NULL } },
	{ "Survey_Arrival_Month"                        ,   3,  4,  6,  TRUE, FALSE, { NULL, NULL } },
	{ "Survey_Arrival_Day"                          ,   3,  4,  7,  TRUE, FALSE, { NULL, NULL } },
	{ "Port_of_Arrival"                             ,  31,  4,  8, FALSE, FALSE, { NULL, NULL } },
	{ "Navigation_Instrumentation"                  ,  41,  5,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Geodetic_Datum_Position_Determination_Method",  39,  5,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Instrumentation"                  ,  41,  6,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Add_Forms_of_Data"                ,  39,  6,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Magnetics_Instrumentation"                   ,  41,  7,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Magnetics_Add_Forms_of_Data"                 ,  39,  7,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Instrumentation"                     ,  41,  8,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Add_Forms_of_Data"                   ,  39,  8,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Seismic_Instrumentation"                     ,  41,  9,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Seismic_Data_Formats"                        ,  39,  9,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Format_Type"                                 ,   1, 10,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Format_Description"                          ,  95, 10,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Topmost_Latitude"                            ,   4, 11,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Bottommost_Latitude"                         ,   4, 11,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Leftmost_Longitude"                          ,   5, 11,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Rightmost_Longitude"                         ,   5, 11,  4,  TRUE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Digitizing_Rate"                  ,   4, 12,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Sampling_Rate"                    ,  13, 12,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Assumed_Sound_Velocity"           ,   6, 12,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Datum_Code"                       ,   3, 12,  4,  TRUE, FALSE, { NULL, NULL } },
	{ "Bathymetry_Interpolation_Scheme"             ,  57, 12,  5, FALSE, FALSE, { NULL, NULL } },
	{ "Magnetics_Digitizing_Rate"                   ,   4, 13,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Sampling_Rate"                     ,   3, 13,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Sensor_Tow_Distance"               ,   5, 13,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Sensor_Depth"                      ,   6, 13,  4,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Sensor_Separation"                 ,   4, 13,  5,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Ref_Field_Code"                    ,   3, 13,  6,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Ref_Field"                         ,  13, 13,  7,  TRUE, FALSE, { NULL, NULL } },
	{ "Magnetics_Method_Applying_Res_Field"         ,  48, 13,  8, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Digitizing_Rate"                     ,   4, 14,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Sampling_Rate"                       ,   3, 14,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Theoretical_Formula_Code"            ,   1, 14,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Theoretical_Formula"                 ,  18, 14,  4, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Reference_System_Code"               ,   1, 14,  5,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Reference_System"                    ,  17, 14,  6, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Corrections_Applied"                 ,  39, 14,  7, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Departure_Base_Station"              ,   8, 15,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Departure_Base_Station_Name"         ,  34, 15,  2, FALSE, FALSE, { NULL, NULL } },
	{ "Gravity_Arrival_Base_Station"                ,   8, 15,  3,  TRUE, FALSE, { NULL, NULL } },
	{ "Gravity_Arrival_Base_Station_Name"           ,  32, 15,  4, FALSE, FALSE, { NULL, NULL } },
	{ "Number_of_Ten_Degree_Identifiers"            ,   3, 16,  1,  TRUE, FALSE, { NULL, NULL } },
	{ "Ten_Degree_Identifier"                       , 151, 16,  2,  TRUE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_1"                  ,  79, 18,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_2"                  ,  79, 19,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_3"                  ,  79, 20,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_4"                  ,  79, 21,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_5"                  ,  79, 22,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_6"                  ,  79, 23,  1, FALSE, FALSE, { NULL, NULL } },
	{ "Additional_Documentation_7"                  ,  79, 24,  1, FALSE, FALSE, { NULL, NULL } },
};

void MGD77_Init_Ptr (struct MGD77_HEADER_LOOKUP *H, struct MGD77_HEADER_PARAMS **P)
{	/* Assigns array of pointers to each idividual parameter */
	int i;

	for (i = 0; i < 2; i++) H[0].ptr[i] = P[i]->Survey_Identifier;
	for (i = 0; i < 2; i++) H[1].ptr[i] = P[i]->Format_Acronym;
	for (i = 0; i < 2; i++) H[2].ptr[i] = P[i]->Data_Center_File_Number;
	for (i = 0; i < 2; i++) H[3].ptr[i] = P[i]->Parameters_Surveyed_Code;
	for (i = 0; i < 2; i++) H[4].ptr[i] = P[i]->File_Creation_Year;
	for (i = 0; i < 2; i++) H[5].ptr[i] = P[i]->File_Creation_Month;
	for (i = 0; i < 2; i++) H[6].ptr[i] = P[i]->File_Creation_Day;
	for (i = 0; i < 2; i++) H[7].ptr[i] = P[i]->Source_Institution;
	for (i = 0; i < 2; i++) H[8].ptr[i] = P[i]->Country;
	for (i = 0; i < 2; i++) H[9].ptr[i] = P[i]->Platform_Name;
	for (i = 0; i < 2; i++) H[10].ptr[i] = &P[i]->Platform_Type_Code;
	for (i = 0; i < 2; i++) H[11].ptr[i] = P[i]->Platform_Type;
	for (i = 0; i < 2; i++) H[12].ptr[i] = P[i]->Chief_Scientist;
	for (i = 0; i < 2; i++) H[13].ptr[i] = P[i]->Project_Cruise_Leg;
	for (i = 0; i < 2; i++) H[14].ptr[i] = P[i]->Funding;
	for (i = 0; i < 2; i++) H[15].ptr[i] = P[i]->Survey_Departure_Year;
	for (i = 0; i < 2; i++) H[16].ptr[i] = P[i]->Survey_Departure_Month;
	for (i = 0; i < 2; i++) H[17].ptr[i] = P[i]->Survey_Departure_Day;
	for (i = 0; i < 2; i++) H[18].ptr[i] = P[i]->Port_of_Departure;
	for (i = 0; i < 2; i++) H[19].ptr[i] = P[i]->Survey_Arrival_Year;
	for (i = 0; i < 2; i++) H[20].ptr[i] = P[i]->Survey_Arrival_Month;
	for (i = 0; i < 2; i++) H[21].ptr[i] = P[i]->Survey_Arrival_Day;
	for (i = 0; i < 2; i++) H[22].ptr[i] = P[i]->Port_of_Arrival;
	for (i = 0; i < 2; i++) H[23].ptr[i] = P[i]->Navigation_Instrumentation;
	for (i = 0; i < 2; i++) H[24].ptr[i] = P[i]->Geodetic_Datum_Position_Determination_Method;
	for (i = 0; i < 2; i++) H[25].ptr[i] = P[i]->Bathymetry_Instrumentation;
	for (i = 0; i < 2; i++) H[26].ptr[i] = P[i]->Bathymetry_Add_Forms_of_Data;
	for (i = 0; i < 2; i++) H[27].ptr[i] = P[i]->Magnetics_Instrumentation;
	for (i = 0; i < 2; i++) H[28].ptr[i] = P[i]->Magnetics_Add_Forms_of_Data;
	for (i = 0; i < 2; i++) H[29].ptr[i] = P[i]->Gravity_Instrumentation;
	for (i = 0; i < 2; i++) H[30].ptr[i] = P[i]->Gravity_Add_Forms_of_Data;
	for (i = 0; i < 2; i++) H[31].ptr[i] = P[i]->Seismic_Instrumentation;
	for (i = 0; i < 2; i++) H[32].ptr[i] = P[i]->Seismic_Data_Formats;
	for (i = 0; i < 2; i++) H[33].ptr[i] = &P[i]->Format_Type;
	for (i = 0; i < 2; i++) H[34].ptr[i] = P[i]->Format_Description;
	for (i = 0; i < 2; i++) H[35].ptr[i] = P[i]->Topmost_Latitude;
	for (i = 0; i < 2; i++) H[36].ptr[i] = P[i]->Bottommost_Latitude;
	for (i = 0; i < 2; i++) H[37].ptr[i] = P[i]->Leftmost_Longitude;
	for (i = 0; i < 2; i++) H[38].ptr[i] = P[i]->Rightmost_Longitude;
	for (i = 0; i < 2; i++) H[39].ptr[i] = P[i]->Bathymetry_Digitizing_Rate;
	for (i = 0; i < 2; i++) H[40].ptr[i] = P[i]->Bathymetry_Sampling_Rate;
	for (i = 0; i < 2; i++) H[41].ptr[i] = P[i]->Bathymetry_Assumed_Sound_Velocity;
	for (i = 0; i < 2; i++) H[42].ptr[i] = P[i]->Bathymetry_Datum_Code;
	for (i = 0; i < 2; i++) H[43].ptr[i] = P[i]->Bathymetry_Interpolation_Scheme;
	for (i = 0; i < 2; i++) H[44].ptr[i] = P[i]->Magnetics_Digitizing_Rate;
	for (i = 0; i < 2; i++) H[45].ptr[i] = P[i]->Magnetics_Sampling_Rate;
	for (i = 0; i < 2; i++) H[46].ptr[i] = P[i]->Magnetics_Sensor_Tow_Distance;
	for (i = 0; i < 2; i++) H[47].ptr[i] = P[i]->Magnetics_Sensor_Depth;
	for (i = 0; i < 2; i++) H[48].ptr[i] = P[i]->Magnetics_Sensor_Separation;
	for (i = 0; i < 2; i++) H[49].ptr[i] = P[i]->Magnetics_Ref_Field_Code;
	for (i = 0; i < 2; i++) H[50].ptr[i] = P[i]->Magnetics_Ref_Field;
	for (i = 0; i < 2; i++) H[51].ptr[i] = P[i]->Magnetics_Method_Applying_Res_Field;
	for (i = 0; i < 2; i++) H[52].ptr[i] = P[i]->Gravity_Digitizing_Rate;
	for (i = 0; i < 2; i++) H[53].ptr[i] = P[i]->Gravity_Sampling_Rate;
	for (i = 0; i < 2; i++) H[54].ptr[i] = &P[i]->Gravity_Theoretical_Formula_Code;
	for (i = 0; i < 2; i++) H[55].ptr[i] = P[i]->Gravity_Theoretical_Formula;
	for (i = 0; i < 2; i++) H[56].ptr[i] = &P[i]->Gravity_Reference_System_Code;
	for (i = 0; i < 2; i++) H[57].ptr[i] = P[i]->Gravity_Reference_System;
	for (i = 0; i < 2; i++) H[58].ptr[i] = P[i]->Gravity_Corrections_Applied;
	for (i = 0; i < 2; i++) H[59].ptr[i] = P[i]->Gravity_Departure_Base_Station;
	for (i = 0; i < 2; i++) H[60].ptr[i] = P[i]->Gravity_Departure_Base_Station_Name;
	for (i = 0; i < 2; i++) H[61].ptr[i] = P[i]->Gravity_Arrival_Base_Station;
	for (i = 0; i < 2; i++) H[62].ptr[i] = P[i]->Gravity_Arrival_Base_Station_Name;
	for (i = 0; i < 2; i++) H[63].ptr[i] = P[i]->Number_of_Ten_Degree_Identifiers;
	for (i = 0; i < 2; i++) H[64].ptr[i] = P[i]->Ten_Degree_Identifier;
	for (i = 0; i < 2; i++) H[65].ptr[i] = P[i]->Additional_Documentation_1;
	for (i = 0; i < 2; i++) H[66].ptr[i] = P[i]->Additional_Documentation_2;
	for (i = 0; i < 2; i++) H[67].ptr[i] = P[i]->Additional_Documentation_3;
	for (i = 0; i < 2; i++) H[68].ptr[i] = P[i]->Additional_Documentation_4;
	for (i = 0; i < 2; i++) H[69].ptr[i] = P[i]->Additional_Documentation_5;
	for (i = 0; i < 2; i++) H[70].ptr[i] = P[i]->Additional_Documentation_6;
	for (i = 0; i < 2; i++) H[71].ptr[i] = P[i]->Additional_Documentation_7;
}
