/*
 * GkDebconf -- Help to configure packages with debconf
 * Copyleft (C) 2003 Agney Lopes Roth Ferraz <agney@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "../config.h"

#include "defines.h"
#include "config.h"

#define GCONF_DIR "/apps/gkdebconf"

/**
 * write_config:
 *
 * @option: gconf option in gkdebconf registry.
 * @data: the value of option.
 *
 *  Writes and gconf2 registry on gkdebconf registry.
 * Returns: 0 on succes and 1 on error.
 */

int
write_config (gchar *option, gchar *data)
{
  GConfClient *confclient = NULL;
  GError *err = NULL;
  gchar *confkey = NULL;

  confclient = gconf_client_get_default ();
  confkey = g_strdup_printf ("%s/%s", GCONF_DIR, option);
  gconf_client_set_string (confclient, confkey, data, &err);
  if (err != NULL)
    {
      fprintf (stderr, "option: %s\ndata: %s\nresult: %s\n",
               option, data, err->message);
      g_error_free (err);
      return 1;
    }

  g_free (confkey);
  return 0;
}

/**
 * read_config:
 *
 * @option: gconf key in gkdebconf registry.
 *
 *  Reads and gconf2 key on gkdebconf registry.
 *
 * Returns: The key (option) value. ¨none¨ if failed.
 */

char*
read_config (gchar *option)
{
  GConfClient *confclient = NULL;
  GError *err = NULL;
  gchar *confkey = NULL;
  gchar *data = NULL;

  confclient = gconf_client_get_default ();
  confkey = g_strdup_printf ("%s/%s", GCONF_DIR, option);
  data = gconf_client_get_string (confclient, confkey, &err);
  if (data == NULL)
    {
      if (err != NULL)
        {
          fprintf (stderr, _("Error getting data: %s"),
                   err->message);
          g_error_free (err);
        }
      data = g_strdup ("none");
    }

  g_free (confkey);
  return data;
}

/**
 * remember_fe_cb:
 *
 * @data: data in w.
 * @action: the event that happens on w.
 * @w: widget that will be checked if is active or not.
 *
 *  Update remember_frontend key on gkdebconf gconf2 registry.
 */

void
remember_fe_cb (gpointer data, guint action, GtkWidget *w )
{
  if (GTK_CHECK_MENU_ITEM(w)->active)
    write_config ("remember_frontend", "yes");
  else
    write_config ("remember_frontend", "no");
}

/**
 * show_libgnome_missing_alert:
 *
 * @data: data in w.
 * @action: the event that happens on w.
 * @w: widget that will be checked if is active or not.
 *
 *  Update libgnome_alert key on gkdebconf gconf2 registry.
 */

void
show_libgnome_missing_alert (gpointer data, guint action, GtkWidget *w )
{
  if (GTK_CHECK_MENU_ITEM(w)->active)
    write_config ("libgnome_alert", "yes");
  else
    write_config ("libgnome_alert", "no");
}
