#! /bin/sh
#
# Assumes ../upstream is a git checkout of upstream

set -e

VERSION=0.9.0
DATE=`date +%Y%m%d`

dirname=gccxml-${VERSION}+git${DATE}.orig
tarname=gccxml_${VERSION}+git${DATE}.orig.tar.xz

echo "to run correctly this script needs the upstream git repository located in the ../upstream directory"
cd ../upstream
git pull

cd ..
rm -rf ${dirname}
cp -a upstream ${dirname}
rm -rf ${dirname}/.git*
find ${dirname} -name .gitattributes -exec rm {} \;

# Remove files with (a) no license, or (b) non-free license.
#
rm -rf ${dirname}/GCC_XML/Support/Borland
rm -f  ${dirname}/GCC/libiberty/xatexit.c

# Remove prebuilt windows binaries
rm -rf ${dirname}/GCC/config_cmake/nawk.exe
rm -rf ${dirname}/GCC_XML/VcInstall/vcCat.exe
rm -rf ${dirname}/GCC_XML/VcInstall/vcPatch.exe

# Build tarball
#
mkdir -p tarballs
GZIP="--best --no-name" tar cfJ tarballs/${tarname} ${dirname}
rm -rf ${dirname}
echo "your new package is located in ../tarballs/${tarname}"
