/*
 * Copyright 2011, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * THIS FILE WAS GENERATED BY A SCRIPT. DO NOT EDIT.
 */

#include <cutils/log.h>
#include <utils/Timers.h>
#include <GLES2/gl2.h>

#include "gltrace.pb.h"
#include "gltrace_context.h"
#include "gltrace_fixup.h"
#include "gltrace_transport.h"

namespace android {
namespace gltrace {

// Definitions for GL2 APIs

void GLTrace_glActiveTexture(GLenum texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glActiveTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glActiveTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAttachShader(GLuint program, GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAttachShader);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAttachShader(program, shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindAttribLocation(GLuint program, GLuint index, const GLchar* name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindAttribLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindAttribLocation(program, index, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindBuffer(GLenum target, GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindBuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindBuffer(target, buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindFramebuffer(GLenum target, GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindFramebuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindFramebuffer(target, framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindRenderbuffer(GLenum target, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindRenderbuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindRenderbuffer(target, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindTexture(GLenum target, GLuint texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindTexture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindTexture(target, texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendColor);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendColor(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquation(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquation);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquation(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationSeparate);

    // copy argument modeRGB
    GLMessage_DataType *arg_modeRGB = glmsg.add_args();
    arg_modeRGB->set_isarray(false);
    arg_modeRGB->set_type(GLMessage::DataType::ENUM);
    arg_modeRGB->add_intvalue((int)modeRGB);

    // copy argument modeAlpha
    GLMessage_DataType *arg_modeAlpha = glmsg.add_args();
    arg_modeAlpha->set_isarray(false);
    arg_modeAlpha->set_type(GLMessage::DataType::ENUM);
    arg_modeAlpha->add_intvalue((int)modeAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationSeparate(modeRGB, modeAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFunc(GLenum sfactor, GLenum dfactor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFunc);

    // copy argument sfactor
    GLMessage_DataType *arg_sfactor = glmsg.add_args();
    arg_sfactor->set_isarray(false);
    arg_sfactor->set_type(GLMessage::DataType::ENUM);
    arg_sfactor->add_intvalue((int)sfactor);

    // copy argument dfactor
    GLMessage_DataType *arg_dfactor = glmsg.add_args();
    arg_dfactor->set_isarray(false);
    arg_dfactor->set_type(GLMessage::DataType::ENUM);
    arg_dfactor->add_intvalue((int)dfactor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFunc(sfactor, dfactor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFuncSeparate(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFuncSeparate);

    // copy argument srcRGB
    GLMessage_DataType *arg_srcRGB = glmsg.add_args();
    arg_srcRGB->set_isarray(false);
    arg_srcRGB->set_type(GLMessage::DataType::ENUM);
    arg_srcRGB->add_intvalue((int)srcRGB);

    // copy argument dstRGB
    GLMessage_DataType *arg_dstRGB = glmsg.add_args();
    arg_dstRGB->set_isarray(false);
    arg_dstRGB->set_type(GLMessage::DataType::ENUM);
    arg_dstRGB->add_intvalue((int)dstRGB);

    // copy argument srcAlpha
    GLMessage_DataType *arg_srcAlpha = glmsg.add_args();
    arg_srcAlpha->set_isarray(false);
    arg_srcAlpha->set_type(GLMessage::DataType::ENUM);
    arg_srcAlpha->add_intvalue((int)srcAlpha);

    // copy argument dstAlpha
    GLMessage_DataType *arg_dstAlpha = glmsg.add_args();
    arg_dstAlpha->set_isarray(false);
    arg_dstAlpha->set_type(GLMessage::DataType::ENUM);
    arg_dstAlpha->add_intvalue((int)dstAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBufferData(GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBufferData);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // copy argument usage
    GLMessage_DataType *arg_usage = glmsg.add_args();
    arg_usage->set_isarray(false);
    arg_usage->set_type(GLMessage::DataType::ENUM);
    arg_usage->add_intvalue((int)usage);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBufferData(target, size, data, usage);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBufferSubData);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument offset
    GLMessage_DataType *arg_offset = glmsg.add_args();
    arg_offset->set_isarray(false);
    arg_offset->set_type(GLMessage::DataType::INT);
    arg_offset->add_intvalue(offset);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBufferSubData(target, offset, size, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glCheckFramebufferStatus(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCheckFramebufferStatus);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glCheckFramebufferStatus(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glClear(GLbitfield mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClear);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClear(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearColor);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearColor(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthf(GLclampf depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthf);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::FLOAT);
    arg_depth->add_floatvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthf(depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearStencil(GLint s) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearStencil);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::INT);
    arg_s->add_intvalue(s);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearStencil(s);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColorMask);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::BOOL);
    arg_red->add_boolvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::BOOL);
    arg_green->add_boolvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::BOOL);
    arg_blue->add_boolvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::BOOL);
    arg_alpha->add_boolvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColorMask(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompileShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompileShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompileShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid* data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid* data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glCreateProgram(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateProgram);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateProgram();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLuint GLTrace_glCreateShader(GLenum type) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateShader);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateShader(type);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glCullFace(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCullFace);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCullFace(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteBuffers(GLsizei n, const GLuint* buffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteBuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT);
    arg_buffers->add_intvalue((int)buffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteBuffers(n, buffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteFramebuffers(GLsizei n, const GLuint* framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteFramebuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT);
    arg_framebuffers->add_intvalue((int)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteFramebuffers(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteRenderbuffers(GLsizei n, const GLuint* renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteRenderbuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT);
    arg_renderbuffers->add_intvalue((int)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteRenderbuffers(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteTextures(GLsizei n, const GLuint* textures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteTextures);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT);
    arg_textures->add_intvalue((int)textures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteTextures(n, textures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthFunc(GLenum func) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthFunc(func);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthMask(GLboolean flag) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthMask);

    // copy argument flag
    GLMessage_DataType *arg_flag = glmsg.add_args();
    arg_flag->set_isarray(false);
    arg_flag->set_type(GLMessage::DataType::BOOL);
    arg_flag->add_boolvalue(flag);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthMask(flag);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthRangef(GLclampf zNear, GLclampf zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangef);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangef(zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDetachShader(GLuint program, GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDetachShader);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDetachShader(program, shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisable(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisable);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisable(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableVertexAttribArray(GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableVertexAttribArray);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableVertexAttribArray(index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawArrays(GLenum mode, GLint first, GLsizei count) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawArrays);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue(first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawArrays(mode, first, count);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid* indices) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawElements);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT);
    arg_indices->add_intvalue((int)indices);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawElements(mode, count, type, indices);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnable(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnable);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnable(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableVertexAttribArray(GLuint index) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableVertexAttribArray);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableVertexAttribArray(index);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFinish(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFinish);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFinish();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFlush(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFlush);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFlush();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferRenderbuffer);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument renderbuffertarget
    GLMessage_DataType *arg_renderbuffertarget = glmsg.add_args();
    arg_renderbuffertarget->set_isarray(false);
    arg_renderbuffertarget->set_type(GLMessage::DataType::ENUM);
    arg_renderbuffertarget->add_intvalue((int)renderbuffertarget);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2D(target, attachment, textarget, texture, level);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrontFace(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrontFace);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrontFace(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenBuffers(GLsizei n, GLuint* buffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenBuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT);
    arg_buffers->add_intvalue((int)buffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenBuffers(n, buffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenerateMipmap(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenerateMipmap);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenerateMipmap(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenFramebuffers(GLsizei n, GLuint* framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenFramebuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT);
    arg_framebuffers->add_intvalue((int)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenFramebuffers(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenRenderbuffers(GLsizei n, GLuint* renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenRenderbuffers);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT);
    arg_renderbuffers->add_intvalue((int)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenRenderbuffers(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenTextures(GLsizei n, GLuint* textures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenTextures);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT);
    arg_textures->add_intvalue((int)textures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenTextures(n, textures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, GLchar* name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveAttrib);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue((int)size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::INT);
    arg_type->add_intvalue((int)type);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveAttrib(program, index, bufsize, length, size, type, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) size,
        (void *) type,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetActiveUniform(GLuint program, GLuint index, GLsizei bufsize, GLsizei* length, GLint* size, GLenum* type, GLchar* name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetActiveUniform);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue((int)size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::INT);
    arg_type->add_intvalue((int)type);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetActiveUniform(program, index, bufsize, length, size, type, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) size,
        (void *) type,
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetAttachedShaders(GLuint program, GLsizei maxcount, GLsizei* count, GLuint* shaders) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetAttachedShaders);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument maxcount
    GLMessage_DataType *arg_maxcount = glmsg.add_args();
    arg_maxcount->set_isarray(false);
    arg_maxcount->set_type(GLMessage::DataType::INT);
    arg_maxcount->add_intvalue(maxcount);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue((int)count);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT);
    arg_shaders->add_intvalue((int)shaders);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetAttachedShaders(program, maxcount, count, shaders);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) count,
        (void *) shaders,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

int GLTrace_glGetAttribLocation(GLuint program, const GLchar* name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetAttribLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    int retValue = glContext->hooks->gl.glGetAttribLocation(program, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetBooleanv(GLenum pname, GLboolean* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBooleanv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBooleanv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetBufferParameteriv(GLenum target, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glGetError(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetError);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glGetError();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetFloatv(GLenum pname, GLfloat* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFloatv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFloatv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFramebufferAttachmentParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetIntegerv(GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetIntegerv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetIntegerv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramiv(GLuint program, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramiv(program, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramInfoLog(GLuint program, GLsizei bufsize, GLsizei* length, GLchar* infolog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramInfoLog);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument infolog
    GLMessage_DataType *arg_infolog = glmsg.add_args();
    arg_infolog->set_isarray(false);
    arg_infolog->set_type(GLMessage::DataType::INT);
    arg_infolog->add_intvalue((int)infolog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramInfoLog(program, bufsize, length, infolog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infolog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetRenderbufferParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetRenderbufferParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderiv(GLuint shader, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderiv);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderiv(shader, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderInfoLog(GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* infolog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderInfoLog);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument infolog
    GLMessage_DataType *arg_infolog = glmsg.add_args();
    arg_infolog->set_isarray(false);
    arg_infolog->set_type(GLMessage::DataType::INT);
    arg_infolog->add_intvalue((int)infolog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderInfoLog(shader, bufsize, length, infolog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infolog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint* range, GLint* precision) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderPrecisionFormat);

    // copy argument shadertype
    GLMessage_DataType *arg_shadertype = glmsg.add_args();
    arg_shadertype->set_isarray(false);
    arg_shadertype->set_type(GLMessage::DataType::ENUM);
    arg_shadertype->add_intvalue((int)shadertype);

    // copy argument precisiontype
    GLMessage_DataType *arg_precisiontype = glmsg.add_args();
    arg_precisiontype->set_isarray(false);
    arg_precisiontype->set_type(GLMessage::DataType::ENUM);
    arg_precisiontype->add_intvalue((int)precisiontype);

    // copy argument range
    GLMessage_DataType *arg_range = glmsg.add_args();
    arg_range->set_isarray(false);
    arg_range->set_type(GLMessage::DataType::INT);
    arg_range->add_intvalue((int)range);

    // copy argument precision
    GLMessage_DataType *arg_precision = glmsg.add_args();
    arg_precision->set_isarray(false);
    arg_precision->set_type(GLMessage::DataType::INT);
    arg_precision->add_intvalue((int)precision);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) range,
        (void *) precision,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetShaderSource(GLuint shader, GLsizei bufsize, GLsizei* length, GLchar* source) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetShaderSource);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument bufsize
    GLMessage_DataType *arg_bufsize = glmsg.add_args();
    arg_bufsize->set_isarray(false);
    arg_bufsize->set_type(GLMessage::DataType::INT);
    arg_bufsize->add_intvalue(bufsize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::INT);
    arg_source->add_intvalue((int)source);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetShaderSource(shader, bufsize, length, source);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) source,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

const GLubyte* GLTrace_glGetString(GLenum name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetString);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::ENUM);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    const GLubyte* retValue = glContext->hooks->gl.glGetString(name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetTexParameterfv(GLenum target, GLenum pname, GLfloat* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameteriv(GLenum target, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformfv(GLuint program, GLint location, GLfloat* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformfv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformfv(program, location, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetUniformiv(GLuint program, GLint location, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformiv);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetUniformiv(program, location, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

int GLTrace_glGetUniformLocation(GLuint program, const GLchar* name) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetUniformLocation);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument name
    GLMessage_DataType *arg_name = glmsg.add_args();
    arg_name->set_isarray(false);
    arg_name->set_type(GLMessage::DataType::INT);
    arg_name->add_intvalue((int)name);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    int retValue = glContext->hooks->gl.glGetUniformLocation(program, name);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) name,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribfv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribfv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribiv(GLuint index, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribiv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribiv(index, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid** pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetVertexAttribPointerv);

    // copy argument index
    GLMessage_DataType *arg_index = glmsg.add_args();
    arg_index->set_isarray(false);
    arg_index->set_type(GLMessage::DataType::INT);
    arg_index->add_intvalue(index);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetVertexAttribPointerv(index, pname, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glHint(GLenum target, GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glHint);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glHint(target, mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsBuffer(GLuint buffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsBuffer);

    // copy argument buffer
    GLMessage_DataType *arg_buffer = glmsg.add_args();
    arg_buffer->set_isarray(false);
    arg_buffer->set_type(GLMessage::DataType::INT);
    arg_buffer->add_intvalue(buffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsBuffer(buffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsEnabled(GLenum cap) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsEnabled);

    // copy argument cap
    GLMessage_DataType *arg_cap = glmsg.add_args();
    arg_cap->set_isarray(false);
    arg_cap->set_type(GLMessage::DataType::ENUM);
    arg_cap->add_intvalue((int)cap);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsEnabled(cap);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsFramebuffer(GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsFramebuffer);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsFramebuffer(framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsRenderbuffer(GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsRenderbuffer);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsRenderbuffer(renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsShader(GLuint shader) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsShader);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsShader(shader);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glIsTexture(GLuint texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glLineWidth(GLfloat width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLineWidth);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::FLOAT);
    arg_width->add_floatvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLineWidth(width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLinkProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLinkProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLinkProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPixelStorei(GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPixelStorei);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPixelStorei(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPolygonOffset(GLfloat factor, GLfloat units) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPolygonOffset);

    // copy argument factor
    GLMessage_DataType *arg_factor = glmsg.add_args();
    arg_factor->set_isarray(false);
    arg_factor->set_type(GLMessage::DataType::FLOAT);
    arg_factor->add_floatvalue(factor);

    // copy argument units
    GLMessage_DataType *arg_units = glmsg.add_args();
    arg_units->set_isarray(false);
    arg_units->set_type(GLMessage::DataType::FLOAT);
    arg_units->add_floatvalue(units);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPolygonOffset(factor, units);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid* pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadPixels);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT);
    arg_pixels->add_intvalue((int)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadPixels(x, y, width, height, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReleaseShaderCompiler(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReleaseShaderCompiler);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReleaseShaderCompiler();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorage);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorage(target, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleCoverage(GLclampf value, GLboolean invert) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleCoverage);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::FLOAT);
    arg_value->add_floatvalue(value);

    // copy argument invert
    GLMessage_DataType *arg_invert = glmsg.add_args();
    arg_invert->set_isarray(false);
    arg_invert->set_type(GLMessage::DataType::BOOL);
    arg_invert->add_boolvalue(invert);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleCoverage(value, invert);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScissor(GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScissor);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScissor(x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShaderBinary(GLsizei n, const GLuint* shaders, GLenum binaryformat, const GLvoid* binary, GLsizei length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShaderBinary);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT);
    arg_shaders->add_intvalue((int)shaders);

    // copy argument binaryformat
    GLMessage_DataType *arg_binaryformat = glmsg.add_args();
    arg_binaryformat->set_isarray(false);
    arg_binaryformat->set_type(GLMessage::DataType::ENUM);
    arg_binaryformat->add_intvalue((int)binaryformat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT);
    arg_binary->add_intvalue((int)binary);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShaderBinary(n, shaders, binaryformat, binary, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) shaders,
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShaderSource(GLuint shader, GLsizei count, const GLchar** string, const GLint* length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShaderSource);

    // copy argument shader
    GLMessage_DataType *arg_shader = glmsg.add_args();
    arg_shader->set_isarray(false);
    arg_shader->set_type(GLMessage::DataType::INT);
    arg_shader->add_intvalue(shader);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument string
    GLMessage_DataType *arg_string = glmsg.add_args();
    arg_string->set_isarray(false);
    arg_string->set_type(GLMessage::DataType::INT);
    arg_string->add_intvalue((int)string);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShaderSource(shader, count, string, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) string,
        (void *) length,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilFunc(GLenum func, GLint ref, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilFunc(func, ref, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilFuncSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilFuncSeparate(face, func, ref, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilMask(GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilMask);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilMask(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilMaskSeparate(GLenum face, GLuint mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilMaskSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilMaskSeparate(face, mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilOp(GLenum fail, GLenum zfail, GLenum zpass) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilOp);

    // copy argument fail
    GLMessage_DataType *arg_fail = glmsg.add_args();
    arg_fail->set_isarray(false);
    arg_fail->set_type(GLMessage::DataType::ENUM);
    arg_fail->add_intvalue((int)fail);

    // copy argument zfail
    GLMessage_DataType *arg_zfail = glmsg.add_args();
    arg_zfail->set_isarray(false);
    arg_zfail->set_type(GLMessage::DataType::ENUM);
    arg_zfail->add_intvalue((int)zfail);

    // copy argument zpass
    GLMessage_DataType *arg_zpass = glmsg.add_args();
    arg_zpass->set_isarray(false);
    arg_zpass->set_type(GLMessage::DataType::ENUM);
    arg_zpass->add_intvalue((int)zpass);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilOp(fail, zfail, zpass);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStencilOpSeparate(GLenum face, GLenum fail, GLenum zfail, GLenum zpass) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStencilOpSeparate);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument fail
    GLMessage_DataType *arg_fail = glmsg.add_args();
    arg_fail->set_isarray(false);
    arg_fail->set_type(GLMessage::DataType::ENUM);
    arg_fail->add_intvalue((int)fail);

    // copy argument zfail
    GLMessage_DataType *arg_zfail = glmsg.add_args();
    arg_zfail->set_isarray(false);
    arg_zfail->set_type(GLMessage::DataType::ENUM);
    arg_zfail->add_intvalue((int)zfail);

    // copy argument zpass
    GLMessage_DataType *arg_zpass = glmsg.add_args();
    arg_zpass->set_isarray(false);
    arg_zpass->set_type(GLMessage::DataType::ENUM);
    arg_zpass->add_intvalue((int)zpass);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStencilOpSeparate(face, fail, zfail, zpass);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid* pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::INT);
    arg_internalformat->add_intvalue(internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT);
    arg_pixels->add_intvalue((int)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterf(GLenum target, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterf);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterf(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterfv(GLenum target, GLenum pname, const GLfloat* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameteri(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameteri);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameteri(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameteriv(GLenum target, GLenum pname, const GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameteriv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameteriv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexSubImage2D);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT);
    arg_pixels->add_intvalue((int)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1f(GLint location, GLfloat x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1f(location, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1fv(GLint location, GLsizei count, const GLfloat* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1fv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1i(GLint location, GLint x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1i(location, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform1iv(GLint location, GLsizei count, const GLint* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform1iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform1iv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2f(GLint location, GLfloat x, GLfloat y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2f(location, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2fv(GLint location, GLsizei count, const GLfloat* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2fv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2i(GLint location, GLint x, GLint y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2i(location, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform2iv(GLint location, GLsizei count, const GLint* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform2iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform2iv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3f(GLint location, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3f(location, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3fv(GLint location, GLsizei count, const GLfloat* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3fv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3i(GLint location, GLint x, GLint y, GLint z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3i(location, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform3iv(GLint location, GLsizei count, const GLint* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform3iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform3iv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4f(GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4f);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::FLOAT);
    arg_w->add_floatvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4f(location, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4fv(GLint location, GLsizei count, const GLfloat* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4fv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4i(GLint location, GLint x, GLint y, GLint z, GLint w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4i);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::INT);
    arg_w->add_intvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4i(location, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniform4iv(GLint location, GLsizei count, const GLint* v) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniform4iv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument v
    GLMessage_DataType *arg_v = glmsg.add_args();
    arg_v->set_isarray(false);
    arg_v->set_type(GLMessage::DataType::INT);
    arg_v->add_intvalue((int)v);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniform4iv(location, count, v);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) v,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix2fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix2fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix3fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix3fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUniformMatrix4fv);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUniformMatrix4fv(location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUseProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUseProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUseProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glValidateProgram(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glValidateProgram);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glValidateProgram(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib1f(GLuint indx, GLfloat x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib1f);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib1f(indx, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib1fv(GLuint indx, const GLfloat* values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib1fv);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT);
    arg_values->add_intvalue((int)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib1fv(indx, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib2f(GLuint indx, GLfloat x, GLfloat y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib2f);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib2f(indx, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib2fv(GLuint indx, const GLfloat* values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib2fv);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT);
    arg_values->add_intvalue((int)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib2fv(indx, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib3f(GLuint indx, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib3f);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib3f(indx, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib3fv(GLuint indx, const GLfloat* values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib3fv);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT);
    arg_values->add_intvalue((int)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib3fv(indx, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib4f(GLuint indx, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib4f);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::FLOAT);
    arg_w->add_floatvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib4f(indx, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttrib4fv(GLuint indx, const GLfloat* values) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttrib4fv);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument values
    GLMessage_DataType *arg_values = glmsg.add_args();
    arg_values->set_isarray(false);
    arg_values->set_type(GLMessage::DataType::INT);
    arg_values->add_intvalue((int)values);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttrib4fv(indx, values);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) values,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexAttribPointer(GLuint indx, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* ptr) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexAttribPointer);

    // copy argument indx
    GLMessage_DataType *arg_indx = glmsg.add_args();
    arg_indx->set_isarray(false);
    arg_indx->set_type(GLMessage::DataType::INT);
    arg_indx->add_intvalue(indx);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument normalized
    GLMessage_DataType *arg_normalized = glmsg.add_args();
    arg_normalized->set_isarray(false);
    arg_normalized->set_type(GLMessage::DataType::BOOL);
    arg_normalized->add_boolvalue(normalized);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument ptr
    GLMessage_DataType *arg_ptr = glmsg.add_args();
    arg_ptr->set_isarray(false);
    arg_ptr->set_type(GLMessage::DataType::INT);
    arg_ptr->add_intvalue((int)ptr);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexAttribPointer(indx, size, type, normalized, stride, ptr);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ptr,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glViewport(GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glViewport);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glViewport(x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL2Ext APIs

void GLTrace_glEGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEGLImageTargetTexture2DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument image
    GLMessage_DataType *arg_image = glmsg.add_args();
    arg_image->set_isarray(false);
    arg_image->set_type(GLMessage::DataType::INT);
    arg_image->add_intvalue((int)image);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEGLImageTargetTexture2DOES(target, image);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) image,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEGLImageTargetRenderbufferStorageOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument image
    GLMessage_DataType *arg_image = glmsg.add_args();
    arg_image->set_isarray(false);
    arg_image->set_type(GLMessage::DataType::INT);
    arg_image->add_intvalue((int)image);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEGLImageTargetRenderbufferStorageOES(target, image);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) image,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramBinaryOES(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramBinaryOES);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::INT);
    arg_binaryFormat->add_intvalue((int)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT);
    arg_binary->add_intvalue((int)binary);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramBinaryOES(program, bufSize, length, binaryFormat, binary);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) binaryFormat,
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramBinaryOES(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLint length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramBinaryOES);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument binaryFormat
    GLMessage_DataType *arg_binaryFormat = glmsg.add_args();
    arg_binaryFormat->set_isarray(false);
    arg_binaryFormat->set_type(GLMessage::DataType::ENUM);
    arg_binaryFormat->add_intvalue((int)binaryFormat);

    // copy argument binary
    GLMessage_DataType *arg_binary = glmsg.add_args();
    arg_binary->set_isarray(false);
    arg_binary->set_type(GLMessage::DataType::INT);
    arg_binary->add_intvalue((int)binary);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramBinaryOES(program, binaryFormat, binary, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) binary,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void* GLTrace_glMapBufferOES(GLenum target, GLenum access) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMapBufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument access
    GLMessage_DataType *arg_access = glmsg.add_args();
    arg_access->set_isarray(false);
    arg_access->set_type(GLMessage::DataType::ENUM);
    arg_access->add_intvalue((int)access);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    void* retValue = glContext->hooks->gl.glMapBufferOES(target, access);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
        (void *) retValue,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glUnmapBufferOES(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUnmapBufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glUnmapBufferOES(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetBufferPointervOES(GLenum target, GLenum pname, GLvoid** params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetBufferPointervOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetBufferPointervOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT);
    arg_pixels->add_intvalue((int)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument pixels
    GLMessage_DataType *arg_pixels = glmsg.add_args();
    arg_pixels->set_isarray(false);
    arg_pixels->set_type(GLMessage::DataType::INT);
    arg_pixels->add_intvalue((int)pixels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pixels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCopyTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCopyTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexImage3DOES(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument border
    GLMessage_DataType *arg_border = glmsg.add_args();
    arg_border->set_isarray(false);
    arg_border->set_type(GLMessage::DataType::INT);
    arg_border->add_intvalue(border);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCompressedTexSubImage3DOES(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCompressedTexSubImage3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument imageSize
    GLMessage_DataType *arg_imageSize = glmsg.add_args();
    arg_imageSize->set_isarray(false);
    arg_imageSize->set_type(GLMessage::DataType::INT);
    arg_imageSize->add_intvalue(imageSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture3DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture3DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBindVertexArrayOES(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindVertexArrayOES);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindVertexArrayOES(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteVertexArraysOES(GLsizei n, const GLuint *arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteVertexArraysOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT);
    arg_arrays->add_intvalue((int)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteVertexArraysOES(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenVertexArraysOES(GLsizei n, GLuint *arrays) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenVertexArraysOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument arrays
    GLMessage_DataType *arg_arrays = glmsg.add_args();
    arg_arrays->set_isarray(false);
    arg_arrays->set_type(GLMessage::DataType::INT);
    arg_arrays->add_intvalue((int)arrays);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenVertexArraysOES(n, arrays);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) arrays,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsVertexArrayOES(GLuint array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsVertexArrayOES);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::INT);
    arg_array->add_intvalue(array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsVertexArrayOES(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetPerfMonitorGroupsAMD(GLint *numGroups, GLsizei groupsSize, GLuint *groups) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorGroupsAMD);

    // copy argument numGroups
    GLMessage_DataType *arg_numGroups = glmsg.add_args();
    arg_numGroups->set_isarray(false);
    arg_numGroups->set_type(GLMessage::DataType::INT);
    arg_numGroups->add_intvalue((int)numGroups);

    // copy argument groupsSize
    GLMessage_DataType *arg_groupsSize = glmsg.add_args();
    arg_groupsSize->set_isarray(false);
    arg_groupsSize->set_type(GLMessage::DataType::INT);
    arg_groupsSize->add_intvalue(groupsSize);

    // copy argument groups
    GLMessage_DataType *arg_groups = glmsg.add_args();
    arg_groups->set_isarray(false);
    arg_groups->set_type(GLMessage::DataType::INT);
    arg_groups->add_intvalue((int)groups);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) numGroups,
        (void *) groups,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCountersAMD(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCountersAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument numCounters
    GLMessage_DataType *arg_numCounters = glmsg.add_args();
    arg_numCounters->set_isarray(false);
    arg_numCounters->set_type(GLMessage::DataType::INT);
    arg_numCounters->add_intvalue((int)numCounters);

    // copy argument maxActiveCounters
    GLMessage_DataType *arg_maxActiveCounters = glmsg.add_args();
    arg_maxActiveCounters->set_isarray(false);
    arg_maxActiveCounters->set_type(GLMessage::DataType::INT);
    arg_maxActiveCounters->add_intvalue((int)maxActiveCounters);

    // copy argument counterSize
    GLMessage_DataType *arg_counterSize = glmsg.add_args();
    arg_counterSize->set_isarray(false);
    arg_counterSize->set_type(GLMessage::DataType::INT);
    arg_counterSize->add_intvalue(counterSize);

    // copy argument counters
    GLMessage_DataType *arg_counters = glmsg.add_args();
    arg_counters->set_isarray(false);
    arg_counters->set_type(GLMessage::DataType::INT);
    arg_counters->add_intvalue((int)counters);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) numCounters,
        (void *) maxActiveCounters,
        (void *) counters,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorGroupStringAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument groupString
    GLMessage_DataType *arg_groupString = glmsg.add_args();
    arg_groupString->set_isarray(false);
    arg_groupString->set_type(GLMessage::DataType::INT);
    arg_groupString->add_intvalue((int)groupString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) groupString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterStringAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument counter
    GLMessage_DataType *arg_counter = glmsg.add_args();
    arg_counter->set_isarray(false);
    arg_counter->set_type(GLMessage::DataType::INT);
    arg_counter->add_intvalue(counter);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument counterString
    GLMessage_DataType *arg_counterString = glmsg.add_args();
    arg_counterString->set_isarray(false);
    arg_counterString->set_type(GLMessage::DataType::INT);
    arg_counterString->add_intvalue((int)counterString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) counterString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, GLvoid *data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterInfoAMD);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument counter
    GLMessage_DataType *arg_counter = glmsg.add_args();
    arg_counter->set_isarray(false);
    arg_counter->set_type(GLMessage::DataType::INT);
    arg_counter->add_intvalue(counter);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterInfoAMD(group, counter, pname, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenPerfMonitorsAMD(GLsizei n, GLuint *monitors) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenPerfMonitorsAMD);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument monitors
    GLMessage_DataType *arg_monitors = glmsg.add_args();
    arg_monitors->set_isarray(false);
    arg_monitors->set_type(GLMessage::DataType::INT);
    arg_monitors->add_intvalue((int)monitors);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenPerfMonitorsAMD(n, monitors);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) monitors,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeletePerfMonitorsAMD(GLsizei n, GLuint *monitors) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeletePerfMonitorsAMD);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument monitors
    GLMessage_DataType *arg_monitors = glmsg.add_args();
    arg_monitors->set_isarray(false);
    arg_monitors->set_type(GLMessage::DataType::INT);
    arg_monitors->add_intvalue((int)monitors);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeletePerfMonitorsAMD(n, monitors);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) monitors,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *countersList) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSelectPerfMonitorCountersAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // copy argument enable
    GLMessage_DataType *arg_enable = glmsg.add_args();
    arg_enable->set_isarray(false);
    arg_enable->set_type(GLMessage::DataType::BOOL);
    arg_enable->add_boolvalue(enable);

    // copy argument group
    GLMessage_DataType *arg_group = glmsg.add_args();
    arg_group->set_isarray(false);
    arg_group->set_type(GLMessage::DataType::INT);
    arg_group->add_intvalue(group);

    // copy argument numCounters
    GLMessage_DataType *arg_numCounters = glmsg.add_args();
    arg_numCounters->set_isarray(false);
    arg_numCounters->set_type(GLMessage::DataType::INT);
    arg_numCounters->add_intvalue(numCounters);

    // copy argument countersList
    GLMessage_DataType *arg_countersList = glmsg.add_args();
    arg_countersList->set_isarray(false);
    arg_countersList->set_type(GLMessage::DataType::INT);
    arg_countersList->add_intvalue((int)countersList);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, countersList);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) countersList,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBeginPerfMonitorAMD(GLuint monitor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginPerfMonitorAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginPerfMonitorAMD(monitor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndPerfMonitorAMD(GLuint monitor) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndPerfMonitorAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndPerfMonitorAMD(monitor);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPerfMonitorCounterDataAMD);

    // copy argument monitor
    GLMessage_DataType *arg_monitor = glmsg.add_args();
    arg_monitor->set_isarray(false);
    arg_monitor->set_type(GLMessage::DataType::INT);
    arg_monitor->add_intvalue(monitor);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument dataSize
    GLMessage_DataType *arg_dataSize = glmsg.add_args();
    arg_dataSize->set_isarray(false);
    arg_dataSize->set_type(GLMessage::DataType::INT);
    arg_dataSize->add_intvalue(dataSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // copy argument bytesWritten
    GLMessage_DataType *arg_bytesWritten = glmsg.add_args();
    arg_bytesWritten->set_isarray(false);
    arg_bytesWritten->set_type(GLMessage::DataType::INT);
    arg_bytesWritten->add_intvalue((int)bytesWritten);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
        (void *) bytesWritten,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlitFramebufferANGLE(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlitFramebufferANGLE);

    // copy argument srcX0
    GLMessage_DataType *arg_srcX0 = glmsg.add_args();
    arg_srcX0->set_isarray(false);
    arg_srcX0->set_type(GLMessage::DataType::INT);
    arg_srcX0->add_intvalue(srcX0);

    // copy argument srcY0
    GLMessage_DataType *arg_srcY0 = glmsg.add_args();
    arg_srcY0->set_isarray(false);
    arg_srcY0->set_type(GLMessage::DataType::INT);
    arg_srcY0->add_intvalue(srcY0);

    // copy argument srcX1
    GLMessage_DataType *arg_srcX1 = glmsg.add_args();
    arg_srcX1->set_isarray(false);
    arg_srcX1->set_type(GLMessage::DataType::INT);
    arg_srcX1->add_intvalue(srcX1);

    // copy argument srcY1
    GLMessage_DataType *arg_srcY1 = glmsg.add_args();
    arg_srcY1->set_isarray(false);
    arg_srcY1->set_type(GLMessage::DataType::INT);
    arg_srcY1->add_intvalue(srcY1);

    // copy argument dstX0
    GLMessage_DataType *arg_dstX0 = glmsg.add_args();
    arg_dstX0->set_isarray(false);
    arg_dstX0->set_type(GLMessage::DataType::INT);
    arg_dstX0->add_intvalue(dstX0);

    // copy argument dstY0
    GLMessage_DataType *arg_dstY0 = glmsg.add_args();
    arg_dstY0->set_isarray(false);
    arg_dstY0->set_type(GLMessage::DataType::INT);
    arg_dstY0->add_intvalue(dstY0);

    // copy argument dstX1
    GLMessage_DataType *arg_dstX1 = glmsg.add_args();
    arg_dstX1->set_isarray(false);
    arg_dstX1->set_type(GLMessage::DataType::INT);
    arg_dstX1->add_intvalue(dstX1);

    // copy argument dstY1
    GLMessage_DataType *arg_dstY1 = glmsg.add_args();
    arg_dstY1->set_isarray(false);
    arg_dstY1->set_type(GLMessage::DataType::INT);
    arg_dstY1->add_intvalue(dstY1);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::INT);
    arg_mask->add_intvalue(mask);

    // copy argument filter
    GLMessage_DataType *arg_filter = glmsg.add_args();
    arg_filter->set_isarray(false);
    arg_filter->set_type(GLMessage::DataType::ENUM);
    arg_filter->add_intvalue((int)filter);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleANGLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleANGLE);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleAPPLE(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleAPPLE);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glResolveMultisampleFramebufferAPPLE(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glResolveMultisampleFramebufferAPPLE);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glResolveMultisampleFramebufferAPPLE();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLabelObjectEXT(GLenum type, GLuint object, GLsizei length, const GLchar *label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLabelObjectEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument object
    GLMessage_DataType *arg_object = glmsg.add_args();
    arg_object->set_isarray(false);
    arg_object->set_type(GLMessage::DataType::INT);
    arg_object->add_intvalue(object);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT);
    arg_label->add_intvalue((int)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLabelObjectEXT(type, object, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetObjectLabelEXT(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetObjectLabelEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument object
    GLMessage_DataType *arg_object = glmsg.add_args();
    arg_object->set_isarray(false);
    arg_object->set_type(GLMessage::DataType::INT);
    arg_object->add_intvalue(object);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument label
    GLMessage_DataType *arg_label = glmsg.add_args();
    arg_label->set_isarray(false);
    arg_label->set_type(GLMessage::DataType::INT);
    arg_label->add_intvalue((int)label);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetObjectLabelEXT(type, object, bufSize, length, label);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) label,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glInsertEventMarkerEXT(GLsizei length, const GLchar *marker) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glInsertEventMarkerEXT);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument marker
    GLMessage_DataType *arg_marker = glmsg.add_args();
    arg_marker->set_isarray(false);
    arg_marker->set_type(GLMessage::DataType::INT);
    arg_marker->add_intvalue((int)marker);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glInsertEventMarkerEXT(length, marker);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) marker,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPushGroupMarkerEXT(GLsizei length, const GLchar *marker) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPushGroupMarkerEXT);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue(length);

    // copy argument marker
    GLMessage_DataType *arg_marker = glmsg.add_args();
    arg_marker->set_isarray(false);
    arg_marker->set_type(GLMessage::DataType::INT);
    arg_marker->add_intvalue((int)marker);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPushGroupMarkerEXT(length, marker);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) marker,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPopGroupMarkerEXT(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPopGroupMarkerEXT);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPopGroupMarkerEXT();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDiscardFramebufferEXT(GLenum target, GLsizei numAttachments, const GLenum *attachments) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDiscardFramebufferEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument numAttachments
    GLMessage_DataType *arg_numAttachments = glmsg.add_args();
    arg_numAttachments->set_isarray(false);
    arg_numAttachments->set_type(GLMessage::DataType::INT);
    arg_numAttachments->add_intvalue(numAttachments);

    // copy argument attachments
    GLMessage_DataType *arg_attachments = glmsg.add_args();
    arg_attachments->set_isarray(false);
    arg_attachments->set_type(GLMessage::DataType::INT);
    arg_attachments->add_intvalue((int)attachments);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDiscardFramebufferEXT(target, numAttachments, attachments);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) attachments,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleEXT(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2DMultisampleEXT(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2DMultisampleEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiDrawArraysEXT(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiDrawArraysEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument first
    GLMessage_DataType *arg_first = glmsg.add_args();
    arg_first->set_isarray(false);
    arg_first->set_type(GLMessage::DataType::INT);
    arg_first->add_intvalue((int)first);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue((int)count);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiDrawArraysEXT(mode, first, count, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) first,
        (void *) count,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiDrawElementsEXT(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiDrawElementsEXT);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue((int)count);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument indices
    GLMessage_DataType *arg_indices = glmsg.add_args();
    arg_indices->set_isarray(false);
    arg_indices->set_type(GLMessage::DataType::INT);
    arg_indices->add_intvalue((int)indices);

    // copy argument primcount
    GLMessage_DataType *arg_primcount = glmsg.add_args();
    arg_primcount->set_isarray(false);
    arg_primcount->set_type(GLMessage::DataType::INT);
    arg_primcount->add_intvalue(primcount);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiDrawElementsEXT(mode, count, type, indices, primcount);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) count,
        (void *) indices,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenQueriesEXT(GLsizei n, GLuint *ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenQueriesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT);
    arg_ids->add_intvalue((int)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenQueriesEXT(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteQueriesEXT(GLsizei n, const GLuint *ids) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteQueriesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument ids
    GLMessage_DataType *arg_ids = glmsg.add_args();
    arg_ids->set_isarray(false);
    arg_ids->set_type(GLMessage::DataType::INT);
    arg_ids->add_intvalue((int)ids);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteQueriesEXT(n, ids);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) ids,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsQueryEXT(GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsQueryEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsQueryEXT(id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBeginQueryEXT(GLenum target, GLuint id) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBeginQueryEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBeginQueryEXT(target, id);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndQueryEXT(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndQueryEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndQueryEXT(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryivEXT(GLenum target, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryivEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryivEXT(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetQueryObjectuivEXT);

    // copy argument id
    GLMessage_DataType *arg_id = glmsg.add_args();
    arg_id->set_isarray(false);
    arg_id->set_type(GLMessage::DataType::INT);
    arg_id->add_intvalue(id);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetQueryObjectuivEXT(id, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glGetGraphicsResetStatusEXT(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetGraphicsResetStatusEXT);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glGetGraphicsResetStatusEXT();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glReadnPixelsEXT(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadnPixelsEXT);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument data
    GLMessage_DataType *arg_data = glmsg.add_args();
    arg_data->set_isarray(false);
    arg_data->set_type(GLMessage::DataType::INT);
    arg_data->add_intvalue((int)data);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadnPixelsEXT(x, y, width, height, format, type, bufSize, data);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) data,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, float *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetnUniformfvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetnUniformfvEXT(program, location, bufSize, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetnUniformivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetnUniformivEXT(program, location, bufSize, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glUseProgramStagesEXT(GLuint pipeline, GLbitfield stages, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glUseProgramStagesEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument stages
    GLMessage_DataType *arg_stages = glmsg.add_args();
    arg_stages->set_isarray(false);
    arg_stages->set_type(GLMessage::DataType::INT);
    arg_stages->add_intvalue(stages);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glUseProgramStagesEXT(pipeline, stages, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glActiveShaderProgramEXT(GLuint pipeline, GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glActiveShaderProgramEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glActiveShaderProgramEXT(pipeline, program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLuint GLTrace_glCreateShaderProgramvEXT(GLenum type, GLsizei count, const GLchar **strings) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCreateShaderProgramvEXT);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument strings
    GLMessage_DataType *arg_strings = glmsg.add_args();
    arg_strings->set_isarray(false);
    arg_strings->set_type(GLMessage::DataType::INT);
    arg_strings->add_intvalue((int)strings);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLuint retValue = glContext->hooks->gl.glCreateShaderProgramvEXT(type, count, strings);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) strings,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBindProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteProgramPipelinesEXT(GLsizei n, const GLuint *pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteProgramPipelinesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT);
    arg_pipelines->add_intvalue((int)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteProgramPipelinesEXT(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenProgramPipelinesEXT(GLsizei n, GLuint *pipelines) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenProgramPipelinesEXT);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument pipelines
    GLMessage_DataType *arg_pipelines = glmsg.add_args();
    arg_pipelines->set_isarray(false);
    arg_pipelines->set_type(GLMessage::DataType::INT);
    arg_pipelines->add_intvalue((int)pipelines);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenProgramPipelinesEXT(n, pipelines);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pipelines,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glProgramParameteriEXT(GLuint program, GLenum pname, GLint value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramParameteriEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramParameteriEXT(program, pname, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramPipelineivEXT(GLuint pipeline, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineivEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineivEXT(pipeline, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1iEXT(GLuint program, GLint location, GLint x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1iEXT(program, location, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2iEXT(GLuint program, GLint location, GLint x, GLint y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2iEXT(program, location, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3iEXT(program, location, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4iEXT(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4iEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::INT);
    arg_w->add_intvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4iEXT(program, location, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1fEXT(GLuint program, GLint location, GLfloat x) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1fEXT(program, location, x);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2fEXT(GLuint program, GLint location, GLfloat x, GLfloat y) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2fEXT(program, location, x, y);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3fEXT(program, location, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4fEXT(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4fEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // copy argument w
    GLMessage_DataType *arg_w = glmsg.add_args();
    arg_w->set_isarray(false);
    arg_w->set_type(GLMessage::DataType::FLOAT);
    arg_w->add_floatvalue(w);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4fEXT(program, location, x, y, z, w);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4ivEXT(GLuint program, GLint location, GLsizei count, const GLint *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4ivEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4ivEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform1fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform1fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform1fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform2fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform2fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform3fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform3fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniform4fvEXT(GLuint program, GLint location, GLsizei count, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniform4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniform4fvEXT(program, location, count, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix2fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix2fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix3fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix3fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glProgramUniformMatrix4fvEXT(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glProgramUniformMatrix4fvEXT);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument location
    GLMessage_DataType *arg_location = glmsg.add_args();
    arg_location->set_isarray(false);
    arg_location->set_type(GLMessage::DataType::INT);
    arg_location->add_intvalue(location);

    // copy argument count
    GLMessage_DataType *arg_count = glmsg.add_args();
    arg_count->set_isarray(false);
    arg_count->set_type(GLMessage::DataType::INT);
    arg_count->add_intvalue(count);

    // copy argument transpose
    GLMessage_DataType *arg_transpose = glmsg.add_args();
    arg_transpose->set_isarray(false);
    arg_transpose->set_type(GLMessage::DataType::BOOL);
    arg_transpose->add_boolvalue(transpose);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue((int)value);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) value,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glValidateProgramPipelineEXT(GLuint pipeline) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glValidateProgramPipelineEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glValidateProgramPipelineEXT(pipeline);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetProgramPipelineInfoLogEXT(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetProgramPipelineInfoLogEXT);

    // copy argument pipeline
    GLMessage_DataType *arg_pipeline = glmsg.add_args();
    arg_pipeline->set_isarray(false);
    arg_pipeline->set_type(GLMessage::DataType::INT);
    arg_pipeline->add_intvalue(pipeline);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument infoLog
    GLMessage_DataType *arg_infoLog = glmsg.add_args();
    arg_infoLog->set_isarray(false);
    arg_infoLog->set_type(GLMessage::DataType::INT);
    arg_infoLog->add_intvalue((int)infoLog);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) infoLog,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage1DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage1DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage1DEXT(target, levels, internalformat, width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage2DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage2DEXT(target, levels, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexStorage3DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexStorage3DEXT);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexStorage3DEXT(target, levels, internalformat, width, height, depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage1DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage1DEXT(texture, target, levels, internalformat, width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage2DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage2DEXT(texture, target, levels, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTextureStorage3DEXT);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument levels
    GLMessage_DataType *arg_levels = glmsg.add_args();
    arg_levels->set_isarray(false);
    arg_levels->set_type(GLMessage::DataType::INT);
    arg_levels->add_intvalue(levels);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageMultisampleIMG(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageMultisampleIMG);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2DMultisampleIMG(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2DMultisampleIMG);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument samples
    GLMessage_DataType *arg_samples = glmsg.add_args();
    arg_samples->set_isarray(false);
    arg_samples->set_type(GLMessage::DataType::INT);
    arg_samples->add_intvalue(samples);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCoverageMaskNV(GLboolean mask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCoverageMaskNV);

    // copy argument mask
    GLMessage_DataType *arg_mask = glmsg.add_args();
    arg_mask->set_isarray(false);
    arg_mask->set_type(GLMessage::DataType::BOOL);
    arg_mask->add_boolvalue(mask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCoverageMaskNV(mask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCoverageOperationNV(GLenum operation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCoverageOperationNV);

    // copy argument operation
    GLMessage_DataType *arg_operation = glmsg.add_args();
    arg_operation->set_isarray(false);
    arg_operation->set_type(GLMessage::DataType::ENUM);
    arg_operation->add_intvalue((int)operation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCoverageOperationNV(operation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawBuffersNV(GLsizei n, const GLenum *bufs) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawBuffersNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument bufs
    GLMessage_DataType *arg_bufs = glmsg.add_args();
    arg_bufs->set_isarray(false);
    arg_bufs->set_type(GLMessage::DataType::INT);
    arg_bufs->add_intvalue((int)bufs);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawBuffersNV(n, bufs);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) bufs,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteFencesNV(GLsizei n, const GLuint *fences) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteFencesNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument fences
    GLMessage_DataType *arg_fences = glmsg.add_args();
    arg_fences->set_isarray(false);
    arg_fences->set_type(GLMessage::DataType::INT);
    arg_fences->add_intvalue((int)fences);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteFencesNV(n, fences);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) fences,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenFencesNV(GLsizei n, GLuint *fences) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenFencesNV);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument fences
    GLMessage_DataType *arg_fences = glmsg.add_args();
    arg_fences->set_isarray(false);
    arg_fences->set_type(GLMessage::DataType::INT);
    arg_fences->add_intvalue((int)fences);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenFencesNV(n, fences);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) fences,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

GLboolean GLTrace_glTestFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTestFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glTestFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glGetFenceivNV(GLuint fence, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFenceivNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFenceivNV(fence, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFinishFenceNV(GLuint fence) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFinishFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFinishFenceNV(fence);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSetFenceNV(GLuint fence, GLenum condition) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSetFenceNV);

    // copy argument fence
    GLMessage_DataType *arg_fence = glmsg.add_args();
    arg_fence->set_isarray(false);
    arg_fence->set_type(GLMessage::DataType::INT);
    arg_fence->add_intvalue(fence);

    // copy argument condition
    GLMessage_DataType *arg_condition = glmsg.add_args();
    arg_condition->set_isarray(false);
    arg_condition->set_type(GLMessage::DataType::ENUM);
    arg_condition->add_intvalue((int)condition);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSetFenceNV(fence, condition);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glReadBufferNV(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glReadBufferNV);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glReadBufferNV(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAlphaFuncQCOM(GLenum func, GLclampf ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFuncQCOM);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::FLOAT);
    arg_ref->add_floatvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFuncQCOM(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetDriverControlsQCOM(GLint *num, GLsizei size, GLuint *driverControls) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetDriverControlsQCOM);

    // copy argument num
    GLMessage_DataType *arg_num = glmsg.add_args();
    arg_num->set_isarray(false);
    arg_num->set_type(GLMessage::DataType::INT);
    arg_num->add_intvalue((int)num);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument driverControls
    GLMessage_DataType *arg_driverControls = glmsg.add_args();
    arg_driverControls->set_isarray(false);
    arg_driverControls->set_type(GLMessage::DataType::INT);
    arg_driverControls->add_intvalue((int)driverControls);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetDriverControlsQCOM(num, size, driverControls);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) num,
        (void *) driverControls,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetDriverControlStringQCOM(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetDriverControlStringQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // copy argument bufSize
    GLMessage_DataType *arg_bufSize = glmsg.add_args();
    arg_bufSize->set_isarray(false);
    arg_bufSize->set_type(GLMessage::DataType::INT);
    arg_bufSize->add_intvalue(bufSize);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // copy argument driverControlString
    GLMessage_DataType *arg_driverControlString = glmsg.add_args();
    arg_driverControlString->set_isarray(false);
    arg_driverControlString->set_type(GLMessage::DataType::INT);
    arg_driverControlString->add_intvalue((int)driverControlString);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) length,
        (void *) driverControlString,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableDriverControlQCOM(GLuint driverControl) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableDriverControlQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableDriverControlQCOM(driverControl);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableDriverControlQCOM(GLuint driverControl) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableDriverControlQCOM);

    // copy argument driverControl
    GLMessage_DataType *arg_driverControl = glmsg.add_args();
    arg_driverControl->set_isarray(false);
    arg_driverControl->set_type(GLMessage::DataType::INT);
    arg_driverControl->add_intvalue(driverControl);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableDriverControlQCOM(driverControl);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexturesQCOM(GLuint *textures, GLint maxTextures, GLint *numTextures) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexturesQCOM);

    // copy argument textures
    GLMessage_DataType *arg_textures = glmsg.add_args();
    arg_textures->set_isarray(false);
    arg_textures->set_type(GLMessage::DataType::INT);
    arg_textures->add_intvalue((int)textures);

    // copy argument maxTextures
    GLMessage_DataType *arg_maxTextures = glmsg.add_args();
    arg_maxTextures->set_isarray(false);
    arg_maxTextures->set_type(GLMessage::DataType::INT);
    arg_maxTextures->add_intvalue(maxTextures);

    // copy argument numTextures
    GLMessage_DataType *arg_numTextures = glmsg.add_args();
    arg_numTextures->set_isarray(false);
    arg_numTextures->set_type(GLMessage::DataType::INT);
    arg_numTextures->add_intvalue((int)numTextures);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexturesQCOM(textures, maxTextures, numTextures);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) textures,
        (void *) numTextures,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetBuffersQCOM(GLuint *buffers, GLint maxBuffers, GLint *numBuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetBuffersQCOM);

    // copy argument buffers
    GLMessage_DataType *arg_buffers = glmsg.add_args();
    arg_buffers->set_isarray(false);
    arg_buffers->set_type(GLMessage::DataType::INT);
    arg_buffers->add_intvalue((int)buffers);

    // copy argument maxBuffers
    GLMessage_DataType *arg_maxBuffers = glmsg.add_args();
    arg_maxBuffers->set_isarray(false);
    arg_maxBuffers->set_type(GLMessage::DataType::INT);
    arg_maxBuffers->add_intvalue(maxBuffers);

    // copy argument numBuffers
    GLMessage_DataType *arg_numBuffers = glmsg.add_args();
    arg_numBuffers->set_isarray(false);
    arg_numBuffers->set_type(GLMessage::DataType::INT);
    arg_numBuffers->add_intvalue((int)numBuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetBuffersQCOM(buffers, maxBuffers, numBuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) buffers,
        (void *) numBuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetRenderbuffersQCOM(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetRenderbuffersQCOM);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT);
    arg_renderbuffers->add_intvalue((int)renderbuffers);

    // copy argument maxRenderbuffers
    GLMessage_DataType *arg_maxRenderbuffers = glmsg.add_args();
    arg_maxRenderbuffers->set_isarray(false);
    arg_maxRenderbuffers->set_type(GLMessage::DataType::INT);
    arg_maxRenderbuffers->add_intvalue(maxRenderbuffers);

    // copy argument numRenderbuffers
    GLMessage_DataType *arg_numRenderbuffers = glmsg.add_args();
    arg_numRenderbuffers->set_isarray(false);
    arg_numRenderbuffers->set_type(GLMessage::DataType::INT);
    arg_numRenderbuffers->add_intvalue((int)numRenderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
        (void *) numRenderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetFramebuffersQCOM(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetFramebuffersQCOM);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT);
    arg_framebuffers->add_intvalue((int)framebuffers);

    // copy argument maxFramebuffers
    GLMessage_DataType *arg_maxFramebuffers = glmsg.add_args();
    arg_maxFramebuffers->set_isarray(false);
    arg_maxFramebuffers->set_type(GLMessage::DataType::INT);
    arg_maxFramebuffers->add_intvalue(maxFramebuffers);

    // copy argument numFramebuffers
    GLMessage_DataType *arg_numFramebuffers = glmsg.add_args();
    arg_numFramebuffers->set_isarray(false);
    arg_numFramebuffers->set_type(GLMessage::DataType::INT);
    arg_numFramebuffers->add_intvalue((int)numFramebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
        (void *) numFramebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexLevelParameterivQCOM(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexLevelParameterivQCOM);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexLevelParameterivQCOM(texture, face, level, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtTexObjectStateOverrideiQCOM(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtTexObjectStateOverrideiQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtTexObjectStateOverrideiQCOM(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetTexSubImageQCOM(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *texels) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetTexSubImageQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // copy argument xoffset
    GLMessage_DataType *arg_xoffset = glmsg.add_args();
    arg_xoffset->set_isarray(false);
    arg_xoffset->set_type(GLMessage::DataType::INT);
    arg_xoffset->add_intvalue(xoffset);

    // copy argument yoffset
    GLMessage_DataType *arg_yoffset = glmsg.add_args();
    arg_yoffset->set_isarray(false);
    arg_yoffset->set_type(GLMessage::DataType::INT);
    arg_yoffset->add_intvalue(yoffset);

    // copy argument zoffset
    GLMessage_DataType *arg_zoffset = glmsg.add_args();
    arg_zoffset->set_isarray(false);
    arg_zoffset->set_type(GLMessage::DataType::INT);
    arg_zoffset->add_intvalue(zoffset);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // copy argument format
    GLMessage_DataType *arg_format = glmsg.add_args();
    arg_format->set_isarray(false);
    arg_format->set_type(GLMessage::DataType::ENUM);
    arg_format->add_intvalue((int)format);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument texels
    GLMessage_DataType *arg_texels = glmsg.add_args();
    arg_texels->set_isarray(false);
    arg_texels->set_type(GLMessage::DataType::INT);
    arg_texels->add_intvalue((int)texels);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) texels,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetBufferPointervQCOM(GLenum target, GLvoid **params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetBufferPointervQCOM);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetBufferPointervQCOM(target, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetShadersQCOM(GLuint *shaders, GLint maxShaders, GLint *numShaders) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetShadersQCOM);

    // copy argument shaders
    GLMessage_DataType *arg_shaders = glmsg.add_args();
    arg_shaders->set_isarray(false);
    arg_shaders->set_type(GLMessage::DataType::INT);
    arg_shaders->add_intvalue((int)shaders);

    // copy argument maxShaders
    GLMessage_DataType *arg_maxShaders = glmsg.add_args();
    arg_maxShaders->set_isarray(false);
    arg_maxShaders->set_type(GLMessage::DataType::INT);
    arg_maxShaders->add_intvalue(maxShaders);

    // copy argument numShaders
    GLMessage_DataType *arg_numShaders = glmsg.add_args();
    arg_numShaders->set_isarray(false);
    arg_numShaders->set_type(GLMessage::DataType::INT);
    arg_numShaders->add_intvalue((int)numShaders);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetShadersQCOM(shaders, maxShaders, numShaders);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) shaders,
        (void *) numShaders,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glExtGetProgramsQCOM(GLuint *programs, GLint maxPrograms, GLint *numPrograms) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetProgramsQCOM);

    // copy argument programs
    GLMessage_DataType *arg_programs = glmsg.add_args();
    arg_programs->set_isarray(false);
    arg_programs->set_type(GLMessage::DataType::INT);
    arg_programs->add_intvalue((int)programs);

    // copy argument maxPrograms
    GLMessage_DataType *arg_maxPrograms = glmsg.add_args();
    arg_maxPrograms->set_isarray(false);
    arg_maxPrograms->set_type(GLMessage::DataType::INT);
    arg_maxPrograms->add_intvalue(maxPrograms);

    // copy argument numPrograms
    GLMessage_DataType *arg_numPrograms = glmsg.add_args();
    arg_numPrograms->set_isarray(false);
    arg_numPrograms->set_type(GLMessage::DataType::INT);
    arg_numPrograms->add_intvalue((int)numPrograms);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetProgramsQCOM(programs, maxPrograms, numPrograms);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) programs,
        (void *) numPrograms,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glExtIsProgramBinaryQCOM(GLuint program) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtIsProgramBinaryQCOM);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glExtIsProgramBinaryQCOM(program);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glExtGetProgramBinarySourceQCOM(GLuint program, GLenum shadertype, GLchar *source, GLint *length) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glExtGetProgramBinarySourceQCOM);

    // copy argument program
    GLMessage_DataType *arg_program = glmsg.add_args();
    arg_program->set_isarray(false);
    arg_program->set_type(GLMessage::DataType::INT);
    arg_program->add_intvalue(program);

    // copy argument shadertype
    GLMessage_DataType *arg_shadertype = glmsg.add_args();
    arg_shadertype->set_isarray(false);
    arg_shadertype->set_type(GLMessage::DataType::ENUM);
    arg_shadertype->add_intvalue((int)shadertype);

    // copy argument source
    GLMessage_DataType *arg_source = glmsg.add_args();
    arg_source->set_isarray(false);
    arg_source->set_type(GLMessage::DataType::INT);
    arg_source->add_intvalue((int)source);

    // copy argument length
    GLMessage_DataType *arg_length = glmsg.add_args();
    arg_length->set_isarray(false);
    arg_length->set_type(GLMessage::DataType::INT);
    arg_length->add_intvalue((int)length);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glExtGetProgramBinarySourceQCOM(program, shadertype, source, length);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) source,
        (void *) length,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glStartTilingQCOM(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glStartTilingQCOM);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // copy argument preserveMask
    GLMessage_DataType *arg_preserveMask = glmsg.add_args();
    arg_preserveMask->set_isarray(false);
    arg_preserveMask->set_type(GLMessage::DataType::INT);
    arg_preserveMask->add_intvalue(preserveMask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glStartTilingQCOM(x, y, width, height, preserveMask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEndTilingQCOM(GLbitfield preserveMask) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEndTilingQCOM);

    // copy argument preserveMask
    GLMessage_DataType *arg_preserveMask = glmsg.add_args();
    arg_preserveMask->set_isarray(false);
    arg_preserveMask->set_type(GLMessage::DataType::INT);
    arg_preserveMask->add_intvalue(preserveMask);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEndTilingQCOM(preserveMask);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL1 APIs

void GLTrace_glAlphaFunc(GLenum func, GLclampf ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFunc);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::FLOAT);
    arg_ref->add_floatvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFunc(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanef(GLenum plane, const GLfloat *equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanef);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT);
    arg_equation->add_intvalue((int)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanef(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4f);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::FLOAT);
    arg_red->add_floatvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::FLOAT);
    arg_green->add_floatvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::FLOAT);
    arg_blue->add_floatvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::FLOAT);
    arg_alpha->add_floatvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4f(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogfv(GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumf);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::FLOAT);
    arg_left->add_floatvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::FLOAT);
    arg_right->add_floatvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::FLOAT);
    arg_bottom->add_floatvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::FLOAT);
    arg_top->add_floatvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumf(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanef(GLenum pname, GLfloat eqn[4]) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanef);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanef(pname, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetLightfv(GLenum light, GLenum pname, GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetLightfv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetLightfv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMaterialfv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMaterialfv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnvfv(GLenum env, GLenum pname, GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnvfv);

    // copy argument env
    GLMessage_DataType *arg_env = glmsg.add_args();
    arg_env->set_isarray(false);
    arg_env->set_type(GLMessage::DataType::ENUM);
    arg_env->add_intvalue((int)env);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnvfv(env, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelfv(GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightf(GLenum light, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightf);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightf(light, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightfv(GLenum light, GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightfv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightfv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadMatrixf(const GLfloat *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadMatrixf);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadMatrixf(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialf(GLenum face, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialf);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialf(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialfv(GLenum face, GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialfv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialfv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultMatrixf(const GLfloat *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultMatrixf);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultMatrixf(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4f);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::FLOAT);
    arg_s->add_floatvalue(s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::FLOAT);
    arg_t->add_floatvalue(t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::FLOAT);
    arg_r->add_floatvalue(r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::FLOAT);
    arg_q->add_floatvalue(q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4f(target, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormal3f);

    // copy argument nx
    GLMessage_DataType *arg_nx = glmsg.add_args();
    arg_nx->set_isarray(false);
    arg_nx->set_type(GLMessage::DataType::FLOAT);
    arg_nx->add_floatvalue(nx);

    // copy argument ny
    GLMessage_DataType *arg_ny = glmsg.add_args();
    arg_ny->set_isarray(false);
    arg_ny->set_type(GLMessage::DataType::FLOAT);
    arg_ny->add_floatvalue(ny);

    // copy argument nz
    GLMessage_DataType *arg_nz = glmsg.add_args();
    arg_nz->set_isarray(false);
    arg_nz->set_type(GLMessage::DataType::FLOAT);
    arg_nz->add_floatvalue(nz);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormal3f(nx, ny, nz);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthof);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::FLOAT);
    arg_left->add_floatvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::FLOAT);
    arg_right->add_floatvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::FLOAT);
    arg_bottom->add_floatvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::FLOAT);
    arg_top->add_floatvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthof(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterf(GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterf);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterf(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterfv(GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterfv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterfv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSize(GLfloat size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSize);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::FLOAT);
    arg_size->add_floatvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSize(size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRotatef);

    // copy argument angle
    GLMessage_DataType *arg_angle = glmsg.add_args();
    arg_angle->set_isarray(false);
    arg_angle->set_type(GLMessage::DataType::FLOAT);
    arg_angle->add_floatvalue(angle);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRotatef(angle, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScalef(GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScalef);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScalef(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvf(GLenum target, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvf);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvf(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvfv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvfv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTranslatef(GLfloat x, GLfloat y, GLfloat z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTranslatef);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTranslatef(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAlphaFuncx(GLenum func, GLclampx ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFuncx);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFuncx(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearColorx);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearColorx(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthx(GLclampx depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthx);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthx(depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClientActiveTexture(GLenum texture) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClientActiveTexture);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::ENUM);
    arg_texture->add_intvalue((int)texture);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClientActiveTexture(texture);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanex(GLenum plane, const GLfixed *equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanex);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT);
    arg_equation->add_intvalue((int)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanex(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4ub);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::BYTE);
    arg_red->add_intvalue((int)red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::BYTE);
    arg_green->add_intvalue((int)green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::BYTE);
    arg_blue->add_intvalue((int)blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::BYTE);
    arg_alpha->add_intvalue((int)alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4ub(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4x);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4x(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColorPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColorPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthRangex(GLclampx zNear, GLclampx zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangex);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangex(zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDisableClientState(GLenum array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDisableClientState);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::ENUM);
    arg_array->add_intvalue((int)array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDisableClientState(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glEnableClientState(GLenum array) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glEnableClientState);

    // copy argument array
    GLMessage_DataType *arg_array = glmsg.add_args();
    arg_array->set_isarray(false);
    arg_array->set_type(GLMessage::DataType::ENUM);
    arg_array->add_intvalue((int)array);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glEnableClientState(array);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogxv(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogxv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumx);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::INT);
    arg_left->add_intvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::INT);
    arg_right->add_intvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::INT);
    arg_bottom->add_intvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::INT);
    arg_top->add_intvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumx(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanex(GLenum pname, GLfixed eqn[4]) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanex);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanex(pname, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFixedv(GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFixedv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFixedv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetLightxv(GLenum light, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetLightxv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetLightxv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMaterialxv(GLenum face, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMaterialxv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMaterialxv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetPointerv(GLenum pname, GLvoid **params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetPointerv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetPointerv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnviv(GLenum env, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnviv);

    // copy argument env
    GLMessage_DataType *arg_env = glmsg.add_args();
    arg_env->set_isarray(false);
    arg_env->set_type(GLMessage::DataType::ENUM);
    arg_env->add_intvalue((int)env);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnviv(env, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnvxv(GLenum env, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnvxv);

    // copy argument env
    GLMessage_DataType *arg_env = glmsg.add_args();
    arg_env->set_isarray(false);
    arg_env->set_type(GLMessage::DataType::ENUM);
    arg_env->add_intvalue((int)env);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnvxv(env, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameterxv(GLenum target, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelxv(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelxv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightx(GLenum light, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightx);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightx(light, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightxv(GLenum light, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightxv);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightxv(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLineWidthx(GLfixed width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLineWidthx);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLineWidthx(width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadIdentity(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadIdentity);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadIdentity();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadMatrixx(const GLfixed *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadMatrixx);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadMatrixx(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLogicOp(GLenum opcode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLogicOp);

    // copy argument opcode
    GLMessage_DataType *arg_opcode = glmsg.add_args();
    arg_opcode->set_isarray(false);
    arg_opcode->set_type(GLMessage::DataType::ENUM);
    arg_opcode->add_intvalue((int)opcode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLogicOp(opcode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialx(GLenum face, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialx);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialx(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialxv(GLenum face, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialxv);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialxv(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMatrixMode(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMatrixMode);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMatrixMode(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultMatrixx(const GLfixed *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultMatrixx);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultMatrixx(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4x(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4x);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::INT);
    arg_s->add_intvalue(s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::INT);
    arg_t->add_intvalue(t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::INT);
    arg_r->add_intvalue(r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::INT);
    arg_q->add_intvalue(q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4x(target, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormal3x(GLfixed nx, GLfixed ny, GLfixed nz) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormal3x);

    // copy argument nx
    GLMessage_DataType *arg_nx = glmsg.add_args();
    arg_nx->set_isarray(false);
    arg_nx->set_type(GLMessage::DataType::INT);
    arg_nx->add_intvalue(nx);

    // copy argument ny
    GLMessage_DataType *arg_ny = glmsg.add_args();
    arg_ny->set_isarray(false);
    arg_ny->set_type(GLMessage::DataType::INT);
    arg_ny->add_intvalue(ny);

    // copy argument nz
    GLMessage_DataType *arg_nz = glmsg.add_args();
    arg_nz->set_isarray(false);
    arg_nz->set_type(GLMessage::DataType::INT);
    arg_nz->add_intvalue(nz);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormal3x(nx, ny, nz);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormalPointer);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormalPointer(type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthox);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::INT);
    arg_left->add_intvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::INT);
    arg_right->add_intvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::INT);
    arg_bottom->add_intvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::INT);
    arg_top->add_intvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthox(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterx(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterx);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterx(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterxv(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterxv);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterxv(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSizex(GLfixed size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSizex);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSizex(size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPolygonOffsetx(GLfixed factor, GLfixed units) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPolygonOffsetx);

    // copy argument factor
    GLMessage_DataType *arg_factor = glmsg.add_args();
    arg_factor->set_isarray(false);
    arg_factor->set_type(GLMessage::DataType::INT);
    arg_factor->add_intvalue(factor);

    // copy argument units
    GLMessage_DataType *arg_units = glmsg.add_args();
    arg_units->set_isarray(false);
    arg_units->set_type(GLMessage::DataType::INT);
    arg_units->add_intvalue(units);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPolygonOffsetx(factor, units);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPopMatrix(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPopMatrix);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPopMatrix();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPushMatrix(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPushMatrix);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPushMatrix();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRotatex);

    // copy argument angle
    GLMessage_DataType *arg_angle = glmsg.add_args();
    arg_angle->set_isarray(false);
    arg_angle->set_type(GLMessage::DataType::INT);
    arg_angle->add_intvalue(angle);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRotatex(angle, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleCoveragex(GLclampx value, GLboolean invert) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleCoveragex);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // copy argument invert
    GLMessage_DataType *arg_invert = glmsg.add_args();
    arg_invert->set_isarray(false);
    arg_invert->set_type(GLMessage::DataType::BOOL);
    arg_invert->add_boolvalue(invert);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleCoveragex(value, invert);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScalex(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScalex);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScalex(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glShadeModel(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glShadeModel);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glShadeModel(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexCoordPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexCoordPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvi(GLenum target, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvi);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvi(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvx(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvx);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvx(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnviv(GLenum target, GLenum pname, const GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnviv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnviv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvxv(GLenum target, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterx(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterx);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterx(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterxv(GLenum target, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterxv);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterxv(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTranslatex(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTranslatex);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTranslatex(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glVertexPointer);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glVertexPointer(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSizePointerOES(GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSizePointerOES);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSizePointerOES(type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


// Definitions for GL1Ext APIs

void GLTrace_glBlendEquationSeparateOES(GLenum modeRGB, GLenum modeAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationSeparateOES);

    // copy argument modeRGB
    GLMessage_DataType *arg_modeRGB = glmsg.add_args();
    arg_modeRGB->set_isarray(false);
    arg_modeRGB->set_type(GLMessage::DataType::ENUM);
    arg_modeRGB->add_intvalue((int)modeRGB);

    // copy argument modeAlpha
    GLMessage_DataType *arg_modeAlpha = glmsg.add_args();
    arg_modeAlpha->set_isarray(false);
    arg_modeAlpha->set_type(GLMessage::DataType::ENUM);
    arg_modeAlpha->add_intvalue((int)modeAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationSeparateOES(modeRGB, modeAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendFuncSeparateOES(GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendFuncSeparateOES);

    // copy argument srcRGB
    GLMessage_DataType *arg_srcRGB = glmsg.add_args();
    arg_srcRGB->set_isarray(false);
    arg_srcRGB->set_type(GLMessage::DataType::ENUM);
    arg_srcRGB->add_intvalue((int)srcRGB);

    // copy argument dstRGB
    GLMessage_DataType *arg_dstRGB = glmsg.add_args();
    arg_dstRGB->set_isarray(false);
    arg_dstRGB->set_type(GLMessage::DataType::ENUM);
    arg_dstRGB->add_intvalue((int)dstRGB);

    // copy argument srcAlpha
    GLMessage_DataType *arg_srcAlpha = glmsg.add_args();
    arg_srcAlpha->set_isarray(false);
    arg_srcAlpha->set_type(GLMessage::DataType::ENUM);
    arg_srcAlpha->add_intvalue((int)srcAlpha);

    // copy argument dstAlpha
    GLMessage_DataType *arg_dstAlpha = glmsg.add_args();
    arg_dstAlpha->set_isarray(false);
    arg_dstAlpha->set_type(GLMessage::DataType::ENUM);
    arg_dstAlpha->add_intvalue((int)dstAlpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendFuncSeparateOES(srcRGB, dstRGB, srcAlpha, dstAlpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glBlendEquationOES(GLenum mode) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBlendEquationOES);

    // copy argument mode
    GLMessage_DataType *arg_mode = glmsg.add_args();
    arg_mode->set_isarray(false);
    arg_mode->set_type(GLMessage::DataType::ENUM);
    arg_mode->add_intvalue((int)mode);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBlendEquationOES(mode);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexsOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexsOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexiOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexiOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexxOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexxOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexsvOES(const GLshort *coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexsvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT);
    arg_coords->add_intvalue((int)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexsvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexivOES(const GLint *coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexivOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT);
    arg_coords->add_intvalue((int)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexivOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexxvOES(const GLfixed *coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexxvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT);
    arg_coords->add_intvalue((int)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexxvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexfOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::FLOAT);
    arg_x->add_floatvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::FLOAT);
    arg_y->add_floatvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::FLOAT);
    arg_z->add_floatvalue(z);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::FLOAT);
    arg_width->add_floatvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::FLOAT);
    arg_height->add_floatvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexfOES(x, y, z, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDrawTexfvOES(const GLfloat *coords) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDrawTexfvOES);

    // copy argument coords
    GLMessage_DataType *arg_coords = glmsg.add_args();
    arg_coords->set_isarray(false);
    arg_coords->set_type(GLMessage::DataType::INT);
    arg_coords->add_intvalue((int)coords);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDrawTexfvOES(coords);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) coords,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glAlphaFuncxOES(GLenum func, GLclampx ref) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glAlphaFuncxOES);

    // copy argument func
    GLMessage_DataType *arg_func = glmsg.add_args();
    arg_func->set_isarray(false);
    arg_func->set_type(GLMessage::DataType::ENUM);
    arg_func->add_intvalue((int)func);

    // copy argument ref
    GLMessage_DataType *arg_ref = glmsg.add_args();
    arg_ref->set_isarray(false);
    arg_ref->set_type(GLMessage::DataType::INT);
    arg_ref->add_intvalue(ref);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glAlphaFuncxOES(func, ref);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearColorxOES(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearColorxOES);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearColorxOES(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthxOES(GLclampx depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthxOES);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::INT);
    arg_depth->add_intvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthxOES(depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanexOES(GLenum plane, const GLfixed *equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanexOES);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT);
    arg_equation->add_intvalue((int)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanexOES(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glColor4xOES(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glColor4xOES);

    // copy argument red
    GLMessage_DataType *arg_red = glmsg.add_args();
    arg_red->set_isarray(false);
    arg_red->set_type(GLMessage::DataType::INT);
    arg_red->add_intvalue(red);

    // copy argument green
    GLMessage_DataType *arg_green = glmsg.add_args();
    arg_green->set_isarray(false);
    arg_green->set_type(GLMessage::DataType::INT);
    arg_green->add_intvalue(green);

    // copy argument blue
    GLMessage_DataType *arg_blue = glmsg.add_args();
    arg_blue->set_isarray(false);
    arg_blue->set_type(GLMessage::DataType::INT);
    arg_blue->add_intvalue(blue);

    // copy argument alpha
    GLMessage_DataType *arg_alpha = glmsg.add_args();
    arg_alpha->set_isarray(false);
    arg_alpha->set_type(GLMessage::DataType::INT);
    arg_alpha->add_intvalue(alpha);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glColor4xOES(red, green, blue, alpha);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDepthRangexOES(GLclampx zNear, GLclampx zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangexOES);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangexOES(zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogxOES(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogxOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogxOES(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFogxvOES(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFogxvOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFogxvOES(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumxOES(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumxOES);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::INT);
    arg_left->add_intvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::INT);
    arg_right->add_intvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::INT);
    arg_bottom->add_intvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::INT);
    arg_top->add_intvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumxOES(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanexOES(GLenum pname, GLfixed eqn[4]) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanexOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanexOES(pname, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFixedvOES(GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFixedvOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFixedvOES(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetLightxvOES(GLenum light, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetLightxvOES);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetLightxvOES(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetMaterialxvOES(GLenum face, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetMaterialxvOES);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetMaterialxvOES(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexEnvxvOES(GLenum env, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexEnvxvOES);

    // copy argument env
    GLMessage_DataType *arg_env = glmsg.add_args();
    arg_env->set_isarray(false);
    arg_env->set_type(GLMessage::DataType::ENUM);
    arg_env->add_intvalue((int)env);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexEnvxvOES(env, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexParameterxvOES(GLenum target, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexParameterxvOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexParameterxvOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelxOES(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelxOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelxOES(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightModelxvOES(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightModelxvOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightModelxvOES(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightxOES(GLenum light, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightxOES);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightxOES(light, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLightxvOES(GLenum light, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLightxvOES);

    // copy argument light
    GLMessage_DataType *arg_light = glmsg.add_args();
    arg_light->set_isarray(false);
    arg_light->set_type(GLMessage::DataType::ENUM);
    arg_light->add_intvalue((int)light);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLightxvOES(light, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLineWidthxOES(GLfixed width) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLineWidthxOES);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLineWidthxOES(width);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadMatrixxOES(const GLfixed *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadMatrixxOES);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadMatrixxOES(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialxOES(GLenum face, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialxOES);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialxOES(face, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMaterialxvOES(GLenum face, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMaterialxvOES);

    // copy argument face
    GLMessage_DataType *arg_face = glmsg.add_args();
    arg_face->set_isarray(false);
    arg_face->set_type(GLMessage::DataType::ENUM);
    arg_face->add_intvalue((int)face);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMaterialxvOES(face, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultMatrixxOES(const GLfixed *m) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultMatrixxOES);

    // copy argument m
    GLMessage_DataType *arg_m = glmsg.add_args();
    arg_m->set_isarray(false);
    arg_m->set_type(GLMessage::DataType::INT);
    arg_m->add_intvalue((int)m);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultMatrixxOES(m);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) m,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMultiTexCoord4xOES(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMultiTexCoord4xOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument s
    GLMessage_DataType *arg_s = glmsg.add_args();
    arg_s->set_isarray(false);
    arg_s->set_type(GLMessage::DataType::INT);
    arg_s->add_intvalue(s);

    // copy argument t
    GLMessage_DataType *arg_t = glmsg.add_args();
    arg_t->set_isarray(false);
    arg_t->set_type(GLMessage::DataType::INT);
    arg_t->add_intvalue(t);

    // copy argument r
    GLMessage_DataType *arg_r = glmsg.add_args();
    arg_r->set_isarray(false);
    arg_r->set_type(GLMessage::DataType::INT);
    arg_r->add_intvalue(r);

    // copy argument q
    GLMessage_DataType *arg_q = glmsg.add_args();
    arg_q->set_isarray(false);
    arg_q->set_type(GLMessage::DataType::INT);
    arg_q->add_intvalue(q);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMultiTexCoord4xOES(target, s, t, r, q);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glNormal3xOES(GLfixed nx, GLfixed ny, GLfixed nz) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glNormal3xOES);

    // copy argument nx
    GLMessage_DataType *arg_nx = glmsg.add_args();
    arg_nx->set_isarray(false);
    arg_nx->set_type(GLMessage::DataType::INT);
    arg_nx->add_intvalue(nx);

    // copy argument ny
    GLMessage_DataType *arg_ny = glmsg.add_args();
    arg_ny->set_isarray(false);
    arg_ny->set_type(GLMessage::DataType::INT);
    arg_ny->add_intvalue(ny);

    // copy argument nz
    GLMessage_DataType *arg_nz = glmsg.add_args();
    arg_nz->set_isarray(false);
    arg_nz->set_type(GLMessage::DataType::INT);
    arg_nz->add_intvalue(nz);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glNormal3xOES(nx, ny, nz);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthoxOES(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthoxOES);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::INT);
    arg_left->add_intvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::INT);
    arg_right->add_intvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::INT);
    arg_bottom->add_intvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::INT);
    arg_top->add_intvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::INT);
    arg_zNear->add_intvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::INT);
    arg_zFar->add_intvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthoxOES(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterxOES(GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterxOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterxOES(pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointParameterxvOES(GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointParameterxvOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointParameterxvOES(pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPointSizexOES(GLfixed size) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPointSizexOES);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPointSizexOES(size);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glPolygonOffsetxOES(GLfixed factor, GLfixed units) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glPolygonOffsetxOES);

    // copy argument factor
    GLMessage_DataType *arg_factor = glmsg.add_args();
    arg_factor->set_isarray(false);
    arg_factor->set_type(GLMessage::DataType::INT);
    arg_factor->add_intvalue(factor);

    // copy argument units
    GLMessage_DataType *arg_units = glmsg.add_args();
    arg_units->set_isarray(false);
    arg_units->set_type(GLMessage::DataType::INT);
    arg_units->add_intvalue(units);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glPolygonOffsetxOES(factor, units);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRotatexOES(GLfixed angle, GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRotatexOES);

    // copy argument angle
    GLMessage_DataType *arg_angle = glmsg.add_args();
    arg_angle->set_isarray(false);
    arg_angle->set_type(GLMessage::DataType::INT);
    arg_angle->add_intvalue(angle);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRotatexOES(angle, x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glSampleCoveragexOES(GLclampx value, GLboolean invert) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glSampleCoveragexOES);

    // copy argument value
    GLMessage_DataType *arg_value = glmsg.add_args();
    arg_value->set_isarray(false);
    arg_value->set_type(GLMessage::DataType::INT);
    arg_value->add_intvalue(value);

    // copy argument invert
    GLMessage_DataType *arg_invert = glmsg.add_args();
    arg_invert->set_isarray(false);
    arg_invert->set_type(GLMessage::DataType::BOOL);
    arg_invert->add_boolvalue(invert);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glSampleCoveragexOES(value, invert);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glScalexOES(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glScalexOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glScalexOES(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvxOES(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvxOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvxOES(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexEnvxvOES(GLenum target, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexEnvxvOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexEnvxvOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterxOES(GLenum target, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterxOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterxOES(target, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexParameterxvOES(GLenum target, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexParameterxvOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexParameterxvOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTranslatexOES(GLfixed x, GLfixed y, GLfixed z) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTranslatexOES);

    // copy argument x
    GLMessage_DataType *arg_x = glmsg.add_args();
    arg_x->set_isarray(false);
    arg_x->set_type(GLMessage::DataType::INT);
    arg_x->add_intvalue(x);

    // copy argument y
    GLMessage_DataType *arg_y = glmsg.add_args();
    arg_y->set_isarray(false);
    arg_y->set_type(GLMessage::DataType::INT);
    arg_y->add_intvalue(y);

    // copy argument z
    GLMessage_DataType *arg_z = glmsg.add_args();
    arg_z->set_isarray(false);
    arg_z->set_type(GLMessage::DataType::INT);
    arg_z->add_intvalue(z);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTranslatexOES(x, y, z);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsRenderbufferOES(GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsRenderbufferOES);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsRenderbufferOES(renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBindRenderbufferOES(GLenum target, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindRenderbufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindRenderbufferOES(target, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteRenderbuffersOES(GLsizei n, const GLuint* renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteRenderbuffersOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT);
    arg_renderbuffers->add_intvalue((int)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteRenderbuffersOES(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenRenderbuffersOES(GLsizei n, GLuint* renderbuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenRenderbuffersOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument renderbuffers
    GLMessage_DataType *arg_renderbuffers = glmsg.add_args();
    arg_renderbuffers->set_isarray(false);
    arg_renderbuffers->set_type(GLMessage::DataType::INT);
    arg_renderbuffers->add_intvalue((int)renderbuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenRenderbuffersOES(n, renderbuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) renderbuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glRenderbufferStorageOES(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glRenderbufferStorageOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument internalformat
    GLMessage_DataType *arg_internalformat = glmsg.add_args();
    arg_internalformat->set_isarray(false);
    arg_internalformat->set_type(GLMessage::DataType::ENUM);
    arg_internalformat->add_intvalue((int)internalformat);

    // copy argument width
    GLMessage_DataType *arg_width = glmsg.add_args();
    arg_width->set_isarray(false);
    arg_width->set_type(GLMessage::DataType::INT);
    arg_width->add_intvalue(width);

    // copy argument height
    GLMessage_DataType *arg_height = glmsg.add_args();
    arg_height->set_isarray(false);
    arg_height->set_type(GLMessage::DataType::INT);
    arg_height->add_intvalue(height);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glRenderbufferStorageOES(target, internalformat, width, height);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetRenderbufferParameterivOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetRenderbufferParameterivOES(target, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLboolean GLTrace_glIsFramebufferOES(GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glIsFramebufferOES);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLboolean retValue = glContext->hooks->gl.glIsFramebufferOES(framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::BOOL);
    rt->add_boolvalue(retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glBindFramebufferOES(GLenum target, GLuint framebuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glBindFramebufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument framebuffer
    GLMessage_DataType *arg_framebuffer = glmsg.add_args();
    arg_framebuffer->set_isarray(false);
    arg_framebuffer->set_type(GLMessage::DataType::INT);
    arg_framebuffer->add_intvalue(framebuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glBindFramebufferOES(target, framebuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glDeleteFramebuffersOES(GLsizei n, const GLuint* framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDeleteFramebuffersOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT);
    arg_framebuffers->add_intvalue((int)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDeleteFramebuffersOES(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenFramebuffersOES(GLsizei n, GLuint* framebuffers) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenFramebuffersOES);

    // copy argument n
    GLMessage_DataType *arg_n = glmsg.add_args();
    arg_n->set_isarray(false);
    arg_n->set_type(GLMessage::DataType::INT);
    arg_n->add_intvalue(n);

    // copy argument framebuffers
    GLMessage_DataType *arg_framebuffers = glmsg.add_args();
    arg_framebuffers->set_isarray(false);
    arg_framebuffers->set_type(GLMessage::DataType::INT);
    arg_framebuffers->add_intvalue((int)framebuffers);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenFramebuffersOES(n, framebuffers);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) framebuffers,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLenum GLTrace_glCheckFramebufferStatusOES(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCheckFramebufferStatusOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLenum retValue = glContext->hooks->gl.glCheckFramebufferStatusOES(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::ENUM);
    rt->add_intvalue((int)retValue);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glFramebufferRenderbufferOES(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferRenderbufferOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument renderbuffertarget
    GLMessage_DataType *arg_renderbuffertarget = glmsg.add_args();
    arg_renderbuffertarget->set_isarray(false);
    arg_renderbuffertarget->set_type(GLMessage::DataType::ENUM);
    arg_renderbuffertarget->add_intvalue((int)renderbuffertarget);

    // copy argument renderbuffer
    GLMessage_DataType *arg_renderbuffer = glmsg.add_args();
    arg_renderbuffer->set_isarray(false);
    arg_renderbuffer->set_type(GLMessage::DataType::INT);
    arg_renderbuffer->add_intvalue(renderbuffer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferRenderbufferOES(target, attachment, renderbuffertarget, renderbuffer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFramebufferTexture2DOES(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFramebufferTexture2DOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument textarget
    GLMessage_DataType *arg_textarget = glmsg.add_args();
    arg_textarget->set_isarray(false);
    arg_textarget->set_type(GLMessage::DataType::ENUM);
    arg_textarget->add_intvalue((int)textarget);

    // copy argument texture
    GLMessage_DataType *arg_texture = glmsg.add_args();
    arg_texture->set_isarray(false);
    arg_texture->set_type(GLMessage::DataType::INT);
    arg_texture->add_intvalue(texture);

    // copy argument level
    GLMessage_DataType *arg_level = glmsg.add_args();
    arg_level->set_isarray(false);
    arg_level->set_type(GLMessage::DataType::INT);
    arg_level->add_intvalue(level);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFramebufferTexture2DOES(target, attachment, textarget, texture, level);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetFramebufferAttachmentParameterivOES(GLenum target, GLenum attachment, GLenum pname, GLint* params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetFramebufferAttachmentParameterivOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // copy argument attachment
    GLMessage_DataType *arg_attachment = glmsg.add_args();
    arg_attachment->set_isarray(false);
    arg_attachment->set_type(GLMessage::DataType::ENUM);
    arg_attachment->add_intvalue((int)attachment);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetFramebufferAttachmentParameterivOES(target, attachment, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGenerateMipmapOES(GLenum target) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGenerateMipmapOES);

    // copy argument target
    GLMessage_DataType *arg_target = glmsg.add_args();
    arg_target->set_isarray(false);
    arg_target->set_type(GLMessage::DataType::ENUM);
    arg_target->add_intvalue((int)target);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGenerateMipmapOES(target);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glCurrentPaletteMatrixOES(GLuint matrixpaletteindex) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glCurrentPaletteMatrixOES);

    // copy argument matrixpaletteindex
    GLMessage_DataType *arg_matrixpaletteindex = glmsg.add_args();
    arg_matrixpaletteindex->set_isarray(false);
    arg_matrixpaletteindex->set_type(GLMessage::DataType::INT);
    arg_matrixpaletteindex->add_intvalue(matrixpaletteindex);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glCurrentPaletteMatrixOES(matrixpaletteindex);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glLoadPaletteFromModelViewMatrixOES(void) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glLoadPaletteFromModelViewMatrixOES);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glLoadPaletteFromModelViewMatrixOES();
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glMatrixIndexPointerOES(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glMatrixIndexPointerOES);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glMatrixIndexPointerOES(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glWeightPointerOES(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glWeightPointerOES);

    // copy argument size
    GLMessage_DataType *arg_size = glmsg.add_args();
    arg_size->set_isarray(false);
    arg_size->set_type(GLMessage::DataType::INT);
    arg_size->add_intvalue(size);

    // copy argument type
    GLMessage_DataType *arg_type = glmsg.add_args();
    arg_type->set_isarray(false);
    arg_type->set_type(GLMessage::DataType::ENUM);
    arg_type->add_intvalue((int)type);

    // copy argument stride
    GLMessage_DataType *arg_stride = glmsg.add_args();
    arg_stride->set_isarray(false);
    arg_stride->set_type(GLMessage::DataType::INT);
    arg_stride->add_intvalue(stride);

    // copy argument pointer
    GLMessage_DataType *arg_pointer = glmsg.add_args();
    arg_pointer->set_isarray(false);
    arg_pointer->set_type(GLMessage::DataType::INT);
    arg_pointer->add_intvalue((int)pointer);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glWeightPointerOES(size, type, stride, pointer);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) pointer,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

GLbitfield GLTrace_glQueryMatrixxOES(GLfixed mantissa[16], GLint exponent[16]) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glQueryMatrixxOES);

    // copy argument mantissa
    GLMessage_DataType *arg_mantissa = glmsg.add_args();
    arg_mantissa->set_isarray(false);
    arg_mantissa->set_type(GLMessage::DataType::INT);
    arg_mantissa->add_intvalue((int)mantissa);

    // copy argument exponent
    GLMessage_DataType *arg_exponent = glmsg.add_args();
    arg_exponent->set_isarray(false);
    arg_exponent->set_type(GLMessage::DataType::INT);
    arg_exponent->add_intvalue((int)exponent);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    GLbitfield retValue = glContext->hooks->gl.glQueryMatrixxOES(mantissa, exponent);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    // set return value
    GLMessage_DataType *rt = glmsg.mutable_returnvalue();
    rt->set_isarray(false);
    rt->set_type(GLMessage::DataType::INT);
    rt->add_intvalue(retValue);

    void *pointerArgs[] = {
        (void *) mantissa,
        (void *) exponent,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);

    return retValue;
}

void GLTrace_glDepthRangefOES(GLclampf zNear, GLclampf zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glDepthRangefOES);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glDepthRangefOES(zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glFrustumfOES(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glFrustumfOES);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::FLOAT);
    arg_left->add_floatvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::FLOAT);
    arg_right->add_floatvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::FLOAT);
    arg_bottom->add_floatvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::FLOAT);
    arg_top->add_floatvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glFrustumfOES(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glOrthofOES(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glOrthofOES);

    // copy argument left
    GLMessage_DataType *arg_left = glmsg.add_args();
    arg_left->set_isarray(false);
    arg_left->set_type(GLMessage::DataType::FLOAT);
    arg_left->add_floatvalue(left);

    // copy argument right
    GLMessage_DataType *arg_right = glmsg.add_args();
    arg_right->set_isarray(false);
    arg_right->set_type(GLMessage::DataType::FLOAT);
    arg_right->add_floatvalue(right);

    // copy argument bottom
    GLMessage_DataType *arg_bottom = glmsg.add_args();
    arg_bottom->set_isarray(false);
    arg_bottom->set_type(GLMessage::DataType::FLOAT);
    arg_bottom->add_floatvalue(bottom);

    // copy argument top
    GLMessage_DataType *arg_top = glmsg.add_args();
    arg_top->set_isarray(false);
    arg_top->set_type(GLMessage::DataType::FLOAT);
    arg_top->add_floatvalue(top);

    // copy argument zNear
    GLMessage_DataType *arg_zNear = glmsg.add_args();
    arg_zNear->set_isarray(false);
    arg_zNear->set_type(GLMessage::DataType::FLOAT);
    arg_zNear->add_floatvalue(zNear);

    // copy argument zFar
    GLMessage_DataType *arg_zFar = glmsg.add_args();
    arg_zFar->set_isarray(false);
    arg_zFar->set_type(GLMessage::DataType::FLOAT);
    arg_zFar->add_floatvalue(zFar);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glOrthofOES(left, right, bottom, top, zNear, zFar);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanefOES(GLenum plane, const GLfloat *equation) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanefOES);

    // copy argument plane
    GLMessage_DataType *arg_plane = glmsg.add_args();
    arg_plane->set_isarray(false);
    arg_plane->set_type(GLMessage::DataType::ENUM);
    arg_plane->add_intvalue((int)plane);

    // copy argument equation
    GLMessage_DataType *arg_equation = glmsg.add_args();
    arg_equation->set_isarray(false);
    arg_equation->set_type(GLMessage::DataType::INT);
    arg_equation->add_intvalue((int)equation);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanefOES(plane, equation);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) equation,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetClipPlanefOES(GLenum pname, GLfloat eqn[4]) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetClipPlanefOES);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetClipPlanefOES(pname, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClearDepthfOES(GLclampf depth) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClearDepthfOES);

    // copy argument depth
    GLMessage_DataType *arg_depth = glmsg.add_args();
    arg_depth->set_isarray(false);
    arg_depth->set_type(GLMessage::DataType::FLOAT);
    arg_depth->add_floatvalue(depth);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClearDepthfOES(depth);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGenfOES(GLenum coord, GLenum pname, GLfloat param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGenfOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::FLOAT);
    arg_param->add_floatvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGenfOES(coord, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGenfvOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGenfvOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGeniOES(GLenum coord, GLenum pname, GLint param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGeniOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGeniOES(coord, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGenivOES(GLenum coord, GLenum pname, const GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGenivOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGenivOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGenxOES(GLenum coord, GLenum pname, GLfixed param) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGenxOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument param
    GLMessage_DataType *arg_param = glmsg.add_args();
    arg_param->set_isarray(false);
    arg_param->set_type(GLMessage::DataType::INT);
    arg_param->add_intvalue(param);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGenxOES(coord, pname, param);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glTexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glTexGenxvOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glTexGenxvOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexGenfvOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexGenfvOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexGenivOES(GLenum coord, GLenum pname, GLint *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexGenivOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexGenivOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glGetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glGetTexGenxvOES);

    // copy argument coord
    GLMessage_DataType *arg_coord = glmsg.add_args();
    arg_coord->set_isarray(false);
    arg_coord->set_type(GLMessage::DataType::ENUM);
    arg_coord->add_intvalue((int)coord);

    // copy argument pname
    GLMessage_DataType *arg_pname = glmsg.add_args();
    arg_pname->set_isarray(false);
    arg_pname->set_type(GLMessage::DataType::ENUM);
    arg_pname->add_intvalue((int)pname);

    // copy argument params
    GLMessage_DataType *arg_params = glmsg.add_args();
    arg_params->set_isarray(false);
    arg_params->set_type(GLMessage::DataType::INT);
    arg_params->add_intvalue((int)params);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glGetTexGenxvOES(coord, pname, params);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) params,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanefIMG(GLenum p, const GLfloat *eqn) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanefIMG);

    // copy argument p
    GLMessage_DataType *arg_p = glmsg.add_args();
    arg_p->set_isarray(false);
    arg_p->set_type(GLMessage::DataType::ENUM);
    arg_p->add_intvalue((int)p);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanefIMG(p, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}

void GLTrace_glClipPlanexIMG(GLenum p, const GLfixed *eqn) {
    GLMessage glmsg;
    GLTraceContext *glContext = getGLTraceContext();

    glmsg.set_function(GLMessage::glClipPlanexIMG);

    // copy argument p
    GLMessage_DataType *arg_p = glmsg.add_args();
    arg_p->set_isarray(false);
    arg_p->set_type(GLMessage::DataType::ENUM);
    arg_p->add_intvalue((int)p);

    // copy argument eqn
    GLMessage_DataType *arg_eqn = glmsg.add_args();
    arg_eqn->set_isarray(false);
    arg_eqn->set_type(GLMessage::DataType::INT);
    arg_eqn->add_intvalue((int)eqn);

    // call function
    nsecs_t wallStartTime = systemTime(SYSTEM_TIME_MONOTONIC);
    nsecs_t threadStartTime = systemTime(SYSTEM_TIME_THREAD);
    glContext->hooks->gl.glClipPlanexIMG(p, eqn);
    nsecs_t threadEndTime = systemTime(SYSTEM_TIME_THREAD);
    nsecs_t wallEndTime = systemTime(SYSTEM_TIME_MONOTONIC);

    void *pointerArgs[] = {
        (void *) eqn,
    };

    fixupGLMessage(glContext, wallStartTime, wallEndTime,
                              threadStartTime, threadEndTime,
                              &glmsg, pointerArgs);
    glContext->traceGLMessage(&glmsg);
}


}; // namespace gltrace
}; // namespace android
