/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi;

import hypergraph.graphApi.GraphException;
import hypergraph.graphApi.GraphSystem;
import java.util.Properties;

public final class GraphSystemFactory {
    private GraphSystemFactory() {
    }

    public static GraphSystem createGraphSystem(String string, Properties properties) throws GraphException {
        try {
            Class<?> clazz = Class.forName(string);
            return GraphSystemFactory.createGraphSystem(clazz, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GraphException("Cannot find class for GraphSystem. " + classNotFoundException.getMessage());
        }
    }

    public static GraphSystem createGraphSystem(Class clazz, Properties properties) throws GraphException {
        try {
            GraphSystem graphSystem = (GraphSystem)clazz.newInstance();
            graphSystem.setProperties(properties);
            return graphSystem;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GraphException("Cannot instantiate GraphSystem class " + clazz.getName() + " - " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new GraphException("Cannot instantiate GraphSystem class " + clazz.getName() + " - " + instantiationException.getMessage());
        }
    }

    public static GraphSystem createGraphSystem(Properties properties) throws GraphException {
        String string = properties.getProperty("hypergraph.graphapi.graphsystem", null);
        if (string == null) {
            throw new GraphException("No value specified for property hypergraph.graphapi.graphsystem");
        }
        return GraphSystemFactory.createGraphSystem(string, properties);
    }
}

