/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsoaudio.h>
#include <gee.h>
#include <freesmartphone.h>
#include <gio/gio.h>
#include <fsobasics.h>
#include <sys/inotify.h>
#include <fsoframework.h>


#define ROUTER_TYPE_LIB_ALSA (router_lib_alsa_get_type ())
#define ROUTER_LIB_ALSA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ROUTER_TYPE_LIB_ALSA, RouterLibAlsa))
#define ROUTER_LIB_ALSA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaClass))
#define ROUTER_IS_LIB_ALSA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ROUTER_TYPE_LIB_ALSA))
#define ROUTER_IS_LIB_ALSA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ROUTER_TYPE_LIB_ALSA))
#define ROUTER_LIB_ALSA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaClass))

typedef struct _RouterLibAlsa RouterLibAlsa;
typedef struct _RouterLibAlsaClass RouterLibAlsaClass;
typedef struct _RouterLibAlsaPrivate RouterLibAlsaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fso_audio_mixer_control_unref0(var) ((var == NULL) ? NULL : (var = (fso_audio_mixer_control_unref (var), NULL)))
#define _fso_audio_bunch_of_mixer_controls_unref0(var) ((var == NULL) ? NULL : (var = (fso_audio_bunch_of_mixer_controls_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _RouterLibAlsa {
	FsoAudioAbstractRouter parent_instance;
	RouterLibAlsaPrivate * priv;
};

struct _RouterLibAlsaClass {
	FsoAudioAbstractRouterClass parent_class;
};

struct _RouterLibAlsaPrivate {
	FsoAudioSoundDevice* device;
	GeeHashMap* allscenarios;
	GeeHashMap* normalDeviceScenarios;
	GeeHashMap* callDeviceScenarios;
	gchar* configurationPath;
	gchar* dataPath;
	gchar* currentscenario;
};


static gpointer router_lib_alsa_parent_class = NULL;
static GType router_lib_alsa_type_id = 0;

#define FSO_AUDIO_ROUTER_ALSA_MODULE_NAME "fsoaudio.router_alsa"
GType router_lib_alsa_get_type (void) G_GNUC_CONST;
GType router_lib_alsa_register_type (GTypeModule * module);
#define ROUTER_LIB_ALSA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ROUTER_TYPE_LIB_ALSA, RouterLibAlsaPrivate))
enum  {
	ROUTER_LIB_ALSA_DUMMY_PROPERTY
};
static void router_lib_alsa_addScenario (RouterLibAlsa* self, const gchar* scenario, GFile* file, guint idxSpeakerVolume, guint idxMicVolume);
static void _vala_array_add1 (FsoAudioMixerControl*** array, int* length, int* size, FsoAudioMixerControl* value);
static GeeHashMap* router_lib_alsa_readDeviceScenarios (RouterLibAlsa* self, FsoFrameworkSmartKeyFile* alsaconf, GList* sections);
static FreeSmartphoneAudioDevice* router_lib_alsa_buildDeviceList (RouterLibAlsa* self, GeeHashMap* deviceMap, int* result_length1);
static void _vala_array_add2 (FreeSmartphoneAudioDevice** array, int* length, int* size, FreeSmartphoneAudioDevice value);
static void router_lib_alsa_initScenarios (RouterLibAlsa* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void router_lib_alsa_onModifiedScenario (RouterLibAlsa* self, int flags, guint32 cookie, const gchar* name);
static void _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func (int flags, guint32 cookie, const gchar* name, gpointer self);
static void router_lib_alsa_updateScenarioIfChanged (RouterLibAlsa* self, const gchar* scenario);
static gchar* router_lib_alsa_retrieveScenarioForDevice (RouterLibAlsa* self, FreeSmartphoneAudioDevice device);
static gboolean router_lib_alsa_setScenarioForDevice (RouterLibAlsa* self, FreeSmartphoneAudioDevice device);
static gchar* router_lib_alsa_real_repr (FsoFrameworkAbstractObject* base);
static void router_lib_alsa_real_set_mode (FsoAudioAbstractRouter* base, FreeSmartphoneAudioMode mode, gboolean force);
const gchar* free_smartphone_audio_mode_to_string (FreeSmartphoneAudioMode self);
static void router_lib_alsa_real_set_device (FsoAudioAbstractRouter* base, FreeSmartphoneAudioDevice device, gboolean expose);
static void router_lib_alsa_real_set_volume (FsoAudioAbstractRouter* base, FreeSmartphoneAudioControl control, guint volume);
RouterLibAlsa* router_lib_alsa_new (void);
RouterLibAlsa* router_lib_alsa_construct (GType object_type);
static GObject * router_lib_alsa_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void router_lib_alsa_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _fso_audio_mixer_control_ref0 (gpointer self) {
	return self ? fso_audio_mixer_control_ref (self) : NULL;
}


static void _vala_array_add1 (FsoAudioMixerControl*** array, int* length, int* size, FsoAudioMixerControl* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FsoAudioMixerControl*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void router_lib_alsa_addScenario (RouterLibAlsa* self, const gchar* scenario, GFile* file, guint idxSpeakerVolume, guint idxMicVolume) {
	FsoAudioMixerControl** _tmp0_ = NULL;
	FsoAudioMixerControl** controls;
	gint controls_length1;
	gint _controls_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scenario != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_new0 (FsoAudioMixerControl*, 0 + 1);
	controls = _tmp0_;
	controls_length1 = 0;
	_controls_size_ = controls_length1;
	{
		GFile* _tmp1_;
		GFileInputStream* _tmp2_ = NULL;
		GFileInputStream* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* _tmp5_;
		GDataInputStream* _tmp6_;
		GDataInputStream* in_stream;
		gchar* line = NULL;
		FsoAudioMixerControl** _tmp24_;
		gint _tmp24__length1;
		guint _tmp25_;
		guint _tmp26_;
		FsoAudioBunchOfMixerControls* _tmp27_;
		FsoAudioBunchOfMixerControls* bunch;
		GeeHashMap* _tmp28_;
		const gchar* _tmp29_;
		FsoAudioBunchOfMixerControls* _tmp30_;
		_tmp1_ = file;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		_tmp4_ = _tmp3_;
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		in_stream = _tmp6_;
		while (TRUE) {
			GDataInputStream* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* stripped;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			gboolean _tmp17_;
			FsoAudioSoundDevice* _tmp18_;
			const gchar* _tmp19_;
			FsoAudioMixerControl* _tmp20_ = NULL;
			FsoAudioMixerControl* control;
			FsoAudioMixerControl** _tmp21_;
			gint _tmp21__length1;
			FsoAudioMixerControl* _tmp22_;
			FsoAudioMixerControl* _tmp23_;
			_tmp7_ = in_stream;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_object_unref0 (in_stream);
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				_g_free0 (line);
				_g_object_unref0 (in_stream);
				controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_audio_mixer_control_unref), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = line;
			_tmp12_ = string_strip (_tmp11_);
			stripped = _tmp12_;
			_tmp14_ = stripped;
			if (g_strcmp0 (_tmp14_, "") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = stripped;
				_tmp16_ = g_str_has_prefix (_tmp15_, "#");
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = _tmp13_;
			if (_tmp17_) {
				_g_free0 (stripped);
				continue;
			}
			_tmp18_ = self->priv->device;
			_tmp19_ = line;
			_tmp20_ = fso_audio_sound_device_controlForString (_tmp18_, _tmp19_, &_inner_error_);
			control = _tmp20_;
			if (_inner_error_ != NULL) {
				_g_free0 (stripped);
				_g_free0 (line);
				_g_object_unref0 (in_stream);
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				goto __finally0;
			}
			_tmp21_ = controls;
			_tmp21__length1 = controls_length1;
			_tmp22_ = control;
			_tmp23_ = _fso_audio_mixer_control_ref0 (_tmp22_);
			_vala_array_add1 (&controls, &controls_length1, &_controls_size_, _tmp23_);
			_fso_audio_mixer_control_unref0 (control);
			_g_free0 (stripped);
		}
		_tmp24_ = controls;
		_tmp24__length1 = controls_length1;
		_tmp25_ = idxSpeakerVolume;
		_tmp26_ = idxMicVolume;
		_tmp27_ = fso_audio_bunch_of_mixer_controls_new (_tmp24_, _tmp24__length1, _tmp25_, _tmp26_);
		bunch = _tmp27_;
		_tmp28_ = self->priv->allscenarios;
		_tmp29_ = scenario;
		_tmp30_ = bunch;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
		_fso_audio_bunch_of_mixer_controls_unref0 (bunch);
		_g_free0 (line);
		_g_object_unref0 (in_stream);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = fso_framework_theLogger;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		_tmp34_ = g_strdup_printf ("%s", _tmp33_);
		_tmp35_ = _tmp34_;
		fso_framework_logger_warning (_tmp31_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_audio_mixer_control_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	controls = (_vala_array_free (controls, controls_length1, (GDestroyNotify) fso_audio_mixer_control_unref), NULL);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static GeeHashMap* router_lib_alsa_readDeviceScenarios (RouterLibAlsa* self, FsoFrameworkSmartKeyFile* alsaconf, GList* sections) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _result_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (alsaconf != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = sections;
	{
		GList* section_collection = NULL;
		GList* section_it = NULL;
		section_collection = _tmp1_;
		for (section_it = section_collection; section_it != NULL; section_it = section_it->next) {
			gchar* _tmp2_;
			gchar* section = NULL;
			_tmp2_ = g_strdup ((const gchar*) section_it->data);
			section = _tmp2_;
			{
				const gchar* _tmp3_;
				gchar** _tmp4_;
				gchar** _tmp5_ = NULL;
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* device_name;
				const gchar* _tmp10_;
				_tmp3_ = section;
				_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ".", 0);
				_tmp6_ = _tmp5_;
				_tmp6__length1 = _vala_array_length (_tmp4_);
				_tmp7_ = _tmp6_[1];
				_tmp8_ = g_strdup (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
				device_name = _tmp9_;
				_tmp10_ = device_name;
				if (g_strcmp0 (_tmp10_, "") != 0) {
					FsoFrameworkSmartKeyFile* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* scenario;
					FsoFrameworkSmartKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_ = 0;
					gint idxSpeakerVolume;
					FsoFrameworkSmartKeyFile* _tmp17_;
					const gchar* _tmp18_;
					gint _tmp19_ = 0;
					gint idxMicVolume;
					FsoFrameworkLogger* _tmp20_;
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					GFile* _tmp31_ = NULL;
					GFile* _tmp32_;
					GFile* file;
					GFile* _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp11_ = alsaconf;
					_tmp12_ = section;
					_tmp13_ = fso_framework_smart_key_file_stringValue (_tmp11_, _tmp12_, "scenario", "");
					scenario = _tmp13_;
					_tmp14_ = alsaconf;
					_tmp15_ = section;
					_tmp16_ = fso_framework_smart_key_file_intValue (_tmp14_, _tmp15_, "speaker_volume", 0);
					idxSpeakerVolume = _tmp16_;
					_tmp17_ = alsaconf;
					_tmp18_ = section;
					_tmp19_ = fso_framework_smart_key_file_intValue (_tmp17_, _tmp18_, "mic_volume", 0);
					idxMicVolume = _tmp19_;
					_tmp20_ = fso_framework_theLogger;
					_tmp21_ = scenario;
					_tmp22_ = idxSpeakerVolume;
					_tmp23_ = idxMicVolume;
					_tmp24_ = g_strdup_printf ("Found scenario '%s' - speaker volume = %d, mic volume = %d", _tmp21_, _tmp22_, _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = fso_framework_logger_debug (_tmp20_, _tmp25_);
					g_assert (_tmp26_);
					_g_free0 (_tmp25_);
					_tmp27_ = self->priv->dataPath;
					_tmp28_ = scenario;
					_tmp29_ = g_build_filename (_tmp27_, _tmp28_, NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_file_new_for_path (_tmp30_);
					_tmp32_ = _tmp31_;
					_g_free0 (_tmp30_);
					file = _tmp32_;
					_tmp33_ = file;
					_tmp34_ = g_file_query_exists (_tmp33_, NULL);
					if (!_tmp34_) {
						FsoFrameworkLogger* _tmp35_;
						GFile* _tmp36_;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_;
						const gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_;
						_tmp35_ = fso_framework_theLogger;
						_tmp36_ = file;
						_tmp37_ = g_file_get_path (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = string_to_string (_tmp38_);
						_tmp40_ = g_strconcat ("Scenario file ", _tmp39_, " doesn't exist. Ignoring.", NULL);
						_tmp41_ = _tmp40_;
						fso_framework_logger_warning (_tmp35_, _tmp41_);
						_g_free0 (_tmp41_);
						_g_free0 (_tmp38_);
					} else {
						const gchar* _tmp42_;
						GFile* _tmp43_;
						gint _tmp44_;
						gint _tmp45_;
						const gchar* _tmp46_;
						gpointer _tmp47_ = NULL;
						FreeSmartphoneAudioDevice device_type;
						GeeHashMap* _tmp48_;
						FreeSmartphoneAudioDevice _tmp49_;
						const gchar* _tmp50_;
						_tmp42_ = scenario;
						_tmp43_ = file;
						_tmp44_ = idxSpeakerVolume;
						_tmp45_ = idxMicVolume;
						router_lib_alsa_addScenario (self, _tmp42_, _tmp43_, (guint) _tmp44_, (guint) _tmp45_);
						_tmp46_ = device_name;
						_tmp47_ = fso_framework_string_handling_enumFromNick (FREE_SMARTPHONE_AUDIO_TYPE_DEVICE, NULL, NULL, _tmp46_);
						device_type = GPOINTER_TO_INT (_tmp47_);
						_tmp48_ = _result_;
						_tmp49_ = device_type;
						_tmp50_ = scenario;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, GINT_TO_POINTER (_tmp49_), _tmp50_);
					}
					_g_object_unref0 (file);
					_g_free0 (scenario);
				}
				_g_free0 (device_name);
				_g_free0 (section);
			}
		}
	}
	result = _result_;
	return result;
}


static void _vala_array_add2 (FreeSmartphoneAudioDevice** array, int* length, int* size, FreeSmartphoneAudioDevice value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FreeSmartphoneAudioDevice, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static FreeSmartphoneAudioDevice* router_lib_alsa_buildDeviceList (RouterLibAlsa* self, GeeHashMap* deviceMap, int* result_length1) {
	FreeSmartphoneAudioDevice* result = NULL;
	FreeSmartphoneAudioDevice* _tmp0_ = NULL;
	FreeSmartphoneAudioDevice* devices;
	gint devices_length1;
	gint _devices_size_;
	FreeSmartphoneAudioDevice* _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (deviceMap != NULL, NULL);
	_tmp0_ = g_new0 (FreeSmartphoneAudioDevice, 0);
	devices = _tmp0_;
	devices_length1 = 0;
	_devices_size_ = devices_length1;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _device_it;
		_tmp1_ = deviceMap;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_device_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			FreeSmartphoneAudioDevice device;
			FreeSmartphoneAudioDevice* _tmp11_;
			gint _tmp11__length1;
			FreeSmartphoneAudioDevice _tmp12_;
			_tmp7_ = _device_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _device_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			device = GPOINTER_TO_INT (_tmp10_);
			_tmp11_ = devices;
			_tmp11__length1 = devices_length1;
			_tmp12_ = device;
			_vala_array_add2 (&devices, &devices_length1, &_devices_size_, _tmp12_);
		}
		_g_object_unref0 (_device_it);
	}
	_tmp13_ = devices;
	_tmp13__length1 = devices_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func (int flags, guint32 cookie, const gchar* name, gpointer self) {
	router_lib_alsa_onModifiedScenario (self, flags, cookie, name);
}


static void router_lib_alsa_initScenarios (RouterLibAlsa* self) {
	GList* sections = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	gchar* _tmp4_;
	FsoFrameworkSmartKeyFile* _tmp5_;
	FsoFrameworkSmartKeyFile* alsaconf;
	FsoFrameworkSmartKeyFile* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_utility_machineConfigurationDir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "/alsa.conf", NULL);
	_g_free0 (self->priv->configurationPath);
	self->priv->configurationPath = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_AUDIO_TYPE_BUNCH_OF_MIXER_CONTROLS, (GBoxedCopyFunc) fso_audio_bunch_of_mixer_controls_ref, fso_audio_bunch_of_mixer_controls_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->allscenarios);
	self->priv->allscenarios = _tmp3_;
	_tmp4_ = g_strdup ("unknown");
	_g_free0 (self->priv->currentscenario);
	self->priv->currentscenario = _tmp4_;
	_tmp5_ = fso_framework_smart_key_file_new ();
	alsaconf = _tmp5_;
	_tmp6_ = alsaconf;
	_tmp7_ = self->priv->configurationPath;
	_tmp8_ = fso_framework_smart_key_file_loadFromFile (_tmp6_, _tmp7_);
	if (_tmp8_) {
		FsoFrameworkSmartKeyFile* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* soundcard;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FsoFrameworkSmartKeyFile* _tmp27_;
		GList* _tmp28_ = NULL;
		FsoFrameworkSmartKeyFile* _tmp29_;
		GList* _tmp30_;
		GeeHashMap* _tmp31_ = NULL;
		GeeHashMap* _tmp32_;
		gint _tmp33_ = 0;
		FreeSmartphoneAudioDevice* _tmp34_ = NULL;
		FsoFrameworkSmartKeyFile* _tmp35_;
		GList* _tmp36_ = NULL;
		FsoFrameworkSmartKeyFile* _tmp37_;
		GList* _tmp38_;
		GeeHashMap* _tmp39_ = NULL;
		GeeHashMap* _tmp40_;
		gint _tmp41_ = 0;
		FreeSmartphoneAudioDevice* _tmp42_ = NULL;
		const gchar* _tmp43_;
		_tmp9_ = alsaconf;
		_tmp10_ = fso_framework_smart_key_file_stringValue (_tmp9_, "alsa", "cardname", "default");
		soundcard = _tmp10_;
		_tmp11_ = fso_framework_utility_machineConfigurationDir ();
		_tmp12_ = _tmp11_;
		_tmp13_ = soundcard;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("/alsa-", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
		_g_free0 (self->priv->dataPath);
		self->priv->dataPath = _tmp17_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp12_);
		{
			const gchar* _tmp18_;
			FsoAudioSoundDevice* _tmp19_ = NULL;
			FsoAudioSoundDevice* _tmp20_;
			_tmp18_ = soundcard;
			_tmp19_ = fso_audio_sound_device_create (_tmp18_, &_inner_error_);
			_tmp20_ = _tmp19_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch1_fso_audio_sound_error;
				}
				_g_free0 (soundcard);
				_g_object_unref0 (alsaconf);
				__g_list_free__g_free0_0 (sections);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (self->priv->device);
			self->priv->device = _tmp20_;
		}
		goto __finally1;
		__catch1_fso_audio_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = fso_framework_theLogger;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = g_strconcat ("Sound card problem: ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			fso_framework_logger_warning (_tmp21_, _tmp26_);
			_g_free0 (_tmp26_);
			_g_error_free0 (e);
			_g_free0 (soundcard);
			_g_object_unref0 (alsaconf);
			__g_list_free__g_free0_0 (sections);
			return;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (soundcard);
			_g_object_unref0 (alsaconf);
			__g_list_free__g_free0_0 (sections);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = alsaconf;
		_tmp28_ = fso_framework_smart_key_file_sectionsWithPrefix (_tmp27_, "normal.");
		__g_list_free__g_free0_0 (sections);
		sections = _tmp28_;
		_tmp29_ = alsaconf;
		_tmp30_ = sections;
		_tmp31_ = router_lib_alsa_readDeviceScenarios (self, _tmp29_, _tmp30_);
		_g_object_unref0 (self->priv->normalDeviceScenarios);
		self->priv->normalDeviceScenarios = _tmp31_;
		_tmp32_ = self->priv->normalDeviceScenarios;
		_tmp34_ = router_lib_alsa_buildDeviceList (self, _tmp32_, &_tmp33_);
		((FsoAudioAbstractRouter*) self)->normal_supported_devices = (g_free (((FsoAudioAbstractRouter*) self)->normal_supported_devices), NULL);
		((FsoAudioAbstractRouter*) self)->normal_supported_devices = _tmp34_;
		((FsoAudioAbstractRouter*) self)->normal_supported_devices_length1 = _tmp33_;
		_tmp35_ = alsaconf;
		_tmp36_ = fso_framework_smart_key_file_sectionsWithPrefix (_tmp35_, "call.");
		__g_list_free__g_free0_0 (sections);
		sections = _tmp36_;
		_tmp37_ = alsaconf;
		_tmp38_ = sections;
		_tmp39_ = router_lib_alsa_readDeviceScenarios (self, _tmp37_, _tmp38_);
		_g_object_unref0 (self->priv->callDeviceScenarios);
		self->priv->callDeviceScenarios = _tmp39_;
		_tmp40_ = self->priv->callDeviceScenarios;
		_tmp42_ = router_lib_alsa_buildDeviceList (self, _tmp40_, &_tmp41_);
		((FsoAudioAbstractRouter*) self)->call_supported_devices = (g_free (((FsoAudioAbstractRouter*) self)->call_supported_devices), NULL);
		((FsoAudioAbstractRouter*) self)->call_supported_devices = _tmp42_;
		((FsoAudioAbstractRouter*) self)->call_supported_devices_length1 = _tmp41_;
		_tmp43_ = self->priv->dataPath;
		fso_framework_inotifier_add (_tmp43_, IN_MODIFY, _router_lib_alsa_onModifiedScenario_fso_framework_inotify_notifier_func, self);
		_g_free0 (soundcard);
	} else {
		FsoFrameworkLogger* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		FsoAudioSoundDevice* _tmp57_;
		gint _tmp58_ = 0;
		FsoAudioMixerControl** _tmp59_ = NULL;
		FsoAudioMixerControl** _tmp60_;
		gint _tmp60__length1;
		gint __tmp60__size_;
		FsoAudioMixerControl** _tmp61_;
		gint _tmp61__length1;
		FsoAudioBunchOfMixerControls* _tmp62_;
		FsoAudioBunchOfMixerControls* _tmp63_;
		FsoAudioBunchOfMixerControls* bunch;
		GeeHashMap* _tmp64_;
		FsoAudioBunchOfMixerControls* _tmp65_;
		gchar* _tmp66_;
		_tmp44_ = fso_framework_theLogger;
		_tmp45_ = self->priv->configurationPath;
		_tmp46_ = string_to_string (_tmp45_);
		_tmp47_ = g_strconcat ("Could not load ", _tmp46_, ". No scenarios available.", NULL);
		_tmp48_ = _tmp47_;
		fso_framework_logger_warning (_tmp44_, _tmp48_);
		_g_free0 (_tmp48_);
		{
			FsoAudioSoundDevice* _tmp49_ = NULL;
			FsoAudioSoundDevice* _tmp50_;
			_tmp49_ = fso_audio_sound_device_create ("default", &_inner_error_);
			_tmp50_ = _tmp49_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FSO_AUDIO_SOUND_ERROR) {
					goto __catch2_fso_audio_sound_error;
				}
				_g_object_unref0 (alsaconf);
				__g_list_free__g_free0_0 (sections);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (self->priv->device);
			self->priv->device = _tmp50_;
		}
		goto __finally2;
		__catch2_fso_audio_sound_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp51_;
			GError* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp51_ = fso_framework_theLogger;
			_tmp52_ = e;
			_tmp53_ = _tmp52_->message;
			_tmp54_ = string_to_string (_tmp53_);
			_tmp55_ = g_strconcat ("Sound card problem: ", _tmp54_, NULL);
			_tmp56_ = _tmp55_;
			fso_framework_logger_warning (_tmp51_, _tmp56_);
			_g_free0 (_tmp56_);
			_g_error_free0 (e);
			_g_object_unref0 (alsaconf);
			__g_list_free__g_free0_0 (sections);
			return;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (alsaconf);
			__g_list_free__g_free0_0 (sections);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp57_ = self->priv->device;
		_tmp59_ = fso_audio_sound_device_allMixerControls (_tmp57_, &_tmp58_, &_inner_error_);
		_tmp60_ = _tmp59_;
		_tmp60__length1 = _tmp58_;
		__tmp60__size_ = _tmp60__length1;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (alsaconf);
			__g_list_free__g_free0_0 (sections);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp61_ = _tmp60_;
		_tmp61__length1 = _tmp60__length1;
		_tmp62_ = fso_audio_bunch_of_mixer_controls_new (_tmp61_, _tmp60__length1, (guint) 0, (guint) 0);
		_tmp63_ = _tmp62_;
		_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) fso_audio_mixer_control_unref), NULL);
		bunch = _tmp63_;
		_tmp64_ = self->priv->allscenarios;
		_tmp65_ = bunch;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp64_, "current", _tmp65_);
		_tmp66_ = g_strdup ("current");
		_g_free0 (self->priv->currentscenario);
		self->priv->currentscenario = _tmp66_;
		_fso_audio_bunch_of_mixer_controls_unref0 (bunch);
	}
	_g_object_unref0 (alsaconf);
	__g_list_free__g_free0_0 (sections);
}


static void router_lib_alsa_updateScenarioIfChanged (RouterLibAlsa* self, const gchar* scenario) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scenario != NULL);
	_tmp0_ = self->priv->currentscenario;
	_tmp1_ = scenario;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		FsoAudioSoundDevice* _tmp2_;
		FsoAudioSoundDevice* _tmp3_;
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_ = NULL;
		FsoAudioBunchOfMixerControls* _tmp7_;
		FsoAudioMixerControl** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = self->priv->device;
		g_assert (_tmp2_ != NULL);
		_tmp3_ = self->priv->device;
		_tmp4_ = self->priv->allscenarios;
		_tmp5_ = scenario;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (FsoAudioBunchOfMixerControls*) _tmp6_;
		_tmp8_ = _tmp7_->controls;
		_tmp8__length1 = _tmp7_->controls_length1;
		fso_audio_sound_device_setAllMixerControls (_tmp3_, _tmp8_, _tmp8__length1, &_inner_error_);
		_fso_audio_bunch_of_mixer_controls_unref0 (_tmp7_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = scenario;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->currentscenario);
		self->priv->currentscenario = _tmp10_;
	}
}


static void router_lib_alsa_onModifiedScenario (RouterLibAlsa* self, int flags, guint32 cookie, const gchar* name) {
	const gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	FsoAudioBunchOfMixerControls* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	guint idxSpeakerVolume;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	FsoAudioBunchOfMixerControls* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint idxMicVolume;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->priv->allscenarios;
	_tmp2_ = name;
	_tmp3_ = gee_map_contains ((GeeMap*) _tmp1_, _tmp2_);
	if (!_tmp3_) {
		FsoFrameworkLogger* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp4_ = fso_framework_theLogger;
		_tmp5_ = name;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat (_tmp6_, " is not a recognized scenario. Ignoring", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = fso_framework_logger_debug (_tmp4_, _tmp8_);
		g_assert (_tmp9_);
		_g_free0 (_tmp8_);
		return;
	}
	_tmp10_ = self->priv->allscenarios;
	_tmp11_ = name;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
	_tmp13_ = (FsoAudioBunchOfMixerControls*) _tmp12_;
	_tmp14_ = _tmp13_->idxSpeakerVolume;
	_tmp15_ = _tmp14_;
	_fso_audio_bunch_of_mixer_controls_unref0 (_tmp13_);
	idxSpeakerVolume = _tmp15_;
	_tmp16_ = self->priv->allscenarios;
	_tmp17_ = name;
	_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
	_tmp19_ = (FsoAudioBunchOfMixerControls*) _tmp18_;
	_tmp20_ = _tmp19_->idxMicVolume;
	_tmp21_ = _tmp20_;
	_fso_audio_bunch_of_mixer_controls_unref0 (_tmp19_);
	idxMicVolume = _tmp21_;
	_tmp22_ = name;
	_tmp23_ = self->priv->currentscenario;
	if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
		FsoFrameworkLogger* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		GFile* _tmp33_ = NULL;
		GFile* _tmp34_;
		GFile* file;
		GFile* _tmp35_;
		gboolean _tmp36_ = FALSE;
		_tmp24_ = fso_framework_theLogger;
		_tmp25_ = name;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat ("Scenario ", _tmp26_, " has been changed (being also the current scenario); invalidating cach" \
"e and reloading", NULL);
		_tmp28_ = _tmp27_;
		fso_framework_logger_info (_tmp24_, _tmp28_);
		_g_free0 (_tmp28_);
		_tmp29_ = self->priv->dataPath;
		_tmp30_ = name;
		_tmp31_ = g_build_filename (_tmp29_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_file_new_for_path (_tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		file = _tmp34_;
		_tmp35_ = file;
		_tmp36_ = g_file_query_exists (_tmp35_, NULL);
		if (!_tmp36_) {
			FsoFrameworkLogger* _tmp37_;
			GFile* _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			_tmp37_ = fso_framework_theLogger;
			_tmp38_ = file;
			_tmp39_ = g_file_get_path (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = string_to_string (_tmp40_);
			_tmp42_ = g_strconcat ("Scenario file ", _tmp41_, " doesn't exist. Ignoring.", NULL);
			_tmp43_ = _tmp42_;
			fso_framework_logger_warning (_tmp37_, _tmp43_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp40_);
		} else {
			const gchar* _tmp44_;
			GFile* _tmp45_;
			guint _tmp46_;
			guint _tmp47_;
			FsoAudioSoundDevice* _tmp48_;
			GeeHashMap* _tmp49_;
			const gchar* _tmp50_;
			gpointer _tmp51_ = NULL;
			FsoAudioBunchOfMixerControls* _tmp52_;
			FsoAudioMixerControl** _tmp53_;
			gint _tmp53__length1;
			_tmp44_ = name;
			_tmp45_ = file;
			_tmp46_ = idxSpeakerVolume;
			_tmp47_ = idxMicVolume;
			router_lib_alsa_addScenario (self, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
			_tmp48_ = self->priv->device;
			_tmp49_ = self->priv->allscenarios;
			_tmp50_ = name;
			_tmp51_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp49_, _tmp50_);
			_tmp52_ = (FsoAudioBunchOfMixerControls*) _tmp51_;
			_tmp53_ = _tmp52_->controls;
			_tmp53__length1 = _tmp52_->controls_length1;
			fso_audio_sound_device_setAllMixerControls (_tmp48_, _tmp53_, _tmp53__length1, &_inner_error_);
			_fso_audio_bunch_of_mixer_controls_unref0 (_tmp52_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	} else {
		FsoFrameworkLogger* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_;
		FsoAudioSoundDevice* _tmp59_;
		gint _tmp60_ = 0;
		FsoAudioMixerControl** _tmp61_ = NULL;
		FsoAudioMixerControl** _tmp62_;
		gint _tmp62__length1;
		gint __tmp62__size_;
		FsoAudioMixerControl** _tmp63_;
		gint _tmp63__length1;
		FsoAudioBunchOfMixerControls* _tmp64_;
		FsoAudioBunchOfMixerControls* _tmp65_;
		FsoAudioBunchOfMixerControls* scene;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
		GFile* _tmp70_ = NULL;
		GFile* _tmp71_;
		GFile* file;
		GFile* _tmp72_;
		gboolean _tmp73_ = FALSE;
		FsoAudioSoundDevice* _tmp85_;
		FsoAudioBunchOfMixerControls* _tmp86_;
		FsoAudioMixerControl** _tmp87_;
		gint _tmp87__length1;
		_tmp54_ = fso_framework_theLogger;
		_tmp55_ = name;
		_tmp56_ = string_to_string (_tmp55_);
		_tmp57_ = g_strconcat ("Scenario ", _tmp56_, " has been changed; invalidating cache for this.", NULL);
		_tmp58_ = _tmp57_;
		fso_framework_logger_info (_tmp54_, _tmp58_);
		_g_free0 (_tmp58_);
		_tmp59_ = self->priv->device;
		_tmp61_ = fso_audio_sound_device_allMixerControls (_tmp59_, &_tmp60_, &_inner_error_);
		_tmp62_ = _tmp61_;
		_tmp62__length1 = _tmp60_;
		__tmp62__size_ = _tmp62__length1;
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp63_ = _tmp62_;
		_tmp63__length1 = _tmp62__length1;
		_tmp64_ = fso_audio_bunch_of_mixer_controls_new (_tmp63_, _tmp62__length1, (guint) 0, (guint) 0);
		_tmp65_ = _tmp64_;
		_tmp63_ = (_vala_array_free (_tmp63_, _tmp63__length1, (GDestroyNotify) fso_audio_mixer_control_unref), NULL);
		scene = _tmp65_;
		_tmp66_ = self->priv->dataPath;
		_tmp67_ = name;
		_tmp68_ = g_build_filename (_tmp66_, _tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_file_new_for_path (_tmp69_);
		_tmp71_ = _tmp70_;
		_g_free0 (_tmp69_);
		file = _tmp71_;
		_tmp72_ = file;
		_tmp73_ = g_file_query_exists (_tmp72_, NULL);
		if (!_tmp73_) {
			FsoFrameworkLogger* _tmp74_;
			GFile* _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			const gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_;
			_tmp74_ = fso_framework_theLogger;
			_tmp75_ = file;
			_tmp76_ = g_file_get_path (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = string_to_string (_tmp77_);
			_tmp79_ = g_strconcat ("Scenario file ", _tmp78_, " doesn't exist. Ignoring.", NULL);
			_tmp80_ = _tmp79_;
			fso_framework_logger_warning (_tmp74_, _tmp80_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp77_);
		} else {
			const gchar* _tmp81_;
			GFile* _tmp82_;
			guint _tmp83_;
			guint _tmp84_;
			_tmp81_ = name;
			_tmp82_ = file;
			_tmp83_ = idxSpeakerVolume;
			_tmp84_ = idxMicVolume;
			router_lib_alsa_addScenario (self, _tmp81_, _tmp82_, _tmp83_, _tmp84_);
		}
		_tmp85_ = self->priv->device;
		_tmp86_ = scene;
		_tmp87_ = _tmp86_->controls;
		_tmp87__length1 = _tmp86_->controls_length1;
		fso_audio_sound_device_setAllMixerControls (_tmp85_, _tmp87_, _tmp87__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_fso_audio_bunch_of_mixer_controls_unref0 (scene);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (file);
		_fso_audio_bunch_of_mixer_controls_unref0 (scene);
	}
}


static gchar* router_lib_alsa_retrieveScenarioForDevice (RouterLibAlsa* self, FreeSmartphoneAudioDevice device) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* scenario;
	FreeSmartphoneAudioMode _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("unknown");
	scenario = _tmp0_;
	_tmp1_ = ((FsoAudioAbstractRouter*) self)->current_mode;
	if (_tmp1_ == FREE_SMARTPHONE_AUDIO_MODE_NORMAL) {
		GeeHashMap* _tmp2_;
		FreeSmartphoneAudioDevice _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->callDeviceScenarios;
		_tmp3_ = device;
		_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, GINT_TO_POINTER (_tmp3_));
		if (_tmp4_) {
			GeeHashMap* _tmp5_;
			FreeSmartphoneAudioDevice _tmp6_;
			gpointer _tmp7_ = NULL;
			_tmp5_ = self->priv->normalDeviceScenarios;
			_tmp6_ = device;
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, GINT_TO_POINTER (_tmp6_));
			_g_free0 (scenario);
			scenario = (gchar*) _tmp7_;
		}
	} else {
		FreeSmartphoneAudioMode _tmp8_;
		_tmp8_ = ((FsoAudioAbstractRouter*) self)->current_mode;
		if (_tmp8_ == FREE_SMARTPHONE_AUDIO_MODE_CALL) {
			GeeHashMap* _tmp9_;
			FreeSmartphoneAudioDevice _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp9_ = self->priv->callDeviceScenarios;
			_tmp10_ = device;
			_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, GINT_TO_POINTER (_tmp10_));
			if (_tmp11_) {
				GeeHashMap* _tmp12_;
				FreeSmartphoneAudioDevice _tmp13_;
				gpointer _tmp14_ = NULL;
				_tmp12_ = self->priv->callDeviceScenarios;
				_tmp13_ = device;
				_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, GINT_TO_POINTER (_tmp13_));
				_g_free0 (scenario);
				scenario = (gchar*) _tmp14_;
			}
		}
	}
	result = scenario;
	return result;
}


static gboolean router_lib_alsa_setScenarioForDevice (RouterLibAlsa* self, FreeSmartphoneAudioDevice device) {
	gboolean result = FALSE;
	gboolean _result_;
	FreeSmartphoneAudioDevice _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* scenario;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = device;
	_tmp1_ = router_lib_alsa_retrieveScenarioForDevice (self, _tmp0_);
	scenario = _tmp1_;
	_tmp2_ = scenario;
	if (g_strcmp0 (_tmp2_, "unknown") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = scenario;
		router_lib_alsa_updateScenarioIfChanged (self, _tmp3_);
		_result_ = TRUE;
	}
	result = _result_;
	_g_free0 (scenario);
	return result;
}


static gchar* router_lib_alsa_real_repr (FsoFrameworkAbstractObject* base) {
	RouterLibAlsa * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


static void router_lib_alsa_real_set_mode (FsoAudioAbstractRouter* base, FreeSmartphoneAudioMode mode, gboolean force) {
	RouterLibAlsa * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	FreeSmartphoneAudioMode _tmp5_;
	FreeSmartphoneAudioMode previous_mode;
	FreeSmartphoneAudioMode _tmp6_;
	FreeSmartphoneAudioDevice _tmp7_;
	gboolean _tmp8_ = FALSE;
	self = (RouterLibAlsa*) base;
	_tmp1_ = force;
	if (!_tmp1_) {
		FreeSmartphoneAudioMode _tmp2_;
		FreeSmartphoneAudioMode _tmp3_;
		_tmp2_ = mode;
		_tmp3_ = ((FsoAudioAbstractRouter*) self)->current_mode;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = ((FsoAudioAbstractRouter*) self)->current_mode;
	previous_mode = _tmp5_;
	_tmp6_ = mode;
	FSO_AUDIO_ABSTRACT_ROUTER_CLASS (router_lib_alsa_parent_class)->set_mode (FSO_AUDIO_ABSTRACT_ROUTER (self), _tmp6_, FALSE);
	_tmp7_ = ((FsoAudioAbstractRouter*) self)->current_device;
	_tmp8_ = router_lib_alsa_setScenarioForDevice (self, _tmp7_);
	if (!_tmp8_) {
		FsoFrameworkLogger* _tmp9_;
		FreeSmartphoneAudioMode _tmp10_;
		GEnumValue* _tmp11_;
		FreeSmartphoneAudioMode _tmp12_;
		GEnumValue* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		FreeSmartphoneAudioMode _tmp16_;
		_tmp9_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp10_ = mode;
		_tmp11_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_MODE), _tmp10_);
		_tmp12_ = previous_mode;
		_tmp13_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_AUDIO_TYPE_MODE), _tmp12_);
		_tmp14_ = g_strconcat ("Could not switch to new mode ", (_tmp11_ != NULL) ? _tmp11_->value_name : NULL, "; switching back to old mode ", (_tmp13_ != NULL) ? _tmp13_->value_name : NULL, " ...", NULL);
		_tmp15_ = _tmp14_;
		fso_framework_logger_error (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = previous_mode;
		fso_audio_abstract_router_set_mode ((FsoAudioAbstractRouter*) self, _tmp16_, FALSE);
	}
}


static void router_lib_alsa_real_set_device (FsoAudioAbstractRouter* base, FreeSmartphoneAudioDevice device, gboolean expose) {
	RouterLibAlsa * self;
	FreeSmartphoneAudioDevice _tmp0_;
	FreeSmartphoneAudioDevice _tmp1_;
	FreeSmartphoneAudioDevice _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	FreeSmartphoneAudioDevice _tmp5_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = device;
	_tmp1_ = ((FsoAudioAbstractRouter*) self)->current_device;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = device;
	_tmp3_ = expose;
	FSO_AUDIO_ABSTRACT_ROUTER_CLASS (router_lib_alsa_parent_class)->set_device (FSO_AUDIO_ABSTRACT_ROUTER (self), _tmp2_, _tmp3_);
	_tmp4_ = expose;
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = device;
	router_lib_alsa_setScenarioForDevice (self, _tmp5_);
}


static void router_lib_alsa_real_set_volume (FsoAudioAbstractRouter* base, FreeSmartphoneAudioControl control, guint volume) {
	RouterLibAlsa * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FsoAudioBunchOfMixerControls* scenario;
	FsoAudioBunchOfMixerControls* _tmp3_;
	guint _tmp4_ = 0U;
	FreeSmartphoneAudioControl _tmp5_;
	guint _tmp10_;
	guint idx;
	FsoAudioSoundDevice* _tmp11_;
	guint _tmp12_;
	self = (RouterLibAlsa*) base;
	_tmp0_ = self->priv->allscenarios;
	_tmp1_ = self->priv->currentscenario;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	scenario = (FsoAudioBunchOfMixerControls*) _tmp2_;
	_tmp3_ = scenario;
	g_assert (_tmp3_ != NULL);
	_tmp5_ = control;
	if (_tmp5_ == FREE_SMARTPHONE_AUDIO_CONTROL_SPEAKER) {
		FsoAudioBunchOfMixerControls* _tmp6_;
		guint _tmp7_;
		_tmp6_ = scenario;
		_tmp7_ = _tmp6_->idxSpeakerVolume;
		_tmp4_ = _tmp7_;
	} else {
		FsoAudioBunchOfMixerControls* _tmp8_;
		guint _tmp9_;
		_tmp8_ = scenario;
		_tmp9_ = _tmp8_->idxMicVolume;
		_tmp4_ = _tmp9_;
	}
	_tmp10_ = _tmp4_;
	idx = _tmp10_;
	_tmp11_ = self->priv->device;
	_tmp12_ = volume;
	fso_audio_sound_device_setVolumeForIndex (_tmp11_, idx, (guint8) _tmp12_);
	_fso_audio_bunch_of_mixer_controls_unref0 (scenario);
}


RouterLibAlsa* router_lib_alsa_construct (GType object_type) {
	RouterLibAlsa * self = NULL;
	self = (RouterLibAlsa*) fso_audio_abstract_router_construct (object_type);
	return self;
}


RouterLibAlsa* router_lib_alsa_new (void) {
	return router_lib_alsa_construct (ROUTER_TYPE_LIB_ALSA);
}


static GObject * router_lib_alsa_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RouterLibAlsa * self;
	FsoFrameworkLogger* _tmp0_;
	parent_class = G_OBJECT_CLASS (router_lib_alsa_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ROUTER_LIB_ALSA (obj);
	router_lib_alsa_initScenarios (self);
	_tmp0_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp0_, "Created and configured.");
	return obj;
}


static void router_lib_alsa_class_init (RouterLibAlsaClass * klass) {
	router_lib_alsa_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RouterLibAlsaPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = router_lib_alsa_real_repr;
	FSO_AUDIO_ABSTRACT_ROUTER_CLASS (klass)->set_mode = router_lib_alsa_real_set_mode;
	FSO_AUDIO_ABSTRACT_ROUTER_CLASS (klass)->set_device = router_lib_alsa_real_set_device;
	FSO_AUDIO_ABSTRACT_ROUTER_CLASS (klass)->set_volume = router_lib_alsa_real_set_volume;
	G_OBJECT_CLASS (klass)->constructor = router_lib_alsa_constructor;
	G_OBJECT_CLASS (klass)->finalize = router_lib_alsa_finalize;
}


static void router_lib_alsa_instance_init (RouterLibAlsa * self) {
	self->priv = ROUTER_LIB_ALSA_GET_PRIVATE (self);
}


static void router_lib_alsa_finalize (GObject* obj) {
	RouterLibAlsa * self;
	self = ROUTER_LIB_ALSA (obj);
	_g_object_unref0 (self->priv->device);
	_g_object_unref0 (self->priv->allscenarios);
	_g_object_unref0 (self->priv->normalDeviceScenarios);
	_g_object_unref0 (self->priv->callDeviceScenarios);
	_g_free0 (self->priv->configurationPath);
	_g_free0 (self->priv->dataPath);
	_g_free0 (self->priv->currentscenario);
	G_OBJECT_CLASS (router_lib_alsa_parent_class)->finalize (obj);
}


GType router_lib_alsa_get_type (void) {
	return router_lib_alsa_type_id;
}


GType router_lib_alsa_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RouterLibAlsaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) router_lib_alsa_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RouterLibAlsa), 0, (GInstanceInitFunc) router_lib_alsa_instance_init, NULL };
	router_lib_alsa_type_id = g_type_module_register_type (module, FSO_AUDIO_TYPE_ABSTRACT_ROUTER, "RouterLibAlsa", &g_define_type_info, 0);
	return router_lib_alsa_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = g_strdup (FSO_AUDIO_ROUTER_ALSA_MODULE_NAME);
	result = _tmp0_;
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	router_lib_alsa_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsoaudio.router_alsa fso_register_function");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



