# Generated by hand against hledger --help as of version 1.14.2.

# TODO: Handle the -NUM form of --depth=NUM.

set -l debug_opts '
    1\tdefault
    2\t
    3\t
    4\t
    5\t
    6\t
    7\t
    8\t
    9\t
'

set -l takes_general_input_flags 'add commodities files'
set -l takes_general_reporting_flags 'import check-dates check-dupes close equity rewrite balancesheet bs balancesheetequity bse cashflow cf incomestatement is roi accounts a activity balance bal b prices print txns p print-unique register reg r register-match stats tags'

# General input flags
complete -c hledger -r -s f -l file -d 'Input file' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -r -l rules-file -d 'CSV-conversion-rules file' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -x -l separator -d 'CSV separator' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -r -l alias -d 'Rename account' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -f -l anon -d 'Anonymize accounts and payees' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -x -l pivot -d 'Use some other field/tag for account names' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"
complete -c hledger -x -s I -l ignore-assertions -d 'Ignore any balance assertions' -n "__fish_seen_subcommand_from $takes_general_input_flags $takes_general_reporting_flags"

# General reporting flags
complete -c hledger -x -s b -l begin -d 'Include postings/txns on or after this date' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -x -s e -l end -d 'Include postings/txns before this date' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s D -l daily -d 'Multiperiod/multicolumn report by day' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s W -l weekly -d 'Multiperiod/multicolumn report by week' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s M -l monthly -d 'Multiperiod/multicolumn report by month' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s Q -l quarterly -d 'Multiperiod/multicolumn report by quarter' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s Y -l yearly -d 'Multiperiod/multicolumn report by year' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -x -s p -l period -d 'Set start date, end date, and report interval' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -l date2 -d 'Match secondary date instead' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s U -l unmarked -d 'Include only unmarked postings/txns' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s P -l pending -d 'Include only pending (“!”) postings/txns' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s C -l cleared -d 'Include only cleared (“*”) postings/txns' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s R -l real -d 'Include only non-virtual postings' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -x -l depth -d 'Hide accounts/postings deeper than this' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s E -l empty -d 'Show items with zero amount' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s B -l cost -d 'Converts amounts to their cost at txn time' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -s V -l value -d 'Converts amounts to their market value on report end date' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -l auto -d 'Apply automated posting rules to modify txns' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"
complete -c hledger -f -l forecast -d 'Apply periodic txn rules to generate future txns' -n "__fish_seen_subcommand_from $takes_general_reporting_flags"

# General help flags
complete -c hledger -x -s h -l help -d 'Show help for this command'
complete -c hledger -x -l debug -a "$debug_opts" -d 'Show debug output'
complete -c hledger -x -l version -d 'Show version information'

# Commands

# Data entry
complete -c hledger -f -n '__fish_use_subcommand' -a add -d 'Add transactions using guided prompts'
complete -c hledger -f -n '__fish_seen_subcommand_from add' -l no-new-accounts -d 'Don’t allow creating new accounts'

complete -c hledger -n '__fish_use_subcommand' -a import -d 'Add new transactions from other files'
complete -c hledger -f -n '__fish_seen_subcommand_from import' -l dry-run -d 'Just show the transactions to be imported'

# Data management
complete -c hledger -f -n '__fish_use_subcommand' -a check-dates -d 'Ensure transactions are ordered by date'
complete -c hledger -f -n '__fish_seen_subcommand_from check-dates' -l strict -d 'Makes date comparing strict'

complete -c hledger -f -n '__fish_use_subcommand' -a check-dupes -d 'Ensure accounts have different leaf names'

complete -c hledger -f -n '__fish_use_subcommand' -a 'close equity' -d 'Generate balance-resetting transactions'
complete -c hledger -f -n '__fish_seen_subcommand_from close' -l opening -d 'Show just opening transaction'
complete -c hledger -f -n '__fish_seen_subcommand_from close' -l closing -d 'Show just closing transaction'

complete -c hledger -f -n '__fish_use_subcommand' -a rewrite -d 'Generate automated postings/diffs'
complete -c hledger -f -n '__fish_seen_subcommand_from rewrite' -l add-posting -d 'Add a posting to account'
complete -c hledger -f -n '__fish_seen_subcommand_from rewrite' -l diff -d 'Generate diff suitable for patch(1)'

# Financial reports
set -l financial_reports_commands 'balancesheet bs balancesheetequity bse cashflow cf incomestatement is' # these four (but not roi!) use the same commands
complete -c hledger -f -n '__fish_use_subcommand' -a 'balancesheet       bs' -d 'Show assets, liabilities, and net worth'
complete -c hledger -f -n '__fish_use_subcommand' -a 'balancesheetequity bse' -d 'Show assets, liabilities, and equity'
complete -c hledger -f -n '__fish_use_subcommand' -a 'cashflow           cf' -d 'Show changes in liquid assets'
complete -c hledger -f -n '__fish_use_subcommand' -a 'incomestatement    is' -d 'Show revenues and expenses'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l change -d 'Show balance change in each period'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l cumulative -d 'Show balance change accumulated across periods'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s H -l historical -d 'Show historical ending balance in each period'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l flat -d 'Show accounts as a list'
complete -c hledger -x -n "__fish_seen_subcommand_from $financial_reports_commands" -l drop -d 'Omit N leading account-name parts (in flat mode)'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s N -l no-total -d 'Omit the final total row'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l tree -d 'Show accounts as a tree; amounts include subaccounts'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s A -l average -d 'Show a row average column in multicolumn reports'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s T -l row-total -d 'Show a row total column in multicolumn reports'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l no-elide -d 'Don’t squash boring parent accounts in tree mode'
complete -c hledger -x -n "__fish_seen_subcommand_from $financial_reports_commands" -l format -d 'Use a custom line format in multicolumn reports'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -l pretty-tables -d 'Use Unicode when displaying tables'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s S -l sort-amount -d 'Sort by amount instead of account code/name'
complete -c hledger -f -n "__fish_seen_subcommand_from $financial_reports_commands" -s O -l output-format -a 'txt csv html' -d 'Select an output format'
complete -c hledger -r -n "__fish_seen_subcommand_from $financial_reports_commands" -s o -l output-file -d 'Write output to given file; extension selects format'

complete -c hledger -f -n '__fish_use_subcommand' -a roi -d 'Show return on investments'
complete -c hledger -f -n '__fish_seen_subcommand_from roi' -l cashflow -d 'Show all amounts that were used to compute returns'
complete -c hledger -x -n '__fish_seen_subcommand_from roi' -l investment -d 'Query to select investment transactions'
complete -c hledger -x -n '__fish_seen_subcommand_from roi' -l profit-loss -l pnl -d 'Query to select profit-and-loss or appreciation/valuation transactions'

# Low-level reports
complete -c hledger -f -n '__fish_use_subcommand' -a accounts -d 'Show account names'
complete -c hledger -f -n '__fish_seen_subcommand_from accounts' -l declared -d 'Show account names declared with account directives'
complete -c hledger -f -n '__fish_seen_subcommand_from accounts' -l used -d 'Show account names referenced by transactions'
complete -c hledger -f -n '__fish_seen_subcommand_from accounts' -l tree -d 'Show short account names as a tree'
complete -c hledger -f -n '__fish_seen_subcommand_from accounts' -l flat -d 'Show short account names as a list'
complete -c hledger -x -n '__fish_seen_subcommand_from accounts' -l drop -d 'Omit N leading account name parts in flat mode'

complete -c hledger -f -n '__fish_use_subcommand' -a activity -d 'Show postings-per-interval bar charts'

complete -c hledger -f -n '__fish_use_subcommand' -a balance -d 'Show balance changes/end balances/budgets in accounts'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l change -d 'Show balance change in each period'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l cumulative -d 'Show balance change accumulated across periods'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -s H -l historical -d 'Show historical ending balance in each period'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l tree -d 'Show accounts as a tree'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l flat -d 'Show accounts as a list'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -s A -l average -d 'Show a row average column in multicolumn reports'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -s T -l row-total -d 'Show a row total column in multicolumn reports'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -s N -l no-total -d 'Omit the final row'
complete -c hledger -x -n '__fish_seen_subcommand_from balance' -l drop -d 'Omit N leading account name parts in flat mode'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l no-elide -d 'Don’t squash boring parent accounts in tree mode'
complete -c hledger -x -n '__fish_seen_subcommand_from balance' -l format -d 'Use a custom line format in multicolumn reports'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l pretty-tables -d 'Use Unicode when displaying tables'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -s S -l sort-amount -d 'Sort by amount instead of account code/name'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l budget -d 'Show performance compared to budget goals defined by periodic transactions'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l invert -d 'Display all amounts with reversed sign'
complete -c hledger -f -n '__fish_seen_subcommand_from balance' -l transpose -d 'Transpose rows and columns'
complete -c hledger -x -n '__fish_seen_subcommand_from balance' -s O -l output-format -a 'txt csv html' -d 'Select an output format'
complete -c hledger -r -n '__fish_seen_subcommand_from balance' -s o -l output-file -d 'Write output to given file; extension selects format'

complete -c hledger -f -n '__fish_use_subcommand' -a commodities -d 'Show commodity/currency symbols'

complete -c hledger -f -n '__fish_use_subcommand' -a files -d 'Show input file paths'

complete -c hledger -f -n '__fish_use_subcommand' -a prices -d 'Show market-price records'
complete -c hledger -f -n '__fish_seen_subcommand_from prices' -l costs -d 'Print transaction prices from postings'
complete -c hledger -f -n '__fish_seen_subcommand_from prices' -l inverted-costs -d 'Print transaction inverted prices from postings also'

complete -c hledger -f -n '__fish_use_subcommand' -a 'print txns' -d 'Show transactions'
complete -c hledger -f -n '__fish_use_subcommand' -a 'print-unique' -d 'Show only transactions with unique descriptions'
complete -c hledger -x -n '__fish_seen_subcommand_from print txns print-unique' -s m -l match -d 'Show the most-recent transaction most similar to STR'
complete -c hledger -f -n '__fish_seen_subcommand_from print txns print-unique' -s x -l explicit -d 'Show all amounts explicitly'
complete -c hledger -f -n '__fish_seen_subcommand_from print txns print-unique' -l new -d 'Show only newer-dated transactions added in each file since last run'
complete -c hledger -x -n '__fish_seen_subcommand_from print txns print-unique' -s O -l output-format -a 'txt csv html' -d 'Select an output format'
complete -c hledger -r -n '__fish_seen_subcommand_from print txns print-unique' -s o -l output-file -d 'Write output to given file; extension selects format'

complete -c hledger -f -n '__fish_use_subcommand' -a register -d 'Show postings in one or more accounts & running total'
complete -c hledger -f -n '__fish_seen_subcommand_from register' -l cumulative -d 'Show running total from report start date'
complete -c hledger -f -n '__fish_seen_subcommand_from register' -s H -l historical -d 'Show historical running total/balance'
complete -c hledger -f -n '__fish_seen_subcommand_from register' -s A -l average -d 'Show running average of posting amounts instead of total (implies --empty)'
complete -c hledger -f -n '__fish_seen_subcommand_from register' -s r -l related -d 'Show postings’ siblings instead'
complete -c hledger -f -n '__fish_seen_subcommand_from register' -l invert -d 'Display all amounts with reversed sign'
complete -c hledger -x -n '__fish_seen_subcommand_from register' -s w -l width -d 'Set output width (defaults to terminal width or $COLUMNS)'
complete -c hledger -x -n '__fish_seen_subcommand_from register' -s O -l output-format -a 'txt csv html' -d 'Select an output format'
complete -c hledger -r -n '__fish_seen_subcommand_from register' -s o -l output-file -d 'Write output to given file; extension selects format'

complete -c hledger -f -n '__fish_use_subcommand' -a register-match -d 'Show a recent posting that best matches a description'

complete -c hledger -f -n '__fish_use_subcommand' -a stats -d 'Show journal statistics'
complete -c hledger -r -n '__fish_seen_subcommand_from stats' -s o -l output-file -d 'Write output to given file; extension selects format'

complete -c hledger -f -n '__fish_use_subcommand' -a tags -d 'Show tag names'

complete -c hledger -f -n '__fish_use_subcommand' -a test -d 'Run self-tests'

# Help
complete -c hledger -f -n '__fish_use_subcommand' -a help -d 'Show hledger manual list'
