/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.EloRating;
import friendless.games.filler.FillerPanel;
import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.TournamentResultsPanel;
import friendless.games.filler.TournamentRules;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;

public class Tournaments {
    private static final String SEP = System.getProperty("line.separator");
    static Random rng = new Random();
    private static boolean cancelled;
    private static ResourceBundle resources;

    static void setResources(ResourceBundle resourceBundle) {
        resources = resourceBundle;
    }

    static void cancel() {
        cancelled = true;
    }

    static void tournament(TournamentRules tournamentRules, FillerPanel fillerPanel, PlayerWrappers playerWrappers) {
        cancelled = false;
        boolean bl = true;
        TournamentResultsPanel.getInstance(resources).newTournament(tournamentRules, playerWrappers);
        while (tournamentRules.isContinuous() || bl) {
            bl = false;
            switch (tournamentRules.rules) {
                case 0: {
                    Tournaments.roundRobin(fillerPanel, playerWrappers);
                    break;
                }
                case 2: {
                    Tournaments.basho(tournamentRules.bashoRounds, fillerPanel, playerWrappers);
                    break;
                }
                case 1: {
                    Tournaments.knockout(fillerPanel, playerWrappers);
                    break;
                }
                case 3: {
                    Tournaments.challenge(fillerPanel, playerWrappers);
                    break;
                }
            }
            if (cancelled) break;
        }
    }

    static void challenge(FillerPanel fillerPanel, PlayerWrappers playerWrappers) {
        int n = 0;
        while (n < playerWrappers.size()) {
            if (cancelled) break;
            PlayerWrapper playerWrapper = playerWrappers.get(n);
            if (!playerWrapper.getInstance().requiresButtons()) {
                PlayerWrapper playerWrapper2 = Tournaments.getBestOpponent(playerWrapper, playerWrappers);
                fillerPanel.tournamentMatch(new PlayerWrapper[]{playerWrapper, playerWrapper2});
            }
            ++n;
        }
    }

    static PlayerWrapper getBestOpponent(PlayerWrapper playerWrapper, PlayerWrappers playerWrappers) {
        Object object;
        Object object2;
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        Object object3 = null;
        int n3 = 0;
        while (n3 < playerWrappers.size()) {
            object2 = playerWrappers.get(n3);
            if (object2 != playerWrapper) {
                int[] nArray;
                int[] nArray2;
                int n4;
                int n5;
                object = playerWrapper.getRecordAgainst((PlayerWrapper)object2);
                int n6 = object[0] + object[1];
                if (n6 < 10) {
                    object[0] = object[0] + (10 - n6) / 2;
                    object[1] = object[1] + (10 - n6) / 2;
                }
                if ((n5 = (n4 = 100 * object[0] / (object[0] + object[1])) * ((nArray2 = EloRating.expectedWinnings(nArray = new int[]{playerWrapper.getRating(), ((PlayerWrapper)object2).getRating()}))[0] - nArray2[1])) > n) {
                    n = n5;
                    object3 = object2;
                    n2 = nArray2[0];
                } else if (n5 == n && ((PlayerWrapper)object3).getRating() > ((PlayerWrapper)object2).getRating()) {
                    object3 = object2;
                    n2 = nArray2[0];
                }
            }
            ++n3;
        }
        object2 = resources.getString("filler.string.challenges");
        object = MessageFormat.format((String)object2, playerWrapper.getName(), ((PlayerWrapper)object3).getName(), new Integer(n2));
        TournamentResultsPanel.getInstance(resources).addText((String)object + SEP);
        return object3;
    }

    static void knockout(FillerPanel fillerPanel, PlayerWrappers playerWrappers) {
        Object object;
        playerWrappers.sortByRandom();
        int n = playerWrappers.size();
        int n2 = n + n % 2;
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = n3 < n ? n3 : -1;
            ++n3;
        }
        while (nArray.length > 1) {
            int n4 = nArray.length + nArray.length % 2;
            object = new int[n4 / 2][2];
            int n5 = 0;
            while (n5 < n4) {
                object[n5 / 2][n5 % 2] = n5 < nArray.length ? nArray[n5] : -1;
                ++n5;
            }
            nArray = Tournaments.playTournamentMatches(object, fillerPanel, playerWrappers, false);
            if (nArray.length % 2 == 1) {
                int n6 = nArray[nArray.length - 1];
                int n7 = nArray.length - 1;
                while (n7 > 0) {
                    nArray[n7] = nArray[n7 - 1];
                    --n7;
                }
                nArray[0] = n6;
            }
            TournamentResultsPanel.getInstance(resources).addText(resources.getString("filler.string.endofround") + SEP);
        }
        String string = resources.getString("filler.string.knockoutwinner");
        object = MessageFormat.format(string, playerWrappers.get(nArray[0]));
        fillerPanel.showMessage((String)object, "");
        TournamentResultsPanel.getInstance(resources).addText((String)object + SEP);
    }

    static PlayerWrappers checkEvenNumberOfPlayers(PlayerWrappers playerWrappers) {
        if (playerWrappers.size() % 2 == 1) {
            playerWrappers.sortByRatings();
            PlayerWrapper playerWrapper = playerWrappers.get(playerWrappers.size() - 1);
            TournamentResultsPanel.getInstance(resources).addText(playerWrapper + " can not participate in the basho." + SEP);
            int n = 0;
            while (n < playerWrappers.size()) {
                PlayerWrapper playerWrapper2 = playerWrappers.get(n);
                playerWrappers.setSelection(playerWrappers.get(n), playerWrapper2 != playerWrapper);
                ++n;
            }
            return playerWrappers.getSelected();
        }
        return playerWrappers;
    }

    private static void swap(Object[] objectArray, int[] nArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    static void sortByRatings(PlayerWrapper[] playerWrapperArray, int[] nArray) {
        int n = 0;
        while (n < playerWrapperArray.length - 1) {
            int n2 = n + 1;
            while (n2 < playerWrapperArray.length) {
                int n3;
                int n4 = playerWrapperArray[n].getRating();
                if (n4 < (n3 = playerWrapperArray[n2].getRating())) {
                    Tournaments.swap(playerWrapperArray, nArray, n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    static void sortByWins(PlayerWrapper[] playerWrapperArray, int[] nArray) {
        int n = 0;
        while (n < playerWrapperArray.length - 1) {
            int n2 = n + 1;
            while (n2 < playerWrapperArray.length) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                if (n3 < n4) {
                    Tournaments.swap(playerWrapperArray, nArray, n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    private static boolean hasPlayed(PlayerWrapper playerWrapper, PlayerWrapper playerWrapper2, boolean[][] blArray, Map map) {
        int n = (Integer)map.get(playerWrapper);
        int n2 = (Integer)map.get(playerWrapper2);
        return blArray[n][n2];
    }

    private static void setPlayed(PlayerWrapper playerWrapper, PlayerWrapper playerWrapper2, boolean[][] blArray, Map map, boolean bl) {
        int n = (Integer)map.get(playerWrapper);
        int n2 = (Integer)map.get(playerWrapper2);
        blArray[n][n2] = bl;
    }

    private static int minIndex(PlayerWrapper[] playerWrapperArray, boolean[] blArray) {
        int n = 0;
        while (n < playerWrapperArray.length) {
            if (!blArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static List allocateBasho(PlayerWrapper[] playerWrapperArray, boolean[][] blArray, Map map, List list, boolean[] blArray2) {
        if (list.size() * 2 == playerWrapperArray.length) {
            return list;
        }
        int n = Tournaments.minIndex(playerWrapperArray, blArray2);
        blArray2[n] = true;
        PlayerWrapper playerWrapper = playerWrapperArray[n];
        int n2 = n + 1;
        while (n2 < playerWrapperArray.length) {
            PlayerWrapper playerWrapper2;
            if (!blArray2[n2] && !Tournaments.hasPlayed(playerWrapper, playerWrapper2 = playerWrapperArray[n2], blArray, map)) {
                blArray2[n2] = true;
                Tournaments.setPlayed(playerWrapper, playerWrapper2, blArray, map, true);
                PlayerWrapper[] playerWrapperArray2 = new PlayerWrapper[]{playerWrapper, playerWrapper2};
                list.add(playerWrapperArray2);
                List list2 = Tournaments.allocateBasho(playerWrapperArray, blArray, map, list, blArray2);
                if (list2 != null) {
                    return list2;
                }
                list.remove(playerWrapperArray2);
                blArray2[n2] = false;
                Tournaments.setPlayed(playerWrapper, playerWrapper2, blArray, map, false);
            }
            ++n2;
        }
        blArray2[n] = false;
        return null;
    }

    static List allocateBasho(PlayerWrapper[] playerWrapperArray, boolean[][] blArray, Map map) {
        ArrayList arrayList = new ArrayList();
        boolean[] blArray2 = new boolean[playerWrapperArray.length];
        return Tournaments.allocateBasho(playerWrapperArray, blArray, map, arrayList, blArray2);
    }

    static void basho(int n, FillerPanel fillerPanel, PlayerWrappers playerWrappers) {
        Object object;
        Object object2;
        if ((playerWrappers = Tournaments.checkEvenNumberOfPlayers(playerWrappers)).size() == 0) {
            TournamentResultsPanel.getInstance(resources).addText("There are no players to participate in the basho." + SEP);
            return;
        }
        boolean[][] blArray = new boolean[playerWrappers.size()][playerWrappers.size()];
        HashMap<PlayerWrapper, Integer> hashMap = new HashMap<PlayerWrapper, Integer>(playerWrappers.size());
        int n2 = 0;
        while (n2 < playerWrappers.size()) {
            hashMap.put(playerWrappers.get(n2), new Integer(n2));
            ++n2;
        }
        int n3 = n / 2;
        int n4 = n - n3;
        PlayerWrapper[] playerWrapperArray = playerWrappers.toArray();
        int[] nArray = new int[playerWrappers.size()];
        int n5 = 0;
        while (n5 < n3) {
            if (cancelled) break;
            Tournaments.sortByRatings(playerWrapperArray, nArray);
            List list = Tournaments.allocateBasho(playerWrapperArray, blArray, hashMap);
            Tournaments.playBashoMatches(fillerPanel, list, playerWrapperArray, nArray);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            if (cancelled) break;
            Tournaments.sortByWins(playerWrapperArray, nArray);
            object2 = resources.getString("filler.string.basholeader");
            object2 = MessageFormat.format((String)object2, playerWrapperArray[0].getName(), new Integer(nArray[0]));
            TournamentResultsPanel.getInstance(resources).addText((String)object2 + SEP);
            object = Tournaments.allocateBasho(playerWrapperArray, blArray, hashMap);
            Tournaments.playBashoMatches(fillerPanel, (List)object, playerWrapperArray, nArray);
            ++n6;
        }
        object2 = null;
        while (!cancelled) {
            Tournaments.sortByWins(playerWrapperArray, nArray);
            if (nArray[0] > nArray[1]) {
                object2 = playerWrappers.get(0);
                break;
            }
            Tournaments.tieBreaker(fillerPanel, playerWrapperArray, nArray);
        }
        if (object2 != null) {
            object = resources.getString("filler.string.bashowinner");
            object = MessageFormat.format((String)object, ((PlayerWrapper)object2).getName());
            fillerPanel.showMessage((String)object, "");
            TournamentResultsPanel.getInstance(resources).addText((String)object + SEP);
        }
    }

    private static void playBashoMatches(FillerPanel fillerPanel, List list, PlayerWrapper[] playerWrapperArray, int[] nArray) {
        int n = 0;
        while (n < list.size()) {
            if (cancelled) break;
            PlayerWrapper[] playerWrapperArray2 = (PlayerWrapper[])list.get(n);
            int[] nArray2 = fillerPanel.tournamentMatch(playerWrapperArray2);
            int n2 = nArray2[0] > nArray2[1] ? 0 : 1;
            int n3 = 0;
            while (n3 < playerWrapperArray.length) {
                if (playerWrapperArray[n3] == playerWrapperArray2[n2]) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + 1;
                    break;
                }
                ++n3;
            }
            ++n;
        }
    }

    private static void tieBreaker(FillerPanel fillerPanel, PlayerWrapper[] playerWrapperArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != nArray[0]) break;
            ++n;
            ++n2;
        }
        TournamentResultsPanel.getInstance(resources).addText("There are " + n + " players in the tiebreaker." + SEP);
        int[][] nArray2 = Tournaments.roundRobinMatches(n);
        ArrayList<PlayerWrapper[]> arrayList = new ArrayList<PlayerWrapper[]>(nArray2.length);
        int n3 = 0;
        while (n3 < nArray2.length) {
            PlayerWrapper[] playerWrapperArray2 = new PlayerWrapper[]{playerWrapperArray[nArray2[n3][0]], playerWrapperArray[nArray2[n3][1]]};
            arrayList.add(playerWrapperArray2);
            ++n3;
        }
        Tournaments.playBashoMatches(fillerPanel, arrayList, playerWrapperArray, nArray);
    }

    static int[][] roundRobinMatches(int n) {
        int n2 = n * (n - 1) / 2;
        int n3 = 0;
        int n4 = n + n % 2;
        int[][] nArray = new int[n2][2];
        int[][] nArray2 = new int[n4 / 2][2];
        int n5 = 0;
        while (n5 < n4 / 2) {
            nArray2[n5][0] = n4 - n5 - 1;
            nArray2[n5][1] = n5;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4 - 1) {
            int n7 = 0;
            while (n7 < nArray2.length) {
                nArray[n3][0] = nArray2[n7][0] == 0 ? 0 : (nArray2[n7][0] + n6) % (n4 - 1) + 1;
                int n8 = nArray[n3][1] = nArray2[n7][1] == 0 ? 0 : (nArray2[n7][1] + n6) % (n4 - 1) + 1;
                if (nArray[n3][0] != n && nArray[n3][1] != n) {
                    ++n3;
                }
                ++n7;
            }
            ++n6;
        }
        return nArray;
    }

    static void roundRobin(FillerPanel fillerPanel, PlayerWrappers playerWrappers) {
        int[][] nArray = Tournaments.roundRobinMatches(playerWrappers.size());
        int[] nArray2 = Tournaments.playTournamentMatches(nArray, fillerPanel, playerWrappers, true);
    }

    static int[] playTournamentMatches(int[][] nArray, FillerPanel fillerPanel, PlayerWrappers playerWrappers, boolean bl) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray2[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int[] nArray3 = nArray[n2];
            if (nArray3[0] < 0) {
                nArray2[n2] = nArray3[1];
            } else if (nArray3[1] < 0) {
                nArray2[n2] = nArray3[0];
            } else {
                PlayerWrapper[] playerWrapperArray;
                int[] nArray4;
                if (rng.nextBoolean()) {
                    int n3 = nArray3[0];
                    nArray3[0] = nArray3[1];
                    nArray3[1] = n3;
                }
                nArray2[n2] = (nArray4 = fillerPanel.tournamentMatch(playerWrapperArray = new PlayerWrapper[]{playerWrappers.get(nArray3[0]), playerWrappers.get(nArray3[1])}))[0] > nArray4[1] ? nArray3[0] : nArray3[1];
                if (bl) {
                    TournamentResultsPanel.getInstance(resources).addMatch(playerWrapperArray, nArray4);
                }
                if (cancelled) break;
            }
            ++n2;
        }
        return nArray2;
    }
}

