/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.AreaFileFactory;
import edu.wisc.ssec.mcidas.adde.AddeImageURL;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import visad.VisADException;
import visad.data.FlatFieldCacheAccessor;
import visad.data.FlatFieldCacheError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaImageAccessor
implements FlatFieldCacheAccessor,
Comparable<AreaImageAccessor> {
    private static Logger log = Logger.getLogger(AreaImageAccessor.class.getName());
    private final int band;
    private final String source;
    private int startLine;
    private int numLines;
    private int lineMag;
    private int startElem;
    private int numElems;
    private int elemMag;
    private Date nominalTime;
    private int[][][] readCache;
    private boolean isAddeSource;

    public AreaImageAccessor(String source, int band, int[][][] readCache) throws VisADException {
        this.band = band;
        this.source = source;
        this.readCache = readCache;
        if (this.readCache == null) {
            log.fine("readCache is null, by-reference data reading is disabled");
        }
        try {
            new AddeImageURL(source, "imagedata", "", "");
            this.isAddeSource = true;
            throw new IllegalArgumentException("adde sources are not currently supported");
        }
        catch (Exception e) {
            this.isAddeSource = false;
            return;
        }
    }

    public void setAreaParams(int startLine, int numLines, int lineMag, int startElem, int numElems, int elemMag) {
        this.startLine = startLine;
        this.numLines = numLines;
        this.lineMag = lineMag;
        this.startElem = startElem;
        this.numElems = numElems;
        this.elemMag = elemMag;
    }

    public boolean isAddeSource() {
        return this.isAddeSource;
    }

    protected int[][][] getAreaData() throws AreaFileException, AddeURLException {
        AreaFile af = null;
        af = !this.isAddeSource ? AreaFileFactory.getAreaFileInstance(this.source.toString(), this.startLine, this.numLines, this.lineMag, this.startElem, this.numElems, this.elemMag, this.band) : AreaFileFactory.getAreaFileInstance(this.source.toString());
        if (this.nominalTime == null) {
            this.nominalTime = af.getAreaDirectory().getNominalTime();
        } else if (this.nominalTime.equals(af.getAreaDirectory())) {
            throw new FlatFieldCacheError("nominal time mismatch on subsequent reads", null);
        }
        int[][][] raw = null;
        raw = this.readCache != null ? af.getData(this.readCache) : af.getData();
        return raw;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public double[][] readFlatField() {
        double[][] range = null;
        try {
            int[][][] raw = this.getAreaData();
            range = new double[1][this.numLines * this.numElems];
            int idx = 0;
            for (int line = 0; line < raw[0].length; ++line) {
                for (int elem = 0; elem < raw[0][0].length; ++elem) {
                    range[0][idx++] = raw[0][line][elem];
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not read image data: " + this.source.toString(), e);
        }
        return range;
    }

    @Override
    public float[][] readFlatFieldFloats() {
        float[][] range = null;
        try {
            int[][][] raw = this.getAreaData();
            range = new float[1][this.numLines * this.numElems];
            int idx = 0;
            for (int line = 0; line < raw[0].length; ++line) {
                for (int elem = 0; elem < raw[0][0].length; ++elem) {
                    range[0][idx++] = raw[0][line][elem];
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not read AREA file: " + this.source.toString(), e);
        }
        return range;
    }

    public Date getNominalTime() {
        if (this.nominalTime == null) {
            AreaFile af;
            try {
                af = AreaFileFactory.getAreaFileInstance(this.source.toString());
            }
            catch (Exception e) {
                throw new FlatFieldCacheError("Error getting nominal time from AREA file", e);
            }
            this.nominalTime = af.getAreaDirectory().getNominalTime();
        }
        return this.nominalTime;
    }

    @Override
    public int compareTo(AreaImageAccessor that) {
        long yourTime;
        long myTime = this.getNominalTime().getTime();
        if (myTime > (yourTime = that.getNominalTime().getTime())) {
            return 1;
        }
        if (myTime < yourTime) {
            return -1;
        }
        return 0;
    }
}

