/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.Hashtable;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.KeyChain;

class KeyHash {
    private Hashtable hash = new Hashtable();

    public final void add(HeaderCard card) {
        String key = card.getKey();
        if (key == null) {
            return;
        }
        key = key.toUpperCase();
        KeyChain kc = new KeyChain(card);
        KeyChain front = (KeyChain)this.hash.get(key);
        if (front == null) {
            this.hash.put(key, kc);
        } else {
            while (front.next != null) {
                front = front.next;
            }
            front.next = kc;
        }
    }

    public final void delete(HeaderCard card) {
        String key = card.getKey();
        if (key == null) {
            return;
        }
        KeyChain front = (KeyChain)this.hash.get(key = key.toUpperCase());
        if (front != null) {
            KeyChain prev = null;
            while (front != null) {
                if (front.card.equals(card)) {
                    if (prev != null) {
                        prev.next = front.next;
                    } else if (front.next != null) {
                        this.hash.put(key, front.next);
                    } else {
                        this.hash.remove(key);
                    }
                    return;
                }
                prev = front;
                front = front.next;
            }
        }
    }

    public final void replace(HeaderCard oldCard, HeaderCard newCard) {
        String oldKey = oldCard.getKey();
        if (oldKey == null) {
            this.add(newCard);
            return;
        }
        String newKey = newCard.getKey();
        if (newKey == null) {
            this.delete(oldCard);
            return;
        }
        if (!oldKey.equalsIgnoreCase(newKey)) {
            this.delete(oldCard);
            this.add(newCard);
            return;
        }
        String key = oldKey.toUpperCase();
        KeyChain front = (KeyChain)this.hash.get(key);
        if (front == null) {
            this.hash.put(key, new KeyChain(newCard));
            return;
        }
        while (true) {
            if (front.card.equals(oldCard)) {
                front.card = newCard;
                return;
            }
            if (front.next == null) break;
            front = front.next;
        }
        front.next = new KeyChain(newCard);
    }

    public final HeaderCard find(String key) {
        KeyChain kc;
        if (key != null && (kc = (KeyChain)this.hash.get(key.trim().toUpperCase())) != null) {
            return kc.card;
        }
        return null;
    }

    public final boolean contains(String key) {
        return key != null && this.hash.containsKey(key.toUpperCase());
    }
}

