/* $Id$ 
 *
 * LabelFactory: generate labels and keep book on these.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/container/LabelFactory.hpp"
#include <string>
#include <sstream>

namespace intermediate {

Label*
LabelFactory::getLabel(const char *prefix)
{
	std::stringstream stream;
	stream << prefix << "_" << LabelFactory::cnt;
	std::string s = stream.str();

	LabelFactory::cnt++;

	return new Label(s);
}

Label*
LabelFactory::getFixedLabel(const char *name)
{
	return new Label(std::string(name));
}

Label*
LabelFactory::getFixedLabel(const std::string &name)
{
	return new Label(name);
}

Label*
LabelFactory::getErrorLabel(void)
{
	static Label *errLabel = NULL;
	if (errLabel == NULL) {
		errLabel = new Label("vhdl_error");
		return errLabel;
	}

	return errLabel;
}

int LabelFactory::cnt = 0;

}; /* namespace intermediate */
