(ert-deftest elpy-multiedit-add-overlay-should-create-overlay ()
  (elpy-testcase ((:teardown (elpy-multiedit-stop)))
    (insert "foo")
    (elpy-multiedit-add-overlay (point-min) (point-max))
    (let ((ov (car (overlays-in (point-min) (point-max)))))
      (should (overlay-get ov 'elpy-multiedit))
      (should (memq ov elpy-multiedit-overlays)))))

(ert-deftest elpy-multiedit-add-overlay-should-fail-with-overlap ()
  (elpy-testcase ((:teardown (elpy-multiedit-stop)))
    (insert "foo")
    (elpy-multiedit-add-overlay (point-min) 3)
    (should-error (elpy-multiedit-add-overlay 2 (point-max)))))

(ert-deftest elpy-multiedit-add-overlay-should-edit-all ()
  (elpy-testcase ((:teardown (elpy-multiedit-stop)))
    (insert "foo\n\nfoo\n")
    (goto-char (point-min))
    (elpy-multiedit-add-overlay (point) (line-end-position))
    (forward-line 2)
    (elpy-multiedit-add-overlay (point) (line-end-position))
    (goto-char (point-min))
    (goto-char (line-end-position))
    (insert "bar")
    (should (equal (buffer-string)
                   "foobar\n\nfoobar\n"))))
