<?xml version="1.0"?>
<!-- $Id: //open/dev/farrago/testgen/generateSqlTestWrapper.xsl#4 $ -->
<!-- This stylesheet takes as input a list of .sql filenames and -->
<!-- generates a JUnit class for running them as diff-based tests -->
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  >
  <xsl:output method="text" indent="no" />

  <xsl:param name="rootpath"/>
  <xsl:param name="packagename"/>
  <xsl:param name="classname"/>
  <xsl:param name="basename"/>

  <xsl:template match="fileset">
// This class generated by ant target generateSqlTestWrapper
package <xsl:value-of select="$packagename"/>;

/**
 * Wraps .sql file diff-based tests with JUnit test methods for
 * convenient execution from within your favorite JUnit-aware IDE.
 */
public class <xsl:value-of select="$classname"/> extends <xsl:value-of select="$basename"/>
{

    public <xsl:value-of select="$classname"/>(String testName)
        throws Exception
    {
        super(testName);
    }

    protected void setUp()
        throws Exception
    {
        // run cleanup before each test case
        runCleanup();
        super.setUp();
        addDiffMask("\\$Id.*\\$");
        setVerbose(true);
    }
<xsl:apply-templates select="node()" />
}

// End <xsl:value-of select="$classname"/>.java
</xsl:template>

  <xsl:template match="fileset/file">
    public void test_<xsl:value-of select="translate(@path,'/.\:','____')"/>()
        throws Exception
    {
        runSqlLineTest("<xsl:value-of select="translate(concat($rootpath,@path),'\','/')"/>");
    }
</xsl:template>

}

</xsl:stylesheet>
