
#ifndef COLOR_H
#define COLOR_H

#include "def.h"
#include "argp.h"

#define N_ESC      7 /* the number of chars in a color-escape seq */
#define N_ESC0     8 /* the number of chars in C_NONE */

#define C_NONE   "\033[0m\033[m"
#define BLACK0   "\033[02;30m"
#define RED0     "\033[02;31m"
#define GREEN0   "\033[02;32m"
#define BROWN0   "\033[02;33m"
#define BLUE0    "\033[02;34m"
#define MAGENTA0 "\033[02;35m"
#define CYAN0    "\033[02;36m"
#define WHITE0   "\033[02;37m"
#define BLACK1   "\033[22;30m"
#define RED1     "\033[22;31m"
#define GREEN1   "\033[22;32m"
#define BROWN1   "\033[22;33m"
#define BLUE1    "\033[22;34m"
#define MAGENTA1 "\033[22;35m"
#define CYAN1    "\033[22;36m"
#define WHITE1   "\033[22;37m"
#define BLACK2   "\033[01;30m"
#define RED2     "\033[01;31m"
#define GREEN2   "\033[01;32m"
#define BROWN2   "\033[01;33m"
#define BLUE2    "\033[01;34m"
#define MAGENTA2 "\033[01;35m"
#define CYAN2    "\033[01;36m"
#define WHITE2   "\033[01;37m"

/* A and B refer to end-branch and metaram title bars, respectively.
 * C refers to main-body output and X refers to xref output.  */
#define C_DOT      WHITE0
#define C_RULE_A   WHITE0
#define C_RULE_B   WHITE0
#define C_RAMNO_A  WHITE1
#define C_RAMNO_B  WHITE1
#define C_RAMNO_C  WHITE1
#define C_RAMNO_X  WHITE0
#define C_TITLE_A  BROWN2
#define C_TITLE_B  BROWN2
#define C_TITLE_C  CYAN1
#define C_TITLE_X  WHITE0
#define C_PAREN_A  WHITE1
#define C_PAREN_B  WHITE1
#define C_COUNT_A  WHITE1
#define C_COUNT_B  WHITE1
#define C_MAINT    BROWN1
#define C_PRI      CYAN1
#define C_PRI_STD  BROWN2
#define C_PRI_OPT  C_PRI
#define C_PRI_EXT  WHITE0
#define C_DEB      WHITE2
#define C_DESC     WHITE1
#define C_XINDIC   WHITE0

#define PRI_OPT_STR "opt"
#define PRI_EXT_STR "ext"

/* "%s"   */
#define NEWLN                              \
  opt.color ?  C_NONE "\n"  : "\n"

/* "%s%s" */
#define COLOR(    STRING, FIELD )          \
  opt.color ? (C_ ## FIELD) : "", (STRING)

/* "%s%s": may only be used in files which include "xref.h" and have a
 * `struct xram *xram' in scope at the place of inclusion.  */
#define COLOR_AB( STRING, FIELD )          \
  opt.color                                \
  ? (                                      \
    xram->sref                             \
    ? (C_ ## FIELD ## _B)                  \
    : (C_ ## FIELD ## _A)                  \
  )                                        \
  : "",                                    \
  (STRING)

/* "%s"   */
#define COLOR_PRI( STRING )                \
  opt.color                                \
  ? (                                      \
    opt.pri_one_color ? C_PRI : (          \
      !strncmp( STRING, PRI_OPT_STR, WIDTH_PRI ) \
        ? C_PRI_OPT :                            \
      !strncmp( STRING, PRI_EXT_STR, WIDTH_PRI ) \
        ? C_PRI_EXT : C_PRI_STD                  \
    )                                      \
  )                                        \
  : ""

char *color2(
  char       *s,
  const char *p,
  const char *cs,
  const char *cp
);

#endif

