/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : ../../../../src/parser/cvc/Cvc.g
 *     -                            On : 2018-06-25 14:34:32
 *     -                for the parser : CvcParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "CvcParser.h"


#include <sstream>
#include <string>
#include <vector>

#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"


#define REPEAT_COMMAND(k, CommandCtor)                      \
  ({                                                        \
    unsigned __k = (k);                                     \
    (__k <= 1)                                              \
      ? (Command*) new CommandCtor                          \
      : ({                                                  \
          CommandSequence* __seq = new CommandSequence();   \
          while(__k-- > 0) {                                \
            __seq->addCommand(new CommandCtor);             \
          }                                                 \
          (Command*) __seq;                                 \
        });                                                 \
  })

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which will be defined
 * by ANTLR *after* this section. (If they were functions, PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Parser*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

#define ENSURE_BV_SIZE(k, f)                                   \
{                                                              \
  unsigned size = BitVectorType(f.getType()).getSize();        \
  if(k > size) {                                               \
    f = MK_EXPR(MK_CONST(BitVectorZeroExtend(k - size)), f);   \
  } else if (k < size) {                                       \
    f = MK_EXPR(MK_CONST(BitVectorExtract(k - 1, 0)), f);      \
  }                                                            \
}


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pCvcParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pCvcParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pCvcParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pCvcParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   CvcParserTokenNames[187+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ABS_TOK",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ARITH_VAR_ORDER_TOK",
        (pANTLR3_UINT8) "ARRAY_TOK",
        (pANTLR3_UINT8) "ARROW_TOK",
        (pANTLR3_UINT8) "ASSERTIONS_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "ASSIGN_TOK",
        (pANTLR3_UINT8) "ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "BAR",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BITVECTOR_TOK",
        (pANTLR3_UINT8) "BOOLEAN_TOK",
        (pANTLR3_UINT8) "BVAND_TOK",
        (pANTLR3_UINT8) "BVASHR_TOK",
        (pANTLR3_UINT8) "BVCOMP_TOK",
        (pANTLR3_UINT8) "BVGE_TOK",
        (pANTLR3_UINT8) "BVGT_TOK",
        (pANTLR3_UINT8) "BVLE_TOK",
        (pANTLR3_UINT8) "BVLSHR_TOK",
        (pANTLR3_UINT8) "BVLT_TOK",
        (pANTLR3_UINT8) "BVMULT_TOK",
        (pANTLR3_UINT8) "BVNAND_TOK",
        (pANTLR3_UINT8) "BVNEG_TOK",
        (pANTLR3_UINT8) "BVNOR_TOK",
        (pANTLR3_UINT8) "BVPLUS_TOK",
        (pANTLR3_UINT8) "BVREPEAT_TOK",
        (pANTLR3_UINT8) "BVROTL_TOK",
        (pANTLR3_UINT8) "BVROTR_TOK",
        (pANTLR3_UINT8) "BVSDIV_TOK",
        (pANTLR3_UINT8) "BVSGE_TOK",
        (pANTLR3_UINT8) "BVSGT_TOK",
        (pANTLR3_UINT8) "BVSHL_TOK",
        (pANTLR3_UINT8) "BVSLE_TOK",
        (pANTLR3_UINT8) "BVSLT_TOK",
        (pANTLR3_UINT8) "BVSMOD_TOK",
        (pANTLR3_UINT8) "BVSREM_TOK",
        (pANTLR3_UINT8) "BVSUB_TOK",
        (pANTLR3_UINT8) "BVUDIV_TOK",
        (pANTLR3_UINT8) "BVUMINUS_TOK",
        (pANTLR3_UINT8) "BVUREM_TOK",
        (pANTLR3_UINT8) "BVXNOR_TOK",
        (pANTLR3_UINT8) "BVXOR_TOK",
        (pANTLR3_UINT8) "BVZEROEXTEND_TOK",
        (pANTLR3_UINT8) "CALL_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "CHECK_TYPE_TOK",
        (pANTLR3_UINT8) "COLON",
        (pANTLR3_UINT8) "COMMA",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONCAT_TOK",
        (pANTLR3_UINT8) "CONTEXT_TOK",
        (pANTLR3_UINT8) "CONTINUE_TOK",
        (pANTLR3_UINT8) "COUNTEREXAMPLE_TOK",
        (pANTLR3_UINT8) "COUNTERMODEL_TOK",
        (pANTLR3_UINT8) "DATATYPE_TOK",
        (pANTLR3_UINT8) "DBG_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISEQUAL_TOK",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "DOTDOT",
        (pANTLR3_UINT8) "DUMP_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_TOK",
        (pANTLR3_UINT8) "DUMP_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_SIG_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_TOK",
        (pANTLR3_UINT8) "DUMP_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "ELSEIF_TOK",
        (pANTLR3_UINT8) "ELSE_TOK",
        (pANTLR3_UINT8) "ENDIF_TOK",
        (pANTLR3_UINT8) "END_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "ESCAPE",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "EXP_TOK",
        (pANTLR3_UINT8) "FALSE_TOK",
        (pANTLR3_UINT8) "FLOOR_TOK",
        (pANTLR3_UINT8) "FMF_CARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FORGET_TOK",
        (pANTLR3_UINT8) "GEQ_TOK",
        (pANTLR3_UINT8) "GET_CHILD_TOK",
        (pANTLR3_UINT8) "GET_OP_TOK",
        (pANTLR3_UINT8) "GET_TYPE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GT_TOK",
        (pANTLR3_UINT8) "HASHPAREN",
        (pANTLR3_UINT8) "HASHSQ",
        (pANTLR3_UINT8) "HELP_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IDENTIFIER",
        (pANTLR3_UINT8) "IDEN_TOK",
        (pANTLR3_UINT8) "IFF_TOK",
        (pANTLR3_UINT8) "IF_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INTDIV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INT_TOK",
        (pANTLR3_UINT8) "IN_TOK",
        (pANTLR3_UINT8) "IS_INTEGER_TOK",
        (pANTLR3_UINT8) "JOIN_IMAGE_TOK",
        (pANTLR3_UINT8) "JOIN_TOK",
        (pANTLR3_UINT8) "LAMBDA_TOK",
        (pANTLR3_UINT8) "LBRACE",
        (pANTLR3_UINT8) "LBRACKET",
        (pANTLR3_UINT8) "LEFTSHIFT_TOK",
        (pANTLR3_UINT8) "LEQ_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN",
        (pANTLR3_UINT8) "LT_TOK",
        (pANTLR3_UINT8) "MEMBER_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "MOD_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMBER_OR_RANGEOP",
        (pANTLR3_UINT8) "OF_TOK",
        (pANTLR3_UINT8) "OPTION_TOK",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PARENHASH",
        (pANTLR3_UINT8) "PATTERN_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POPTO_SCOPE_TOK",
        (pANTLR3_UINT8) "POPTO_TOK",
        (pANTLR3_UINT8) "POP_SCOPE_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PRINT_TOK",
        (pANTLR3_UINT8) "PRINT_TYPE_TOK",
        (pANTLR3_UINT8) "PRODUCT_TOK",
        (pANTLR3_UINT8) "PUSH_SCOPE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUERY_TOK",
        (pANTLR3_UINT8) "RBRACE",
        (pANTLR3_UINT8) "RBRACKET",
        (pANTLR3_UINT8) "REAL_TOK",
        (pANTLR3_UINT8) "RECURSIVE_FUNCTION_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "RESTART_TOK",
        (pANTLR3_UINT8) "RIGHTSHIFT_TOK",
        (pANTLR3_UINT8) "RPAREN",
        (pANTLR3_UINT8) "SEMICOLON",
        (pANTLR3_UINT8) "SETS_CARD_TOK",
        (pANTLR3_UINT8) "SET_TOK",
        (pANTLR3_UINT8) "SQHASH",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STRING_CHARAT_TOK",
        (pANTLR3_UINT8) "STRING_CONCAT_TOK",
        (pANTLR3_UINT8) "STRING_CONTAINS_TOK",
        (pANTLR3_UINT8) "STRING_INDEXOF_TOK",
        (pANTLR3_UINT8) "STRING_ITOS_TOK",
        (pANTLR3_UINT8) "STRING_LENGTH_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "STRING_PREFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_REPLACE_TOK",
        (pANTLR3_UINT8) "STRING_STOI_TOK",
        (pANTLR3_UINT8) "STRING_SUBSTR_TOK",
        (pANTLR3_UINT8) "STRING_SUFFIXOF_TOK",
        (pANTLR3_UINT8) "STRING_TOK",
        (pANTLR3_UINT8) "SUBSTITUTE_TOK",
        (pANTLR3_UINT8) "SUBTYPE_TOK",
        (pANTLR3_UINT8) "SX_TOK",
        (pANTLR3_UINT8) "THEN_TOK",
        (pANTLR3_UINT8) "TRACE_TOK",
        (pANTLR3_UINT8) "TRANSCLOSURE_TOK",
        (pANTLR3_UINT8) "TRANSFORM_TOK",
        (pANTLR3_UINT8) "TRANSPOSE_TOK",
        (pANTLR3_UINT8) "TRUE_TOK",
        (pANTLR3_UINT8) "TUPLE_TOK",
        (pANTLR3_UINT8) "TYPE_TOK",
        (pANTLR3_UINT8) "UNDERSCORE",
        (pANTLR3_UINT8) "UNIVSET_TOK",
        (pANTLR3_UINT8) "UNTRACE_TOK",
        (pANTLR3_UINT8) "WHERE_TOK",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "WITH_TOK",
        (pANTLR3_UINT8) "XOR_TOK"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::Expr
	parseExpr    (pCvcParser ctx);
static 
 CVC4::Command*
	parseCommand    (pCvcParser ctx);
static 
 void
	command    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	typeOrVarLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	mainCommand    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	simpleSymbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	toplevelDeclaration    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	boundVarDecl    (pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t);
static 
 void
	boundVarDecls    (pCvcParser ctx);
static 
 void
	boundVarDeclsReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	boundVarDeclReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	declareTypes    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, const std::vector<std::string>& idList);
static 
 void
	declareVariables    (pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel);
static 
 void
	identifierList    (pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	identifier    (pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	type    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedType    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedTypePossiblyFunctionLHS    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs);
static 
 void
	parameterization    (pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params);
static 
 void
	bound    (pCvcParser ctx);
static 
 void
	typeLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	formula    (pCvcParser ctx, CVC4::Expr& f);
static 
 size_t
	morecomparisons    (pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators);
static 
 size_t
	nots    (pCvcParser ctx);
static 
 void
	prefixFormula    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	instantiationPatterns    (pCvcParser ctx, CVC4::Expr& expr);
static 
 void
	letDecl    (pCvcParser ctx);
static 
 void
	booleanBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	comparison    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	comparisonBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	arithmeticBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	term    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	arrayStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	tupleStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	recordStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	uminusTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinaryOpTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	bvNegTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	relationTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	postfixTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	stringTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	setsTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	simpleTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	typeAscription    (pCvcParser ctx, const CVC4::Expr& f, CVC4::Type& t);
static 
 void
	recordEntry    (pCvcParser ctx, std::string& name, CVC4::Expr& ex);
static 
 void
	iteTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	iteElseTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	datatypeDef    (pCvcParser ctx, std::vector<CVC4::Datatype>& datatypes);
static 
 void
	constructorDef    (pCvcParser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pCvcParser ctx, std::unique_ptr<CVC4::DatatypeConstructor>* ctor);
static 
 unsigned
	numeral    (pCvcParser ctx);
static 
 CVC4::Rational
	integer    (pCvcParser ctx);
static 
 void
	str    (pCvcParser ctx, std::string& s);
static 
 ANTLR3_BOOLEAN
	synpred1_Cvc    (pCvcParser ctx);
static void	CvcParserFree(pCvcParser ctx);
static void     CvcParserReset (pCvcParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "../../../../src/parser/cvc/Cvc.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return CvcParserNewSSD(instream, NULL);
}

/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pCvcParser ctx;	    /* Context structure we will build and return   */

    ctx	= (pCvcParser) ANTLR3_CALLOC(1, sizeof(CvcParser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in CvcParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our CvcParser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->command	= command;
    ctx->typeOrVarLetDecl	= typeOrVarLetDecl;
    ctx->mainCommand	= mainCommand;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->toplevelDeclaration	= toplevelDeclaration;
    ctx->boundVarDecl	= boundVarDecl;
    ctx->boundVarDecls	= boundVarDecls;
    ctx->boundVarDeclsReturn	= boundVarDeclsReturn;
    ctx->boundVarDeclReturn	= boundVarDeclReturn;
    ctx->declareTypes	= declareTypes;
    ctx->declareVariables	= declareVariables;
    ctx->identifierList	= identifierList;
    ctx->identifier	= identifier;
    ctx->type	= type;
    ctx->restrictedType	= restrictedType;
    ctx->restrictedTypePossiblyFunctionLHS	= restrictedTypePossiblyFunctionLHS;
    ctx->parameterization	= parameterization;
    ctx->bound	= bound;
    ctx->typeLetDecl	= typeLetDecl;
    ctx->formula	= formula;
    ctx->morecomparisons	= morecomparisons;
    ctx->nots	= nots;
    ctx->prefixFormula	= prefixFormula;
    ctx->instantiationPatterns	= instantiationPatterns;
    ctx->letDecl	= letDecl;
    ctx->booleanBinop	= booleanBinop;
    ctx->comparison	= comparison;
    ctx->comparisonBinop	= comparisonBinop;
    ctx->arithmeticBinop	= arithmeticBinop;
    ctx->term	= term;
    ctx->arrayStore	= arrayStore;
    ctx->tupleStore	= tupleStore;
    ctx->recordStore	= recordStore;
    ctx->uminusTerm	= uminusTerm;
    ctx->bvBinaryOpTerm	= bvBinaryOpTerm;
    ctx->bvBinop	= bvBinop;
    ctx->bvNegTerm	= bvNegTerm;
    ctx->relationTerm	= relationTerm;
    ctx->postfixTerm	= postfixTerm;
    ctx->bvTerm	= bvTerm;
    ctx->stringTerm	= stringTerm;
    ctx->setsTerm	= setsTerm;
    ctx->simpleTerm	= simpleTerm;
    ctx->typeAscription	= typeAscription;
    ctx->recordEntry	= recordEntry;
    ctx->iteTerm	= iteTerm;
    ctx->iteElseTerm	= iteElseTerm;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->numeral	= numeral;
    ctx->integer	= integer;
    ctx->str	= str;
    ctx->synpred1_Cvc	= synpred1_Cvc;
    ctx->free			= CvcParserFree;
    ctx->reset			= CvcParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = CvcParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
CvcParserReset (pCvcParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 CvcParserFree(pCvcParser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return CvcParserTokenNames;
}



    // Idea and code guidance from Sam Harwell,
    // http://www.antlr.org/wiki/display/ANTLR3/Operator+precedence+parser

    bool isRightToLeft(int type) {
      // return true here for any operators that are right-to-left associative
      switch(type) {
      case IMPLIES_TOK: return true;
      default: return false;
      }
    }/* isRightToLeft() */

    int getOperatorPrecedence(int type) {
      switch(type) {
      case BITVECTOR_TOK: return 1;
      //case DOT:
      case LPAREN:
      case LBRACE: return 2;
      case LBRACKET: return 3;
      case ARROW_TOK: return 4;
      case IS_INTEGER_TOK: return 5;
      case BVSLT_TOK:
      case BVSLE_TOK:
      case BVSGT_TOK:
      case BVSGE_TOK: return 6;
      case BVLT_TOK:
      case BVLE_TOK:
      case BVGT_TOK:
      case BVGE_TOK: return 7;
      case LEFTSHIFT_TOK:
      case RIGHTSHIFT_TOK: return 8;
      case SX_TOK:
      case BVZEROEXTEND_TOK:
      case BVREPEAT_TOK:
      case BVROTL_TOK:
      case BVROTR_TOK: return 9;
      case BVUDIV_TOK:
      case BVSDIV_TOK:
      case BVUREM_TOK:
      case BVSREM_TOK:
      case BVSMOD_TOK:
      case BVSHL_TOK:
      case BVASHR_TOK:
      case BVLSHR_TOK: return 10;
      case BVUMINUS_TOK:
      case BVPLUS_TOK:
      case BVSUB_TOK: return 11;
      case BVNEG_TOK: return 12;
      case BVXNOR_TOK: return 13;
      case BVNOR_TOK:
      case BVCOMP_TOK: return 14;
      case BVNAND_TOK: return 15;
      case BVXOR_TOK: return 16;
      case BVAND_TOK: return 17;
      case BAR: return 18;
      case CONCAT_TOK: return 19;
    //case UMINUS_TOK: return 20;
      case WITH_TOK: return 21;
      case EXP_TOK: return 22;
      case STAR_TOK:
      case INTDIV_TOK:
      case DIV_TOK:
      case TUPLE_TOK:
      case MOD_TOK: return 23;
      case PLUS_TOK:
      case MINUS_TOK:
      case JOIN_TOK:
      case TRANSPOSE_TOK:
      case PRODUCT_TOK:
      case IDEN_TOK:
      case JOIN_IMAGE_TOK:  
      case TRANSCLOSURE_TOK: return 24;
      case LEQ_TOK:
      case LT_TOK:
      case GEQ_TOK:
      case GT_TOK:
      case MEMBER_TOK: 
      case SETS_CARD_TOK:
      case FMF_CARD_TOK: return 25;
      case EQUAL_TOK:
      case DISEQUAL_TOK: return 26;
      case NOT_TOK: return 27;
      case AND_TOK: return 28;
      case OR_TOK:
      case XOR_TOK: return 29;
      case IMPLIES_TOK: return 30;// right-to-left
      case IFF_TOK: return 31;
      case FORALL_TOK:
      case EXISTS_TOK: return 32;
      case ASSIGN_TOK:
      case IN_TOK: return 33;

      default:
        std::stringstream ss;
        ss << "internal error: no entry in precedence table for operator " << CvcParserTokenNames[type];
        throw ParserException(ss.str());
      }
    }/* getOperatorPrecedence() */

    Kind getOperatorKind(int type, bool& negate) {
      negate = false;

      switch(type) {
        // booleanBinop
      case IFF_TOK: return kind::EQUAL;
      case IMPLIES_TOK: return kind::IMPLIES;
      case OR_TOK: return kind::OR;
      case XOR_TOK: return kind::XOR;
      case AND_TOK: return kind::AND;
      
      case PRODUCT_TOK: return kind::PRODUCT;
      case JOIN_TOK: return kind::JOIN;
      case JOIN_IMAGE_TOK: return kind::JOIN_IMAGE;  

        // comparisonBinop
      case EQUAL_TOK: return kind::EQUAL;
      case DISEQUAL_TOK: negate = true; return kind::EQUAL;
      case GT_TOK: return kind::GT;
      case GEQ_TOK: return kind::GEQ;
      case LT_TOK: return kind::LT;
      case LEQ_TOK: return kind::LEQ;
      case MEMBER_TOK: return kind::MEMBER;
      case SETS_CARD_TOK: return kind::CARD;
      case FMF_CARD_TOK: return kind::CARDINALITY_CONSTRAINT;

        // arithmeticBinop
      case PLUS_TOK: return kind::PLUS;
      case MINUS_TOK: return kind::MINUS;
      case STAR_TOK: return kind::MULT;
      case INTDIV_TOK: return kind::INTS_DIVISION;
      case MOD_TOK: return kind::INTS_MODULUS;
      case DIV_TOK: return kind::DIVISION;
      case EXP_TOK: return kind::POW;

        // bvBinop
      case CONCAT_TOK: return kind::BITVECTOR_CONCAT;
      case BAR: return kind::BITVECTOR_OR;
      case BVAND_TOK: return kind::BITVECTOR_AND;
      
      }

      std::stringstream ss;
      ss << "internal error: no entry in operator-kind table for operator " << CvcParserTokenNames[type];
      throw ParserException(ss.str());

    }/* getOperatorKind() */

    unsigned findPivot(const std::vector<unsigned>& operators,
                       unsigned startIndex, unsigned stopIndex) {
      unsigned pivot = startIndex;
      unsigned pivotRank = getOperatorPrecedence(operators[pivot]);
      /*Debug("prec") << "initial pivot at " << pivot
                    << "(" << CvcParserTokenNames[operators[pivot]] << ") "
                    << "level " << pivotRank << std::endl;*/
      for(unsigned i = startIndex + 1; i <= stopIndex; ++i) {
        unsigned current = getOperatorPrecedence(operators[i]);
        bool rtl = isRightToLeft(operators[i]);
        if(current > pivotRank || (current == pivotRank && !rtl)) {
          /*Debug("prec") << "new pivot at " << i
                        << "(" << CvcParserTokenNames[operators[i]] << ") "
                        << "level " << current << " rtl == " << rtl << std::endl;*/
          pivot = i;
          pivotRank = current;
        }
      }
      return pivot;
    }/* findPivot() */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators,
                              unsigned startIndex, unsigned stopIndex) {
      assert(expressions.size() == operators.size() + 1);
      assert(startIndex < expressions.size());
      assert(stopIndex < expressions.size());
      assert(startIndex <= stopIndex);

      if(stopIndex == startIndex) {
        return expressions[startIndex];
      }

      unsigned pivot = findPivot(operators, startIndex, stopIndex - 1);
      //Debug("prec") << "pivot[" << startIndex << "," << stopIndex - 1 << "] at " << pivot << std::endl;
      bool negate;
      Kind k = getOperatorKind(operators[pivot], negate);
      Expr lhs = createPrecedenceTree(parser, em, expressions, operators, startIndex, pivot);
      Expr rhs = createPrecedenceTree(parser, em, expressions, operators, pivot + 1, stopIndex);

      switch(k) {
      case kind::LEQ          : if(lhs.getType().isSet()) { k = kind::SUBSET; } break;
      case kind::MINUS        : if(lhs.getType().isSet()) { k = kind::SETMINUS; } break;
      case kind::BITVECTOR_AND: if(lhs.getType().isSet()) { k = kind::INTERSECTION; } break;
      case kind::BITVECTOR_OR : if(lhs.getType().isSet()) { k = kind::UNION; } break;
      default: break;
      }
      Expr e = em->mkExpr(k, lhs, rhs);
      return negate ? em->mkExpr(kind::NOT, e) : e;
    }/* createPrecedenceTree() recursive variant */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators) {
      if(Debug.isOn("prec") && operators.size() > 1) {
        for(unsigned i = 0; i < expressions.size(); ++i) {
          Debug("prec") << expressions[i];
          if(operators.size() > i) {
            Debug("prec") << ' ' << CvcParserTokenNames[operators[i]] << ' ';
          }
        }
        Debug("prec") << std::endl;
      }

      Expr e = createPrecedenceTree(parser, em, expressions, operators, 0, expressions.size() - 1);
      if(Debug.isOn("prec") && operators.size() > 1) {
        language::SetLanguage::Scope ls(Debug("prec"), language::output::LANG_AST);
        Debug("prec") << "=> " << e << std::endl;
      }
      return e;
    }/* createPrecedenceTree() base variant */

    /** Add n NOTs to the front of e and return the result. */
    Expr addNots(ExprManager* em, size_t n, Expr e) {
      while(n-- > 0) {
        e = em->mkExpr(kind::NOT, e);
      }
      return e;
    }/* addNots() */



/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_parseExpr1792  */
static	ANTLR3_BITWORD FOLLOW_formula_in_parseExpr1792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_parseExpr1792	= { FOLLOW_formula_in_parseExpr1792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr1799  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr1799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr1799	= { FOLLOW_EOF_in_parseExpr1799_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand1830  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand1830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand1830	= { FOLLOW_command_in_parseCommand1830_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_parseCommand1837  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_parseCommand1837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_parseCommand1837	= { FOLLOW_LPAREN_in_parseCommand1837_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_parseCommand1839  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_parseCommand1839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_parseCommand1839	= { FOLLOW_IDENTIFIER_in_parseCommand1839_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand1851  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand1851_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand1851	= { FOLLOW_EOF_in_parseCommand1851_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_mainCommand_in_command1870  */
static	ANTLR3_BITWORD FOLLOW_mainCommand_in_command1870_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_mainCommand_in_command1870	= { FOLLOW_mainCommand_in_command1870_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1873  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1873	= { FOLLOW_SEMICOLON_in_command1873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1881  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1881_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1881	= { FOLLOW_SEMICOLON_in_command1881_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_command1889  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_command1889_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_command1889	= { FOLLOW_LET_TOK_in_command1889_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1899  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1899_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1899	= { FOLLOW_typeOrVarLetDecl_in_command1899_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_command1914  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_command1914_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_command1914	= { FOLLOW_COMMA_in_command1914_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1916  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1916_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1916	= { FOLLOW_typeOrVarLetDecl_in_command1916_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_command1928  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_command1928_bits[]	= { ANTLR3_UINT64_LIT(0x3F0E000000002C80), ANTLR3_UINT64_LIT(0x08004247A080FFC0), ANTLR3_UINT64_LIT(0x0C0A200009C77E10) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_command1928	= { FOLLOW_IN_TOK_in_command1928_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_command1930  */
static	ANTLR3_BITWORD FOLLOW_command_in_command1930_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_command1930	= { FOLLOW_command_in_command1930_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_command1957  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_command1957_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_command1957	= { FOLLOW_IDENTIFIER_in_command1957_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1959  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1959_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1959	= { FOLLOW_SEMICOLON_in_command1959_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_typeOrVarLetDecl1990  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_typeOrVarLetDecl1990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_typeOrVarLetDecl1990	= { FOLLOW_letDecl_in_typeOrVarLetDecl1990_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_typeOrVarLetDecl1994  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_typeOrVarLetDecl1994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_typeOrVarLetDecl1994	= { FOLLOW_typeLetDecl_in_typeOrVarLetDecl1994_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_mainCommand2020  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_mainCommand2020_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_mainCommand2020	= { FOLLOW_ASSERT_TOK_in_mainCommand2020_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2022  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2022_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2022	= { FOLLOW_formula_in_mainCommand2022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUERY_TOK_in_mainCommand2032  */
static	ANTLR3_BITWORD FOLLOW_QUERY_TOK_in_mainCommand2032_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_QUERY_TOK_in_mainCommand2032	= { FOLLOW_QUERY_TOK_in_mainCommand2032_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2034  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2034_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2034	= { FOLLOW_formula_in_mainCommand2034_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_mainCommand2043  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_mainCommand2043_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_mainCommand2043	= { FOLLOW_CHECKSAT_TOK_in_mainCommand2043_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2045  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2045	= { FOLLOW_formula_in_mainCommand2045_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OPTION_TOK_in_mainCommand2065  */
static	ANTLR3_BITWORD FOLLOW_OPTION_TOK_in_mainCommand2065_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_OPTION_TOK_in_mainCommand2065	= { FOLLOW_OPTION_TOK_in_mainCommand2065_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2073  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2073_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0020004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2073	= { FOLLOW_str_in_mainCommand2073_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2078  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2078_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x9001030002000000), ANTLR3_UINT64_LIT(0x0020004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2078	= { FOLLOW_IDENTIFIER_in_mainCommand2078_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_mainCommand2090  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_mainCommand2090_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_mainCommand2090	= { FOLLOW_symbolicExpr_in_mainCommand2090_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_mainCommand2107  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_mainCommand2107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_mainCommand2107	= { FOLLOW_TRUE_TOK_in_mainCommand2107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_mainCommand2117  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_mainCommand2117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_mainCommand2117	= { FOLLOW_FALSE_TOK_in_mainCommand2117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_mainCommand2146  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_mainCommand2146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_mainCommand2146	= { FOLLOW_PUSH_TOK_in_mainCommand2146_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2152  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2152	= { FOLLOW_numeral_in_mainCommand2152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_mainCommand2181  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_mainCommand2181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_mainCommand2181	= { FOLLOW_POP_TOK_in_mainCommand2181_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2187  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2187	= { FOLLOW_numeral_in_mainCommand2187_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_TOK_in_mainCommand2215  */
static	ANTLR3_BITWORD FOLLOW_POPTO_TOK_in_mainCommand2215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_TOK_in_mainCommand2215	= { FOLLOW_POPTO_TOK_in_mainCommand2215_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2219  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2219	= { FOLLOW_numeral_in_mainCommand2219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2239  */
static	ANTLR3_BITWORD FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2239	= { FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2239_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2243  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2243	= { FOLLOW_numeral_in_mainCommand2243_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_SCOPE_TOK_in_mainCommand2256  */
static	ANTLR3_BITWORD FOLLOW_POP_SCOPE_TOK_in_mainCommand2256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_SCOPE_TOK_in_mainCommand2256	= { FOLLOW_POP_SCOPE_TOK_in_mainCommand2256_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2260  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2260	= { FOLLOW_numeral_in_mainCommand2260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2273  */
static	ANTLR3_BITWORD FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2273	= { FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2273_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2277  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2277	= { FOLLOW_numeral_in_mainCommand2277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2291  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2291_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2291	= { FOLLOW_RESET_TOK_in_mainCommand2291_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2304  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2304	= { FOLLOW_RESET_TOK_in_mainCommand2304_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERTIONS_TOK_in_mainCommand2306  */
static	ANTLR3_BITWORD FOLLOW_ASSERTIONS_TOK_in_mainCommand2306_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERTIONS_TOK_in_mainCommand2306	= { FOLLOW_ASSERTIONS_TOK_in_mainCommand2306_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATATYPE_TOK_in_mainCommand2334  */
static	ANTLR3_BITWORD FOLLOW_DATATYPE_TOK_in_mainCommand2334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DATATYPE_TOK_in_mainCommand2334	= { FOLLOW_DATATYPE_TOK_in_mainCommand2334_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2346  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2346_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2346	= { FOLLOW_datatypeDef_in_mainCommand2346_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand2355  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand2355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand2355	= { FOLLOW_COMMA_in_mainCommand2355_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2357  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2357_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2357	= { FOLLOW_datatypeDef_in_mainCommand2357_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_END_TOK_in_mainCommand2367  */
static	ANTLR3_BITWORD FOLLOW_END_TOK_in_mainCommand2367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_END_TOK_in_mainCommand2367	= { FOLLOW_END_TOK_in_mainCommand2367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTEXT_TOK_in_mainCommand2380  */
static	ANTLR3_BITWORD FOLLOW_CONTEXT_TOK_in_mainCommand2380_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTEXT_TOK_in_mainCommand2380	= { FOLLOW_CONTEXT_TOK_in_mainCommand2380_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2390  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2390_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2390	= { FOLLOW_str_in_mainCommand2390_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2395  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2395	= { FOLLOW_IDENTIFIER_in_mainCommand2395_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORGET_TOK_in_mainCommand2428  */
static	ANTLR3_BITWORD FOLLOW_FORGET_TOK_in_mainCommand2428_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORGET_TOK_in_mainCommand2428	= { FOLLOW_FORGET_TOK_in_mainCommand2428_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2430  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2430	= { FOLLOW_identifier_in_mainCommand2430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_TYPE_TOK_in_mainCommand2444  */
static	ANTLR3_BITWORD FOLLOW_GET_TYPE_TOK_in_mainCommand2444_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_TYPE_TOK_in_mainCommand2444	= { FOLLOW_GET_TYPE_TOK_in_mainCommand2444_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2446  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2446	= { FOLLOW_formula_in_mainCommand2446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_TYPE_TOK_in_mainCommand2460  */
static	ANTLR3_BITWORD FOLLOW_CHECK_TYPE_TOK_in_mainCommand2460_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_TYPE_TOK_in_mainCommand2460	= { FOLLOW_CHECK_TYPE_TOK_in_mainCommand2460_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2462  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2462_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2462	= { FOLLOW_formula_in_mainCommand2462_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2465  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2465_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2465	= { FOLLOW_COLON_in_mainCommand2465_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2467  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2467_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2467	= { FOLLOW_type_in_mainCommand2467_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_CHILD_TOK_in_mainCommand2481  */
static	ANTLR3_BITWORD FOLLOW_GET_CHILD_TOK_in_mainCommand2481_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_CHILD_TOK_in_mainCommand2481	= { FOLLOW_GET_CHILD_TOK_in_mainCommand2481_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2483  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2483	= { FOLLOW_formula_in_mainCommand2483_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2488  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2488	= { FOLLOW_numeral_in_mainCommand2488_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OP_TOK_in_mainCommand2501  */
static	ANTLR3_BITWORD FOLLOW_GET_OP_TOK_in_mainCommand2501_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OP_TOK_in_mainCommand2501	= { FOLLOW_GET_OP_TOK_in_mainCommand2501_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2503  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2503	= { FOLLOW_formula_in_mainCommand2503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_mainCommand2517  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_mainCommand2517_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_mainCommand2517	= { FOLLOW_GET_VALUE_TOK_in_mainCommand2517_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2519  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2519_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2519	= { FOLLOW_formula_in_mainCommand2519_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBSTITUTE_TOK_in_mainCommand2533  */
static	ANTLR3_BITWORD FOLLOW_SUBSTITUTE_TOK_in_mainCommand2533_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBSTITUTE_TOK_in_mainCommand2533	= { FOLLOW_SUBSTITUTE_TOK_in_mainCommand2533_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2535  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2535_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2535	= { FOLLOW_identifier_in_mainCommand2535_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2538  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2538	= { FOLLOW_COLON_in_mainCommand2538_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2544  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2544	= { FOLLOW_type_in_mainCommand2544_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand2547  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand2547_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand2547	= { FOLLOW_EQUAL_TOK_in_mainCommand2547_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2549  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2549_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2549	= { FOLLOW_formula_in_mainCommand2549_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_mainCommand2552  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_mainCommand2552_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_mainCommand2552	= { FOLLOW_LBRACKET_in_mainCommand2552_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2558  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2558_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2558	= { FOLLOW_identifier_in_mainCommand2558_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_mainCommand2561  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_mainCommand2561_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_mainCommand2561	= { FOLLOW_ASSIGN_TOK_in_mainCommand2561_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2563  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2563_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2563	= { FOLLOW_formula_in_mainCommand2563_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_mainCommand2566  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_mainCommand2566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_mainCommand2566	= { FOLLOW_RBRACKET_in_mainCommand2566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DBG_TOK_in_mainCommand2585  */
static	ANTLR3_BITWORD FOLLOW_DBG_TOK_in_mainCommand2585_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DBG_TOK_in_mainCommand2585	= { FOLLOW_DBG_TOK_in_mainCommand2585_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2595  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2595	= { FOLLOW_str_in_mainCommand2595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2600  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2600_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2600	= { FOLLOW_IDENTIFIER_in_mainCommand2600_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRACE_TOK_in_mainCommand2633  */
static	ANTLR3_BITWORD FOLLOW_TRACE_TOK_in_mainCommand2633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRACE_TOK_in_mainCommand2633	= { FOLLOW_TRACE_TOK_in_mainCommand2633_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2643  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2643	= { FOLLOW_str_in_mainCommand2643_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2648  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2648_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2648	= { FOLLOW_IDENTIFIER_in_mainCommand2648_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTRACE_TOK_in_mainCommand2680  */
static	ANTLR3_BITWORD FOLLOW_UNTRACE_TOK_in_mainCommand2680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTRACE_TOK_in_mainCommand2680	= { FOLLOW_UNTRACE_TOK_in_mainCommand2680_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2690  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2690_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2690	= { FOLLOW_str_in_mainCommand2690_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2695  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2695	= { FOLLOW_IDENTIFIER_in_mainCommand2695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HELP_TOK_in_mainCommand2728  */
static	ANTLR3_BITWORD FOLLOW_HELP_TOK_in_mainCommand2728_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HELP_TOK_in_mainCommand2728	= { FOLLOW_HELP_TOK_in_mainCommand2728_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2738  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2738_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2738	= { FOLLOW_str_in_mainCommand2738_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2743  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2743	= { FOLLOW_IDENTIFIER_in_mainCommand2743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSFORM_TOK_in_mainCommand2784  */
static	ANTLR3_BITWORD FOLLOW_TRANSFORM_TOK_in_mainCommand2784_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSFORM_TOK_in_mainCommand2784	= { FOLLOW_TRANSFORM_TOK_in_mainCommand2784_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2786  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2786	= { FOLLOW_formula_in_mainCommand2786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TOK_in_mainCommand2800  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TOK_in_mainCommand2800_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TOK_in_mainCommand2800	= { FOLLOW_PRINT_TOK_in_mainCommand2800_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2802  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2802	= { FOLLOW_formula_in_mainCommand2802_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TYPE_TOK_in_mainCommand2815  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TYPE_TOK_in_mainCommand2815_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TYPE_TOK_in_mainCommand2815	= { FOLLOW_PRINT_TYPE_TOK_in_mainCommand2815_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2817  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2817	= { FOLLOW_type_in_mainCommand2817_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CALL_TOK_in_mainCommand2831  */
static	ANTLR3_BITWORD FOLLOW_CALL_TOK_in_mainCommand2831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CALL_TOK_in_mainCommand2831	= { FOLLOW_CALL_TOK_in_mainCommand2831_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2833  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2833_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2833	= { FOLLOW_identifier_in_mainCommand2833_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2836  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2836_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2836	= { FOLLOW_formula_in_mainCommand2836_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_mainCommand2850  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_mainCommand2850_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008002), ANTLR3_UINT64_LIT(0x8001030000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_mainCommand2850	= { FOLLOW_ECHO_TOK_in_mainCommand2850_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_mainCommand2858  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_mainCommand2858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_mainCommand2858	= { FOLLOW_simpleSymbolicExpr_in_mainCommand2858_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_mainCommand2888  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_mainCommand2888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_mainCommand2888	= { FOLLOW_EXIT_TOK_in_mainCommand2888_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_mainCommand2901  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_mainCommand2901_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000020000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_mainCommand2901	= { FOLLOW_INCLUDE_TOK_in_mainCommand2901_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2911  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2911	= { FOLLOW_str_in_mainCommand2911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2916  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2916	= { FOLLOW_IDENTIFIER_in_mainCommand2916_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_PROOF_TOK_in_mainCommand2949  */
static	ANTLR3_BITWORD FOLLOW_DUMP_PROOF_TOK_in_mainCommand2949_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_PROOF_TOK_in_mainCommand2949	= { FOLLOW_DUMP_PROOF_TOK_in_mainCommand2949_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2962  */
static	ANTLR3_BITWORD FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2962_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2962	= { FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2962_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand2975  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand2975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand2975	= { FOLLOW_set_in_mainCommand2975_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand3046  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand3046_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand3046	= { FOLLOW_set_in_mainCommand3046_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3071  */
static	ANTLR3_BITWORD FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3071	= { FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTERMODEL_TOK_in_mainCommand3083  */
static	ANTLR3_BITWORD FOLLOW_COUNTERMODEL_TOK_in_mainCommand3083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTERMODEL_TOK_in_mainCommand3083	= { FOLLOW_COUNTERMODEL_TOK_in_mainCommand3083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3096  */
static	ANTLR3_BITWORD FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3096_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3096	= { FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3096_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_mainCommand3098  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_mainCommand3098_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_mainCommand3098	= { FOLLOW_LPAREN_in_mainCommand3098_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3100  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3100_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3100	= { FOLLOW_formula_in_mainCommand3100_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3105  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3105_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3105	= { FOLLOW_COMMA_in_mainCommand3105_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3107  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3107_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3107	= { FOLLOW_formula_in_mainCommand3107_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_mainCommand3113  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_mainCommand3113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_mainCommand3113	= { FOLLOW_RPAREN_in_mainCommand3113_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTINUE_TOK_in_mainCommand3126  */
static	ANTLR3_BITWORD FOLLOW_CONTINUE_TOK_in_mainCommand3126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTINUE_TOK_in_mainCommand3126	= { FOLLOW_CONTINUE_TOK_in_mainCommand3126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESTART_TOK_in_mainCommand3138  */
static	ANTLR3_BITWORD FOLLOW_RESTART_TOK_in_mainCommand3138_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_RESTART_TOK_in_mainCommand3138	= { FOLLOW_RESTART_TOK_in_mainCommand3138_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3140  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3140_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3140	= { FOLLOW_formula_in_mainCommand3140_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3149  */
static	ANTLR3_BITWORD FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3149	= { FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3149_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand3152  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand3152_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand3152	= { FOLLOW_identifier_in_mainCommand3152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand3166  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand3166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand3166	= { FOLLOW_COLON_in_mainCommand3166_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand3168  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand3168_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000020000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand3168	= { FOLLOW_type_in_mainCommand3168_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3172  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3172	= { FOLLOW_COMMA_in_mainCommand3172_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand3191  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand3191_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand3191	= { FOLLOW_EQUAL_TOK_in_mainCommand3191_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand3194  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand3194_bits[]	= { ANTLR3_UINT64_LIT(0x4021FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand3194	= { FOLLOW_formula_in_mainCommand3194_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand3208  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand3208_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C112), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand3208	= { FOLLOW_COMMA_in_mainCommand3208_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_toplevelDeclaration_in_mainCommand3231  */
static	ANTLR3_BITWORD FOLLOW_toplevelDeclaration_in_mainCommand3231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_toplevelDeclaration_in_mainCommand3231	= { FOLLOW_toplevelDeclaration_in_mainCommand3231_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3251  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3251	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3251_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3263  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3263	= { FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3263_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3265  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3265	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3277  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3277	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3289  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3289_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3289	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3289_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3301  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3301	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3301_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExpr3313  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExpr3313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExpr3313	= { FOLLOW_str_in_simpleSymbolicExpr3313_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3326  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3326_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3326	= { FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3326_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3351  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3351	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3351_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_symbolicExpr3358  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_symbolicExpr3358_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0000004004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_symbolicExpr3358	= { FOLLOW_LPAREN_in_symbolicExpr3358_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3361  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3361_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000008000), ANTLR3_UINT64_LIT(0x9001030000000000), ANTLR3_UINT64_LIT(0x0000004004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3361	= { FOLLOW_symbolicExpr_in_symbolicExpr3361_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_symbolicExpr3369  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_symbolicExpr3369_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_symbolicExpr3369	= { FOLLOW_RPAREN_in_symbolicExpr3369_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_toplevelDeclaration3396  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_toplevelDeclaration3396_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_toplevelDeclaration3396	= { FOLLOW_identifierList_in_toplevelDeclaration3396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_toplevelDeclaration3399  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_toplevelDeclaration3399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0080500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_toplevelDeclaration3399	= { FOLLOW_COLON_in_toplevelDeclaration3399_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_toplevelDeclaration3407  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_toplevelDeclaration3407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_toplevelDeclaration3407	= { FOLLOW_declareVariables_in_toplevelDeclaration3407_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareTypes_in_toplevelDeclaration3416  */
static	ANTLR3_BITWORD FOLLOW_declareTypes_in_toplevelDeclaration3416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareTypes_in_toplevelDeclaration3416	= { FOLLOW_declareTypes_in_toplevelDeclaration3416_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDecl3440  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDecl3440_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDecl3440	= { FOLLOW_identifierList_in_boundVarDecl3440_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDecl3443  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDecl3443_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDecl3443	= { FOLLOW_COLON_in_boundVarDecl3443_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_boundVarDecl3449  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_boundVarDecl3449_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_boundVarDecl3449	= { FOLLOW_declareVariables_in_boundVarDecl3449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3470  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3470_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3470	= { FOLLOW_boundVarDecl_in_boundVarDecls3470_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDecls3475  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDecls3475_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDecls3475	= { FOLLOW_COMMA_in_boundVarDecls3475_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3477  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3477_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3477	= { FOLLOW_boundVarDecl_in_boundVarDecls3477_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3500  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3500_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3500	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3500_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDeclsReturn3505  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDeclsReturn3505_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDeclsReturn3505	= { FOLLOW_COMMA_in_boundVarDeclsReturn3505_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3507  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3507_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3507	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3507_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDeclReturn3530  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDeclReturn3530_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDeclReturn3530	= { FOLLOW_identifierList_in_boundVarDeclReturn3530_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDeclReturn3533  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDeclReturn3533_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDeclReturn3533	= { FOLLOW_COLON_in_boundVarDeclReturn3533_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_boundVarDeclReturn3535  */
static	ANTLR3_BITWORD FOLLOW_type_in_boundVarDeclReturn3535_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_boundVarDeclReturn3535	= { FOLLOW_type_in_boundVarDeclReturn3535_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3569  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3569_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3569	= { FOLLOW_TYPE_TOK_in_declareTypes3569_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3588  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3588	= { FOLLOW_TYPE_TOK_in_declareTypes3588_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareTypes3590  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareTypes3590_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareTypes3590	= { FOLLOW_EQUAL_TOK_in_declareTypes3590_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareTypes3592  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareTypes3592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareTypes3592	= { FOLLOW_type_in_declareTypes3592_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareVariables3626  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareVariables3626_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareVariables3626	= { FOLLOW_type_in_declareVariables3626_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareVariables3631  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareVariables3631_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareVariables3631	= { FOLLOW_EQUAL_TOK_in_declareVariables3631_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_declareVariables3633  */
static	ANTLR3_BITWORD FOLLOW_formula_in_declareVariables3633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_declareVariables3633	= { FOLLOW_formula_in_declareVariables3633_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3664  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3664_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3664	= { FOLLOW_identifier_in_identifierList3664_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_identifierList3675  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_identifierList3675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_identifierList3675	= { FOLLOW_COMMA_in_identifierList3675_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3677  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3677_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3677	= { FOLLOW_identifier_in_identifierList3677_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_identifier3699  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_identifier3699_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_identifier3699	= { FOLLOW_IDENTIFIER_in_identifier3699_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3732  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000202) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3732	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_TOK_in_type3747  */
static	ANTLR3_BITWORD FOLLOW_ARROW_TOK_in_type3747_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_TOK_in_type3747	= { FOLLOW_ARROW_TOK_in_type3747_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3749  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3749_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3749	= { FOLLOW_type_in_type3749_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_type3774  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_type3774_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_type3774	= { FOLLOW_LET_TOK_in_type3774_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3782  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3782_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3782	= { FOLLOW_typeLetDecl_in_type3782_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_type3787  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_type3787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_type3787	= { FOLLOW_COMMA_in_type3787_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3789  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3789_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3789	= { FOLLOW_typeLetDecl_in_type3789_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_type3795  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_type3795_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_type3795	= { FOLLOW_IN_TOK_in_type3795_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3797  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3797	= { FOLLOW_type_in_type3797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3833  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3833_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3833	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3833_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3867  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3867	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3867_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3874  */
static	ANTLR3_BITWORD FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3874_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3874	= { FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3874_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3895  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3895	= { FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3895_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3897  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3897_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3897	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3897_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3900  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3900	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3900_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3902  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3902	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3915  */
static	ANTLR3_BITWORD FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3915_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3915	= { FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3915_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3917  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3917_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3917	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3917_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3919  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3919_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3919	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3919_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3942  */
static	ANTLR3_BITWORD FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3942	= { FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3942_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3944  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3944_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3944	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3944_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3962  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3962_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3962	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3962_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3967  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3967_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3967	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3967_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3969  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3969	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3969_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3975  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3975	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3975_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3994  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3994	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3994_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3996  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3996	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3996_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3998  */
static	ANTLR3_BITWORD FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8001000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3998	= { FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3998_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4000  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4000	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4000_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4002  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4002_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4002	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4002_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4021  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4021_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060300000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4021	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4021_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4025  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4025_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4025	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4025_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4036  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4036_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4036	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4036_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4038  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4038_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4038	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4038_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4049  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4049_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4049	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4049_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4068  */
static	ANTLR3_BITWORD FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4068_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000022000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4068	= { FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4068_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4072  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4072_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4072	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4072_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4075  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4075	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4075_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4077  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4077_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4077	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4077_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4088  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4088_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4088	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4088_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4090  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4090_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4090	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4090_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4093  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4093	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4093_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4095  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4095_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4095	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4095_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4106  */
static	ANTLR3_BITWORD FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4106	= { FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4106_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4125  */
static	ANTLR3_BITWORD FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4125	= { FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4125_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4127  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4127	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4127_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4131  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4131_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4131	= { FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4131_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4133  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4133	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4133_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4152  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4152	= { FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4167  */
static	ANTLR3_BITWORD FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4167	= { FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4175  */
static	ANTLR3_BITWORD FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4175	= { FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4175_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4183  */
static	ANTLR3_BITWORD FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4183	= { FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4183_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4198  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4198_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4198	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4198_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4200  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4200_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4200	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4200_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4211  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4211	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4211_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4213  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4213_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4213	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4213_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4221  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4221	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4221_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_parameterization4246  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_parameterization4246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_parameterization4246	= { FOLLOW_LBRACKET_in_parameterization4246_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4248  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4248_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4248	= { FOLLOW_restrictedType_in_parameterization4248_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_parameterization4259  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_parameterization4259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_parameterization4259	= { FOLLOW_COMMA_in_parameterization4259_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization4261  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization4261_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization4261	= { FOLLOW_restrictedType_in_parameterization4261_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_parameterization4269  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_parameterization4269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_parameterization4269	= { FOLLOW_RBRACKET_in_parameterization4269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNDERSCORE_in_bound4282  */
static	ANTLR3_BITWORD FOLLOW_UNDERSCORE_in_bound4282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNDERSCORE_in_bound4282	= { FOLLOW_UNDERSCORE_in_bound4282_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_bound4288  */
static	ANTLR3_BITWORD FOLLOW_integer_in_bound4288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_bound4288	= { FOLLOW_integer_in_bound4288_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_typeLetDecl4305  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_typeLetDecl4305_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_typeLetDecl4305	= { FOLLOW_identifier_in_typeLetDecl4305_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeLetDecl4309  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeLetDecl4309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0080000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeLetDecl4309	= { FOLLOW_COLON_in_typeLetDecl4309_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_typeLetDecl4311  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_typeLetDecl4311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_typeLetDecl4311	= { FOLLOW_TYPE_TOK_in_typeLetDecl4311_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_typeLetDecl4315  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_typeLetDecl4315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_typeLetDecl4315	= { FOLLOW_EQUAL_TOK_in_typeLetDecl4315_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_typeLetDecl4317  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_typeLetDecl4317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_typeLetDecl4317	= { FOLLOW_restrictedType_in_typeLetDecl4317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_formula4347  */
static	ANTLR3_BITWORD FOLLOW_nots_in_formula4347_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_formula4347	= { FOLLOW_nots_in_formula4347_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_formula4355  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_formula4355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_formula4355	= { FOLLOW_prefixFormula_in_formula4355_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_formula4372  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_formula4372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0030280000000000), ANTLR3_UINT64_LIT(0x4000000000008020) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_formula4372	= { FOLLOW_comparison_in_formula4372_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_formula4389  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_formula4389_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_formula4389	= { FOLLOW_morecomparisons_in_formula4389_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_booleanBinop_in_morecomparisons4428  */
static	ANTLR3_BITWORD FOLLOW_booleanBinop_in_morecomparisons4428_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_booleanBinop_in_morecomparisons4428	= { FOLLOW_booleanBinop_in_morecomparisons4428_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_morecomparisons4439  */
static	ANTLR3_BITWORD FOLLOW_nots_in_morecomparisons4439_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_morecomparisons4439	= { FOLLOW_nots_in_morecomparisons4439_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_morecomparisons4447  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_morecomparisons4447_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_morecomparisons4447	= { FOLLOW_prefixFormula_in_morecomparisons4447_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_morecomparisons4464  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_morecomparisons4464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x0030280000000000), ANTLR3_UINT64_LIT(0x4000000000008020) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_morecomparisons4464	= { FOLLOW_comparison_in_morecomparisons4464_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_morecomparisons4481  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_morecomparisons4481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_morecomparisons4481	= { FOLLOW_morecomparisons_in_morecomparisons4481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_nots4510  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_nots4510_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_nots4510	= { FOLLOW_NOT_TOK_in_nots4510_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_prefixFormula4542  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_prefixFormula4542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_prefixFormula4542	= { FOLLOW_FORALL_TOK_in_prefixFormula4542_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_prefixFormula4548  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_prefixFormula4548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_prefixFormula4548	= { FOLLOW_EXISTS_TOK_in_prefixFormula4548_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4560  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4560_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4560	= { FOLLOW_LPAREN_in_prefixFormula4560_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4566  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4566_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4566	= { FOLLOW_boundVarDecl_in_prefixFormula4566_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4581  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4581_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4581	= { FOLLOW_COMMA_in_prefixFormula4581_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4583  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4583_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4583	= { FOLLOW_boundVarDecl_in_prefixFormula4583_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4601  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4601_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4601	= { FOLLOW_RPAREN_in_prefixFormula4601_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4609  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4609_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF100000C2) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4609	= { FOLLOW_COLON_in_prefixFormula4609_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_instantiationPatterns_in_prefixFormula4611  */
static	ANTLR3_BITWORD FOLLOW_instantiationPatterns_in_prefixFormula4611_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_instantiationPatterns_in_prefixFormula4611	= { FOLLOW_instantiationPatterns_in_prefixFormula4611_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4615  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4615	= { FOLLOW_formula_in_prefixFormula4615_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_prefixFormula4634  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_prefixFormula4634_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_prefixFormula4634	= { FOLLOW_LET_TOK_in_prefixFormula4634_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4642  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4642_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4642	= { FOLLOW_letDecl_in_prefixFormula4642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4646  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4646	= { FOLLOW_COMMA_in_prefixFormula4646_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4648  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4648_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4648	= { FOLLOW_letDecl_in_prefixFormula4648_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_prefixFormula4657  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_prefixFormula4657_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_prefixFormula4657	= { FOLLOW_IN_TOK_in_prefixFormula4657_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4659  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4659_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4659	= { FOLLOW_formula_in_prefixFormula4659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LAMBDA_TOK_in_prefixFormula4674  */
static	ANTLR3_BITWORD FOLLOW_LAMBDA_TOK_in_prefixFormula4674_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LAMBDA_TOK_in_prefixFormula4674	= { FOLLOW_LAMBDA_TOK_in_prefixFormula4674_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4678  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4678	= { FOLLOW_LPAREN_in_prefixFormula4678_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclsReturn_in_prefixFormula4684  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclsReturn_in_prefixFormula4684_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclsReturn_in_prefixFormula4684	= { FOLLOW_boundVarDeclsReturn_in_prefixFormula4684_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4691  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4691_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4691	= { FOLLOW_RPAREN_in_prefixFormula4691_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4693  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4693_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4693	= { FOLLOW_COLON_in_prefixFormula4693_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4695  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4695	= { FOLLOW_formula_in_prefixFormula4695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PATTERN_TOK_in_instantiationPatterns4723  */
static	ANTLR3_BITWORD FOLLOW_PATTERN_TOK_in_instantiationPatterns4723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PATTERN_TOK_in_instantiationPatterns4723	= { FOLLOW_PATTERN_TOK_in_instantiationPatterns4723_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_instantiationPatterns4725  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_instantiationPatterns4725_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_instantiationPatterns4725	= { FOLLOW_LPAREN_in_instantiationPatterns4725_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4727  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4727_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4727	= { FOLLOW_formula_in_instantiationPatterns4727_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_instantiationPatterns4733  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_instantiationPatterns4733_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_instantiationPatterns4733	= { FOLLOW_COMMA_in_instantiationPatterns4733_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4735  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4735_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4735	= { FOLLOW_formula_in_instantiationPatterns4735_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_instantiationPatterns4743  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_instantiationPatterns4743_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_instantiationPatterns4743	= { FOLLOW_RPAREN_in_instantiationPatterns4743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_instantiationPatterns4745  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_instantiationPatterns4745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_instantiationPatterns4745	= { FOLLOW_COLON_in_instantiationPatterns4745_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_letDecl4782  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_letDecl4782_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_letDecl4782	= { FOLLOW_identifier_in_letDecl4782_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_letDecl4785  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_letDecl4785_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_letDecl4785	= { FOLLOW_EQUAL_TOK_in_letDecl4785_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_letDecl4787  */
static	ANTLR3_BITWORD FOLLOW_formula_in_letDecl4787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_letDecl4787	= { FOLLOW_formula_in_letDecl4787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4876  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4876	= { FOLLOW_term_in_comparison4876_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparisonBinop_in_comparison4887  */
static	ANTLR3_BITWORD FOLLOW_comparisonBinop_in_comparison4887_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_comparisonBinop_in_comparison4887	= { FOLLOW_comparisonBinop_in_comparison4887_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4890  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4890_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x6400000848100001) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4890	= { FOLLOW_term_in_comparison4890_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5045  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x2000000080000101) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5045	= { FOLLOW_uminusTerm_in_term5045_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WITH_TOK_in_term5054  */
static	ANTLR3_BITWORD FOLLOW_WITH_TOK_in_term5054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_WITH_TOK_in_term5054	= { FOLLOW_WITH_TOK_in_term5054_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5064  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5064_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5064	= { FOLLOW_arrayStore_in_term5064_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5069  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5069	= { FOLLOW_COMMA_in_term5069_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_term5071  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_term5071_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_term5071	= { FOLLOW_arrayStore_in_term5071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5085  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5085_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5085	= { FOLLOW_DOT_in_term5085_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5089  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5089_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5089	= { FOLLOW_tupleStore_in_term5089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5094  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5094_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5094	= { FOLLOW_COMMA_in_term5094_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5096  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5096_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5096	= { FOLLOW_DOT_in_term5096_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_term5098  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_term5098_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_term5098	= { FOLLOW_tupleStore_in_term5098_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5118  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5118_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5118	= { FOLLOW_recordStore_in_term5118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_term5123  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_term5123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_term5123	= { FOLLOW_COMMA_in_term5123_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_term5125  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_term5125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_term5125	= { FOLLOW_DOT_in_term5125_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_term5127  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_term5127_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_term5127	= { FOLLOW_recordStore_in_term5127_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arithmeticBinop_in_term5153  */
static	ANTLR3_BITWORD FOLLOW_arithmeticBinop_in_term5153_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_arithmeticBinop_in_term5153	= { FOLLOW_arithmeticBinop_in_term5153_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_term5156  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_term5156_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x8000800001000008), ANTLR3_UINT64_LIT(0x0000000080000101) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_term5156	= { FOLLOW_uminusTerm_in_term5156_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_arrayStore5197  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_arrayStore5197_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_arrayStore5197	= { FOLLOW_LBRACKET_in_arrayStore5197_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_arrayStore5199  */
static	ANTLR3_BITWORD FOLLOW_formula_in_arrayStore5199_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_arrayStore5199	= { FOLLOW_formula_in_arrayStore5199_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_arrayStore5202  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_arrayStore5202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_arrayStore5202	= { FOLLOW_RBRACKET_in_arrayStore5202_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_arrayStore5218  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_arrayStore5218_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_arrayStore5218	= { FOLLOW_arrayStore_in_arrayStore5218_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_arrayStore5229  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_arrayStore5229_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_arrayStore5229	= { FOLLOW_DOT_in_arrayStore5229_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_arrayStore5233  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_arrayStore5233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_arrayStore5233	= { FOLLOW_tupleStore_in_arrayStore5233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_arrayStore5250  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_arrayStore5250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_arrayStore5250	= { FOLLOW_recordStore_in_arrayStore5250_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_arrayStore5263  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_arrayStore5263_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_arrayStore5263	= { FOLLOW_ASSIGN_TOK_in_arrayStore5263_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_arrayStore5265  */
static	ANTLR3_BITWORD FOLLOW_term_in_arrayStore5265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_arrayStore5265	= { FOLLOW_term_in_arrayStore5265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_tupleStore5297  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_tupleStore5297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_tupleStore5297	= { FOLLOW_numeral_in_tupleStore5297_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_tupleStore5313  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_tupleStore5313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_tupleStore5313	= { FOLLOW_arrayStore_in_tupleStore5313_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_tupleStore5324  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_tupleStore5324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_tupleStore5324	= { FOLLOW_DOT_in_tupleStore5324_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_tupleStore5328  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_tupleStore5328_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_tupleStore5328	= { FOLLOW_tupleStore_in_tupleStore5328_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_tupleStore5345  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_tupleStore5345_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_tupleStore5345	= { FOLLOW_recordStore_in_tupleStore5345_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_tupleStore5358  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_tupleStore5358_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_tupleStore5358	= { FOLLOW_ASSIGN_TOK_in_tupleStore5358_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_tupleStore5360  */
static	ANTLR3_BITWORD FOLLOW_term_in_tupleStore5360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_tupleStore5360	= { FOLLOW_term_in_tupleStore5360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordStore5390  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordStore5390_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0100000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordStore5390	= { FOLLOW_identifier_in_recordStore5390_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_recordStore5407  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_recordStore5407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_recordStore5407	= { FOLLOW_arrayStore_in_recordStore5407_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_recordStore5418  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_recordStore5418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_recordStore5418	= { FOLLOW_DOT_in_recordStore5418_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_recordStore5422  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_recordStore5422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_recordStore5422	= { FOLLOW_tupleStore_in_recordStore5422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_recordStore5439  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_recordStore5439_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_recordStore5439	= { FOLLOW_recordStore_in_recordStore5439_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordStore5452  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordStore5452_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordStore5452	= { FOLLOW_ASSIGN_TOK_in_recordStore5452_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_recordStore5454  */
static	ANTLR3_BITWORD FOLLOW_term_in_recordStore5454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_recordStore5454	= { FOLLOW_term_in_recordStore5454_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_uminusTerm5491  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_uminusTerm5491_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x9089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_uminusTerm5491	= { FOLLOW_MINUS_TOK_in_uminusTerm5491_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm5497  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm5497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm5497	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm5497_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm5510  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm5510_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm5510	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm5510_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5532  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5532_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5532	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5532_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinop_in_bvBinaryOpTerm5543  */
static	ANTLR3_BITWORD FOLLOW_bvBinop_in_bvBinaryOpTerm5543_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinop_in_bvBinaryOpTerm5543	= { FOLLOW_bvBinop_in_bvBinaryOpTerm5543_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5546  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5546_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5546	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5546_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNEG_TOK_in_bvNegTerm5609  */
static	ANTLR3_BITWORD FOLLOW_BVNEG_TOK_in_bvNegTerm5609_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNEG_TOK_in_bvNegTerm5609	= { FOLLOW_BVNEG_TOK_in_bvNegTerm5609_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvNegTerm5611  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvNegTerm5611_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvNegTerm5611	= { FOLLOW_bvNegTerm_in_bvNegTerm5611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_bvNegTerm5624  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_bvNegTerm5624_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_bvNegTerm5624	= { FOLLOW_relationTerm_in_bvNegTerm5624_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSPOSE_TOK_in_relationTerm5645  */
static	ANTLR3_BITWORD FOLLOW_TRANSPOSE_TOK_in_relationTerm5645_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSPOSE_TOK_in_relationTerm5645	= { FOLLOW_TRANSPOSE_TOK_in_relationTerm5645_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5647  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5647	= { FOLLOW_relationTerm_in_relationTerm5647_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5661  */
static	ANTLR3_BITWORD FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5661_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5661	= { FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5661_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5663  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5663_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5663	= { FOLLOW_relationTerm_in_relationTerm5663_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_TOK_in_relationTerm5676  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_TOK_in_relationTerm5676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_TOK_in_relationTerm5676	= { FOLLOW_TUPLE_TOK_in_relationTerm5676_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_relationTerm5678  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_relationTerm5678_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_relationTerm5678	= { FOLLOW_LPAREN_in_relationTerm5678_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5680  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5680	= { FOLLOW_relationTerm_in_relationTerm5680_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_relationTerm5683  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_relationTerm5683_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_relationTerm5683	= { FOLLOW_RPAREN_in_relationTerm5683_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDEN_TOK_in_relationTerm5695  */
static	ANTLR3_BITWORD FOLLOW_IDEN_TOK_in_relationTerm5695_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFEFF8C110), ANTLR3_UINT64_LIT(0x1089170006000006), ANTLR3_UINT64_LIT(0x02748FFF10000040) };
static  ANTLR3_BITSET_LIST FOLLOW_IDEN_TOK_in_relationTerm5695	= { FOLLOW_IDEN_TOK_in_relationTerm5695_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_relationTerm_in_relationTerm5697  */
static	ANTLR3_BITWORD FOLLOW_relationTerm_in_relationTerm5697_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_relationTerm_in_relationTerm5697	= { FOLLOW_relationTerm_in_relationTerm5697_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_postfixTerm_in_relationTerm5727  */
static	ANTLR3_BITWORD FOLLOW_postfixTerm_in_relationTerm5727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_postfixTerm_in_relationTerm5727	= { FOLLOW_postfixTerm_in_relationTerm5727_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvTerm_in_postfixTerm5751  */
static	ANTLR3_BITWORD FOLLOW_bvTerm_in_postfixTerm5751_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_bvTerm_in_postfixTerm5751	= { FOLLOW_bvTerm_in_postfixTerm5751_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_postfixTerm5768  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_postfixTerm5768_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_postfixTerm5768	= { FOLLOW_LBRACKET_in_postfixTerm5768_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5780  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5780_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5780	= { FOLLOW_formula_in_postfixTerm5780_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5797  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5797_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5797	= { FOLLOW_numeral_in_postfixTerm5797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_postfixTerm5799  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_postfixTerm5799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_postfixTerm5799	= { FOLLOW_COLON_in_postfixTerm5799_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5803  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5803_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5803	= { FOLLOW_numeral_in_postfixTerm5803_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_postfixTerm5815  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_postfixTerm5815_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_postfixTerm5815	= { FOLLOW_RBRACKET_in_postfixTerm5815_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5841  */
static	ANTLR3_BITWORD FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5841_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5841	= { FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5841_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5853  */
static	ANTLR3_BITWORD FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5853_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5853	= { FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5853_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5861  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5861_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5861	= { FOLLOW_numeral_in_postfixTerm5861_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5886  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5886_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5886	= { FOLLOW_LPAREN_in_postfixTerm5886_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5896  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5896_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5896	= { FOLLOW_formula_in_postfixTerm5896_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5909  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5909_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5909	= { FOLLOW_COMMA_in_postfixTerm5909_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5911  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5911_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5911	= { FOLLOW_formula_in_postfixTerm5911_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5919  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5919_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5919	= { FOLLOW_RPAREN_in_postfixTerm5919_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_postfixTerm5951  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_postfixTerm5951_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_postfixTerm5951	= { FOLLOW_DOT_in_postfixTerm5951_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_postfixTerm5961  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_postfixTerm5961_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_postfixTerm5961	= { FOLLOW_identifier_in_postfixTerm5961_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5984  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5984_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x1300000000000010), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5984	= { FOLLOW_numeral_in_postfixTerm5984_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FLOOR_TOK_in_postfixTerm6017  */
static	ANTLR3_BITWORD FOLLOW_FLOOR_TOK_in_postfixTerm6017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FLOOR_TOK_in_postfixTerm6017	= { FOLLOW_FLOOR_TOK_in_postfixTerm6017_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6019  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6019_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6019	= { FOLLOW_LPAREN_in_postfixTerm6019_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6021  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6021_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6021	= { FOLLOW_formula_in_postfixTerm6021_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6024  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6024_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6024	= { FOLLOW_RPAREN_in_postfixTerm6024_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_INTEGER_TOK_in_postfixTerm6040  */
static	ANTLR3_BITWORD FOLLOW_IS_INTEGER_TOK_in_postfixTerm6040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_INTEGER_TOK_in_postfixTerm6040	= { FOLLOW_IS_INTEGER_TOK_in_postfixTerm6040_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6042  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6042_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6042	= { FOLLOW_LPAREN_in_postfixTerm6042_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6044  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6044_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6044	= { FOLLOW_formula_in_postfixTerm6044_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6047  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6047_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6047	= { FOLLOW_RPAREN_in_postfixTerm6047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ABS_TOK_in_postfixTerm6063  */
static	ANTLR3_BITWORD FOLLOW_ABS_TOK_in_postfixTerm6063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ABS_TOK_in_postfixTerm6063	= { FOLLOW_ABS_TOK_in_postfixTerm6063_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6065  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6065_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6065	= { FOLLOW_LPAREN_in_postfixTerm6065_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6067  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6067	= { FOLLOW_formula_in_postfixTerm6067_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6070  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6070_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6070	= { FOLLOW_RPAREN_in_postfixTerm6070_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_postfixTerm6086  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_postfixTerm6086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_postfixTerm6086	= { FOLLOW_DIVISIBLE_TOK_in_postfixTerm6086_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6088  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6088_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6088	= { FOLLOW_LPAREN_in_postfixTerm6088_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6090  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6090_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6090	= { FOLLOW_formula_in_postfixTerm6090_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6093  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6093	= { FOLLOW_COMMA_in_postfixTerm6093_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm6097  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm6097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm6097	= { FOLLOW_numeral_in_postfixTerm6097_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6099  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6099_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6099	= { FOLLOW_RPAREN_in_postfixTerm6099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_postfixTerm6115  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_postfixTerm6115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_postfixTerm6115	= { FOLLOW_DISTINCT_TOK_in_postfixTerm6115_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm6117  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm6117_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm6117	= { FOLLOW_LPAREN_in_postfixTerm6117_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6125  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6125_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6125	= { FOLLOW_formula_in_postfixTerm6125_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm6138  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm6138_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm6138	= { FOLLOW_COMMA_in_postfixTerm6138_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm6140  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm6140_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm6140	= { FOLLOW_formula_in_postfixTerm6140_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm6148  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm6148_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm6148	= { FOLLOW_RPAREN_in_postfixTerm6148_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeAscription_in_postfixTerm6170  */
static	ANTLR3_BITWORD FOLLOW_typeAscription_in_postfixTerm6170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeAscription_in_postfixTerm6170	= { FOLLOW_typeAscription_in_postfixTerm6170_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXOR_TOK_in_bvTerm6211  */
static	ANTLR3_BITWORD FOLLOW_BVXOR_TOK_in_bvTerm6211_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXOR_TOK_in_bvTerm6211	= { FOLLOW_BVXOR_TOK_in_bvTerm6211_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6213  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6213_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6213	= { FOLLOW_LPAREN_in_bvTerm6213_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6215  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6215_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6215	= { FOLLOW_formula_in_bvTerm6215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6218  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6218_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6218	= { FOLLOW_COMMA_in_bvTerm6218_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6220  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6220	= { FOLLOW_formula_in_bvTerm6220_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6223  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6223_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6223	= { FOLLOW_RPAREN_in_bvTerm6223_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNAND_TOK_in_bvTerm6235  */
static	ANTLR3_BITWORD FOLLOW_BVNAND_TOK_in_bvTerm6235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNAND_TOK_in_bvTerm6235	= { FOLLOW_BVNAND_TOK_in_bvTerm6235_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6237  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6237_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6237	= { FOLLOW_LPAREN_in_bvTerm6237_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6239  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6239_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6239	= { FOLLOW_formula_in_bvTerm6239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6242  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6242_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6242	= { FOLLOW_COMMA_in_bvTerm6242_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6244  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6244	= { FOLLOW_formula_in_bvTerm6244_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6247  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6247	= { FOLLOW_RPAREN_in_bvTerm6247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOR_TOK_in_bvTerm6259  */
static	ANTLR3_BITWORD FOLLOW_BVNOR_TOK_in_bvTerm6259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOR_TOK_in_bvTerm6259	= { FOLLOW_BVNOR_TOK_in_bvTerm6259_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6261  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6261_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6261	= { FOLLOW_LPAREN_in_bvTerm6261_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6263  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6263_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6263	= { FOLLOW_formula_in_bvTerm6263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6266  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6266_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6266	= { FOLLOW_COMMA_in_bvTerm6266_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6268  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6268	= { FOLLOW_formula_in_bvTerm6268_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6271  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6271	= { FOLLOW_RPAREN_in_bvTerm6271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVCOMP_TOK_in_bvTerm6283  */
static	ANTLR3_BITWORD FOLLOW_BVCOMP_TOK_in_bvTerm6283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVCOMP_TOK_in_bvTerm6283	= { FOLLOW_BVCOMP_TOK_in_bvTerm6283_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6285  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6285_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6285	= { FOLLOW_LPAREN_in_bvTerm6285_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6287  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6287_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6287	= { FOLLOW_formula_in_bvTerm6287_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6290  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6290_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6290	= { FOLLOW_COMMA_in_bvTerm6290_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6292  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6292	= { FOLLOW_formula_in_bvTerm6292_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6295  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6295	= { FOLLOW_RPAREN_in_bvTerm6295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXNOR_TOK_in_bvTerm6307  */
static	ANTLR3_BITWORD FOLLOW_BVXNOR_TOK_in_bvTerm6307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXNOR_TOK_in_bvTerm6307	= { FOLLOW_BVXNOR_TOK_in_bvTerm6307_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6309  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6309_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6309	= { FOLLOW_LPAREN_in_bvTerm6309_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6311  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6311_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6311	= { FOLLOW_formula_in_bvTerm6311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6314  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6314_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6314	= { FOLLOW_COMMA_in_bvTerm6314_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6316  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6316_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6316	= { FOLLOW_formula_in_bvTerm6316_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6319  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6319	= { FOLLOW_RPAREN_in_bvTerm6319_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUMINUS_TOK_in_bvTerm6338  */
static	ANTLR3_BITWORD FOLLOW_BVUMINUS_TOK_in_bvTerm6338_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUMINUS_TOK_in_bvTerm6338	= { FOLLOW_BVUMINUS_TOK_in_bvTerm6338_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6340  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6340_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6340	= { FOLLOW_LPAREN_in_bvTerm6340_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6342  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6342_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6342	= { FOLLOW_formula_in_bvTerm6342_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6345  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6345_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6345	= { FOLLOW_RPAREN_in_bvTerm6345_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVPLUS_TOK_in_bvTerm6363  */
static	ANTLR3_BITWORD FOLLOW_BVPLUS_TOK_in_bvTerm6363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVPLUS_TOK_in_bvTerm6363	= { FOLLOW_BVPLUS_TOK_in_bvTerm6363_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6365  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6365_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6365	= { FOLLOW_LPAREN_in_bvTerm6365_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6369  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6369_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6369	= { FOLLOW_numeral_in_bvTerm6369_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6371  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6371_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6371	= { FOLLOW_COMMA_in_bvTerm6371_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6373  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6373_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6373	= { FOLLOW_formula_in_bvTerm6373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6384  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6384_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6384	= { FOLLOW_COMMA_in_bvTerm6384_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6386  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6386_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6386	= { FOLLOW_formula_in_bvTerm6386_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6394  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6394_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6394	= { FOLLOW_RPAREN_in_bvTerm6394_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSUB_TOK_in_bvTerm6412  */
static	ANTLR3_BITWORD FOLLOW_BVSUB_TOK_in_bvTerm6412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSUB_TOK_in_bvTerm6412	= { FOLLOW_BVSUB_TOK_in_bvTerm6412_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6414  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6414_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6414	= { FOLLOW_LPAREN_in_bvTerm6414_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6418  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6418_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6418	= { FOLLOW_numeral_in_bvTerm6418_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6420  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6420_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6420	= { FOLLOW_COMMA_in_bvTerm6420_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6422  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6422_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6422	= { FOLLOW_formula_in_bvTerm6422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6425  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6425_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6425	= { FOLLOW_COMMA_in_bvTerm6425_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6427  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6427_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6427	= { FOLLOW_formula_in_bvTerm6427_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6430  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6430	= { FOLLOW_RPAREN_in_bvTerm6430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVMULT_TOK_in_bvTerm6448  */
static	ANTLR3_BITWORD FOLLOW_BVMULT_TOK_in_bvTerm6448_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVMULT_TOK_in_bvTerm6448	= { FOLLOW_BVMULT_TOK_in_bvTerm6448_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6450  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6450_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6450	= { FOLLOW_LPAREN_in_bvTerm6450_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6454  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6454_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6454	= { FOLLOW_numeral_in_bvTerm6454_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6456  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6456_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6456	= { FOLLOW_COMMA_in_bvTerm6456_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6458  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6458_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6458	= { FOLLOW_formula_in_bvTerm6458_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6461  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6461_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6461	= { FOLLOW_COMMA_in_bvTerm6461_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6463  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6463_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6463	= { FOLLOW_formula_in_bvTerm6463_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6466  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6466	= { FOLLOW_RPAREN_in_bvTerm6466_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUDIV_TOK_in_bvTerm6484  */
static	ANTLR3_BITWORD FOLLOW_BVUDIV_TOK_in_bvTerm6484_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUDIV_TOK_in_bvTerm6484	= { FOLLOW_BVUDIV_TOK_in_bvTerm6484_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6486  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6486_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6486	= { FOLLOW_LPAREN_in_bvTerm6486_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6488  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6488_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6488	= { FOLLOW_formula_in_bvTerm6488_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6491  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6491_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6491	= { FOLLOW_COMMA_in_bvTerm6491_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6493  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6493_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6493	= { FOLLOW_formula_in_bvTerm6493_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6496  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6496_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6496	= { FOLLOW_RPAREN_in_bvTerm6496_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSDIV_TOK_in_bvTerm6514  */
static	ANTLR3_BITWORD FOLLOW_BVSDIV_TOK_in_bvTerm6514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSDIV_TOK_in_bvTerm6514	= { FOLLOW_BVSDIV_TOK_in_bvTerm6514_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6516  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6516_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6516	= { FOLLOW_LPAREN_in_bvTerm6516_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6518  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6518_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6518	= { FOLLOW_formula_in_bvTerm6518_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6521  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6521_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6521	= { FOLLOW_COMMA_in_bvTerm6521_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6523  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6523_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6523	= { FOLLOW_formula_in_bvTerm6523_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6526  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6526_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6526	= { FOLLOW_RPAREN_in_bvTerm6526_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUREM_TOK_in_bvTerm6544  */
static	ANTLR3_BITWORD FOLLOW_BVUREM_TOK_in_bvTerm6544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUREM_TOK_in_bvTerm6544	= { FOLLOW_BVUREM_TOK_in_bvTerm6544_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6546  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6546_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6546	= { FOLLOW_LPAREN_in_bvTerm6546_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6548  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6548_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6548	= { FOLLOW_formula_in_bvTerm6548_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6551  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6551_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6551	= { FOLLOW_COMMA_in_bvTerm6551_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6553  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6553_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6553	= { FOLLOW_formula_in_bvTerm6553_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6556  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6556_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6556	= { FOLLOW_RPAREN_in_bvTerm6556_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSREM_TOK_in_bvTerm6574  */
static	ANTLR3_BITWORD FOLLOW_BVSREM_TOK_in_bvTerm6574_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSREM_TOK_in_bvTerm6574	= { FOLLOW_BVSREM_TOK_in_bvTerm6574_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6576  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6576_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6576	= { FOLLOW_LPAREN_in_bvTerm6576_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6578  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6578_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6578	= { FOLLOW_formula_in_bvTerm6578_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6581  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6581_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6581	= { FOLLOW_COMMA_in_bvTerm6581_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6583  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6583	= { FOLLOW_formula_in_bvTerm6583_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6586  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6586	= { FOLLOW_RPAREN_in_bvTerm6586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSMOD_TOK_in_bvTerm6604  */
static	ANTLR3_BITWORD FOLLOW_BVSMOD_TOK_in_bvTerm6604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSMOD_TOK_in_bvTerm6604	= { FOLLOW_BVSMOD_TOK_in_bvTerm6604_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6606  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6606_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6606	= { FOLLOW_LPAREN_in_bvTerm6606_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6608  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6608_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6608	= { FOLLOW_formula_in_bvTerm6608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6611  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6611_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6611	= { FOLLOW_COMMA_in_bvTerm6611_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6613  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6613_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6613	= { FOLLOW_formula_in_bvTerm6613_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6616  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6616	= { FOLLOW_RPAREN_in_bvTerm6616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSHL_TOK_in_bvTerm6634  */
static	ANTLR3_BITWORD FOLLOW_BVSHL_TOK_in_bvTerm6634_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSHL_TOK_in_bvTerm6634	= { FOLLOW_BVSHL_TOK_in_bvTerm6634_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6636  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6636_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6636	= { FOLLOW_LPAREN_in_bvTerm6636_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6638  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6638_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6638	= { FOLLOW_formula_in_bvTerm6638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6641  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6641_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6641	= { FOLLOW_COMMA_in_bvTerm6641_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6643  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6643	= { FOLLOW_formula_in_bvTerm6643_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6646  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6646	= { FOLLOW_RPAREN_in_bvTerm6646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVASHR_TOK_in_bvTerm6664  */
static	ANTLR3_BITWORD FOLLOW_BVASHR_TOK_in_bvTerm6664_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVASHR_TOK_in_bvTerm6664	= { FOLLOW_BVASHR_TOK_in_bvTerm6664_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6666  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6666_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6666	= { FOLLOW_LPAREN_in_bvTerm6666_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6668  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6668_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6668	= { FOLLOW_formula_in_bvTerm6668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6671  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6671_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6671	= { FOLLOW_COMMA_in_bvTerm6671_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6673  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6673_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6673	= { FOLLOW_formula_in_bvTerm6673_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6676  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6676	= { FOLLOW_RPAREN_in_bvTerm6676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLSHR_TOK_in_bvTerm6694  */
static	ANTLR3_BITWORD FOLLOW_BVLSHR_TOK_in_bvTerm6694_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLSHR_TOK_in_bvTerm6694	= { FOLLOW_BVLSHR_TOK_in_bvTerm6694_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6696  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6696_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6696	= { FOLLOW_LPAREN_in_bvTerm6696_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6698  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6698_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6698	= { FOLLOW_formula_in_bvTerm6698_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6701  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6701_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6701	= { FOLLOW_COMMA_in_bvTerm6701_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6703  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6703_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6703	= { FOLLOW_formula_in_bvTerm6703_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6706  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6706_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6706	= { FOLLOW_RPAREN_in_bvTerm6706_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SX_TOK_in_bvTerm6724  */
static	ANTLR3_BITWORD FOLLOW_SX_TOK_in_bvTerm6724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SX_TOK_in_bvTerm6724	= { FOLLOW_SX_TOK_in_bvTerm6724_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6726  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6726_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6726	= { FOLLOW_LPAREN_in_bvTerm6726_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6728  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6728_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6728	= { FOLLOW_formula_in_bvTerm6728_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6731  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6731	= { FOLLOW_COMMA_in_bvTerm6731_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6735  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6735_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6735	= { FOLLOW_numeral_in_bvTerm6735_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6737  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6737	= { FOLLOW_RPAREN_in_bvTerm6737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6755  */
static	ANTLR3_BITWORD FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6755_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6755	= { FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6755_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6757  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6757_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6757	= { FOLLOW_LPAREN_in_bvTerm6757_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6759  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6759_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6759	= { FOLLOW_formula_in_bvTerm6759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6762  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6762_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6762	= { FOLLOW_COMMA_in_bvTerm6762_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6766  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6766_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6766	= { FOLLOW_numeral_in_bvTerm6766_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6768  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6768	= { FOLLOW_RPAREN_in_bvTerm6768_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVREPEAT_TOK_in_bvTerm6786  */
static	ANTLR3_BITWORD FOLLOW_BVREPEAT_TOK_in_bvTerm6786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVREPEAT_TOK_in_bvTerm6786	= { FOLLOW_BVREPEAT_TOK_in_bvTerm6786_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6788  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6788_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6788	= { FOLLOW_LPAREN_in_bvTerm6788_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6790  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6790_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6790	= { FOLLOW_formula_in_bvTerm6790_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6793  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6793	= { FOLLOW_COMMA_in_bvTerm6793_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6797  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6797	= { FOLLOW_numeral_in_bvTerm6797_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6799  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6799	= { FOLLOW_RPAREN_in_bvTerm6799_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTR_TOK_in_bvTerm6817  */
static	ANTLR3_BITWORD FOLLOW_BVROTR_TOK_in_bvTerm6817_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTR_TOK_in_bvTerm6817	= { FOLLOW_BVROTR_TOK_in_bvTerm6817_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6819  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6819_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6819	= { FOLLOW_LPAREN_in_bvTerm6819_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6821  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6821_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6821	= { FOLLOW_formula_in_bvTerm6821_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6824  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6824_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6824	= { FOLLOW_COMMA_in_bvTerm6824_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6828  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6828	= { FOLLOW_numeral_in_bvTerm6828_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6830  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6830	= { FOLLOW_RPAREN_in_bvTerm6830_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTL_TOK_in_bvTerm6848  */
static	ANTLR3_BITWORD FOLLOW_BVROTL_TOK_in_bvTerm6848_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTL_TOK_in_bvTerm6848	= { FOLLOW_BVROTL_TOK_in_bvTerm6848_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6850  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6850_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6850	= { FOLLOW_LPAREN_in_bvTerm6850_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6852  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6852_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6852	= { FOLLOW_formula_in_bvTerm6852_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6855  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6855_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6855	= { FOLLOW_COMMA_in_bvTerm6855_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6859  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6859	= { FOLLOW_numeral_in_bvTerm6859_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6861  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6861	= { FOLLOW_RPAREN_in_bvTerm6861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLT_TOK_in_bvTerm6880  */
static	ANTLR3_BITWORD FOLLOW_BVLT_TOK_in_bvTerm6880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLT_TOK_in_bvTerm6880	= { FOLLOW_BVLT_TOK_in_bvTerm6880_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6882  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6882_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6882	= { FOLLOW_LPAREN_in_bvTerm6882_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6884  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6884_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6884	= { FOLLOW_formula_in_bvTerm6884_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6887  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6887_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6887	= { FOLLOW_COMMA_in_bvTerm6887_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6889  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6889_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6889	= { FOLLOW_formula_in_bvTerm6889_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6892  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6892_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6892	= { FOLLOW_RPAREN_in_bvTerm6892_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLE_TOK_in_bvTerm6904  */
static	ANTLR3_BITWORD FOLLOW_BVLE_TOK_in_bvTerm6904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLE_TOK_in_bvTerm6904	= { FOLLOW_BVLE_TOK_in_bvTerm6904_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6906  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6906_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6906	= { FOLLOW_LPAREN_in_bvTerm6906_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6908  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6908_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6908	= { FOLLOW_formula_in_bvTerm6908_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6911  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6911_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6911	= { FOLLOW_COMMA_in_bvTerm6911_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6913  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6913	= { FOLLOW_formula_in_bvTerm6913_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6916  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6916	= { FOLLOW_RPAREN_in_bvTerm6916_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGT_TOK_in_bvTerm6928  */
static	ANTLR3_BITWORD FOLLOW_BVGT_TOK_in_bvTerm6928_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGT_TOK_in_bvTerm6928	= { FOLLOW_BVGT_TOK_in_bvTerm6928_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6930  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6930_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6930	= { FOLLOW_LPAREN_in_bvTerm6930_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6932  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6932_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6932	= { FOLLOW_formula_in_bvTerm6932_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6935  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6935_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6935	= { FOLLOW_COMMA_in_bvTerm6935_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6937  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6937	= { FOLLOW_formula_in_bvTerm6937_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6940  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6940_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6940	= { FOLLOW_RPAREN_in_bvTerm6940_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGE_TOK_in_bvTerm6952  */
static	ANTLR3_BITWORD FOLLOW_BVGE_TOK_in_bvTerm6952_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGE_TOK_in_bvTerm6952	= { FOLLOW_BVGE_TOK_in_bvTerm6952_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6954  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6954_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6954	= { FOLLOW_LPAREN_in_bvTerm6954_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6956  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6956_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6956	= { FOLLOW_formula_in_bvTerm6956_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6959  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6959_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6959	= { FOLLOW_COMMA_in_bvTerm6959_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6961  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6961_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6961	= { FOLLOW_formula_in_bvTerm6961_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6964  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6964	= { FOLLOW_RPAREN_in_bvTerm6964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLT_TOK_in_bvTerm6976  */
static	ANTLR3_BITWORD FOLLOW_BVSLT_TOK_in_bvTerm6976_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLT_TOK_in_bvTerm6976	= { FOLLOW_BVSLT_TOK_in_bvTerm6976_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6978  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6978_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6978	= { FOLLOW_LPAREN_in_bvTerm6978_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6980  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6980_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6980	= { FOLLOW_formula_in_bvTerm6980_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6983  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6983_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6983	= { FOLLOW_COMMA_in_bvTerm6983_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6985  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6985	= { FOLLOW_formula_in_bvTerm6985_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6988  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6988	= { FOLLOW_RPAREN_in_bvTerm6988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLE_TOK_in_bvTerm7000  */
static	ANTLR3_BITWORD FOLLOW_BVSLE_TOK_in_bvTerm7000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLE_TOK_in_bvTerm7000	= { FOLLOW_BVSLE_TOK_in_bvTerm7000_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7002  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7002_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7002	= { FOLLOW_LPAREN_in_bvTerm7002_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7004  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7004_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7004	= { FOLLOW_formula_in_bvTerm7004_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7007  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7007_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7007	= { FOLLOW_COMMA_in_bvTerm7007_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7009  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7009_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7009	= { FOLLOW_formula_in_bvTerm7009_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7012  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7012	= { FOLLOW_RPAREN_in_bvTerm7012_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGT_TOK_in_bvTerm7024  */
static	ANTLR3_BITWORD FOLLOW_BVSGT_TOK_in_bvTerm7024_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGT_TOK_in_bvTerm7024	= { FOLLOW_BVSGT_TOK_in_bvTerm7024_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7026  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7026_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7026	= { FOLLOW_LPAREN_in_bvTerm7026_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7028  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7028_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7028	= { FOLLOW_formula_in_bvTerm7028_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7031  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7031_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7031	= { FOLLOW_COMMA_in_bvTerm7031_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7033  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7033_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7033	= { FOLLOW_formula_in_bvTerm7033_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7036  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7036_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7036	= { FOLLOW_RPAREN_in_bvTerm7036_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGE_TOK_in_bvTerm7048  */
static	ANTLR3_BITWORD FOLLOW_BVSGE_TOK_in_bvTerm7048_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGE_TOK_in_bvTerm7048	= { FOLLOW_BVSGE_TOK_in_bvTerm7048_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm7050  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm7050_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm7050	= { FOLLOW_LPAREN_in_bvTerm7050_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7052  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7052_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7052	= { FOLLOW_formula_in_bvTerm7052_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm7055  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm7055_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm7055	= { FOLLOW_COMMA_in_bvTerm7055_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm7057  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm7057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm7057	= { FOLLOW_formula_in_bvTerm7057_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm7060  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm7060_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm7060	= { FOLLOW_RPAREN_in_bvTerm7060_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stringTerm_in_bvTerm7072  */
static	ANTLR3_BITWORD FOLLOW_stringTerm_in_bvTerm7072_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stringTerm_in_bvTerm7072	= { FOLLOW_stringTerm_in_bvTerm7072_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONCAT_TOK_in_stringTerm7098  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONCAT_TOK_in_stringTerm7098_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONCAT_TOK_in_stringTerm7098	= { FOLLOW_STRING_CONCAT_TOK_in_stringTerm7098_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7100  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7100_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7100	= { FOLLOW_LPAREN_in_stringTerm7100_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7102  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7102_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7102	= { FOLLOW_formula_in_stringTerm7102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7113  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7113_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7113	= { FOLLOW_COMMA_in_stringTerm7113_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7115  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7115_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7115	= { FOLLOW_formula_in_stringTerm7115_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7123  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7123	= { FOLLOW_RPAREN_in_stringTerm7123_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LENGTH_TOK_in_stringTerm7135  */
static	ANTLR3_BITWORD FOLLOW_STRING_LENGTH_TOK_in_stringTerm7135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LENGTH_TOK_in_stringTerm7135	= { FOLLOW_STRING_LENGTH_TOK_in_stringTerm7135_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7137  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7137_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7137	= { FOLLOW_LPAREN_in_stringTerm7137_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7139  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7139_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7139	= { FOLLOW_formula_in_stringTerm7139_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7142  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7142_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7142	= { FOLLOW_RPAREN_in_stringTerm7142_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7154  */
static	ANTLR3_BITWORD FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7154	= { FOLLOW_STRING_CONTAINS_TOK_in_stringTerm7154_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7156  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7156_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7156	= { FOLLOW_LPAREN_in_stringTerm7156_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7158  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7158_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7158	= { FOLLOW_formula_in_stringTerm7158_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7161  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7161_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7161	= { FOLLOW_COMMA_in_stringTerm7161_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7163  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7163	= { FOLLOW_formula_in_stringTerm7163_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7166  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7166	= { FOLLOW_RPAREN_in_stringTerm7166_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7178  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7178	= { FOLLOW_STRING_SUBSTR_TOK_in_stringTerm7178_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7180  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7180_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7180	= { FOLLOW_LPAREN_in_stringTerm7180_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7182  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7182_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7182	= { FOLLOW_formula_in_stringTerm7182_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7185  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7185_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7185	= { FOLLOW_COMMA_in_stringTerm7185_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7187  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7187_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7187	= { FOLLOW_formula_in_stringTerm7187_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7190  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7190_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7190	= { FOLLOW_COMMA_in_stringTerm7190_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7192  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7192_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7192	= { FOLLOW_formula_in_stringTerm7192_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7195  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7195_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7195	= { FOLLOW_RPAREN_in_stringTerm7195_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_CHARAT_TOK_in_stringTerm7207  */
static	ANTLR3_BITWORD FOLLOW_STRING_CHARAT_TOK_in_stringTerm7207_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_CHARAT_TOK_in_stringTerm7207	= { FOLLOW_STRING_CHARAT_TOK_in_stringTerm7207_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7209  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7209_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7209	= { FOLLOW_LPAREN_in_stringTerm7209_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7211  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7211_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7211	= { FOLLOW_formula_in_stringTerm7211_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7214  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7214_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7214	= { FOLLOW_COMMA_in_stringTerm7214_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7216  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7216_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7216	= { FOLLOW_formula_in_stringTerm7216_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7219  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7219	= { FOLLOW_RPAREN_in_stringTerm7219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7231  */
static	ANTLR3_BITWORD FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7231	= { FOLLOW_STRING_INDEXOF_TOK_in_stringTerm7231_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7233  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7233_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7233	= { FOLLOW_LPAREN_in_stringTerm7233_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7235  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7235_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7235	= { FOLLOW_formula_in_stringTerm7235_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7238  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7238_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7238	= { FOLLOW_COMMA_in_stringTerm7238_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7240  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7240_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7240	= { FOLLOW_formula_in_stringTerm7240_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7243  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7243_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7243	= { FOLLOW_COMMA_in_stringTerm7243_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7245  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7245	= { FOLLOW_formula_in_stringTerm7245_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7248  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7248_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7248	= { FOLLOW_RPAREN_in_stringTerm7248_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_REPLACE_TOK_in_stringTerm7260  */
static	ANTLR3_BITWORD FOLLOW_STRING_REPLACE_TOK_in_stringTerm7260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_REPLACE_TOK_in_stringTerm7260	= { FOLLOW_STRING_REPLACE_TOK_in_stringTerm7260_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7262  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7262_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7262	= { FOLLOW_LPAREN_in_stringTerm7262_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7264  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7264_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7264	= { FOLLOW_formula_in_stringTerm7264_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7267  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7267_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7267	= { FOLLOW_COMMA_in_stringTerm7267_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7269  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7269_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7269	= { FOLLOW_formula_in_stringTerm7269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7272  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7272_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7272	= { FOLLOW_COMMA_in_stringTerm7272_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7274  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7274	= { FOLLOW_formula_in_stringTerm7274_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7277  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7277	= { FOLLOW_RPAREN_in_stringTerm7277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7289  */
static	ANTLR3_BITWORD FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7289_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7289	= { FOLLOW_STRING_PREFIXOF_TOK_in_stringTerm7289_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7291  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7291_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7291	= { FOLLOW_LPAREN_in_stringTerm7291_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7293  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7293_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7293	= { FOLLOW_formula_in_stringTerm7293_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7296  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7296_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7296	= { FOLLOW_COMMA_in_stringTerm7296_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7298  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7298_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7298	= { FOLLOW_formula_in_stringTerm7298_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7301  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7301	= { FOLLOW_RPAREN_in_stringTerm7301_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7313  */
static	ANTLR3_BITWORD FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7313	= { FOLLOW_STRING_SUFFIXOF_TOK_in_stringTerm7313_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7315  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7315_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7315	= { FOLLOW_LPAREN_in_stringTerm7315_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7317  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7317_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7317	= { FOLLOW_formula_in_stringTerm7317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm7320  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm7320_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm7320	= { FOLLOW_COMMA_in_stringTerm7320_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7322  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7322	= { FOLLOW_formula_in_stringTerm7322_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7325  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7325_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7325	= { FOLLOW_RPAREN_in_stringTerm7325_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_STOI_TOK_in_stringTerm7337  */
static	ANTLR3_BITWORD FOLLOW_STRING_STOI_TOK_in_stringTerm7337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_STOI_TOK_in_stringTerm7337	= { FOLLOW_STRING_STOI_TOK_in_stringTerm7337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7339  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7339_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7339	= { FOLLOW_LPAREN_in_stringTerm7339_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7341  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7341_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7341	= { FOLLOW_formula_in_stringTerm7341_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7344  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7344	= { FOLLOW_RPAREN_in_stringTerm7344_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_ITOS_TOK_in_stringTerm7356  */
static	ANTLR3_BITWORD FOLLOW_STRING_ITOS_TOK_in_stringTerm7356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_ITOS_TOK_in_stringTerm7356	= { FOLLOW_STRING_ITOS_TOK_in_stringTerm7356_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm7358  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm7358_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm7358	= { FOLLOW_LPAREN_in_stringTerm7358_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm7360  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm7360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm7360	= { FOLLOW_formula_in_stringTerm7360_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm7363  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm7363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm7363	= { FOLLOW_RPAREN_in_stringTerm7363_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_stringTerm7385  */
static	ANTLR3_BITWORD FOLLOW_str_in_stringTerm7385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_stringTerm7385	= { FOLLOW_str_in_stringTerm7385_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setsTerm_in_stringTerm7399  */
static	ANTLR3_BITWORD FOLLOW_setsTerm_in_stringTerm7399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setsTerm_in_stringTerm7399	= { FOLLOW_setsTerm_in_stringTerm7399_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SETS_CARD_TOK_in_setsTerm7427  */
static	ANTLR3_BITWORD FOLLOW_SETS_CARD_TOK_in_setsTerm7427_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SETS_CARD_TOK_in_setsTerm7427	= { FOLLOW_SETS_CARD_TOK_in_setsTerm7427_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_setsTerm7429  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_setsTerm7429_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_setsTerm7429	= { FOLLOW_LPAREN_in_setsTerm7429_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_setsTerm7431  */
static	ANTLR3_BITWORD FOLLOW_formula_in_setsTerm7431_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_setsTerm7431	= { FOLLOW_formula_in_setsTerm7431_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_setsTerm7434  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_setsTerm7434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_setsTerm7434	= { FOLLOW_RPAREN_in_setsTerm7434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_setsTerm7446  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_setsTerm7446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_setsTerm7446	= { FOLLOW_simpleTerm_in_setsTerm7446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteTerm_in_simpleTerm7477  */
static	ANTLR3_BITWORD FOLLOW_iteTerm_in_simpleTerm7477_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteTerm_in_simpleTerm7477	= { FOLLOW_iteTerm_in_simpleTerm7477_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7500  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7500_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7500	= { FOLLOW_LPAREN_in_simpleTerm7500_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7502  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7502_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7502	= { FOLLOW_formula_in_simpleTerm7502_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7513  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7513_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7513	= { FOLLOW_COMMA_in_simpleTerm7513_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7515  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7515_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7515	= { FOLLOW_formula_in_simpleTerm7515_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7523  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7523_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7523	= { FOLLOW_RPAREN_in_simpleTerm7523_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7546  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7546	= { FOLLOW_LPAREN_in_simpleTerm7546_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7548  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7548	= { FOLLOW_RPAREN_in_simpleTerm7548_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm7592  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm7592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm7592	= { FOLLOW_PARENHASH_in_simpleTerm7592_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm7594  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm7594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm7594	= { FOLLOW_HASHPAREN_in_simpleTerm7594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm7612  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm7612_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm7612	= { FOLLOW_LBRACE_in_simpleTerm7612_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm7614  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm7614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm7614	= { FOLLOW_RBRACE_in_simpleTerm7614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNIVSET_TOK_in_simpleTerm7626  */
static	ANTLR3_BITWORD FOLLOW_UNIVSET_TOK_in_simpleTerm7626_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNIVSET_TOK_in_simpleTerm7626	= { FOLLOW_UNIVSET_TOK_in_simpleTerm7626_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm7645  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm7645_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm7645	= { FOLLOW_LBRACE_in_simpleTerm7645_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7647  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7647_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7647	= { FOLLOW_formula_in_simpleTerm7647_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7658  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7658_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7658	= { FOLLOW_COMMA_in_simpleTerm7658_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7660  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7660_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7660	= { FOLLOW_formula_in_simpleTerm7660_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm7668  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm7668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm7668	= { FOLLOW_RBRACE_in_simpleTerm7668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7687  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7687_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7687	= { FOLLOW_BAR_in_simpleTerm7687_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7689  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7689_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7689	= { FOLLOW_BAR_in_simpleTerm7689_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm7691  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm7691_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm7691	= { FOLLOW_formula_in_simpleTerm7691_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7696  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7696_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7696	= { FOLLOW_BAR_in_simpleTerm7696_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_simpleTerm7698  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_simpleTerm7698_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_simpleTerm7698	= { FOLLOW_BAR_in_simpleTerm7698_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_simpleTerm7717  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_simpleTerm7717_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_simpleTerm7717	= { FOLLOW_ARRAY_TOK_in_simpleTerm7717_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm7721  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm7721_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm7721	= { FOLLOW_LPAREN_in_simpleTerm7721_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm7727  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm7727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm7727	= { FOLLOW_restrictedType_in_simpleTerm7727_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_simpleTerm7730  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_simpleTerm7730_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1102020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_simpleTerm7730	= { FOLLOW_OF_TOK_in_simpleTerm7730_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_simpleTerm7732  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_simpleTerm7732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_simpleTerm7732	= { FOLLOW_restrictedType_in_simpleTerm7732_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm7739  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm7739_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm7739	= { FOLLOW_RPAREN_in_simpleTerm7739_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_simpleTerm7741  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_simpleTerm7741_bits[]	= { ANTLR3_UINT64_LIT(0x400000000000C100), ANTLR3_UINT64_LIT(0x1081130002000000), ANTLR3_UINT64_LIT(0x0220000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_simpleTerm7741	= { FOLLOW_COLON_in_simpleTerm7741_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_simpleTerm7743  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_simpleTerm7743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_simpleTerm7743	= { FOLLOW_simpleTerm_in_simpleTerm7743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_simpleTerm7763  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_simpleTerm7763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_simpleTerm7763	= { FOLLOW_TRUE_TOK_in_simpleTerm7763_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_simpleTerm7772  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_simpleTerm7772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_simpleTerm7772	= { FOLLOW_FALSE_TOK_in_simpleTerm7772_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleTerm7792  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleTerm7792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleTerm7792	= { FOLLOW_DECIMAL_LITERAL_in_simpleTerm7792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleTerm7800  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleTerm7800_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleTerm7800	= { FOLLOW_INTEGER_LITERAL_in_simpleTerm7800_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleTerm7814  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleTerm7814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleTerm7814	= { FOLLOW_HEX_LITERAL_in_simpleTerm7814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleTerm7826  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleTerm7826_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleTerm7826	= { FOLLOW_BINARY_LITERAL_in_simpleTerm7826_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm7844  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm7844_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm7844	= { FOLLOW_PARENHASH_in_simpleTerm7844_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7846  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7846_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7846	= { FOLLOW_recordEntry_in_simpleTerm7846_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7857  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7857_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7857	= { FOLLOW_COMMA_in_simpleTerm7857_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7859  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7859_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7859	= { FOLLOW_recordEntry_in_simpleTerm7859_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm7867  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm7867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm7867	= { FOLLOW_HASHPAREN_in_simpleTerm7867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_simpleTerm7886  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_simpleTerm7886_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_simpleTerm7886	= { FOLLOW_identifier_in_simpleTerm7886_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7920  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7920_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7920	= { FOLLOW_COLON_in_typeAscription7920_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7922  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7922_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7922	= { FOLLOW_COLON_in_typeAscription7922_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_typeAscription7924  */
static	ANTLR3_BITWORD FOLLOW_type_in_typeAscription7924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_typeAscription7924	= { FOLLOW_type_in_typeAscription7924_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordEntry7941  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordEntry7941_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordEntry7941	= { FOLLOW_identifier_in_recordEntry7941_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordEntry7944  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordEntry7944_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordEntry7944	= { FOLLOW_ASSIGN_TOK_in_recordEntry7944_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_recordEntry7946  */
static	ANTLR3_BITWORD FOLLOW_formula_in_recordEntry7946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_recordEntry7946	= { FOLLOW_formula_in_recordEntry7946_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IF_TOK_in_iteTerm7968  */
static	ANTLR3_BITWORD FOLLOW_IF_TOK_in_iteTerm7968_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_IF_TOK_in_iteTerm7968	= { FOLLOW_IF_TOK_in_iteTerm7968_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm7970  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm7970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm7970	= { FOLLOW_formula_in_iteTerm7970_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteTerm7979  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteTerm7979_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteTerm7979	= { FOLLOW_THEN_TOK_in_iteTerm7979_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm7981  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm7981_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm7981	= { FOLLOW_formula_in_iteTerm7981_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteTerm7990  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteTerm7990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteTerm7990	= { FOLLOW_iteElseTerm_in_iteTerm7990_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENDIF_TOK_in_iteTerm7999  */
static	ANTLR3_BITWORD FOLLOW_ENDIF_TOK_in_iteTerm7999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENDIF_TOK_in_iteTerm7999	= { FOLLOW_ENDIF_TOK_in_iteTerm7999_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSE_TOK_in_iteElseTerm8026  */
static	ANTLR3_BITWORD FOLLOW_ELSE_TOK_in_iteElseTerm8026_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSE_TOK_in_iteElseTerm8026	= { FOLLOW_ELSE_TOK_in_iteElseTerm8026_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8028  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8028_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8028	= { FOLLOW_formula_in_iteElseTerm8028_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSEIF_TOK_in_iteElseTerm8035  */
static	ANTLR3_BITWORD FOLLOW_ELSEIF_TOK_in_iteElseTerm8035_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSEIF_TOK_in_iteElseTerm8035	= { FOLLOW_ELSEIF_TOK_in_iteElseTerm8035_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8041  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8041_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8041	= { FOLLOW_formula_in_iteElseTerm8041_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteElseTerm8050  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteElseTerm8050_bits[]	= { ANTLR3_UINT64_LIT(0x4001FFFFFFF8C110), ANTLR3_UINT64_LIT(0x98C9170016400006), ANTLR3_UINT64_LIT(0x02748FFF10000042) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteElseTerm8050	= { FOLLOW_THEN_TOK_in_iteElseTerm8050_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm8056  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm8056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000030000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm8056	= { FOLLOW_formula_in_iteElseTerm8056_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteElseTerm8069  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteElseTerm8069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteElseTerm8069	= { FOLLOW_iteElseTerm_in_iteElseTerm8069_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8105  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8105_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8105	= { FOLLOW_identifier_in_datatypeDef8105_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_datatypeDef8116  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_datatypeDef8116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_datatypeDef8116	= { FOLLOW_LBRACKET_in_datatypeDef8116_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8118  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8118_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8118	= { FOLLOW_identifier_in_datatypeDef8118_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_datatypeDef8131  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_datatypeDef8131_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_datatypeDef8131	= { FOLLOW_COMMA_in_datatypeDef8131_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef8133  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef8133_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef8133	= { FOLLOW_identifier_in_datatypeDef8133_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_datatypeDef8147  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_datatypeDef8147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_datatypeDef8147	= { FOLLOW_RBRACKET_in_datatypeDef8147_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_datatypeDef8166  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_datatypeDef8166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_datatypeDef8166	= { FOLLOW_EQUAL_TOK_in_datatypeDef8166_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8168  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8168_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8168	= { FOLLOW_constructorDef_in_datatypeDef8168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_datatypeDef8177  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_datatypeDef8177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_datatypeDef8177	= { FOLLOW_BAR_in_datatypeDef8177_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef8179  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef8179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef8179	= { FOLLOW_constructorDef_in_datatypeDef8179_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_constructorDef8210  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_constructorDef8210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_constructorDef8210	= { FOLLOW_identifier_in_constructorDef8210_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_constructorDef8225  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_constructorDef8225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_constructorDef8225	= { FOLLOW_LPAREN_in_constructorDef8225_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8233  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8233_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8233	= { FOLLOW_selector_in_constructorDef8233_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_constructorDef8244  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_constructorDef8244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_constructorDef8244	= { FOLLOW_COMMA_in_constructorDef8244_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef8246  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef8246_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef8246	= { FOLLOW_selector_in_constructorDef8246_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_constructorDef8258  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_constructorDef8258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_constructorDef8258	= { FOLLOW_RPAREN_in_constructorDef8258_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_selector8290  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_selector8290_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_selector8290	= { FOLLOW_identifier_in_selector8290_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_selector8293  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_selector8293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x1902020000000000), ANTLR3_UINT64_LIT(0x0000500060200000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_selector8293	= { FOLLOW_COLON_in_selector8293_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_selector8295  */
static	ANTLR3_BITWORD FOLLOW_type_in_selector8295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_selector8295	= { FOLLOW_type_in_selector8295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_numeral8370  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_numeral8370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_numeral8370	= { FOLLOW_INTEGER_LITERAL_in_numeral8370_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8395  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8395	= { FOLLOW_INTEGER_LITERAL_in_integer8395_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_integer8407  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_integer8407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0001000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_integer8407	= { FOLLOW_MINUS_TOK_in_integer8407_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer8409  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer8409_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer8409	= { FOLLOW_INTEGER_LITERAL_in_integer8409_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str8431  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str8431_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str8431	= { FOLLOW_STRING_LITERAL_in_str8431_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_synpred1_Cvc1990  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_synpred1_Cvc1990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_synpred1_Cvc1990	= { FOLLOW_letDecl_in_synpred1_Cvc1990_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * ../../../../src/parser/cvc/Cvc.g:633:1: parseExpr returns [CVC4::Expr expr = CVC4::Expr()] : ( formula[expr] | EOF );
 */
static CVC4::Expr
parseExpr(pCvcParser ctx)
{
    CVC4::Expr expr;


    /* Initialize rule variables
     */
    expr =  CVC4::Expr();


    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:634:3: ( formula[expr] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case EXISTS_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case FORALL_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LAMBDA_TOK:
            case LBRACE:
            case LET_TOK:
            case LPAREN:
            case MINUS_TOK:
            case NOT_TOK:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return expr;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:634:5: formula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_formula_in_parseExpr1792);
        	        formula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:635:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr1799);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * ../../../../src/parser/cvc/Cvc.g:642:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : (c= command[&cmd] | LPAREN IDENTIFIER | EOF );
 */
static CVC4::Command*
parseCommand(pCvcParser ctx)
{
    CVC4::Command* cmd_return;



        std::unique_ptr<CVC4::Command> cmd;

    pANTLR3_COMMON_TOKEN    IDENTIFIER1;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    IDENTIFIER1       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:649:3: (c= command[&cmd] | LPAREN IDENTIFIER | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case IDENTIFIER:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RECURSIVE_FUNCTION_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt2=1;
            	}
                break;
            case LPAREN:
            	{
            		alt2=2;
            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd_return;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:649:5: c= command[&cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand1830);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:650:5: LPAREN IDENTIFIER
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_parseCommand1837);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        IDENTIFIER1 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_parseCommand1839);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::string s = AntlrInput::tokenText(IDENTIFIER1);
        	                if(s == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIBv1 format "
        	                        "detected.  Use --lang smt1 for SMT-LIBv1 support.");
        	                  } else if(s == "set" || s == "get" || s == "declare" ||
        	                            s == "define" || s == "assert") {
        	                    PARSER_STATE->parseError(
        	                        "In CVC4 presentation language mode, but SMT-LIB format detected. "
        	                        "Use --lang smt for SMT-LIB support.");
        	                  } else {
        	                    PARSER_STATE->parseError(
        	                        "A CVC4 presentation language command cannot begin with a "
        	                        "parenthesis; expected command name.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:667:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand1851);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd_return;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                        cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start command
 * ../../../../src/parser/cvc/Cvc.g:674:1: command[std::unique_ptr<CVC4::Command>* cmd] : ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON );
 */
static void
command(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER2;

    /* Initialize rule variables
     */

    IDENTIFIER2       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:675:3: ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] ) | IDENTIFIER SEMICOLON )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case CONTINUE_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case DUMP_UNSAT_CORE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RECURSIVE_FUNCTION_TOK:
            case RESET_TOK:
            case RESTART_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt5=1;
            	}
                break;
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case SEMICOLON:
            			{
            				alt5=2;
            			}
            		    break;
            		case COLON:
            		case COMMA:
            			{
            				alt5=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 5;
            		    EXCEPTION->state        = 42;


            		    goto rulecommandEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt5)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:675:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:675:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd] )
        	        {
        	            int alt4=3;
        	            switch ( LA(1) )
        	            {
        	            case ARITH_VAR_ORDER_TOK:
        	            case ASSERTIONS_TOK:
        	            case ASSERT_TOK:
        	            case ASSUMPTIONS_TOK:
        	            case CALL_TOK:
        	            case CHECKSAT_TOK:
        	            case CHECK_TYPE_TOK:
        	            case CONTEXT_TOK:
        	            case CONTINUE_TOK:
        	            case COUNTEREXAMPLE_TOK:
        	            case COUNTERMODEL_TOK:
        	            case DATATYPE_TOK:
        	            case DBG_TOK:
        	            case DUMP_ASSUMPTIONS_TOK:
        	            case DUMP_CLOSURE_PROOF_TOK:
        	            case DUMP_CLOSURE_TOK:
        	            case DUMP_PROOF_TOK:
        	            case DUMP_SIG_TOK:
        	            case DUMP_TCC_ASSUMPTIONS_TOK:
        	            case DUMP_TCC_PROOF_TOK:
        	            case DUMP_TCC_TOK:
        	            case DUMP_UNSAT_CORE_TOK:
        	            case ECHO_TOK:
        	            case EXIT_TOK:
        	            case FORGET_TOK:
        	            case GET_CHILD_TOK:
        	            case GET_OP_TOK:
        	            case GET_TYPE_TOK:
        	            case GET_VALUE_TOK:
        	            case HELP_TOK:
        	            case IDENTIFIER:
        	            case INCLUDE_TOK:
        	            case OPTION_TOK:
        	            case POPTO_SCOPE_TOK:
        	            case POPTO_TOK:
        	            case POP_SCOPE_TOK:
        	            case POP_TOK:
        	            case PRINT_TOK:
        	            case PRINT_TYPE_TOK:
        	            case PUSH_SCOPE_TOK:
        	            case PUSH_TOK:
        	            case QUERY_TOK:
        	            case RECURSIVE_FUNCTION_TOK:
        	            case RESET_TOK:
        	            case RESTART_TOK:
        	            case SUBSTITUTE_TOK:
        	            case TRACE_TOK:
        	            case TRANSFORM_TOK:
        	            case UNTRACE_TOK:
        	            case WHERE_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;
        	            case LET_TOK:
        	            	{
        	            		alt4=3;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:675:7: mainCommand[cmd] SEMICOLON
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_mainCommand_in_command1870);
        	        	        mainCommand(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1873);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:676:7: SEMICOLON
        	        	    {
        	        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1881);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/cvc/Cvc.g:677:7: LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK command[cmd]
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_command1889);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->pushScope(); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1899);
        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:678:40: ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt3=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt3=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt3)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:679:11: COMMA typeOrVarLetDecl[CHECK_DECLARED]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_command1914);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1916);
        	        	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulecommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop3;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop3: ; /* Jump out to here if this rule does not match */


        	        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_command1928);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_command_in_command1930);
        	        	        command(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->popScope(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!(*cmd)) {
        	                    cmd->reset(new EmptyCommand());
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:687:5: IDENTIFIER SEMICOLON
        	    {
        	        IDENTIFIER2 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_command1957);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1959);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::stringstream ss;
        	                  ss << "Unrecognized command `"
        	                     << AntlrInput::tokenText(IDENTIFIER2)
        	                     << "'";
        	                  PARSER_STATE->parseError(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start typeOrVarLetDecl
 * ../../../../src/parser/cvc/Cvc.g:696:1: typeOrVarLetDecl[CVC4::parser::DeclarationCheck check] options {backtrack=true; } : ( letDecl | typeLetDecl[check] );
 */
static void
typeOrVarLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:698:3: ( letDecl | typeLetDecl[check] )

            ANTLR3_UINT32 alt6;

            alt6=2;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				switch ( LA(3) )
            				{
            				case ABS_TOK:
            				case BAR:
            				case BINARY_LITERAL:
            				case BVASHR_TOK:
            				case BVCOMP_TOK:
            				case BVGE_TOK:
            				case BVGT_TOK:
            				case BVLE_TOK:
            				case BVLSHR_TOK:
            				case BVLT_TOK:
            				case BVMULT_TOK:
            				case BVNAND_TOK:
            				case BVNEG_TOK:
            				case BVNOR_TOK:
            				case BVPLUS_TOK:
            				case BVREPEAT_TOK:
            				case BVROTL_TOK:
            				case BVROTR_TOK:
            				case BVSDIV_TOK:
            				case BVSGE_TOK:
            				case BVSGT_TOK:
            				case BVSHL_TOK:
            				case BVSLE_TOK:
            				case BVSLT_TOK:
            				case BVSMOD_TOK:
            				case BVSREM_TOK:
            				case BVSUB_TOK:
            				case BVUDIV_TOK:
            				case BVUMINUS_TOK:
            				case BVUREM_TOK:
            				case BVXNOR_TOK:
            				case BVXOR_TOK:
            				case BVZEROEXTEND_TOK:
            				case DECIMAL_LITERAL:
            				case DISTINCT_TOK:
            				case DIVISIBLE_TOK:
            				case EXISTS_TOK:
            				case FALSE_TOK:
            				case FLOOR_TOK:
            				case FORALL_TOK:
            				case HEX_LITERAL:
            				case IDEN_TOK:
            				case IF_TOK:
            				case INTEGER_LITERAL:
            				case IS_INTEGER_TOK:
            				case LAMBDA_TOK:
            				case LBRACE:
            				case LET_TOK:
            				case MINUS_TOK:
            				case NOT_TOK:
            				case PARENHASH:
            				case SETS_CARD_TOK:
            				case STRING_CHARAT_TOK:
            				case STRING_CONCAT_TOK:
            				case STRING_CONTAINS_TOK:
            				case STRING_INDEXOF_TOK:
            				case STRING_ITOS_TOK:
            				case STRING_LENGTH_TOK:
            				case STRING_LITERAL:
            				case STRING_PREFIXOF_TOK:
            				case STRING_REPLACE_TOK:
            				case STRING_STOI_TOK:
            				case STRING_SUBSTR_TOK:
            				case STRING_SUFFIXOF_TOK:
            				case SX_TOK:
            				case TRANSCLOSURE_TOK:
            				case TRANSPOSE_TOK:
            				case TRUE_TOK:
            				case TUPLE_TOK:
            				case UNIVSET_TOK:
            					{
            						alt6=1;
            					}
            				    break;
            				case LPAREN:
            					{
            						{
            						    int LA6_59 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 59;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case ARRAY_TOK:
            					{
            						{
            						    int LA6_64 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 64;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case IDENTIFIER:
            					{
            						{
            						    int LA6_71 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt6=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt6=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 6;
            						        EXCEPTION->state        = 71;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case BITVECTOR_TOK:
            				case BOOLEAN_TOK:
            				case INT_TOK:
            				case LBRACKET:
            				case REAL_TOK:
            				case SET_TOK:
            				case SQHASH:
            				case STRING_TOK:
            				case SUBTYPE_TOK:
            					{
            						alt6=2;
            					}
            				    break;

            				default:
            				    if (BACKTRACKING>0)
            				    {
            				        FAILEDFLAG = ANTLR3_TRUE;
            				        return ;
            				    }

            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 6;
            				    EXCEPTION->state        = 2;


            				    goto ruletypeOrVarLetDeclEx;

            				}

            			}
            		    break;
            		case COLON:
            			{
            				alt6=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 6;
            		    EXCEPTION->state        = 1;


            		    goto ruletypeOrVarLetDeclEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 6;
                EXCEPTION->state        = 0;


                goto ruletypeOrVarLetDeclEx;

            }

            switch (alt6)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:698:5: letDecl
        	    {
        	        FOLLOWPUSH(FOLLOW_letDecl_in_typeOrVarLetDecl1990);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:698:15: typeLetDecl[check]
        	    {
        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_typeOrVarLetDecl1994);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeOrVarLetDeclEx; /* Prevent compiler warnings */
    ruletypeOrVarLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeOrVarLetDecl */

/**
 * $ANTLR start mainCommand
 * ../../../../src/parser/cvc/Cvc.g:701:1: mainCommand[std::unique_ptr<CVC4::Command>* cmd] : ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+ | toplevelDeclaration[cmd] );
 */
static void
mainCommand(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER3;
    pANTLR3_COMMON_TOKEN    IDENTIFIER4;
    pANTLR3_COMMON_TOKEN    IDENTIFIER5;
    pANTLR3_COMMON_TOKEN    IDENTIFIER6;
    pANTLR3_COMMON_TOKEN    IDENTIFIER7;
    pANTLR3_COMMON_TOKEN    IDENTIFIER8;
    pANTLR3_COMMON_TOKEN    IDENTIFIER9;
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f;
      SExpr sexpr;
      std::string id;
      Type t;
      std::vector<CVC4::Datatype> dts;
      Debug("parser-extra") << "command: " << AntlrInput::tokenText(LT(1)) << std::endl;
      std::string s;
      Expr func;
      std::vector<Expr> bvs;
      std::vector<Expr> funcs;
      std::vector<Expr> formulas;
      std::vector<std::vector<Expr>> formals;
      std::vector<std::string> ids;
      std::vector<CVC4::Type> types;
      bool idCommaFlag = true;
      bool formCommaFlag = true;

    IDENTIFIER3       = NULL;
    IDENTIFIER4       = NULL;
    IDENTIFIER5       = NULL;
    IDENTIFIER6       = NULL;
    IDENTIFIER7       = NULL;
    IDENTIFIER8       = NULL;
    IDENTIFIER9       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:721:3: ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | RESET_TOK ASSERTIONS_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | DUMP_UNSAT_CORE_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | CONTINUE_TOK | RESTART_TOK formula[f] | RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+ | toplevelDeclaration[cmd] )

            ANTLR3_UINT32 alt35;

            alt35=43;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            	{
            		alt35=1;
            	}
                break;
            case QUERY_TOK:
            	{
            		alt35=2;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt35=3;
            	}
                break;
            case OPTION_TOK:
            	{
            		alt35=4;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt35=5;
            	}
                break;
            case POP_TOK:
            	{
            		alt35=6;
            	}
                break;
            case POPTO_TOK:
            	{
            		alt35=7;
            	}
                break;
            case PUSH_SCOPE_TOK:
            	{
            		alt35=8;
            	}
                break;
            case POP_SCOPE_TOK:
            	{
            		alt35=9;
            	}
                break;
            case POPTO_SCOPE_TOK:
            	{
            		alt35=10;
            	}
                break;
            case RESET_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case ASSERTIONS_TOK:
            			{
            				alt35=12;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt35=11;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 35;
            		    EXCEPTION->state        = 11;


            		    goto rulemainCommandEx;

            		}

            	}
                break;
            case DATATYPE_TOK:
            	{
            		alt35=13;
            	}
                break;
            case CONTEXT_TOK:
            	{
            		alt35=14;
            	}
                break;
            case FORGET_TOK:
            	{
            		alt35=15;
            	}
                break;
            case GET_TYPE_TOK:
            	{
            		alt35=16;
            	}
                break;
            case CHECK_TYPE_TOK:
            	{
            		alt35=17;
            	}
                break;
            case GET_CHILD_TOK:
            	{
            		alt35=18;
            	}
                break;
            case GET_OP_TOK:
            	{
            		alt35=19;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt35=20;
            	}
                break;
            case SUBSTITUTE_TOK:
            	{
            		alt35=21;
            	}
                break;
            case DBG_TOK:
            	{
            		alt35=22;
            	}
                break;
            case TRACE_TOK:
            	{
            		alt35=23;
            	}
                break;
            case UNTRACE_TOK:
            	{
            		alt35=24;
            	}
                break;
            case HELP_TOK:
            	{
            		alt35=25;
            	}
                break;
            case TRANSFORM_TOK:
            	{
            		alt35=26;
            	}
                break;
            case PRINT_TOK:
            	{
            		alt35=27;
            	}
                break;
            case PRINT_TYPE_TOK:
            	{
            		alt35=28;
            	}
                break;
            case CALL_TOK:
            	{
            		alt35=29;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt35=30;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt35=31;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt35=32;
            	}
                break;
            case DUMP_PROOF_TOK:
            	{
            		alt35=33;
            	}
                break;
            case DUMP_UNSAT_CORE_TOK:
            	{
            		alt35=34;
            	}
                break;
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            	{
            		alt35=35;
            	}
                break;
            case ASSERTIONS_TOK:
            case ASSUMPTIONS_TOK:
            case WHERE_TOK:
            	{
            		alt35=36;
            	}
                break;
            case COUNTEREXAMPLE_TOK:
            	{
            		alt35=37;
            	}
                break;
            case COUNTERMODEL_TOK:
            	{
            		alt35=38;
            	}
                break;
            case ARITH_VAR_ORDER_TOK:
            	{
            		alt35=39;
            	}
                break;
            case CONTINUE_TOK:
            	{
            		alt35=40;
            	}
                break;
            case RESTART_TOK:
            	{
            		alt35=41;
            	}
                break;
            case RECURSIVE_FUNCTION_TOK:
            	{
            		alt35=42;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt35=43;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 35;
                EXCEPTION->state        = 0;


                goto rulemainCommandEx;

            }

            switch (alt35)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:721:5: ASSERT_TOK formula[f]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_mainCommand2020);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2022);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new AssertCommand(f)); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:723:5: QUERY_TOK formula[f]
        	    {
        	         MATCHT(QUERY_TOK, &FOLLOW_QUERY_TOK_in_mainCommand2032);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2034);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QueryCommand(f)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:724:5: CHECKSAT_TOK ( formula[f] )?
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_mainCommand2043);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:724:18: ( formula[f] )?
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	                case ABS_TOK:
        	                case ARRAY_TOK:
        	                case BAR:
        	                case BINARY_LITERAL:
        	                case BVASHR_TOK:
        	                case BVCOMP_TOK:
        	                case BVGE_TOK:
        	                case BVGT_TOK:
        	                case BVLE_TOK:
        	                case BVLSHR_TOK:
        	                case BVLT_TOK:
        	                case BVMULT_TOK:
        	                case BVNAND_TOK:
        	                case BVNEG_TOK:
        	                case BVNOR_TOK:
        	                case BVPLUS_TOK:
        	                case BVREPEAT_TOK:
        	                case BVROTL_TOK:
        	                case BVROTR_TOK:
        	                case BVSDIV_TOK:
        	                case BVSGE_TOK:
        	                case BVSGT_TOK:
        	                case BVSHL_TOK:
        	                case BVSLE_TOK:
        	                case BVSLT_TOK:
        	                case BVSMOD_TOK:
        	                case BVSREM_TOK:
        	                case BVSUB_TOK:
        	                case BVUDIV_TOK:
        	                case BVUMINUS_TOK:
        	                case BVUREM_TOK:
        	                case BVXNOR_TOK:
        	                case BVXOR_TOK:
        	                case BVZEROEXTEND_TOK:
        	                case DECIMAL_LITERAL:
        	                case DISTINCT_TOK:
        	                case DIVISIBLE_TOK:
        	                case EXISTS_TOK:
        	                case FALSE_TOK:
        	                case FLOOR_TOK:
        	                case FORALL_TOK:
        	                case HEX_LITERAL:
        	                case IDENTIFIER:
        	                case IDEN_TOK:
        	                case IF_TOK:
        	                case INTEGER_LITERAL:
        	                case IS_INTEGER_TOK:
        	                case LAMBDA_TOK:
        	                case LBRACE:
        	                case LET_TOK:
        	                case LPAREN:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case PARENHASH:
        	                case SETS_CARD_TOK:
        	                case STRING_CHARAT_TOK:
        	                case STRING_CONCAT_TOK:
        	                case STRING_CONTAINS_TOK:
        	                case STRING_INDEXOF_TOK:
        	                case STRING_ITOS_TOK:
        	                case STRING_LENGTH_TOK:
        	                case STRING_LITERAL:
        	                case STRING_PREFIXOF_TOK:
        	                case STRING_REPLACE_TOK:
        	                case STRING_STOI_TOK:
        	                case STRING_SUBSTR_TOK:
        	                case STRING_SUFFIXOF_TOK:
        	                case SX_TOK:
        	                case TRANSCLOSURE_TOK:
        	                case TRANSPOSE_TOK:
        	                case TRUE_TOK:
        	                case TUPLE_TOK:
        	                case UNIVSET_TOK:
        	                	{
        	                		alt7=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:724:18: formula[f]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2045);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(f.isNull() ? new CheckSatCommand() : new CheckSatCommand(f)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:727:5: OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	    {
        	         MATCHT(OPTION_TOK, &FOLLOW_OPTION_TOK_in_mainCommand2065);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:728:5: ( str[s] | IDENTIFIER )
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case STRING_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case IDENTIFIER:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:728:7: str[s]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2073);
        	        	        str(ctx, s);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:728:16: IDENTIFIER
        	        	    {
        	        	        IDENTIFIER3 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2078);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             s = AntlrInput::tokenText(IDENTIFIER3); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // ../../../../src/parser/cvc/Cvc.g:729:5: ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	        {
        	            int alt9=4;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt9=1;
        	            	}
        	                break;
        	            case TRUE_TOK:
        	            	{
        	            		alt9=2;
        	            	}
        	                break;
        	            case FALSE_TOK:
        	            	{
        	            		alt9=3;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt9=4;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 9;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt9)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:729:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_mainCommand2090);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(s == "logic") {
        	        	                      cmd->reset(new SetBenchmarkLogicCommand(sexpr.getValue()));
        	        	                    } else {
        	        	                      cmd->reset(new SetOptionCommand(s, sexpr));
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:736:7: TRUE_TOK
        	        	    {
        	        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_mainCommand2107);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/cvc/Cvc.g:737:7: FALSE_TOK
        	        	    {
        	        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_mainCommand2117);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("false"))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/cvc/Cvc.g:738:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new SetOptionCommand(s, SExpr("true"))); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:742:5: PUSH_TOK (k= numeral |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_mainCommand2146);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:742:14: (k= numeral |)
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:742:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2152);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PushCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:743:18: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PushCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:744:5: POP_TOK (k= numeral |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_mainCommand2181);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:744:13: (k= numeral |)
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt11=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt11=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 11;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:744:15: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2187);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(REPEAT_COMMAND(k, PopCommand())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:745:17: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new PopCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:746:5: POPTO_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_TOK, &FOLLOW_POPTO_TOK_in_mainCommand2215);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:746:16: (k= numeral )?
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt12=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:746:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2219);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO command"); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:750:5: PUSH_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(PUSH_SCOPE_TOK, &FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2239);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:750:21: (k= numeral )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:750:21: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2243);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PUSH_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:752:5: POP_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POP_SCOPE_TOK, &FOLLOW_POP_SCOPE_TOK_in_mainCommand2256);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:752:20: (k= numeral )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:752:20: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2260);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POP_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:754:5: POPTO_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_SCOPE_TOK, &FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2273);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:754:22: (k= numeral )?
        	        {
        	            int alt15=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt15=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt15)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:754:22: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2277);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:757:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2291);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:762:5: RESET_TOK ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2304);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSERTIONS_TOK, &FOLLOW_ASSERTIONS_TOK_in_mainCommand2306);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:770:5: DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK
        	    {
        	         MATCHT(DATATYPE_TOK, &FOLLOW_DATATYPE_TOK_in_mainCommand2334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* open a scope to keep the UnresolvedTypes contained */
        	                  PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2346);
        	        datatypeDef(ctx, dts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:774:5: ( COMMA datatypeDef[dts] )*

        	        for (;;)
        	        {
        	            int alt16=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt16=1;
        	            	}
        	                break;

        	            }

        	            switch (alt16)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:774:7: COMMA datatypeDef[dts]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand2355);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2357);
        	        	        datatypeDef(ctx, dts);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop16;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop16: ; /* Jump out to here if this rule does not match */


        	         MATCHT(END_TOK, &FOLLOW_END_TOK_in_mainCommand2367);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  cmd->reset(new DatatypeDeclarationCommand(
        	                      PARSER_STATE->mkMutualDatatypeTypes(dts)));
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/cvc/Cvc.g:781:5: CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(CONTEXT_TOK, &FOLLOW_CONTEXT_TOK_in_mainCommand2380);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:782:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt18=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 18;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:782:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:782:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt17=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt17=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt17=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 17;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt17)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:782:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2390);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:782:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER4 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2395);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER4); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:784:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/cvc/Cvc.g:787:5: FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE]
        	    {
        	         MATCHT(FORGET_TOK, &FOLLOW_FORGET_TOK_in_mainCommand2428);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2430);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("FORGET command"); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/cvc/Cvc.g:790:5: GET_TYPE_TOK formula[f]
        	    {
        	         MATCHT(GET_TYPE_TOK, &FOLLOW_GET_TYPE_TOK_in_mainCommand2444);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2446);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/cvc/Cvc.g:793:5: CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(CHECK_TYPE_TOK, &FOLLOW_CHECK_TYPE_TOK_in_mainCommand2460);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2462);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2465);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2467);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CHECK_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/cvc/Cvc.g:796:5: GET_CHILD_TOK formula[f] k= numeral
        	    {
        	         MATCHT(GET_CHILD_TOK, &FOLLOW_GET_CHILD_TOK_in_mainCommand2481);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2483);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2488);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_CHILD command"); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/cvc/Cvc.g:799:5: GET_OP_TOK formula[f]
        	    {
        	         MATCHT(GET_OP_TOK, &FOLLOW_GET_OP_TOK_in_mainCommand2501);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2503);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_OP command"); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/cvc/Cvc.g:802:5: GET_VALUE_TOK formula[f]
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_mainCommand2517);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2519);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetValueCommand(f)); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/cvc/Cvc.g:805:5: SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET
        	    {
        	         MATCHT(SUBSTITUTE_TOK, &FOLLOW_SUBSTITUTE_TOK_in_mainCommand2533);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2535);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2538);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2544);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand2547);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2549);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_mainCommand2552);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2558);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_mainCommand2561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2563);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_mainCommand2566);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("SUBSTITUTE command"); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/cvc/Cvc.g:812:5: DBG_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(DBG_TOK, &FOLLOW_DBG_TOK_in_mainCommand2585);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:813:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt20=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt20=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt20=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 20;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:813:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:813:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt19=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt19=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt19=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 19;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt19)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:813:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2595);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:813:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER5 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2600);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER5); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Debug.on(s); Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:815:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify what to debug." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/cvc/Cvc.g:818:5: TRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(TRACE_TOK, &FOLLOW_TRACE_TOK_in_mainCommand2633);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:819:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt22=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt22=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt22=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 22;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt22)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:819:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:819:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt21=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt21=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt21=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 21;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt21)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:819:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2643);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:819:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER6 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2648);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER6); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:821:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to trace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/cvc/Cvc.g:823:5: UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(UNTRACE_TOK, &FOLLOW_UNTRACE_TOK_in_mainCommand2680);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:824:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt24=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt24=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt24=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 24;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt24)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:824:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:824:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt23=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt23=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt23=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 23;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt23)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:824:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2690);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:824:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER7 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2695);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER7); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.off(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:826:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to untrace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 25:
        	    // ../../../../src/parser/cvc/Cvc.g:829:5: HELP_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(HELP_TOK, &FOLLOW_HELP_TOK_in_mainCommand2728);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:830:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt26=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt26=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt26=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 26;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt26)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:830:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:830:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt25=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt25=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt25=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 25;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt25)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:830:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2738);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:830:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER8 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2743);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER8); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "No help available for `" << s << "'." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:832:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please use --help at the command line for help."
        	        	                            << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 26:
        	    // ../../../../src/parser/cvc/Cvc.g:836:5: TRANSFORM_TOK formula[f]
        	    {
        	         MATCHT(TRANSFORM_TOK, &FOLLOW_TRANSFORM_TOK_in_mainCommand2784);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2786);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new SimplifyCommand(f)); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // ../../../../src/parser/cvc/Cvc.g:839:5: PRINT_TOK formula[f]
        	    {
        	         MATCHT(PRINT_TOK, &FOLLOW_PRINT_TOK_in_mainCommand2800);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2802);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT command"); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // ../../../../src/parser/cvc/Cvc.g:841:5: PRINT_TYPE_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(PRINT_TYPE_TOK, &FOLLOW_PRINT_TYPE_TOK_in_mainCommand2815);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2817);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // ../../../../src/parser/cvc/Cvc.g:844:5: CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f]
        	    {
        	         MATCHT(CALL_TOK, &FOLLOW_CALL_TOK_in_mainCommand2831);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2833);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2836);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CALL command"); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // ../../../../src/parser/cvc/Cvc.g:847:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_mainCommand2850);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:848:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt27=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt27=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt27=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 27;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt27)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:848:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_mainCommand2858);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.getValue())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:850:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 31:
        	    // ../../../../src/parser/cvc/Cvc.g:853:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_mainCommand2888);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 32:
        	    // ../../../../src/parser/cvc/Cvc.g:856:5: INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_mainCommand2901);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:857:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt29=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt29=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 29;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:857:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // ../../../../src/parser/cvc/Cvc.g:857:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt28=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt28=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt28=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 28;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt28)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:857:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2911);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:857:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER9 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2916);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER9); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:859:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->parseError("No filename given to INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 33:
        	    // ../../../../src/parser/cvc/Cvc.g:862:5: DUMP_PROOF_TOK
        	    {
        	         MATCHT(DUMP_PROOF_TOK, &FOLLOW_DUMP_PROOF_TOK_in_mainCommand2949);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 34:
        	    // ../../../../src/parser/cvc/Cvc.g:865:5: DUMP_UNSAT_CORE_TOK
        	    {
        	         MATCHT(DUMP_UNSAT_CORE_TOK, &FOLLOW_DUMP_UNSAT_CORE_TOK_in_mainCommand2962);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetUnsatCoreCommand()); 
        	        }


        	    }
        	    break;
        	case 35:
        	    // ../../../../src/parser/cvc/Cvc.g:868:5: ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK )
        	    {
        	        if ( ((LA(1) >= DUMP_ASSUMPTIONS_TOK) && (LA(1) <= DUMP_CLOSURE_TOK)) || ((LA(1) >= DUMP_SIG_TOK) && (LA(1) <= DUMP_TCC_TOK)) )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("DUMP* command"); 
        	        }


        	    }
        	    break;
        	case 36:
        	    // ../../../../src/parser/cvc/Cvc.g:878:5: ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK )
        	    {
        	        if ( LA(1) == ASSERTIONS_TOK || LA(1) == ASSUMPTIONS_TOK || LA(1) == WHERE_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 37:
        	    // ../../../../src/parser/cvc/Cvc.g:881:5: COUNTEREXAMPLE_TOK
        	    {
        	         MATCHT(COUNTEREXAMPLE_TOK, &FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand3071);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 38:
        	    // ../../../../src/parser/cvc/Cvc.g:883:5: COUNTERMODEL_TOK
        	    {
        	         MATCHT(COUNTERMODEL_TOK, &FOLLOW_COUNTERMODEL_TOK_in_mainCommand3083);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd->reset(new GetModelCommand); 
        	        }


        	    }
        	    break;
        	case 39:
        	    // ../../../../src/parser/cvc/Cvc.g:886:5: ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(ARITH_VAR_ORDER_TOK, &FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand3096);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_mainCommand3098);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3100);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:886:43: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt30=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt30=1;
        	            	}
        	                break;

        	            }

        	            switch (alt30)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:886:45: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3105);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3107);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop30;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop30: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_mainCommand3113);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("ARITH_VAR_ORDER command"); 
        	        }


        	    }
        	    break;
        	case 40:
        	    // ../../../../src/parser/cvc/Cvc.g:889:5: CONTINUE_TOK
        	    {
        	         MATCHT(CONTINUE_TOK, &FOLLOW_CONTINUE_TOK_in_mainCommand3126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CONTINUE command"); 
        	        }


        	    }
        	    break;
        	case 41:
        	    // ../../../../src/parser/cvc/Cvc.g:891:5: RESTART_TOK formula[f]
        	    {
        	         MATCHT(RESTART_TOK, &FOLLOW_RESTART_TOK_in_mainCommand3138);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand3140);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("RESTART command"); 
        	        }


        	    }
        	    break;
        	case 42:
        	    // ../../../../src/parser/cvc/Cvc.g:892:5: RECURSIVE_FUNCTION_TOK ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+ EQUAL_TOK ( formula[f] ( COMMA )? )+
        	    {
        	         MATCHT(RECURSIVE_FUNCTION_TOK, &FOLLOW_RECURSIVE_FUNCTION_TOK_in_mainCommand3149);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:892:28: ( identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )? )+
        	        {
        	            int cnt32=0;

        	            for (;;)
        	            {
        	                int alt32=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case IDENTIFIER:
        	        		{
        	        			alt32=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt32)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:892:29: identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ( COMMA )?
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_identifier_in_mainCommand3152);
        	        	            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if(idCommaFlag){
        	        	                        idCommaFlag=false;
        	        	                      }
        	        	                      else{
        	        	                        PARSER_STATE->parseError("Identifiers need to be comma separated");
        	        	                      }
        	        	                    
        	        	            }


        	        	             MATCHT(COLON, &FOLLOW_COLON_in_mainCommand3166);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_type_in_mainCommand3168);
        	        	            type(ctx, t, CHECK_DECLARED);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            // ../../../../src/parser/cvc/Cvc.g:901:34: ( COMMA )?
        	        	            {
        	        	                int alt31=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                    case COMMA:
        	        	                    	{
        	        	                    		alt31=1;
        	        	                    	}
        	        	                        break;
        	        	                }

        	        	                switch (alt31)
        	        	                {
        	        	            	case 1:
        	        	            	    // ../../../../src/parser/cvc/Cvc.g:901:35: COMMA
        	        	            	    {
        	        	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3172);
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto rulemainCommandEx;
        	        	            	        }
        	        	            	        if (HASFAILED())
        	        	            	        {
        	        	            	            return ;
        	        	            	        }


        	        	            	        if ( BACKTRACKING==0 )
        	        	            	        {

        	        	            	                  idCommaFlag=true;
        	        	            	                  
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	                }
        	        	            }

        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      func = PARSER_STATE->mkVar(id, t, ExprManager::VAR_FLAG_NONE, true);
        	        	                      ids.push_back(id);
        	        	                      types.push_back(t);
        	        	                      funcs.push_back(func);
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt32 >= 1 )
        	        		{
        	        		    goto loop32;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulemainCommandEx;
        	        	}
        	        	cnt32++;
        	            }
        	            loop32: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand3191);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:910:15: ( formula[f] ( COMMA )? )+
        	        {
        	            int cnt34=0;

        	            for (;;)
        	            {
        	                int alt34=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ABS_TOK:
        	        	case ARRAY_TOK:
        	        	case BAR:
        	        	case BINARY_LITERAL:
        	        	case BVASHR_TOK:
        	        	case BVCOMP_TOK:
        	        	case BVGE_TOK:
        	        	case BVGT_TOK:
        	        	case BVLE_TOK:
        	        	case BVLSHR_TOK:
        	        	case BVLT_TOK:
        	        	case BVMULT_TOK:
        	        	case BVNAND_TOK:
        	        	case BVNEG_TOK:
        	        	case BVNOR_TOK:
        	        	case BVPLUS_TOK:
        	        	case BVREPEAT_TOK:
        	        	case BVROTL_TOK:
        	        	case BVROTR_TOK:
        	        	case BVSDIV_TOK:
        	        	case BVSGE_TOK:
        	        	case BVSGT_TOK:
        	        	case BVSHL_TOK:
        	        	case BVSLE_TOK:
        	        	case BVSLT_TOK:
        	        	case BVSMOD_TOK:
        	        	case BVSREM_TOK:
        	        	case BVSUB_TOK:
        	        	case BVUDIV_TOK:
        	        	case BVUMINUS_TOK:
        	        	case BVUREM_TOK:
        	        	case BVXNOR_TOK:
        	        	case BVXOR_TOK:
        	        	case BVZEROEXTEND_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DISTINCT_TOK:
        	        	case DIVISIBLE_TOK:
        	        	case EXISTS_TOK:
        	        	case FALSE_TOK:
        	        	case FLOOR_TOK:
        	        	case FORALL_TOK:
        	        	case HEX_LITERAL:
        	        	case IDENTIFIER:
        	        	case IDEN_TOK:
        	        	case IF_TOK:
        	        	case INTEGER_LITERAL:
        	        	case IS_INTEGER_TOK:
        	        	case LAMBDA_TOK:
        	        	case LBRACE:
        	        	case LET_TOK:
        	        	case LPAREN:
        	        	case MINUS_TOK:
        	        	case NOT_TOK:
        	        	case PARENHASH:
        	        	case SETS_CARD_TOK:
        	        	case STRING_CHARAT_TOK:
        	        	case STRING_CONCAT_TOK:
        	        	case STRING_CONTAINS_TOK:
        	        	case STRING_INDEXOF_TOK:
        	        	case STRING_ITOS_TOK:
        	        	case STRING_LENGTH_TOK:
        	        	case STRING_LITERAL:
        	        	case STRING_PREFIXOF_TOK:
        	        	case STRING_REPLACE_TOK:
        	        	case STRING_STOI_TOK:
        	        	case STRING_SUBSTR_TOK:
        	        	case STRING_SUFFIXOF_TOK:
        	        	case SX_TOK:
        	        	case TRANSCLOSURE_TOK:
        	        	case TRANSPOSE_TOK:
        	        	case TRUE_TOK:
        	        	case TUPLE_TOK:
        	        	case UNIVSET_TOK:
        	        		{
        	        			alt34=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt34)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:910:16: formula[f] ( COMMA )?
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_formula_in_mainCommand3194);
        	        	            formula(ctx, f);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulemainCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if(formCommaFlag){
        	        	                        formCommaFlag=false;
        	        	                      }
        	        	                      else{
        	        	                        PARSER_STATE->parseError("Function definitions need to be comma separated");
        	        	                      }
        	        	                    
        	        	            }


        	        	            // ../../../../src/parser/cvc/Cvc.g:919:5: ( COMMA )?
        	        	            {
        	        	                int alt33=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                    case COMMA:
        	        	                    	{
        	        	                    		alt33=1;
        	        	                    	}
        	        	                        break;
        	        	                }

        	        	                switch (alt33)
        	        	                {
        	        	            	case 1:
        	        	            	    // ../../../../src/parser/cvc/Cvc.g:919:6: COMMA
        	        	            	    {
        	        	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand3208);
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto rulemainCommandEx;
        	        	            	        }
        	        	            	        if (HASFAILED())
        	        	            	        {
        	        	            	            return ;
        	        	            	        }


        	        	            	        if ( BACKTRACKING==0 )
        	        	            	        {

        	        	            	                  formCommaFlag=true;
        	        	            	                
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	                }
        	        	            }

        	        	            if ( BACKTRACKING==0 )
        	        	            {

        	        	                      if( f.getKind()==kind::LAMBDA ){
        	        	                        bvs.insert(bvs.end(), f[0].begin(), f[0].end());
        	        	                        formals.push_back(bvs);
        	        	                        bvs.clear();
        	        	                        f = f[1];
        	        	                        formulas.push_back(f);
        	        	                      }
        	        	                      else {
        	        	                        formals.push_back(bvs);
        	        	                        formulas.push_back(f);
        	        	                      }
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt34 >= 1 )
        	        		{
        	        		    goto loop34;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulemainCommandEx;
        	        	}
        	        	cnt34++;
        	            }
        	            loop34: ;	/* Jump to here if this rule does not match */
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(idCommaFlag){
        	                    PARSER_STATE->parseError("Cannot end function list with comma");
        	                  }
        	                  if(formCommaFlag){
        	                    PARSER_STATE->parseError("Cannot end function definition list with comma");
        	                  }
        	                  if(funcs.size()!=formulas.size()){
        	                    PARSER_STATE->parseError("Number of functions doesn't match number of function definitions");
        	                  }
        	                  for(unsigned int i = 0, size = funcs.size(); i < size; i++){
        	                    if(!funcs[i].getType().isSubtypeOf(types[i])){
        	                      PARSER_STATE->parseError("Type mismatch in definition");
        	                    }
        	                  }
        	                  cmd->reset(new DefineFunctionRecCommand(funcs,formals,formulas));
        	                
        	        }


        	    }
        	    break;
        	case 43:
        	    // ../../../../src/parser/cvc/Cvc.g:952:5: toplevelDeclaration[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_toplevelDeclaration_in_mainCommand3231);
        	        toplevelDeclaration(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulemainCommandEx; /* Prevent compiler warnings */
    rulemainCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end mainCommand */

/**
 * $ANTLR start simpleSymbolicExpr
 * ../../../../src/parser/cvc/Cvc.g:955:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER );
 */
static void
simpleSymbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::string s;
      CVC4::Rational r;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL10;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL11;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL12;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL13;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL14;
    pANTLR3_COMMON_TOKEN    IDENTIFIER15;

    /* Initialize rule variables
     */

    INTEGER_LITERAL10       = NULL;
    INTEGER_LITERAL11       = NULL;
    DECIMAL_LITERAL12       = NULL;
    HEX_LITERAL13       = NULL;
    BINARY_LITERAL14       = NULL;
    IDENTIFIER15       = NULL;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:960:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER )

            ANTLR3_UINT32 alt36;

            alt36=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt36=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt36=2;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt36=3;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt36=4;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt36=5;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt36=6;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt36=7;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 36;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt36)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:960:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3251);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL10))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:962:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_simpleSymbolicExpr3263);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        INTEGER_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr3265);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(-Integer(AntlrInput::tokenText(INTEGER_LITERAL11))); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:964:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr3277);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL12)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:966:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr3289);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(HEX_LITERAL13)); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:968:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr3301);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(BINARY_LITERAL14)); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:970:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExpr3313);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:972:5: IDENTIFIER
        	    {
        	        IDENTIFIER15 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_simpleSymbolicExpr3326);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(IDENTIFIER15)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * ../../../../src/parser/cvc/Cvc.g:976:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN );
 */
static void
symbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:980:3: ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN )

            ANTLR3_UINT32 alt38;

            alt38=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case IDENTIFIER:
            case INTEGER_LITERAL:
            case MINUS_TOK:
            case STRING_LITERAL:
            	{
            		alt38=1;
            	}
                break;
            case LPAREN:
            	{
            		alt38=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 38;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt38)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:980:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3351);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:981:5: LPAREN ( symbolicExpr[sexpr] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_symbolicExpr3358);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:981:12: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt37=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt37=1;
        	            	}
        	                break;

        	            }

        	            switch (alt37)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:981:13: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3361);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop37;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop37: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_symbolicExpr3369);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start toplevelDeclaration
 * ../../../../src/parser/cvc/Cvc.g:988:1: toplevelDeclaration[std::unique_ptr<CVC4::Command>* cmd] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) ;
 */
static void
toplevelDeclaration(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      Debug("parser-extra") << "declaration: " << AntlrInput::tokenText(LT(1))
                            << std::endl;

    {
        // ../../../../src/parser/cvc/Cvc.g:995:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) )
        // ../../../../src/parser/cvc/Cvc.g:995:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_toplevelDeclaration3396);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_toplevelDeclaration3399);
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:996:5: ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
            {
                int alt39=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BITVECTOR_TOK:
                case BOOLEAN_TOK:
                case IDENTIFIER:
                case INT_TOK:
                case LBRACKET:
                case LET_TOK:
                case LPAREN:
                case REAL_TOK:
                case SET_TOK:
                case SQHASH:
                case STRING_TOK:
                case SUBTYPE_TOK:
                	{
                		alt39=1;
                	}
                    break;
                case TYPE_TOK:
                	{
                		alt39=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 39;
                    EXCEPTION->state        = 0;


                    goto ruletoplevelDeclarationEx;

                }

                switch (alt39)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:996:7: declareVariables[cmd,t,ids,true]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareVariables_in_toplevelDeclaration3407);
            	        declareVariables(ctx, cmd, t, ids, true);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:997:7: declareTypes[cmd,ids]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareTypes_in_toplevelDeclaration3416);
            	        declareTypes(ctx, cmd, ids);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletoplevelDeclarationEx; /* Prevent compiler warnings */
    ruletoplevelDeclarationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end toplevelDeclaration */

/**
 * $ANTLR start boundVarDecl
 * ../../../../src/parser/cvc/Cvc.g:1003:1: boundVarDecl[std::vector<std::string>& ids, CVC4::Type& t] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] ;
 */
static void
boundVarDecl(pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t)
{
    /* Initialize rule variables
     */


      std::unique_ptr<Command> local_cmd;

    {
        // ../../../../src/parser/cvc/Cvc.g:1007:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false] )
        // ../../../../src/parser/cvc/Cvc.g:1007:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[&local_cmd,t,ids,false]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDecl3440);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDecl3443);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_declareVariables_in_boundVarDecl3449);
            declareVariables(ctx, &local_cmd, t, ids, false);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclEx; /* Prevent compiler warnings */
    ruleboundVarDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecl */

/**
 * $ANTLR start boundVarDecls
 * ../../../../src/parser/cvc/Cvc.g:1014:1: boundVarDecls : boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* ;
 */
static void
boundVarDecls(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1019:3: ( boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* )
        // ../../../../src/parser/cvc/Cvc.g:1019:5: boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3470);
            boundVarDecl(ctx, ids, t);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1019:25: ( COMMA boundVarDecl[ids,t] )*

            for (;;)
            {
                int alt40=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt40=1;
                	}
                    break;

                }

                switch (alt40)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1019:27: COMMA boundVarDecl[ids,t]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDecls3475);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3477);
            	        boundVarDecl(ctx, ids, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop40;	/* break out of the loop */
            	    break;
                }
            }
            loop40: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsEx; /* Prevent compiler warnings */
    ruleboundVarDeclsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecls */

/**
 * $ANTLR start boundVarDeclsReturn
 * ../../../../src/parser/cvc/Cvc.g:1022:1: boundVarDeclsReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* ;
 */
static void
boundVarDeclsReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      terms.clear();
      types.clear();

    {
        // ../../../../src/parser/cvc/Cvc.g:1030:3: ( boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* )
        // ../../../../src/parser/cvc/Cvc.g:1030:5: boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3500);
            boundVarDeclReturn(ctx, terms, types);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1030:37: ( COMMA boundVarDeclReturn[terms,types] )*

            for (;;)
            {
                int alt41=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt41=1;
                	}
                    break;

                }

                switch (alt41)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1030:39: COMMA boundVarDeclReturn[terms,types]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDeclsReturn3505);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3507);
            	        boundVarDeclReturn(ctx, terms, types);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop41;	/* break out of the loop */
            	    break;
                }
            }
            loop41: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclsReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclsReturn */

/**
 * $ANTLR start boundVarDeclReturn
 * ../../../../src/parser/cvc/Cvc.g:1033:1: boundVarDeclReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ;
 */
static void
boundVarDeclReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      // NOTE: do not clear the vectors here!

    {
        // ../../../../src/parser/cvc/Cvc.g:1040:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] )
        // ../../../../src/parser/cvc/Cvc.g:1040:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDeclReturn3530);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDeclReturn3533);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_boundVarDeclReturn3535);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 const std::vector<Expr>& vars = PARSER_STATE->mkBoundVars(ids, t);
                      terms.insert(terms.end(), vars.begin(), vars.end());
                      for(unsigned i = 0; i < vars.size(); ++i) {
                        types.push_back(t);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclReturn */

/**
 * $ANTLR start declareTypes
 * ../../../../src/parser/cvc/Cvc.g:1056:1: declareTypes[std::unique_ptr<CVC4::Command>* cmd,\n const std::vector<std::string>& idList] : ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] );
 */
static void
declareTypes(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, const std::vector<std::string>& idList)
{
    /* Initialize rule variables
     */


      Type t;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1062:3: ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] )

            ANTLR3_UINT32 alt42;

            alt42=2;

            switch ( LA(1) )
            {
            case TYPE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				alt42=2;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt42=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 42;
            		    EXCEPTION->state        = 1;


            		    goto ruledeclareTypesEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 42;
                EXCEPTION->state        = 0;


                goto ruledeclareTypesEx;

            }

            switch (alt42)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1062:5: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3569);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::unique_ptr<DeclarationSequence> seq(new DeclarationSequence());
        	                  for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end(); ++i) {
        	                    // Don't allow a type variable to clash with a previously
        	                    // declared type variable, however a type variable and a
        	                    // non-type variable can clash unambiguously.  Break from CVC3
        	                    // behavior here.
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    Type sort = PARSER_STATE->mkSort(*i);
        	                    Command* decl = new DeclareTypeCommand(*i, 0, sort);
        	                    seq->addCommand(decl);
        	                  }
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1079:5: TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3588);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareTypes3590);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_declareTypes3592);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end();
        	                      ++i) {
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    PARSER_STATE->defineType(*i, t);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledeclareTypesEx; /* Prevent compiler warnings */
    ruledeclareTypesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareTypes */

/**
 * $ANTLR start declareVariables
 * ../../../../src/parser/cvc/Cvc.g:1098:1: declareVariables[std::unique_ptr<CVC4::Command>* cmd, CVC4::Type& t,\n const std::vector<std::string>& idList, bool topLevel] : type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? ;
 */
static void
declareVariables(pCvcParser ctx, std::unique_ptr<CVC4::Command>* cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel)
{
    /* Initialize rule variables
     */


      Expr f;
      Debug("parser-extra") << "declType: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // ../../../../src/parser/cvc/Cvc.g:1105:3: ( type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? )
        // ../../../../src/parser/cvc/Cvc.g:1105:5: type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )?
        {
            FOLLOWPUSH(FOLLOW_type_in_declareVariables3626);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledeclareVariablesEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1105:28: ( EQUAL_TOK formula[f] )?
            {
                int alt43=2;
                switch ( LA(1) )
                {
                    case EQUAL_TOK:
                    	{
                    		alt43=1;
                    	}
                        break;
                }

                switch (alt43)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1105:30: EQUAL_TOK formula[f]
            	    {
            	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareVariables3631);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_declareVariables3633);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 std::unique_ptr<DeclarationSequence> seq;
                      if(topLevel) {
                        seq.reset(new DeclarationSequence());
                      }
                      if(f.isNull()) {
                        Debug("parser") << "working on " << idList.front() << " : " << t
                                        << std::endl;
                        // CVC language allows redeclaration of variables if types are the same
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          if(PARSER_STATE->isDeclared(*i, SYM_VARIABLE)) {
                            Type oldType = PARSER_STATE->getVariable(*i).getType();
                            Debug("parser") << "  " << *i << " was declared previously "
                                            << "with type " << oldType << std::endl;
                            if(oldType != t) {
                              std::stringstream ss;
                              ss << language::SetLanguage(language::output::LANG_CVC4)
                                 << "incompatible type for `" << *i << "':" << std::endl
                                 << "  old type: " << oldType << std::endl
                                 << "  new type: " << t << std::endl;
                              PARSER_STATE->parseError(ss.str());
                            } else {
                              Debug("parser") << "  types " << t << " and " << oldType
                                              << " are compatible" << std::endl;
                            }
                          } else {
                            Debug("parser") << "  " << *i << " not declared" << std::endl;
                            if(topLevel) {
                              Expr func = PARSER_STATE->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL);
                              Command* decl = new DeclareFunctionCommand(*i, func, t);
                              seq->addCommand(decl);
                            } else {
                              PARSER_STATE->mkBoundVar(*i, t);
                            }
                          }
                        }
                      } else {
                        // f is not null-- meaning this is a definition not a declaration
                        //Check if the formula f has the correct type, declared as t.
                        if(!f.getType().isSubtypeOf(t)){
                          PARSER_STATE->parseError("Type mismatch in definition");
                        }
                        if(!topLevel) {
                          // must be top-level; doesn't make sense to write something
                          // like e.g. FORALL(x:INT = 4): [...]
                          PARSER_STATE->parseError("cannot construct a definition here; maybe you want a LET");
                        }
                        assert(!idList.empty());
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          Debug("parser") << "making " << *i << " : " << t << " = " << f << std::endl;
                          PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_VARIABLE);
                          Expr func = EXPR_MANAGER->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL | ExprManager::VAR_FLAG_DEFINED);
                          PARSER_STATE->defineFunction(*i, f);
                          Command* decl = new DefineFunctionCommand(*i, func, f);
                          seq->addCommand(decl);
                        }
                      }
                      if(topLevel) {
                        cmd->reset(new DeclarationSequence());
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledeclareVariablesEx; /* Prevent compiler warnings */
    ruledeclareVariablesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareVariables */

/**
 * $ANTLR start identifierList
 * ../../../../src/parser/cvc/Cvc.g:1180:1: identifierList[std::vector<std::string>& idList,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : identifier[id,check,type] ( COMMA identifier[id,check,type] )* ;
 */
static void
identifierList(pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    /* Initialize rule variables
     */


      std::string id;
      idList.clear();

    {
        // ../../../../src/parser/cvc/Cvc.g:1187:3: ( identifier[id,check,type] ( COMMA identifier[id,check,type] )* )
        // ../../../../src/parser/cvc/Cvc.g:1187:5: identifier[id,check,type] ( COMMA identifier[id,check,type] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_identifierList3664);
            identifier(ctx, id, check, type);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleidentifierListEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 idList.push_back(id); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1188:5: ( COMMA identifier[id,check,type] )*

            for (;;)
            {
                int alt44=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt44=1;
                	}
                    break;

                }

                switch (alt44)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1188:7: COMMA identifier[id,check,type]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_identifierList3675);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_identifierList3677);
            	        identifier(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             idList.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop44;	/* break out of the loop */
            	    break;
                }
            }
            loop44: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierListEx; /* Prevent compiler warnings */
    ruleidentifierListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifierList */

/**
 * $ANTLR start identifier
 * ../../../../src/parser/cvc/Cvc.g:1194:1: identifier[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : IDENTIFIER ;
 */
static void
identifier(pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER16;

    /* Initialize rule variables
     */

    IDENTIFIER16       = NULL;

    {
        // ../../../../src/parser/cvc/Cvc.g:1197:3: ( IDENTIFIER )
        // ../../../../src/parser/cvc/Cvc.g:1197:5: IDENTIFIER
        {
            IDENTIFIER16 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_identifier3699);
            if  (HASEXCEPTION())
            {
                goto ruleidentifierEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 id = AntlrInput::tokenText(IDENTIFIER16);
                      PARSER_STATE->checkDeclaration(id, check, type); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierEx; /* Prevent compiler warnings */
    ruleidentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifier */

/**
 * $ANTLR start type
 * ../../../../src/parser/cvc/Cvc.g:1214:1: type[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] );
 */
static void
type(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t2;
      bool lhs;
      std::vector<Type> args;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1222:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] )

            ANTLR3_UINT32 alt47;

            alt47=2;

            switch ( LA(1) )
            {
            case ARRAY_TOK:
            case BITVECTOR_TOK:
            case BOOLEAN_TOK:
            case IDENTIFIER:
            case INT_TOK:
            case LBRACKET:
            case LPAREN:
            case REAL_TOK:
            case SET_TOK:
            case SQHASH:
            case STRING_TOK:
            case SUBTYPE_TOK:
            	{
            		alt47=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt47=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto ruletypeEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1222:5: restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3732);
        	        restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) {
        	                    assert(t.isTuple());
        	                    args = ((DatatypeType)t).getTupleTypes();
        	                  } else {
        	                    args.push_back(t);
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1230:5: ( ARROW_TOK type[t2,check] )?
        	        {
        	            int alt45=2;
        	            switch ( LA(1) )
        	            {
        	                case ARROW_TOK:
        	                	{
        	                		alt45=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt45)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1230:7: ARROW_TOK type[t2,check]
        	        	    {
        	        	         MATCHT(ARROW_TOK, &FOLLOW_ARROW_TOK_in_type3747);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_type3749);
        	        	        type(ctx, t2, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(t2); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(t2.isNull()) {
        	                    if(lhs) {
        	                      PARSER_STATE->parseError("improperly-placed type list; expected `->' after to define a function; or else maybe these parentheses were meant to be square brackets, to define a tuple type?");
        	                    }
        	                  } else {
        	                    t = EXPR_MANAGER->mkFunctionType(args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1243:5: LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_type3774);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3782);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1244:24: ( COMMA typeLetDecl[check] )*

        	        for (;;)
        	        {
        	            int alt46=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt46=1;
        	            	}
        	                break;

        	            }

        	            switch (alt46)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1244:26: COMMA typeLetDecl[check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_type3787);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3789);
        	        	        typeLetDecl(ctx, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop46;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop46: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_type3795);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_type3797);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeEx; /* Prevent compiler warnings */
    ruletypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end type */

/**
 * $ANTLR start restrictedType
 * ../../../../src/parser/cvc/Cvc.g:1258:1: restrictedType[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : restrictedTypePossiblyFunctionLHS[t,check,lhs] ;
 */
static void
restrictedType(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      bool lhs;

    {
        // ../../../../src/parser/cvc/Cvc.g:1263:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] )
        // ../../../../src/parser/cvc/Cvc.g:1263:5: restrictedTypePossiblyFunctionLHS[t,check,lhs]
        {
            FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3833);
            restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerestrictedTypeEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 if(lhs) { PARSER_STATE->parseError("improperly-placed type list; maybe these parentheses were meant to be square brackets, to define a tuple type?"); } 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypeEx; /* Prevent compiler warnings */
    rulerestrictedTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedType */

/**
 * $ANTLR start restrictedTypePossiblyFunctionLHS
 * ../../../../src/parser/cvc/Cvc.g:1271:1: restrictedTypePossiblyFunctionLHS[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check,\n bool& lhs] : ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET bound DOTDOT bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN );
 */
static void
restrictedTypePossiblyFunctionLHS(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Type t2;
      Expr f, f2;
      std::string id;
      std::vector<Type> types;
      std::vector< std::pair<std::string, Type> > typeIds;
      //SymbolTable* symtab;
      Parser* parser;
      lhs = false;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1285:3: ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET bound DOTDOT bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN )

            ANTLR3_UINT32 alt55;

            alt55=13;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		alt55=1;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt55=2;
            	}
                break;
            case SET_TOK:
            	{
            		alt55=3;
            	}
                break;
            case SUBTYPE_TOK:
            	{
            		alt55=4;
            	}
                break;
            case LBRACKET:
            	{
            		switch ( LA(2) )
            		{
            		case INTEGER_LITERAL:
            		case MINUS_TOK:
            		case UNDERSCORE:
            			{
            				alt55=5;
            			}
            		    break;
            		case ARRAY_TOK:
            		case BITVECTOR_TOK:
            		case BOOLEAN_TOK:
            		case IDENTIFIER:
            		case INT_TOK:
            		case LBRACKET:
            		case LET_TOK:
            		case LPAREN:
            		case RBRACKET:
            		case REAL_TOK:
            		case SET_TOK:
            		case SQHASH:
            		case STRING_TOK:
            		case SUBTYPE_TOK:
            			{
            				alt55=6;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 55;
            		    EXCEPTION->state        = 5;


            		    goto rulerestrictedTypePossiblyFunctionLHSEx;

            		}

            	}
                break;
            case SQHASH:
            	{
            		alt55=7;
            	}
                break;
            case BITVECTOR_TOK:
            	{
            		alt55=8;
            	}
                break;
            case STRING_TOK:
            	{
            		alt55=9;
            	}
                break;
            case BOOLEAN_TOK:
            	{
            		alt55=10;
            	}
                break;
            case REAL_TOK:
            	{
            		alt55=11;
            	}
                break;
            case INT_TOK:
            	{
            		alt55=12;
            	}
                break;
            case LPAREN:
            	{
            		alt55=13;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 55;
                EXCEPTION->state        = 0;


                goto rulerestrictedTypePossiblyFunctionLHSEx;

            }

            switch (alt55)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1285:5: identifier[id,check,SYM_SORT] ( parameterization[check,types] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3867);
        	        identifier(ctx, id, check, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1286:5: ( parameterization[check,types] )?
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	                case LBRACKET:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case IDENTIFIER:
        	                		    	{
        	                		    		switch ( LA(3) )
        	                		    		{
        	                		    		    case COMMA:
        	                		    		    case LBRACKET:
        	                		    		    case RBRACKET:
        	                		    		    	{
        	                		    		    		alt48=1;
        	                		    		    	}
        	                		    		        break;
        	                		    		}

        	                		    	}
        	                		        break;
        	                		    case ARRAY_TOK:
        	                		    case BITVECTOR_TOK:
        	                		    case BOOLEAN_TOK:
        	                		    case INT_TOK:
        	                		    case LBRACKET:
        	                		    case LPAREN:
        	                		    case REAL_TOK:
        	                		    case SET_TOK:
        	                		    case SQHASH:
        	                		    case STRING_TOK:
        	                		    case SUBTYPE_TOK:
        	                		    	{
        	                		    		alt48=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1286:5: parameterization[check,types]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3874);
        	        	        parameterization(ctx, check, types);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(check == CHECK_DECLARED ||
        	                     PARSER_STATE->isDeclared(id, SYM_SORT)) {
        	                    Debug("parser-param") << "param: getSort " << id << " " << types.size() << " " << PARSER_STATE->getArity( id )
        	                                          << " " << PARSER_STATE->isDeclared(id, SYM_SORT) << std::endl;
        	                    if(types.size() != PARSER_STATE->getArity(id)) {
        	                      std::stringstream ss;
        	                      ss << "incorrect arity for symbol `" << id << "': expected "
        	                         << PARSER_STATE->getArity( id ) << " type arguments, got "
        	                         << types.size();
        	                      PARSER_STATE->parseError(ss.str());
        	                    }
        	                    if(types.size() > 0) {
        	                      t = PARSER_STATE->getSort(id, types);
        	                    }else{
        	                      t = PARSER_STATE->getSort(id);
        	                    }
        	                  } else {
        	                    if(types.empty()) {
        	                      t = PARSER_STATE->mkUnresolvedType(id);
        	                      Debug("parser-param") << "param: make unres type " << id << std::endl;
        	                    }else{
        	                      t = PARSER_STATE->mkUnresolvedTypeConstructor(id,types);
        	                      t = SortConstructorType(t).instantiate( types );
        	                      Debug("parser-param") << "param: make unres param type " << id << " " << types.size() << " "
        	                                            << PARSER_STATE->getArity( id ) << std::endl;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1318:5: ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3895);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3897);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3900);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3902);
        	        restrictedType(ctx, t2, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkArrayType(t, t2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1320:5: SET_TOK OF_TOK restrictedType[t,check]
        	    {
        	         MATCHT(SET_TOK, &FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3915);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3917);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3919);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkSetType(t); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1324:5: SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN
        	    {
        	         MATCHT(SUBTYPE_TOK, &FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3942);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3944);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*symtab = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(new SymbolTable());*/ 
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3962);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1331:16: ( COMMA formula[f2] )?
        	        {
        	            int alt49=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA:
        	                	{
        	                		alt49=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt49)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1331:18: COMMA formula[f2]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3967);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3969);
        	        	        formula(ctx, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3975);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*SymbolTable* old = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(symtab);
        	                  delete old;*/
        	                  PARSER_STATE->unimplementedFeature("predicate subtyping not supported in this release");
        	                  /*t = f2.isNull() ?
        	                    EXPR_MANAGER->mkPredicateSubtype(f) :
        	                    EXPR_MANAGER->mkPredicateSubtype(f, f2);
        	                  */
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:1343:5: LBRACKET bound DOTDOT bound RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3994);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3996);
        	        bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(DOTDOT, &FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3998);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS4000);
        	        bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4002);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->unimplementedFeature("subrange typing not supported in this release");
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/cvc/Cvc.g:1349:5: LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS4021);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1349:14: ( type[t,check] ( COMMA type[t,check] )* )?
        	        {
        	            int alt51=2;
        	            switch ( LA(1) )
        	            {
        	                case ARRAY_TOK:
        	                case BITVECTOR_TOK:
        	                case BOOLEAN_TOK:
        	                case IDENTIFIER:
        	                case INT_TOK:
        	                case LBRACKET:
        	                case LET_TOK:
        	                case LPAREN:
        	                case REAL_TOK:
        	                case SET_TOK:
        	                case SQHASH:
        	                case STRING_TOK:
        	                case SUBTYPE_TOK:
        	                	{
        	                		alt51=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt51)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1349:16: type[t,check] ( COMMA type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4025);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             types.push_back(t); 
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:1350:5: ( COMMA type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt50=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt50=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt50)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1350:7: COMMA type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4036);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4038);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             types.push_back(t); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop50;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop50: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS4049);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(types.size() == 1 && types.front().isFunction()) {
        	                    // old style function syntax [ T -> U ]
        	                    PARSER_STATE->parseError("old-style function type syntax not supported anymore; please use the new syntax");
        	                  } else {
        	                    // tuple type [ T, U, V... ]
        	                    t = EXPR_MANAGER->mkTupleType(types);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/cvc/Cvc.g:1361:5: SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ
        	    {
        	         MATCHT(SQHASH, &FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS4068);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1361:12: ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )?
        	        {
        	            int alt53=2;
        	            switch ( LA(1) )
        	            {
        	                case IDENTIFIER:
        	                	{
        	                		alt53=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt53)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1361:14: identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4072);
        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4075);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4077);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        }


        	        	        // ../../../../src/parser/cvc/Cvc.g:1362:5: ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt52=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt52=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt52)
        	        	            {
        	        	        	case 1:
        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1362:7: COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4088);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS4090);
        	        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS4093);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4095);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop52;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop52: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(HASHSQ, &FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS4106);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkRecordType(typeIds); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/cvc/Cvc.g:1366:5: BITVECTOR_TOK LPAREN k= numeral RPAREN
        	    {
        	         MATCHT(BITVECTOR_TOK, &FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS4125);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4127);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS4131);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4133);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k == 0) {
        	                    PARSER_STATE->parseError("Illegal bitvector size: 0");
        	                  }
        	                  t = EXPR_MANAGER->mkBitVectorType(k);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/cvc/Cvc.g:1374:5: STRING_TOK
        	    {
        	         MATCHT(STRING_TOK, &FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS4152);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->stringType(); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/cvc/Cvc.g:1377:5: BOOLEAN_TOK
        	    {
        	         MATCHT(BOOLEAN_TOK, &FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS4167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->booleanType(); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/cvc/Cvc.g:1378:5: REAL_TOK
        	    {
        	         MATCHT(REAL_TOK, &FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS4175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->realType(); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/cvc/Cvc.g:1379:5: INT_TOK
        	    {
        	         MATCHT(INT_TOK, &FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS4183);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->integerType(); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/cvc/Cvc.g:1384:5: LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS4198);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4200);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             types.push_back(t); 
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1385:5: ( COMMA type[t,check] )*

        	        for (;;)
        	        {
        	            int alt54=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt54=1;
        	            	}
        	                break;

        	            }

        	            switch (alt54)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1385:7: COMMA type[t,check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS4211);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS4213);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             lhs = true; types.push_back(t); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop54;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop54: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS4221);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) { t = EXPR_MANAGER->mkTupleType(types); }
        	                  // if !lhs, t is already set up correctly, nothing to do..
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypePossiblyFunctionLHSEx; /* Prevent compiler warnings */
    rulerestrictedTypePossiblyFunctionLHSEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedTypePossiblyFunctionLHS */

/**
 * $ANTLR start parameterization
 * ../../../../src/parser/cvc/Cvc.g:1391:1: parameterization[CVC4::parser::DeclarationCheck check,\n std::vector<CVC4::Type>& params] : LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET ;
 */
static void
parameterization(pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params)
{
    /* Initialize rule variables
     */


      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1396:3: ( LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET )
        // ../../../../src/parser/cvc/Cvc.g:1396:5: LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_parameterization4246);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4248);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1397:5: ( COMMA restrictedType[t,check] )*

            for (;;)
            {
                int alt56=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt56=1;
                	}
                    break;

                }

                switch (alt56)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1397:7: COMMA restrictedType[t,check]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_parameterization4259);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization4261);
            	        restrictedType(ctx, t, check);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop56;	/* break out of the loop */
            	    break;
                }
            }
            loop56: ; /* Jump out to here if this rule does not match */


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_parameterization4269);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparameterizationEx; /* Prevent compiler warnings */
    ruleparameterizationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parameterization */

/**
 * $ANTLR start bound
 * ../../../../src/parser/cvc/Cvc.g:1400:1: bound : ( UNDERSCORE | integer );
 */
static void
bound(pCvcParser ctx)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1401:3: ( UNDERSCORE | integer )

            ANTLR3_UINT32 alt57;

            alt57=2;

            switch ( LA(1) )
            {
            case UNDERSCORE:
            	{
            		alt57=1;
            	}
                break;
            case INTEGER_LITERAL:
            case MINUS_TOK:
            	{
            		alt57=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 57;
                EXCEPTION->state        = 0;


                goto ruleboundEx;

            }

            switch (alt57)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1401:5: UNDERSCORE
        	    {
        	         MATCHT(UNDERSCORE, &FOLLOW_UNDERSCORE_in_bound4282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1402:5: integer
        	    {
        	        FOLLOWPUSH(FOLLOW_integer_in_bound4288);
        	        integer(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleboundEx; /* Prevent compiler warnings */
    ruleboundEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bound */

/**
 * $ANTLR start typeLetDecl
 * ../../../../src/parser/cvc/Cvc.g:1405:1: typeLetDecl[CVC4::parser::DeclarationCheck check] : identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] ;
 */
static void
typeLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t;
      std::string id;

    {
        // ../../../../src/parser/cvc/Cvc.g:1410:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] )
        // ../../../../src/parser/cvc/Cvc.g:1410:5: identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_typeLetDecl4305);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1410:40: ( COLON TYPE_TOK )?
            {
                int alt58=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		alt58=1;
                    	}
                        break;
                }

                switch (alt58)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1410:41: COLON TYPE_TOK
            	    {
            	         MATCHT(COLON, &FOLLOW_COLON_in_typeLetDecl4309);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_typeLetDecl4311);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_typeLetDecl4315);
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_typeLetDecl4317);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->defineType(id, t); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeLetDeclEx; /* Prevent compiler warnings */
    ruletypeLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeLetDecl */

/**
 * $ANTLR start formula
 * ../../../../src/parser/cvc/Cvc.g:1421:1: formula[CVC4::Expr& f] : n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static void
formula(pCvcParser ctx, CVC4::Expr& f)
{
    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */


      Debug("parser-extra") << "formula: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Expr f2;
      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1429:3: (n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // ../../../../src/parser/cvc/Cvc.g:1429:5: n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_nots_in_formula4347);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleformulaEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1430:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt60=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA_TOK:
                case LET_TOK:
                	{
                		alt60=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt60=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 60;
                    EXCEPTION->state        = 0;


                    goto ruleformulaEx;

                }

                switch (alt60)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1430:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_formula4355);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1432:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_formula4372);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1436:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt59=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case JOIN_IMAGE_TOK:
            	                case JOIN_TOK:
            	                case OR_TOK:
            	                case PRODUCT_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt59=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt59)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1436:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_formula4389);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleformulaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruleformulaEx; /* Prevent compiler warnings */
    ruleformulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end formula */

/**
 * $ANTLR start morecomparisons
 * ../../../../src/parser/cvc/Cvc.g:1441:1: morecomparisons[std::vector<CVC4::Expr>& expressions,\n std::vector<unsigned>& operators] returns [size_t i = 0] : booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static size_t
morecomparisons(pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators)
{
    size_t i;


    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */
    i =  0;



      unsigned op;
      Expr f;
      i= expressions.size();


    {
        // ../../../../src/parser/cvc/Cvc.g:1448:3: ( booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // ../../../../src/parser/cvc/Cvc.g:1448:5: booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_booleanBinop_in_morecomparisons4428);
            booleanBinop(ctx, op);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            if ( BACKTRACKING==0 )
            {
                 operators.push_back(op); 
            }


            FOLLOWPUSH(FOLLOW_nots_in_morecomparisons4439);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            // ../../../../src/parser/cvc/Cvc.g:1450:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt62=2;
                switch ( LA(1) )
                {
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA_TOK:
                case LET_TOK:
                	{
                		alt62=1;
                	}
                    break;
                case ABS_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case SX_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                	{
                		alt62=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return i;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 62;
                    EXCEPTION->state        = 0;


                    goto rulemorecomparisonsEx;

                }

                switch (alt62)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1450:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_morecomparisons4447);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(addNots(EXPR_MANAGER, n, f)); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1452:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_morecomparisons4464);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1456:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt61=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case JOIN_IMAGE_TOK:
            	                case JOIN_TOK:
            	                case OR_TOK:
            	                case PRODUCT_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt61=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt61)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1456:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_morecomparisons4481);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulemorecomparisonsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return i;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulemorecomparisonsEx; /* Prevent compiler warnings */
    rulemorecomparisonsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return i;
}
/* $ANTLR end morecomparisons */

/**
 * $ANTLR start nots
 * ../../../../src/parser/cvc/Cvc.g:1461:1: nots returns [size_t n = 0] : ( NOT_TOK )* ;
 */
static size_t
nots(pCvcParser ctx)
{
    size_t n;


    /* Initialize rule variables
     */
    n =  0;


    {
        // ../../../../src/parser/cvc/Cvc.g:1462:3: ( ( NOT_TOK )* )
        // ../../../../src/parser/cvc/Cvc.g:1462:5: ( NOT_TOK )*
        {
            // ../../../../src/parser/cvc/Cvc.g:1462:5: ( NOT_TOK )*

            for (;;)
            {
                int alt63=2;
                switch ( LA(1) )
                {
                case NOT_TOK:
                	{
                		alt63=1;
                	}
                    break;

                }

                switch (alt63)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1462:7: NOT_TOK
            	    {
            	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_nots4510);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenotsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return n;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             ++n
            	            ; 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop63;	/* break out of the loop */
            	    break;
                }
            }
            loop63: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenotsEx; /* Prevent compiler warnings */
    rulenotsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return n;
}
/* $ANTLR end nots */

/**
 * $ANTLR start prefixFormula
 * ../../../../src/parser/cvc/Cvc.g:1465:1: prefixFormula[CVC4::Expr& f] : ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] );
 */
static void
prefixFormula(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      std::vector<Expr> terms;
      std::vector<Type> types;
      std::vector<Expr> bvs;
      Type t;
      Kind k;
      Expr ipl;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1476:3: ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] )

            ANTLR3_UINT32 alt68;

            alt68=3;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt68=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt68=2;
            	}
                break;
            case LAMBDA_TOK:
            	{
            		alt68=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 68;
                EXCEPTION->state        = 0;


                goto ruleprefixFormulaEx;

            }

            switch (alt68)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1476:5: ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f]
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:1476:5: ( FORALL_TOK | EXISTS_TOK )
        	        {
        	            int alt64=2;
        	            switch ( LA(1) )
        	            {
        	            case FORALL_TOK:
        	            	{
        	            		alt64=1;
        	            	}
        	                break;
        	            case EXISTS_TOK:
        	            	{
        	            		alt64=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 64;
        	                EXCEPTION->state        = 0;


        	                goto ruleprefixFormulaEx;

        	            }

        	            switch (alt64)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1476:7: FORALL_TOK
        	        	    {
        	        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_prefixFormula4542);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::FORALL; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1476:42: EXISTS_TOK
        	        	    {
        	        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_prefixFormula4548);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::EXISTS; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4560);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4566);
        	        boundVarDecl(ctx, ids, t);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	                    bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	                  }
        	                  ids.clear();
        	                
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1484:5: ( COMMA boundVarDecl[ids,t] )*

        	        for (;;)
        	        {
        	            int alt65=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt65=1;
        	            	}
        	                break;

        	            }

        	            switch (alt65)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1484:7: COMMA boundVarDecl[ids,t]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4581);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4583);
        	        	        boundVarDecl(ctx, ids, t);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {

        	        	                    for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	        	                      bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	        	                    }
        	        	                    ids.clear();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop65;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop65: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4601);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  terms.push_back( EXPR_MANAGER->mkExpr( kind::BOUND_VAR_LIST, bvs ) ); 
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4609);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1493:11: ( instantiationPatterns[ipl] )?
        	        {
        	            int alt66=2;
        	            switch ( LA(1) )
        	            {
        	                case PATTERN_TOK:
        	                	{
        	                		alt66=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt66)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1493:11: instantiationPatterns[ipl]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_instantiationPatterns_in_prefixFormula4611);
        	        	        instantiationPatterns(ctx, ipl);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4615);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  terms.push_back(f);
        	                  if(! ipl.isNull()) {
        	                    terms.push_back(ipl);
        	                  }
        	                  f = MK_EXPR(k, terms);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1505:5: LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_prefixFormula4634);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4642);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // ../../../../src/parser/cvc/Cvc.g:1506:13: ( COMMA letDecl )*

        	        for (;;)
        	        {
        	            int alt67=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt67=1;
        	            	}
        	                break;

        	            }

        	            switch (alt67)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/cvc/Cvc.g:1506:15: COMMA letDecl
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4646);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4648);
        	        	        letDecl(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop67;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop67: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_prefixFormula4657);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4659);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1510:5: LAMBDA_TOK LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f]
        	    {
        	         MATCHT(LAMBDA_TOK, &FOLLOW_LAMBDA_TOK_in_prefixFormula4674);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4678);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDeclsReturn_in_prefixFormula4684);
        	        boundVarDeclsReturn(ctx, terms, types);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4691);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4693);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4695);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  Type t = EXPR_MANAGER->mkFunctionType(types, f.getType());
        	                  Expr bvl = EXPR_MANAGER->mkExpr( kind::BOUND_VAR_LIST, terms );
        	                  f = EXPR_MANAGER->mkExpr( kind::LAMBDA, bvl, f );
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleprefixFormulaEx; /* Prevent compiler warnings */
    ruleprefixFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end prefixFormula */

/**
 * $ANTLR start instantiationPatterns
 * ../../../../src/parser/cvc/Cvc.g:1520:1: instantiationPatterns[ CVC4::Expr& expr ] : ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ ;
 */
static void
instantiationPatterns(pCvcParser ctx, CVC4::Expr& expr)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Expr f;
      std::vector<Expr> patterns;

    {
        // ../../../../src/parser/cvc/Cvc.g:1526:3: ( ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ )
        // ../../../../src/parser/cvc/Cvc.g:1526:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
        {
            // ../../../../src/parser/cvc/Cvc.g:1526:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
            {
                int cnt70=0;

                for (;;)
                {
                    int alt70=2;
            	switch ( LA(1) )
            	{
            	case PATTERN_TOK:
            		{
            			alt70=1;
            		}
            	    break;

            	}

            	switch (alt70)
            	{
            	    case 1:
            	        // ../../../../src/parser/cvc/Cvc.g:1526:7: PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON
            	        {
            	             MATCHT(PATTERN_TOK, &FOLLOW_PATTERN_TOK_in_instantiationPatterns4723);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(LPAREN, &FOLLOW_LPAREN_in_instantiationPatterns4725);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4727);
            	            formula(ctx, f);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 args.push_back( f ); 
            	            }


            	            // ../../../../src/parser/cvc/Cvc.g:1526:62: ( COMMA formula[f] )*

            	            for (;;)
            	            {
            	                int alt69=2;
            	                switch ( LA(1) )
            	                {
            	                case COMMA:
            	                	{
            	                		alt69=1;
            	                	}
            	                    break;

            	                }

            	                switch (alt69)
            	                {
            	            	case 1:
            	            	    // ../../../../src/parser/cvc/Cvc.g:1526:63: COMMA formula[f]
            	            	    {
            	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_instantiationPatterns4733);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4735);
            	            	        formula(ctx, f);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        if ( BACKTRACKING==0 )
            	            	        {
            	            	             args.push_back( f ); 
            	            	        }


            	            	    }
            	            	    break;

            	            	default:
            	            	    goto loop69;	/* break out of the loop */
            	            	    break;
            	                }
            	            }
            	            loop69: ; /* Jump out to here if this rule does not match */


            	             MATCHT(RPAREN, &FOLLOW_RPAREN_in_instantiationPatterns4743);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(COLON, &FOLLOW_COLON_in_instantiationPatterns4745);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 patterns.push_back( EXPR_MANAGER->mkExpr( kind::INST_PATTERN, args ) );
            	                        args.clear();
            	                      
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt70 >= 1 )
            		{
            		    goto loop70;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruleinstantiationPatternsEx;
            	}
            	cnt70++;
                }
                loop70: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 if(! patterns.empty()) {
                       expr = EXPR_MANAGER->mkExpr( kind::INST_PATTERN_LIST, patterns );
                       }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleinstantiationPatternsEx; /* Prevent compiler warnings */
    ruleinstantiationPatternsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end instantiationPatterns */

/**
 * $ANTLR start letDecl
 * ../../../../src/parser/cvc/Cvc.g:1539:1: letDecl : identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] ;
 */
static void
letDecl(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      Expr e;
      std::string name;

    {
        // ../../../../src/parser/cvc/Cvc.g:1544:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] )
        // ../../../../src/parser/cvc/Cvc.g:1544:5: identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_letDecl4782);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_letDecl4785);
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_letDecl4787);
            formula(ctx, e);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser") << language::SetLanguage(language::output::LANG_CVC4) << e.getType() << std::endl;
                      PARSER_STATE->defineVar(name, e);
                      Debug("parser") << "LET[" << PARSER_STATE->scopeLevel() << "]: "
                                      << name << std::endl
                                      << " ==>" << " " << e << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleletDeclEx; /* Prevent compiler warnings */
    ruleletDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end letDecl */

/**
 * $ANTLR start booleanBinop
 * ../../../../src/parser/cvc/Cvc.g:1553:1: booleanBinop[unsigned& op] : ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK | JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK );
 */
static void
booleanBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1557:3: ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK | JOIN_TOK | PRODUCT_TOK | JOIN_IMAGE_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == AND_TOK || LA(1) == IFF_TOK || LA(1) == IMPLIES_TOK || ((LA(1) >= JOIN_IMAGE_TOK) && (LA(1) <= JOIN_TOK)) || LA(1) == OR_TOK || LA(1) == PRODUCT_TOK || LA(1) == XOR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebooleanBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebooleanBinopEx; /* Prevent compiler warnings */
    rulebooleanBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end booleanBinop */

/**
 * $ANTLR start comparison
 * ../../../../src/parser/cvc/Cvc.g:1567:1: comparison[CVC4::Expr& f] : term[f] ( comparisonBinop[op] term[f] )* ;
 */
static void
comparison(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1573:3: ( term[f] ( comparisonBinop[op] term[f] )* )
        // ../../../../src/parser/cvc/Cvc.g:1573:5: term[f] ( comparisonBinop[op] term[f] )*
        {
            FOLLOWPUSH(FOLLOW_term_in_comparison4876);
            term(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecomparisonEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1574:5: ( comparisonBinop[op] term[f] )*

            for (;;)
            {
                int alt71=2;
                switch ( LA(1) )
                {
                case DISEQUAL_TOK:
                case EQUAL_TOK:
                case FMF_CARD_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                	{
                		alt71=1;
                	}
                    break;

                }

                switch (alt71)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1574:7: comparisonBinop[op] term[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_comparisonBinop_in_comparison4887);
            	        comparisonBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_comparison4890);
            	        term(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop71;	/* break out of the loop */
            	    break;
                }
            }
            loop71: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonEx; /* Prevent compiler warnings */
    rulecomparisonEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparison */

/**
 * $ANTLR start comparisonBinop
 * ../../../../src/parser/cvc/Cvc.g:1579:1: comparisonBinop[unsigned& op] : ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK );
 */
static void
comparisonBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1583:3: ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK | FMF_CARD_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DISEQUAL_TOK || LA(1) == EQUAL_TOK || LA(1) == FMF_CARD_TOK || LA(1) == GEQ_TOK || LA(1) == GT_TOK || LA(1) == LEQ_TOK || ((LA(1) >= LT_TOK) && (LA(1) <= MEMBER_TOK)) )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulecomparisonBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonBinopEx; /* Prevent compiler warnings */
    rulecomparisonBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparisonBinop */

/**
 * $ANTLR start arithmeticBinop
 * ../../../../src/parser/cvc/Cvc.g:1593:1: arithmeticBinop[unsigned& op] : ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK );
 */
static void
arithmeticBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1597:3: ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DIV_TOK || LA(1) == EXP_TOK || LA(1) == INTDIV_TOK || ((LA(1) >= MINUS_TOK) && (LA(1) <= MOD_TOK)) || LA(1) == PLUS_TOK || LA(1) == STAR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulearithmeticBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearithmeticBinopEx; /* Prevent compiler warnings */
    rulearithmeticBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arithmeticBinop */

/**
 * $ANTLR start term
 * ../../../../src/parser/cvc/Cvc.g:1607:1: term[CVC4::Expr& f] : uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) ;
 */
static void
term(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1614:3: ( uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* ) )
        // ../../../../src/parser/cvc/Cvc.g:1614:5: uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
        {
            FOLLOWPUSH(FOLLOW_uminusTerm_in_term5045);
            uminusTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // ../../../../src/parser/cvc/Cvc.g:1615:5: ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) | ( arithmeticBinop[op] uminusTerm[f] )* )
            {
                int alt78=2;
                switch ( LA(1) )
                {
                case WITH_TOK:
                	{
                		alt78=1;
                	}
                    break;
                case EOF:
                case ABS_TOK:
                case AND_TOK:
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case COLON:
                case COMMA:
                case DECIMAL_LITERAL:
                case DISEQUAL_TOK:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case DIV_TOK:
                case ELSEIF_TOK:
                case ELSE_TOK:
                case ENDIF_TOK:
                case EQUAL_TOK:
                case EXISTS_TOK:
                case EXP_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case FMF_CARD_TOK:
                case FORALL_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case HASHPAREN:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IDEN_TOK:
                case IFF_TOK:
                case IF_TOK:
                case IMPLIES_TOK:
                case INTDIV_TOK:
                case INTEGER_LITERAL:
                case IN_TOK:
                case IS_INTEGER_TOK:
                case JOIN_IMAGE_TOK:
                case JOIN_TOK:
                case LAMBDA_TOK:
                case LBRACE:
                case LBRACKET:
                case LEQ_TOK:
                case LET_TOK:
                case LPAREN:
                case LT_TOK:
                case MEMBER_TOK:
                case MINUS_TOK:
                case MOD_TOK:
                case NOT_TOK:
                case OR_TOK:
                case PARENHASH:
                case PLUS_TOK:
                case PRODUCT_TOK:
                case RBRACE:
                case RBRACKET:
                case RPAREN:
                case SEMICOLON:
                case SETS_CARD_TOK:
                case STAR_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case SX_TOK:
                case THEN_TOK:
                case TRANSCLOSURE_TOK:
                case TRANSPOSE_TOK:
                case TRUE_TOK:
                case TUPLE_TOK:
                case UNIVSET_TOK:
                case XOR_TOK:
                	{
                		alt78=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 78;
                    EXCEPTION->state        = 0;


                    goto ruletermEx;

                }

                switch (alt78)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1615:7: WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	    {
            	         MATCHT(WITH_TOK, &FOLLOW_WITH_TOK_in_term5054);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1616:7: ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	        {
            	            int alt76=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt76=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt76=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 76;
            	                EXCEPTION->state        = 0;


            	                goto ruletermEx;

            	            }

            	            switch (alt76)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1616:9: arrayStore[f] ( COMMA arrayStore[f] )*
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5064);
            	        	        arrayStore(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1616:23: ( COMMA arrayStore[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt72=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		alt72=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt72)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1616:25: COMMA arrayStore[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5069);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_term5071);
            	        	        	        arrayStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop72;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop72: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1617:9: DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5085);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1617:13: ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	        {
            	        	            int alt75=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt75=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt75=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 75;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletermEx;

            	        	            }

            	        	            switch (alt75)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1617:15: tupleStore[f] ( COMMA DOT tupleStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5089);
            	        	        	        tupleStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // ../../../../src/parser/cvc/Cvc.g:1617:29: ( COMMA DOT tupleStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt73=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt73=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt73)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1617:31: COMMA DOT tupleStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5094);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5096);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_term5098);
            	        	        	        	        tupleStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop73;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop73: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1618:15: recordStore[f] ( COMMA DOT recordStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5118);
            	        	        	        recordStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // ../../../../src/parser/cvc/Cvc.g:1618:30: ( COMMA DOT recordStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt74=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		alt74=1;
            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt74)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // ../../../../src/parser/cvc/Cvc.g:1618:32: COMMA DOT recordStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_term5123);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_term5125);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_term5127);
            	        	        	        	        recordStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto ruletermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop74;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop74: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1619:7: ( arithmeticBinop[op] uminusTerm[f] )*
            	    {
            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(f); 
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1620:7: ( arithmeticBinop[op] uminusTerm[f] )*

            	        for (;;)
            	        {
            	            int alt77=2;
            	            switch ( LA(1) )
            	            {
            	            case MINUS_TOK:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case BVNEG_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSPOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSCLOSURE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TUPLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IDEN_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNAND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVCOMP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUMINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVPLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSUB_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVMULT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSMOD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSHL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVASHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLSHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SX_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVZEROEXTEND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVREPEAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LENGTH_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONTAINS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUBSTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CHARAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_INDEXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_PREFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUFFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_STOI_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_ITOS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case SETS_CARD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LPAREN:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case PARENHASH:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case HASHPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LBRACE:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case UNIVSET_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case BAR:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ARRAY_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRUE_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case FALSE_TOK:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case DECIMAL_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case INTEGER_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case HEX_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case BINARY_LITERAL:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case IDENTIFIER:
            	            			{
            	            				alt77=1;
            	            			}
            	            		    break;
            	            		case FLOOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IS_INTEGER_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case DIVISIBLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case DISTINCT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case MINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt77=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case DIV_TOK:
            	            case EXP_TOK:
            	            case INTDIV_TOK:
            	            case MOD_TOK:
            	            case PLUS_TOK:
            	            case STAR_TOK:
            	            	{
            	            		alt77=1;
            	            	}
            	                break;

            	            }

            	            switch (alt77)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1620:9: arithmeticBinop[op] uminusTerm[f]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arithmeticBinop_in_term5153);
            	        	        arithmeticBinop(ctx, op);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_uminusTerm_in_term5156);
            	        	        uminusTerm(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             operators.push_back(op); expressions.push_back(f); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop77;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop77: ; /* Jump out to here if this rule does not match */


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start arrayStore
 * ../../../../src/parser/cvc/Cvc.g:1629:1: arrayStore[CVC4::Expr& f] : LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
arrayStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      Expr f2, k;

    {
        // ../../../../src/parser/cvc/Cvc.g:1633:3: ( LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1633:5: LBRACKET formula[k] RBRACKET ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_arrayStore5197);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_arrayStore5199);
            formula(ctx, k);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_arrayStore5202);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 f2 = MK_EXPR(CVC4::kind::SELECT, f, k); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1635:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt81=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt81=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt81=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 81;
                    EXCEPTION->state        = 0;


                    goto rulearrayStoreEx;

                }

                switch (alt81)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1635:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1635:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt80=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt80=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt80=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 80;
            	                EXCEPTION->state        = 0;


            	                goto rulearrayStoreEx;

            	            }

            	            switch (alt80)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1635:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_arrayStore5218);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1636:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_arrayStore5229);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulearrayStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1636:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt79=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt79=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt79=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 79;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulearrayStoreEx;

            	        	            }

            	        	            switch (alt79)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1636:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_arrayStore5233);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1637:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_arrayStore5250);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulearrayStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1638:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_arrayStore5263);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_arrayStore5265);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulearrayStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(CVC4::kind::STORE, f, k, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearrayStoreEx; /* Prevent compiler warnings */
    rulearrayStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arrayStore */

/**
 * $ANTLR start tupleStore
 * ../../../../src/parser/cvc/Cvc.g:1646:1: tupleStore[CVC4::Expr& f] : k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
tupleStore(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f2;

    {
        // ../../../../src/parser/cvc/Cvc.g:1650:3: (k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1650:5: k= numeral ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_numeral_in_tupleStore5297);
            k=numeral(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Type t = f.getType();
                      if(! t.isTuple()) {
                        PARSER_STATE->parseError("tuple-update applied to non-tuple");
                      }
                      size_t length = ((DatatypeType)t).getTupleLength();
                      if(k >= length) {
                        std::stringstream ss;
                        ss << "tuple is of length " << length << "; cannot update index " << k;
                        PARSER_STATE->parseError(ss.str());
                      }
                      std::vector<Expr> args;
                      const Datatype & dt = ((DatatypeType)t).getDatatype();
                      args.push_back( dt[0][k].getSelector() );
                      args.push_back( f );
                      f2 = MK_EXPR(CVC4::kind::APPLY_SELECTOR,args);
                    
            }


            // ../../../../src/parser/cvc/Cvc.g:1667:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt84=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt84=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt84=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 84;
                    EXCEPTION->state        = 0;


                    goto ruletupleStoreEx;

                }

                switch (alt84)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1667:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1667:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt83=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt83=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt83=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 83;
            	                EXCEPTION->state        = 0;


            	                goto ruletupleStoreEx;

            	            }

            	            switch (alt83)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1667:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_tupleStore5313);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1668:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_tupleStore5324);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruletupleStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1668:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt82=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt82=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt82=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 82;
            	        	                EXCEPTION->state        = 0;


            	        	                goto ruletupleStoreEx;

            	        	            }

            	        	            switch (alt82)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1668:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_tupleStore5328);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1669:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_tupleStore5345);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto ruletupleStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1670:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_tupleStore5358);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_tupleStore5360);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletupleStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(MK_CONST(TupleUpdate(k)), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletupleStoreEx; /* Prevent compiler warnings */
    ruletupleStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tupleStore */

/**
 * $ANTLR start recordStore
 * ../../../../src/parser/cvc/Cvc.g:1678:1: recordStore[CVC4::Expr& f] : identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) ;
 */
static void
recordStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::string id;
      Expr f2;

    {
        // ../../../../src/parser/cvc/Cvc.g:1683:3: ( identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] ) )
        // ../../../../src/parser/cvc/Cvc.g:1683:5: identifier[id,CHECK_NONE,SYM_VARIABLE] ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordStore5390);
            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Type t = f.getType();
                      if(! t.isRecord()) {
                        std::stringstream ss;
                        ss << "record-update applied to non-record term" << std::endl
                           << "the term: " << f << std::endl
                           << "its type: " << t;
                        PARSER_STATE->parseError(ss.str());
                      }
                      const Record& rec = ((DatatypeType)t).getRecord();
                      if(! rec.contains(id)) {
                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
                      }
                      std::vector<Expr> args;
                      const Datatype & dt = ((DatatypeType)t).getDatatype();
                      args.push_back( dt[0][id].getSelector() );
                      args.push_back( f );
                      f2 = MK_EXPR(CVC4::kind::APPLY_SELECTOR,args);
                    
            }


            // ../../../../src/parser/cvc/Cvc.g:1702:5: ( ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) ) | ASSIGN_TOK term[f2] )
            {
                int alt87=2;
                switch ( LA(1) )
                {
                case DOT:
                case LBRACKET:
                	{
                		alt87=1;
                	}
                    break;
                case ASSIGN_TOK:
                	{
                		alt87=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 87;
                    EXCEPTION->state        = 0;


                    goto rulerecordStoreEx;

                }

                switch (alt87)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1702:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	    {
            	        // ../../../../src/parser/cvc/Cvc.g:1702:7: ( arrayStore[f2] | DOT ( tupleStore[f2] | recordStore[f2] ) )
            	        {
            	            int alt86=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt86=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt86=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 86;
            	                EXCEPTION->state        = 0;


            	                goto rulerecordStoreEx;

            	            }

            	            switch (alt86)
            	            {
            	        	case 1:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1702:9: arrayStore[f2]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_recordStore5407);
            	        	        arrayStore(ctx, f2);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // ../../../../src/parser/cvc/Cvc.g:1703:9: DOT ( tupleStore[f2] | recordStore[f2] )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_recordStore5418);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulerecordStoreEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // ../../../../src/parser/cvc/Cvc.g:1703:13: ( tupleStore[f2] | recordStore[f2] )
            	        	        {
            	        	            int alt85=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt85=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt85=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 85;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulerecordStoreEx;

            	        	            }

            	        	            switch (alt85)
            	        	            {
            	        	        	case 1:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1703:15: tupleStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_recordStore5422);
            	        	        	        tupleStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // ../../../../src/parser/cvc/Cvc.g:1704:15: recordStore[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_recordStore5439);
            	        	        	        recordStore(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulerecordStoreEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/cvc/Cvc.g:1705:7: ASSIGN_TOK term[f2]
            	    {
            	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordStore5452);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_recordStore5454);
            	        term(ctx, f2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulerecordStoreEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(MK_CONST(RecordUpdate(id)), f, f2); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordStoreEx; /* Prevent compiler warnings */
    rulerecordStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordStore */

/**
 * $ANTLR start uminusTerm
 * ../../../../src/parser/cvc/Cvc.g:1710:1: uminusTerm[CVC4::Expr& f] : ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] );
 */
static void
uminusTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      unsigned minusCount = 0;

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1715:3: ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] )

            ANTLR3_UINT32 alt89;

            alt89=2;

            switch ( LA(1) )
            {
            case MINUS_TOK:
            	{
            		alt89=1;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt89=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 89;
                EXCEPTION->state        = 0;


                goto ruleuminusTermEx;

            }

            switch (alt89)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1715:5: ( MINUS_TOK )+ bvBinaryOpTerm[f]
        	    {
        	        // ../../../../src/parser/cvc/Cvc.g:1715:5: ( MINUS_TOK )+
        	        {
        	            int cnt88=0;

        	            for (;;)
        	            {
        	                int alt88=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case MINUS_TOK:
        	        		{
        	        			alt88=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt88)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/cvc/Cvc.g:1715:6: MINUS_TOK
        	        	        {
        	        	             MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_uminusTerm5491);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleuminusTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 ++minusCount; 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt88 >= 1 )
        	        		{
        	        		    goto loop88;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleuminusTermEx;
        	        	}
        	        	cnt88++;
        	            }
        	            loop88: ;	/* Jump to here if this rule does not match */
        	        }

        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm5497);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             while(minusCount > 0) { --minusCount; f = MK_EXPR(CVC4::kind::UMINUS, f); } 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1717:5: bvBinaryOpTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm5510);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleuminusTermEx; /* Prevent compiler warnings */
    ruleuminusTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end uminusTerm */

/**
 * $ANTLR start bvBinaryOpTerm
 * ../../../../src/parser/cvc/Cvc.g:1721:1: bvBinaryOpTerm[CVC4::Expr& f] : bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* ;
 */
static void
bvBinaryOpTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // ../../../../src/parser/cvc/Cvc.g:1727:3: ( bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* )
        // ../../../../src/parser/cvc/Cvc.g:1727:5: bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5532);
            bvNegTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulebvBinaryOpTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // ../../../../src/parser/cvc/Cvc.g:1728:5: ( bvBinop[op] bvNegTerm[f] )*

            for (;;)
            {
                int alt90=2;
                switch ( LA(1) )
                {
                case BAR:
                	{
                		switch ( LA(2) )
                		{
                		case BAR:
                			{
                				switch ( LA(3) )
                				{
                				case BAR:
                					{
                						alt90=1;
                					}
                				    break;

                				}

                			}
                		    break;
                		case ABS_TOK:
                		case ARRAY_TOK:
                		case BINARY_LITERAL:
                		case BVASHR_TOK:
                		case BVCOMP_TOK:
                		case BVGE_TOK:
                		case BVGT_TOK:
                		case BVLE_TOK:
                		case BVLSHR_TOK:
                		case BVLT_TOK:
                		case BVMULT_TOK:
                		case BVNAND_TOK:
                		case BVNEG_TOK:
                		case BVNOR_TOK:
                		case BVPLUS_TOK:
                		case BVREPEAT_TOK:
                		case BVROTL_TOK:
                		case BVROTR_TOK:
                		case BVSDIV_TOK:
                		case BVSGE_TOK:
                		case BVSGT_TOK:
                		case BVSHL_TOK:
                		case BVSLE_TOK:
                		case BVSLT_TOK:
                		case BVSMOD_TOK:
                		case BVSREM_TOK:
                		case BVSUB_TOK:
                		case BVUDIV_TOK:
                		case BVUMINUS_TOK:
                		case BVUREM_TOK:
                		case BVXNOR_TOK:
                		case BVXOR_TOK:
                		case BVZEROEXTEND_TOK:
                		case DECIMAL_LITERAL:
                		case DISTINCT_TOK:
                		case DIVISIBLE_TOK:
                		case FALSE_TOK:
                		case FLOOR_TOK:
                		case HEX_LITERAL:
                		case IDENTIFIER:
                		case IDEN_TOK:
                		case IF_TOK:
                		case INTEGER_LITERAL:
                		case IS_INTEGER_TOK:
                		case LBRACE:
                		case LPAREN:
                		case PARENHASH:
                		case SETS_CARD_TOK:
                		case STRING_CHARAT_TOK:
                		case STRING_CONCAT_TOK:
                		case STRING_CONTAINS_TOK:
                		case STRING_INDEXOF_TOK:
                		case STRING_ITOS_TOK:
                		case STRING_LENGTH_TOK:
                		case STRING_LITERAL:
                		case STRING_PREFIXOF_TOK:
                		case STRING_REPLACE_TOK:
                		case STRING_STOI_TOK:
                		case STRING_SUBSTR_TOK:
                		case STRING_SUFFIXOF_TOK:
                		case SX_TOK:
                		case TRANSCLOSURE_TOK:
                		case TRANSPOSE_TOK:
                		case TRUE_TOK:
                		case TUPLE_TOK:
                		case UNIVSET_TOK:
                			{
                				alt90=1;
                			}
                		    break;

                		}

                	}
                    break;
                case BVAND_TOK:
                case CONCAT_TOK:
                	{
                		alt90=1;
                	}
                    break;

                }

                switch (alt90)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1728:7: bvBinop[op] bvNegTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_bvBinop_in_bvBinaryOpTerm5543);
            	        bvBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5546);
            	        bvNegTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop90;	/* break out of the loop */
            	    break;
                }
            }
            loop90: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinaryOpTermEx; /* Prevent compiler warnings */
    rulebvBinaryOpTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinaryOpTerm */

/**
 * $ANTLR start bvBinop
 * ../../../../src/parser/cvc/Cvc.g:1731:1: bvBinop[unsigned& op] : ( CONCAT_TOK | BAR | BVAND_TOK );
 */
static void
bvBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // ../../../../src/parser/cvc/Cvc.g:1735:3: ( CONCAT_TOK | BAR | BVAND_TOK )
        // ../../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == BAR || LA(1) == BVAND_TOK || LA(1) == CONCAT_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebvBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinopEx; /* Prevent compiler warnings */
    rulebvBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinop */

/**
 * $ANTLR start bvNegTerm
 * ../../../../src/parser/cvc/Cvc.g:1740:1: bvNegTerm[CVC4::Expr& f] : ( BVNEG_TOK bvNegTerm[f] | relationTerm[f] );
 */
static void
bvNegTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1742:3: ( BVNEG_TOK bvNegTerm[f] | relationTerm[f] )

            ANTLR3_UINT32 alt91;

            alt91=2;

            switch ( LA(1) )
            {
            case BVNEG_TOK:
            	{
            		alt91=1;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IDEN_TOK:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case SX_TOK:
            case TRANSCLOSURE_TOK:
            case TRANSPOSE_TOK:
            case TRUE_TOK:
            case TUPLE_TOK:
            case UNIVSET_TOK:
            	{
            		alt91=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 91;
                EXCEPTION->state        = 0;


                goto rulebvNegTermEx;

            }

            switch (alt91)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1742:5: BVNEG_TOK bvNegTerm[f]
        	    {
        	         MATCHT(BVNEG_TOK, &FOLLOW_BVNEG_TOK_in_bvNegTerm5609);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvNegTerm5611);
        	        bvNegTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = f.getType().isSet() ? MK_EXPR(CVC4::kind::COMPLEMENT, f) : MK_EXPR(CVC4::kind::BITVECTOR_NOT, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1744:5: relationTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_relationTerm_in_bvNegTerm5624);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvNegTermEx; /* Prevent compiler warnings */
    rulebvNegTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvNegTerm */

/**
 * $ANTLR start relationTerm
 * ../../../../src/parser/cvc/Cvc.g:1747:1: relationTerm[CVC4::Expr& f] : ( TRANSPOSE_TOK relationTerm[f] | TRANSCLOSURE_TOK relationTerm[f] | TUPLE_TOK LPAREN relationTerm[f] RPAREN | IDEN_TOK relationTerm[f] | postfixTerm[f] );
 */
static void
relationTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/cvc/Cvc.g:1749:3: ( TRANSPOSE_TOK relationTerm[f] | TRANSCLOSURE_TOK relationTerm[f] | TUPLE_TOK LPAREN relationTerm[f] RPAREN | IDEN_TOK relationTerm[f] | postfixTerm[f] )

            ANTLR3_UINT32 alt92;

            alt92=5;

            switch ( LA(1) )
            {
            case TRANSPOSE_TOK:
            	{
            		alt92=1;
            	}
                break;
            case TRANSCLOSURE_TOK:
            	{
            		alt92=2;
            	}
                break;
            case TUPLE_TOK:
            	{
            		alt92=3;
            	}
                break;
            case IDEN_TOK:
            	{
            		alt92=4;
            	}
                break;
            case ABS_TOK:
            case ARRAY_TOK:
            case BAR:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SETS_CARD_TOK:
            case STRING_CHARAT_TOK:
            case STRING_CONCAT_TOK:
            case STRING_CONTAINS_TOK:
            case STRING_INDEXOF_TOK:
            case STRING_ITOS_TOK:
            case STRING_LENGTH_TOK:
            case STRING_LITERAL:
            case STRING_PREFIXOF_TOK:
            case STRING_REPLACE_TOK:
            case STRING_STOI_TOK:
            case STRING_SUBSTR_TOK:
            case STRING_SUFFIXOF_TOK:
            case SX_TOK:
            case TRUE_TOK:
            case UNIVSET_TOK:
            	{
            		alt92=5;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 92;
                EXCEPTION->state        = 0;


                goto rulerelationTermEx;

            }

            switch (alt92)
            {
        	case 1:
        	    // ../../../../src/parser/cvc/Cvc.g:1749:5: TRANSPOSE_TOK relationTerm[f]
        	    {
        	         MATCHT(TRANSPOSE_TOK, &FOLLOW_TRANSPOSE_TOK_in_relationTerm5645);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5647);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::TRANSPOSE, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/cvc/Cvc.g:1751:5: TRANSCLOSURE_TOK relationTerm[f]
        	    {
        	         MATCHT(TRANSCLOSURE_TOK, &FOLLOW_TRANSCLOSURE_TOK_in_relationTerm5661);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5663);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::TCLOSURE, f); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/cvc/Cvc.g:1753:5: TUPLE_TOK LPAREN relationTerm[f] RPAREN
        	    {
        	         MATCHT(TUPLE_TOK, &FOLLOW_TUPLE_TOK_in_relationTerm5676);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_relationTerm5678);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5680);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_relationTerm5683);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector<Type> types;
        	                  std::vector<Expr> args;
        	                  args.push_back(f);
        	            	    types.push_back(f.getType());
        	                  DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                  const Datatype& dt = t.getDatatype();
        	                  args.insert( args.begin(), dt[0].getConstructor() );
        	                  f = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/cvc/Cvc.g:1763:5: IDEN_TOK relationTerm[f]
        	    {
        	         MATCHT(IDEN_TOK, &FOLLOW_IDEN_TOK_in_relationTerm5695);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_relationTerm_in_relationTerm5697);
        	        relationTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::IDEN, f); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/cvc/Cvc.g:1765:5: postfixTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_postfixTerm_in_relationTerm5727);
        	        postfixTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerelationTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerelationTermEx; /* Prevent compiler warnings */
    rulerelationTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end relationTerm */

/**
 * $ANTLR start postfixTerm
 * ../../../../src/parser/cvc/Cvc.g:1777:1: postfixTerm[CVC4::Expr& f] : ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? ;
 */
static void
postfixTerm(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 unsigned

    unsigned k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 unsigned

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    unsigned n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n unsigned

    /* Initialize rule variables
     */


      Expr f2;
      bool extract = false, left = false;
      std::vector<Expr> args;
      std::string id;
      Type t;

    {
        // ../../../../src/parser/cvc/Cvc.g:1785:3: ( ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? )
        // ../../../../src/parser/cvc/Cvc.g:1785:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )?
        {
            // ../../../../src/parser/cvc/Cvc.g:1785:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN )
            {
                int alt99=6;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BAR:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case FALSE_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IF_TOK:
                case INTEGER_LITERAL:
                case LBRACE:
                case LPAREN:
                case PARENHASH:
                case SETS_CARD_TOK:
                case STRING_CHARAT_TOK:
                case STRING_CONCAT_TOK:
                case STRING_CONTAINS_TOK:
                case STRING_INDEXOF_TOK:
                case STRING_ITOS_TOK:
                case STRING_LENGTH_TOK:
                case STRING_LITERAL:
                case STRING_PREFIXOF_TOK:
                case STRING_REPLACE_TOK:
                case STRING_STOI_TOK:
                case STRING_SUBSTR_TOK:
                case STRING_SUFFIXOF_TOK:
                case SX_TOK:
                case TRUE_TOK:
                case UNIVSET_TOK:
                	{
                		alt99=1;
                	}
                    break;
                case FLOOR_TOK:
                	{
                		alt99=2;
                	}
                    break;
                case IS_INTEGER_TOK:
                	{
                		alt99=3;
                	}
                    break;
                case ABS_TOK:
                	{
                		alt99=4;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt99=5;
                	}
                    break;
                case DISTINCT_TOK:
                	{
                		alt99=6;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 99;
                    EXCEPTION->state        = 0;


                    goto rulepostfixTermEx;

                }

                switch (alt99)
                {
            	case 1:
            	    // ../../../../src/parser/cvc/Cvc.g:1785:7: bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*
            	    {
            	        FOLLOWPUSH(FOLLOW_bvTerm_in_postfixTerm5751);
            	        bvTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // ../../../../src/parser/cvc/Cvc.g:1786:5: ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*

            	        for (;;)
            	        {
            	            int alt97=5;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case IDENTIFIER:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case AND_TOK:
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case COLON:
            	            				case CONCAT_TOK:
            	            				case DISEQUAL_TOK:
            	            				case DIV_TOK:
            	            				case DOT:
            	            				case EQUAL_TOK:
            	            				case EXP_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case INTDIV_TOK:
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case LBRACKET:
            	            				case LEFTSHIFT_TOK:
            	            				case LEQ_TOK:
            	            				case LPAREN:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case OR_TOK:
            	            				case PLUS_TOK:
            	            				case PRODUCT_TOK:
            	            				case RBRACKET:
            	            				case RIGHTSHIFT_TOK:
            	            				case STAR_TOK:
            	            				case WITH_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt97=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            		case ARRAY_TOK:
            	            		case BAR:
            	            		case BINARY_LITERAL:
            	            		case BVASHR_TOK:
            	            		case BVCOMP_TOK:
            	            		case BVGE_TOK:
            	            		case BVGT_TOK:
            	            		case BVLE_TOK:
            	            		case BVLSHR_TOK:
            	            		case BVLT_TOK:
            	            		case BVMULT_TOK:
            	            		case BVNAND_TOK:
            	            		case BVNEG_TOK:
            	            		case BVNOR_TOK:
            	            		case BVPLUS_TOK:
            	            		case BVREPEAT_TOK:
            	            		case BVROTL_TOK:
            	            		case BVROTR_TOK:
            	            		case BVSDIV_TOK:
            	            		case BVSGE_TOK:
            	            		case BVSGT_TOK:
            	            		case BVSHL_TOK:
            	            		case BVSLE_TOK:
            	            		case BVSLT_TOK:
            	            		case BVSMOD_TOK:
            	            		case BVSREM_TOK:
            	            		case BVSUB_TOK:
            	            		case BVUDIV_TOK:
            	            		case BVUMINUS_TOK:
            	            		case BVUREM_TOK:
            	            		case BVXNOR_TOK:
            	            		case BVXOR_TOK:
            	            		case BVZEROEXTEND_TOK:
            	            		case DECIMAL_LITERAL:
            	            		case DISTINCT_TOK:
            	            		case DIVISIBLE_TOK:
            	            		case EXISTS_TOK:
            	            		case FALSE_TOK:
            	            		case FLOOR_TOK:
            	            		case FORALL_TOK:
            	            		case HEX_LITERAL:
            	            		case IDEN_TOK:
            	            		case IF_TOK:
            	            		case INTEGER_LITERAL:
            	            		case IS_INTEGER_TOK:
            	            		case LAMBDA_TOK:
            	            		case LBRACE:
            	            		case LET_TOK:
            	            		case LPAREN:
            	            		case MINUS_TOK:
            	            		case NOT_TOK:
            	            		case PARENHASH:
            	            		case SETS_CARD_TOK:
            	            		case STRING_CHARAT_TOK:
            	            		case STRING_CONCAT_TOK:
            	            		case STRING_CONTAINS_TOK:
            	            		case STRING_INDEXOF_TOK:
            	            		case STRING_ITOS_TOK:
            	            		case STRING_LENGTH_TOK:
            	            		case STRING_LITERAL:
            	            		case STRING_PREFIXOF_TOK:
            	            		case STRING_REPLACE_TOK:
            	            		case STRING_STOI_TOK:
            	            		case STRING_SUBSTR_TOK:
            	            		case STRING_SUFFIXOF_TOK:
            	            		case SX_TOK:
            	            		case TRANSCLOSURE_TOK:
            	            		case TRANSPOSE_TOK:
            	            		case TRUE_TOK:
            	            		case TUPLE_TOK:
            	            		case UNIVSET_TOK:
            	            			{
            	            				alt97=1;
            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case LPAREN:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case NOT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case FORALL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case FORALL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case EXISTS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LET_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LAMBDA_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case MINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNEG_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSPOSE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TRANSCLOSURE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case TUPLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IDEN_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNAND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVCOMP_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVXNOR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUMINUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVPLUS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSUB_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVMULT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSDIV_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVUREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSREM_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSMOD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSHL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVASHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLSHR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SX_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVZEROEXTEND_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVREPEAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVROTL_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSLE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case BVSGE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONCAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LENGTH_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CONTAINS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUBSTR_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_CHARAT_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_INDEXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_REPLACE_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_PREFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_SUFFIXOF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_STOI_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_ITOS_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case STRING_LITERAL:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LBRACKET:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LEFTSHIFT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case RIGHTSHIFT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DOT:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case COLON:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case WITH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIV_TOK:
            	            				case EXP_TOK:
            	            				case INTDIV_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case PLUS_TOK:
            	            				case STAR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISEQUAL_TOK:
            	            				case EQUAL_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case LEQ_TOK:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case AND_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case JOIN_IMAGE_TOK:
            	            				case JOIN_TOK:
            	            				case OR_TOK:
            	            				case PRODUCT_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case COMMA:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case RPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case SETS_CARD_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case IF_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case NOT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LPAREN:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case PARENHASH:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case HASHPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case LBRACE:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case RBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case NOT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FORALL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case EXISTS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LAMBDA_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case MINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNEG_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSPOSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRANSCLOSURE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TUPLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDEN_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNAND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVCOMP_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVXNOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUMINUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVPLUS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSUB_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVMULT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSDIV_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVUREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSREM_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSMOD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSHL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVASHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLSHR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SX_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVZEROEXTEND_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVREPEAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVROTL_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BVSGE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LENGTH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CONTAINS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUBSTR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_CHARAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_INDEXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_REPLACE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_PREFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_SUFFIXOF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_STOI_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_ITOS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case STRING_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case SETS_CARD_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IF_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case PARENHASH:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LBRACE:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case UNIVSET_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ARRAY_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case TRUE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FALSE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DECIMAL_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case INTEGER_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case HEX_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BINARY_LITERAL:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IDENTIFIER:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case FLOOR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case IS_INTEGER_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case ABS_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIVISIBLE_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISTINCT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case UNIVSET_TOK:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case LBRACKET:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LEFTSHIFT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case RIGHTSHIFT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case LPAREN:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DOT:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case COLON:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case CONCAT_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case WITH_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DIV_TOK:
            	            				case EXP_TOK:
            	            				case INTDIV_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case PLUS_TOK:
            	            				case STAR_TOK:
            	            					{
            	            						alt97=3;
            	            					}
            	            				    break;
            	            				case DISEQUAL_TOK:
            	            				case EQUAL_TOK:
            	            				case FMF_CARD_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case LEQ_TOK:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            