/* SPDX-License-Identifier: GPL-2.0-only */

// EHCI Controller 0:1d.0

Device (EHCI)
{
	Name (_ADR, 0x001d0000)

	Name (_PRW, Package () { DEFAULT_PRW_VALUE, 3 })

	// Leave USB ports on for to allow Wake from USB

	Method (_S3D, 0)	// Highest D State in S3 State
	{
		Return (2)
	}

	Method (_S4D, 0)	// Highest D State in S4 State
	{
		Return (2)
	}

	Device (HUB7)
	{
		Name (_ADR, 0)

		Device (PRT1) { Name (_ADR, 1) } // USB Port 0
		Device (PRT2) { Name (_ADR, 2) } // USB Port 1
		Device (PRT3) { Name (_ADR, 3) } // USB Port 2
		Device (PRT4) { Name (_ADR, 4) } // USB Port 3
		Device (PRT5) { Name (_ADR, 5) } // USB Port 4
		Device (PRT6) { Name (_ADR, 6) } // USB Port 5
	}
}
