%define oname configshell

Name:           python-configshell
License:        Apache License 2.0
Group:          System Environment/Libraries
Summary:        A framework to implement simple but nice CLIs.
Version:        1.6.1~g020d540
Release:        1%{?dist}
URL:            http://www.risingtidesystems.com/git/
Source:         %{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-rpmroot
BuildArch:      noarch
BuildRequires:  python-devel, epydoc, pyparsing, python-urwid >= 0.9.9
Requires:       pyparsing, python-urwid >= 0.9.9
Vendor:         Datera, Inc.

%description
A framework to implement simple but nice command-line interfaces.

%prep
%setup -q -n %{oname}-%{version}

%build
%{__python} setup.py build
mkdir -p doc/
epydoc --no-sourcecode --html -n %{oname} --exclude configobj %{oname}/*.py
mv html doc/

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot} --prefix=usr
mkdir -p %{buildroot}/usr/share/doc/python-configshell-doc-%{version}
cp -r doc/* %{buildroot}/usr/share/doc/python-configshell-doc-%{version}/

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}
/usr/share/doc/python-configshell-doc-%{version}
%doc examples COPYING README.md

%changelog
* Sat Dec 13 2014 Marc Fleischmann <mwf@datera.io> 1.6.1~g020d540-1
  - Generated from git commit 020d540850ca36f31af68e9b545a520f1122ea69.
