#!/usr/bin/perl -w

eval 'exec perl -S $0 ${1+"$@"}'
    if 0;

# This script will create the Makefile to build and install CLC-INTERCAL

# This file is part of CLC-INTERCAL 1.-94.-2

# Copyright (c) 2008 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use vars qw($VERSION $PERVERSION);
($VERSION) = ($PERVERSION = "CLC-INTERCAL Makefile.PL 1.-94.-2") =~ /\s(\S+)$/;

use strict;
use Cwd;
use ExtUtils::MakeMaker;

BEGIN { $ENV{CLC_INTERCAL_PATH} = '' }

my @A = map {
    /'/ and die "Try not to use single quotes...\n";
    "'$_'"
} @ARGV;

# find out what packages are included in this
my $ddsh_suffix = 'ddsh';
my $tar_suffix = 'tar';
my $gz_suffix = 'gz';

open(MANIFEST, '<', 'MANIFEST')
    or die "Sorry, I can't work without a MANIFEST\n";
my $base = undef;
my @extras = ();
my @other_tar = ();
my @other_ddsh = ();
my @other_echo = ();
while (<MANIFEST>) {
    if (/^(.*)\.($ddsh_suffix|$tar_suffix)\.$gz_suffix\s+(\S+)$/) {
	my ($name, $suffix, $path) = ($1, $2, $3);
	"$name$suffix$path" =~ /[\s'"]/ and die "Invalid file name, please inform maintainer\n";
	if ($name =~ /\bBase\b/) {
	    $base and die "Something is wrong... Base is provided by $name and $base->[0]\n";
	    $base = [$name, $suffix, $path];
	} else {
	    push @extras, [$name, $suffix, $path];
	}
	push @other_echo, "\$(ECHO) '$name.$ddsh_suffix.$gz_suffix   $path' >> .ddsh/MANIFEST";
    } elsif (/^(\S+)/) {
	push @other_tar, "\$(CP) $1 .tar/CLC-INTERCAL-%v/$1";
	push @other_ddsh, "\$(CP) $1 .ddsh/$1" if $1 ne 'MANIFEST';
	push @other_echo, "\$(ECHO) $1 >> .ddsh/MANIFEST";
    }
}
close MANIFEST;
$base or die "Something is wrong... Base package was not included\n";

# pretend to write a Makefile. so that we get all the constants
my $constants = '';
ExtUtils::MakeMaker::WriteEmptyMakefile(
    NORECURS => 1,
);

# extract base package
extract(@$base);

$ENV{CLC_INTERCAL_PATH} = getcwd . '/' . $base->[2];

# extract other packages
for my $extra (@extras) {
    extract(@$extra);
}

# create a simple Makefile
my @targets = qw(all test clean realclean install tardist ddsh_dist);
my %beforepath = (
    tardist => [
	'$(RM_RF) .tar',
	"\$(NOECHO) $^X -MExtUtils::Command -e mkpath .tar/CLC-INTERCAL-%v",
	@other_tar,
    ],
    ddsh_dist => [
	'$(RM_RF) .ddsh',
	"\$(NOECHO) $^X -MExtUtils::Command -e mkpath .ddsh",
	@other_echo,
	@other_ddsh,
    ],
);
my %afterpath = (
    clean => [
	'$(RM_F) Makefile.old',
	'$(MV) Makefile Makefile.old',
    ],
    realclean => '$(RM_F) Makefile',
    tardist => [
	'cd .tar && $(TAR) $(TARFLAGS) ../CLC-INTERCAL-%v.tar CLC-INTERCAL-%v',
	'$(RM_F) CLC-INTERCAL-%v.tar.%g',
	'gzip CLC-INTERCAL-%v.tar',
	'$(RM_RF) .tar',
    ],
    ddsh_dist => [
	"cd .ddsh && $^X -e 'require \"../$base->[2]/INTERCAL/Distribute.pm\";' \\",
	"\t-e 'Language::INTERCAL::Distribute::makeddshdist()' \\",
	"\t'' MANIFEST ../CLC-INTERCAL-%v.ddsh %v",
	'$(RM_F) CLC-INTERCAL-%v.ddsh.%g',
	'gzip CLC-INTERCAL-%v.ddsh',
	'$(RM_RF) .ddsh',
    ],
);
my %perpath = (
    realclean => '$(RM_RF) %p',
    tardist => '$(MV) "%p/CLC-INTERCAL-%n-%v.tar.%g" ".tar/CLC-INTERCAL-%v/%n.tar.%g"',
    ddsh_dist => '$(MV) "%p/CLC-INTERCAL-%n-%v.ddsh.%g" ".ddsh/%n.ddsh.%g"',
);

open(MAKEFILE, '>', 'Makefile') or die "Makefile: $!\n";
print MAKEFILE "# Tool paths from MakeMaker...\n\n" or die "Makefile: $!\n";
print MAKEFILE $constants or die "Makefile: $!\n";
print MAKEFILE "\n\n# Generated by CLC-INTERCAL...\n\n" or die "Makefile: $!\n";
print MAKEFILE "SUBDIRS = \\\n" or die "Makefile: $!\n";
for my $pv (@extras) {
    print MAKEFILE "\t$pv->[2]\\\n" or die "Makefile: $!\n";
}
print MAKEFILE "\t$base->[2]\n\n" or die "Makefile: $!\n";
print MAKEFILE "CLC_INTERCAL_PATH = $ENV{CLC_INTERCAL_PATH}\n\n" or die "Makefile: $!\n";
print MAKEFILE ".PHONY: @targets dist\n\n" or die "Makefile: $!\n";
for my $target (@targets) {
    print MAKEFILE "$target :\n" or die "Makefile: $!\n";
    if (exists $beforepath{$target}) {
	my $s = $beforepath{$target};
	my %rep = (
	    v => $VERSION,
	    g => $gz_suffix,
	    '%' => '%',
	);
	for my $c (ref $s ? @$s : $s) {
	    my $cv = $c;
	    $cv =~ s/%([vg%])/$rep{$1}/ge;
	    print MAKEFILE "\t$cv\n" or die "Makefile: $!\n";
	}
    }
    my $env = '';
    for my $pv ($base, @extras) {
	my ($name, $suffix, $path) = @$pv;
	print MAKEFILE "\tcd $path; $env\$(MAKE) $target\n" or die "Makefile: $!\n";
	my %rep = (
	    p => $path,
	    n => $name,
	    s => $suffix,
	    v => $VERSION,
	    g => $gz_suffix,
	    '%' => '%',
	);
	if (exists $perpath{$target}) {
	    my $s = $perpath{$target};
	    for my $c (ref $s ? @$s : $s) {
		my $cv = $c;
		$cv =~ s/%([pnsgv%])/$rep{$1}/ge;
		print MAKEFILE "\t$cv\n" or die "Makefile: $!\n";
	    }
	}
	$env = 'CLC_INTERCAL_PATH=\'$(CLC_INTERCAL_PATH)\' ';
    }
    if (exists $afterpath{$target}) {
	my $s = $afterpath{$target};
	my %rep = (
	    v => $VERSION,
	    g => $gz_suffix,
	    '%' => '%',
	);
	for my $c (ref $s ? @$s : $s) {
	    my $cv = $c;
	    $cv =~ s/%([vg%])/$rep{$1}/ge;
	    print MAKEFILE "\t$cv\n" or die "Makefile: $!\n";
	}
    }
    print MAKEFILE "\n" or die "Makefile: $!\n";
}
print MAKEFILE "dist : ddsh_dist\n" or die "Makefile: $!\n";
print MAKEFILE "\n" or die "Makefile: $!\n";
close MAKEFILE or die "Makefile: $!\n";

sub extract {
    my ($name, $suffix, $path) = @_;
    my @unlink = ();
    print "Uncompressing $name\n";
    unlink "$name.$suffix";
    system("gzip  -dc '$name.$suffix.$gz_suffix' > $name.$suffix") == 0
	or die "Uncompress failed: $!\n";
    push @unlink, "$name.$suffix";
    print "Extracting $name\n";
    if ($suffix eq $ddsh_suffix) {
	system('sh', "$name.$suffix") == 0
	    or die "Extraction failed: $!\n";
    } elsif ($suffix eq $tar_suffix) {
	system('tar', '-xf', "$name.$suffix") == 0
	    or die "Extraction failed: $!\n";
    } else {
	die "Internal error, suffix is not supposed to be $suffix\n";
    }
    unlink @unlink;
    print "Running Makefile.PL for $name\n";
    system("cd '$path' && $^X Makefile.PL @A") == 0
	or die "Makefile.PL failed: $!\n";
}

sub MY::tools_other {
    package MY;
    my $i = shift->SUPER::tools_other(@_);
    $constants .= $i;
    $i;
}

sub MY::dist {
    package MY;
    my $i = shift->SUPER::dist(@_);
    $constants .= $i;
    $i;
}

1;
