{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetInterpolation: TInterpolation;
    procedure SetInterpolation(const Value: TInterpolation);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_fraction: TSFFloatEvent;
    {  }
    public property EventSet_fraction: TSFFloatEvent read FEventSet_fraction;

    strict private FFdKey: TMFFloat;
    { Internal wrapper for property @link(Key). This wrapper API may change, we advise to access simpler @link(Key) instead. }
    public property FdKey: TMFFloat read FFdKey;
    {  }
    procedure SetKey(const Value: array of Single); overload;
    {  }
    procedure SetKey(const Value: TSingleList); overload;

    strict private FFdInterpolation: TSFStringEnum;
    { Internal wrapper for property @link(Interpolation). This wrapper API may change, we advise to access simpler @link(Interpolation) instead. }
    public property FdInterpolation: TSFStringEnum read FFdInterpolation;
    {  }
    property Interpolation: TInterpolation read GetInterpolation write SetInterpolation;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractInterpolatorNode ----------------------------------------------- }

procedure TAbstractInterpolatorNode.SetKey(const Value: array of Single);
begin
  FdKey.Send(Value);
end;

procedure TAbstractInterpolatorNode.SetKey(const Value: TSingleList);
begin
  FdKey.Send(Value);
end;

function TAbstractInterpolatorNode.GetInterpolation: TInterpolation;
begin
  Result := TInterpolation(FdInterpolation.EnumValue);
end;

procedure TAbstractInterpolatorNode.SetInterpolation(const Value: TInterpolation);
begin
  FdInterpolation.SendEnumValue(Ord(Value));
end;

class function TAbstractInterpolatorNode.ClassX3DType: String;
begin
  Result := 'X3DInterpolatorNode';
end;

procedure TAbstractInterpolatorNode.CreateNode;
begin
  inherited;

  FEventSet_fraction := TSFFloatEvent.Create(Self, 'set_fraction', true);
  AddEvent(FEventSet_fraction);

  FFdKey := TMFFloat.Create(Self, True, 'key', []);
   FdKey.ChangeAlways := chNone;
  AddField(FFdKey);

  FFdInterpolation := TSFStringEnum.Create(Self, True, 'interpolation', @InterpolationNames, Ord(High(InterpolationNames)) + 1, Ord(inLinear));
   FdInterpolation.ChangeAlways := chNone;
  AddField(FFdInterpolation);
end;

{$endif read_implementation}
