{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetForceContinuousValue_changed: Boolean;
    procedure SetForceContinuousValue_changed(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventNext: TSFBoolEvent;
    { X3D in event "next". } { }
    public property EventNext: TSFBoolEvent read FEventNext;

    strict private FEventPrevious: TSFBoolEvent;
    { X3D in event "previous". } { }
    public property EventPrevious: TSFBoolEvent read FEventPrevious;

    strict private FEventSet_fraction: TSFFloatEvent;
    { X3D in event "set_fraction". } { }
    public property EventSet_fraction: TSFFloatEvent read FEventSet_fraction;

    strict private FFdKey: TMFFloat;
    { X3D field "key". } { }
    public property FdKey: TMFFloat read FFdKey;
    { Set X3D field "key". } { }
    procedure SetKey(const Value: array of Single);
    { Set X3D field "key". } { }
    procedure SetKey(const Value: TSingleList);

    strict private FFdForceContinuousValue_changed: TSFBool;
    { X3D field "forceContinuousValue_changed". } { }
    public property FdForceContinuousValue_changed: TSFBool read FFdForceContinuousValue_changed;
    { X3D field "forceContinuousValue_changed". } { }
    property ForceContinuousValue_changed: Boolean read GetForceContinuousValue_changed write SetForceContinuousValue_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSequencerNode ----------------------------------------------- }

procedure TAbstractSequencerNode.SetKey(const Value: array of Single);
begin
  FdKey.Send(Value);
end;

procedure TAbstractSequencerNode.SetKey(const Value: TSingleList);
begin
  FdKey.Send(Value);
end;

function TAbstractSequencerNode.GetForceContinuousValue_changed: Boolean;
begin
  Result := FdForceContinuousValue_changed.Value;
end;

procedure TAbstractSequencerNode.SetForceContinuousValue_changed(const Value: Boolean);
begin
  FdForceContinuousValue_changed.Send(Value);
end;

class function TAbstractSequencerNode.ClassX3DType: String;
begin
  Result := 'X3DSequencerNode';
end;

procedure TAbstractSequencerNode.CreateNode;
begin
  inherited;

  FEventNext := TSFBoolEvent.Create(Self, 'next', true);
  AddEvent(FEventNext);

  FEventPrevious := TSFBoolEvent.Create(Self, 'previous', true);
  AddEvent(FEventPrevious);

  FEventSet_fraction := TSFFloatEvent.Create(Self, 'set_fraction', true);
  AddEvent(FEventSet_fraction);

  FFdKey := TMFFloat.Create(Self, True, 'key', []);
   FdKey.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdKey);
  { X3D specification comment: (-Inf,Inf) }

  FFdForceContinuousValue_changed := TSFBool.Create(Self, True, 'forceContinuousValue_changed', false);
   FdForceContinuousValue_changed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForceContinuousValue_changed);
end;

{$endif read_implementation}
