{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdEnabled: TSFBool;
    { X3D field "enabled". } { }
    public property FdEnabled: TSFBool read FFdEnabled;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FEventIsActive: TSFBoolEvent;
    { X3D out event "isActive". } { }
    public property EventIsActive: TSFBoolEvent read FEventIsActive;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSensorNode ----------------------------------------------- }

function TAbstractSensorNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TAbstractSensorNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

class function TAbstractSensorNode.ClassX3DType: String;
begin
  Result := 'X3DSensorNode';
end;

procedure TAbstractSensorNode.CreateNode;
begin
  inherited;

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FEventIsActive := TSFBoolEvent.Create(Self, 'isActive', false);
  AddEvent(FEventIsActive);
end;

{$endif read_implementation}
