{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetIntensity: Single;
    procedure SetIntensity(const Value: Single);
    function GetLocation: TVector3;
    procedure SetLocation(const Value: TVector3);
    function GetMaxBack: Single;
    procedure SetMaxBack(const Value: Single);
    function GetMaxFront: Single;
    procedure SetMaxFront(const Value: Single);
    function GetMinBack: Single;
    procedure SetMinBack(const Value: Single);
    function GetMinFront: Single;
    procedure SetMinFront(const Value: Single);
    function GetPriority: Single;
    procedure SetPriority(const Value: Single);
    function GetSource: TAbstractSoundSourceNode;
    procedure SetSource(const Value: TAbstractSoundSourceNode);
    function GetSpatialize: Boolean;
    procedure SetSpatialize(const Value: Boolean);
  public
    { X3D field "direction". } { }
    property Direction: TVector3 read GetDirection write SetDirection;
    { X3D field "intensity". } { }
    property Intensity: Single read GetIntensity write SetIntensity;
    { X3D field "location". } { }
    property Location: TVector3 read GetLocation write SetLocation;
    { X3D field "maxBack". } { }
    property MaxBack: Single read GetMaxBack write SetMaxBack;
    { X3D field "maxFront". } { }
    property MaxFront: Single read GetMaxFront write SetMaxFront;
    { X3D field "minBack". } { }
    property MinBack: Single read GetMinBack write SetMinBack;
    { X3D field "minFront". } { }
    property MinFront: Single read GetMinFront write SetMinFront;
    { X3D field "priority". } { }
    property Priority: Single read GetPriority write SetPriority;
    { X3D field "source". } { }
    property Source: TAbstractSoundSourceNode read GetSource write SetSource;
    { X3D field "spatialize". } { }
    property Spatialize: Boolean read GetSpatialize write SetSpatialize;

{$endif read_interface}

{$ifdef read_implementation}

{ TSoundNode ----------------------------------------------- }

function TSoundNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TSoundNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TSoundNode.GetIntensity: Single;
begin
  Result := FdIntensity.Value;
end;

procedure TSoundNode.SetIntensity(const Value: Single);
begin
  FdIntensity.Send(Value);
end;

function TSoundNode.GetLocation: TVector3;
begin
  Result := FdLocation.Value;
end;

procedure TSoundNode.SetLocation(const Value: TVector3);
begin
  FdLocation.Send(Value);
end;

function TSoundNode.GetMaxBack: Single;
begin
  Result := FdMaxBack.Value;
end;

procedure TSoundNode.SetMaxBack(const Value: Single);
begin
  FdMaxBack.Send(Value);
end;

function TSoundNode.GetMaxFront: Single;
begin
  Result := FdMaxFront.Value;
end;

procedure TSoundNode.SetMaxFront(const Value: Single);
begin
  FdMaxFront.Send(Value);
end;

function TSoundNode.GetMinBack: Single;
begin
  Result := FdMinBack.Value;
end;

procedure TSoundNode.SetMinBack(const Value: Single);
begin
  FdMinBack.Send(Value);
end;

function TSoundNode.GetMinFront: Single;
begin
  Result := FdMinFront.Value;
end;

procedure TSoundNode.SetMinFront(const Value: Single);
begin
  FdMinFront.Send(Value);
end;

function TSoundNode.GetPriority: Single;
begin
  Result := FdPriority.Value;
end;

procedure TSoundNode.SetPriority(const Value: Single);
begin
  FdPriority.Send(Value);
end;

function TSoundNode.GetSource: TAbstractSoundSourceNode;
begin
  if FdSource.Value is TAbstractSoundSourceNode then
    Result := TAbstractSoundSourceNode(FdSource.Value)
  else
    Result := nil;
end;

procedure TSoundNode.SetSource(const Value: TAbstractSoundSourceNode);
begin
  FdSource.Send(Value);
end;

function TSoundNode.GetSpatialize: Boolean;
begin
  Result := FdSpatialize.Value;
end;

procedure TSoundNode.SetSpatialize(const Value: Boolean);
begin
  FdSpatialize.Send(Value);
end;

{$endif read_implementation}
