{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAxisRotation: TVector4;
    procedure SetAxisRotation(const Value: TVector4);
    function GetMaxPosition: TVector2;
    procedure SetMaxPosition(const Value: TVector2);
    function GetMinPosition: TVector2;
    procedure SetMinPosition(const Value: TVector2);
    function GetOffset: TVector3;
    procedure SetOffset(const Value: TVector3);
  public
    { X3D field "axisRotation". } { }
    property AxisRotation: TVector4 read GetAxisRotation write SetAxisRotation;
    { X3D field "maxPosition". } { }
    property MaxPosition: TVector2 read GetMaxPosition write SetMaxPosition;
    { X3D field "minPosition". } { }
    property MinPosition: TVector2 read GetMinPosition write SetMinPosition;
    { X3D field "offset". } { }
    property Offset: TVector3 read GetOffset write SetOffset;

{$endif read_interface}

{$ifdef read_implementation}

{ TPlaneSensorNode ----------------------------------------------- }

function TPlaneSensorNode.GetAxisRotation: TVector4;
begin
  Result := FdAxisRotation.Value;
end;

procedure TPlaneSensorNode.SetAxisRotation(const Value: TVector4);
begin
  FdAxisRotation.Send(Value);
end;

function TPlaneSensorNode.GetMaxPosition: TVector2;
begin
  Result := FdMaxPosition.Value;
end;

procedure TPlaneSensorNode.SetMaxPosition(const Value: TVector2);
begin
  FdMaxPosition.Send(Value);
end;

function TPlaneSensorNode.GetMinPosition: TVector2;
begin
  Result := FdMinPosition.Value;
end;

procedure TPlaneSensorNode.SetMinPosition(const Value: TVector2);
begin
  FdMinPosition.Send(Value);
end;

function TPlaneSensorNode.GetOffset: TVector3;
begin
  Result := FdOffset.Value;
end;

procedure TPlaneSensorNode.SetOffset(const Value: TVector3);
begin
  FdOffset.Send(Value);
end;

{$endif read_implementation}
