{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: array of TVector3Double);
    { Set X3D field "keyValue". } { }
    procedure SetKeyValue(const Value: TVector3DoubleList);
    { X3D field "geoOrigin". } { }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: array of string);
    { Set X3D field "geoSystem". } { }
    procedure SetGeoSystem(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoPositionInterpolatorNode ----------------------------------------------- }

procedure TGeoPositionInterpolatorNode.SetKeyValue(const Value: array of TVector3Double);
begin
  FdKeyValue.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetKeyValue(const Value: TVector3DoubleList);
begin
  FdKeyValue.Send(Value);
end;

function TGeoPositionInterpolatorNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoPositionInterpolatorNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

{$endif read_implementation}
