{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSrcFactor: String;
    procedure SetSrcFactor(const Value: String);
    function GetDestFactor: String;
    procedure SetDestFactor(const Value: String);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetColorTransparency: Single;
    procedure SetColorTransparency(const Value: Single);
  public
    { X3D field "srcFactor". } { }
    property SrcFactor: String read GetSrcFactor write SetSrcFactor;
    { X3D field "destFactor". } { }
    property DestFactor: String read GetDestFactor write SetDestFactor;
    { X3D field "color". } { }
    property Color: TCastleColorRGB read GetColor write SetColor;
    { X3D field "colorTransparency". } { }
    property ColorTransparency: Single read GetColorTransparency write SetColorTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TBlendModeNode ----------------------------------------------- }

function TBlendModeNode.GetSrcFactor: String;
begin
  Result := FdSrcFactor.Value;
end;

procedure TBlendModeNode.SetSrcFactor(const Value: String);
begin
  FdSrcFactor.Send(Value);
end;

function TBlendModeNode.GetDestFactor: String;
begin
  Result := FdDestFactor.Value;
end;

procedure TBlendModeNode.SetDestFactor(const Value: String);
begin
  FdDestFactor.Send(Value);
end;

function TBlendModeNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TBlendModeNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TBlendModeNode.GetColorTransparency: Single;
begin
  Result := FdColorTransparency.Value;
end;

procedure TBlendModeNode.SetColorTransparency(const Value: Single);
begin
  FdColorTransparency.Send(Value);
end;

{$endif read_implementation}
