/*
* Substitution/Permutation Tables for DES
* (C) 1999-2007 Jack Lloyd
*
* Distributed under the terms of the Botan license
*/

#include <botan/des.h>

namespace Botan {

const u32bit DES_SPBOX1[256] = {
   0x01010400, 0x00000000, 0x00010000, 0x01010404, 0x01010004, 0x00010404,
   0x00000004, 0x00010000, 0x00000400, 0x01010400, 0x01010404, 0x00000400,
   0x01000404, 0x01010004, 0x01000000, 0x00000004, 0x00000404, 0x01000400,
   0x01000400, 0x00010400, 0x00010400, 0x01010000, 0x01010000, 0x01000404,
   0x00010004, 0x01000004, 0x01000004, 0x00010004, 0x00000000, 0x00000404,
   0x00010404, 0x01000000, 0x00010000, 0x01010404, 0x00000004, 0x01010000,
   0x01010400, 0x01000000, 0x01000000, 0x00000400, 0x01010004, 0x00010000,
   0x00010400, 0x01000004, 0x00000400, 0x00000004, 0x01000404, 0x00010404,
   0x01010404, 0x00010004, 0x01010000, 0x01000404, 0x01000004, 0x00000404,
   0x00010404, 0x01010400, 0x00000404, 0x01000400, 0x01000400, 0x00000000,
   0x00010004, 0x00010400, 0x00000000, 0x01010004, 0x01010400, 0x00000000,
   0x00010000, 0x01010404, 0x01010004, 0x00010404, 0x00000004, 0x00010000,
   0x00000400, 0x01010400, 0x01010404, 0x00000400, 0x01000404, 0x01010004,
   0x01000000, 0x00000004, 0x00000404, 0x01000400, 0x01000400, 0x00010400,
   0x00010400, 0x01010000, 0x01010000, 0x01000404, 0x00010004, 0x01000004,
   0x01000004, 0x00010004, 0x00000000, 0x00000404, 0x00010404, 0x01000000,
   0x00010000, 0x01010404, 0x00000004, 0x01010000, 0x01010400, 0x01000000,
   0x01000000, 0x00000400, 0x01010004, 0x00010000, 0x00010400, 0x01000004,
   0x00000400, 0x00000004, 0x01000404, 0x00010404, 0x01010404, 0x00010004,
   0x01010000, 0x01000404, 0x01000004, 0x00000404, 0x00010404, 0x01010400,
   0x00000404, 0x01000400, 0x01000400, 0x00000000, 0x00010004, 0x00010400,
   0x00000000, 0x01010004, 0x01010400, 0x00000000, 0x00010000, 0x01010404,
   0x01010004, 0x00010404, 0x00000004, 0x00010000, 0x00000400, 0x01010400,
   0x01010404, 0x00000400, 0x01000404, 0x01010004, 0x01000000, 0x00000004,
   0x00000404, 0x01000400, 0x01000400, 0x00010400, 0x00010400, 0x01010000,
   0x01010000, 0x01000404, 0x00010004, 0x01000004, 0x01000004, 0x00010004,
   0x00000000, 0x00000404, 0x00010404, 0x01000000, 0x00010000, 0x01010404,
   0x00000004, 0x01010000, 0x01010400, 0x01000000, 0x01000000, 0x00000400,
   0x01010004, 0x00010000, 0x00010400, 0x01000004, 0x00000400, 0x00000004,
   0x01000404, 0x00010404, 0x01010404, 0x00010004, 0x01010000, 0x01000404,
   0x01000004, 0x00000404, 0x00010404, 0x01010400, 0x00000404, 0x01000400,
   0x01000400, 0x00000000, 0x00010004, 0x00010400, 0x00000000, 0x01010004,
   0x01010400, 0x00000000, 0x00010000, 0x01010404, 0x01010004, 0x00010404,
   0x00000004, 0x00010000, 0x00000400, 0x01010400, 0x01010404, 0x00000400,
   0x01000404, 0x01010004, 0x01000000, 0x00000004, 0x00000404, 0x01000400,
   0x01000400, 0x00010400, 0x00010400, 0x01010000, 0x01010000, 0x01000404,
   0x00010004, 0x01000004, 0x01000004, 0x00010004, 0x00000000, 0x00000404,
   0x00010404, 0x01000000, 0x00010000, 0x01010404, 0x00000004, 0x01010000,
   0x01010400, 0x01000000, 0x01000000, 0x00000400, 0x01010004, 0x00010000,
   0x00010400, 0x01000004, 0x00000400, 0x00000004, 0x01000404, 0x00010404,
   0x01010404, 0x00010004, 0x01010000, 0x01000404, 0x01000004, 0x00000404,
   0x00010404, 0x01010400, 0x00000404, 0x01000400, 0x01000400, 0x00000000,
   0x00010004, 0x00010400, 0x00000000, 0x01010004 };

const u32bit DES_SPBOX2[256] = {
   0x80108020, 0x80008000, 0x00008000, 0x00108020, 0x00100000, 0x00000020,
   0x80100020, 0x80008020, 0x80000020, 0x80108020, 0x80108000, 0x80000000,
   0x80008000, 0x00100000, 0x00000020, 0x80100020, 0x00108000, 0x00100020,
   0x80008020, 0x00000000, 0x80000000, 0x00008000, 0x00108020, 0x80100000,
   0x00100020, 0x80000020, 0x00000000, 0x00108000, 0x00008020, 0x80108000,
   0x80100000, 0x00008020, 0x00000000, 0x00108020, 0x80100020, 0x00100000,
   0x80008020, 0x80100000, 0x80108000, 0x00008000, 0x80100000, 0x80008000,
   0x00000020, 0x80108020, 0x00108020, 0x00000020, 0x00008000, 0x80000000,
   0x00008020, 0x80108000, 0x00100000, 0x80000020, 0x00100020, 0x80008020,
   0x80000020, 0x00100020, 0x00108000, 0x00000000, 0x80008000, 0x00008020,
   0x80000000, 0x80100020, 0x80108020, 0x00108000, 0x80108020, 0x80008000,
   0x00008000, 0x00108020, 0x00100000, 0x00000020, 0x80100020, 0x80008020,
   0x80000020, 0x80108020, 0x80108000, 0x80000000, 0x80008000, 0x00100000,
   0x00000020, 0x80100020, 0x00108000, 0x00100020, 0x80008020, 0x00000000,
   0x80000000, 0x00008000, 0x00108020, 0x80100000, 0x00100020, 0x80000020,
   0x00000000, 0x00108000, 0x00008020, 0x80108000, 0x80100000, 0x00008020,
   0x00000000, 0x00108020, 0x80100020, 0x00100000, 0x80008020, 0x80100000,
   0x80108000, 0x00008000, 0x80100000, 0x80008000, 0x00000020, 0x80108020,
   0x00108020, 0x00000020, 0x00008000, 0x80000000, 0x00008020, 0x80108000,
   0x00100000, 0x80000020, 0x00100020, 0x80008020, 0x80000020, 0x00100020,
   0x00108000, 0x00000000, 0x80008000, 0x00008020, 0x80000000, 0x80100020,
   0x80108020, 0x00108000, 0x80108020, 0x80008000, 0x00008000, 0x00108020,
   0x00100000, 0x00000020, 0x80100020, 0x80008020, 0x80000020, 0x80108020,
   0x80108000, 0x80000000, 0x80008000, 0x00100000, 0x00000020, 0x80100020,
   0x00108000, 0x00100020, 0x80008020, 0x00000000, 0x80000000, 0x00008000,
   0x00108020, 0x80100000, 0x00100020, 0x80000020, 0x00000000, 0x00108000,
   0x00008020, 0x80108000, 0x80100000, 0x00008020, 0x00000000, 0x00108020,
   0x80100020, 0x00100000, 0x80008020, 0x80100000, 0x80108000, 0x00008000,
   0x80100000, 0x80008000, 0x00000020, 0x80108020, 0x00108020, 0x00000020,
   0x00008000, 0x80000000, 0x00008020, 0x80108000, 0x00100000, 0x80000020,
   0x00100020, 0x80008020, 0x80000020, 0x00100020, 0x00108000, 0x00000000,
   0x80008000, 0x00008020, 0x80000000, 0x80100020, 0x80108020, 0x00108000,
   0x80108020, 0x80008000, 0x00008000, 0x00108020, 0x00100000, 0x00000020,
   0x80100020, 0x80008020, 0x80000020, 0x80108020, 0x80108000, 0x80000000,
   0x80008000, 0x00100000, 0x00000020, 0x80100020, 0x00108000, 0x00100020,
   0x80008020, 0x00000000, 0x80000000, 0x00008000, 0x00108020, 0x80100000,
   0x00100020, 0x80000020, 0x00000000, 0x00108000, 0x00008020, 0x80108000,
   0x80100000, 0x00008020, 0x00000000, 0x00108020, 0x80100020, 0x00100000,
   0x80008020, 0x80100000, 0x80108000, 0x00008000, 0x80100000, 0x80008000,
   0x00000020, 0x80108020, 0x00108020, 0x00000020, 0x00008000, 0x80000000,
   0x00008020, 0x80108000, 0x00100000, 0x80000020, 0x00100020, 0x80008020,
   0x80000020, 0x00100020, 0x00108000, 0x00000000, 0x80008000, 0x00008020,
   0x80000000, 0x80100020, 0x80108020, 0x00108000 };

const u32bit DES_SPBOX3[256] = {
   0x00000208, 0x08020200, 0x00000000, 0x08020008, 0x08000200, 0x00000000,
   0x00020208, 0x08000200, 0x00020008, 0x08000008, 0x08000008, 0x00020000,
   0x08020208, 0x00020008, 0x08020000, 0x00000208, 0x08000000, 0x00000008,
   0x08020200, 0x00000200, 0x00020200, 0x08020000, 0x08020008, 0x00020208,
   0x08000208, 0x00020200, 0x00020000, 0x08000208, 0x00000008, 0x08020208,
   0x00000200, 0x08000000, 0x08020200, 0x08000000, 0x00020008, 0x00000208,
   0x00020000, 0x08020200, 0x08000200, 0x00000000, 0x00000200, 0x00020008,
   0x08020208, 0x08000200, 0x08000008, 0x00000200, 0x00000000, 0x08020008,
   0x08000208, 0x00020000, 0x08000000, 0x08020208, 0x00000008, 0x00020208,
   0x00020200, 0x08000008, 0x08020000, 0x08000208, 0x00000208, 0x08020000,
   0x00020208, 0x00000008, 0x08020008, 0x00020200, 0x00000208, 0x08020200,
   0x00000000, 0x08020008, 0x08000200, 0x00000000, 0x00020208, 0x08000200,
   0x00020008, 0x08000008, 0x08000008, 0x00020000, 0x08020208, 0x00020008,
   0x08020000, 0x00000208, 0x08000000, 0x00000008, 0x08020200, 0x00000200,
   0x00020200, 0x08020000, 0x08020008, 0x00020208, 0x08000208, 0x00020200,
   0x00020000, 0x08000208, 0x00000008, 0x08020208, 0x00000200, 0x08000000,
   0x08020200, 0x08000000, 0x00020008, 0x00000208, 0x00020000, 0x08020200,
   0x08000200, 0x00000000, 0x00000200, 0x00020008, 0x08020208, 0x08000200,
   0x08000008, 0x00000200, 0x00000000, 0x08020008, 0x08000208, 0x00020000,
   0x08000000, 0x08020208, 0x00000008, 0x00020208, 0x00020200, 0x08000008,
   0x08020000, 0x08000208, 0x00000208, 0x08020000, 0x00020208, 0x00000008,
   0x08020008, 0x00020200, 0x00000208, 0x08020200, 0x00000000, 0x08020008,
   0x08000200, 0x00000000, 0x00020208, 0x08000200, 0x00020008, 0x08000008,
   0x08000008, 0x00020000, 0x08020208, 0x00020008, 0x08020000, 0x00000208,
   0x08000000, 0x00000008, 0x08020200, 0x00000200, 0x00020200, 0x08020000,
   0x08020008, 0x00020208, 0x08000208, 0x00020200, 0x00020000, 0x08000208,
   0x00000008, 0x08020208, 0x00000200, 0x08000000, 0x08020200, 0x08000000,
   0x00020008, 0x00000208, 0x00020000, 0x08020200, 0x08000200, 0x00000000,
   0x00000200, 0x00020008, 0x08020208, 0x08000200, 0x08000008, 0x00000200,
   0x00000000, 0x08020008, 0x08000208, 0x00020000, 0x08000000, 0x08020208,
   0x00000008, 0x00020208, 0x00020200, 0x08000008, 0x08020000, 0x08000208,
   0x00000208, 0x08020000, 0x00020208, 0x00000008, 0x08020008, 0x00020200,
   0x00000208, 0x08020200, 0x00000000, 0x08020008, 0x08000200, 0x00000000,
   0x00020208, 0x08000200, 0x00020008, 0x08000008, 0x08000008, 0x00020000,
   0x08020208, 0x00020008, 0x08020000, 0x00000208, 0x08000000, 0x00000008,
   0x08020200, 0x00000200, 0x00020200, 0x08020000, 0x08020008, 0x00020208,
   0x08000208, 0x00020200, 0x00020000, 0x08000208, 0x00000008, 0x08020208,
   0x00000200, 0x08000000, 0x08020200, 0x08000000, 0x00020008, 0x00000208,
   0x00020000, 0x08020200, 0x08000200, 0x00000000, 0x00000200, 0x00020008,
   0x08020208, 0x08000200, 0x08000008, 0x00000200, 0x00000000, 0x08020008,
   0x08000208, 0x00020000, 0x08000000, 0x08020208, 0x00000008, 0x00020208,
   0x00020200, 0x08000008, 0x08020000, 0x08000208, 0x00000208, 0x08020000,
   0x00020208, 0x00000008, 0x08020008, 0x00020200 };

const u32bit DES_SPBOX4[256] = {
   0x00802001, 0x00002081, 0x00002081, 0x00000080, 0x00802080, 0x00800081,
   0x00800001, 0x00002001, 0x00000000, 0x00802000, 0x00802000, 0x00802081,
   0x00000081, 0x00000000, 0x00800080, 0x00800001, 0x00000001, 0x00002000,
   0x00800000, 0x00802001, 0x00000080, 0x00800000, 0x00002001, 0x00002080,
   0x00800081, 0x00000001, 0x00002080, 0x00800080, 0x00002000, 0x00802080,
   0x00802081, 0x00000081, 0x00800080, 0x00800001, 0x00802000, 0x00802081,
   0x00000081, 0x00000000, 0x00000000, 0x00802000, 0x00002080, 0x00800080,
   0x00800081, 0x00000001, 0x00802001, 0x00002081, 0x00002081, 0x00000080,
   0x00802081, 0x00000081, 0x00000001, 0x00002000, 0x00800001, 0x00002001,
   0x00802080, 0x00800081, 0x00002001, 0x00002080, 0x00800000, 0x00802001,
   0x00000080, 0x00800000, 0x00002000, 0x00802080, 0x00802001, 0x00002081,
   0x00002081, 0x00000080, 0x00802080, 0x00800081, 0x00800001, 0x00002001,
   0x00000000, 0x00802000, 0x00802000, 0x00802081, 0x00000081, 0x00000000,
   0x00800080, 0x00800001, 0x00000001, 0x00002000, 0x00800000, 0x00802001,
   0x00000080, 0x00800000, 0x00002001, 0x00002080, 0x00800081, 0x00000001,
   0x00002080, 0x00800080, 0x00002000, 0x00802080, 0x00802081, 0x00000081,
   0x00800080, 0x00800001, 0x00802000, 0x00802081, 0x00000081, 0x00000000,
   0x00000000, 0x00802000, 0x00002080, 0x00800080, 0x00800081, 0x00000001,
   0x00802001, 0x00002081, 0x00002081, 0x00000080, 0x00802081, 0x00000081,
   0x00000001, 0x00002000, 0x00800001, 0x00002001, 0x00802080, 0x00800081,
   0x00002001, 0x00002080, 0x00800000, 0x00802001, 0x00000080, 0x00800000,
   0x00002000, 0x00802080, 0x00802001, 0x00002081, 0x00002081, 0x00000080,
   0x00802080, 0x00800081, 0x00800001, 0x00002001, 0x00000000, 0x00802000,
   0x00802000, 0x00802081, 0x00000081, 0x00000000, 0x00800080, 0x00800001,
   0x00000001, 0x00002000, 0x00800000, 0x00802001, 0x00000080, 0x00800000,
   0x00002001, 0x00002080, 0x00800081, 0x00000001, 0x00002080, 0x00800080,
   0x00002000, 0x00802080, 0x00802081, 0x00000081, 0x00800080, 0x00800001,
   0x00802000, 0x00802081, 0x00000081, 0x00000000, 0x00000000, 0x00802000,
   0x00002080, 0x00800080, 0x00800081, 0x00000001, 0x00802001, 0x00002081,
   0x00002081, 0x00000080, 0x00802081, 0x00000081, 0x00000001, 0x00002000,
   0x00800001, 0x00002001, 0x00802080, 0x00800081, 0x00002001, 0x00002080,
   0x00800000, 0x00802001, 0x00000080, 0x00800000, 0x00002000, 0x00802080,
   0x00802001, 0x00002081, 0x00002081, 0x00000080, 0x00802080, 0x00800081,
   0x00800001, 0x00002001, 0x00000000, 0x00802000, 0x00802000, 0x00802081,
   0x00000081, 0x00000000, 0x00800080, 0x00800001, 0x00000001, 0x00002000,
   0x00800000, 0x00802001, 0x00000080, 0x00800000, 0x00002001, 0x00002080,
   0x00800081, 0x00000001, 0x00002080, 0x00800080, 0x00002000, 0x00802080,
   0x00802081, 0x00000081, 0x00800080, 0x00800001, 0x00802000, 0x00802081,
   0x00000081, 0x00000000, 0x00000000, 0x00802000, 0x00002080, 0x00800080,
   0x00800081, 0x00000001, 0x00802001, 0x00002081, 0x00002081, 0x00000080,
   0x00802081, 0x00000081, 0x00000001, 0x00002000, 0x00800001, 0x00002001,
   0x00802080, 0x00800081, 0x00002001, 0x00002080, 0x00800000, 0x00802001,
   0x00000080, 0x00800000, 0x00002000, 0x00802080 };

const u32bit DES_SPBOX5[256] = {
   0x00000100, 0x02080100, 0x02080000, 0x42000100, 0x00080000, 0x00000100,
   0x40000000, 0x02080000, 0x40080100, 0x00080000, 0x02000100, 0x40080100,
   0x42000100, 0x42080000, 0x00080100, 0x40000000, 0x02000000, 0x40080000,
   0x40080000, 0x00000000, 0x40000100, 0x42080100, 0x42080100, 0x02000100,
   0x42080000, 0x40000100, 0x00000000, 0x42000000, 0x02080100, 0x02000000,
   0x42000000, 0x00080100, 0x00080000, 0x42000100, 0x00000100, 0x02000000,
   0x40000000, 0x02080000, 0x42000100, 0x40080100, 0x02000100, 0x40000000,
   0x42080000, 0x02080100, 0x40080100, 0x00000100, 0x02000000, 0x42080000,
   0x42080100, 0x00080100, 0x42000000, 0x42080100, 0x02080000, 0x00000000,
   0x40080000, 0x42000000, 0x00080100, 0x02000100, 0x40000100, 0x00080000,
   0x00000000, 0x40080000, 0x02080100, 0x40000100, 0x00000100, 0x02080100,
   0x02080000, 0x42000100, 0x00080000, 0x00000100, 0x40000000, 0x02080000,
   0x40080100, 0x00080000, 0x02000100, 0x40080100, 0x42000100, 0x42080000,
   0x00080100, 0x40000000, 0x02000000, 0x40080000, 0x40080000, 0x00000000,
   0x40000100, 0x42080100, 0x42080100, 0x02000100, 0x42080000, 0x40000100,
   0x00000000, 0x42000000, 0x02080100, 0x02000000, 0x42000000, 0x00080100,
   0x00080000, 0x42000100, 0x00000100, 0x02000000, 0x40000000, 0x02080000,
   0x42000100, 0x40080100, 0x02000100, 0x40000000, 0x42080000, 0x02080100,
   0x40080100, 0x00000100, 0x02000000, 0x42080000, 0x42080100, 0x00080100,
   0x42000000, 0x42080100, 0x02080000, 0x00000000, 0x40080000, 0x42000000,
   0x00080100, 0x02000100, 0x40000100, 0x00080000, 0x00000000, 0x40080000,
   0x02080100, 0x40000100, 0x00000100, 0x02080100, 0x02080000, 0x42000100,
   0x00080000, 0x00000100, 0x40000000, 0x02080000, 0x40080100, 0x00080000,
   0x02000100, 0x40080100, 0x42000100, 0x42080000, 0x00080100, 0x40000000,
   0x02000000, 0x40080000, 0x40080000, 0x00000000, 0x40000100, 0x42080100,
   0x42080100, 0x02000100, 0x42080000, 0x40000100, 0x00000000, 0x42000000,
   0x02080100, 0x02000000, 0x42000000, 0x00080100, 0x00080000, 0x42000100,
   0x00000100, 0x02000000, 0x40000000, 0x02080000, 0x42000100, 0x40080100,
   0x02000100, 0x40000000, 0x42080000, 0x02080100, 0x40080100, 0x00000100,
   0x02000000, 0x42080000, 0x42080100, 0x00080100, 0x42000000, 0x42080100,
   0x02080000, 0x00000000, 0x40080000, 0x42000000, 0x00080100, 0x02000100,
   0x40000100, 0x00080000, 0x00000000, 0x40080000, 0x02080100, 0x40000100,
   0x00000100, 0x02080100, 0x02080000, 0x42000100, 0x00080000, 0x00000100,
   0x40000000, 0x02080000, 0x40080100, 0x00080000, 0x02000100, 0x40080100,
   0x42000100, 0x42080000, 0x00080100, 0x40000000, 0x02000000, 0x40080000,
   0x40080000, 0x00000000, 0x40000100, 0x42080100, 0x42080100, 0x02000100,
   0x42080000, 0x40000100, 0x00000000, 0x42000000, 0x02080100, 0x02000000,
   0x42000000, 0x00080100, 0x00080000, 0x42000100, 0x00000100, 0x02000000,
   0x40000000, 0x02080000, 0x42000100, 0x40080100, 0x02000100, 0x40000000,
   0x42080000, 0x02080100, 0x40080100, 0x00000100, 0x02000000, 0x42080000,
   0x42080100, 0x00080100, 0x42000000, 0x42080100, 0x02080000, 0x00000000,
   0x40080000, 0x42000000, 0x00080100, 0x02000100, 0x40000100, 0x00080000,
   0x00000000, 0x40080000, 0x02080100, 0x40000100 };

const u32bit DES_SPBOX6[256] = {
   0x20000010, 0x20400000, 0x00004000, 0x20404010, 0x20400000, 0x00000010,
   0x20404010, 0x00400000, 0x20004000, 0x00404010, 0x00400000, 0x20000010,
   0x00400010, 0x20004000, 0x20000000, 0x00004010, 0x00000000, 0x00400010,
   0x20004010, 0x00004000, 0x00404000, 0x20004010, 0x00000010, 0x20400010,
   0x20400010, 0x00000000, 0x00404010, 0x20404000, 0x00004010, 0x00404000,
   0x20404000, 0x20000000, 0x20004000, 0x00000010, 0x20400010, 0x00404000,
   0x20404010, 0x00400000, 0x00004010, 0x20000010, 0x00400000, 0x20004000,
   0x20000000, 0x00004010, 0x20000010, 0x20404010, 0x00404000, 0x20400000,
   0x00404010, 0x20404000, 0x00000000, 0x20400010, 0x00000010, 0x00004000,
   0x20400000, 0x00404010, 0x00004000, 0x00400010, 0x20004010, 0x00000000,
   0x20404000, 0x20000000, 0x00400010, 0x20004010, 0x20000010, 0x20400000,
   0x00004000, 0x20404010, 0x20400000, 0x00000010, 0x20404010, 0x00400000,
   0x20004000, 0x00404010, 0x00400000, 0x20000010, 0x00400010, 0x20004000,
   0x20000000, 0x00004010, 0x00000000, 0x00400010, 0x20004010, 0x00004000,
   0x00404000, 0x20004010, 0x00000010, 0x20400010, 0x20400010, 0x00000000,
   0x00404010, 0x20404000, 0x00004010, 0x00404000, 0x20404000, 0x20000000,
   0x20004000, 0x00000010, 0x20400010, 0x00404000, 0x20404010, 0x00400000,
   0x00004010, 0x20000010, 0x00400000, 0x20004000, 0x20000000, 0x00004010,
   0x20000010, 0x20404010, 0x00404000, 0x20400000, 0x00404010, 0x20404000,
   0x00000000, 0x20400010, 0x00000010, 0x00004000, 0x20400000, 0x00404010,
   0x00004000, 0x00400010, 0x20004010, 0x00000000, 0x20404000, 0x20000000,
   0x00400010, 0x20004010, 0x20000010, 0x20400000, 0x00004000, 0x20404010,
   0x20400000, 0x00000010, 0x20404010, 0x00400000, 0x20004000, 0x00404010,
   0x00400000, 0x20000010, 0x00400010, 0x20004000, 0x20000000, 0x00004010,
   0x00000000, 0x00400010, 0x20004010, 0x00004000, 0x00404000, 0x20004010,
   0x00000010, 0x20400010, 0x20400010, 0x00000000, 0x00404010, 0x20404000,
   0x00004010, 0x00404000, 0x20404000, 0x20000000, 0x20004000, 0x00000010,
   0x20400010, 0x00404000, 0x20404010, 0x00400000, 0x00004010, 0x20000010,
   0x00400000, 0x20004000, 0x20000000, 0x00004010, 0x20000010, 0x20404010,
   0x00404000, 0x20400000, 0x00404010, 0x20404000, 0x00000000, 0x20400010,
   0x00000010, 0x00004000, 0x20400000, 0x00404010, 0x00004000, 0x00400010,
   0x20004010, 0x00000000, 0x20404000, 0x20000000, 0x00400010, 0x20004010,
   0x20000010, 0x20400000, 0x00004000, 0x20404010, 0x20400000, 0x00000010,
   0x20404010, 0x00400000, 0x20004000, 0x00404010, 0x00400000, 0x20000010,
   0x00400010, 0x20004000, 0x20000000, 0x00004010, 0x00000000, 0x00400010,
   0x20004010, 0x00004000, 0x00404000, 0x20004010, 0x00000010, 0x20400010,
   0x20400010, 0x00000000, 0x00404010, 0x20404000, 0x00004010, 0x00404000,
   0x20404000, 0x20000000, 0x20004000, 0x00000010, 0x20400010, 0x00404000,
   0x20404010, 0x00400000, 0x00004010, 0x20000010, 0x00400000, 0x20004000,
   0x20000000, 0x00004010, 0x20000010, 0x20404010, 0x00404000, 0x20400000,
   0x00404010, 0x20404000, 0x00000000, 0x20400010, 0x00000010, 0x00004000,
   0x20400000, 0x00404010, 0x00004000, 0x00400010, 0x20004010, 0x00000000,
   0x20404000, 0x20000000, 0x00400010, 0x20004010 };

const u32bit DES_SPBOX7[256] = {
   0x00200000, 0x04200002, 0x04000802, 0x00000000, 0x00000800, 0x04000802,
   0x00200802, 0x04200800, 0x04200802, 0x00200000, 0x00000000, 0x04000002,
   0x00000002, 0x04000000, 0x04200002, 0x00000802, 0x04000800, 0x00200802,
   0x00200002, 0x04000800, 0x04000002, 0x04200000, 0x04200800, 0x00200002,
   0x04200000, 0x00000800, 0x00000802, 0x04200802, 0x00200800, 0x00000002,
   0x04000000, 0x00200800, 0x04000000, 0x00200800, 0x00200000, 0x04000802,
   0x04000802, 0x04200002, 0x04200002, 0x00000002, 0x00200002, 0x04000000,
   0x04000800, 0x00200000, 0x04200800, 0x00000802, 0x00200802, 0x04200800,
   0x00000802, 0x04000002, 0x04200802, 0x04200000, 0x00200800, 0x00000000,
   0x00000002, 0x04200802, 0x00000000, 0x00200802, 0x04200000, 0x00000800,
   0x04000002, 0x04000800, 0x00000800, 0x00200002, 0x00200000, 0x04200002,
   0x04000802, 0x00000000, 0x00000800, 0x04000802, 0x00200802, 0x04200800,
   0x04200802, 0x00200000, 0x00000000, 0x04000002, 0x00000002, 0x04000000,
   0x04200002, 0x00000802, 0x04000800, 0x00200802, 0x00200002, 0x04000800,
   0x04000002, 0x04200000, 0x04200800, 0x00200002, 0x04200000, 0x00000800,
   0x00000802, 0x04200802, 0x00200800, 0x00000002, 0x04000000, 0x00200800,
   0x04000000, 0x00200800, 0x00200000, 0x04000802, 0x04000802, 0x04200002,
   0x04200002, 0x00000002, 0x00200002, 0x04000000, 0x04000800, 0x00200000,
   0x04200800, 0x00000802, 0x00200802, 0x04200800, 0x00000802, 0x04000002,
   0x04200802, 0x04200000, 0x00200800, 0x00000000, 0x00000002, 0x04200802,
   0x00000000, 0x00200802, 0x04200000, 0x00000800, 0x04000002, 0x04000800,
   0x00000800, 0x00200002, 0x00200000, 0x04200002, 0x04000802, 0x00000000,
   0x00000800, 0x04000802, 0x00200802, 0x04200800, 0x04200802, 0x00200000,
   0x00000000, 0x04000002, 0x00000002, 0x04000000, 0x04200002, 0x00000802,
   0x04000800, 0x00200802, 0x00200002, 0x04000800, 0x04000002, 0x04200000,
   0x04200800, 0x00200002, 0x04200000, 0x00000800, 0x00000802, 0x04200802,
   0x00200800, 0x00000002, 0x04000000, 0x00200800, 0x04000000, 0x00200800,
   0x00200000, 0x04000802, 0x04000802, 0x04200002, 0x04200002, 0x00000002,
   0x00200002, 0x04000000, 0x04000800, 0x00200000, 0x04200800, 0x00000802,
   0x00200802, 0x04200800, 0x00000802, 0x04000002, 0x04200802, 0x04200000,
   0x00200800, 0x00000000, 0x00000002, 0x04200802, 0x00000000, 0x00200802,
   0x04200000, 0x00000800, 0x04000002, 0x04000800, 0x00000800, 0x00200002,
   0x00200000, 0x04200002, 0x04000802, 0x00000000, 0x00000800, 0x04000802,
   0x00200802, 0x04200800, 0x04200802, 0x00200000, 0x00000000, 0x04000002,
   0x00000002, 0x04000000, 0x04200002, 0x00000802, 0x04000800, 0x00200802,
   0x00200002, 0x04000800, 0x04000002, 0x04200000, 0x04200800, 0x00200002,
   0x04200000, 0x00000800, 0x00000802, 0x04200802, 0x00200800, 0x00000002,
   0x04000000, 0x00200800, 0x04000000, 0x00200800, 0x00200000, 0x04000802,
   0x04000802, 0x04200002, 0x04200002, 0x00000002, 0x00200002, 0x04000000,
   0x04000800, 0x00200000, 0x04200800, 0x00000802, 0x00200802, 0x04200800,
   0x00000802, 0x04000002, 0x04200802, 0x04200000, 0x00200800, 0x00000000,
   0x00000002, 0x04200802, 0x00000000, 0x00200802, 0x04200000, 0x00000800,
   0x04000002, 0x04000800, 0x00000800, 0x00200002 };

const u32bit DES_SPBOX8[256] = {
   0x10001040, 0x00001000, 0x00040000, 0x10041040, 0x10000000, 0x10001040,
   0x00000040, 0x10000000, 0x00040040, 0x10040000, 0x10041040, 0x00041000,
   0x10041000, 0x00041040, 0x00001000, 0x00000040, 0x10040000, 0x10000040,
   0x10001000, 0x00001040, 0x00041000, 0x00040040, 0x10040040, 0x10041000,
   0x00001040, 0x00000000, 0x00000000, 0x10040040, 0x10000040, 0x10001000,
   0x00041040, 0x00040000, 0x00041040, 0x00040000, 0x10041000, 0x00001000,
   0x00000040, 0x10040040, 0x00001000, 0x00041040, 0x10001000, 0x00000040,
   0x10000040, 0x10040000, 0x10040040, 0x10000000, 0x00040000, 0x10001040,
   0x00000000, 0x10041040, 0x00040040, 0x10000040, 0x10040000, 0x10001000,
   0x10001040, 0x00000000, 0x10041040, 0x00041000, 0x00041000, 0x00001040,
   0x00001040, 0x00040040, 0x10000000, 0x10041000, 0x10001040, 0x00001000,
   0x00040000, 0x10041040, 0x10000000, 0x10001040, 0x00000040, 0x10000000,
   0x00040040, 0x10040000, 0x10041040, 0x00041000, 0x10041000, 0x00041040,
   0x00001000, 0x00000040, 0x10040000, 0x10000040, 0x10001000, 0x00001040,
   0x00041000, 0x00040040, 0x10040040, 0x10041000, 0x00001040, 0x00000000,
   0x00000000, 0x10040040, 0x10000040, 0x10001000, 0x00041040, 0x00040000,
   0x00041040, 0x00040000, 0x10041000, 0x00001000, 0x00000040, 0x10040040,
   0x00001000, 0x00041040, 0x10001000, 0x00000040, 0x10000040, 0x10040000,
   0x10040040, 0x10000000, 0x00040000, 0x10001040, 0x00000000, 0x10041040,
   0x00040040, 0x10000040, 0x10040000, 0x10001000, 0x10001040, 0x00000000,
   0x10041040, 0x00041000, 0x00041000, 0x00001040, 0x00001040, 0x00040040,
   0x10000000, 0x10041000, 0x10001040, 0x00001000, 0x00040000, 0x10041040,
   0x10000000, 0x10001040, 0x00000040, 0x10000000, 0x00040040, 0x10040000,
   0x10041040, 0x00041000, 0x10041000, 0x00041040, 0x00001000, 0x00000040,
   0x10040000, 0x10000040, 0x10001000, 0x00001040, 0x00041000, 0x00040040,
   0x10040040, 0x10041000, 0x00001040, 0x00000000, 0x00000000, 0x10040040,
   0x10000040, 0x10001000, 0x00041040, 0x00040000, 0x00041040, 0x00040000,
   0x10041000, 0x00001000, 0x00000040, 0x10040040, 0x00001000, 0x00041040,
   0x10001000, 0x00000040, 0x10000040, 0x10040000, 0x10040040, 0x10000000,
   0x00040000, 0x10001040, 0x00000000, 0x10041040, 0x00040040, 0x10000040,
   0x10040000, 0x10001000, 0x10001040, 0x00000000, 0x10041040, 0x00041000,
   0x00041000, 0x00001040, 0x00001040, 0x00040040, 0x10000000, 0x10041000,
   0x10001040, 0x00001000, 0x00040000, 0x10041040, 0x10000000, 0x10001040,
   0x00000040, 0x10000000, 0x00040040, 0x10040000, 0x10041040, 0x00041000,
   0x10041000, 0x00041040, 0x00001000, 0x00000040, 0x10040000, 0x10000040,
   0x10001000, 0x00001040, 0x00041000, 0x00040040, 0x10040040, 0x10041000,
   0x00001040, 0x00000000, 0x00000000, 0x10040040, 0x10000040, 0x10001000,
   0x00041040, 0x00040000, 0x00041040, 0x00040000, 0x10041000, 0x00001000,
   0x00000040, 0x10040040, 0x00001000, 0x00041040, 0x10001000, 0x00000040,
   0x10000040, 0x10040000, 0x10040040, 0x10000000, 0x00040000, 0x10001040,
   0x00000000, 0x10041040, 0x00040040, 0x10000040, 0x10040000, 0x10001000,
   0x10001040, 0x00000000, 0x10041040, 0x00041000, 0x00041000, 0x00001040,
   0x00001040, 0x00040040, 0x10000000, 0x10041000 };

const u64bit DES_IPTAB1[256] = {
0x0000000000000000, 0x0000000200000000, 0x0000000000000002, 0x0000000200000002,
0x0000020000000000, 0x0000020200000000, 0x0000020000000002, 0x0000020200000002,
0x0000000000000200, 0x0000000200000200, 0x0000000000000202, 0x0000000200000202,
0x0000020000000200, 0x0000020200000200, 0x0000020000000202, 0x0000020200000202,
0x0002000000000000, 0x0002000200000000, 0x0002000000000002, 0x0002000200000002,
0x0002020000000000, 0x0002020200000000, 0x0002020000000002, 0x0002020200000002,
0x0002000000000200, 0x0002000200000200, 0x0002000000000202, 0x0002000200000202,
0x0002020000000200, 0x0002020200000200, 0x0002020000000202, 0x0002020200000202,
0x0000000000020000, 0x0000000200020000, 0x0000000000020002, 0x0000000200020002,
0x0000020000020000, 0x0000020200020000, 0x0000020000020002, 0x0000020200020002,
0x0000000000020200, 0x0000000200020200, 0x0000000000020202, 0x0000000200020202,
0x0000020000020200, 0x0000020200020200, 0x0000020000020202, 0x0000020200020202,
0x0002000000020000, 0x0002000200020000, 0x0002000000020002, 0x0002000200020002,
0x0002020000020000, 0x0002020200020000, 0x0002020000020002, 0x0002020200020002,
0x0002000000020200, 0x0002000200020200, 0x0002000000020202, 0x0002000200020202,
0x0002020000020200, 0x0002020200020200, 0x0002020000020202, 0x0002020200020202,
0x0200000000000000, 0x0200000200000000, 0x0200000000000002, 0x0200000200000002,
0x0200020000000000, 0x0200020200000000, 0x0200020000000002, 0x0200020200000002,
0x0200000000000200, 0x0200000200000200, 0x0200000000000202, 0x0200000200000202,
0x0200020000000200, 0x0200020200000200, 0x0200020000000202, 0x0200020200000202,
0x0202000000000000, 0x0202000200000000, 0x0202000000000002, 0x0202000200000002,
0x0202020000000000, 0x0202020200000000, 0x0202020000000002, 0x0202020200000002,
0x0202000000000200, 0x0202000200000200, 0x0202000000000202, 0x0202000200000202,
0x0202020000000200, 0x0202020200000200, 0x0202020000000202, 0x0202020200000202,
0x0200000000020000, 0x0200000200020000, 0x0200000000020002, 0x0200000200020002,
0x0200020000020000, 0x0200020200020000, 0x0200020000020002, 0x0200020200020002,
0x0200000000020200, 0x0200000200020200, 0x0200000000020202, 0x0200000200020202,
0x0200020000020200, 0x0200020200020200, 0x0200020000020202, 0x0200020200020202,
0x0202000000020000, 0x0202000200020000, 0x0202000000020002, 0x0202000200020002,
0x0202020000020000, 0x0202020200020000, 0x0202020000020002, 0x0202020200020002,
0x0202000000020200, 0x0202000200020200, 0x0202000000020202, 0x0202000200020202,
0x0202020000020200, 0x0202020200020200, 0x0202020000020202, 0x0202020200020202,
0x0000000002000000, 0x0000000202000000, 0x0000000002000002, 0x0000000202000002,
0x0000020002000000, 0x0000020202000000, 0x0000020002000002, 0x0000020202000002,
0x0000000002000200, 0x0000000202000200, 0x0000000002000202, 0x0000000202000202,
0x0000020002000200, 0x0000020202000200, 0x0000020002000202, 0x0000020202000202,
0x0002000002000000, 0x0002000202000000, 0x0002000002000002, 0x0002000202000002,
0x0002020002000000, 0x0002020202000000, 0x0002020002000002, 0x0002020202000002,
0x0002000002000200, 0x0002000202000200, 0x0002000002000202, 0x0002000202000202,
0x0002020002000200, 0x0002020202000200, 0x0002020002000202, 0x0002020202000202,
0x0000000002020000, 0x0000000202020000, 0x0000000002020002, 0x0000000202020002,
0x0000020002020000, 0x0000020202020000, 0x0000020002020002, 0x0000020202020002,
0x0000000002020200, 0x0000000202020200, 0x0000000002020202, 0x0000000202020202,
0x0000020002020200, 0x0000020202020200, 0x0000020002020202, 0x0000020202020202,
0x0002000002020000, 0x0002000202020000, 0x0002000002020002, 0x0002000202020002,
0x0002020002020000, 0x0002020202020000, 0x0002020002020002, 0x0002020202020002,
0x0002000002020200, 0x0002000202020200, 0x0002000002020202, 0x0002000202020202,
0x0002020002020200, 0x0002020202020200, 0x0002020002020202, 0x0002020202020202,
0x0200000002000000, 0x0200000202000000, 0x0200000002000002, 0x0200000202000002,
0x0200020002000000, 0x0200020202000000, 0x0200020002000002, 0x0200020202000002,
0x0200000002000200, 0x0200000202000200, 0x0200000002000202, 0x0200000202000202,
0x0200020002000200, 0x0200020202000200, 0x0200020002000202, 0x0200020202000202,
0x0202000002000000, 0x0202000202000000, 0x0202000002000002, 0x0202000202000002,
0x0202020002000000, 0x0202020202000000, 0x0202020002000002, 0x0202020202000002,
0x0202000002000200, 0x0202000202000200, 0x0202000002000202, 0x0202000202000202,
0x0202020002000200, 0x0202020202000200, 0x0202020002000202, 0x0202020202000202,
0x0200000002020000, 0x0200000202020000, 0x0200000002020002, 0x0200000202020002,
0x0200020002020000, 0x0200020202020000, 0x0200020002020002, 0x0200020202020002,
0x0200000002020200, 0x0200000202020200, 0x0200000002020202, 0x0200000202020202,
0x0200020002020200, 0x0200020202020200, 0x0200020002020202, 0x0200020202020202,
0x0202000002020000, 0x0202000202020000, 0x0202000002020002, 0x0202000202020002,
0x0202020002020000, 0x0202020202020000, 0x0202020002020002, 0x0202020202020002,
0x0202000002020200, 0x0202000202020200, 0x0202000002020202, 0x0202000202020202,
0x0202020002020200, 0x0202020202020200, 0x0202020002020202, 0x0202020202020202 };

const u64bit DES_IPTAB2[256] = {
0x0000000000000000, 0x0000010000000000, 0x0000000000000100, 0x0000010000000100,
0x0001000000000000, 0x0001010000000000, 0x0001000000000100, 0x0001010000000100,
0x0000000000010000, 0x0000010000010000, 0x0000000000010100, 0x0000010000010100,
0x0001000000010000, 0x0001010000010000, 0x0001000000010100, 0x0001010000010100,
0x0100000000000000, 0x0100010000000000, 0x0100000000000100, 0x0100010000000100,
0x0101000000000000, 0x0101010000000000, 0x0101000000000100, 0x0101010000000100,
0x0100000000010000, 0x0100010000010000, 0x0100000000010100, 0x0100010000010100,
0x0101000000010000, 0x0101010000010000, 0x0101000000010100, 0x0101010000010100,
0x0000000001000000, 0x0000010001000000, 0x0000000001000100, 0x0000010001000100,
0x0001000001000000, 0x0001010001000000, 0x0001000001000100, 0x0001010001000100,
0x0000000001010000, 0x0000010001010000, 0x0000000001010100, 0x0000010001010100,
0x0001000001010000, 0x0001010001010000, 0x0001000001010100, 0x0001010001010100,
0x0100000001000000, 0x0100010001000000, 0x0100000001000100, 0x0100010001000100,
0x0101000001000000, 0x0101010001000000, 0x0101000001000100, 0x0101010001000100,
0x0100000001010000, 0x0100010001010000, 0x0100000001010100, 0x0100010001010100,
0x0101000001010000, 0x0101010001010000, 0x0101000001010100, 0x0101010001010100,
0x0000000100000000, 0x0000010100000000, 0x0000000100000100, 0x0000010100000100,
0x0001000100000000, 0x0001010100000000, 0x0001000100000100, 0x0001010100000100,
0x0000000100010000, 0x0000010100010000, 0x0000000100010100, 0x0000010100010100,
0x0001000100010000, 0x0001010100010000, 0x0001000100010100, 0x0001010100010100,
0x0100000100000000, 0x0100010100000000, 0x0100000100000100, 0x0100010100000100,
0x0101000100000000, 0x0101010100000000, 0x0101000100000100, 0x0101010100000100,
0x0100000100010000, 0x0100010100010000, 0x0100000100010100, 0x0100010100010100,
0x0101000100010000, 0x0101010100010000, 0x0101000100010100, 0x0101010100010100,
0x0000000101000000, 0x0000010101000000, 0x0000000101000100, 0x0000010101000100,
0x0001000101000000, 0x0001010101000000, 0x0001000101000100, 0x0001010101000100,
0x0000000101010000, 0x0000010101010000, 0x0000000101010100, 0x0000010101010100,
0x0001000101010000, 0x0001010101010000, 0x0001000101010100, 0x0001010101010100,
0x0100000101000000, 0x0100010101000000, 0x0100000101000100, 0x0100010101000100,
0x0101000101000000, 0x0101010101000000, 0x0101000101000100, 0x0101010101000100,
0x0100000101010000, 0x0100010101010000, 0x0100000101010100, 0x0100010101010100,
0x0101000101010000, 0x0101010101010000, 0x0101000101010100, 0x0101010101010100,
0x0000000000000001, 0x0000010000000001, 0x0000000000000101, 0x0000010000000101,
0x0001000000000001, 0x0001010000000001, 0x0001000000000101, 0x0001010000000101,
0x0000000000010001, 0x0000010000010001, 0x0000000000010101, 0x0000010000010101,
0x0001000000010001, 0x0001010000010001, 0x0001000000010101, 0x0001010000010101,
0x0100000000000001, 0x0100010000000001, 0x0100000000000101, 0x0100010000000101,
0x0101000000000001, 0x0101010000000001, 0x0101000000000101, 0x0101010000000101,
0x0100000000010001, 0x0100010000010001, 0x0100000000010101, 0x0100010000010101,
0x0101000000010001, 0x0101010000010001, 0x0101000000010101, 0x0101010000010101,
0x0000000001000001, 0x0000010001000001, 0x0000000001000101, 0x0000010001000101,
0x0001000001000001, 0x0001010001000001, 0x0001000001000101, 0x0001010001000101,
0x0000000001010001, 0x0000010001010001, 0x0000000001010101, 0x0000010001010101,
0x0001000001010001, 0x0001010001010001, 0x0001000001010101, 0x0001010001010101,
0x0100000001000001, 0x0100010001000001, 0x0100000001000101, 0x0100010001000101,
0x0101000001000001, 0x0101010001000001, 0x0101000001000101, 0x0101010001000101,
0x0100000001010001, 0x0100010001010001, 0x0100000001010101, 0x0100010001010101,
0x0101000001010001, 0x0101010001010001, 0x0101000001010101, 0x0101010001010101,
0x0000000100000001, 0x0000010100000001, 0x0000000100000101, 0x0000010100000101,
0x0001000100000001, 0x0001010100000001, 0x0001000100000101, 0x0001010100000101,
0x0000000100010001, 0x0000010100010001, 0x0000000100010101, 0x0000010100010101,
0x0001000100010001, 0x0001010100010001, 0x0001000100010101, 0x0001010100010101,
0x0100000100000001, 0x0100010100000001, 0x0100000100000101, 0x0100010100000101,
0x0101000100000001, 0x0101010100000001, 0x0101000100000101, 0x0101010100000101,
0x0100000100010001, 0x0100010100010001, 0x0100000100010101, 0x0100010100010101,
0x0101000100010001, 0x0101010100010001, 0x0101000100010101, 0x0101010100010101,
0x0000000101000001, 0x0000010101000001, 0x0000000101000101, 0x0000010101000101,
0x0001000101000001, 0x0001010101000001, 0x0001000101000101, 0x0001010101000101,
0x0000000101010001, 0x0000010101010001, 0x0000000101010101, 0x0000010101010101,
0x0001000101010001, 0x0001010101010001, 0x0001000101010101, 0x0001010101010101,
0x0100000101000001, 0x0100010101000001, 0x0100000101000101, 0x0100010101000101,
0x0101000101000001, 0x0101010101000001, 0x0101000101000101, 0x0101010101000101,
0x0100000101010001, 0x0100010101010001, 0x0100000101010101, 0x0100010101010101,
0x0101000101010001, 0x0101010101010001, 0x0101000101010101, 0x0101010101010101 };

const u64bit DES_FPTAB1[256] = {
0x0000000000000000, 0x0000000100000000, 0x0000000004000000, 0x0000000104000000,
0x0000000000040000, 0x0000000100040000, 0x0000000004040000, 0x0000000104040000,
0x0000000000000400, 0x0000000100000400, 0x0000000004000400, 0x0000000104000400,
0x0000000000040400, 0x0000000100040400, 0x0000000004040400, 0x0000000104040400,
0x0000000000000004, 0x0000000100000004, 0x0000000004000004, 0x0000000104000004,
0x0000000000040004, 0x0000000100040004, 0x0000000004040004, 0x0000000104040004,
0x0000000000000404, 0x0000000100000404, 0x0000000004000404, 0x0000000104000404,
0x0000000000040404, 0x0000000100040404, 0x0000000004040404, 0x0000000104040404,
0x0400000000000000, 0x0400000100000000, 0x0400000004000000, 0x0400000104000000,
0x0400000000040000, 0x0400000100040000, 0x0400000004040000, 0x0400000104040000,
0x0400000000000400, 0x0400000100000400, 0x0400000004000400, 0x0400000104000400,
0x0400000000040400, 0x0400000100040400, 0x0400000004040400, 0x0400000104040400,
0x0400000000000004, 0x0400000100000004, 0x0400000004000004, 0x0400000104000004,
0x0400000000040004, 0x0400000100040004, 0x0400000004040004, 0x0400000104040004,
0x0400000000000404, 0x0400000100000404, 0x0400000004000404, 0x0400000104000404,
0x0400000000040404, 0x0400000100040404, 0x0400000004040404, 0x0400000104040404,
0x0004000000000000, 0x0004000100000000, 0x0004000004000000, 0x0004000104000000,
0x0004000000040000, 0x0004000100040000, 0x0004000004040000, 0x0004000104040000,
0x0004000000000400, 0x0004000100000400, 0x0004000004000400, 0x0004000104000400,
0x0004000000040400, 0x0004000100040400, 0x0004000004040400, 0x0004000104040400,
0x0004000000000004, 0x0004000100000004, 0x0004000004000004, 0x0004000104000004,
0x0004000000040004, 0x0004000100040004, 0x0004000004040004, 0x0004000104040004,
0x0004000000000404, 0x0004000100000404, 0x0004000004000404, 0x0004000104000404,
0x0004000000040404, 0x0004000100040404, 0x0004000004040404, 0x0004000104040404,
0x0404000000000000, 0x0404000100000000, 0x0404000004000000, 0x0404000104000000,
0x0404000000040000, 0x0404000100040000, 0x0404000004040000, 0x0404000104040000,
0x0404000000000400, 0x0404000100000400, 0x0404000004000400, 0x0404000104000400,
0x0404000000040400, 0x0404000100040400, 0x0404000004040400, 0x0404000104040400,
0x0404000000000004, 0x0404000100000004, 0x0404000004000004, 0x0404000104000004,
0x0404000000040004, 0x0404000100040004, 0x0404000004040004, 0x0404000104040004,
0x0404000000000404, 0x0404000100000404, 0x0404000004000404, 0x0404000104000404,
0x0404000000040404, 0x0404000100040404, 0x0404000004040404, 0x0404000104040404,
0x0000040000000000, 0x0000040100000000, 0x0000040004000000, 0x0000040104000000,
0x0000040000040000, 0x0000040100040000, 0x0000040004040000, 0x0000040104040000,
0x0000040000000400, 0x0000040100000400, 0x0000040004000400, 0x0000040104000400,
0x0000040000040400, 0x0000040100040400, 0x0000040004040400, 0x0000040104040400,
0x0000040000000004, 0x0000040100000004, 0x0000040004000004, 0x0000040104000004,
0x0000040000040004, 0x0000040100040004, 0x0000040004040004, 0x0000040104040004,
0x0000040000000404, 0x0000040100000404, 0x0000040004000404, 0x0000040104000404,
0x0000040000040404, 0x0000040100040404, 0x0000040004040404, 0x0000040104040404,
0x0400040000000000, 0x0400040100000000, 0x0400040004000000, 0x0400040104000000,
0x0400040000040000, 0x0400040100040000, 0x0400040004040000, 0x0400040104040000,
0x0400040000000400, 0x0400040100000400, 0x0400040004000400, 0x0400040104000400,
0x0400040000040400, 0x0400040100040400, 0x0400040004040400, 0x0400040104040400,
0x0400040000000004, 0x0400040100000004, 0x0400040004000004, 0x0400040104000004,
0x0400040000040004, 0x0400040100040004, 0x0400040004040004, 0x0400040104040004,
0x0400040000000404, 0x0400040100000404, 0x0400040004000404, 0x0400040104000404,
0x0400040000040404, 0x0400040100040404, 0x0400040004040404, 0x0400040104040404,
0x0004040000000000, 0x0004040100000000, 0x0004040004000000, 0x0004040104000000,
0x0004040000040000, 0x0004040100040000, 0x0004040004040000, 0x0004040104040000,
0x0004040000000400, 0x0004040100000400, 0x0004040004000400, 0x0004040104000400,
0x0004040000040400, 0x0004040100040400, 0x0004040004040400, 0x0004040104040400,
0x0004040000000004, 0x0004040100000004, 0x0004040004000004, 0x0004040104000004,
0x0004040000040004, 0x0004040100040004, 0x0004040004040004, 0x0004040104040004,
0x0004040000000404, 0x0004040100000404, 0x0004040004000404, 0x0004040104000404,
0x0004040000040404, 0x0004040100040404, 0x0004040004040404, 0x0004040104040404,
0x0404040000000000, 0x0404040100000000, 0x0404040004000000, 0x0404040104000000,
0x0404040000040000, 0x0404040100040000, 0x0404040004040000, 0x0404040104040000,
0x0404040000000400, 0x0404040100000400, 0x0404040004000400, 0x0404040104000400,
0x0404040000040400, 0x0404040100040400, 0x0404040004040400, 0x0404040104040400,
0x0404040000000004, 0x0404040100000004, 0x0404040004000004, 0x0404040104000004,
0x0404040000040004, 0x0404040100040004, 0x0404040004040004, 0x0404040104040004,
0x0404040000000404, 0x0404040100000404, 0x0404040004000404, 0x0404040104000404,
0x0404040000040404, 0x0404040100040404, 0x0404040004040404, 0x0404040104040404 };

const u64bit DES_FPTAB2[256] = {
0x0000000000000000, 0x0000004000000000, 0x0000000001000000, 0x0000004001000000,
0x0000000000010000, 0x0000004000010000, 0x0000000001010000, 0x0000004001010000,
0x0000000000000100, 0x0000004000000100, 0x0000000001000100, 0x0000004001000100,
0x0000000000010100, 0x0000004000010100, 0x0000000001010100, 0x0000004001010100,
0x0000000000000001, 0x0000004000000001, 0x0000000001000001, 0x0000004001000001,
0x0000000000010001, 0x0000004000010001, 0x0000000001010001, 0x0000004001010001,
0x0000000000000101, 0x0000004000000101, 0x0000000001000101, 0x0000004001000101,
0x0000000000010101, 0x0000004000010101, 0x0000000001010101, 0x0000004001010101,
0x0100000000000000, 0x0100004000000000, 0x0100000001000000, 0x0100004001000000,
0x0100000000010000, 0x0100004000010000, 0x0100000001010000, 0x0100004001010000,
0x0100000000000100, 0x0100004000000100, 0x0100000001000100, 0x0100004001000100,
0x0100000000010100, 0x0100004000010100, 0x0100000001010100, 0x0100004001010100,
0x0100000000000001, 0x0100004000000001, 0x0100000001000001, 0x0100004001000001,
0x0100000000010001, 0x0100004000010001, 0x0100000001010001, 0x0100004001010001,
0x0100000000000101, 0x0100004000000101, 0x0100000001000101, 0x0100004001000101,
0x0100000000010101, 0x0100004000010101, 0x0100000001010101, 0x0100004001010101,
0x0001000000000000, 0x0001004000000000, 0x0001000001000000, 0x0001004001000000,
0x0001000000010000, 0x0001004000010000, 0x0001000001010000, 0x0001004001010000,
0x0001000000000100, 0x0001004000000100, 0x0001000001000100, 0x0001004001000100,
0x0001000000010100, 0x0001004000010100, 0x0001000001010100, 0x0001004001010100,
0x0001000000000001, 0x0001004000000001, 0x0001000001000001, 0x0001004001000001,
0x0001000000010001, 0x0001004000010001, 0x0001000001010001, 0x0001004001010001,
0x0001000000000101, 0x0001004000000101, 0x0001000001000101, 0x0001004001000101,
0x0001000000010101, 0x0001004000010101, 0x0001000001010101, 0x0001004001010101,
0x0101000000000000, 0x0101004000000000, 0x0101000001000000, 0x0101004001000000,
0x0101000000010000, 0x0101004000010000, 0x0101000001010000, 0x0101004001010000,
0x0101000000000100, 0x0101004000000100, 0x0101000001000100, 0x0101004001000100,
0x0101000000010100, 0x0101004000010100, 0x0101000001010100, 0x0101004001010100,
0x0101000000000001, 0x0101004000000001, 0x0101000001000001, 0x0101004001000001,
0x0101000000010001, 0x0101004000010001, 0x0101000001010001, 0x0101004001010001,
0x0101000000000101, 0x0101004000000101, 0x0101000001000101, 0x0101004001000101,
0x0101000000010101, 0x0101004000010101, 0x0101000001010101, 0x0101004001010101,
0x0000010000000000, 0x0000014000000000, 0x0000010001000000, 0x0000014001000000,
0x0000010000010000, 0x0000014000010000, 0x0000010001010000, 0x0000014001010000,
0x0000010000000100, 0x0000014000000100, 0x0000010001000100, 0x0000014001000100,
0x0000010000010100, 0x0000014000010100, 0x0000010001010100, 0x0000014001010100,
0x0000010000000001, 0x0000014000000001, 0x0000010001000001, 0x0000014001000001,
0x0000010000010001, 0x0000014000010001, 0x0000010001010001, 0x0000014001010001,
0x0000010000000101, 0x0000014000000101, 0x0000010001000101, 0x0000014001000101,
0x0000010000010101, 0x0000014000010101, 0x0000010001010101, 0x0000014001010101,
0x0100010000000000, 0x0100014000000000, 0x0100010001000000, 0x0100014001000000,
0x0100010000010000, 0x0100014000010000, 0x0100010001010000, 0x0100014001010000,
0x0100010000000100, 0x0100014000000100, 0x0100010001000100, 0x0100014001000100,
0x0100010000010100, 0x0100014000010100, 0x0100010001010100, 0x0100014001010100,
0x0100010000000001, 0x0100014000000001, 0x0100010001000001, 0x0100014001000001,
0x0100010000010001, 0x0100014000010001, 0x0100010001010001, 0x0100014001010001,
0x0100010000000101, 0x0100014000000101, 0x0100010001000101, 0x0100014001000101,
0x0100010000010101, 0x0100014000010101, 0x0100010001010101, 0x0100014001010101,
0x0001010000000000, 0x0001014000000000, 0x0001010001000000, 0x0001014001000000,
0x0001010000010000, 0x0001014000010000, 0x0001010001010000, 0x0001014001010000,
0x0001010000000100, 0x0001014000000100, 0x0001010001000100, 0x0001014001000100,
0x0001010000010100, 0x0001014000010100, 0x0001010001010100, 0x0001014001010100,
0x0001010000000001, 0x0001014000000001, 0x0001010001000001, 0x0001014001000001,
0x0001010000010001, 0x0001014000010001, 0x0001010001010001, 0x0001014001010001,
0x0001010000000101, 0x0001014000000101, 0x0001010001000101, 0x0001014001000101,
0x0001010000010101, 0x0001014000010101, 0x0001010001010101, 0x0001014001010101,
0x0101010000000000, 0x0101014000000000, 0x0101010001000000, 0x0101014001000000,
0x0101010000010000, 0x0101014000010000, 0x0101010001010000, 0x0101014001010000,
0x0101010000000100, 0x0101014000000100, 0x0101010001000100, 0x0101014001000100,
0x0101010000010100, 0x0101014000010100, 0x0101010001010100, 0x0101014001010100,
0x0101010000000001, 0x0101014000000001, 0x0101010001000001, 0x0101014001000001,
0x0101010000010001, 0x0101014000010001, 0x0101010001010001, 0x0101014001010001,
0x0101010000000101, 0x0101014000000101, 0x0101010001000101, 0x0101014001000101,
0x0101010000010101, 0x0101014000010101, 0x0101010001010101, 0x0101014001010101 };

}
