//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Device/InstrumentItemCatalog.h
//! @brief     Defines class InstrumentItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTITEMCATALOG_H
#define BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTITEMCATALOG_H

#include "GUI/Support/Type/UiInfo.h"
#include <QVector>

class InstrumentItem;

class InstrumentItemCatalog {
public:
    // used in SelectionProperty<Catalog>
    using CatalogedType = InstrumentItem;

    // Do not change the numbering! It is serialized!
    enum class Type : uint8_t { GISAS = 0, Offspec = 1, Specular = 2, Depthprobe = 3 };

    //! Creates the item of the given type.
    static InstrumentItem* create(Type type);

    //! List of available types, sorted as expected in the UI.
    static QVector<Type> types();

    //! UiInfo on the given type.
    static UiInfo uiInfo(Type t);

    //! Returns the enum type of the given item.
    static Type type(const InstrumentItem* item);
};

#endif // BORNAGAIN_GUI_MODEL_DEVICE_INSTRUMENTITEMCATALOG_H
