: Based on Kd model of Foust et al. (2011)


NEURON	{
	SUFFIX Kd
	USEION k READ ek WRITE ik
	RANGE gbar, g, ik
}

UNITS	{
	(S) = (siemens)
	(mV) = (millivolt)
	(mA) = (milliamp)
}

PARAMETER	{
	gbar = 0.00001 (S/cm2)
}

ASSIGNED	{
	v	(mV)
	ek	(mV)
	ik	(mA/cm2)
	g	(S/cm2)
	celsius (degC)
	mInf
	mTau
	hInf
	hTau
}

STATE	{
	m
	h
}

BREAKPOINT	{
	SOLVE states METHOD cnexp
	g = gbar * m * h
	ik = g * (v - ek)
}

DERIVATIVE states	{
	rates()
	m' = (mInf - m) / mTau
	h' = (hInf - h) / hTau
}

INITIAL{
	rates()
	m = mInf
	h = hInf
}

PROCEDURE rates() {
  LOCAL qt
  qt = 2.3^((celsius-23)/10)
	mInf = 1 - 1 / (1 + exp((v - (-43)) / 8))
  mTau = 1
  hInf = 1 / (1 + exp((v - (-67)) / 7.3))
  hTau = 1500
}
