# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gobject import timeout_add
from os.path import isfile, join
from gtk.gdk import pixbuf_new_from_file, INTERP_BILINEAR

from modules.explorer.playlist import Playlist

from modules.explorer.views.lightweight import LightweightView
from modules.explorer.views.basic import BasicView
from modules.explorer.views.normal import NormalView
from modules.explorer.views.full import FullView
from modules.explorer.views.albums import AlbumsView
from modules.explorer.views.playlists import PlaylistsView
from modules.explorer.views.webradios import WebradiosView

from common.config import ConfigLoader
from common.functions import Functions

class Views:
    def __init__(self, glade_file, conf, force_view=False, force_reload=False):
        if not force_view:
            if conf['mode'] not in ('full', 'normal', 'basic', 'lightweight',
                                    'albums', 'playlists', 'webradios'):
                raise SystemExit('Ahah. You are funny.')

            view_mode = conf['mode']
        else:
            view_mode = force_view

        self.glade_file = glade_file
        self.config = conf
        self.userconf = ConfigLoader()
        self.functions = Functions()

        # Hide all widgets, will be shown after by the selected view
        self.glade_file.get_widget('hbox3').hide()
        self.glade_file.get_widget('vpaned1').hide()
        self.glade_file.get_widget('toolbar3').hide()
        self.glade_file.get_widget('progressbar1').hide()
        self.glade_file.get_widget('alignment6').hide()
        self.glade_file.get_widget('vbox2').hide()
        self.glade_file.get_widget('hbox6').hide()
        self.glade_file.get_widget('frame4').hide()
        self.glade_file.get_widget('scrolledwindow1').hide()
        self.glade_file.get_widget('scrolledwindow7').hide()
        self.glade_file.get_widget('scrolledwindow10').hide()
        self.glade_file.get_widget('scrolledwindow11').hide()
        self.glade_file.get_widget('vbox11').hide()
        self.glade_file.get_widget('toolbar6').hide()

        # Hide the playlist's widgets
        glade_file.get_widget('scrolledwindow3').hide()
        glade_file.get_widget('toolbar4').hide()

        # Show a message if no music folder selected
        if self.config['folder'] == '':
            # Hide all
            self.glade_file.get_widget('hpaned1').hide()
            self.glade_file.get_widget('hbox4').hide()
            self.glade_file.get_widget('menu-refresh').set_sensitive(False)
            self.glade_file.get_widget('menuitem2').set_sensitive(False)

            self.glade_file.get_widget('alignment6').show()

            pimg = self.glade_file.get_widget('image4')
            pixbuf = pixbuf_new_from_file(join(self.functions.datadir, 'image',
                                               'logo_head_big.png'))
            pixbuf = pixbuf.scale_simple(85, 85, INTERP_BILINEAR)
            pimg.set_from_pixbuf(pixbuf)

            widget = self.glade_file.get_widget('label4')
            widget.set_markup(_('<b>Welcome in Bluemindo!</b>\n\n'
                  'First of all, you need to configure the explorer module '
                  'in order to choose your root music directory. This is easy!'
                  ' Go in the File menu, click on Preferences and you will be '
                  'able to configure all Bluemindo\'s modules.'))

        # Start the view
        class_name = eval(view_mode.capitalize() + 'View')
        v = class_name(self.glade_file, self.config, self.userconf)

        if force_reload:
            v.reload_database(force_scan=True)

    def reload_config(self, newconf, force_reload=False):
        """This function sends new config parameters."""
        # Show widgets if they were hidden
        self.glade_file.get_widget('hpaned1').show()
        self.glade_file.get_widget('hbox4').show()
        self.glade_file.get_widget('menu-refresh').set_sensitive(True)
        self.glade_file.get_widget('menuitem2').set_sensitive(True)
        self.glade_file.get_widget('alignment6').hide()

        # We need to change the view mode
        if self.config['mode'] != newconf['mode'] or force_reload:
            Views(self.glade_file, newconf, newconf['mode'], force_reload)

        # And we need to show/hide columns in the playlist
        playlist = Playlist(self.glade_file, newconf, self.userconf)
        playlist.update_columns(newconf['columns'])

        # Hide playlist if view mode is webradios
        if newconf['mode'] == 'webradios':
            self.glade_file.get_widget('vpaned1').hide()
            self.glade_file.get_widget('scrolledwindow3').hide()
            self.glade_file.get_widget('toolbar4').hide()