# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gtk.glade import XML as glade_XML
from gtk import ICON_SIZE_LARGE_TOOLBAR, VolumeButton
from ConfigParser import ConfigParser
from os.path import join, exists

from common.config import ConfigLoader
from common.functions import Functions
from media.gstreamer import GStreamer

config = ConfigLoader()
functions = Functions()
gst = GStreamer()

class VolumeManagement(object):
    ref = None
    ref2 = None

    def __new__(cls, *args, **kws):
        # Singleton
        if cls.ref is None:
            cls.ref = super(VolumeManagement, cls).__new__(cls, args, kws)
        return cls.ref
	 	     
    def __init__(self, widgets):
        if VolumeManagement.ref2 is None:
            VolumeManagement.ref2 = 42
            self.launch(widgets)

    def launch(self, widgets):
        self.widgets = widgets
        self.show_volume = False

        tool_wdg = self.widgets.get_widget('tool')
        self.tool_volume = VolumeButton()
        tool_wdg.add(self.tool_volume)
        self.tool_volume.show()

        self.tool_volume.connect('value-changed', self.user_set_volume)

        configparser = ConfigParser()
        configparser.read(join(config.confdir, 'Bluemindo.cfg'))
        try:
            volume = float(configparser.get('Audio', 'volume'))
        except ConfigParser.NoSectionError:
            volume = 1.0

        self.volume = volume

    def volume_more(self, datagram):
        """This function handles the user's command to increase the volume."""
        is_step = datagram.split('--volume-more ')
        if len(is_step) == 2:
            step = float(is_step[1]) / 100.
        else:
            step = 0.1

        volume = self.volume + step
        self.change_volume(volume)

    def volume_less(self, datagram):
        """This function handles the user's command to decrease the volume."""
        is_step = datagram.split('--volume-less ')
        if len(is_step) == 2:
            step = float(is_step[1]) / 100.
        else:
            step = 0.1

        volume = self.volume - step
        self.change_volume(volume)

    def volume_set(self, volume):
        """This function handles the user's command to change the volume."""
        self.change_volume((float(volume) / 100.))

    def user_set_volume(self, widget, volume):
        self.change_volume(volume)

    def change_volume(self, volume):
        """This function changes the volume."""
        # Verify the volume
        if volume < 0.0:
            volume = 0.0
        elif volume > 1.0:
            volume = 1.0

        self.volume = volume

        # Send the new volume to Gstreamer
        player = gst.getplayer()
        player.set_property('volume', volume)

        # Update gtk.VolumeButton
        self.tool_volume.set_value(volume)

        # Save the new volume level
        configparser = ConfigParser()
        configfile = join(config.confdir, 'Bluemindo.cfg')

        if exists(configfile):
            configparser.read(configfile)

            if configparser.has_section('Window'):
                width = configparser.get('Window', 'width')
                height = configparser.get('Window', 'height')
                x = configparser.get('Window', 'x')
                y = configparser.get('Window', 'y')

                configparser.set('Window', 'width', width)
                configparser.set('Window', 'height', height)
                configparser.set('Window', 'x', x)
                configparser.set('Window', 'y', y)

            configparser.set('Audio', 'volume', volume)
        else:
            configparser.add_section('Audio')
            configparser.set('Audio', 'volume', volume)

        configparser.write(open(configfile, 'w'))