# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from webbrowser import open as open_
from gtk.glade import XML as glade_XML
from gtk import about_dialog_set_url_hook
from gtk.gdk import pixbuf_new_from_file

from common.functions import Functions
functions = Functions()

class AboutDialog:
    def __init__(self):
        about_dialog_set_url_hook(self.on_aboutdialog_link, None)
        xml = glade_XML(functions.datadir + '/glade/aboutdialog.glade',
                                            'aboutdialog1', domain='bluemindo')
        aboutdialog = xml.get_widget('aboutdialog1')
        bluemindologo = pixbuf_new_from_file(
                        functions.datadir + '/image/bluemindo.png')
        aboutdialog.set_logo(bluemindologo)
        aboutdialog.run()
        aboutdialog.destroy()

    def on_aboutdialog_link(self, widget, link, _):
        open_(link)